/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.external;

import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.external.ICsBasicsExternalService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.external.anno.CsBasicsExternalStrategy;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component(value="csExternalBasicsStrategyUtils")
public class CsBasicsExternalStrategyUtils
implements ApplicationContextAware {
    private static Logger logger = LoggerFactory.getLogger(CsBasicsExternalStrategyUtils.class);
    private ApplicationContext applicationContext;
    private static Map<String, ICsBasicsExternalService> externalBasicsServiceMap = Maps.newHashMap();
    public static final String PREFIX = "Cs";
    public static final String SUFFIX = "externalBasicsStrategyService";
    public static final String WMS = "wms";
    public static final String BD_WMS = "bd_wms";
    public static final String EAS = "eas";
    public static final String E3 = "e3";

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        Map beansWithAnnotationMap = applicationContext.getBeansWithAnnotation(CsBasicsExternalStrategy.class);
        if (MapUtils.isEmpty((Map)beansWithAnnotationMap)) {
            return;
        }
        Set entrySet = beansWithAnnotationMap.entrySet();
        for (Map.Entry entry : entrySet) {
            boolean effect;
            ICsBasicsExternalService csExternalBasicsService = (ICsBasicsExternalService)entry.getValue();
            Class targetClass = AopUtils.getTargetClass((Object)csExternalBasicsService);
            CsBasicsExternalStrategy annotation = targetClass.getDeclaredAnnotation(CsBasicsExternalStrategy.class);
            if (null == annotation || !(effect = annotation.effect())) continue;
            String strategyName = annotation.strategyName();
            externalBasicsServiceMap.put(strategyName, csExternalBasicsService);
        }
    }

    public static ICsBasicsExternalService getBasicsOrderOperateService(String strategy) {
        logger.info("getInventoryService==>\u6839\u636e\u4f20\u5165\u7684\u7b56\u7565\u83b7\u53d6\u64cd\u4f5c\u5916\u90e8\u5bf9\u63a5\u7684\u7b56\u7565\u7c7b,strategy:{}", (Object)strategy);
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)strategy), "\u64cd\u4f5c\u7b56\u7565\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        return externalBasicsServiceMap.getOrDefault(InventoryConfig.getProjectCode() + "_" + strategy, externalBasicsServiceMap.get(strategy));
    }
}

