/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate;

import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.yundt.cube.center.inventory.biz.constant.InventoryConstant;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.DateUtils;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsGenerateCodeEnum;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import java.util.Calendar;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="simpleGenerateCodeUtil")
public class SimpleGenerateCodeUtil {
    private static Logger logger = LoggerFactory.getLogger(SimpleGenerateCodeUtil.class);
    @Resource
    private ICacheService cacheService;

    @Deprecated
    public CsGenerateCodeEnum pcpGenerateCode(String orderCategory) {
        CsGenerateCodeEnum generateCodeEnum = CsGenerateCodeEnum.ENABLE;
        String status = "";
        String pre = "";
        switch (orderCategory) {
            case "101": {
                pre = "DON";
                status = BaseOrderStatusEnum.INIT.getCode();
                break;
            }
            case "102": {
                pre = "DS";
                status = BaseOrderStatusEnum.DELIVERY_OUT_FINISH.getCode();
                break;
            }
            case "401": {
                pre = "PDON";
                status = BaseOrderStatusEnum.DELIVERY_OUT_ING.getCode();
                break;
            }
            case "402": {
                pre = "PSR";
                status = BaseOrderStatusEnum.DELIVERY_OUT_FINISH.getCode();
                break;
            }
            case "201": {
                pre = "GRN";
                status = BaseOrderStatusEnum.RECEIVE_WAIT_RECEIVE.getCode();
                break;
            }
            case "202": {
                pre = "RS";
                status = BaseOrderStatusEnum.RECEIVE_FINISH.getCode();
                break;
            }
            case "501": {
                pre = "PASN";
                status = BaseOrderStatusEnum.RECEIVE_WAIT_RECEIVE.getCode();
                break;
            }
            case "502": {
                pre = "PRO";
                status = BaseOrderStatusEnum.RECEIVE_FINISH.getCode();
                break;
            }
            case "301": {
                pre = "TH";
                status = BaseOrderStatusEnum.ADJUST_WAIT_AUDIT.getCode();
                break;
            }
        }
        Long incr = this.cacheService.incr(status);
        if (incr == 1L) {
            this.cacheService.expire(status, SimpleGenerateCodeUtil.getSecondsNextEarlyMorning());
        }
        String code = pre + DateUtils.formatDate(new Date(), "yyyyMMdd") + this.generateIncrNum(String.valueOf(incr));
        logger.info(orderCategory + "\u751f\u6210\u5355\u636e\u53f7:" + code + "\u72b6\u6001:" + status);
        generateCodeEnum.setCode(code);
        generateCodeEnum.setStatus(status);
        return generateCodeEnum;
    }

    private static int getSecondsNextEarlyMorning() {
        Calendar cal = Calendar.getInstance();
        cal.add(6, 1);
        cal.set(11, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(14, 0);
        return (int)((cal.getTimeInMillis() - System.currentTimeMillis()) / 1000L);
    }

    private String generateIncrNum(String code) {
        return String.format("%06d", Integer.parseInt(code));
    }

    public CsGenerateCodeEnum generateCode(String orderCategory) {
        CsGenerateCodeEnum generateCodeEnum = CsGenerateCodeEnum.ENABLE;
        String status = "";
        String pre = "";
        switch (orderCategory) {
            case "101": {
                pre = "FHTZ";
                status = BaseOrderStatusEnum.INIT.getCode();
                break;
            }
            case "102": {
                pre = "FHJG";
                status = BaseOrderStatusEnum.DELIVERY_OUT_FINISH.getCode();
                break;
            }
            case "401": {
                pre = "CKTZ";
                status = BaseOrderStatusEnum.DELIVERY_OUT_ING.getCode();
                break;
            }
            case "402": {
                pre = "CKJG";
                status = BaseOrderStatusEnum.DELIVERY_OUT_FINISH.getCode();
                break;
            }
            case "201": {
                pre = "SHTZ";
                status = BaseOrderStatusEnum.RECEIVE_WAIT_RECEIVE.getCode();
                break;
            }
            case "202": {
                pre = "SHJG";
                status = BaseOrderStatusEnum.RECEIVE_FINISH.getCode();
                break;
            }
            case "501": {
                pre = "RKTZ";
                status = BaseOrderStatusEnum.RECEIVE_WAIT_RECEIVE.getCode();
                break;
            }
            case "502": {
                pre = "RKJG";
                status = BaseOrderStatusEnum.RECEIVE_FINISH.getCode();
                break;
            }
            case "301": {
                pre = "TH";
                status = BaseOrderStatusEnum.ADJUST_WAIT_AUDIT.getCode();
                break;
            }
        }
        String code = pre + InventoryConstant.createId();
        logger.info(orderCategory + "\u751f\u6210\u5355\u636e\u53f7:" + code + "\u72b6\u6001:" + status);
        generateCodeEnum.setCode(code);
        generateCodeEnum.setStatus(status);
        return generateCodeEnum;
    }
}

