/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.yundt.cube.center.inventory.api.annotion.Power;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.basics.CsInventoryStrategyUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.basics.ICsInventoryQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsInventoryExposedQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics.CsInventoryBasicsPageQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics.CsInventoryBasicsQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics.CsInventoryLogBasicsPageQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryBatchQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryPageQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryWarehouseQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.log.CsActivityInventoryLogPageQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.log.CsInventoryLogPageQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.basics.CsInventoryBasicsPageQueryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.basics.CsInventoryBasicsQueryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsInventoryBatchQueryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsInventoryPageQueryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsInventoryWarehouseQueryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.log.CsActivityInventoryLogRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsWarehouseClassifyEnum;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicInventoryDomain;
import com.yunxi.dg.base.center.inventory.dto.domain.CsInventoryLogRespDto;
import com.yunxi.dg.base.center.inventory.eo.LogicInventoryEo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="csInventoryExposedQueryServiceImpl")
public class CsInventoryExposedQueryServiceImpl
implements ICsInventoryExposedQueryService {
    private Logger logger = LoggerFactory.getLogger(CsInventoryExposedQueryServiceImpl.class);
    @Autowired
    ILogicInventoryDomain logicInventoryDomain;

    @Override
    public PageInfo<CsInventoryPageQueryRespDto> queryInventoryPage(CsInventoryPageQueryReqDto csInventoryPageQueryReqDto) {
        this.logger.info("queryInventoryPage==>\u5e93\u5b58\u5206\u9875\u67e5\u8be2,csInventoryPageQueryReqDto:{}", (Object)LogUtils.buildLogContent(csInventoryPageQueryReqDto));
        if (StringUtils.isBlank((CharSequence)csInventoryPageQueryReqDto.getWarehouseClassify())) {
            csInventoryPageQueryReqDto.setWarehouseClassify(CsWarehouseClassifyEnum.LOGIC.getCode());
        }
        this.checkParams(csInventoryPageQueryReqDto);
        String warehouseClassify = csInventoryPageQueryReqDto.getWarehouseClassify();
        CsInventoryStrategyEnum csInventoryStrategyEnum = CsInventoryStrategyEnum.getByCode((String)warehouseClassify);
        if (null == csInventoryStrategyEnum) {
            throw new BizException("\u5e93\u5b58\u7b56\u7565\u83b7\u53d6\u6709\u8bef~");
        }
        ICsInventoryQueryService inventoryQueryService = CsInventoryStrategyUtils.getInventoryQueryService(csInventoryStrategyEnum.getCode());
        this.logger.info("queryInventoryPage==>\u5e93\u5b58\u5206\u9875\u67e5\u8be2,inventoryQueryService:{}", (Object)LogUtils.buildLogContent(inventoryQueryService));
        CsInventoryBasicsPageQueryReqDto basicsPageQueryReqDto = new CsInventoryBasicsPageQueryReqDto();
        CubeBeanUtils.copyProperties((Object)basicsPageQueryReqDto, (Object)csInventoryPageQueryReqDto, (String[])new String[0]);
        PageInfo<CsInventoryBasicsPageQueryRespDto> pageInfo = inventoryQueryService.queryInventoryPage(basicsPageQueryReqDto);
        List pageInfoList = pageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)pageInfoList)) {
            return new PageInfo();
        }
        List respDtoList = pageInfoList.stream().map(e -> {
            CsInventoryPageQueryRespDto csInventoryPageQueryRespDto = new CsInventoryPageQueryRespDto();
            CubeBeanUtils.copyProperties((Object)csInventoryPageQueryRespDto, (Object)e, (String[])new String[0]);
            BigDecimal preempt = e.getPreempt() == null ? BigDecimal.ZERO : e.getPreempt();
            BigDecimal allocate = e.getAllocate() == null ? BigDecimal.ZERO : e.getAllocate();
            BigDecimal activityAllocate = e.getActivityAllocate() == null ? BigDecimal.ZERO : e.getActivityAllocate();
            BigDecimal transfer = e.getTransfer() == null ? BigDecimal.ZERO : e.getTransfer();
            BigDecimal totalPreempt = preempt.add(allocate).add(activityAllocate).add(transfer);
            csInventoryPageQueryRespDto.setPreempt(totalPreempt);
            return csInventoryPageQueryRespDto;
        }).collect(Collectors.toList());
        PageInfo result = new PageInfo();
        BeanUtils.copyProperties(pageInfo, (Object)result);
        result.setList(respDtoList);
        return result;
    }

    @Override
    @Power
    public PageInfo<CsInventoryLogRespDto> queryInventoryLogPage(CsInventoryLogPageQueryReqDto csInventoryLogPageQueryReqDto) {
        this.logger.info("queryInventoryLogPage==>\u5e93\u5b58\u6d41\u6c34\u5206\u9875\u67e5\u8be2,csInventoryLogPageQueryReqDto:{}", (Object)LogUtils.buildLogContent(csInventoryLogPageQueryReqDto));
        AssertUtil.isTrue(null != csInventoryLogPageQueryReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(null != csInventoryLogPageQueryReqDto.getPageNum() && csInventoryLogPageQueryReqDto.getPageNum() > 0, "\u5206\u9875\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(null != csInventoryLogPageQueryReqDto.getPageSize() && csInventoryLogPageQueryReqDto.getPageSize() > 0, "\u5206\u9875\u53c2\u6570\u6709\u8bef");
        ICsInventoryQueryService inventoryQueryService = CsInventoryStrategyUtils.getInventoryQueryService(CsInventoryStrategyEnum.COMMON.getCode());
        this.logger.info("queryInventoryLogPage==>\u5e93\u5b58\u6d41\u6c34\u5206\u9875\u67e5\u8be2,inventoryQueryService:{}", (Object)LogUtils.buildLogContent(inventoryQueryService));
        CsInventoryLogBasicsPageQueryReqDto logBasicsPageQueryReqDto = new CsInventoryLogBasicsPageQueryReqDto();
        CubeBeanUtils.copyProperties((Object)logBasicsPageQueryReqDto, (Object)csInventoryLogPageQueryReqDto, (String[])new String[0]);
        PageInfo<CsInventoryLogRespDto> csInventoryLogRespDtoPageInfo = inventoryQueryService.queryInventoryLogPage(logBasicsPageQueryReqDto);
        List pageInfoList = csInventoryLogRespDtoPageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)pageInfoList)) {
            return new PageInfo();
        }
        return csInventoryLogRespDtoPageInfo;
    }

    @Override
    public PageInfo<CsActivityInventoryLogRespDto> queryActivityInventoryLogPage(CsActivityInventoryLogPageQueryReqDto csInventoryLogPageQueryReqDto) {
        this.logger.info("queryActivityInventoryLogPage==>\u5e93\u5b58\u6d41\u6c34\u5206\u9875\u67e5\u8be2,csInventoryLogPageQueryReqDto:{}", (Object)LogUtils.buildLogContent(csInventoryLogPageQueryReqDto));
        AssertUtil.isTrue(null != csInventoryLogPageQueryReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(null != csInventoryLogPageQueryReqDto.getPageNum() && csInventoryLogPageQueryReqDto.getPageNum() > 0, "\u5206\u9875\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(null != csInventoryLogPageQueryReqDto.getPageSize() && csInventoryLogPageQueryReqDto.getPageSize() > 0, "\u5206\u9875\u53c2\u6570\u6709\u8bef");
        ICsInventoryQueryService inventoryQueryService = CsInventoryStrategyUtils.getInventoryQueryService(CsInventoryStrategyEnum.ACTIVITY.getCode());
        return inventoryQueryService.queryActivityInventoryLogPage(csInventoryLogPageQueryReqDto);
    }

    @Override
    public List<CsInventoryBasicsQueryRespDto> queryCommonInventory(CsInventoryBasicsQueryReqDto basicsQueryReqDto) {
        this.logger.info("queryCommonInventory==>\u5e93\u5b58\u901a\u7528\u67e5\u8be2\u63a5\u53e3,basicsQueryReqDto:{}", (Object)LogUtils.buildLogContent(basicsQueryReqDto));
        this.checkParams(basicsQueryReqDto);
        String inventoryStrategy = basicsQueryReqDto.getInventoryStrategy();
        ICsInventoryQueryService inventoryQueryService = CsInventoryStrategyUtils.getInventoryQueryService(inventoryStrategy);
        List<CsInventoryBasicsQueryRespDto> resultList = inventoryQueryService.queryCommonInventory(basicsQueryReqDto);
        return resultList;
    }

    @Override
    public List<CsInventoryBatchQueryRespDto> queryBatchInfo(CsInventoryBatchQueryReqDto csInventoryBatchQueryReqDto) {
        this.logger.info("queryBatchInfo==>\u5e93\u5b58\u6279\u6b21\u4fe1\u606f\u67e5\u8be2,csInventoryBatchQueryReqDto:{}", (Object)LogUtils.buildLogContent(csInventoryBatchQueryReqDto));
        String inventoryStrategy = csInventoryBatchQueryReqDto.getInventoryStrategy();
        inventoryStrategy = StringUtils.isBlank((CharSequence)inventoryStrategy) ? CsInventoryStrategyEnum.LOGIC.getCode() : inventoryStrategy;
        ArrayList resultList = Lists.newArrayList();
        if (CsInventoryStrategyEnum.LOGIC.getCode().equals(inventoryStrategy)) {
            QueryWrapper csLogicInventoryEoQueryWrapper = new QueryWrapper();
            this.buildQueryCommonWrapper(csInventoryBatchQueryReqDto, csLogicInventoryEoQueryWrapper);
            List csLogicInventoryEoList = this.logicInventoryDomain.getMapper().selectList((Wrapper)csLogicInventoryEoQueryWrapper);
            if (CollectionUtils.isEmpty((Collection)csLogicInventoryEoList)) {
                return resultList;
            }
            List distinctList = csLogicInventoryEoList.stream().filter(CsInventoryExposedQueryServiceImpl.distinctByKey(LogicInventoryEo::getBatch)).collect(Collectors.toList());
            for (LogicInventoryEo csLogicInventoryEo : distinctList) {
                CsInventoryBatchQueryRespDto csInventoryBatchQueryRespDto = new CsInventoryBatchQueryRespDto();
                csInventoryBatchQueryRespDto.setId(csLogicInventoryEo.getId());
                csInventoryBatchQueryRespDto.setBatch(csLogicInventoryEo.getBatch());
                csInventoryBatchQueryRespDto.setLongCode(csLogicInventoryEo.getSkuCode());
                resultList.add(csInventoryBatchQueryRespDto);
            }
        }
        return resultList;
    }

    protected <T> void buildQueryCommonWrapper(CsInventoryBatchQueryReqDto csInventoryBatchQueryReqDto, QueryWrapper<T> queryWrapper) {
        this.logger.info("buildQueryCommonWrapper==>\u5e93\u5b58\u901a\u7528\u67e5\u8be2\uff0c\u6784\u5efa\u67e5\u8be2\u53c2\u6570,csInventoryBatchQueryReqDto:{},queryWrapper:{}", (Object)LogUtils.buildLogContent(csInventoryBatchQueryReqDto), (Object)LogUtils.buildLogContent(queryWrapper));
        if (StringUtils.isNotBlank((CharSequence)csInventoryBatchQueryReqDto.getBatchLike())) {
            queryWrapper.likeRight((Object)"batch", (Object)csInventoryBatchQueryReqDto.getBatchLike());
        }
        if (StringUtils.isNotBlank((CharSequence)csInventoryBatchQueryReqDto.getLongCode())) {
            queryWrapper.eq((Object)"sku_code", (Object)csInventoryBatchQueryReqDto.getLongCode());
        }
        if (StringUtils.isNotBlank((CharSequence)csInventoryBatchQueryReqDto.getWarehouseCode())) {
            queryWrapper.eq((Object)"warehouse_code", (Object)csInventoryBatchQueryReqDto.getWarehouseCode());
        }
        if (Boolean.TRUE.equals(csInventoryBatchQueryReqDto.getGtZero())) {
            queryWrapper.gt((Object)"available", (Object)BigDecimal.ZERO);
        }
        queryWrapper.eq((Object)"dr", (Object)0);
    }

    public static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    @Override
    public List<CsInventoryWarehouseQueryRespDto> queryWarehouseInfo(CsInventoryWarehouseQueryReqDto csInventoryWarehouseQueryReqDto) {
        this.logger.info("queryWarehouseInfo==>\u6839\u636e\u9009\u5b9a\u6279\u6b21\u7b49\u4fe1\u606f\uff0c\u67e5\u8be2\u53ef\u7528\u4ed3\u5e93\u4fe1\u606f,csInventoryWarehouseQueryReqDto:{}", (Object)LogUtils.buildLogContent(csInventoryWarehouseQueryReqDto));
        String inventoryStrategy = csInventoryWarehouseQueryReqDto.getInventoryStrategy();
        inventoryStrategy = StringUtils.isBlank((CharSequence)inventoryStrategy) ? CsInventoryStrategyEnum.LOGIC.getCode() : inventoryStrategy;
        ArrayList resultList = Lists.newArrayList();
        if (CsInventoryStrategyEnum.LOGIC.getCode().equals(inventoryStrategy)) {
            QueryWrapper csLogicInventoryEoQueryWrapper = new QueryWrapper();
            this.buildQueryCommonWrapper(csInventoryWarehouseQueryReqDto, csLogicInventoryEoQueryWrapper);
            List csLogicInventoryEoList = this.logicInventoryDomain.getMapper().selectList((Wrapper)csLogicInventoryEoQueryWrapper);
            if (CollectionUtils.isEmpty((Collection)csLogicInventoryEoList)) {
                return resultList;
            }
            List distinctList = csLogicInventoryEoList.stream().filter(CsInventoryExposedQueryServiceImpl.distinctByKey(LogicInventoryEo::getWarehouseCode)).collect(Collectors.toList());
            for (LogicInventoryEo csLogicInventoryEo : distinctList) {
                CsInventoryWarehouseQueryRespDto csInventoryWarehouQueryRespDto = new CsInventoryWarehouseQueryRespDto();
                csInventoryWarehouQueryRespDto.setWarehouseCode(csLogicInventoryEo.getWarehouseCode());
                csInventoryWarehouQueryRespDto.setWarehouseName(csLogicInventoryEo.getWarehouseName());
                csInventoryWarehouQueryRespDto.setWarehouseId(csLogicInventoryEo.getWarehouseId());
                csInventoryWarehouQueryRespDto.setWarehouseClassify(CsWarehouseClassifyEnum.LOGIC.getCode());
                resultList.add(csInventoryWarehouQueryRespDto);
            }
        }
        return resultList;
    }

    protected <T> void buildQueryCommonWrapper(CsInventoryWarehouseQueryReqDto csInventoryWarehouseQueryReqDto, QueryWrapper<T> queryWrapper) {
        this.logger.info("buildQueryCommonWrapper==>\u6839\u636e\u9009\u5b9a\u6279\u6b21\u7b49\u4fe1\u606f\uff0c\u67e5\u8be2\u53ef\u7528\u4ed3\u5e93\u4fe1\u606f,csInventoryWarehouseQueryReqDto:{},queryWrapper:{}", (Object)LogUtils.buildLogContent(csInventoryWarehouseQueryReqDto), (Object)LogUtils.buildLogContent(queryWrapper));
        if (StringUtils.isNotBlank((CharSequence)csInventoryWarehouseQueryReqDto.getBatch())) {
            queryWrapper.eq((Object)"batch", (Object)csInventoryWarehouseQueryReqDto.getBatch());
        }
        if (StringUtils.isNotBlank((CharSequence)csInventoryWarehouseQueryReqDto.getLongCode())) {
            queryWrapper.eq((Object)"sku_code", (Object)csInventoryWarehouseQueryReqDto.getLongCode());
        }
        queryWrapper.eq((Object)"dr", (Object)0);
    }

    private void checkParams(CsInventoryBasicsQueryReqDto basicsQueryReqDto) {
        AssertUtil.isTrue(null != basicsQueryReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)basicsQueryReqDto.getInventoryStrategy()) && null != CsInventoryStrategyEnum.getByCode((String)basicsQueryReqDto.getInventoryStrategy()), "\u64cd\u4f5c\u7b56\u7565\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private void checkParams(CsInventoryPageQueryReqDto csInventoryPageQueryReqDto) {
        AssertUtil.isTrue(null != csInventoryPageQueryReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(null != csInventoryPageQueryReqDto.getPageNum() && csInventoryPageQueryReqDto.getPageNum() > 0, "\u5206\u9875\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(null != csInventoryPageQueryReqDto.getPageSize() && csInventoryPageQueryReqDto.getPageSize() > 0, "\u5206\u9875\u53c2\u6570\u6709\u8bef");
        String warehouseClassify = csInventoryPageQueryReqDto.getWarehouseClassify();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)warehouseClassify) && null != CsWarehouseClassifyEnum.getByCode((String)warehouseClassify), "\u4ed3\u5e93\u5206\u7c7b\u53c2\u6570\u6709\u8bef");
    }
}

