/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.impl;

import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.api.exception.InventoryExceptionCode;
import com.dtyunxi.yundt.cube.center.inventory.biz.dto.request.CsBasisOrderBusinessDataReqDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.INoticeWmsStatusService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsBaseOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsInNoticeOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsWarehouseAddressQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsWarehouseAddressParamQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsInNoticeOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsWarehouseAddressRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsWarehouseClassifyEnum;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.domain.ContactDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsBasisOrderBusinessDataRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsInNoticeOrderDetailQueryDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsInNoticeOrderDetailRespDto;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="csInNoticeOrderQueryService")
public class CsInNoticeOrderQueryServiceImpl
implements ICsInNoticeOrderQueryService {
    private static Logger logger = LoggerFactory.getLogger(CsInNoticeOrderQueryServiceImpl.class);
    @Autowired
    private IInOutResultOrderDomain inOutResultOrderDomain;
    @Resource
    private IInOutNoticeOrderDetailDomain inOutNoticeOrderDetailDomain;
    @Resource
    private IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Resource
    private IInOutResultOrderDetailDomain inOutResultOrderDetailDomain;
    @Resource
    private ICsWarehouseAddressQueryService csWarehouseAddressQueryService;
    @Resource
    private ICsBaseOrderQueryService csBaseOrderQueryService;
    @Resource
    private INoticeWmsStatusService noticeWmsStatusService;

    @Override
    public InOutNoticeOrderEo selectByPrimaryKey(Long id) {
        logger.info("\u6839\u636eid\u67e5\u8be2\u4fe1\u606f\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        return (InOutNoticeOrderEo)this.inOutNoticeOrderDomain.selectByPrimaryKey(id);
    }

    @Override
    public PageInfo<CsInNoticeOrderDetailRespDto> queryDetailByPage(CsInNoticeOrderDetailQueryDto queryDto) {
        if (StringUtil.isNotBlank((String)queryDto.getIdentification()) && queryDto.getIdentification().equals("identification")) {
            String key;
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"document_no", (Object)queryDto.getDocumentNo());
            queryWrapper.eq((Object)"init_flag", (Object)YesNoEnum.YES.getValue());
            queryWrapper.eq((Object)"dr", (Object)0);
            PageHelper.startPage((int)queryDto.getPageNum(), (int)queryDto.getPageSize());
            List eos = this.inOutNoticeOrderDetailDomain.getMapper().selectList((Wrapper)queryWrapper);
            if (CollectionUtils.isEmpty((Collection)eos)) {
                return new PageInfo();
            }
            InOutNoticeOrderDetailEo eo = (InOutNoticeOrderDetailEo)eos.get(0);
            HashMap<String, BigDecimal> resultDetailCargoNumMap = new HashMap<String, BigDecimal>();
            List detailEos = new ArrayList();
            if (StringUtils.isNotBlank((CharSequence)eo.getRelevanceNo())) {
                List eoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutResultOrderDomain.filter().eq((Object)"relevance_no", (Object)eo.getRelevanceNo())).eq((Object)"order_type", (Object)"in")).list();
                List noList = eoList.stream().map(InOutResultOrderEo::getDocumentNo).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty((Collection)eoList)) {
                    detailEos = ((ExtQueryChainWrapper)this.inOutResultOrderDetailDomain.filter().in((Object)"document_no", noList)).list();
                    for (InOutResultOrderDetailEo detailEo : detailEos) {
                        String mapKey = detailEo.getSkuCode() + "_" + detailEo.getBatch();
                        resultDetailCargoNumMap.put(mapKey, BigDecimalUtils.add((BigDecimal)resultDetailCargoNumMap.getOrDefault(mapKey, BigDecimal.ZERO), (BigDecimal)detailEo.getDoneQuantity()));
                    }
                }
            }
            PageInfo csOutResultOrderDetailEoPageInfo = new PageInfo(eos);
            PageInfo pageInfo = new PageInfo();
            CubeBeanUtils.copyProperties((Object)pageInfo, (Object)csOutResultOrderDetailEoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
            ArrayList list = Lists.newArrayList();
            for (InOutNoticeOrderDetailEo detailEo : eos) {
                CsInNoticeOrderDetailRespDto respDto = new CsInNoticeOrderDetailRespDto();
                BeanUtils.copyProperties((Object)detailEo, (Object)respDto);
                respDto.setLongCode(detailEo.getSkuCode());
                respDto.setCargoCode(detailEo.getSkuCode());
                respDto.setCargoCode(detailEo.getSkuName());
                list.add(respDto);
            }
            for (CsInNoticeOrderDetailRespDto dto : list) {
                key = dto.getLongCode() + "_" + dto.getBatch();
                if (!resultDetailCargoNumMap.containsKey(key)) continue;
                dto.setWaitQuantity(BigDecimalUtils.subtract((BigDecimal)dto.getPlanQuantity(), (BigDecimal)((BigDecimal)resultDetailCargoNumMap.get(key))));
                resultDetailCargoNumMap.remove(key);
            }
            if (CollectionUtils.isNotEmpty(detailEos)) {
                for (InOutResultOrderDetailEo orderEo : detailEos) {
                    key = orderEo.getSkuCode() + "_" + orderEo.getBatch();
                    if (!resultDetailCargoNumMap.containsKey(key)) continue;
                    CsInNoticeOrderDetailRespDto dto = new CsInNoticeOrderDetailRespDto();
                    BeanUtils.copyProperties((Object)orderEo, (Object)dto);
                    dto.setWaitQuantity(BigDecimalUtils.subtract((BigDecimal)orderEo.getPlanQuantity(), (BigDecimal)((BigDecimal)resultDetailCargoNumMap.get(key))));
                    dto.setLongCode(orderEo.getSkuCode());
                    dto.setCargoCode(orderEo.getSkuCode());
                    dto.setCargoName(orderEo.getSkuName());
                    list.add(dto);
                    resultDetailCargoNumMap.remove(key);
                }
            }
            pageInfo.setList((List)list);
            return pageInfo;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"document_no", (Object)queryDto.getDocumentNo());
        queryWrapper.eq((Object)"init_flag", (Object)YesNoEnum.YES.getValue());
        queryWrapper.eq((Object)"dr", (Object)0);
        PageHelper.startPage((int)queryDto.getPageNum(), (int)queryDto.getPageSize());
        List eos = this.inOutNoticeOrderDetailDomain.getMapper().selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)eos)) {
            return new PageInfo();
        }
        PageInfo csOutResultOrderDetailEoPageInfo = new PageInfo(eos);
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)csOutResultOrderDetailEoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList list = Lists.newArrayList();
        for (InOutNoticeOrderDetailEo detailEo : eos) {
            CsInNoticeOrderDetailRespDto respDto = new CsInNoticeOrderDetailRespDto();
            BeanUtils.copyProperties((Object)detailEo, (Object)respDto);
            respDto.setLongCode(detailEo.getSkuCode());
            respDto.setCargoCode(detailEo.getSkuCode());
            respDto.setCargoCode(detailEo.getSkuName());
            list.add(respDto);
        }
        pageInfo.setList((List)list);
        return pageInfo;
    }

    @Override
    public CsInNoticeOrderRespDto queryByDocumentNo(String documentNo) {
        QueryWrapper deliveryResultOrderQueryWrapper = new QueryWrapper();
        deliveryResultOrderQueryWrapper.eq((Object)"document_no", (Object)documentNo);
        deliveryResultOrderQueryWrapper.eq((Object)"dr", (Object)0);
        deliveryResultOrderQueryWrapper.eq((Object)"order_type", (Object)"in");
        List list = this.inOutNoticeOrderDomain.getMapper().selectList((Wrapper)deliveryResultOrderQueryWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)list), "\u67e5\u8be2\u4e0d\u5230\u8be5\u5355\u53f7");
        InOutNoticeOrderEo eo = (InOutNoticeOrderEo)list.get(0);
        AssertUtil.isTrue(eo != null, InventoryExceptionCode.RECORD_NOT_EXIST.getMsg());
        logger.info("eo\u54cd\u5e94=>{}", (Object)JSON.toJSONString((Object)eo));
        CsInNoticeOrderRespDto dto = new CsInNoticeOrderRespDto();
        DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)dto);
        dto.setWarehouseCode(eo.getInPhysicsWarehouseCode());
        dto.setWarehouseName(eo.getInPhysicsWarehouseName());
        dto.setOutWarehouseCode(eo.getOutPhysicsWarehouseCode());
        dto.setOutWarehouseName(eo.getOutPhysicsWarehouseName());
        CsBasisOrderBusinessDataReqDto dataReqDto = new CsBasisOrderBusinessDataReqDto();
        CubeBeanUtils.copyProperties((Object)dataReqDto, (Object)dto, (String[])new String[0]);
        CsBasisOrderBusinessDataRespDto dataRespDto = this.csBaseOrderQueryService.outInNoticeBuildRelOrderInfo(dataReqDto, "receive", "in");
        if (Objects.nonNull(dataRespDto)) {
            dto.setContactDto(dataRespDto.getContactDto());
            dto.setRelOrderInfoList(dataRespDto.getRelOrderInfoList());
        }
        dto.setWmsStatus(this.noticeWmsStatusService.getNewWmsStatusByDocumentNo(dto.getDocumentNo()));
        BigDecimal skuNum = this.csBaseOrderQueryService.queryItemMapByOutInNoticeDocumentNo(dto.getDocumentNo());
        dto.setSkuNum(skuNum);
        if (!CsPcpBusinessTypeEnum.returnInWarehouseAddressBusinessType((String)eo.getBusinessType()).booleanValue()) {
            logger.info("\u4e0d\u7528\u8fd4\u56de\u5173\u8054\u4e1a\u52a1\u5355\u4fe1\u606f,\u76f4\u63a5\u8fd4\u56de");
            dto.setContactDto(null);
            logger.info("dto\u54cd\u5e94=>{}", (Object)JSON.toJSONString((Object)dto));
            return dto;
        }
        CsWarehouseAddressParamQueryDto csWarehouseAddressParamQueryDto = new CsWarehouseAddressParamQueryDto();
        csWarehouseAddressParamQueryDto.setWarehouseCode(dto.getWarehouseCode());
        csWarehouseAddressParamQueryDto.setWarehouseClassify(CsWarehouseClassifyEnum.PHYSICS.getCode());
        csWarehouseAddressParamQueryDto.setValidFlag(CsValidFlagEnum.ENABLE.getCode());
        csWarehouseAddressParamQueryDto.setPageNum(Integer.valueOf(1));
        csWarehouseAddressParamQueryDto.setPageSize(Integer.valueOf(10));
        PageInfo<CsWarehouseAddressRespDto> addressPageInfo = this.csWarehouseAddressQueryService.queryPageInfo(csWarehouseAddressParamQueryDto);
        if (Objects.nonNull(addressPageInfo) && CollectionUtils.isNotEmpty((Collection)addressPageInfo.getList())) {
            CsWarehouseAddressRespDto warehouseAddressEo = (CsWarehouseAddressRespDto)addressPageInfo.getList().get(0);
            ContactDto contactDto = Objects.nonNull(dto.getContactDto()) ? dto.getContactDto() : new ContactDto();
            contactDto.setAddress(Objects.nonNull(warehouseAddressEo.getCountry()) ? warehouseAddressEo.getCountry() : "" + warehouseAddressEo.getProvince() + warehouseAddressEo.getCity() + warehouseAddressEo.getDistrict() + warehouseAddressEo.getDetailAddress());
            contactDto.setReciveName(warehouseAddressEo.getContacts());
            contactDto.setRecivePhone(warehouseAddressEo.getPhone());
            dto.setContactDto(contactDto);
        }
        logger.info("dto\u54cd\u5e94=>{}", (Object)JSON.toJSONString((Object)dto));
        return dto;
    }
}

