/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.biz.dto.request.CsBasisOrderBusinessDataReqDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsBaseOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsInResultOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsWarehouseAddressQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsWarehouseAddressParamQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsWarehouseAddressRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.enums.CsWarehouseClassifyEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.domain.ContactDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsBasisOrderBusinessDataRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsInResultOrderDetailQueryDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsInResultOrderDetailRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsInResultOrderRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsWmsShippingInfoReqDto;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="csInResultOrderQueryService")
public class CsInResultOrderQueryServiceImpl
implements ICsInResultOrderQueryService {
    private static Logger logger = LoggerFactory.getLogger(CsInResultOrderQueryServiceImpl.class);
    @Autowired
    IInOutResultOrderDomain inOutResultOrderDomain;
    @Resource
    IInOutResultOrderDetailDomain inOutResultOrderDetailDomain;
    @Resource
    private ICsWarehouseAddressQueryService csWarehouseAddressQueryService;
    @Resource
    private ICsBaseOrderQueryService csBaseOrderQueryService;

    @Override
    public InOutResultOrderEo selectByPrimaryKey(Long id) {
        logger.info("\u6839\u636eid\u67e5\u8be2\u4fe1\u606f\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        return (InOutResultOrderEo)this.inOutResultOrderDomain.selectByPrimaryKey(id);
    }

    @Override
    public PageInfo<CsInResultOrderDetailRespDto> queryDetailByPage(CsInResultOrderDetailQueryDto queryDto) {
        if (StringUtil.isNotBlank((String)queryDto.getIdentification()) && queryDto.getIdentification().equals("identification")) {
            PageHelper.startPage((int)queryDto.getPageNum(), (int)queryDto.getPageSize());
            List dtoList = this.inOutResultOrderDetailDomain.queryResultByPage(queryDto);
            for (CsInResultOrderDetailRespDto respDto : dtoList) {
                respDto.setCargoCode(respDto.getSkuCode());
                respDto.setLongCode(respDto.getSkuCode());
                respDto.setCargoName(respDto.getSkuName());
            }
            return new PageInfo(dtoList);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"document_no", (Object)queryDto.getDocumentNo());
        queryWrapper.eq((Object)"dr", (Object)0);
        PageHelper.startPage((int)queryDto.getPageNum(), (int)queryDto.getPageSize());
        List eos = this.inOutResultOrderDetailDomain.getMapper().selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)eos)) {
            return new PageInfo();
        }
        PageInfo csOutResultOrderDetailEoPageInfo = new PageInfo(eos);
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)csOutResultOrderDetailEoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List list = eos.stream().map(e -> {
            CsInResultOrderDetailRespDto respDto = (CsInResultOrderDetailRespDto)BeanUtil.copyProperties((Object)e, CsInResultOrderDetailRespDto.class, (String[])new String[0]);
            respDto.setCargoCode(e.getSkuCode());
            respDto.setLongCode(e.getSkuCode());
            respDto.setCargoName(e.getSkuName());
            return respDto;
        }).collect(Collectors.toList());
        pageInfo.setList(list);
        return pageInfo;
    }

    @Override
    public CsInResultOrderRespDto queryByDocumentNo(String documentNo) {
        QueryWrapper deliveryResultOrderQueryWrapper = new QueryWrapper();
        deliveryResultOrderQueryWrapper.eq((Object)"document_no", (Object)documentNo);
        deliveryResultOrderQueryWrapper.eq((Object)"dr", (Object)0);
        deliveryResultOrderQueryWrapper.eq((Object)"order_type", (Object)"in");
        List list = this.inOutResultOrderDomain.getMapper().selectList((Wrapper)deliveryResultOrderQueryWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)list), "\u67e5\u8be2\u4e0d\u5230\u8be5\u5355\u53f7");
        InOutResultOrderEo eo = (InOutResultOrderEo)list.get(0);
        AssertUtil.isTrue(eo != null, "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        CsInResultOrderRespDto dto = new CsInResultOrderRespDto();
        DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)dto);
        dto.setWarehouseCode(eo.getInPhysicsWarehouseCode());
        dto.setWarehouseName(eo.getInPhysicsWarehouseName());
        dto.setOutWarehouseCode(eo.getOutPhysicsWarehouseCode());
        dto.setOutWarehouseName(eo.getOutPhysicsWarehouseName());
        String shippingJson = dto.getShippingJson();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)shippingJson)) {
            try {
                List csWmsShippingInfoReqDtoList = JSON.parseArray((String)shippingJson, CsWmsShippingInfoReqDto.class);
                logger.info("queryVersionSecondByDocumentNo==>\u5355\u53f7:{},\u7269\u6d41\u4fe1\u606f\u96c6\u5408,csWmsShippingInfoReqDtoList:{}", (Object)dto.getDocumentNo(), (Object)LogUtils.buildLogContent(csWmsShippingInfoReqDtoList));
                dto.setShippingInfoList(csWmsShippingInfoReqDtoList);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        CsBasisOrderBusinessDataReqDto dataReqDto = new CsBasisOrderBusinessDataReqDto();
        CubeBeanUtils.copyProperties((Object)dataReqDto, (Object)dto, (String[])new String[0]);
        CsBasisOrderBusinessDataRespDto dataRespDto = this.csBaseOrderQueryService.outInResultBuildRelOrderInfo(dataReqDto, "receive", "in");
        if (Objects.nonNull(dataRespDto)) {
            dto.setContactDto(dataRespDto.getContactDto());
            dto.setRelOrderInfoList(dataRespDto.getRelOrderInfoList());
        }
        BigDecimal skuNum = this.csBaseOrderQueryService.queryItemMapByOutInResultDocumentNo(dto.getDocumentNo());
        dto.setSkuNum(skuNum);
        if (StringUtils.isBlank((CharSequence)dto.getOutWarehouseCode())) {
            QueryWrapper inResultOrderQueryWrapper = new QueryWrapper();
            inResultOrderQueryWrapper.eq((Object)"relevance_no", (Object)eo.getRelevanceNo());
            inResultOrderQueryWrapper.eq((Object)"dr", (Object)0);
            inResultOrderQueryWrapper.eq((Object)"order_type", (Object)"out");
            List inResultOrderEos = this.inOutResultOrderDomain.getMapper().selectList((Wrapper)inResultOrderQueryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)inResultOrderEos)) {
                InOutResultOrderEo inResultOrderEo = (InOutResultOrderEo)inResultOrderEos.get(0);
                dto.setOutWarehouseCode(inResultOrderEo.getInPhysicsWarehouseCode());
                dto.setOutWarehouseName(inResultOrderEo.getInPhysicsWarehouseName());
                dto.setOutLogicWarehouseCode(inResultOrderEo.getOutLogicWarehouseCode());
                dto.setOutLogicWarehouseName(inResultOrderEo.getOutLogicWarehouseName());
            }
        }
        if (!CsPcpBusinessTypeEnum.returnInWarehouseAddressBusinessType((String)eo.getBusinessType()).booleanValue()) {
            logger.info("\u4e0d\u7528\u8fd4\u56de\u5173\u8054\u4e1a\u52a1\u5355\u4fe1\u606f,\u76f4\u63a5\u8fd4\u56de");
            dto.setContactDto(null);
            return dto;
        }
        CsWarehouseAddressParamQueryDto csWarehouseAddressParamQueryDto = new CsWarehouseAddressParamQueryDto();
        csWarehouseAddressParamQueryDto.setWarehouseCode(dto.getWarehouseCode());
        csWarehouseAddressParamQueryDto.setWarehouseClassify(CsWarehouseClassifyEnum.PHYSICS.getCode());
        csWarehouseAddressParamQueryDto.setValidFlag(CsValidFlagEnum.ENABLE.getCode());
        csWarehouseAddressParamQueryDto.setPageNum(Integer.valueOf(1));
        csWarehouseAddressParamQueryDto.setPageSize(Integer.valueOf(10));
        PageInfo<CsWarehouseAddressRespDto> addressPageInfo = this.csWarehouseAddressQueryService.queryPageInfo(csWarehouseAddressParamQueryDto);
        if (Objects.nonNull(addressPageInfo) && CollectionUtils.isNotEmpty((Collection)addressPageInfo.getList())) {
            CsWarehouseAddressRespDto warehouseAddressEo = (CsWarehouseAddressRespDto)addressPageInfo.getList().get(0);
            ContactDto contactDto = Objects.nonNull(dto.getContactDto()) ? dto.getContactDto() : new ContactDto();
            String country = warehouseAddressEo.getCountry();
            String province = warehouseAddressEo.getProvince();
            String city = warehouseAddressEo.getCity();
            String district = warehouseAddressEo.getDistrict();
            String detailAddress = warehouseAddressEo.getDetailAddress();
            String address = StringUtils.defaultString((String)country) + StringUtils.defaultString((String)province) + StringUtils.defaultString((String)city) + StringUtils.defaultString((String)district) + StringUtils.defaultString((String)detailAddress);
            contactDto.setAddress(address);
            contactDto.setReciveName(warehouseAddressEo.getContacts());
            contactDto.setRecivePhone(warehouseAddressEo.getPhone());
            dto.setContactDto(contactDto);
        }
        return dto;
    }
}

