/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.InspectionReleaseOperateLogReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.QualityInspectionReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.InspectionReleaseOperateLogRespDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IInspectionReleaseOperateLogService;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.InspectionReleaseOperateLogDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.InspectionReleaseOperateLogEo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InspectionReleaseOperateLogServiceImpl
implements IInspectionReleaseOperateLogService {
    @Resource
    private InspectionReleaseOperateLogDas inspectionReleaseOperateLogDas;
    @Resource
    private IContext iContext;

    @Override
    public Long addInspectionReleaseOperateLog(InspectionReleaseOperateLogReqDto addReqDto) {
        InspectionReleaseOperateLogEo inspectionReleaseOperateLogEo = new InspectionReleaseOperateLogEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)inspectionReleaseOperateLogEo);
        this.inspectionReleaseOperateLogDas.insert((BaseEo)inspectionReleaseOperateLogEo);
        return inspectionReleaseOperateLogEo.getId();
    }

    @Override
    public void addOperateLog(QualityInspectionReqDto addReqDto) {
        InspectionReleaseOperateLogEo logEo = new InspectionReleaseOperateLogEo();
        String logDesc = "\u66f4\u65b0\u62a5\u544a\u7ed3\u679c:";
        logEo.setSkuCode(addReqDto.getLongCode());
        logEo.setBatch(addReqDto.getBatch());
        if (StringUtils.isNotBlank((CharSequence)addReqDto.getCreatePerson())) {
            logEo.setCreatePerson(addReqDto.getCreatePerson());
        } else {
            logEo.setCreatePerson(this.iContext.userName());
        }
        logEo.setOperate("import_quality_inspection_report");
        logEo.setDescription(logDesc + addReqDto.getReportResult());
        this.inspectionReleaseOperateLogDas.insert((BaseEo)logEo);
    }

    @Override
    public void modifyInspectionReleaseOperateLog(InspectionReleaseOperateLogReqDto modifyReqDto) {
        InspectionReleaseOperateLogEo inspectionReleaseOperateLogEo = new InspectionReleaseOperateLogEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)inspectionReleaseOperateLogEo);
        this.inspectionReleaseOperateLogDas.updateSelective((BaseEo)inspectionReleaseOperateLogEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeInspectionReleaseOperateLog(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.inspectionReleaseOperateLogDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public InspectionReleaseOperateLogRespDto queryById(Long id) {
        InspectionReleaseOperateLogEo inspectionReleaseOperateLogEo = (InspectionReleaseOperateLogEo)this.inspectionReleaseOperateLogDas.selectByPrimaryKey(id);
        InspectionReleaseOperateLogRespDto inspectionReleaseOperateLogRespDto = new InspectionReleaseOperateLogRespDto();
        DtoHelper.eo2Dto((BaseEo)inspectionReleaseOperateLogEo, (BaseVo)inspectionReleaseOperateLogRespDto);
        return inspectionReleaseOperateLogRespDto;
    }

    @Override
    public PageInfo<InspectionReleaseOperateLogRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        InspectionReleaseOperateLogReqDto inspectionReleaseOperateLogReqDto = (InspectionReleaseOperateLogReqDto)JSON.parseObject((String)filter, InspectionReleaseOperateLogReqDto.class);
        InspectionReleaseOperateLogEo inspectionReleaseOperateLogEo = new InspectionReleaseOperateLogEo();
        DtoHelper.dto2Eo((BaseVo)inspectionReleaseOperateLogReqDto, (BaseEo)inspectionReleaseOperateLogEo);
        PageInfo eoPageInfo = this.inspectionReleaseOperateLogDas.selectPage((BaseEo)inspectionReleaseOperateLogEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, InspectionReleaseOperateLogRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

