/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.INoticeWmsStatusService;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.NoticeWmsStatusDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.NoticeWmsStatusEo;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.NoticeWmsStatusQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.NoticeWmsStatusReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.NoticeWmsStatusRespDto;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class NoticeWmsStatusServiceImpl
implements INoticeWmsStatusService {
    private static final Logger logger = LoggerFactory.getLogger(NoticeWmsStatusServiceImpl.class);
    @Resource
    private NoticeWmsStatusDas noticeWmsStatusDas;

    @Override
    public Long addNoticeWmsStatus(NoticeWmsStatusReqDto addReqDto) {
        NoticeWmsStatusEo noticeWmsStatusEo = new NoticeWmsStatusEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)noticeWmsStatusEo);
        this.noticeWmsStatusDas.insert((BaseEo)noticeWmsStatusEo);
        return noticeWmsStatusEo.getId();
    }

    @Override
    public void modifyNoticeWmsStatus(NoticeWmsStatusReqDto modifyReqDto) {
        NoticeWmsStatusEo noticeWmsStatusEo = new NoticeWmsStatusEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)noticeWmsStatusEo);
        this.noticeWmsStatusDas.updateSelective((BaseEo)noticeWmsStatusEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeNoticeWmsStatus(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.noticeWmsStatusDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public NoticeWmsStatusRespDto queryById(Long id) {
        NoticeWmsStatusEo noticeWmsStatusEo = (NoticeWmsStatusEo)this.noticeWmsStatusDas.selectByPrimaryKey(id);
        NoticeWmsStatusRespDto noticeWmsStatusRespDto = new NoticeWmsStatusRespDto();
        DtoHelper.eo2Dto((BaseEo)noticeWmsStatusEo, (BaseVo)noticeWmsStatusRespDto);
        return noticeWmsStatusRespDto;
    }

    @Override
    public PageInfo<NoticeWmsStatusRespDto> queryByPage(NoticeWmsStatusQueryReqDto queryReqDto) {
        NoticeWmsStatusEo noticeWmsStatusEo = new NoticeWmsStatusEo();
        DtoHelper.dto2Eo((BaseVo)queryReqDto, (BaseEo)noticeWmsStatusEo);
        noticeWmsStatusEo.setOrderByDesc("id");
        PageInfo eoPageInfo = this.noticeWmsStatusDas.selectPage((BaseEo)noticeWmsStatusEo, queryReqDto.getPageNum(), queryReqDto.getPageSize());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, NoticeWmsStatusRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<NoticeWmsStatusRespDto> queryByParamList(NoticeWmsStatusQueryReqDto queryReqDto) {
        LambdaQueryWrapper<NoticeWmsStatusEo> queryWrapper = this.queryWrapper(queryReqDto);
        List saleOrderEos = this.noticeWmsStatusDas.list(queryWrapper);
        if (CollectionUtils.isEmpty((Collection)saleOrderEos)) {
            return Lists.newArrayList();
        }
        ArrayList resultList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)saleOrderEos, (Collection)resultList, NoticeWmsStatusRespDto.class);
        return resultList;
    }

    private LambdaQueryWrapper<NoticeWmsStatusEo> queryWrapper(NoticeWmsStatusQueryReqDto queryReqDto) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)queryReqDto.getWmsOrderNo())) {
            wrapper.eq(NoticeWmsStatusEo::getWmsOrderNo, (Object)queryReqDto.getWmsOrderNo());
        }
        if (StringUtils.isNotBlank((CharSequence)queryReqDto.getDocumentNo())) {
            wrapper.eq(NoticeWmsStatusEo::getDocumentNo, (Object)queryReqDto.getDocumentNo());
        }
        if (StringUtils.isNotBlank((CharSequence)queryReqDto.getType())) {
            wrapper.eq(NoticeWmsStatusEo::getType, (Object)queryReqDto.getType());
        }
        if (StringUtils.isNotBlank((CharSequence)queryReqDto.getOrderStatus())) {
            wrapper.eq(NoticeWmsStatusEo::getOrderStatus, (Object)queryReqDto.getOrderStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)queryReqDto.getOptPerson())) {
            wrapper.eq(NoticeWmsStatusEo::getOptPerson, (Object)queryReqDto.getOptPerson());
        }
        if (CollectionUtils.isNotEmpty((Collection)queryReqDto.getDocumentNoList())) {
            wrapper.in(NoticeWmsStatusEo::getDocumentNo, (Collection)queryReqDto.getDocumentNoList());
        }
        if (CollectionUtils.isNotEmpty((Collection)queryReqDto.getWmsOrderNoList())) {
            wrapper.in(NoticeWmsStatusEo::getWmsOrderNo, (Collection)queryReqDto.getWmsOrderNoList());
        }
        wrapper.eq(BaseEo::getDr, (Object)0);
        wrapper.orderByDesc(BaseEo::getId);
        return wrapper;
    }

    @Override
    public String getNewWmsStatusByDocumentNo(String documentNo) {
        NoticeWmsStatusQueryReqDto queryReqDto = new NoticeWmsStatusQueryReqDto();
        queryReqDto.setDocumentNo(documentNo);
        List<NoticeWmsStatusRespDto> noticeWmsStatusRespDtos = this.queryByParamList(queryReqDto);
        if (CollectionUtils.isEmpty(noticeWmsStatusRespDtos)) {
            return null;
        }
        return noticeWmsStatusRespDtos.get(0).getOrderStatus();
    }
}

