/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.scheduler.task;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.GenerateCodeUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsTransferOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.pcp.ICsLockOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.pcp.ICsLockOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.DateUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.inventory.CsStorageAuditRecordDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsLockLogEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsStorageAuditRecordEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.inventory.pcp.CsLockLogMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsTransferOrderComboReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsTransferOrderDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsTransferOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLockOrderQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLockOrderUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsLockOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsGenerateCodeStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsLockLogStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsLockTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsLogicWarehouseQualityEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsOtherStorageOrderEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsTransferOrderEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.enums.CsWarehouseClassifyEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IRelWarehouseDomain;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.PhysicsWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.RelWarehouseEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderCallBack;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderFacade;
import com.yunxi.dg.base.center.inventory.service.baseorder.constants.BaseOrderOperateTypeEnum;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderBaseContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.ReceiveDeliveryNoticeOrderFacadeBo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="nearOverdueUnlockTask")
@Scope(value="prototype")
public class NearOverdueUnlockTask
extends SingleTupleScheduleEvent {
    private static Logger logger = LoggerFactory.getLogger(NearOverdueUnlockTask.class);
    @Resource
    private ICsLockOrderQueryService csLockOrderQueryService;
    @Resource
    private ICsLockOrderService csLockOrderService;
    @Resource
    private ICsTransferOrderService csTransferOrderService;
    @Resource
    private CsStorageAuditRecordDas csStorageAuditRecordDas;
    @Resource
    IRelWarehouseDomain relWarehouseDomain;
    @Resource
    ILogicWarehouseDomain logicWarehouseDomain;
    @Resource
    private CsLockLogMapper csLockLogMapper;
    @Resource
    BaseOrderFacade baseOrderFacade;
    private static final String NORMAL_REMARK = "\u8fd1\u6548\u671f\u4ea7\u54c1\u5e93\u5b58\u81ea\u52a8\u89e3\u9501";
    private static final String ABNORMAL_REMARK = "\u8fd1\u6548\u671f\u4ea7\u54c1\u8c03\u62e8\u5931\u8d25\uff0c\u8c03\u62e8\u4ed3\u5e93\u4e3a\u7a7a";
    private static final String CREATE_PERSON = "system";

    public void before(TaskMsg taskMsg) {
    }

    public boolean execute(TaskMsg taskMsg) {
        long startTime = System.currentTimeMillis();
        this.task();
        long endTime = System.currentTimeMillis();
        logger.info("nearOverdueUnlockTask\u3010\u5c06\u8fd1\u6548\u671f\u9501\u5e93\u5355\u89e3\u9501\u7684\u5b9a\u65f6\u4efb\u52a1\u3011\u7ed3\u675f\uff0c\u7528\u65f6\uff1a{}", (Object)(startTime - endTime + "ms"));
        return true;
    }

    public void task() {
        CsLockOrderQueryDto queryDto = new CsLockOrderQueryDto();
        queryDto.setIsNearOverdue(Integer.valueOf(1));
        queryDto.setIsLockInventory(Integer.valueOf(1));
        Integer pageNum = 1;
        Integer pageSize = 50;
        while (true) {
            queryDto.setPageNum(pageNum);
            queryDto.setPageSize(pageSize);
            PageInfo<CsLockOrderRespDto> pageInfo = this.csLockOrderQueryService.queryByPage(queryDto);
            if (Objects.isNull(pageInfo) || CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
                logger.info("nearOverdueUnlockTask\u3010\u5c06\u8fd1\u6548\u671f\u9501\u5e93\u5355\u89e3\u9501\u7684\u5b9a\u65f6\u4efb\u52a1\u3011\u6ca1\u6709\u67e5\u5230\u8fd1\u6548\u671f\u7684\u5546\u54c1\u9501\u5e93\uff0c\u4e0d\u7528\u5904\u7406 ");
                break;
            }
            Map<String, List<CsLockOrderRespDto>> map = pageInfo.getList().stream().collect(Collectors.groupingBy(CsLockOrderRespDto::getWarehouseCode));
            logger.info("nearOverdueUnlockTask \u67e5\u8be2\u5728\u9501\u5e93\uff0c\u4e14\u8fd1\u6548\u671f\u7684\u5546\u54c1\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(map));
            for (Map.Entry<String, List<CsLockOrderRespDto>> entry : map.entrySet()) {
                List<CsLockOrderRespDto> list = entry.getValue();
                String logicWarehouseCode = entry.getKey();
                QueryWrapper logicWarehouseQueryWrapper = new QueryWrapper();
                logicWarehouseQueryWrapper.eq((Object)"warehouse_code", (Object)logicWarehouseCode);
                LogicWarehouseEo outLogicWarehouse = this.queryLogicWarehouseEo((QueryWrapper<LogicWarehouseEo>)logicWarehouseQueryWrapper);
                if (outLogicWarehouse == null) continue;
                ArrayList logicWarehouseCodes = Lists.newArrayList((Object[])new String[]{logicWarehouseCode});
                logicWarehouseQueryWrapper = new QueryWrapper();
                logicWarehouseQueryWrapper.eq((Object)"organization_id", (Object)outLogicWarehouse.getOrganizationId());
                logicWarehouseQueryWrapper.eq((Object)"warehouse_quality", (Object)CsLogicWarehouseQualityEnum.PENDING.getCode());
                LogicWarehouseEo inLogicWarehouse = this.queryLogicWarehouseEo((QueryWrapper<LogicWarehouseEo>)logicWarehouseQueryWrapper);
                if (inLogicWarehouse == null) {
                    list.stream().forEach(e -> {
                        QueryWrapper logQueryWrapper = new QueryWrapper();
                        logQueryWrapper.eq((Object)"long_code", (Object)e.getLongCode());
                        logQueryWrapper.eq((Object)"batch", (Object)e.getBatch());
                        logQueryWrapper.eq((Object)"warehouse_code", (Object)e.getWarehouseCode());
                        logQueryWrapper.eq((Object)"log_status", (Object)CsLockLogStatusEnum.ABNORMAL.getCode());
                        logQueryWrapper.eq((Object)"type", (Object)CsLockTypeEnum.UNLOCK.getCode());
                        logQueryWrapper.eq((Object)"dr", (Object)0);
                        List lockLogEos = this.csLockLogMapper.selectList((Wrapper)logQueryWrapper);
                        CsLockLogEo lockLogEo = new CsLockLogEo();
                        lockLogEo.setUpdatePerson(CREATE_PERSON);
                        if (CollectionUtils.isEmpty((Collection)lockLogEos)) {
                            CubeBeanUtils.copyProperties((Object)lockLogEo, (Object)e, (String[])new String[]{"createTime", "updateTime"});
                            lockLogEo.setLogStatus(CsLockLogStatusEnum.ABNORMAL.getCode());
                            lockLogEo.setCurrentQuantity(e.getCurrentLockQuantity());
                            lockLogEo.setType(CsLockTypeEnum.UNLOCK.getCode());
                            lockLogEo.setCreatePerson(CREATE_PERSON);
                            this.csLockLogMapper.insert((Object)lockLogEo);
                        } else {
                            Long id = ((CsLockLogEo)lockLogEos.get(0)).getId();
                            lockLogEo.setId(id);
                            this.csLockLogMapper.updateById((BaseEo)lockLogEo);
                        }
                    });
                    continue;
                }
                logicWarehouseCodes.add(inLogicWarehouse.getWarehouseCode());
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.in((Object)"warehouse_code", (Collection)logicWarehouseCodes);
                queryWrapper.eq((Object)"valid_flag", (Object)CsValidFlagEnum.ENABLE.getCode());
                queryWrapper.eq((Object)"warehouse_classify", (Object)CsWarehouseClassifyEnum.LOGIC.getCode());
                queryWrapper.eq((Object)"ref_warehouse_classify", (Object)CsWarehouseClassifyEnum.PHYSICS.getCode());
                queryWrapper.eq((Object)"dr", (Object)0);
                List csRelWarehouseEos = this.relWarehouseDomain.getMapper().selectList((Wrapper)queryWrapper);
                logger.info("nearOverdueUnlockTask \u6839\u636e\u903b\u8f91\u4ed3\u5e93\u67e5\u8be2\u51fa\u5e93\u7269\u7406\u4ed3\u5e93==>csRelWarehouseEo:{}", (Object)LogUtils.buildLogContent(csRelWarehouseEos));
                PhysicsWarehouseEo outPhysicsWarehouseEo = new PhysicsWarehouseEo();
                PhysicsWarehouseEo inPhysicsWarehouseEo = new PhysicsWarehouseEo();
                if (CollectionUtils.isNotEmpty((Collection)csRelWarehouseEos)) {
                    RelWarehouseEo csRelWarehouseEo;
                    Map physicsWarehouseMap = csRelWarehouseEos.stream().collect(Collectors.toMap(RelWarehouseEo::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
                    if (Objects.nonNull(physicsWarehouseMap.get(logicWarehouseCode))) {
                        csRelWarehouseEo = (RelWarehouseEo)physicsWarehouseMap.get(logicWarehouseCode);
                        outPhysicsWarehouseEo.setWarehouseCode(csRelWarehouseEo.getRefWarehouseCode());
                        outPhysicsWarehouseEo.setWarehouseName(csRelWarehouseEo.getRefWarehouseName());
                    }
                    if (Objects.nonNull(physicsWarehouseMap.get(logicWarehouseCode))) {
                        csRelWarehouseEo = (RelWarehouseEo)physicsWarehouseMap.get(inLogicWarehouse.getWarehouseCode());
                        inPhysicsWarehouseEo.setWarehouseCode(csRelWarehouseEo.getRefWarehouseCode());
                        inPhysicsWarehouseEo.setWarehouseName(csRelWarehouseEo.getRefWarehouseName());
                    }
                }
                list.stream().forEach(e -> {
                    CsLockOrderUpdateReqDto updateReqDto = new CsLockOrderUpdateReqDto();
                    updateReqDto.setWarehouseCode(e.getWarehouseCode());
                    updateReqDto.setLongCode(e.getLongCode());
                    updateReqDto.setBatch(e.getBatch());
                    updateReqDto.setCurrentLockQuantity(e.getCurrentLockQuantity());
                    updateReqDto.setIsNearOverdue(Integer.valueOf(1));
                    updateReqDto.setRemark(NORMAL_REMARK);
                    updateReqDto.setCreatePerson(CREATE_PERSON);
                    CsTransferOrderDetailReqDto csTransferOrderDetailReqDto = new CsTransferOrderDetailReqDto();
                    csTransferOrderDetailReqDto.setCargoName(e.getCargoName());
                    csTransferOrderDetailReqDto.setCargoCode(e.getCargoCode());
                    csTransferOrderDetailReqDto.setBatch(e.getBatch());
                    csTransferOrderDetailReqDto.setArtNo(e.getArtNo());
                    csTransferOrderDetailReqDto.setLongCode(e.getLongCode());
                    csTransferOrderDetailReqDto.setDueDate(DateUtils.formatDate(e.getExpireTime(), "yyyy-MM-dd HH:mm:ss"));
                    csTransferOrderDetailReqDto.setProductDate(DateUtils.formatDate(e.getProduceTime(), "yyyy-MM-dd HH:mm:ss"));
                    csTransferOrderDetailReqDto.setQuantity(e.getCurrentLockQuantity());
                    String result = this.csLockOrderService.updateLockInventory(CsLockTypeEnum.UNLOCK.getCode(), updateReqDto, false);
                    logger.info("nearOverdueUnlockTask \u89e3\u9501\u9501\u5e93\u5355\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)result));
                    if (StringUtils.isNotBlank((CharSequence)result)) {
                        this.generateTransferOrder(outLogicWarehouse, inLogicWarehouse, outPhysicsWarehouseEo, inPhysicsWarehouseEo, csTransferOrderDetailReqDto);
                    }
                });
            }
            if (pageInfo.getList().size() < pageSize) break;
            Integer n = pageNum;
            Integer n2 = pageNum = Integer.valueOf(pageNum + 1);
        }
    }

    private LogicWarehouseEo queryLogicWarehouseEo(QueryWrapper<LogicWarehouseEo> logicWarehouseQueryWrapper) {
        logicWarehouseQueryWrapper.eq((Object)"dr", (Object)0);
        logger.info("nearOverdueUnlockTask \u67e5\u8be2\u903b\u8f91\u4ed3\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString(logicWarehouseQueryWrapper));
        List outLogicWarehouseEos = this.logicWarehouseDomain.getMapper().selectList(logicWarehouseQueryWrapper);
        logger.info(String.format("nearOverdueUnlockTask \u67e5\u5230\u4ed3\u5e93\u4fe1\u606f\uff1a%s", JSON.toJSONString((Object)outLogicWarehouseEos)));
        if (CollectionUtils.isEmpty((Collection)outLogicWarehouseEos)) {
            logger.error(String.format("nearOverdueUnlockTask \u627e\u4e0d\u5230\u4ed3\u5e93\u4fe1\u606f", new Object[0]));
            return null;
        }
        LogicWarehouseEo outLogicWarehouse = (LogicWarehouseEo)outLogicWarehouseEos.get(0);
        if (Objects.isNull(outLogicWarehouse) || Objects.isNull(outLogicWarehouse.getOrganizationId())) {
            logger.error(String.format("nearOverdueUnlockTask \u627e\u4e0d\u5230\u7ec4\u7ec7\u4fe1\u606f", new Object[0]));
            return null;
        }
        return outLogicWarehouse;
    }

    public String generateTransferOrder(LogicWarehouseEo outLogicWarehouse, LogicWarehouseEo inLogicWarehouse, PhysicsWarehouseEo outPhysicsWarehouseEo, PhysicsWarehouseEo inPhysicsWarehouseEo, CsTransferOrderDetailReqDto detailReqDto) {
        CsTransferOrderComboReqDto transferOrderComboReqDto = new CsTransferOrderComboReqDto();
        String transferNo = GenerateCodeUtils.getStrategy(CsGenerateCodeStrategyEnum.TRANSFER_ORDER.getCode()).getCode();
        CsTransferOrderReqDto transferOrderReqDto = new CsTransferOrderReqDto();
        transferOrderReqDto.setTransferOrderNo(transferNo);
        transferOrderReqDto.setOrderStatus(CsTransferOrderEnum.Status.WAIT_DELIVERY.getCode());
        transferOrderReqDto.setOrderSrc("PCP");
        transferOrderReqDto.setInLogicWarehouseCode(inLogicWarehouse.getWarehouseCode());
        transferOrderReqDto.setInLogicWarehouseName(inLogicWarehouse.getWarehouseName());
        transferOrderReqDto.setInPhysicsWarehouseCode(inPhysicsWarehouseEo.getWarehouseCode());
        transferOrderReqDto.setInPhysicsWarehouseName(inPhysicsWarehouseEo.getWarehouseName());
        transferOrderReqDto.setInOrganization(inLogicWarehouse.getOrganizationName());
        transferOrderReqDto.setInOrganizationId(inLogicWarehouse.getOrganizationId());
        transferOrderReqDto.setOutLogicWarehouseCode(outLogicWarehouse.getWarehouseCode());
        transferOrderReqDto.setOutLogicWarehouseName(outLogicWarehouse.getWarehouseName());
        transferOrderReqDto.setOutPhysicsWarehouseCode(outPhysicsWarehouseEo.getWarehouseCode());
        transferOrderReqDto.setOutPhysicsWarehouseName(outPhysicsWarehouseEo.getWarehouseName());
        transferOrderReqDto.setOutOrganization(outLogicWarehouse.getOrganizationCode());
        transferOrderReqDto.setOutOrganizationId(outLogicWarehouse.getOrganizationId());
        transferOrderReqDto.setTotalQuantity(detailReqDto.getQuantity());
        transferOrderReqDto.setType(CsPcpBusinessTypeEnum.ALLOT_LOSE_EFFICACY.getCode());
        transferOrderComboReqDto.setCsOtherStorageOrderReqDto(transferOrderReqDto);
        transferOrderComboReqDto.setDetailList((List)Lists.newArrayList((Object[])new CsTransferOrderDetailReqDto[]{detailReqDto}));
        this.csTransferOrderService.addTransferOrder(transferOrderComboReqDto);
        this.insertAuditLog(transferNo);
        this.generateDeliveryNoticeOrder(transferOrderReqDto, detailReqDto);
        return transferNo;
    }

    private void insertAuditLog(String transferNo) {
        CsStorageAuditRecordEo auditLog = new CsStorageAuditRecordEo();
        auditLog.setAuditResult(CsOtherStorageOrderEnum.AuditEnum.AUDIT_PASS.getCode());
        auditLog.setRemark("\u8fd1\u6548\u671f\u5546\u54c1\u8c03\u62e8\u81ea\u52a8\u5ba1\u6838\u901a\u8fc7");
        auditLog.setType(CsOtherStorageOrderEnum.InOrOut.ALLOT_LOSE_EFFICACY.getCode());
        auditLog.setOrderSrcNo(transferNo);
        this.csStorageAuditRecordDas.insert((BaseEo)auditLog);
    }

    private void generateDeliveryNoticeOrder(CsTransferOrderReqDto respDto, CsTransferOrderDetailReqDto detailDto) {
        logger.info("nearOverdueUnlockTask==>\u8c03\u62e8\u5355\u751f\u6210\u53d1\u8d27\u901a\u77e5\u5355,orderNo:{}", (Object)respDto.getTransferOrderNo());
        ReceiveDeliveryNoticeOrderFacadeBo noticeOrderFacadeBo = new ReceiveDeliveryNoticeOrderFacadeBo();
        noticeOrderFacadeBo.setOperateTypeEnum(BaseOrderOperateTypeEnum.DELIVERY);
        noticeOrderFacadeBo.setPreOrderNo(respDto.getPreOrderNo());
        noticeOrderFacadeBo.setExternalOrderNo("");
        noticeOrderFacadeBo.setRelevanceNo(respDto.getTransferOrderNo());
        noticeOrderFacadeBo.setBusinessType(respDto.getType());
        noticeOrderFacadeBo.setRelevanceTableName(CsRelevanceTableNameEnum.CS_TRANSFER_ORDER);
        noticeOrderFacadeBo.setLogicWarehouseCode(respDto.getOutLogicWarehouseCode());
        noticeOrderFacadeBo.setLogicWarehouseName(respDto.getOutLogicWarehouseName());
        noticeOrderFacadeBo.setPhysicsWarehouseCode(respDto.getOutPhysicsWarehouseCode());
        noticeOrderFacadeBo.setPhysicsWarehouseName(respDto.getOutPhysicsWarehouseName());
        noticeOrderFacadeBo.setTransferInLogicWarehouseCode(respDto.getInLogicWarehouseCode());
        noticeOrderFacadeBo.setSourceType(CsInventorySourceTypeEnum.OUT_ALLOT.getCode());
        noticeOrderFacadeBo.setPreemptReleaseType(CsInventorySourceTypeEnum.TRANSFER_OTHER_PREEMPT.getCode());
        ArrayList<BaseOrderDetailReqDto> deliveryDetailList = new ArrayList<BaseOrderDetailReqDto>(1);
        BaseOrderDetailReqDto detailReqDto = new BaseOrderDetailReqDto();
        detailReqDto.setPreOrderItemId(detailDto.getId());
        detailReqDto.setSkuCode(detailDto.getLongCode());
        detailReqDto.setSkuName(detailDto.getCargoName());
        detailReqDto.setQuantity(detailDto.getQuantity());
        detailReqDto.setBatch(detailDto.getBatch());
        detailReqDto.setVolume(detailDto.getVolume());
        deliveryDetailList.add(detailReqDto);
        noticeOrderFacadeBo.setOrderBasicsDetailReqDtoList(deliveryDetailList);
        noticeOrderFacadeBo.setCallBack((BaseOrderCallBack)new BaseOrderCallBack<BaseOrderBaseContext>(){

            public void beforeCallBack(BaseOrderBaseContext context) {
            }

            public void afterCallBack(BaseOrderBaseContext context) {
            }
        });
        this.baseOrderFacade.deliveryNoticeOrderGen(noticeOrderFacadeBo);
    }

    public void after(TaskMsg taskMsg) {
    }
}

