/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.external.impl.wms;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.tcbj.center.openapi.common.qimen.dto.request.ReturnorderCreateRequestDto;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsItemLine;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsReturnOrderCreateReqDto;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.dto.ExchangeCarrierDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.mq.MqService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IConsignmentOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.commons.BusinessOrderCallBackParseHelper;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.external.AbstractCsBasicsExternalService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.external.anno.CsBasicsExternalStrategy;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.external.wms.ICsWmsService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.IAdjustInTransitHandler;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsOutNoticeOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.business.CsBusinessOrderCallBackUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.business.ICsBusinessOrderCallBackService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.CodeGenerateUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.DateUtils;
import com.dtyunxi.yundt.cube.center.inventory.constant.ShipmentMappingConstant;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.ConsignmentOrderAddressDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.ConsignmentOrderDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.ConsignmentOrderDeliveryInfoDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.IInventoryBatchDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.MergeNoticeTransferDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.ConsignmentOrderAddressEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.ConsignmentOrderDeliveryInfoEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.ConsignmentOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.InventoryBatchEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.MergeNoticeTransferEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsTransferOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.ConsignmentOrderMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.InventoryBatchMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.CsResultOrderExtendDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.external.wms.CsBasicsCancelReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.external.wms.CsBasicsReceiveReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.external.wms.CsWmsBasicsDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOrderBusinessCallBackContext;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.ShippingJsonDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsBusinessCallBackStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryInOutEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsTransferDispatcherStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsTransferOrderEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleOrderQueryApi;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.basicdata.enums.DictEnum;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInventoryPreemptionDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IPhysicsWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IWarehouseAddressDomain;
import com.yunxi.dg.base.center.inventory.dto.domain.ContactDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsBasicsOrderReqDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsWmsShippingInfoReqDto;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.PhysicsWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.WarehouseAddressEo;
import com.yunxi.dg.base.center.inventory.proxy.data.IPcpDictApiProxy;
import com.yunxi.dg.base.center.inventory.proxy.item.IItemSkuQueryApiProxy;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderCallBack;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderFacade;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderBaseContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.InOutResultOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.ReceiveDeliveryResultOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.BaseOrderCommonCancelBo;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.InOutResultOrderFacadeBo;
import com.yunxi.dg.base.center.inventory.transcation.TransactionAfterService;
import com.yunxi.dg.base.center.inventory.transcation.TransactionCallBackService;
import com.yunxi.dg.base.center.item.ItemSkuDto;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.LogUtils;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@CsBasicsExternalStrategy(strategyName="wms")
@Component(value="CswmsexternalBasicsStrategyService")
public class CsWmsExternalServiceImpl
extends AbstractCsBasicsExternalService {
    private static final Logger log = LoggerFactory.getLogger(CsWmsExternalServiceImpl.class);
    @Autowired
    IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Autowired
    IInOutNoticeOrderDetailDomain inOutNoticeOrderDetailDomain;
    @Autowired
    IReceiveDeliveryNoticeOrderDomain receiveDeliveryNoticeOrderDomain;
    @Autowired
    IInOutResultOrderDomain inOutResultOrderDomain;
    @Autowired
    IInOutResultOrderDetailDomain inOutResultOrderDetailDomain;
    @Resource
    IAdjustInTransitHandler adjustInTransitHandler;
    @Resource
    MqService mqService;
    @Resource
    private ICommonsMqService commonsMqService;
    @Autowired
    ILockService lockService;
    @Autowired
    TransactionCallBackService transactionCallBackService;
    @Autowired
    TransactionAfterService transactionAfterService;
    @Autowired
    ICsOutNoticeOrderService csOutNoticeOrderService;
    @Autowired
    IPhysicsWarehouseDomain physicsWarehouseDomain;
    @Autowired
    IItemSkuQueryApiProxy itemSkuProxy;
    @Autowired
    BaseOrderFacade baseOrderFacade;
    @Autowired
    IPcpDictApiProxy pcpDictApiProxy;
    @Autowired
    IWarehouseAddressDomain warehouseAddressDomain;
    @Autowired
    CodeGenerateUtil codeGenerateUtil;
    @Autowired
    ConsignmentOrderDas consignmentOrderDas;
    @Autowired
    ConsignmentOrderAddressDas consignmentOrderAddressDas;
    @Autowired
    IConsignmentOrderService consignmentOrderService;
    @Autowired
    ConsignmentOrderDeliveryInfoDas consignmentOrderDeliveryInfoDas;
    @Autowired
    ICsWmsService csWmsService;
    @Autowired
    ConsignmentOrderMapper consignmentOrderMapper;
    @Autowired
    InventoryBatchMapper inventoryBatchMapper;
    @Autowired
    IInventoryBatchDas inventoryBatchDas;
    @Autowired
    IInventoryPreemptionDomain inventoryPreemptionDomain;
    @Resource
    ISaleOrderQueryApi saleOrderQueryApi;
    @Autowired
    MergeNoticeTransferDas mergeNoticeTransferDas;
    protected static final String IN_INVENTORY_LOCK = "in_inventory_lock";
    protected static final int LOCK_TIME_OUT = 60;
    public static List<String> notRqwlPhysicsWarehouseCodes = Lists.newArrayList((Object[])new String[]{"ZHK", "HZRDC"});

    @Override
    public Boolean send(CsBasicsOrderReqDto sendInfo) {
        return true;
    }

    @Override
    public Boolean receive(CsBasicsOrderReqDto receiveInfo) {
        return true;
    }

    @Override
    public Boolean receiveIn(CsBasicsReceiveReqDto basicsReceiveBasicsReqDto) {
        return this.receiveInWms(basicsReceiveBasicsReqDto);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean receiveInWms(CsBasicsReceiveReqDto basicsReceiveBasicsReqDto) {
        super.checkParams(basicsReceiveBasicsReqDto);
        Mutex mutex = this.lockService.lock(IN_INVENTORY_LOCK, basicsReceiveBasicsReqDto.getInOutNoticeOrderNo(), 60, 65, TimeUnit.SECONDS);
        try {
            String inOutNoticeOrderNo = basicsReceiveBasicsReqDto.getInOutNoticeOrderNo();
            QueryWrapper inOutNoticeOrderEoQueryWrapper = new QueryWrapper();
            inOutNoticeOrderEoQueryWrapper.eq((Object)"document_no", (Object)inOutNoticeOrderNo);
            inOutNoticeOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
            inOutNoticeOrderEoQueryWrapper.eq((Object)"order_type", (Object)"in");
            inOutNoticeOrderEoQueryWrapper.in((Object)"order_status", (Collection)Lists.newArrayList((Object[])new String[]{BaseOrderStatusEnum.INO_WAIT_IN.getCode(), BaseOrderStatusEnum.INO_PORTION_IN.getCode(), BaseOrderStatusEnum.INO_TOTAL_IN.getCode()}));
            List inOutNoticeOrderEos = this.inOutNoticeOrderDomain.getMapper().selectList((Wrapper)inOutNoticeOrderEoQueryWrapper);
            AssertUtils.notEmpty((Collection)inOutNoticeOrderEos, (String)"\u67e5\u8be2\u4e0d\u5230\u51fa\u5165\u5e93\u5355\u636e\u4fe1\u606f");
            InOutNoticeOrderEo inOutNoticeOrderEo = (InOutNoticeOrderEo)inOutNoticeOrderEos.get(0);
            if (CsRelevanceTableNameEnum.CS_IN_PLANNED_ORDER.getCode().equals(inOutNoticeOrderEo.getRelevanceTableName())) {
                this.calculateExpireTime(basicsReceiveBasicsReqDto);
            }
            List inOutNoticeOrderDetailEos = this.inOutNoticeOrderDetailDomain.queryByDocumentNo(inOutNoticeOrderEo.getDocumentNo());
            this.judgmentDispathcer(basicsReceiveBasicsReqDto, inOutNoticeOrderDetailEos, CsBusinessCallBackStrategyEnum.getByTableName((String)inOutNoticeOrderEo.getRelevanceTableName()), inOutNoticeOrderEo);
            ((CsWmsExternalServiceImpl)SpringBeanUtil.getBean(CsWmsExternalServiceImpl.class)).callBackIn(basicsReceiveBasicsReqDto, inOutNoticeOrderEo, inOutNoticeOrderDetailEos);
        }
        finally {
            this.transactionAfterService.execute(() -> this.lockService.unlock(mutex));
        }
        return true;
    }

    private void judgmentDispathcer(CsBasicsReceiveReqDto basicsReceiveBasicsReqDto, List<InOutNoticeOrderDetailEo> inOutNoticeOrderDetailEos, CsBusinessCallBackStrategyEnum callBackStrategyEnum, InOutNoticeOrderEo csOutNoticeOrderEo) {
        if (!InventoryConfig.isDispatchOrderEnable()) {
            return;
        }
        Map itemBatchMap = inOutNoticeOrderDetailEos.stream().collect(Collectors.toMap(k -> k.getSkuCode() + "_" + k.getBatch(), Function.identity(), (o, o1) -> o));
        basicsReceiveBasicsReqDto.getDetailReqDtoList().forEach(detail -> {
            String key = detail.getSkuCode() + Optional.ofNullable(detail.getBatch()).filter(StringUtils::isNotBlank).map(r -> "_" + r).orElse("");
            if (CsBusinessCallBackStrategyEnum.TRANSFER_ORDER.getCode().equals(callBackStrategyEnum.getCode()) && "in".equals(csOutNoticeOrderEo.getOrderType())) {
                log.info("\u5f00\u59cb\u8fdb\u884c\u6536\u53d1\u5dee\u5f02\u5355\u7684\u5224\u65ad,detail\uff1a{}", (Object)JSON.toJSONString((Object)detail));
                if (itemBatchMap.containsKey(key)) {
                    InOutNoticeOrderDetailEo eo1 = (InOutNoticeOrderDetailEo)itemBatchMap.get(key);
                    BigDecimal subtract = detail.getQuantity().subtract(eo1.getWaitQuantity());
                    if (subtract.compareTo(BigDecimal.ZERO) > 0) {
                        log.info("\u591a\u6536");
                        detail.setQuantity(eo1.getWaitQuantity());
                        detail.setDispatcherStatus(CsTransferDispatcherStatusEnum.MORE_DISPATCHER.getCode());
                    } else if (subtract.compareTo(BigDecimal.ZERO) < 0) {
                        log.info("\u5c11\u6536");
                        detail.setDispatcherStatus(CsTransferDispatcherStatusEnum.LESS_DISPATCHER.getCode());
                    } else {
                        log.info("\u6b63\u5e38\u6536");
                        detail.setDispatcherStatus(CsTransferDispatcherStatusEnum.NO_DISPATCHER.getCode());
                    }
                    detail.setDispatcherQuantity(subtract);
                } else {
                    log.info("\u65b0\u589e\u591a\u6536");
                    detail.setDispatcherQuantity(detail.getQuantity());
                    detail.setQuantity(BigDecimal.ZERO);
                    detail.setDispatcherStatus(CsTransferDispatcherStatusEnum.MORE_DISPATCHER.getCode());
                }
                log.info("\u6536\u53d1\u5dee\u5f02\u5355\u7684\u5224\u65ad\u7ed3\u675f,detail\uff1a{}", (Object)JSON.toJSONString((Object)detail));
            }
        });
        log.info("\u6536\u53d1\u5dee\u5f02\u5355\u5224\u65ad\u540e\u7684\u6574\u4f53\u53c2\u6570\u5982\u4e0b\uff1a{}", (Object)JSON.toJSONString((Object)basicsReceiveBasicsReqDto));
    }

    @Transactional(rollbackFor={Exception.class})
    public void callBackIn(CsBasicsReceiveReqDto basicsReceiveBasicsReqDto, InOutNoticeOrderEo inOutNoticeOrderEo, List<InOutNoticeOrderDetailEo> inOutNoticeOrderDetailEos) {
        this.matchLineNo(basicsReceiveBasicsReqDto.getDetailReqDtoList(), inOutNoticeOrderDetailEos);
        InOutResultOrderFacadeBo inOutResultOrderFacadeBo = new InOutResultOrderFacadeBo();
        inOutResultOrderFacadeBo.setWmsOrderNo(basicsReceiveBasicsReqDto.getWmsOrderNo());
        inOutResultOrderFacadeBo.setMergeQuantity(basicsReceiveBasicsReqDto.getMergeQuantity());
        inOutResultOrderFacadeBo.setTotalCartons(basicsReceiveBasicsReqDto.getTotalCartons());
        inOutResultOrderFacadeBo.setInOutNoticeOrderEo(inOutNoticeOrderEo);
        inOutResultOrderFacadeBo.setInOutNoticeOrderDetailEos(inOutNoticeOrderDetailEos);
        inOutResultOrderFacadeBo.setShippingInfoReqDtoList(basicsReceiveBasicsReqDto.getShippingInfoReqDtoList());
        inOutResultOrderFacadeBo.setOverchargeQuantity(basicsReceiveBasicsReqDto.getDetailReqDtoList().stream().filter(a -> CsTransferDispatcherStatusEnum.MORE_DISPATCHER.getCode().equals(a.getDispatcherStatus())).map(CsWmsBasicsDetailReqDto::getDispatcherQuantity).reduce(BigDecimal.ZERO, BigDecimal::add));
        inOutResultOrderFacadeBo.setReceivelessQuantity(basicsReceiveBasicsReqDto.getDetailReqDtoList().stream().filter(a -> CsTransferDispatcherStatusEnum.LESS_DISPATCHER.getCode().equals(a.getDispatcherStatus())).map(CsWmsBasicsDetailReqDto::getDispatcherQuantity).reduce(BigDecimal.ZERO, BigDecimal::add));
        inOutResultOrderFacadeBo.setDispatcherStatus(this.getDispatcherStatus(inOutResultOrderFacadeBo.getOverchargeQuantity(), inOutResultOrderFacadeBo.getReceivelessQuantity()));
        inOutResultOrderFacadeBo.setExtension(inOutNoticeOrderEo.getExtension());
        List skuCodes = basicsReceiveBasicsReqDto.getDetailReqDtoList().stream().map(CsWmsBasicsDetailReqDto::getSkuCode).distinct().collect(Collectors.toList());
        List skuDtoList = this.itemSkuProxy.queryBySkuCodes(skuCodes);
        Map skuDtoMap = skuDtoList.stream().collect(Collectors.toMap(ItemSkuDto::getSkuCode, Function.identity()));
        ArrayList detailReqDtoList = Lists.newArrayList();
        for (CsWmsBasicsDetailReqDto csWmsBasicsDetailReqDto : basicsReceiveBasicsReqDto.getDetailReqDtoList()) {
            BaseOrderDetailReqDto detailReqDto = new BaseOrderDetailReqDto();
            ItemSkuDto itemSkuDto = (ItemSkuDto)skuDtoMap.get(csWmsBasicsDetailReqDto.getSkuCode());
            if (null == itemSkuDto) {
                throw new BizException(StrUtil.format((CharSequence)"\u5546\u54c1\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728, sku code: %s", (Object[])new Object[]{csWmsBasicsDetailReqDto.getSkuCode()}));
            }
            InOutNoticeOrderDetailEo noticeOrderDetailEo = inOutNoticeOrderDetailEos.stream().filter(o -> Objects.equals(o.getPreOrderItemId(), csWmsBasicsDetailReqDto.getTradeOrderItemId())).findFirst().orElse(null);
            AssertUtils.notNull((Object)csWmsBasicsDetailReqDto, (String)"\u5546\u54c1\u884c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            JSONObject noticeDetailExtensionJson = new JSONObject();
            if (ObjectUtil.isNotEmpty((Object)noticeOrderDetailEo)) {
                noticeDetailExtensionJson = JSONObject.parseObject((String)noticeOrderDetailEo.getExtension());
            }
            if (ObjectUtil.isNotEmpty((Object)noticeDetailExtensionJson)) {
                detailReqDto.setExtension(noticeDetailExtensionJson.toJSONString());
            }
            detailReqDto.setSkuCode(csWmsBasicsDetailReqDto.getSkuCode());
            detailReqDto.setSkuName(itemSkuDto.getSkuName());
            detailReqDto.setBatch(csWmsBasicsDetailReqDto.getBatch());
            detailReqDto.setQuantity(csWmsBasicsDetailReqDto.getQuantity());
            detailReqDto.setWeight(csWmsBasicsDetailReqDto.getWeight());
            detailReqDto.setVolume(csWmsBasicsDetailReqDto.getVolume());
            detailReqDto.setExpireTime(csWmsBasicsDetailReqDto.getExpireTime());
            detailReqDto.setProduceTime(csWmsBasicsDetailReqDto.getProduceTime());
            detailReqDto.setLineNo(csWmsBasicsDetailReqDto.getLineNo());
            detailReqDto.setPreOrderItemId(csWmsBasicsDetailReqDto.getTradeOrderItemId());
            detailReqDto.setDispatcherStatus(csWmsBasicsDetailReqDto.getDispatcherStatus());
            detailReqDto.setDispatcherQuantity(csWmsBasicsDetailReqDto.getDispatcherQuantity());
            detailReqDtoList.add(detailReqDto);
        }
        inOutResultOrderFacadeBo.setOrderBasicsDetailReqDtoList((List)detailReqDtoList);
        inOutResultOrderFacadeBo.setCallBack(this.createInCallback(basicsReceiveBasicsReqDto, inOutNoticeOrderEo, inOutNoticeOrderDetailEos));
        inOutResultOrderFacadeBo.setCompleteCallBack(context -> {
            if (context instanceof InOutResultOrderContext) {
                InOutResultOrderContext inOutResultOrderContext = (InOutResultOrderContext)context;
                log.info("callBackIn CompleteCallBack context: {}", (Object)LogUtils.buildLogContent((Object)inOutResultOrderContext));
                CsBusinessCallBackStrategyEnum callBackStrategyEnum = CsBusinessCallBackStrategyEnum.getByTableName((String)inOutNoticeOrderEo.getRelevanceTableName());
                ICsBusinessOrderCallBackService businessOrderCallBackService = CsBusinessOrderCallBackUtils.getBusinessOrderCallBackService(callBackStrategyEnum.getCode());
                CsOrderBusinessCallBackContext csOrderBusinessCallBackContext = BusinessOrderCallBackParseHelper.parseNoticeCallBack(context);
                csOrderBusinessCallBackContext.setPortionFlag(Boolean.valueOf(!inOutResultOrderContext.isNoticeEnd()));
                csOrderBusinessCallBackContext.setInOutResultOrderDetailEos(inOutResultOrderContext.getInOutResultOrderDetailEoList());
                csOrderBusinessCallBackContext.setInOutResultOrderEo(inOutResultOrderContext.getInOutResultOrderEo());
                businessOrderCallBackService.deliveryReceiveResultOrderCallBack(csOrderBusinessCallBackContext);
            }
        });
        this.baseOrderFacade.inResultOrderGen(inOutResultOrderFacadeBo);
    }

    private String getDispatcherStatus(BigDecimal overchargeQuantity, BigDecimal receivelessQuantity) {
        if (overchargeQuantity.compareTo(BigDecimal.ZERO) != 0 && receivelessQuantity.compareTo(BigDecimal.ZERO) != 0) {
            return CsTransferDispatcherStatusEnum.DISPATCHER.getCode();
        }
        if (overchargeQuantity.compareTo(BigDecimal.ZERO) == 0 && receivelessQuantity.compareTo(BigDecimal.ZERO) == 0) {
            return CsTransferDispatcherStatusEnum.NO_DISPATCHER.getCode();
        }
        if (overchargeQuantity.compareTo(BigDecimal.ZERO) != 0) {
            return CsTransferDispatcherStatusEnum.MORE_DISPATCHER.getCode();
        }
        if (receivelessQuantity.compareTo(BigDecimal.ZERO) != 0) {
            return CsTransferDispatcherStatusEnum.LESS_DISPATCHER.getCode();
        }
        return null;
    }

    @Override
    protected void buildOverchargeProportion(InOutNoticeOrderEo csOutNoticeOrderEo) {
        log.info("buildOverchargeProportion==>\u83b7\u53d6\u8d85\u6536\u6bd4\u4f8b,csOutNoticeOrderEo:{}", (Object)LogUtils.buildLogContent((Object)csOutNoticeOrderEo));
        String relevanceTableName = csOutNoticeOrderEo.getRelevanceTableName();
        if (!CsRelevanceTableNameEnum.CS_IN_PLANNED_ORDER.getCode().equals(relevanceTableName)) {
            this.overchargeProportion = BigDecimal.ONE;
            return;
        }
        String orderType = csOutNoticeOrderEo.getOrderType();
        if (!"in".equals(orderType)) {
            this.overchargeProportion = BigDecimal.ONE;
            return;
        }
        String plannedOrderType = csOutNoticeOrderEo.getBusinessType();
        String code = DictEnum.PURCHASE_ORDER_RATIO.getCode();
        if (CsPlannedOrderTypeEnum.PRODUCTION.getCode().equals(plannedOrderType)) {
            code = DictEnum.PRODUCTION_ORDER_RATIO.getCode();
        } else if (CsPlannedOrderTypeEnum.OUTSOURCE.getCode().equals(plannedOrderType)) {
            code = DictEnum.OUT_SOURCED_ORDER_RATIO.getCode();
        }
        try {
            log.info("buildOverchargeProportion==>\u83b7\u53d6\u8d85\u6536\u6bd4\u4f8b,GROUP_CODE:{},code:{}", (Object)DictEnum.PURCHASE_ORDER_RATIO.getGroupCode(), (Object)code);
            DictDto dictDto = this.pcpDictApiProxy.queryByGroupCodeAndCode(DictEnum.PURCHASE_ORDER_RATIO.getGroupCode(), code);
            log.info("buildOverchargeProportion==>\u83b7\u53d6\u8d85\u6536\u6bd4\u4f8b,dictDto:{}", (Object)LogUtils.buildLogContent((Object)dictDto));
            if (null != dictDto) {
                String value = dictDto.getValue();
                BigDecimal decimalVal = BigDecimalUtils.divide((BigDecimal)BigDecimalUtils.parse((String)value), (BigDecimal)BigDecimalUtils.ONE_HUNDRED, (int)4);
                this.overchargeProportion = BigDecimalUtils.add((BigDecimal)decimalVal, (BigDecimal)BigDecimal.ONE);
                log.info("buildOverchargeProportion==>\u83b7\u53d6\u8d85\u6536\u6bd4\u4f8b,\u57fa\u7840\u6570\u636e\u4e2d\u5fc3\u8ba1\u7b97\u4e4b\u540e\u7684,overchargeProportion:{}", (Object)this.overchargeProportion);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private BaseOrderCallBack createInCallback(final CsBasicsReceiveReqDto basicsReceiveBasicsReqDto, final InOutNoticeOrderEo inOutNoticeOrderEo, final List<InOutNoticeOrderDetailEo> inOutNoticeOrderDetailEos) {
        final Map<String, List<InOutNoticeOrderDetailEo>> noticeDetailBatchMap = inOutNoticeOrderDetailEos.stream().collect(Collectors.groupingBy(InOutNoticeOrderDetailEo::getSkuCode));
        List receiveDeliveryNoticeOrderEos = this.receiveDeliveryNoticeOrderDomain.queryByRelevanceNo(inOutNoticeOrderEo.getRelevanceNo());
        AssertUtils.notEmpty((Collection)receiveDeliveryNoticeOrderEos, (String)"\u6536\u53d1\u8d27\u901a\u77e5\u5355\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728");
        final ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo = (ReceiveDeliveryNoticeOrderEo)receiveDeliveryNoticeOrderEos.get(0);
        return new BaseOrderCallBack<BaseOrderBaseContext>(){

            public void beforeCallBack(BaseOrderBaseContext context) {
                log.info("\u5165\u5e93\u5355\u56de\u4f20beforeCallBack-{}", JSON.toJSON((Object)context));
                context.setTransparentCallback(Boolean.valueOf(true));
                if (context instanceof ReceiveDeliveryResultOrderContext) {
                    ReceiveDeliveryResultOrderEo receiveDeliveryResultOrderEo = ((ReceiveDeliveryResultOrderContext)context).getReceiveDeliveryResultOrderEo();
                    receiveDeliveryResultOrderEo.setExtension(receiveDeliveryNoticeOrderEo.getExtension());
                } else if (context instanceof InOutResultOrderContext) {
                    InOutResultOrderContext inContext = (InOutResultOrderContext)context;
                    CsWmsExternalServiceImpl.this.buildOverchargeProportion(inOutNoticeOrderEo);
                    String overchargeReason = CsWmsExternalServiceImpl.this.checkOverchargeIn(inOutNoticeOrderEo, inOutNoticeOrderDetailEos, basicsReceiveBasicsReqDto.getDetailReqDtoList());
                    if (StringUtils.isBlank((CharSequence)overchargeReason)) {
                        overchargeReason = CsWmsExternalServiceImpl.this.checkOverchargeFlag(inOutNoticeOrderEo, noticeDetailBatchMap, basicsReceiveBasicsReqDto.getDetailReqDtoList());
                    }
                    inContext.setHangup(StringUtils.isNotBlank((CharSequence)overchargeReason));
                    InOutResultOrderEo inOutResultOrderEo = inContext.getInOutResultOrderEo();
                    inOutResultOrderEo.setOverChargeReason(overchargeReason);
                    inOutResultOrderEo.setOverChargeTime(inContext.getCurDate());
                    inOutResultOrderEo.setInOutTime(basicsReceiveBasicsReqDto.getInOutTime());
                    if (null != inOutResultOrderEo.getInOutTime()) {
                        inOutResultOrderEo.setBizDate(inOutResultOrderEo.getInOutTime());
                    }
                }
            }

            public void afterCallBack(BaseOrderBaseContext context) {
                log.info("\u5165\u5e93\u5355\u56de\u4f20afterCallBack-{}", JSON.toJSON((Object)context));
                context.setTransparentCallback(Boolean.valueOf(true));
                CsBusinessCallBackStrategyEnum callBackStrategyEnum = CsBusinessCallBackStrategyEnum.getByTableName((String)inOutNoticeOrderEo.getRelevanceTableName());
                ICsBusinessOrderCallBackService businessOrderCallBackService = CsBusinessOrderCallBackUtils.getBusinessOrderCallBackService(callBackStrategyEnum.getCode());
                CsOrderBusinessCallBackContext csOrderBusinessCallBackContext = BusinessOrderCallBackParseHelper.parseResultCallBack(context);
                if (context instanceof InOutResultOrderContext) {
                    InOutResultOrderContext inContext = (InOutResultOrderContext)context;
                    CsWmsExternalServiceImpl.this.saveInventoryBatch(inContext.getInOutResultOrderEo(), inContext.getInOutResultOrderDetailEoList());
                    log.info("\u5165\u5e93\u5355\u56de\u4f20\u540e\u7f6e\u5904\u7406\u4e8b\u4ef6isHangup-{},", (Object)inContext.isHangup(), JSON.toJSON((Object)basicsReceiveBasicsReqDto));
                    if (inContext.isHangup()) {
                        businessOrderCallBackService.updateMainOrderStatus(inOutNoticeOrderEo.getRelevanceNo(), true);
                    } else {
                        if (basicsReceiveBasicsReqDto.getEnableAdjustInTransit().booleanValue() && CsRelevanceTableNameEnum.CS_TRANSFER_ORDER.getCode().equals(inOutNoticeOrderEo.getRelevanceTableName())) {
                            CsWmsExternalServiceImpl.this.adjustInTransitHandler.handle(new IAdjustInTransitHandler.AdjustInTransitHandlerVo(inOutNoticeOrderEo, true, inContext.getInOutResultOrderDetailEoList(), inContext.getInOutResultOrderEo(), Boolean.TRUE));
                        }
                        businessOrderCallBackService.inOutResultOrderCallBack(csOrderBusinessCallBackContext);
                    }
                }
            }
        };
    }

    @Transactional(rollbackFor={Exception.class})
    public void callBackOut(CsBasicsReceiveReqDto basicsReceiveBasicsReqDto, InOutNoticeOrderEo inOutNoticeOrderEo, List<InOutNoticeOrderDetailEo> inOutNoticeOrderDetailEos) {
        log.info("\u5f00\u59cb\u751f\u6210\u51fa\u5e93\u7ed3\u679c\u5355: {}", (Object)LogUtils.buildLogContent((Object)basicsReceiveBasicsReqDto));
        CsBusinessCallBackStrategyEnum callBackStrategyEnum = CsBusinessCallBackStrategyEnum.getByTableName((String)inOutNoticeOrderEo.getRelevanceTableName());
        ICsBusinessOrderCallBackService businessOrderCallBackService = CsBusinessOrderCallBackUtils.getBusinessOrderCallBackService(callBackStrategyEnum.getCode());
        this.matchLineNo(basicsReceiveBasicsReqDto.getDetailReqDtoList(), inOutNoticeOrderDetailEos);
        if (basicsReceiveBasicsReqDto.getZeroDetailCount().booleanValue()) {
            BaseOrderCommonCancelBo orderCommonCancelBo = BaseOrderCommonCancelBo.builder().isSaleOrder(Boolean.valueOf(StringUtils.contains((CharSequence)inOutNoticeOrderEo.getRelevanceNo(), (CharSequence)"DD"))).relevanceNo(inOutNoticeOrderEo.getRelevanceNo()).businessType(inOutNoticeOrderEo.getBusinessType()).documentNo(inOutNoticeOrderEo.getPreOrderNo()).build();
            this.baseOrderFacade.deliveryNoticeOrderCancel(orderCommonCancelBo);
            businessOrderCallBackService.closeOrderStatus(inOutNoticeOrderEo.getRelevanceNo());
            return;
        }
        this.handlingVolumeWeight(basicsReceiveBasicsReqDto);
        InOutResultOrderFacadeBo inOutResultOrderFacadeBo = new InOutResultOrderFacadeBo();
        inOutResultOrderFacadeBo.setWmsOrderNo(basicsReceiveBasicsReqDto.getWmsOrderNo());
        inOutResultOrderFacadeBo.setMergeQuantity(basicsReceiveBasicsReqDto.getMergeQuantity());
        inOutResultOrderFacadeBo.setTotalCartons(basicsReceiveBasicsReqDto.getTotalCartons());
        inOutResultOrderFacadeBo.setTotalVolume(basicsReceiveBasicsReqDto.getVolume());
        inOutResultOrderFacadeBo.setTotalWeight(basicsReceiveBasicsReqDto.getWeight());
        inOutResultOrderFacadeBo.setInOutNoticeOrderEo(inOutNoticeOrderEo);
        inOutResultOrderFacadeBo.setInOutNoticeOrderDetailEos(inOutNoticeOrderDetailEos);
        inOutResultOrderFacadeBo.setShippingInfoReqDtoList(basicsReceiveBasicsReqDto.getShippingInfoReqDtoList());
        inOutResultOrderFacadeBo.setOcsConsignmentNo(basicsReceiveBasicsReqDto.getOcsConsignmentNo());
        inOutResultOrderFacadeBo.setRemark(inOutNoticeOrderEo.getRemark());
        log.info("callBackOut.inOutNoticeOrderEo={}", JSON.toJSON((Object)inOutNoticeOrderEo));
        if (CollectionUtils.isEmpty((Collection)basicsReceiveBasicsReqDto.getShippingInfoReqDtoList()) && CsPcpBusinessTypeEnum.ALLOT_SALE.getCode().equals(inOutNoticeOrderEo.getBusinessType()) && CsRelevanceTableNameEnum.CS_TRANSFER_ORDER.getCode().equals(inOutNoticeOrderEo.getRelevanceTableName())) {
            this.getShippingInfo(inOutNoticeOrderEo, inOutResultOrderFacadeBo, basicsReceiveBasicsReqDto);
        }
        if (CollectionUtils.isEmpty((Collection)basicsReceiveBasicsReqDto.getShippingInfoReqDtoList()) && CsPcpBusinessTypeEnum.maiyouBcAllotList().contains(inOutNoticeOrderEo.getBusinessType()) && CsRelevanceTableNameEnum.CS_TRANSFER_ORDER.getCode().equals(inOutNoticeOrderEo.getRelevanceTableName())) {
            ArrayList orderStatusList = Lists.newArrayList((Object[])new String[]{CsTransferOrderEnum.Status.CANCELED.getCode(), CsTransferOrderEnum.Status.AUDIT_FAILED.getCode()});
            List csTransferOrderEos = this.csTransferOrderMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CsTransferOrderEo.class).eq(CsTransferOrderEo::getTransferOrderNo, (Object)inOutNoticeOrderEo.getRelevanceNo())).notIn(CsTransferOrderEo::getOrderStatus, (Collection)orderStatusList)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
            log.info("bc\u8c03\u62e8\u5355\u7ee7\u627f\u666e\u901a\u8c03\u62e8\u5355\u4fe1\u606f={}", JSON.toJSON((Object)csTransferOrderEos));
            if (CollectionUtils.isNotEmpty((Collection)csTransferOrderEos) && StringUtils.isNotBlank((CharSequence)((CsTransferOrderEo)csTransferOrderEos.get(0)).getSaleOrderNo())) {
                this.getShippingInfo(inOutNoticeOrderEo, inOutResultOrderFacadeBo, basicsReceiveBasicsReqDto);
            }
        }
        inOutResultOrderFacadeBo.setValidNegative(Boolean.FALSE);
        JSONObject jsonObject = JSONObject.parseObject((String)inOutNoticeOrderEo.getExtension());
        jsonObject.put("mergeOrderNo", (Object)basicsReceiveBasicsReqDto.getMergeOrderNo());
        if (StringUtils.isNotBlank((CharSequence)basicsReceiveBasicsReqDto.getExtensionExternal()) && basicsReceiveBasicsReqDto.getExtensionExternal().startsWith("{")) {
            jsonObject.putAll((Map)JSONObject.parseObject((String)basicsReceiveBasicsReqDto.getExtensionExternal()));
        }
        if (ObjectUtil.isNotEmpty((Object)jsonObject)) {
            inOutResultOrderFacadeBo.setExtension(jsonObject.toJSONString());
        }
        List skuCodes = basicsReceiveBasicsReqDto.getDetailReqDtoList().stream().map(CsWmsBasicsDetailReqDto::getSkuCode).distinct().collect(Collectors.toList());
        List skuDtoList = this.itemSkuProxy.queryBySkuCodes(skuCodes);
        Map skuDtoMap = skuDtoList.stream().collect(Collectors.toMap(ItemSkuDto::getSkuCode, Function.identity()));
        ArrayList detailReqDtoList = Lists.newArrayList();
        for (CsWmsBasicsDetailReqDto csWmsBasicsDetailReqDto : basicsReceiveBasicsReqDto.getDetailReqDtoList()) {
            BaseOrderDetailReqDto detailReqDto = new BaseOrderDetailReqDto();
            ItemSkuDto itemSkuDto = (ItemSkuDto)skuDtoMap.get(csWmsBasicsDetailReqDto.getSkuCode());
            InOutNoticeOrderDetailEo noticeOrderDetailEo = inOutNoticeOrderDetailEos.stream().filter(o -> Objects.equals(o.getPreOrderItemId(), csWmsBasicsDetailReqDto.getTradeOrderItemId())).findFirst().orElse(null);
            AssertUtils.notNull((Object)csWmsBasicsDetailReqDto, (String)"\u5546\u54c1\u884c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            JSONObject noticeDetailExtensionJson = new JSONObject();
            if (ObjectUtil.isNotEmpty((Object)noticeOrderDetailEo) && JSONUtil.isJsonObj((String)noticeOrderDetailEo.getExtension())) {
                noticeDetailExtensionJson = JSONObject.parseObject((String)noticeOrderDetailEo.getExtension());
            }
            if (StringUtils.isNotBlank((CharSequence)csWmsBasicsDetailReqDto.getExtensionExternal()) && JSONUtil.isJsonObj((String)csWmsBasicsDetailReqDto.getExtensionExternal())) {
                noticeDetailExtensionJson.putAll((Map)JSONObject.parseObject((String)csWmsBasicsDetailReqDto.getExtensionExternal()));
            }
            if (ObjectUtil.isNotEmpty((Object)noticeDetailExtensionJson)) {
                detailReqDto.setExtension(noticeDetailExtensionJson.toJSONString());
            }
            if (null == itemSkuDto) {
                throw new BizException(StrUtil.format((CharSequence)"\u5546\u54c1\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728, sku code: %s", (Object[])new Object[]{csWmsBasicsDetailReqDto.getSkuCode()}));
            }
            detailReqDto.setSkuCode(csWmsBasicsDetailReqDto.getSkuCode());
            detailReqDto.setSkuName(itemSkuDto.getSkuName());
            detailReqDto.setBatch(csWmsBasicsDetailReqDto.getBatch());
            detailReqDto.setQuantity(csWmsBasicsDetailReqDto.getQuantity());
            detailReqDto.setWeight(csWmsBasicsDetailReqDto.getWeight());
            detailReqDto.setVolume(csWmsBasicsDetailReqDto.getVolume());
            detailReqDto.setExpireTime(csWmsBasicsDetailReqDto.getExpireTime());
            detailReqDto.setProduceTime(csWmsBasicsDetailReqDto.getProduceTime());
            detailReqDto.setPreOrderItemId(csWmsBasicsDetailReqDto.getTradeOrderItemId());
            detailReqDto.setLineNo(csWmsBasicsDetailReqDto.getLineNo());
            detailReqDtoList.add(detailReqDto);
        }
        inOutResultOrderFacadeBo.setOrderBasicsDetailReqDtoList((List)detailReqDtoList);
        if (StringUtils.contains((CharSequence)inOutNoticeOrderEo.getRelevanceNo(), (CharSequence)"DD")) {
            inOutResultOrderFacadeBo.setIsSaleOrder(Boolean.valueOf(true));
        }
        inOutResultOrderFacadeBo.setCallBack(this.createOutCallback(basicsReceiveBasicsReqDto, inOutNoticeOrderEo, inOutNoticeOrderDetailEos));
        inOutResultOrderFacadeBo.setCompleteCallBack(context -> {
            log.info("\u51fa\u5e93 CompleteCallBack............. {}", (Object)LogUtils.buildLogContent((Object)context));
            if (context instanceof InOutResultOrderContext) {
                log.info("\u51fa\u5e93 afterCallBack InOutResultOrderContext: {}", (Object)LogUtils.buildLogContent((Object)context));
                InOutResultOrderContext outContext = (InOutResultOrderContext)context;
                if (outContext.isHangup()) {
                    businessOrderCallBackService.updateMainOrderStatus(inOutNoticeOrderEo.getRelevanceNo(), true);
                } else {
                    log.info("\u51fa\u5e93\u56de\u4f20 \u9884\u5907\u751f\u6210\u5728\u9014\u8c03\u6574\u5355 {}....... {}", (Object)inOutNoticeOrderEo.getRelevanceTableName(), (Object)LogUtils.buildLogContent((Object)basicsReceiveBasicsReqDto));
                    if (basicsReceiveBasicsReqDto.getEnableAdjustInTransit().booleanValue() && Objects.equals(inOutNoticeOrderEo.getRelevanceTableName(), "cs_transfer_order")) {
                        this.adjustInTransitHandler.handle(new IAdjustInTransitHandler.AdjustInTransitHandlerVo(inOutNoticeOrderEo, false, outContext.getInOutResultOrderDetailEoList(), outContext.getInOutResultOrderEo(), Boolean.TRUE));
                    }
                    CsOrderBusinessCallBackContext csOrderBusinessCallBackContext = BusinessOrderCallBackParseHelper.parseResultCallBack((BaseOrderBaseContext)outContext);
                    csOrderBusinessCallBackContext.setPortionFlag(Boolean.valueOf(false));
                    csOrderBusinessCallBackContext.setInOutResultOrderEo(outContext.getInOutResultOrderEo());
                    csOrderBusinessCallBackContext.setInOutResultOrderDetailEos(outContext.getInOutResultOrderDetailEoList());
                    businessOrderCallBackService.inOutResultOrderCallBack(csOrderBusinessCallBackContext);
                    businessOrderCallBackService.deliveryReceiveResultOrderCallBack(csOrderBusinessCallBackContext);
                }
                basicsReceiveBasicsReqDto.setInOutResultOrderNo(outContext.getInOutResultOrderEo().getDocumentNo());
                this.transactionCallBackService.execute(() -> {
                    MessageVo messageVo = new MessageVo();
                    messageVo.setData((Object)JSON.toJSONString((Object)basicsReceiveBasicsReqDto));
                    this.commonsMqService.sendDelaySingleMessage("INVENTORY_BUSINESS_TOPIC", "CREATE_CONSIGNMENT_ORDER", (Object)messageVo, Long.valueOf(2L));
                });
            }
        });
        ArrayList orderStatusList = Lists.newArrayList((Object[])new String[]{CsTransferOrderEnum.Status.CANCELED.getCode(), CsTransferOrderEnum.Status.AUDIT_FAILED.getCode()});
        if (CsRelevanceTableNameEnum.CS_TRANSFER_ORDER.getCode().equals(inOutNoticeOrderEo.getRelevanceTableName())) {
            CsTransferOrderEo transferOrderEo = (CsTransferOrderEo)this.csTransferOrderMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CsTransferOrderEo.class).eq(CsTransferOrderEo::getTransferOrderNo, (Object)inOutNoticeOrderEo.getRelevanceNo())).notIn(CsTransferOrderEo::getOrderStatus, (Collection)orderStatusList)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
            AssertUtils.notNull((Object)transferOrderEo, (String)"\u8c03\u62e8\u5355[%s]\u67e5\u8be2\u4e0d\u5b58\u5728", (Object[])new Object[]{inOutNoticeOrderEo.getRelevanceNo()});
            inOutResultOrderFacadeBo.setTransferInLogicWarehouseCode(transferOrderEo.getInLogicWarehouseCode());
            if (CsPcpBusinessTypeEnum.BC_ALLOT.getCode().equals(transferOrderEo.getType()) || CsPcpBusinessTypeEnum.CC_ALLOT.getCode().equals(transferOrderEo.getType()) || CsPcpBusinessTypeEnum.ALLOT_OUT_ONLY.getCode().equals(transferOrderEo.getType()) || CsPcpBusinessTypeEnum.INTERNAL_EXPORT_DEAL.getCode().equals(transferOrderEo.getType())) {
                inOutResultOrderFacadeBo.setCanProcessTransit(Boolean.FALSE);
            }
            if (CsPcpBusinessTypeEnum.ALLOT_SALE.getCode().equals(transferOrderEo.getType())) {
                inOutResultOrderFacadeBo.setIsSaleOrder(Boolean.TRUE);
            }
            if (CsPcpBusinessTypeEnum.maiyouBcAllotList().contains(transferOrderEo.getType())) {
                inOutResultOrderFacadeBo.setIsSaleOrder(Boolean.TRUE);
            }
        }
        this.baseOrderFacade.outResultOrderGen(inOutResultOrderFacadeBo);
    }

    private void getShippingInfo(InOutNoticeOrderEo inOutNoticeOrderEo, InOutResultOrderFacadeBo inOutResultOrderFacadeBo, CsBasicsReceiveReqDto basicsReceiveBasicsReqDto) {
        ArrayList shippingInfoReqDtoList = Lists.newArrayList();
        CsWmsShippingInfoReqDto infoReqDto = new CsWmsShippingInfoReqDto();
        ArrayList orderStatusList = Lists.newArrayList((Object[])new String[]{CsTransferOrderEnum.Status.CANCELED.getCode(), CsTransferOrderEnum.Status.AUDIT_FAILED.getCode()});
        List csTransferOrderEos = this.csTransferOrderMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CsTransferOrderEo.class).eq(CsTransferOrderEo::getTransferOrderNo, (Object)inOutNoticeOrderEo.getRelevanceNo())).notIn(CsTransferOrderEo::getOrderStatus, (Collection)orderStatusList)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        AssertUtils.notEmpty((Collection)csTransferOrderEos, (String)"\u627e\u4e0d\u5230\u8c03\u62e8\u5355\u5355\u53f7");
        CsTransferOrderEo csTransferOrderEo = (CsTransferOrderEo)csTransferOrderEos.get(0);
        if (StringUtils.isNotBlank((CharSequence)csTransferOrderEo.getSecondTransferOrderNo())) {
            List inOutResultOrderEos = this.inOutResultOrderDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InOutResultOrderEo.class).eq(InOutResultOrderEo::getRelevanceNo, (Object)csTransferOrderEo.getSecondTransferOrderNo())).eq(InOutResultOrderEo::getOrderType, (Object)CsInventoryInOutEnum.OUT.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
            AssertUtils.notEmpty((Collection)inOutResultOrderEos, (String)"\u9500\u552e\u8c03\u62e8\u5355\u7684\u7ed3\u679c\u5355\u4e0d\u5b58\u5728");
            InOutResultOrderEo csOutResultOrderEo = (InOutResultOrderEo)inOutResultOrderEos.get(0);
            String shippingJson = csOutResultOrderEo.getShippingJson();
            AssertUtil.assertNotBlank(shippingJson, "\u7ed3\u679c\u5355\u7269\u6d41\u4fe1\u606f\u4e3a\u7a7a\uff0c\u6216\u8005\u4e0d\u5b58\u5728", new Object[0]);
            List shippingJsonDtoList = JSONObject.parseArray((String)shippingJson, ShippingJsonDto.class);
            ShippingJsonDto shippingJsonDto = (ShippingJsonDto)shippingJsonDtoList.get(0);
            infoReqDto.setConsignNo(shippingJsonDto.getConsignNo());
            if (CsPcpBusinessTypeEnum.maiyouAllotList().contains(csTransferOrderEo.getType())) {
                infoReqDto.setLogisticsType(StringUtils.isNotBlank((CharSequence)shippingJsonDto.getLogisticsType()) ? shippingJsonDto.getLogisticsType() : shippingJsonDto.getShippingType());
                infoReqDto.setShippingCompanyCode(shippingJsonDto.getShippingCompanyCode());
                infoReqDto.setShippingCompanyName(shippingJsonDto.getShippingCompanyName());
            } else if (StringUtils.isNotBlank((CharSequence)inOutNoticeOrderEo.getOutPhysicsWarehouseCode())) {
                infoReqDto.setLogisticsType((String)ShipmentMappingConstant.SHIPMENT_TYPE_MAP.get(inOutNoticeOrderEo.getOutPhysicsWarehouseCode()));
                infoReqDto.setShippingCompanyCode((String)ShipmentMappingConstant.MAPPING.get(inOutNoticeOrderEo.getOutPhysicsWarehouseCode()));
                infoReqDto.setShippingCompanyName((String)ShipmentMappingConstant.SHIPMENT_NAME_MAP.get(inOutNoticeOrderEo.getOutPhysicsWarehouseCode()));
            }
            infoReqDto.setShippingNo(shippingJsonDto.getShippingNo());
            infoReqDto.setWmsOrderNo(shippingJsonDto.getWmsOrderNo());
            infoReqDto.setDeliveryTime(new Date());
            shippingInfoReqDtoList.add(infoReqDto);
            inOutResultOrderFacadeBo.setShippingInfoReqDtoList((List)shippingInfoReqDtoList);
            inOutResultOrderFacadeBo.setMergeQuantity(csOutResultOrderEo.getMergeQuantity());
            inOutResultOrderFacadeBo.setTotalCartons(csOutResultOrderEo.getTotalCartons());
            inOutResultOrderFacadeBo.setTotalVolume(csOutResultOrderEo.getTotalVolume());
            inOutResultOrderFacadeBo.setTotalWeight(csOutResultOrderEo.getTotalWeight());
            basicsReceiveBasicsReqDto.setShippingInfoReqDtoList((List)shippingInfoReqDtoList);
            log.info("\u5f00\u59cb\u751f\u6210\u51fa\u5e93\u7ed3\u679c\u5355,\u7ee7\u627f\u7269\u6d41\u4fe1\u606f\u540e: {}", (Object)JSON.toJSONString((Object)inOutResultOrderFacadeBo));
        }
    }

    private BaseOrderCallBack createOutCallback(final CsBasicsReceiveReqDto basicsReceiveBasicsReqDto, final InOutNoticeOrderEo inOutNoticeOrderEo, List<InOutNoticeOrderDetailEo> inOutNoticeOrderDetailEos) {
        final Map<String, List<InOutNoticeOrderDetailEo>> noticeDetailBatchMap = inOutNoticeOrderDetailEos.stream().collect(Collectors.groupingBy(InOutNoticeOrderDetailEo::getSkuCode));
        List receiveDeliveryNoticeOrderEos = this.receiveDeliveryNoticeOrderDomain.queryByRelevanceNo(inOutNoticeOrderEo.getRelevanceNo());
        AssertUtils.notEmpty((Collection)receiveDeliveryNoticeOrderEos, (String)"\u6536\u53d1\u8d27\u901a\u77e5\u5355\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728");
        final ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo = (ReceiveDeliveryNoticeOrderEo)receiveDeliveryNoticeOrderEos.get(0);
        return new BaseOrderCallBack<BaseOrderBaseContext>(){

            public void beforeCallBack(BaseOrderBaseContext context) {
                context.setTransparentCallback(Boolean.valueOf(true));
                if (context instanceof ReceiveDeliveryResultOrderContext) {
                    ReceiveDeliveryResultOrderEo receiveDeliveryResultOrderEo = ((ReceiveDeliveryResultOrderContext)context).getReceiveDeliveryResultOrderEo();
                    receiveDeliveryResultOrderEo.setExtension(receiveDeliveryNoticeOrderEo.getExtension());
                } else if (context instanceof InOutResultOrderContext) {
                    log.info("\u51fa\u5e93\u56de\u4f20 beforeCallBack.....");
                    InOutResultOrderContext outContext = (InOutResultOrderContext)context;
                    CsBusinessCallBackStrategyEnum callBackStrategyEnum = CsBusinessCallBackStrategyEnum.getByTableName((String)inOutNoticeOrderEo.getRelevanceTableName());
                    ICsBusinessOrderCallBackService businessOrderCallBackService = CsBusinessOrderCallBackUtils.getBusinessOrderCallBackService(callBackStrategyEnum.getCode());
                    context.setSendWms(businessOrderCallBackService.sendWms(inOutNoticeOrderEo).booleanValue());
                    InOutResultOrderEo outResultOrderEo = outContext.getInOutResultOrderEo();
                    List csTransferOrderEos = CsWmsExternalServiceImpl.this.csTransferOrderMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"transfer_order_no", (Object)inOutNoticeOrderEo.getRelevanceNo())).eq((Object)"type", (Object)CsInventorySourceTypeEnum.ALLOT_SALE.getCode())).notIn((Object)"order_status", (Collection)Lists.newArrayList((Object[])new String[]{CsTransferOrderEnum.Status.AUDIT_FAILED.getCode(), CsTransferOrderEnum.Status.CANCELED.getCode(), CsTransferOrderEnum.Status.FINISH.getCode()}))).isNull((Object)"pre_order_no")).eq((Object)"dr", (Object)YesNoHelper.NO));
                    Boolean isAllotSale = CollectionUtils.isNotEmpty((Collection)csTransferOrderEos);
                    if (isAllotSale.booleanValue()) {
                        String saleOrderNo = ((CsTransferOrderEo)csTransferOrderEos.get(0)).getSaleOrderNo();
                        log.info("\u83b7\u53d6\u9500\u552e\u5355\u53f7: {}", (Object)saleOrderNo);
                        if (StringUtils.isNotBlank((CharSequence)saleOrderNo)) {
                            List receiveDeliveryNoticeOrderEos = CsWmsExternalServiceImpl.this.receiveDeliveryNoticeOrderDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ReceiveDeliveryNoticeOrderEo.class).eq(ReceiveDeliveryNoticeOrderEo::getRelevanceNo, (Object)saleOrderNo)).eq(ReceiveDeliveryNoticeOrderEo::getRelevanceTableName, (Object)CsRelevanceTableNameEnum.CS_ORDER_SALE.getCode())).eq(ReceiveDeliveryNoticeOrderEo::getOrderType, (Object)"delivery")).eq(ReceiveDeliveryNoticeOrderEo::getOrderStatus, (Object)BaseOrderStatusEnum.DNO_WAIT_DELIVERY.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
                            log.info("\u67e5\u8be2\u9500\u552e\u5355\u7684\u53d1\u8d27\u901a\u77e5\u5355\u4fe1\u606f: {}", (Object)LogUtils.buildLogContent((Collection)receiveDeliveryNoticeOrderEos));
                            if (CollectionUtils.isNotEmpty((Collection)receiveDeliveryNoticeOrderEos)) {
                                ReceiveDeliveryNoticeOrderEo ReceiveDeliveryNoticeOrderEo2 = (ReceiveDeliveryNoticeOrderEo)receiveDeliveryNoticeOrderEos.get(0);
                                log.info("\u83b7\u53d6\u9500\u552e\u5355\u53d1\u8d27\u901a\u77e5\u5355\u4e2d\u7684\u53d1\u8d27\u7269\u7406\u4ed3: {}", (Object)ReceiveDeliveryNoticeOrderEo2.getDeliveryPhysicsWarehouseCode());
                                CsResultOrderExtendDto csResultOrderExtendDto = new CsResultOrderExtendDto();
                                String consignmentNo = outResultOrderEo.getConsignmentNo();
                                log.info("\u9884\u751f\u6210\u6258\u8fd0\u5355\u53f7: {}", (Object)consignmentNo);
                                csResultOrderExtendDto.setSaleOrderConsignmentNo(consignmentNo);
                                outResultOrderEo.setExtension(JSON.toJSONString((Object)csResultOrderExtendDto));
                            }
                        }
                        basicsReceiveBasicsReqDto.setEnableAdjustInTransit(Boolean.valueOf(true));
                        basicsReceiveBasicsReqDto.setAdjustInTransitAutoAudit(Boolean.valueOf(true));
                    }
                    String overchargeReason = basicsReceiveBasicsReqDto.getHangUp() != false ? basicsReceiveBasicsReqDto.getHangUpReason() : CsWmsExternalServiceImpl.this.checkOverchargeFlag(inOutNoticeOrderEo, noticeDetailBatchMap, basicsReceiveBasicsReqDto.getDetailReqDtoList());
                    outContext.setHangup(StringUtils.isNotBlank((CharSequence)overchargeReason));
                    outResultOrderEo.setOverChargeReason(overchargeReason);
                    outResultOrderEo.setOverChargeTime(outContext.getCurDate());
                    CsWmsExternalServiceImpl.this.executeShippingInfo(outResultOrderEo, inOutNoticeOrderEo, basicsReceiveBasicsReqDto);
                    outResultOrderEo.setInOutTime(basicsReceiveBasicsReqDto.getInOutTime());
                    if (null != outResultOrderEo.getInOutTime()) {
                        outResultOrderEo.setBizDate(outResultOrderEo.getInOutTime());
                    }
                    outContext.setNoticeEnd(true);
                }
            }

            public void afterCallBack(BaseOrderBaseContext context) {
            }
        };
    }

    private void executeShippingInfo(InOutResultOrderEo outResultOrderEo, InOutNoticeOrderEo inOutNoticeOrderEo, CsBasicsReceiveReqDto basicsReceiveBasicsReqDto) {
        List shippingInfoReqDtoList = basicsReceiveBasicsReqDto.getShippingInfoReqDtoList();
        if (CollectionUtils.isNotEmpty((Collection)shippingInfoReqDtoList)) {
            String shippingJSON = JSON.toJSONString((Object)shippingInfoReqDtoList);
            outResultOrderEo.setShippingJson(shippingJSON);
            List consignNoList = shippingInfoReqDtoList.stream().map(obj -> obj.getConsignNo()).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(consignNoList)) {
                String consignNo = consignNoList.stream().collect(Collectors.joining(","));
                outResultOrderEo.setConsignmentNo(consignNo);
            }
            CsWmsShippingInfoReqDto csWmsShippingInfoReqDto = (CsWmsShippingInfoReqDto)shippingInfoReqDtoList.get(0);
            outResultOrderEo.setShippingCompanyCode(csWmsShippingInfoReqDto.getShippingCompanyCode());
            outResultOrderEo.setShippingType(StringUtils.isNotBlank((CharSequence)csWmsShippingInfoReqDto.getShippingType()) ? csWmsShippingInfoReqDto.getShippingType() : csWmsShippingInfoReqDto.getLogisticsType());
            outResultOrderEo.setShippingCompany(csWmsShippingInfoReqDto.getShippingCompanyName());
            outResultOrderEo.setShippingCode(StringUtils.isNotBlank((CharSequence)csWmsShippingInfoReqDto.getShippingNo()) ? csWmsShippingInfoReqDto.getShippingNo() : csWmsShippingInfoReqDto.getConsignNo());
            outResultOrderEo.setEstimatedTime(csWmsShippingInfoReqDto.getEstimatedTime());
        }
        if (StringUtils.isNotBlank((CharSequence)basicsReceiveBasicsReqDto.getConsignmentNo())) {
            outResultOrderEo.setConsignmentNo(basicsReceiveBasicsReqDto.getConsignmentNo());
            outResultOrderEo.setShippingCompanyCode(basicsReceiveBasicsReqDto.getShippingCompanyCode());
            outResultOrderEo.setShippingCompany(basicsReceiveBasicsReqDto.getShippingCompany());
        } else if (StringUtils.isBlank((CharSequence)outResultOrderEo.getShippingCode())) {
            outResultOrderEo.setShippingCompanyCode(basicsReceiveBasicsReqDto.getShippingCompanyCode());
            outResultOrderEo.setShippingCompany(basicsReceiveBasicsReqDto.getShippingCompany());
            List csTransferOrderEos = this.csTransferOrderMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"transfer_order_no", (Object)outResultOrderEo.getRelevanceNo())).eq((Object)"dr", (Object)YesNoHelper.NO));
            if (CollectionUtils.isNotEmpty((Collection)csTransferOrderEos)) {
                if (csTransferOrderEos.size() == 1 && StringUtils.equals((CharSequence)((CsTransferOrderEo)csTransferOrderEos.get(0)).getType(), (CharSequence)CsInventorySourceTypeEnum.ALLOT_SALE.getCode())) {
                    log.info("consignmentNo \u5f00\u59cb\u5224\u5b9a \u4e8c\u6b21\u9500\u552e\u8c03\u62e8.........");
                    CsTransferOrderEo csTransferOrderEo = (CsTransferOrderEo)csTransferOrderEos.get(0);
                    List saleTransferOrderEos = this.csTransferOrderMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"sale_order_no", (Object)csTransferOrderEo.getSaleOrderNo())).in((Object)"order_status", (Collection)Lists.newArrayList((Object[])new String[]{CsTransferOrderEnum.Status.WAIT_AUDIT.getCode(), CsTransferOrderEnum.Status.WAIT_DELIVERY.getCode(), CsTransferOrderEnum.Status.FINISH.getCode()}))).eq((Object)"dr", (Object)YesNoHelper.NO));
                    log.info("consignmentNo \u9500\u552e\u5355\u5173\u8054\u9500\u552e\u8c03\u62e8\u5355\u4fe1\u606f: {}", (Object)LogUtils.buildLogContent((Collection)saleTransferOrderEos));
                    if (CollectionUtils.isNotEmpty((Collection)saleTransferOrderEos) && saleTransferOrderEos.size() > 1) {
                        CsTransferOrderEo saleTransferOrderEo = saleTransferOrderEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getOrderStatus(), (CharSequence)CsTransferOrderEnum.Status.FINISH.getCode())).findFirst().orElse(null);
                        List saleTransferOutResultOrderEos = this.inOutResultOrderDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InOutResultOrderEo.class).eq(InOutResultOrderEo::getRelevanceNo, (Object)saleTransferOrderEo.getTransferOrderNo())).eq(InOutResultOrderEo::getOrderType, (Object)"out")).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
                        log.info("\u67e5\u8be2\u9500\u552e\u5355\u5173\u8054\u9500\u552e\u8c03\u62e8\u5355 \u51fa\u5e93\u7ed3\u679c\u5355: {}", (Object)LogUtils.buildLogContent((Collection)saleTransferOutResultOrderEos));
                        if (CollectionUtils.isNotEmpty((Collection)saleTransferOutResultOrderEos)) {
                            outResultOrderEo.setConsignmentNo(((InOutResultOrderEo)saleTransferOutResultOrderEos.get(0)).getConsignmentNo());
                        }
                    } else {
                        String consignmentNo = this.csOutNoticeOrderService.getConsignmentNoByPhysicsWarehouse(inOutNoticeOrderEo.getOutPhysicsWarehouseCode());
                        outResultOrderEo.setConsignmentNo(consignmentNo);
                    }
                }
            } else {
                String consignmentNo = this.csOutNoticeOrderService.getConsignmentNoByPhysicsWarehouse(inOutNoticeOrderEo.getOutPhysicsWarehouseCode());
                outResultOrderEo.setConsignmentNo(consignmentNo);
            }
        }
        if (CollectionUtils.isEmpty((Collection)shippingInfoReqDtoList)) {
            shippingInfoReqDtoList = Lists.newArrayList();
            CsWmsShippingInfoReqDto shippingInfoReqDto = new CsWmsShippingInfoReqDto();
            shippingInfoReqDto.setConsignNo(outResultOrderEo.getConsignmentNo());
            shippingInfoReqDto.setShippingNo(outResultOrderEo.getConsignmentNo());
            shippingInfoReqDto.setWmsOrderNo("");
            shippingInfoReqDto.setDeliveryTime(new Date());
            shippingInfoReqDto.setLogisticsType("");
            shippingInfoReqDto.setShippingCompanyCode("");
            shippingInfoReqDto.setShippingCompanyName("");
            shippingInfoReqDtoList.add(shippingInfoReqDto);
            outResultOrderEo.setShippingJson(JSON.toJSONString((Object)shippingInfoReqDtoList));
        }
        DictDto dictDto = this.pcpDictApiProxy.queryByGroupCodeAndCode("COMMON_CONFIG", "CONSIGNMENT_EXCHANGE_CARRIER");
        List exchangeCarrierDtoList = Lists.newArrayList();
        if (null != dictDto && StringUtils.isNotBlank((CharSequence)dictDto.getValue())) {
            log.info("\u8bfb\u53d6 \u8f6c\u6362\u7269\u6d41\u5546\u914d\u7f6e: {}", (Object)dictDto.getValue());
            exchangeCarrierDtoList = JSONArray.parseArray((String)dictDto.getValue(), ExchangeCarrierDto.class);
        }
        if (CollectionUtils.isNotEmpty((Collection)exchangeCarrierDtoList)) {
            for (ExchangeCarrierDto carrierDto : exchangeCarrierDtoList) {
                if (!StringUtils.equals((CharSequence)carrierDto.getCarrierCode(), (CharSequence)outResultOrderEo.getShippingCompanyCode()) || !StringUtils.equals((CharSequence)carrierDto.getCarrierType(), (CharSequence)outResultOrderEo.getShippingType())) continue;
                outResultOrderEo.setShippingCompanyCode(carrierDto.getExChangeCarrierCode());
                outResultOrderEo.setShippingCompany(carrierDto.getExChangeCarrierName());
                List shippingJsonDtoList = JSONArray.parseArray((String)outResultOrderEo.getShippingJson(), ShippingJsonDto.class);
                if (!CollectionUtils.isNotEmpty((Collection)shippingJsonDtoList)) continue;
                log.info("\u5f00\u59cb shippingJsonDto \u4fee\u6539");
                for (ShippingJsonDto shippingInfoReqDto : shippingJsonDtoList) {
                    shippingInfoReqDto.setShippingCompanyCode(carrierDto.getExChangeCarrierCode());
                    shippingInfoReqDto.setShippingCompanyName(carrierDto.getExChangeCarrierName());
                }
                outResultOrderEo.setShippingJson(JSON.toJSONString((Object)shippingJsonDtoList));
            }
        }
    }

    private void calculateExpireTime(CsBasicsReceiveReqDto basicsReceiveBasicsReqDto) {
        List detailReqDtoList = basicsReceiveBasicsReqDto.getDetailReqDtoList();
        List longCodeList = detailReqDtoList.stream().map(CsWmsBasicsDetailReqDto::getSkuCode).distinct().collect(Collectors.toList());
        List csItemEoList = this.itemSkuProxy.queryBySkuCodes(longCodeList);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)csItemEoList), "\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728");
        Map itemEoMap = csItemEoList.stream().collect(Collectors.toMap(eo -> eo.getSkuCode(), Function.identity()));
        for (CsWmsBasicsDetailReqDto detailReqDto : detailReqDtoList) {
            String skuCode = detailReqDto.getSkuCode();
            Date produceTime = detailReqDto.getProduceTime();
            AssertUtil.isTrue(null != produceTime, "\u751f\u4ea7\u65e5\u671f\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            if (null != detailReqDto.getExpireTime()) continue;
            String produceTimeStr = DateUtils.formatDate(produceTime, "yyyy-MM-dd");
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)produceTimeStr), "\u751f\u4ea7\u65e5\u671f\u53c2\u6570\u683c\u5f0f\u6709\u8bef");
            ItemSkuDto csItemEo = (ItemSkuDto)itemEoMap.get(skuCode);
            AssertUtil.isTrue(null != csItemEo, "\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728");
            String expirationDate = "360";
            Integer expirationDateInt = Integer.parseInt(expirationDate);
            Date date = DateUtils.addMonth(produceTime, expirationDateInt);
            Date expireTime = DateUtils.beforeDay(date, 1);
            detailReqDto.setExpireTime(expireTime);
        }
    }

    @Override
    public Boolean receiveOut(CsBasicsReceiveReqDto basicsReceiveBasicsReqDto) {
        super.checkParams(basicsReceiveBasicsReqDto);
        String inOutNoticeOrderNo = basicsReceiveBasicsReqDto.getInOutNoticeOrderNo();
        QueryWrapper inOutNoticeOrderEoQueryWrapper = new QueryWrapper();
        inOutNoticeOrderEoQueryWrapper.eq((Object)"document_no", (Object)inOutNoticeOrderNo);
        inOutNoticeOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        inOutNoticeOrderEoQueryWrapper.eq((Object)"order_type", (Object)"out");
        inOutNoticeOrderEoQueryWrapper.in((Object)"order_status", (Collection)Lists.newArrayList((Object[])new String[]{BaseOrderStatusEnum.ONO_WAIT_OUT.getCode(), BaseOrderStatusEnum.ONO_PORTION_OUT.getCode()}));
        List inOutNoticeOrderEos = this.inOutNoticeOrderDomain.getMapper().selectList((Wrapper)inOutNoticeOrderEoQueryWrapper);
        AssertUtils.notEmpty((Collection)inOutNoticeOrderEos, (String)"\u67e5\u8be2\u4e0d\u5230\u51fa\u5165\u5e93\u5355\u636e\u4fe1\u606f");
        InOutNoticeOrderEo inOutNoticeOrderEo = (InOutNoticeOrderEo)inOutNoticeOrderEos.get(0);
        List inOutNoticeOrderDetailEos = this.inOutNoticeOrderDetailDomain.queryByDocumentNo(inOutNoticeOrderEo.getDocumentNo());
        ((CsWmsExternalServiceImpl)SpringBeanUtil.getBean(CsWmsExternalServiceImpl.class)).callBackOut(basicsReceiveBasicsReqDto, inOutNoticeOrderEo, inOutNoticeOrderDetailEos);
        return true;
    }

    private List<InOutResultOrderDetailEo> createResultOrderDetailListByTransferOrder(InOutResultOrderEo transferResultOrderEo, InOutResultOrderEo csInResultOrderEo) {
        ArrayList csInResultOrderDetailEoList = Lists.newArrayList();
        List transferResultOrderDetailList = this.inOutResultOrderDetailDomain.getMapper().selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"document_no", (Object)transferResultOrderEo.getDocumentNo())).eq((Object)"dr", (Object)YesNoHelper.NO));
        AssertUtil.assertNotEmpty(transferResultOrderDetailList, "\u9500\u552e\u8c03\u62e8\u5355\u5bf9\u5e94\u7ed3\u679c\u5355\u660e\u7ec6\u67e5\u8be2\u4e0d\u5230", new Object[0]);
        for (InOutResultOrderDetailEo transferResultOrderDetail : transferResultOrderDetailList) {
            InOutResultOrderDetailEo detailEo = new InOutResultOrderDetailEo();
            BeanUtils.copyProperties((Object)transferResultOrderDetail, (Object)detailEo);
            detailEo.setId(null);
            detailEo.setDocumentNo(csInResultOrderEo.getDocumentNo());
            detailEo.setRelevanceNo(csInResultOrderEo.getRelevanceNo());
            detailEo.setPreOrderNo(csInResultOrderEo.getPreOrderNo());
            detailEo.setExternalOrderNo(csInResultOrderEo.getExternalOrderNo());
            detailEo.setWmsOrderNo(csInResultOrderEo.getWmsOrderNo());
            csInResultOrderDetailEoList.add(detailEo);
        }
        return csInResultOrderDetailEoList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean cancel(CsBasicsCancelReqDto csBasicsCancelReqDto) {
        log.info("cancel==>WMS\u53d1\u8d77\u53d6\u6d88\u64cd\u4f5c,csBasicsCancelReqDto:{}", (Object)LogUtils.buildLogContent((Object)csBasicsCancelReqDto));
        this.checkParams(csBasicsCancelReqDto);
        String noticeOrderNo = csBasicsCancelReqDto.getNoticeOrderNo();
        QueryWrapper inOutNoticeOrderEoQueryWrapper = new QueryWrapper();
        inOutNoticeOrderEoQueryWrapper.eq((Object)"document_no", (Object)noticeOrderNo);
        inOutNoticeOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        InOutNoticeOrderEo inOutNoticeOrderEo = (InOutNoticeOrderEo)this.inOutNoticeOrderDomain.getMapper().selectOne((Wrapper)inOutNoticeOrderEoQueryWrapper);
        AssertUtil.isTrue(null != inOutNoticeOrderEo, "\u67e5\u8be2\u4e0d\u5230\u51fa\u5165\u5e93\u901a\u77e5\u5355\u4fe1\u606f");
        ArrayList cancelStatusList = Lists.newArrayList((Object[])new String[]{BaseOrderStatusEnum.ONO_CANCEL.getCode(), BaseOrderStatusEnum.DNO_CANCEL.getCode(), BaseOrderStatusEnum.INO_CANCEL.getCode()});
        if (cancelStatusList.contains(inOutNoticeOrderEo.getOrderStatus())) {
            throw new BizException("\u5df2\u53d6\u6d88\u72b6\u6001\u4e0d\u5141\u8bb8\u91cd\u590d\u64cd\u4f5c\u53d6\u6d88");
        }
        String businessType = inOutNoticeOrderEo.getBusinessType();
        String sourceType = CsPcpBusinessTypeEnum.ORDER_SALES_OUT.getCode().equals(businessType) ? CsInventorySourceTypeEnum.IN_SALE_RELEASE.getCode() : (CsPcpBusinessTypeEnum.PURCHASE_REFUND.getCode().equals(businessType) ? CsInventorySourceTypeEnum.PURCHASE_RETREAT_PREEMPT_RELEASE.getCode() : (CsPcpBusinessTypeEnum.OUTSOURCE_REFUND.getCode().equals(businessType) ? CsInventorySourceTypeEnum.OUTSOURCE_RETREAT_PREEMPT_RELEASE.getCode() : (CsPcpBusinessTypeEnum.ALLOT_OUT.getCode().equals(businessType) ? CsInventorySourceTypeEnum.TRANSFER_OTHER_RELEASE.getCode() : (CsPcpBusinessTypeEnum.MAIYOU_ALLOT_OUT.getCode().equals(businessType) ? CsInventorySourceTypeEnum.TRANSFER_OTHER_RELEASE.getCode() : (CsPcpBusinessTypeEnum.cAllotList().contains(businessType) ? CsInventorySourceTypeEnum.TRANSFER_OTHER_RELEASE.getCode() : CsInventorySourceTypeEnum.OUT_OTHER_RELEASE.getCode())))));
        List inOutResultOrderEos = this.inOutResultOrderDomain.queryByRelevanceNo(inOutNoticeOrderEo.getRelevanceNo());
        if (CollectionUtils.isNotEmpty((Collection)inOutResultOrderEos)) {
            for (InOutResultOrderEo InOutResultOrderEo2 : inOutResultOrderEos) {
                AssertUtil.isTrue(!BaseOrderStatusEnum.ORO_HANG_UP.getCode().equals(InOutResultOrderEo2.getOrderStatus()) && !BaseOrderStatusEnum.IRO_HANG_UP.getCode().equals(InOutResultOrderEo2.getOrderStatus()), "\u6302\u8d77\u72b6\u6001\u4e0d\u5141\u8bb8\u53d6\u6d88");
            }
        }
        CsOrderBusinessCallBackContext callBackContext = new CsOrderBusinessCallBackContext();
        String orderType = inOutNoticeOrderEo.getOrderType();
        Boolean isSaleOrder = StringUtils.contains((CharSequence)inOutNoticeOrderEo.getRelevanceNo(), (CharSequence)"DD");
        if (CsPcpBusinessTypeEnum.ALLOT_SALE.getCode().equals(inOutNoticeOrderEo.getBusinessType())) {
            isSaleOrder = Boolean.TRUE;
        }
        if (CsPcpBusinessTypeEnum.maiyouBcAllotList().contains(inOutNoticeOrderEo.getBusinessType())) {
            isSaleOrder = Boolean.TRUE;
        }
        if ("in".equals(orderType)) {
            callBackContext.setInFlag(Boolean.valueOf(true));
            this.baseOrderFacade.receiveNoticeOrderCancel(BaseOrderCommonCancelBo.builder().documentNo(inOutNoticeOrderEo.getPreOrderNo()).sourceType(sourceType).businessType(businessType).cancelReason(csBasicsCancelReqDto.getRemark()).isSaleOrder(isSaleOrder).build());
        } else {
            callBackContext.setInFlag(Boolean.valueOf(false));
            this.baseOrderFacade.deliveryNoticeOrderCancel(BaseOrderCommonCancelBo.builder().documentNo(inOutNoticeOrderEo.getPreOrderNo()).sourceType(sourceType).businessType(businessType).cancelReason(csBasicsCancelReqDto.getRemark()).isSaleOrder(isSaleOrder).build());
        }
        String relevanceTableName = inOutNoticeOrderEo.getRelevanceTableName();
        CsBusinessCallBackStrategyEnum callBackStrategyEnum = CsBusinessCallBackStrategyEnum.getByTableName((String)relevanceTableName);
        ICsBusinessOrderCallBackService businessOrderCallBackService = CsBusinessOrderCallBackUtils.getBusinessOrderCallBackService(callBackStrategyEnum.getCode());
        callBackContext.setRelevanceNo(inOutNoticeOrderEo.getRelevanceNo());
        callBackContext.setDocumentNo(csBasicsCancelReqDto.getNoticeOrderNo());
        callBackContext.setRemark(csBasicsCancelReqDto.getRemark());
        callBackContext.setOnlyNodeCancel(csBasicsCancelReqDto.getOnlyNodeCancel());
        businessOrderCallBackService.wmsCancel(callBackContext);
        if (csBasicsCancelReqDto.getOnlyNodeCancel().booleanValue()) {
            return true;
        }
        this.transactionCallBackService.execute(() -> {
            csBasicsCancelReqDto.setPlatformOrderNo(inOutNoticeOrderEo.getExternalOrderNo());
            csBasicsCancelReqDto.setBusinessType(inOutNoticeOrderEo.getBusinessType());
            csBasicsCancelReqDto.setOrderType(inOutNoticeOrderEo.getOrderType());
            csBasicsCancelReqDto.setRelevanceTableName(inOutNoticeOrderEo.getRelevanceTableName());
            MessageVo messageVo = new MessageVo();
            messageVo.setData((Object)JSON.toJSONString((Object)csBasicsCancelReqDto));
            this.mqService.wmsCancelCompleteProcessor(messageVo);
        });
        return true;
    }

    private void outCancel(InOutNoticeOrderEo InOutNoticeOrderEo2, CsBasicsCancelReqDto csBasicsCancelReqDto) {
        log.info("inCancel==>\u51fa\u5e93\u7684\u53d6\u6d88,InOutNoticeOrderEo:{},csBasicsCancelReqDto:{}", (Object)LogUtils.buildLogContent((Object)InOutNoticeOrderEo2), (Object)LogUtils.buildLogContent((Object)csBasicsCancelReqDto));
        InOutNoticeOrderEo2.setOrderStatus(BaseOrderStatusEnum.ONO_CANCEL.getCode());
        QueryWrapper InOutNoticeOrderEoQueryWrapper = new QueryWrapper();
        InOutNoticeOrderEoQueryWrapper.eq((Object)"document_no", (Object)InOutNoticeOrderEo2.getDocumentNo());
        this.inOutNoticeOrderDomain.getMapper().update((Object)InOutNoticeOrderEo2, (Wrapper)InOutNoticeOrderEoQueryWrapper);
        QueryWrapper ReceiveDeliveryNoticeOrderEoQueryWrapper = new QueryWrapper();
        ReceiveDeliveryNoticeOrderEoQueryWrapper.eq((Object)"document_no", (Object)InOutNoticeOrderEo2.getPreOrderNo());
        ReceiveDeliveryNoticeOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        ReceiveDeliveryNoticeOrderEoQueryWrapper.eq((Object)"order_type", (Object)"delivery");
        ReceiveDeliveryNoticeOrderEo ReceiveDeliveryNoticeOrderEo2 = (ReceiveDeliveryNoticeOrderEo)this.receiveDeliveryNoticeOrderDomain.getMapper().selectOne((Wrapper)ReceiveDeliveryNoticeOrderEoQueryWrapper);
        AssertUtil.isTrue(null != ReceiveDeliveryNoticeOrderEo2, "\u67e5\u8be2\u4e0d\u5230\u53d1\u8d27\u5e93\u901a\u77e5\u5355\u4fe1\u606f");
        ReceiveDeliveryNoticeOrderEoQueryWrapper.clear();
        ReceiveDeliveryNoticeOrderEoQueryWrapper.eq((Object)"document_no", (Object)ReceiveDeliveryNoticeOrderEo2.getDocumentNo());
        ReceiveDeliveryNoticeOrderEo2.setOrderStatus(BaseOrderStatusEnum.DNO_CANCEL.getCode());
        ReceiveDeliveryNoticeOrderEo2.setRemark(csBasicsCancelReqDto.getRemark());
        this.receiveDeliveryNoticeOrderDomain.getMapper().update((Object)ReceiveDeliveryNoticeOrderEo2, (Wrapper)ReceiveDeliveryNoticeOrderEoQueryWrapper);
    }

    private void inCancel(InOutNoticeOrderEo InOutNoticeOrderEo2, CsBasicsCancelReqDto csBasicsCancelReqDto) {
        log.info("inCancel==>\u5165\u5e93\u7684\u53d6\u6d88,InOutNoticeOrderEo:{},csBasicsCancelReqDto:{}", (Object)LogUtils.buildLogContent((Object)InOutNoticeOrderEo2), (Object)LogUtils.buildLogContent((Object)csBasicsCancelReqDto));
        InOutNoticeOrderEo2.setOrderStatus(BaseOrderStatusEnum.INO_CANCEL.getCode());
        QueryWrapper InOutNoticeOrderEoQueryWrapper = new QueryWrapper();
        InOutNoticeOrderEoQueryWrapper.eq((Object)"document_no", (Object)InOutNoticeOrderEo2.getDocumentNo());
        this.inOutNoticeOrderDomain.getMapper().update((Object)InOutNoticeOrderEo2, (Wrapper)InOutNoticeOrderEoQueryWrapper);
        QueryWrapper ReceiveDeliveryNoticeOrderEoQueryWrapper = new QueryWrapper();
        ReceiveDeliveryNoticeOrderEoQueryWrapper.eq((Object)"document_no", (Object)InOutNoticeOrderEo2.getPreOrderNo());
        ReceiveDeliveryNoticeOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        ReceiveDeliveryNoticeOrderEoQueryWrapper.eq((Object)"order_type", (Object)"receive");
        ReceiveDeliveryNoticeOrderEo ReceiveDeliveryNoticeOrderEo2 = (ReceiveDeliveryNoticeOrderEo)this.receiveDeliveryNoticeOrderDomain.getMapper().selectOne((Wrapper)ReceiveDeliveryNoticeOrderEoQueryWrapper);
        AssertUtil.isTrue(null != ReceiveDeliveryNoticeOrderEo2, "\u67e5\u8be2\u4e0d\u5230\u6536\u8d27\u5e93\u901a\u77e5\u5355\u4fe1\u606f");
        ReceiveDeliveryNoticeOrderEoQueryWrapper.clear();
        ReceiveDeliveryNoticeOrderEoQueryWrapper.eq((Object)"document_no", (Object)ReceiveDeliveryNoticeOrderEo2.getDocumentNo());
        ReceiveDeliveryNoticeOrderEo2.setOrderStatus(BaseOrderStatusEnum.RNO_CANCEL.getCode());
        ReceiveDeliveryNoticeOrderEo2.setRemark(csBasicsCancelReqDto.getRemark());
        this.receiveDeliveryNoticeOrderDomain.getMapper().update((Object)ReceiveDeliveryNoticeOrderEo2, (Wrapper)ReceiveDeliveryNoticeOrderEoQueryWrapper);
    }

    private void checkParams(CsBasicsCancelReqDto csBasicsCancelReqDto) {
        AssertUtil.isTrue(null != csBasicsCancelReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String noticeOrderNo = csBasicsCancelReqDto.getNoticeOrderNo();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)noticeOrderNo), "\u51fa\u5165\u5e93\u901a\u77e5\u5355\u5355\u53f7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createConsignmentOrder(CsBasicsReceiveReqDto basicsReceiveBasicsReqDto) {
        log.info("createConsignmentOrder.basicsReceiveBasicsReqDto\u5165\u53c2\u65e5\u5fd7={}", JSON.toJSON((Object)basicsReceiveBasicsReqDto));
        AssertUtils.notBlank((String)basicsReceiveBasicsReqDto.getInOutResultOrderNo(), (String)"\u51fa\u5e93\u7ed3\u679c\u5355\u5355\u53f7\u4e0d\u5b58\u5728");
        List inOutResultOrderEos = this.inOutResultOrderDomain.queryByDocumentNo(basicsReceiveBasicsReqDto.getInOutResultOrderNo());
        AssertUtils.notEmpty((Collection)inOutResultOrderEos, (String)"\u7ed3\u679c\u5355\u5355\u53f7\u67e5\u8be2\u4e0d\u5b58\u5728");
        InOutResultOrderEo csOutResultOrderEo = (InOutResultOrderEo)inOutResultOrderEos.get(0);
        List outResultOrderDetailEos = this.inOutResultOrderDetailDomain.queryByDocumentNo(csOutResultOrderEo.getDocumentNo());
        AssertUtils.notEmpty((Collection)outResultOrderDetailEos, (String)"\u51fa\u5e93\u7ed3\u679c\u5355\u660e\u7ec6\u67e5\u8be2\u4e0d\u5b58\u5728");
        List csDeliveryNoticeOrderEos = this.receiveDeliveryNoticeOrderDomain.queryByRelevanceNo(csOutResultOrderEo.getRelevanceNo());
        AssertUtils.notEmpty((Collection)csDeliveryNoticeOrderEos, (String)"\u53d1\u8d27\u901a\u77e5\u5355\u67e5\u8be2\u4e0d\u5b58\u5728");
        ReceiveDeliveryNoticeOrderEo csDeliveryNoticeOrderEo = (ReceiveDeliveryNoticeOrderEo)csDeliveryNoticeOrderEos.get(0);
        List shippingInfoReqDtoList = basicsReceiveBasicsReqDto.getShippingInfoReqDtoList();
        if (CollectionUtils.isEmpty((Collection)shippingInfoReqDtoList)) {
            log.info("\u7269\u6d41\u4fe1\u606f\u56de\u4f20\u4e0d\u5b58\u5728");
            return;
        }
        String wmsConsignmentNo = ((CsWmsShippingInfoReqDto)shippingInfoReqDtoList.get(0)).getConsignNo();
        if (StringUtils.isBlank((CharSequence)wmsConsignmentNo)) {
            log.info("\u7269\u6d41\u4fe1\u606f\u56de\u4f20\uff0c\u7269\u6d41\u5355\u53f7\u4e0d\u5b58\u5728");
            return;
        }
        String physicsWarehouseCode = csDeliveryNoticeOrderEo.getDeliveryPhysicsWarehouseCode();
        AssertUtil.assertNotBlank(physicsWarehouseCode, "\u53d1\u8d27\u7269\u7406\u4ed3\u7f16\u7801\u4e0d\u5b58\u5728", new Object[0]);
        PhysicsWarehouseEo physicsWarehouseEo = (PhysicsWarehouseEo)this.physicsWarehouseDomain.getMapper().selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(PhysicsWarehouseEo.class).eq(PhysicsWarehouseEo::getWarehouseCode, (Object)physicsWarehouseCode)).eq(PhysicsWarehouseEo::getWarehouseStatus, (Object)CsValidFlagEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        AssertUtil.assertNotNull(physicsWarehouseEo, "\u7269\u7406\u4ed3\u7f16\u7801:[%s]\u67e5\u8be2\u4e0d\u5b58\u5728", physicsWarehouseCode);
        WarehouseAddressEo csWarehouseAddressEo = (WarehouseAddressEo)this.warehouseAddressDomain.getMapper().selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(WarehouseAddressEo.class).eq(WarehouseAddressEo::getWarehouseCode, (Object)physicsWarehouseCode)).eq(WarehouseAddressEo::getValidFlag, (Object)CsValidFlagEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        AssertUtil.assertNotNull(csWarehouseAddressEo, "\u7269\u7406\u4ed3\u7f16\u7801:[%s]\u67e5\u8be2\u5730\u5740\u4e0d\u5b58\u5728", physicsWarehouseCode);
        String logicWarehouseCode = csDeliveryNoticeOrderEo.getDeliveryLogicWarehouseCode();
        AssertUtil.assertNotBlank(logicWarehouseCode, "\u53d1\u8d27\u903b\u8f91\u4ed3\u7f16\u7801\u4e0d\u5b58\u5728", new Object[0]);
        LogicWarehouseEo logicWarehouseEo = (LogicWarehouseEo)this.logicWarehouseDomain.getMapper().selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(LogicWarehouseEo.class).eq(LogicWarehouseEo::getWarehouseCode, (Object)logicWarehouseCode)).eq(LogicWarehouseEo::getWarehouseStatus, (Object)CsValidFlagEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        AssertUtil.assertNotNull(logicWarehouseEo, "\u903b\u8f91\u4ed3\u7f16\u7801:[%s]\u67e5\u8be2\u4e0d\u5b58\u5728", logicWarehouseCode);
        ConsignmentOrderEo consignmentOrderEo = new ConsignmentOrderEo();
        String consignmentNo = this.codeGenerateUtil.generateNo("TS", 6);
        consignmentOrderEo.setConsignmentNo(consignmentNo);
        consignmentOrderEo.setConsignmentType(Integer.valueOf(1));
        consignmentOrderEo.setWmsConsignmentNo(wmsConsignmentNo);
        consignmentOrderEo.setOriginConsignmentNo(consignmentNo);
        consignmentOrderEo.setOriginWmsConsignmentNo(wmsConsignmentNo);
        consignmentOrderEo.setSecondaryConsignmentNo(wmsConsignmentNo);
        consignmentOrderEo.setOutNoticeNo(csOutResultOrderEo.getPreOrderNo());
        consignmentOrderEo.setOutResultNo(csOutResultOrderEo.getDocumentNo());
        consignmentOrderEo.setBusinessNo(csOutResultOrderEo.getRelevanceNo());
        consignmentOrderEo.setBusinessType(csOutResultOrderEo.getBusinessType());
        consignmentOrderEo.setExternalOrderNo(csOutResultOrderEo.getExternalOrderNo());
        consignmentOrderEo.setMergeOrderNo(basicsReceiveBasicsReqDto.getMergeOrderNo());
        consignmentOrderEo.setOrderStatus(Integer.valueOf(1));
        consignmentOrderEo.setTransferConsignmentNo("");
        consignmentOrderEo.setTransferWmsConsignmentNo("");
        consignmentOrderEo.setParentConsignmentNo("");
        consignmentOrderEo.setParentWmsConsignmentNo("");
        consignmentOrderEo.setPhysicsWarehouseCode(physicsWarehouseCode);
        consignmentOrderEo.setPhysicsWarehouseName(physicsWarehouseEo.getWarehouseName());
        this.consignmentOrderDas.insert((BaseEo)consignmentOrderEo);
        ConsignmentOrderAddressEo deliveryAddressEo = new ConsignmentOrderAddressEo();
        deliveryAddressEo.setConsignmentNo(consignmentNo);
        deliveryAddressEo.setWmsConsignmentNo(wmsConsignmentNo);
        deliveryAddressEo.setOutNoticeNo(csOutResultOrderEo.getPreOrderNo());
        deliveryAddressEo.setOutResultNo(csOutResultOrderEo.getDocumentNo());
        deliveryAddressEo.setBusinessNo(csOutResultOrderEo.getRelevanceNo());
        deliveryAddressEo.setExternalOrderNo(csOutResultOrderEo.getExternalOrderNo());
        deliveryAddressEo.setMergeOrderNo(consignmentOrderEo.getMergeOrderNo());
        deliveryAddressEo.setAddressType("delivery");
        deliveryAddressEo.setPhysicsWarehouseCode(physicsWarehouseCode);
        deliveryAddressEo.setPhysicsWarehouseName(physicsWarehouseEo.getWarehouseName());
        deliveryAddressEo.setLogicWarehouseCode(logicWarehouseCode);
        deliveryAddressEo.setLogicWarehouseName(logicWarehouseEo.getWarehouseName());
        deliveryAddressEo.setPerson(csWarehouseAddressEo.getContacts());
        deliveryAddressEo.setPhone(csWarehouseAddressEo.getPhone());
        deliveryAddressEo.setOrganizationId(logicWarehouseEo.getOrganizationId());
        deliveryAddressEo.setOrganizationCode(logicWarehouseEo.getOrganizationCode());
        deliveryAddressEo.setOrganizationName(logicWarehouseEo.getOrganizationName());
        deliveryAddressEo.setProvinceCode(csWarehouseAddressEo.getProvinceCode());
        deliveryAddressEo.setProvinceName(csWarehouseAddressEo.getProvince());
        deliveryAddressEo.setCityCode(csWarehouseAddressEo.getCityCode());
        deliveryAddressEo.setCityName(csWarehouseAddressEo.getCity());
        deliveryAddressEo.setDistrictCode(csWarehouseAddressEo.getDistrictCode());
        deliveryAddressEo.setDistrictName(csWarehouseAddressEo.getDistrict());
        deliveryAddressEo.setDetailAddress(csWarehouseAddressEo.getDetailAddress());
        this.consignmentOrderAddressDas.insert((BaseEo)deliveryAddressEo);
        String extendJsonStr = csDeliveryNoticeOrderEo.getExtension();
        ContactDto contactDto = (ContactDto)JSON.parseObject((String)extendJsonStr, ContactDto.class);
        ConsignmentOrderAddressEo receiveAddressEo = new ConsignmentOrderAddressEo();
        receiveAddressEo.setConsignmentNo(consignmentNo);
        receiveAddressEo.setWmsConsignmentNo(wmsConsignmentNo);
        receiveAddressEo.setOutNoticeNo(csOutResultOrderEo.getPreOrderNo());
        receiveAddressEo.setOutResultNo(csOutResultOrderEo.getDocumentNo());
        receiveAddressEo.setBusinessNo(csOutResultOrderEo.getRelevanceNo());
        receiveAddressEo.setExternalOrderNo(csOutResultOrderEo.getExternalOrderNo());
        receiveAddressEo.setMergeOrderNo(consignmentOrderEo.getMergeOrderNo());
        receiveAddressEo.setAddressType("receive");
        receiveAddressEo.setPhysicsWarehouseCode("");
        receiveAddressEo.setPhysicsWarehouseName("");
        receiveAddressEo.setLogicWarehouseCode("");
        receiveAddressEo.setLogicWarehouseName("");
        receiveAddressEo.setOrganizationId(null);
        receiveAddressEo.setOrganizationCode("");
        receiveAddressEo.setOrganizationName("");
        if (null != contactDto) {
            receiveAddressEo.setPerson(contactDto.getReciveName());
            receiveAddressEo.setPhone(contactDto.getRecivePhone());
            receiveAddressEo.setProvinceCode(contactDto.getProvinceCode());
            receiveAddressEo.setProvinceName(contactDto.getProvince());
            receiveAddressEo.setCityCode(contactDto.getCityCode());
            receiveAddressEo.setCityName(contactDto.getCity());
            receiveAddressEo.setDistrictCode(contactDto.getDistrictCode());
            receiveAddressEo.setDistrictName(contactDto.getDistrict());
            receiveAddressEo.setDetailAddress(contactDto.getDetailAddress());
        }
        this.consignmentOrderAddressDas.insert((BaseEo)receiveAddressEo);
        String shippingJson = csOutResultOrderEo.getShippingJson();
        AssertUtil.assertNotBlank(shippingJson, "\u7ed3\u679c\u5355\u7269\u6d41\u4fe1\u606f\u4e3a\u7a7a\uff0c\u6216\u8005\u4e0d\u5b58\u5728", new Object[0]);
        List shippingJsonDtoList = JSONObject.parseArray((String)shippingJson, ShippingJsonDto.class);
        ShippingJsonDto shippingJsonDto = (ShippingJsonDto)shippingJsonDtoList.get(0);
        ConsignmentOrderDeliveryInfoEo consignmentOrderDeliveryInfoEo = new ConsignmentOrderDeliveryInfoEo();
        consignmentOrderDeliveryInfoEo.setConsignmentNo(consignmentNo);
        consignmentOrderDeliveryInfoEo.setWmsConsignmentNo(wmsConsignmentNo);
        consignmentOrderDeliveryInfoEo.setOutNoticeNo(csOutResultOrderEo.getPreOrderNo());
        consignmentOrderDeliveryInfoEo.setOutResultNo(csOutResultOrderEo.getDocumentNo());
        consignmentOrderDeliveryInfoEo.setBusinessNo(csOutResultOrderEo.getRelevanceNo());
        consignmentOrderDeliveryInfoEo.setExternalOrderNo(csOutResultOrderEo.getExternalOrderNo());
        consignmentOrderDeliveryInfoEo.setMergeOrderNo(consignmentOrderEo.getMergeOrderNo());
        consignmentOrderDeliveryInfoEo.setCarrierNo(shippingJsonDto.getShippingNo());
        consignmentOrderDeliveryInfoEo.setCarrierCode(shippingJsonDto.getShippingCompanyCode());
        consignmentOrderDeliveryInfoEo.setCarrierName(shippingJsonDto.getShippingCompanyName());
        consignmentOrderDeliveryInfoEo.setCarrierType(StringUtils.isNotBlank((CharSequence)shippingJsonDto.getLogisticsType()) ? shippingJsonDto.getLogisticsType() : shippingJsonDto.getShippingType());
        consignmentOrderDeliveryInfoEo.setCarLicenseNo(basicsReceiveBasicsReqDto.getCarNum());
        consignmentOrderDeliveryInfoEo.setDriverName(basicsReceiveBasicsReqDto.getDriverName());
        consignmentOrderDeliveryInfoEo.setDriverPhone(basicsReceiveBasicsReqDto.getDriverPhone());
        if (null != shippingJsonDto.getDeliveryTime()) {
            consignmentOrderDeliveryInfoEo.setDeliveryTime(new Date(shippingJsonDto.getDeliveryTime()));
        } else {
            consignmentOrderDeliveryInfoEo.setDeliveryTime(csOutResultOrderEo.getInOutTime());
        }
        int planDays = this.consignmentOrderService.calcPlanArriveDays(consignmentOrderDeliveryInfoEo.getCarrierCode(), consignmentOrderEo.getPhysicsWarehouseCode(), receiveAddressEo.getDistrictName(), receiveAddressEo.getCityName(), receiveAddressEo.getProvinceName(), consignmentOrderDeliveryInfoEo.getCarrierType());
        if (planDays > 0) {
            consignmentOrderDeliveryInfoEo.setPlanArriveDays(Integer.valueOf(planDays));
            Date planArriveTime = DateUtil.addDays((Date)consignmentOrderDeliveryInfoEo.getDeliveryTime(), (int)planDays);
            log.info("\u53d1\u8d27\u65f6\u95f4\u589e\u52a0\u5929\u6570:{}, \u8ba1\u5212\u5230\u8fbe\u65f6\u95f4: {}", (Object)planDays, (Object)DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)planArriveTime));
            planArriveTime = DateUtils.getEndTime(planArriveTime);
            String timeStr = DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)planArriveTime);
            log.info("\u8ba1\u5212\u5230\u8fbe\u65f6\u95f4\u53d6\u6700\u5927\u503c\u540e: {}, {}", (Object)planDays, (Object)timeStr);
            consignmentOrderDeliveryInfoEo.setPlanArriveTime(DateUtil.parseDate((String)timeStr, (String)"yyyy-MM-dd HH:mm:ss"));
        }
        this.consignmentOrderDeliveryInfoDas.insert((BaseEo)consignmentOrderDeliveryInfoEo);
        InOutResultOrderEo updateOutResultEo = new InOutResultOrderEo();
        updateOutResultEo.setId(csOutResultOrderEo.getId());
        updateOutResultEo.setEstimatedTime(consignmentOrderDeliveryInfoEo.getPlanArriveTime());
        this.inOutResultOrderDomain.updateSelective((BaseEo)updateOutResultEo);
        if (CsPcpBusinessTypeEnum.ALLOT_SALE.getCode().equals(csOutResultOrderEo.getBusinessType())) {
            CsTransferOrderEo csTransferOrderEo = (CsTransferOrderEo)this.csTransferOrderMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CsTransferOrderEo.class).eq(CsTransferOrderEo::getTransferOrderNo, (Object)csOutResultOrderEo.getRelevanceNo())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
            AssertUtils.notNull((Object)csTransferOrderEo, (String)"\u9500\u552e\u8c03\u62e8\u5355\u4e0d\u5b58\u5728");
            if (StringUtils.isNotBlank((CharSequence)csTransferOrderEo.getSecondTransferOrderNo())) {
                return;
            }
            this.doSaveMergeNotice(csOutResultOrderEo.getConsignmentNo());
        } else {
            boolean flag = false;
            if (CsPcpBusinessTypeEnum.maiyouBcAllotList().contains(csOutResultOrderEo.getBusinessType())) {
                CsTransferOrderEo csTransferOrderEo = (CsTransferOrderEo)this.csTransferOrderMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CsTransferOrderEo.class).eq(CsTransferOrderEo::getTransferOrderNo, (Object)csOutResultOrderEo.getRelevanceNo())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
                log.info("\u666e\u901a\u3001bc\u8c03\u62e8\u5355={}", JSON.toJSON((Object)csTransferOrderEo));
                if (Objects.nonNull(csTransferOrderEo) && StringUtils.isNotBlank((CharSequence)csTransferOrderEo.getSaleOrderNo())) {
                    if (StringUtils.isNotBlank((CharSequence)csTransferOrderEo.getSecondTransferOrderNo())) {
                        return;
                    }
                    flag = true;
                }
            }
            if (flag) {
                this.doSaveMergeNotice(csOutResultOrderEo.getConsignmentNo());
            } else {
                ConsignmentOrderEo transferConsignmentOrderEo = (ConsignmentOrderEo)this.consignmentOrderMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ConsignmentOrderEo.class).eq(ConsignmentOrderEo::getOutNoticeNo, (Object)csOutResultOrderEo.getPreOrderNo())).eq(ConsignmentOrderEo::getConsignmentType, (Object)2)).eq(ConsignmentOrderEo::getOrderStatus, (Object)-1));
                if (null != transferConsignmentOrderEo) {
                    this.csWmsService.doNoticeConsignmentOrder(transferConsignmentOrderEo, transferConsignmentOrderEo.getPhysicsWarehouseCode(), csOutResultOrderEo.getPreOrderNo(), transferConsignmentOrderEo.getConsignmentNo(), csOutResultOrderEo);
                }
            }
        }
    }

    private String getSaleOrderConsignmentNo(InOutResultOrderEo csOutResultOrderEo) {
        ArrayList orderStatusList = Lists.newArrayList((Object[])new String[]{CsTransferOrderEnum.Status.CANCELED.getCode(), CsTransferOrderEnum.Status.AUDIT_FAILED.getCode()});
        List csTransferOrderEos = this.csTransferOrderMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CsTransferOrderEo.class).eq(CsTransferOrderEo::getSaleOrderNo, (Object)csOutResultOrderEo.getRelevanceNo())).isNull(CsTransferOrderEo::getSecondTransferOrderNo)).notIn(CsTransferOrderEo::getOrderStatus, (Collection)orderStatusList)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        if (CollectionUtils.isEmpty((Collection)csTransferOrderEos)) {
            return null;
        }
        CsTransferOrderEo csTransferOrderEo = (CsTransferOrderEo)csTransferOrderEos.get(0);
        List consignmentOrderEos = this.consignmentOrderDas.getMapper().selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ConsignmentOrderEo.class).eq(ConsignmentOrderEo::getBusinessNo, (Object)csTransferOrderEo.getTransferOrderNo())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        if (CollectionUtils.isEmpty((Collection)consignmentOrderEos)) {
            return null;
        }
        ConsignmentOrderEo consignmentOrderEo = (ConsignmentOrderEo)consignmentOrderEos.get(0);
        String saleOrderConsignmentNo = consignmentOrderEo.getThirdConsignmentNo();
        return saleOrderConsignmentNo;
    }

    private String getSecondTransferConsignmentNo(InOutResultOrderEo csOutResultOrderEo) {
        ArrayList orderStatusList = Lists.newArrayList((Object[])new String[]{CsTransferOrderEnum.Status.CANCELED.getCode(), CsTransferOrderEnum.Status.AUDIT_FAILED.getCode()});
        List csTransferOrderEos = this.csTransferOrderMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CsTransferOrderEo.class).eq(CsTransferOrderEo::getTransferOrderNo, (Object)csOutResultOrderEo.getRelevanceNo())).notIn(CsTransferOrderEo::getOrderStatus, (Collection)orderStatusList)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        if (CollectionUtils.isEmpty((Collection)csTransferOrderEos)) {
            return null;
        }
        CsTransferOrderEo csTransferOrderEo = (CsTransferOrderEo)csTransferOrderEos.get(0);
        List consignmentOrderEos = this.consignmentOrderDas.getMapper().selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ConsignmentOrderEo.class).eq(ConsignmentOrderEo::getBusinessNo, (Object)csTransferOrderEo.getSecondTransferOrderNo())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        if (CollectionUtils.isEmpty((Collection)consignmentOrderEos)) {
            return null;
        }
        ConsignmentOrderEo consignmentOrderEo = (ConsignmentOrderEo)consignmentOrderEos.get(0);
        String SecondTransferConsignmentNo = consignmentOrderEo.getSecondConsignmentNo();
        log.info("\u67e5\u8be2\u5230\u4e2d\u8f6c\u8c03\u62e8\u5355\u8fd0\u5355:{}", (Object)JSON.toJSONString((Object)SecondTransferConsignmentNo));
        return SecondTransferConsignmentNo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSaveMergeNotice(String consignmentNo) {
        Mutex mutex = this.lockService.lock("doSaveMergeNotice", consignmentNo, 20, 25, TimeUnit.SECONDS);
        try {
            List mergeNoticeTransferEos = this.mergeNoticeTransferDas.getMapper().selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(MergeNoticeTransferEo.class).eq(MergeNoticeTransferEo::getWmsConsignmentNo, (Object)consignmentNo)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
            if (CollectionUtils.isNotEmpty((Collection)mergeNoticeTransferEos)) {
                return;
            }
            MergeNoticeTransferEo mergeNoticeTransferEo = new MergeNoticeTransferEo();
            mergeNoticeTransferEo.setMergeNo(this.codeGenerateUtil.generateNo("METS", 6));
            mergeNoticeTransferEo.setWmsConsignmentNo(consignmentNo);
            mergeNoticeTransferEo.setOrderStatus(Integer.valueOf(0));
            this.mergeNoticeTransferDas.insert((BaseEo)mergeNoticeTransferEo);
        }
        finally {
            this.transactionCallBackService.execute(() -> this.lockService.unlock(mutex));
        }
    }

    private void doAllotSaleNoticeConsignmentOrder(CsTransferOrderEo transferOrderEo, InOutResultOrderEo csOutResultOrderEo, List<InOutResultOrderDetailEo> csOutResultOrderDetailEos, ConsignmentOrderEo consignmentOrderEo, ConsignmentOrderDeliveryInfoEo deliveryInfoEo) {
        MessageVo messageVo = new MessageVo();
        WmsReturnOrderCreateReqDto wmsReturnOrderCreateReqDto = new WmsReturnOrderCreateReqDto();
        String outPhysicsWarehouseCode = transferOrderEo.getOutPhysicsWarehouseCode();
        AssertUtils.notBlank((String)outPhysicsWarehouseCode, (String)"\u51fa\u5e93\u7269\u7406\u4ed3\u7f16\u7801\u4e0d\u5b58\u5728");
        List outPhysicsWarehouseEos = this.physicsWarehouseDomain.queryByWarehouseCode(outPhysicsWarehouseCode);
        AssertUtils.notEmpty((Collection)outPhysicsWarehouseEos, (String)"\u51fa\u5e93\u7269\u7406\u4ed3\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728");
        PhysicsWarehouseEo outPhysicsWarehouseEo = (PhysicsWarehouseEo)outPhysicsWarehouseEos.get(0);
        WarehouseAddressEo outWarehouseAddressEo = this.warehouseAddressDomain.queryByWarehouseCode(outPhysicsWarehouseCode);
        AssertUtils.notNull((Object)outWarehouseAddressEo, (String)"\u51fa\u5e93\u7269\u7406\u4ed3\u5730\u5740\u67e5\u8be2\u4e0d\u5b58\u5728");
        String inPhysicsWarehouseCode = transferOrderEo.getInPhysicsWarehouseCode();
        AssertUtils.notBlank((String)inPhysicsWarehouseCode, (String)"\u5165\u5e93\u7269\u7406\u4ed3\u7f16\u7801\u4e0d\u5b58\u5728");
        List inPhysicsWarehouseEos = this.physicsWarehouseDomain.queryByWarehouseCode(inPhysicsWarehouseCode);
        AssertUtils.notEmpty((Collection)inPhysicsWarehouseEos, (String)"\u5165\u5e93\u7269\u7406\u4ed3\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728");
        PhysicsWarehouseEo inPhysicsWarehouseEo = (PhysicsWarehouseEo)inPhysicsWarehouseEos.get(0);
        WarehouseAddressEo inWarehouseAddressEo = this.warehouseAddressDomain.queryByWarehouseCode(inPhysicsWarehouseCode);
        AssertUtils.notNull((Object)inWarehouseAddressEo, (String)"\u5165\u5e93\u7269\u7406\u4ed3\u5730\u5740\u67e5\u8be2\u4e0d\u5b58\u5728");
        String saleOrderNo = transferOrderEo.getSaleOrderNo();
        List receiveDeliveryNoticeOrderEos = this.receiveDeliveryNoticeOrderDomain.queryByRelevanceNo(saleOrderNo);
        ReceiveDeliveryNoticeOrderEo deliveryNoticeOrderEo = receiveDeliveryNoticeOrderEos.stream().filter(o -> "delivery".equals(o.getOrderType())).findFirst().orElse(null);
        AssertUtils.notNull((Object)deliveryNoticeOrderEo, (String)"\u8ba2\u5355\u53d1\u8d27\u901a\u77e5\u5355\u67e5\u8be2\u4e0d\u5b58\u5728");
        ContactDto contactDto = (ContactDto)JSON.parseObject((String)deliveryNoticeOrderEo.getExtension(), ContactDto.class);
        AssertUtils.notNull((Object)contactDto, (String)"\u53d1\u8d27\u5ba2\u6237\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728");
        wmsReturnOrderCreateReqDto.setWarehouseCode(inPhysicsWarehouseCode);
        WmsReturnOrderCreateReqDto.ExtendInfo extendInfo = new WmsReturnOrderCreateReqDto.ExtendInfo();
        extendInfo.setDocumentNo(csOutResultOrderEo.getPreOrderNo());
        extendInfo.setPhysicWarehouseCode(csOutResultOrderEo.getInPhysicsWarehouseCode());
        List<Object> transferDtoList = Lists.newArrayList();
        if (StringUtils.isBlank((CharSequence)transferOrderEo.getNextPhysicsWarehouseCode())) {
            transferDtoList = this.twoStageLogistics(consignmentOrderEo, deliveryInfoEo, outPhysicsWarehouseEo, inPhysicsWarehouseEo, inWarehouseAddressEo, contactDto);
        } else {
            String nextPhysicsWarehouseCode = transferOrderEo.getNextPhysicsWarehouseCode();
            AssertUtils.notBlank((String)nextPhysicsWarehouseCode, (String)"\u4e0b\u4e00\u6b65\u7269\u7406\u4ed3\u7f16\u7801\u4e0d\u5b58\u5728");
            List nextPhysicsWarehouseEos = this.physicsWarehouseDomain.queryByWarehouseCode(nextPhysicsWarehouseCode);
            AssertUtils.notEmpty((Collection)nextPhysicsWarehouseEos, (String)"\u4e0b\u4e00\u6b65\u7269\u7406\u4ed3\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728");
            PhysicsWarehouseEo nextPhysicsWarehouseEo = (PhysicsWarehouseEo)nextPhysicsWarehouseEos.get(0);
            WarehouseAddressEo nextWarehouseAddressEo = this.warehouseAddressDomain.queryByWarehouseCode(nextPhysicsWarehouseCode);
            AssertUtils.notNull((Object)nextWarehouseAddressEo, (String)"\u4e0b\u4e00\u6b65\u7269\u7406\u4ed3\u5730\u5740\u67e5\u8be2\u4e0d\u5b58\u5728");
            transferDtoList = this.threeStageLogistics(consignmentOrderEo, deliveryInfoEo, outPhysicsWarehouseEo, inPhysicsWarehouseEo, inWarehouseAddressEo, nextPhysicsWarehouseEo, nextWarehouseAddressEo, contactDto);
        }
        extendInfo.setTransferArray((List)transferDtoList);
        wmsReturnOrderCreateReqDto.setExtendInfo(extendInfo);
        ArrayList itemLines = Lists.newArrayList();
        for (InOutResultOrderDetailEo csOutResultOrderDetailEo : csOutResultOrderDetailEos) {
            WmsItemLine itemLine = new WmsItemLine();
            itemLine.setCargoCode(csOutResultOrderDetailEo.getSkuCode());
            itemLine.setCargoName(csOutResultOrderDetailEo.getSkuName());
            itemLine.setBatch(csOutResultOrderDetailEo.getBatch());
            itemLine.setPlanQuantity(csOutResultOrderDetailEo.getDoneQuantity());
            itemLine.setTradeOrderItemId(null != csOutResultOrderDetailEo.getPreOrderItemId() ? csOutResultOrderDetailEo.getPreOrderItemId().toString() : csOutResultOrderDetailEo.getId().toString());
            String productDate = null != csOutResultOrderDetailEo.getProduceTime() ? DateUtils.formatYMDHms(csOutResultOrderDetailEo.getProduceTime()) : null;
            String arrivalDate = null != csOutResultOrderDetailEo.getExpireTime() ? DateUtils.formatYMDHms(csOutResultOrderDetailEo.getExpireTime()) : null;
            itemLine.setProductDate(productDate);
            itemLine.setArrivalDate(arrivalDate);
            itemLines.add(itemLine);
        }
        wmsReturnOrderCreateReqDto.setItemLines((List)itemLines);
        this.transactionCallBackService.execute(() -> {
            ReturnorderCreateRequestDto.SenderInfo senderInfo = new ReturnorderCreateRequestDto.SenderInfo();
            senderInfo.setName(outWarehouseAddressEo.getContacts());
            senderInfo.setMobile(outWarehouseAddressEo.getPhone());
            senderInfo.setProvince(outWarehouseAddressEo.getProvince());
            senderInfo.setCity(outWarehouseAddressEo.getCity());
            senderInfo.setArea(outWarehouseAddressEo.getDistrict());
            senderInfo.setDetailAddress(outWarehouseAddressEo.getDetailAddress());
            wmsReturnOrderCreateReqDto.setSenderInfo(senderInfo);
            messageVo.setData((Object)JSON.toJSONString((Object)wmsReturnOrderCreateReqDto));
            this.mqService.returnOrderToWmsProcessor(messageVo);
        });
    }

    private List<WmsReturnOrderCreateReqDto.TransferDto> threeStageLogistics(ConsignmentOrderEo consignmentOrderEo, ConsignmentOrderDeliveryInfoEo deliveryInfoEo, PhysicsWarehouseEo outPhysicsWarehouseEo, PhysicsWarehouseEo inPhysicsWarehouseEo, WarehouseAddressEo inWarehouseAddressEo, PhysicsWarehouseEo nextPhysicsWarehouseEo, WarehouseAddressEo nextWarehouseAddressEo, ContactDto contactDto) {
        ArrayList transferDtoList = Lists.newArrayList();
        WmsReturnOrderCreateReqDto.TransferDto oneTransferDto = new WmsReturnOrderCreateReqDto.TransferDto();
        oneTransferDto.setPhysicWarehouseCode(outPhysicsWarehouseEo.getWarehouseCode());
        oneTransferDto.setPhysicWarehouseName(outPhysicsWarehouseEo.getWarehouseName());
        oneTransferDto.setOcsSecondaryConsignmentNo(String.format("%s(%s)", consignmentOrderEo.getSecondaryConsignmentNo(), outPhysicsWarehouseEo.getSampleCode()));
        oneTransferDto.setOcsConsignmentNo(consignmentOrderEo.getConsignmentNo());
        oneTransferDto.setOriginWmsConsignmentNo(consignmentOrderEo.getOriginWmsConsignmentNo());
        oneTransferDto.setTransferFlag(outPhysicsWarehouseEo.getSampleCode());
        oneTransferDto.setReceivePerson(inWarehouseAddressEo.getContacts());
        oneTransferDto.setReceivePhone(inWarehouseAddressEo.getPhone());
        oneTransferDto.setReceiveProvince(inWarehouseAddressEo.getProvince());
        oneTransferDto.setReceiveCity(inWarehouseAddressEo.getCity());
        oneTransferDto.setReceiveDistrict(inWarehouseAddressEo.getDistrict());
        oneTransferDto.setReceiveDetailAddress(inWarehouseAddressEo.getDetailAddress());
        oneTransferDto.setLogisticsCode(deliveryInfoEo.getCarrierCode());
        oneTransferDto.setLogisticsName(deliveryInfoEo.getCarrierName());
        oneTransferDto.setLogisticsType(deliveryInfoEo.getCarrierType());
        oneTransferDto.setCarNum(deliveryInfoEo.getCarLicenseNo());
        oneTransferDto.setCustomerCode(outPhysicsWarehouseEo.getWarehouseCode());
        oneTransferDto.setTransferSort("1");
        transferDtoList.add(oneTransferDto);
        WmsReturnOrderCreateReqDto.TransferDto twoTransferDto = new WmsReturnOrderCreateReqDto.TransferDto();
        twoTransferDto.setPhysicWarehouseCode(inPhysicsWarehouseEo.getWarehouseCode());
        twoTransferDto.setPhysicWarehouseName(inPhysicsWarehouseEo.getWarehouseName());
        twoTransferDto.setOcsSecondaryConsignmentNo(String.format("%s(%s)", consignmentOrderEo.getSecondaryConsignmentNo(), inPhysicsWarehouseEo.getSampleCode()));
        String twoConsignmentNo = this.codeGenerateUtil.generateNo("TS", 6);
        twoTransferDto.setOcsConsignmentNo(twoConsignmentNo);
        twoTransferDto.setOriginWmsConsignmentNo(consignmentOrderEo.getOriginWmsConsignmentNo());
        twoTransferDto.setTransferFlag(inPhysicsWarehouseEo.getSampleCode());
        twoTransferDto.setReceivePerson(nextWarehouseAddressEo.getContacts());
        twoTransferDto.setReceivePhone(nextWarehouseAddressEo.getPhone());
        twoTransferDto.setReceiveProvince(nextWarehouseAddressEo.getProvince());
        twoTransferDto.setReceiveCity(nextWarehouseAddressEo.getCity());
        twoTransferDto.setReceiveDistrict(nextWarehouseAddressEo.getDistrict());
        twoTransferDto.setReceiveDetailAddress(nextWarehouseAddressEo.getDetailAddress());
        twoTransferDto.setLogisticsCode(inPhysicsWarehouseEo.getWarehouseCode());
        twoTransferDto.setLogisticsName(inPhysicsWarehouseEo.getWarehouseName() + "\u8363\u5e86");
        twoTransferDto.setLogisticsType(deliveryInfoEo.getCarrierType());
        twoTransferDto.setCarNum(deliveryInfoEo.getCarLicenseNo());
        twoTransferDto.setCustomerCode(inPhysicsWarehouseEo.getWarehouseCode());
        twoTransferDto.setTransferSort("2");
        transferDtoList.add(twoTransferDto);
        WmsReturnOrderCreateReqDto.TransferDto threeTransferDto = new WmsReturnOrderCreateReqDto.TransferDto();
        threeTransferDto.setPhysicWarehouseCode(nextPhysicsWarehouseEo.getWarehouseCode());
        threeTransferDto.setPhysicWarehouseName(nextPhysicsWarehouseEo.getWarehouseName());
        threeTransferDto.setOcsSecondaryConsignmentNo(String.format("%s(%s)", consignmentOrderEo.getSecondaryConsignmentNo(), nextPhysicsWarehouseEo.getSampleCode()));
        String threeConsignmentNo = this.codeGenerateUtil.generateNo("TS", 6);
        threeTransferDto.setOcsConsignmentNo(threeConsignmentNo);
        threeTransferDto.setOriginWmsConsignmentNo(consignmentOrderEo.getOriginWmsConsignmentNo());
        threeTransferDto.setTransferFlag(nextPhysicsWarehouseEo.getSampleCode());
        threeTransferDto.setReceivePerson(contactDto.getContacts());
        threeTransferDto.setReceivePhone(contactDto.getPhone());
        threeTransferDto.setReceiveProvince(contactDto.getProvince());
        threeTransferDto.setReceiveCity(contactDto.getCity());
        threeTransferDto.setReceiveDistrict(contactDto.getDistrict());
        threeTransferDto.setReceiveDetailAddress(contactDto.getDetailAddress());
        threeTransferDto.setLogisticsCode(nextPhysicsWarehouseEo.getWarehouseCode());
        threeTransferDto.setLogisticsName(nextPhysicsWarehouseEo.getWarehouseName() + "\u8363\u5e86");
        threeTransferDto.setLogisticsType(deliveryInfoEo.getCarrierType());
        threeTransferDto.setCarNum(deliveryInfoEo.getCarLicenseNo());
        threeTransferDto.setCustomerCode(nextPhysicsWarehouseEo.getWarehouseCode());
        threeTransferDto.setTransferSort("3");
        transferDtoList.add(threeTransferDto);
        this.updateConsignmentOrder(consignmentOrderEo, twoConsignmentNo, threeConsignmentNo);
        return transferDtoList;
    }

    private void updateConsignmentOrder(ConsignmentOrderEo consignmentOrderEo, String twoConsignmentNo, String threeConsignmentNo) {
        log.info("updateConsignmentOrder\u8fd0\u5355\u4fee\u6539:{},\u7b2c\u4e8c\u6bb5\u8fd0\u5355:{},\u7b2c\u4e09\u6bb5\u8fd0\u5355:{}", new Object[]{JSON.toJSONString((Object)consignmentOrderEo), JSON.toJSONString((Object)twoConsignmentNo), JSON.toJSONString((Object)threeConsignmentNo)});
        List consignmentOrderEos = this.consignmentOrderDas.getMapper().selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ConsignmentOrderEo.class).eq(ConsignmentOrderEo::getConsignmentNo, (Object)consignmentOrderEo.getConsignmentNo())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        AssertUtils.notEmpty((Collection)consignmentOrderEos, (String)"\u8fd0\u5355\u67e5\u8be2\u4e0d\u5b58\u5728");
        ConsignmentOrderEo orderEo = (ConsignmentOrderEo)consignmentOrderEos.get(0);
        orderEo.setSecondConsignmentNo(twoConsignmentNo);
        orderEo.setThirdConsignmentNo(threeConsignmentNo);
        this.consignmentOrderDas.updateSelective((BaseEo)orderEo);
    }

    private List<WmsReturnOrderCreateReqDto.TransferDto> twoStageLogistics(ConsignmentOrderEo consignmentOrderEo, ConsignmentOrderDeliveryInfoEo deliveryInfoEo, PhysicsWarehouseEo outPhysicsWarehouseEo, PhysicsWarehouseEo inPhysicsWarehouseEo, WarehouseAddressEo inWarehouseAddressEo, ContactDto contactDto) {
        ArrayList transferDtoList = Lists.newArrayList();
        WmsReturnOrderCreateReqDto.TransferDto oneTransferDto = new WmsReturnOrderCreateReqDto.TransferDto();
        oneTransferDto.setPhysicWarehouseCode(outPhysicsWarehouseEo.getWarehouseCode());
        oneTransferDto.setPhysicWarehouseName(outPhysicsWarehouseEo.getWarehouseName());
        oneTransferDto.setOcsSecondaryConsignmentNo(String.format("%s(%s)", consignmentOrderEo.getSecondaryConsignmentNo(), outPhysicsWarehouseEo.getSampleCode()));
        oneTransferDto.setOcsConsignmentNo(consignmentOrderEo.getConsignmentNo());
        oneTransferDto.setOriginWmsConsignmentNo(consignmentOrderEo.getOriginWmsConsignmentNo());
        oneTransferDto.setTransferFlag(outPhysicsWarehouseEo.getSampleCode());
        oneTransferDto.setReceivePerson(inWarehouseAddressEo.getContacts());
        oneTransferDto.setReceivePhone(inWarehouseAddressEo.getPhone());
        oneTransferDto.setReceiveProvince(inWarehouseAddressEo.getProvince());
        oneTransferDto.setReceiveCity(inWarehouseAddressEo.getCity());
        oneTransferDto.setReceiveDistrict(inWarehouseAddressEo.getDistrict());
        oneTransferDto.setReceiveDetailAddress(inWarehouseAddressEo.getDetailAddress());
        oneTransferDto.setLogisticsCode(deliveryInfoEo.getCarrierCode());
        oneTransferDto.setLogisticsName(deliveryInfoEo.getCarrierName());
        oneTransferDto.setLogisticsType(deliveryInfoEo.getCarrierType());
        oneTransferDto.setCarNum(deliveryInfoEo.getCarLicenseNo());
        oneTransferDto.setCustomerCode(outPhysicsWarehouseEo.getWarehouseCode());
        oneTransferDto.setTransferSort("1");
        transferDtoList.add(oneTransferDto);
        WmsReturnOrderCreateReqDto.TransferDto twoTransferDto = new WmsReturnOrderCreateReqDto.TransferDto();
        twoTransferDto.setPhysicWarehouseCode(inPhysicsWarehouseEo.getWarehouseCode());
        twoTransferDto.setPhysicWarehouseName(inPhysicsWarehouseEo.getWarehouseName());
        twoTransferDto.setOcsSecondaryConsignmentNo(String.format("%s(%s)", consignmentOrderEo.getSecondaryConsignmentNo(), inPhysicsWarehouseEo.getSampleCode()));
        String twoConsignmentNo = this.codeGenerateUtil.generateNo("TS", 6);
        twoTransferDto.setOcsConsignmentNo(twoConsignmentNo);
        twoTransferDto.setOriginWmsConsignmentNo(consignmentOrderEo.getOriginWmsConsignmentNo());
        twoTransferDto.setTransferFlag(inPhysicsWarehouseEo.getSampleCode());
        twoTransferDto.setReceivePerson(contactDto.getContacts());
        twoTransferDto.setReceivePhone(contactDto.getPhone());
        twoTransferDto.setReceiveProvince(contactDto.getProvince());
        twoTransferDto.setReceiveCity(contactDto.getCity());
        twoTransferDto.setReceiveDistrict(contactDto.getDistrict());
        twoTransferDto.setReceiveDetailAddress(contactDto.getDetailAddress());
        twoTransferDto.setLogisticsCode(inPhysicsWarehouseEo.getWarehouseCode());
        twoTransferDto.setLogisticsName(inPhysicsWarehouseEo.getWarehouseName() + "\u8363\u5e86");
        twoTransferDto.setLogisticsType(deliveryInfoEo.getCarrierType());
        twoTransferDto.setCarNum(deliveryInfoEo.getCarLicenseNo());
        twoTransferDto.setCustomerCode(inPhysicsWarehouseEo.getWarehouseCode());
        twoTransferDto.setTransferSort("2");
        transferDtoList.add(twoTransferDto);
        this.updateConsignmentOrder(consignmentOrderEo, null, twoConsignmentNo);
        return transferDtoList;
    }

    private void saveInventoryBatch(InOutResultOrderEo resultOrderEo, List<InOutResultOrderDetailEo> resultOrderDetailEoList) {
        log.info("saveInventoryBatch...................");
        if (!StringUtils.equals((CharSequence)resultOrderEo.getOrderType(), (CharSequence)"in")) {
            return;
        }
        if (CollectionUtils.isEmpty(resultOrderDetailEoList)) {
            return;
        }
        Date inTime = resultOrderEo.getInOutTime();
        if (null == inTime) {
            inTime = new Date();
        }
        log.info("saveInventoryBatch: {}", resultOrderDetailEoList);
        List skuCodeList = resultOrderDetailEoList.stream().map(InOutResultOrderDetailEo::getSkuCode).distinct().collect(Collectors.toList());
        List batchList = resultOrderDetailEoList.stream().map(InOutResultOrderDetailEo::getBatch).distinct().collect(Collectors.toList());
        List inventoryBatchEos = this.inventoryBatchMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InventoryBatchEo.class).in(InventoryBatchEo::getSkuCode, skuCodeList)).in(InventoryBatchEo::getBatch, batchList)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        for (InOutResultOrderDetailEo detailEo : resultOrderDetailEoList) {
            InventoryBatchEo inventoryBatchEo = inventoryBatchEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getSkuCode(), (CharSequence)detailEo.getSkuCode()) && StringUtils.equals((CharSequence)o.getBatch(), (CharSequence)detailEo.getBatch())).findFirst().orElse(null);
            try {
                if (null != inventoryBatchEo) {
                    if (null != inventoryBatchEo.getFirstInTime()) continue;
                    InventoryBatchEo updateEo = new InventoryBatchEo();
                    updateEo.setId(inventoryBatchEo.getId());
                    updateEo.setFirstInTime(inTime);
                    this.inventoryBatchDas.updateSelective((BaseEo)updateEo);
                    continue;
                }
                InventoryBatchEo insertEo = new InventoryBatchEo();
                insertEo.setSkuCode(detailEo.getSkuCode());
                insertEo.setSkuName(detailEo.getSkuName());
                insertEo.setBatch(detailEo.getBatch());
                insertEo.setFirstInTime(inTime);
                this.inventoryBatchDas.insert((BaseEo)insertEo);
            }
            catch (Exception e) {
                log.error("\u4fdd\u5b58\u6279\u6b21\u6863\u6848\u5f02\u5e38: {}", (Object)e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

