/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl.inventory;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsDeliveryNoticeOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.inventory.CsQualityInfoDetailDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.inventory.CsTransferOrderDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsQualityInfoDetailEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsTransferOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsStorageSendMqReqDto;
import com.yunxi.dg.base.center.inventory.dto.calc.ReleasePreemptDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsBasicsOrderReqDto;
import com.yunxi.dg.base.center.inventory.service.calc.ICalcInventoryService;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CsCommonOrderService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    ICsDeliveryNoticeOrderQueryService csDeliveryNoticeOrderQueryService;
    @Resource
    CsQualityInfoDetailDas qualityInfoDetailDas;
    @Resource
    CsTransferOrderDas csTransferOrderDas;
    @Autowired
    ICalcInventoryService calcInventoryService;

    @Transactional(rollbackFor={Exception.class})
    public void createReceiveDeliveryResultOrder(CsStorageSendMqReqDto csStorageSendMqReqDto) {
        this.logger.info("\u521b\u5efa\u6536\u53d1\u8d27\u7ed3\u679c\u5355,\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)csStorageSendMqReqDto));
    }

    @Transactional(rollbackFor={Exception.class})
    public void createOutInNoticeOrder(CsStorageSendMqReqDto csStorageSendMqReqDto) {
        this.logger.info("\u521b\u5efa\u51fa\u5165\u5e93\u901a\u77e5\u5355,\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)csStorageSendMqReqDto));
    }

    private void releaseInventory(CsBasicsOrderReqDto csBasicsOrderReqDto) {
        ReleasePreemptDto releasePreemptDto = new ReleasePreemptDto();
        releasePreemptDto.setSourceNo(csBasicsOrderReqDto.getRelevanceNo());
        releasePreemptDto.setSourceType(csBasicsOrderReqDto.getSourceType());
        releasePreemptDto.setExternalOrderNo(csBasicsOrderReqDto.getExternalOrderNo());
        this.calcInventoryService.releasePreempt(releasePreemptDto);
    }

    private void updateQualityDetailWmsStatus(String plannedOrderNo, String status) {
        this.logger.info("updateQualityDetailWmsStatus\u5f00\u59cb\u66f4\u65b0\u5f85\u68c0\u8f6c\u5408\u683c\u5355\u636e\u4fe1\u606fplannedOrderNo:{}\uff0cstatus:{}", (Object)plannedOrderNo, (Object)status);
        CsQualityInfoDetailEo qualityInfoDetailEo = (CsQualityInfoDetailEo)((ExtQueryChainWrapper)this.qualityInfoDetailDas.filter().eq((Object)"planned_order_no", (Object)plannedOrderNo)).one();
        if (null != qualityInfoDetailEo) {
            CsQualityInfoDetailEo csQualityInfoDetailEo = new CsQualityInfoDetailEo();
            csQualityInfoDetailEo.setId(qualityInfoDetailEo.getId());
            csQualityInfoDetailEo.setPushWmsStatus(status);
            csQualityInfoDetailEo.setDischargedTime(new Date());
            this.qualityInfoDetailDas.updateSelective((BaseEo)csQualityInfoDetailEo);
        } else {
            this.logger.info("\u6839\u636e\u5355\u53f7\u672a\u67e5\u5230\u5f85\u68c0\u8f6c\u5408\u683c\u5355\u636eplannedOrderNo\uff1a{}", (Object)plannedOrderNo);
        }
    }

    private CsTransferOrderEo getCsTransferOrderEo(String transferOrderNo) {
        CsTransferOrderEo transferOrderEo = (CsTransferOrderEo)((ExtQueryChainWrapper)this.csTransferOrderDas.filter().eq((Object)"transfer_order_no", (Object)transferOrderNo)).one();
        AssertUtil.isTrue(Objects.nonNull(transferOrderEo), "\u627e\u4e0d\u5230\u8c03\u62e8\u5355\u5355\u636e,\u5355\u636e\u53f7:" + transferOrderNo);
        return transferOrderEo;
    }
}

