/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.utils;

import com.dtyunxi.huieryun.cache.api.ICacheService;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class CodeGenerateUtil {
    @Resource
    private ICacheService cacheService;

    public static String getIdPrefix(LocalDateTime now) {
        return now.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
    }

    private long generate(String key, Date expireTime) {
        long index = this.cacheService.incrBy(key, 1L);
        long expire = this.cacheService.getToLiveTime(key);
        if (expire == -1L) {
            this.cacheService.expireAt(key, expireTime.getTime());
        }
        return index;
    }

    public String generateNo(String prefix, int weiShu) {
        LocalDateTime now = LocalDateTime.now();
        String idPrefix = CodeGenerateUtil.getIdPrefix(now);
        return prefix + idPrefix + String.format("%1$0" + weiShu + "d", this.generate(prefix + idPrefix, this.getExpireAtTime(now)));
    }

    private Date getExpireAtTime(LocalDateTime now) {
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDateTime localDateTime = now.plusDays(1L);
        ZonedDateTime zdt = localDateTime.atZone(zoneId);
        return Date.from(zdt.toInstant());
    }
}

