/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.adapter;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.IMqMessageApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.inventory.IMqMessageService;
import com.dtyunxi.yundt.cube.center.inventory.dto.ResponseDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.MqContentOrderDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.MqMessageReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.MqMessageRespDto;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MqMessageApiImpl
implements IMqMessageApi {
    private static final Logger log = LoggerFactory.getLogger(MqMessageApiImpl.class);
    @Resource
    protected IMqMessageService mqMessageService;

    public RestResponse<Void> sendDeliverOrderInform(MqContentOrderDto dto) {
        this.mqMessageService.sendDeliverOrderInform(dto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> sendReceiveOrderInformMq(MqContentOrderDto dto) {
        this.mqMessageService.sendReceiveOrderInformMq(dto);
        return RestResponse.VOID;
    }

    public RestResponse<String> repairDataOfNo() {
        return new RestResponse((Object)this.mqMessageService.repairDataOfNo());
    }

    public RestResponse<Long> addMqMessage(MqMessageReqDto mqMessageReqDto) {
        return new RestResponse((Object)this.mqMessageService.addMqMessage(mqMessageReqDto));
    }

    public ResponseDto queryById(Long id) {
        ResponseDto dto = new ResponseDto();
        try {
            MqMessageRespDto mqMessageRespDto = this.mqMessageService.queryById(id, true);
            if (mqMessageRespDto != null) {
                dto.setErrorCode(ResponseDto.SUCC_CODE);
                dto.setErrorMessage(null);
                dto.setReturnObject(mqMessageRespDto.getMessage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            dto.setErrorCode(ResponseDto.ERROR_CODE);
            dto.setErrorMessage("\u83b7\u53d6\u62a5\u6587\u5f02\u5e38:" + id + "->" + e.getMessage());
        }
        return dto;
    }

    public RestResponse<List<MqMessageRespDto>> queryByNo(List<String> noList) {
        return new RestResponse(this.mqMessageService.queryByNo(noList));
    }
}

