/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.basics.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.basics.AbstractCsInventoryQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.log.CsActivityInventoryLogEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.inventory.CsActivityInventoryMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.log.CsActivityInventoryLogMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.base.req.BasePageDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics.CsInventoryBasicsQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.log.CsActivityInventoryLogPageQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.basics.CsInventoryBasicsQueryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.log.CsActivityInventoryLogRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryStrategyEnum;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="CsactivityinventoryStrategyQueryService")
public class CsActivityInventoryQueryServiceImpl
extends AbstractCsInventoryQueryService {
    private Logger logger = LoggerFactory.getLogger(CsActivityInventoryQueryServiceImpl.class);
    @Autowired
    private CsActivityInventoryLogMapper csActivityInventoryLogMapper;
    @Autowired
    private CsActivityInventoryMapper csActivityInventoryMapper;

    @Override
    public String getStrategy() {
        return CsInventoryStrategyEnum.ACTIVITY.getCode();
    }

    @Override
    public List<CsInventoryBasicsQueryRespDto> queryCommonInventory(CsInventoryBasicsQueryReqDto query) {
        this.logger.info("queryCommonInventory==>physics,\u57fa\u7840\u5e93\u5b58\u67e5\u8be2,query:{}", (Object)LogUtils.buildLogContent(query));
        if (!this.checkQueryCommonParams(query).booleanValue()) {
            return Lists.newArrayList();
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        this.buildQueryCommonWrapper(query, queryWrapper);
        ArrayList resultList = Lists.newArrayList();
        List csActivityInventoryEoList = this.csActivityInventoryMapper.selectList((Wrapper)queryWrapper);
        CubeBeanUtils.copyCollection((Collection)resultList, (Collection)csActivityInventoryEoList, CsInventoryBasicsQueryRespDto.class);
        return resultList;
    }

    @Override
    public PageInfo<CsActivityInventoryLogRespDto> queryActivityInventoryLogPage(CsActivityInventoryLogPageQueryReqDto pageQueryReqDto) {
        this.logger.info("queryActivityInventoryLogPage==>\u6d3b\u52a8\u5e93\u5b58\u6d41\u6c34\u5206\u9875\u67e5\u8be2,pageQueryReqDto:{}", (Object)LogUtils.buildLogContent(pageQueryReqDto));
        this.checkParams((BasePageDto)pageQueryReqDto);
        QueryWrapper queryWrapper = new QueryWrapper();
        if (!this.buildInventoryPageQueryDto(pageQueryReqDto, (QueryWrapper<CsActivityInventoryLogEo>)queryWrapper).booleanValue()) {
            return new PageInfo();
        }
        PageHelper.startPage((int)pageQueryReqDto.getPageNum(), (int)pageQueryReqDto.getPageSize());
        this.logger.info("queryActivityInventoryLogPage===>\u6d3b\u52a8\u5e93\u5b58\u6d41\u6c34\u5206\u9875\u67e5\u8be2,\u6784\u5efa\u540e\u7684\u67e5\u8be2\u53c2\u6570,queryWrapper:{}", (Object)LogUtils.buildLogContent(queryWrapper));
        List resultList = this.csActivityInventoryLogMapper.selectList((Wrapper)queryWrapper);
        this.logger.info("queryInventoryPage===>\u6d3b\u52a8\u5e93\u5b58\u6d41\u6c34\u5206\u9875\u67e5\u8be2,\u67e5\u8be2\u7ed3\u679c\u96c6\u5408,resultList:{}", (Object)LogUtils.buildLogContent(resultList));
        if (CollectionUtils.isEmpty((Collection)resultList)) {
            return new PageInfo();
        }
        PageInfo pageInfo = new PageInfo(resultList);
        PageInfo result = new PageInfo();
        BeanUtils.copyProperties((Object)pageInfo, (Object)result, (String[])new String[]{"list"});
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)resultList, CsActivityInventoryLogRespDto.class);
        result.setList((List)list);
        return result;
    }

    private Boolean buildInventoryPageQueryDto(CsActivityInventoryLogPageQueryReqDto pageQueryReqDto, QueryWrapper<CsActivityInventoryLogEo> queryWrapper) {
        String endChangeTime;
        String beginChangeTime;
        String suitCode;
        String suitName;
        String activityCode;
        String sourceNo;
        String sourceType;
        String warehouseCode;
        String warehouseName;
        String artNo;
        String cargoCode;
        this.logger.info("buildInventoryPageQueryDto==>\u6d3b\u52a8\u5e93\u5b58\u6d41\u6c34\u5206\u9875\u67e5\u8be2\uff0c\u6784\u5efa\u67e5\u8be2\u53c2\u6570,pageQueryReqDto:{},queryWrapper:{}", (Object)LogUtils.buildLogContent(pageQueryReqDto), (Object)LogUtils.buildLogContent(queryWrapper));
        String cargoName = pageQueryReqDto.getCargoName();
        if (StringUtils.isNotBlank((CharSequence)cargoName)) {
            queryWrapper.eq((Object)"cargo_name", (Object)cargoName);
        }
        if (StringUtils.isNotBlank((CharSequence)(cargoCode = pageQueryReqDto.getCargoCode()))) {
            queryWrapper.eq((Object)"cargo_code", (Object)cargoCode);
        }
        if (StringUtils.isNotBlank((CharSequence)(artNo = pageQueryReqDto.getArtNo()))) {
            queryWrapper.eq((Object)"art_no", (Object)artNo);
        }
        if (StringUtils.isNotBlank((CharSequence)(warehouseName = pageQueryReqDto.getWarehouseName()))) {
            queryWrapper.eq((Object)"warehouse_name", (Object)warehouseName);
        }
        if (StringUtils.isNotBlank((CharSequence)(warehouseCode = pageQueryReqDto.getWarehouseCode()))) {
            queryWrapper.eq((Object)"warehouse_code", (Object)warehouseCode);
        }
        if (StringUtils.isNotBlank((CharSequence)(sourceType = pageQueryReqDto.getSourceType()))) {
            queryWrapper.eq((Object)"source_type", (Object)sourceType);
        }
        if (StringUtils.isNotBlank((CharSequence)(sourceNo = pageQueryReqDto.getSourceNo()))) {
            queryWrapper.eq((Object)"source_no", (Object)sourceNo);
        }
        if (StringUtils.isNotBlank((CharSequence)(activityCode = pageQueryReqDto.getActivityCode()))) {
            queryWrapper.eq((Object)"activity_code", (Object)activityCode);
        }
        if (StringUtils.isNotBlank((CharSequence)(suitName = pageQueryReqDto.getSuitName()))) {
            queryWrapper.eq((Object)"suit_name", (Object)suitName);
        }
        if (StringUtils.isNotBlank((CharSequence)(suitCode = pageQueryReqDto.getSuitCode()))) {
            queryWrapper.eq((Object)"suit_code", (Object)suitCode);
        }
        if (StringUtils.isNotBlank((CharSequence)(beginChangeTime = pageQueryReqDto.getBeginChangeTime()))) {
            queryWrapper.ge((Object)"change_time", (Object)beginChangeTime);
        }
        if (StringUtils.isNotBlank((CharSequence)(endChangeTime = pageQueryReqDto.getEndChangeTime()))) {
            queryWrapper.le((Object)"change_time", (Object)endChangeTime);
        }
        queryWrapper.orderByDesc((Object)"create_time");
        return true;
    }
}

