/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.impl;

import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsLogisticsInfoService;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.inventory.CsLogisticsInfoDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsLogisticsInfoEo;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLogisticsInfoReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLogisticsInfoSyncDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsLogisticsInfoRespDto;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CsLogisticsInfoServiceImpl
implements ICsLogisticsInfoService {
    @Resource
    private CsLogisticsInfoDas csLogisticsInfoDas;

    @Override
    public Long addCsLogisticsInfo(CsLogisticsInfoReqDto addReqDto) {
        CsLogisticsInfoEo csLogisticsInfoEo = new CsLogisticsInfoEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)csLogisticsInfoEo);
        this.csLogisticsInfoDas.insert((BaseEo)csLogisticsInfoEo);
        return csLogisticsInfoEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void logisticsInfoSync(String str) {
        CsLogisticsInfoSyncDto csLogisticsInfoSyncDto = (CsLogisticsInfoSyncDto)JSON.parseObject((String)str, CsLogisticsInfoSyncDto.class);
        List dataInfoList = csLogisticsInfoSyncDto.getDataInfoList();
        ArrayList logisticsInfoEoList = new ArrayList();
        dataInfoList.forEach(info -> {
            CsLogisticsInfoEo logisticsInfoEo = new CsLogisticsInfoEo();
            CubeBeanUtils.copyProperties((Object)logisticsInfoEo, (Object)info, (String[])new String[0]);
            if (StringUtils.isNotBlank((CharSequence)info.getOperTime())) {
                logisticsInfoEo.setOperTime(DateUtil.parseDate((String)info.getOperTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            if (StringUtils.isNotBlank((CharSequence)info.getActualArrivalTime())) {
                logisticsInfoEo.setActualArrivalTime(DateUtil.parseDate((String)info.getActualArrivalTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            if (StringUtils.isNotBlank((CharSequence)info.getCreateTime())) {
                logisticsInfoEo.setCreateTime(DateUtil.parseDate((String)info.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            logisticsInfoEoList.add(logisticsInfoEo);
        });
        if (CollectionUtils.isNotEmpty(logisticsInfoEoList)) {
            this.csLogisticsInfoDas.insertBatch(logisticsInfoEoList);
        }
    }

    @Override
    public void modifyCsLogisticsInfo(CsLogisticsInfoReqDto modifyReqDto) {
        CsLogisticsInfoEo csLogisticsInfoEo = new CsLogisticsInfoEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)csLogisticsInfoEo);
        this.csLogisticsInfoDas.updateSelective((BaseEo)csLogisticsInfoEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeCsLogisticsInfo(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.csLogisticsInfoDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public CsLogisticsInfoRespDto queryById(Long id) {
        CsLogisticsInfoEo csLogisticsInfoEo = (CsLogisticsInfoEo)this.csLogisticsInfoDas.selectByPrimaryKey(id);
        CsLogisticsInfoRespDto csLogisticsInfoRespDto = new CsLogisticsInfoRespDto();
        DtoHelper.eo2Dto((BaseEo)csLogisticsInfoEo, (BaseVo)csLogisticsInfoRespDto);
        return csLogisticsInfoRespDto;
    }

    @Override
    public List<CsLogisticsInfoRespDto> queryByCspNos(List<String> cspNoList) {
        List logisticsInfoEoList = ((ExtQueryChainWrapper)this.csLogisticsInfoDas.filter().in((Object)"csp_no", cspNoList)).list();
        ArrayList<CsLogisticsInfoRespDto> csLogisticsInfoRespDtoList = new ArrayList<CsLogisticsInfoRespDto>();
        DtoHelper.eoList2DtoList((Collection)logisticsInfoEoList, csLogisticsInfoRespDtoList, CsLogisticsInfoRespDto.class);
        return csLogisticsInfoRespDtoList;
    }

    @Override
    public PageInfo<CsLogisticsInfoRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        CsLogisticsInfoReqDto csLogisticsInfoReqDto = (CsLogisticsInfoReqDto)JSON.parseObject((String)filter, CsLogisticsInfoReqDto.class);
        CsLogisticsInfoEo csLogisticsInfoEo = new CsLogisticsInfoEo();
        DtoHelper.dto2Eo((BaseVo)csLogisticsInfoReqDto, (BaseEo)csLogisticsInfoEo);
        PageInfo eoPageInfo = this.csLogisticsInfoDas.selectPage((BaseEo)csLogisticsInfoEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, CsLogisticsInfoRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

