/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.utils;

import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.NumberUtils;
import org.springframework.util.StringUtils;

public class CsNumberUtils
extends NumberUtils {
    public static boolean greaterThanZero(Long value) {
        return value != null && value > 0L;
    }

    public static boolean greaterThanZero(Integer value) {
        return value != null && value > 0;
    }

    public static boolean greaterThanZero(BigDecimal value) {
        return value != null && value.compareTo(BigDecimal.ZERO) > 0;
    }

    public static boolean lessThanZeroOrNull(BigDecimal value) {
        return value == null || value.compareTo(BigDecimal.ZERO) < 0;
    }

    public static boolean lessThanZeroOrNull(Long value) {
        return value == null || value.compareTo(0L) < 0;
    }

    public static boolean lessThanZeroOrNull(Integer value) {
        return value == null || value.compareTo(0) < 0;
    }

    public static boolean lessThanZero(BigDecimal value) {
        if (value == null) {
            return false;
        }
        return value.compareTo(BigDecimal.ZERO) < 0;
    }

    public static boolean lessThanZero(Long value) {
        if (value == null) {
            return false;
        }
        return value.compareTo(0L) < 0;
    }

    public static boolean lessThanZero(Integer value) {
        if (value == null) {
            return false;
        }
        return value.compareTo(0) < 0;
    }

    public static BigDecimal subtract(BigDecimal main, BigDecimal ... args) {
        BigDecimal result = main;
        for (BigDecimal value : args) {
            if (value == null) continue;
            result = result.subtract(value);
        }
        return result.setScale(2, 4);
    }

    public static BigDecimal add(BigDecimal ... args) {
        BigDecimal result = BigDecimal.ZERO;
        for (BigDecimal value : args) {
            if (value == null) continue;
            result = result.add(value);
        }
        return result;
    }

    public static BigDecimal plus(BigDecimal ... args) {
        return CsNumberUtils.add(args);
    }

    public static boolean isNumeric(String str) {
        if (StringUtils.isEmpty((Object)str)) {
            return false;
        }
        Pattern pattern = Pattern.compile("[0-9]*");
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }

    public static BigDecimal mul(BigDecimal bd, double m) {
        AssertUtil.isTrue(null != bd, "parameter is null");
        return bd != null && bd.compareTo(BigDecimal.ZERO) != 0 ? bd.multiply(new BigDecimal(m + "")) : BigDecimal.ZERO;
    }

    public static BigDecimal emptyAmount(Object amount) {
        return Objects.nonNull(amount) ? new BigDecimal(amount.toString()) : BigDecimal.ZERO;
    }

    public static BigDecimal mul(BigDecimal multiplier, String multiplicand, int decimal, int UPorDown) {
        if (StringUtils.isEmpty((Object)multiplicand) || multiplicand.equals("0")) {
            return BigDecimal.ZERO;
        }
        if (Objects.isNull(multiplier) || multiplier.doubleValue() == 0.0) {
            return BigDecimal.ZERO;
        }
        return multiplier.multiply(new BigDecimal(multiplicand)).setScale(decimal, UPorDown);
    }

    public static BigDecimal rounding(BigDecimal params) {
        if (Objects.isNull(params)) {
            return BigDecimal.ZERO;
        }
        if (params.toString().contains("-")) {
            double v = Math.abs(params.doubleValue());
            return new BigDecimal(v);
        }
        return params;
    }
}

