/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.statemachine.impl;

import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsInventoryExposedService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsDeliveryNoticeOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.statemachine.AbstractDocumentActionService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateCargoReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryNoticeOrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryNoticeOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="csDocumentDeliveryCancelService")
public class CsDocumentDeliveryCancelServiceImpl
extends AbstractDocumentActionService {
    private static Logger logger = LoggerFactory.getLogger(CsDocumentDeliveryCancelServiceImpl.class);
    @Resource
    private ICsInventoryExposedService csInventoryExposedService;
    @Resource
    private ICsDeliveryNoticeOrderQueryService csDeliveryNoticeOrderQueryService;

    @Override
    public void doAction(String documentNo, String preOrderNo) {
        logger.info("\u53d6\u6d88\u8ba2\u5355,\u5165\u53c2\uff1a[documentNo:{},preOrderNo{}]", (Object)documentNo, (Object)preOrderNo);
        CsInventoryOperateReqDto dto = this.structureParam(documentNo);
        logger.info("\u53d6\u6d88\u8ba2\u5355,\u91ca\u653e\u5e93\u5b58\u53c2\u6570\uff1a[dto\uff1a{}]", (Object)LogUtils.buildLogContent(dto));
        Boolean aBoolean = this.csInventoryExposedService.releaseInventory(dto, true);
        logger.info("\u53d6\u6d88\u8ba2\u5355,\u91ca\u653e\u5e93\u5b58\u5b8c\u6210\uff1a[aBoolean\uff1a{}]", (Object)aBoolean);
    }

    private CsInventoryOperateReqDto structureParam(String documentNo) {
        CsInventoryOperateReqDto dto = new CsInventoryOperateReqDto();
        CsDeliveryNoticeOrderRespDto deliveryNoticeOrderRespDto = this.csDeliveryNoticeOrderQueryService.queryByDocumentNo(documentNo);
        dto.setSourceNo(deliveryNoticeOrderRespDto.getPreOrderNo());
        dto.setSourceType(CsInventorySourceTypeEnum.IN_SALE_RELEASE.getCode());
        dto.setNegativeValidate(YesNoEnum.NO.getValue());
        ArrayList<CsInventoryOperateCargoReqDto> operateCargoReqDtoList = new ArrayList<CsInventoryOperateCargoReqDto>();
        for (CsDeliveryNoticeOrderDetailRespDto detailRespDto : deliveryNoticeOrderRespDto.getDeliveryNoticeOrderDetailRespDtoList()) {
            CsInventoryOperateCargoReqDto cargoReqDto = new CsInventoryOperateCargoReqDto();
            cargoReqDto.setCargoCode(detailRespDto.getCargoCode());
            cargoReqDto.setWarehouseCode(deliveryNoticeOrderRespDto.getWarehouseCode());
            cargoReqDto.setBatch(detailRespDto.getBatch());
            cargoReqDto.setActivityId(detailRespDto.getActivityId());
            cargoReqDto.setChangeInventory(detailRespDto.getWaitQuantity());
            operateCargoReqDtoList.add(cargoReqDto);
        }
        dto.setOperateCargoReqDtoList(operateCargoReqDtoList);
        return dto;
    }
}

