/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsInventoryPreemptionQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsInventoryPreemptionService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateCargoReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryPreemptionAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryPreemptionUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.domain.entity.IInventoryPreemptionDomain;
import com.yunxi.dg.base.center.inventory.eo.InventoryPreemptionEo;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="csInventoryPreemptionService")
public class CsInventoryPreemptionServiceImpl
implements ICsInventoryPreemptionService {
    private static Logger logger = LoggerFactory.getLogger(CsInventoryPreemptionServiceImpl.class);
    @Autowired
    IInventoryPreemptionDomain inventoryPreemptionDomain;
    @Autowired
    private ICsInventoryPreemptionQueryService csInventoryPreemptionQueryService;

    @Override
    public Long add(CsInventoryPreemptionAddReqDto addReqDto) {
        logger.info("\u6dfb\u52a0\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(addReqDto));
        AssertUtil.isTrue(addReqDto != null, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        InventoryPreemptionEo insertEo = new InventoryPreemptionEo();
        CubeBeanUtils.copyProperties((Object)insertEo, (Object)addReqDto, (String[])new String[0]);
        this.inventoryPreemptionDomain.insert((BaseEo)insertEo);
        return insertEo.getId();
    }

    @Override
    public void update(Long id, CsInventoryPreemptionUpdateReqDto updateReqDto) {
        logger.info("\u4fee\u6539\u53c2\u6570\uff1a[id:{}, {}]", (Object)id, (Object)LogUtils.buildLogContent(updateReqDto));
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(updateReqDto != null, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        InventoryPreemptionEo updateEo = new InventoryPreemptionEo();
        CubeBeanUtils.copyProperties((Object)updateEo, (Object)updateReqDto, (String[])new String[0]);
        updateEo.setId(id);
        this.inventoryPreemptionDomain.updateSelective((BaseEo)updateEo);
    }

    @Override
    public void delete(Long id) {
        logger.info("\u5220\u9664\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        InventoryPreemptionEo eo = this.csInventoryPreemptionQueryService.selectByPrimaryKey(id);
        AssertUtil.isTrue(eo != null, "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        this.inventoryPreemptionDomain.logicDeleteById(id);
    }

    @Override
    public void insertPreemptInventoryRecord(CsInventoryOperateReqDto inParamDto) {
        logger.info("inParamDto:{}", (Object)LogUtils.buildLogContent(inParamDto));
        ArrayList InventoryPreemptionEoList = Lists.newArrayList();
        for (CsInventoryOperateCargoReqDto cargoDto : inParamDto.getOperateCargoReqDtoList()) {
            InventoryPreemptionEo InventoryPreemptionEo2 = new InventoryPreemptionEo();
            InventoryPreemptionEo2.setSourceNo(inParamDto.getSourceNo());
            InventoryPreemptionEo2.setSourceType(inParamDto.getSourceType());
            InventoryPreemptionEo2.setWarehouseCode(cargoDto.getWarehouseCode());
            InventoryPreemptionEo2.setSkuCode(cargoDto.getCargoCode());
            InventoryPreemptionEo2.setBatch(cargoDto.getBatch());
            InventoryPreemptionEo2.setValid(CsValidFlagEnum.ENABLE.getCode());
            InventoryPreemptionEo2.setActivityId(cargoDto.getActivityId());
            InventoryPreemptionEo2.setActivityFlag(null != cargoDto.getActivityId() ? YesNoEnum.YES.getValue() : YesNoEnum.NO.getValue());
            BigDecimal preempt = cargoDto.getChangeInventory();
            preempt = preempt == null ? BigDecimal.ZERO : preempt;
            InventoryPreemptionEo2.setPreemptNum(preempt);
            InventoryPreemptionEoList.add(InventoryPreemptionEo2);
        }
        this.inventoryPreemptionDomain.insertBatch((List)InventoryPreemptionEoList);
    }

    @Override
    public void updateStatusDisable(List<InventoryPreemptionEo> preemptionEoList) {
        for (InventoryPreemptionEo preemptionEo : preemptionEoList) {
            preemptionEo.setValid(CsValidFlagEnum.DISABLE.getCode());
            preemptionEo.setDisplay(YesNoEnum.NO.getValue());
            this.inventoryPreemptionDomain.getMapper().updateById((BaseEo)preemptionEo);
        }
    }

    @Override
    public void updateStatusDisableBySourceNo(String sourceNo) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"source_no", (Object)sourceNo);
        wrapper.eq((Object)"valid", (Object)CsValidFlagEnum.ENABLE.getCode());
        wrapper.orderByDesc((Object)"create_time");
        List preemptionEoList = this.inventoryPreemptionDomain.getMapper().selectList((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)preemptionEoList)) {
            this.updateStatusDisable(preemptionEoList);
        }
    }
}

