/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.impl;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.commons.CsCommonService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.GenerateCodeUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.IGenerateCodeService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.SimpleGenerateCodeUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsReceiveResultOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsReceiveResultOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsReceiveResultOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsReceiveResultOrderDetailAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsReceiveResultOrderUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsGenerateCodeStrategyEnum;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDomain;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderEo;
import com.yunxi.dg.base.center.inventory.proxy.item.IItemSkuQueryApiProxy;
import com.yunxi.dg.base.commons.utils.RepeatFilter;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="csReceiveResultOrderService")
public class CsReceiveResultOrderServiceImpl
implements ICsReceiveResultOrderService {
    private static Logger logger = LoggerFactory.getLogger(CsReceiveResultOrderServiceImpl.class);
    @Autowired
    IReceiveDeliveryNoticeOrderDomain receiveDeliveryNoticeOrderDomain;
    @Resource
    IReceiveDeliveryResultOrderDomain receiveDeliveryResultOrderDomain;
    @Resource
    IReceiveDeliveryResultOrderDetailDomain receiveDeliveryResultOrderDetailDomain;
    @Resource
    ILogicWarehouseDomain logicWarehouseDomain;
    @Resource
    IInOutResultOrderDetailDomain inOutResultOrderDetailDomain;
    @Resource
    private CsCommonService csCommonService;
    @Autowired
    private ICsReceiveResultOrderQueryService csReceiveResultOrderQueryService;
    @Resource
    private SimpleGenerateCodeUtil simpleGenerateCodeUtil;
    @Resource
    private RepeatFilter repeatFilter;
    @Autowired
    IItemSkuQueryApiProxy itemSkuProxy;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long add(CsReceiveResultOrderAddReqDto addReqDto) {
        logger.info("\u751f\u6210\u6536\u8d27\u7ed3\u679c\u5355,\u5165\u53c2\uff1a[addReqDto:{}]", (Object)LogUtils.buildLogContent(addReqDto));
        ReceiveDeliveryResultOrderEo resultOrderEo = new ReceiveDeliveryResultOrderEo();
        CubeBeanUtils.copyProperties((Object)resultOrderEo, (Object)addReqDto, (String[])new String[0]);
        String orderNo = this.generateCode();
        resultOrderEo.setDocumentNo(orderNo);
        resultOrderEo.setOrderStatus(BaseOrderStatusEnum.RECEIVE_FINISH.getCode());
        resultOrderEo.setExtension(JSON.toJSONString((Object)addReqDto.getContactDto()));
        this.receiveDeliveryResultOrderDomain.insert((BaseEo)resultOrderEo);
        ArrayList detailEoList = Lists.newArrayList();
        for (CsReceiveResultOrderDetailAddReqDto detailAddReqDto : addReqDto.getDetailAddReqDtoList()) {
            ReceiveDeliveryResultOrderDetailEo detailEo = new ReceiveDeliveryResultOrderDetailEo();
            CubeBeanUtils.copyProperties((Object)detailEo, (Object)addReqDto, (String[])new String[]{"id"});
            CubeBeanUtils.copyProperties((Object)detailEo, (Object)detailAddReqDto, (String[])new String[]{"id"});
            detailEo.setDocumentNo(orderNo);
            detailEoList.add(detailEo);
        }
        this.receiveDeliveryResultOrderDetailDomain.insertBatch((List)detailEoList);
        logger.info("\u751f\u6210\u6536\u8d27\u7ed3\u679c\u5355,id\uff1a[id:{}]", (Object)resultOrderEo.getId());
        return resultOrderEo.getId();
    }

    @Override
    public void update(Long id, CsReceiveResultOrderUpdateReqDto updateReqDto) {
        logger.info("\u4fee\u6539\u53c2\u6570\uff1a[id:{}, {}]", (Object)id, (Object)LogUtils.buildLogContent(updateReqDto));
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(updateReqDto != null, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        ReceiveDeliveryResultOrderEo updateEo = new ReceiveDeliveryResultOrderEo();
        CubeBeanUtils.copyProperties((Object)updateEo, (Object)updateReqDto, (String[])new String[0]);
        updateEo.setId(id);
        this.receiveDeliveryResultOrderDomain.updateSelective((BaseEo)updateEo);
    }

    @Override
    public void delete(Long id) {
        logger.info("\u5220\u9664\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        this.csReceiveResultOrderQueryService.selectByPrimaryKey(id);
        this.receiveDeliveryNoticeOrderDomain.logicDeleteById(id);
    }

    private String generateCode() {
        IGenerateCodeService generateCodeService = GenerateCodeUtils.getStrategy(CsGenerateCodeStrategyEnum.RECEIVE_RESULT_ORDER.getCode());
        return generateCodeService.getCode();
    }
}

