/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.apiimpl.cs.order;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsDeliveryNoticeOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.mq.CreateDeliverInformOrderProcess2;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsDeliveryNoticeOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.DateUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsDeliveryNoticeOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsDeliveryNoticeOrderDetailAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsDeliveryNoticeOrderUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.basics.CsCommonBasicsOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.BusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderDeliveryRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.TradeItemRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.ContactDto;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="csDeliveryNoticeOrderApi")
public class CsDeliveryNoticeOrderApiImpl
implements ICsDeliveryNoticeOrderApi {
    private static Logger logger = LoggerFactory.getLogger(CsDeliveryNoticeOrderApiImpl.class);
    @Resource
    private ICsDeliveryNoticeOrderService csDeliveryNoticeOrderService;
    @Resource
    private CreateDeliverInformOrderProcess2 createDeliverInformOrderProcess2;
    @Resource
    private ICsOrderQueryService csOrderQueryService;

    public RestResponse<Long> add(CsDeliveryNoticeOrderAddReqDto addReqDto) {
        logger.info("\u6dfb\u52a0\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(addReqDto));
        return new RestResponse((Object)this.csDeliveryNoticeOrderService.add(addReqDto));
    }

    public RestResponse<Void> update(Long id, CsDeliveryNoticeOrderUpdateReqDto updateReqDto) {
        logger.info("\u4fee\u6539\u53c2\u6570\uff1a[id:{}, {}]", (Object)id, (Object)LogUtils.buildLogContent(updateReqDto));
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        this.csDeliveryNoticeOrderService.update(id, updateReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> delete(Long id) {
        logger.info("\u5220\u9664\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        this.csDeliveryNoticeOrderService.delete(id);
        return RestResponse.VOID;
    }

    public RestResponse<Void> updateOrderStatus(String preOrderNo, String action) {
        this.csDeliveryNoticeOrderService.updateOrderStatus(preOrderNo, action);
        return RestResponse.VOID;
    }

    public RestResponse<Void> onlyUpdateDocumentStatus(String preOrderNo, String orderStatus) {
        this.csDeliveryNoticeOrderService.onlyUpdateDocumentStatus(preOrderNo, orderStatus);
        return RestResponse.VOID;
    }

    public RestResponse<Void> CreateDeliverInformOrderProcess2(MessageVo messageVo) {
        MessageResponse process = this.createDeliverInformOrderProcess2.process(messageVo);
        AssertUtil.isTrue(MessageResponse.SUCCESS.equals(process), process.getResultMsg());
        return RestResponse.VOID;
    }

    public RestResponse<String> updateDetailBatchByPreOrderNo(String preOrderNo) {
        OrderDetailRespDto orderDetailRespDto = this.csOrderQueryService.queryByOrderNo(preOrderNo);
        String desc = this.csDeliveryNoticeOrderService.updateDetailBatch(orderDetailRespDto);
        return new RestResponse((Object)desc);
    }

    public RestResponse<Integer> updateDetailBatch(CsInventoryOperateReqDto csInventoryOperateReqDto) {
        Integer num = this.csDeliveryNoticeOrderService.updateDetailBatch(csInventoryOperateReqDto);
        return new RestResponse((Object)num);
    }

    public RestResponse<Boolean> createDeliveryByOrderNo(String orderNo) {
        logger.info("\u6839\u636e\u8ba2\u5355\u53f7\u521b\u5efa\u53d1\u8d27\u901a\u77e5\u5355,\u5165\u53c2\uff1a{}", (Object)orderNo);
        OrderDetailRespDto orderDto = this.csOrderQueryService.queryByOrderNo(orderNo);
        logger.info("\u6839\u636e\u8ba2\u5355\u53f7\u521b\u5efa\u53d1\u8d27\u901a\u77e5\u5355,\u8ba2\u5355\u8be6\u60c5\uff1a{}", (Object)LogUtils.buildLogContent(orderDto));
        CsDeliveryNoticeOrderAddReqDto addReqDto = this.getCsDeliveryNoticeOrderAddReqDto(orderDto);
        logger.info("\u6839\u636e\u8ba2\u5355\u53f7\u521b\u5efa\u53d1\u8d27\u901a\u77e5\u5355,\u751f\u6210\u53d1\u8d27\u901a\u77e5\u5355\u5165\u53c2\uff1a{}", (Object)LogUtils.buildLogContent(addReqDto));
        Long id = this.csDeliveryNoticeOrderService.add(addReqDto);
        logger.info("\u6839\u636e\u8ba2\u5355\u53f7\u521b\u5efa\u53d1\u8d27\u901a\u77e5\u5355,\u751f\u6210\u53d1\u8d27\u901a\u77e5\u5355id\uff1a{}", (Object)id);
        return new RestResponse((Object)true);
    }

    public RestResponse<Boolean> batchUpdateNoticeStatusPass(List<String> preOrderNoList) {
        Boolean statusPass = this.csDeliveryNoticeOrderService.batchUpdateNoticeStatusPass(preOrderNoList);
        return new RestResponse((Object)statusPass);
    }

    public RestResponse<Boolean> batchUpdateNoticeStatusNoPass(List<String> preOrderNoList) {
        Boolean statusPass = this.csDeliveryNoticeOrderService.batchUpdateNoticeStatusNoPass(preOrderNoList);
        return new RestResponse((Object)statusPass);
    }

    public RestResponse<Long> addBaseOrder(CsCommonBasicsOrderReqDto addReqDto) {
        return null;
    }

    public RestResponse<Boolean> cancelByDocumentNo(String cancelByDocumentNo) {
        return null;
    }

    public RestResponse<String> finishByDocumentNo(String documentNo) {
        return null;
    }

    private CsDeliveryNoticeOrderAddReqDto getCsDeliveryNoticeOrderAddReqDto(OrderDetailRespDto orderDto) {
        OrderDeliveryRespDto orderDelivery = new OrderDeliveryRespDto();
        if (ObjectUtil.isNotEmpty((Object)orderDto.getDeliveryAddress())) {
            orderDelivery = (OrderDeliveryRespDto)JSONObject.parseObject((String)orderDto.getDeliveryAddress(), OrderDeliveryRespDto.class);
        }
        CsDeliveryNoticeOrderAddReqDto addReqDto = new CsDeliveryNoticeOrderAddReqDto();
        addReqDto.setPreOrderNo(orderDto.getOrderNo());
        addReqDto.setExternalOrderNo(orderDto.getThirdOrderNo());
        addReqDto.setWarehouseCode(orderDto.getWarehouseCode());
        addReqDto.setOrganizationId(orderDto.getOrganizationId());
        addReqDto.setOrganizationName(orderDto.getOrganizationName());
        ContactDto contactDto = new ContactDto();
        contactDto.setAddress(orderDelivery.getAddress());
        contactDto.setPlanTime(DateUtils.formatDate(orderDto.getPlaceTime(), "yyyy-MM-dd HH:mm:ss"));
        contactDto.setReciveName(orderDelivery.getDeliveryName());
        contactDto.setRecivePhone(orderDelivery.getDeliveryMobile());
        ArrayList detailAddReqDtoList = Lists.newArrayList();
        BigDecimal totalQuantity = BigDecimal.ZERO;
        for (TradeItemRespDto item : orderDto.getOrderItems()) {
            CsDeliveryNoticeOrderDetailAddReqDto dto = new CsDeliveryNoticeOrderDetailAddReqDto();
            dto.setBatch(item.getBatchNo());
            dto.setCargoCode(item.getCargoSerial());
            dto.setPlanQuantity(BigDecimal.valueOf(item.getItemNum().intValue()));
            try {
                dto.setActivityId(item.getCombinedPackageActivityId());
            }
            catch (Exception ex) {
                logger.error("\u5546\u54c1\u53c2\u4e0e\u6d3b\u52a8id\u5f02\u5e38\uff0c\u4e0d\u8d4b\u503c\uff1bactivityId:{}", (Object)item.getCombinedPackageActivityId());
            }
            totalQuantity = totalQuantity.add(dto.getPlanQuantity());
            dto.setTradeOrderItemId(item.getId());
            detailAddReqDtoList.add(dto);
        }
        addReqDto.setTotalQuantity(totalQuantity);
        addReqDto.setDetailAddReqDtoList((List)detailAddReqDtoList);
        addReqDto.setContactDto(contactDto);
        addReqDto.setBusinessType(BusinessTypeEnum.INVOKE_CUBE_ORDER_TYPE_SALES_ISSUE.getCode());
        logger.info("----->\u521b\u5efa\u53d1\u8d27\u901a\u77e5\u5355\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)addReqDto));
        return addReqDto;
    }
}

