/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.business;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsStockEntryOrderReqDto;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsStockOutOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.business.AbstractCsBusinessOrderCallBackService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.business.ICsBusinessOrderCallBackService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.bd.sap.PushItemReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.bd.sap.PushStorageOrderHeadReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.bd.sap.PushStorageOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsOrderAfterSaleDetailMessageDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsOrderAfterSaleMessageDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOrderBusinessCallBackContext;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsInOutResultDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsInOutResultRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.SapCenterTypeEnum;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.basicdata.enums.PcpBasicTradeBusinessTypeEnum;
import com.yunxi.dg.base.center.inventory.dto.domain.CsWmsShippingInfoReqDto;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="Csorder_after_saleBusinessOrderCallBackService")
public class CsOrderAfterSaleCallBackServiceImpl
extends AbstractCsBusinessOrderCallBackService
implements ICsBusinessOrderCallBackService {
    private static final Logger log = LoggerFactory.getLogger(CsOrderAfterSaleCallBackServiceImpl.class);
    @Resource
    private ICommonsMqService mqService;

    @Override
    public String getStrategy() {
        return this.getPrefix() + "order_after_sale";
    }

    @Override
    public Boolean deliveryReceiveNoticeOrderCallBack(CsOrderBusinessCallBackContext callBackContext) {
        return null;
    }

    @Override
    public Boolean inOutNoticeOrderCallBack(CsOrderBusinessCallBackContext callBackContext) {
        return null;
    }

    @Override
    public Boolean inOutResultOrderCallBack(CsOrderBusinessCallBackContext callBackContext) {
        log.info("CsOrderAfterSaleCallBackServiceImpl#inOutResultOrderCallBack,callBackContext:{}", (Object)LogUtils.buildLogContent(callBackContext));
        return Boolean.TRUE;
    }

    @Override
    public Boolean deliveryReceiveResultOrderCallBack(CsOrderBusinessCallBackContext callBackContext) {
        log.info("CsOrderAfterSaleCallBackServiceImpl#deliveryReceiveResultOrderCallBack,callBackContext:{}", (Object)LogUtils.buildLogContent(callBackContext));
        this.pushReceiveResultOrderMsg(callBackContext);
        Boolean orderAfterSaleFlagCommon = callBackContext.getOrderAfterSaleFlagCommon();
        if (!orderAfterSaleFlagCommon.booleanValue()) {
            return Boolean.TRUE;
        }
        this.noticeOrderAfterSale(callBackContext);
        return Boolean.TRUE;
    }

    private void pushReceiveResultOrderMsg(CsOrderBusinessCallBackContext callBackContext) {
        log.info("pushReceiveResultOrderMsg==>callBackContext:{}", (Object)LogUtils.buildLogContent(callBackContext));
        CsInOutResultRespDto csInOutResultRespDto = callBackContext.getCsInOutResultRespDto();
        List detailList = csInOutResultRespDto.getInOutResultDetailRespDtoList();
        log.info("\u9000\u8d27\u9000\u6b3e\u56de\u8c03,\u8fdb\u5165pushDeliveryResultOrder\u65b9\u6cd5\uff0ctransferOrderNo:{}", (Object)callBackContext.getRelevanceNo());
        List<String> notSaleBusinessTypes = Arrays.asList(PcpBasicTradeBusinessTypeEnum.REFUND_ORDER_TRIAL_PRODUCTION.getCode(), PcpBasicTradeBusinessTypeEnum.REFUND_ORDER_DEMONSTRATE_RECIPIENTS.getCode(), PcpBasicTradeBusinessTypeEnum.REFUND_ORDER_PACKAGING_RECIPIENTS.getCode(), PcpBasicTradeBusinessTypeEnum.REFUND_ORDER_DEVELOPMENT_ACQUISITION.getCode(), PcpBasicTradeBusinessTypeEnum.REFUND_ORDER_MAINTENANCE_MATERIALS.getCode());
        if (notSaleBusinessTypes.contains(csInOutResultRespDto.getDisplayBusinessType())) {
            log.info("\u9000\u8d27\u9000\u6b3e\u56de\u8c03,\u63a8\u9001\u975e\u9500\u552e\u51fa\u5e93,inFlag:{},transferOrderNo:{}", (Object)callBackContext.getInFlag(), (Object)csInOutResultRespDto.getRelevanceNo());
            if (callBackContext.getInFlag().booleanValue()) {
                this.pushOrder(callBackContext.getOutResultOrderId().toString(), csInOutResultRespDto, detailList, "PUSH_RECEIVED_RESULT_ORDER", csInOutResultRespDto.getInLogicWarehouseCode(), "pushReceiveResultOrder\u63a8\u9001\u975e\u9500\u552e\u51fa\u5e93\u5355mq\u6d88\u606f", callBackContext.getShopCode());
            }
        }
    }

    private void pushOrder(String id, CsInOutResultRespDto csDeliveryReceiveResultRespDto, List<CsInOutResultDetailRespDto> detailList, String tag, String warehouseCode, String message, String shopCode) {
        log.info("\u9000\u8d27\u9000\u6b3e\u56de\u8c03,\u8fdb\u5165pushOrder\u65b9\u6cd5,id:{},transferOrder\uff1a{},shopCode:{}", new Object[]{id, csDeliveryReceiveResultRespDto.getRelevanceNo(), shopCode});
        PushStorageOrderHeadReqDto head = new PushStorageOrderHeadReqDto();
        head.setId(id);
        head.setCreateDate(DateUtil.formatDateTime((Date)csDeliveryReceiveResultRespDto.getCreateTime()));
        head.setSapMoveType(SapCenterTypeEnum.getSapType((String)csDeliveryReceiveResultRespDto.getDisplayBusinessType()));
        head.setKostl("C10005021");
        String factoryType = "1220";
        head.setFactoryType(factoryType);
        head.setRefNo(csDeliveryReceiveResultRespDto.getDocumentNo());
        head.setTransferOrderNo(csDeliveryReceiveResultRespDto.getRelevanceNo());
        head.setSrcOrderNo(csDeliveryReceiveResultRespDto.getExternalOrderNo());
        ArrayList<PushItemReqDto> itemReqDtoList = new ArrayList<PushItemReqDto>(detailList.size());
        DecimalFormat df = new DecimalFormat("#0.00");
        for (int i = 0; i < detailList.size(); ++i) {
            PushItemReqDto sapItemReqDto = new PushItemReqDto();
            sapItemReqDto.setCode(detailList.get(i).getSkuCode());
            sapItemReqDto.setRowNum(String.valueOf(i + 1));
            sapItemReqDto.setWarehouseCode(warehouseCode);
            sapItemReqDto.setNum(df.format(detailList.get(i).getQuantity()));
            sapItemReqDto.setFactoryType(factoryType);
            sapItemReqDto.setMoveReason("");
            itemReqDtoList.add(sapItemReqDto);
        }
        PushStorageOrderReqDto sapStorageOrderReqDto = new PushStorageOrderReqDto();
        sapStorageOrderReqDto.setStorageOrderHearReqDto(head);
        sapStorageOrderReqDto.setItemReqDtoList(itemReqDtoList);
        log.info("\u9000\u8d27\u9000\u6b3e\u56de\u8c03,pushOrder\u63a8\u9001\u975e\u9500\u552e\u51fa\u5e93\u5355mq\u6d88\u606f,transferOrder\uff1a{}", (Object)csDeliveryReceiveResultRespDto.getRelevanceNo());
        this.mqService.sendSingleMessage("SINGLE_TOPIC", tag, (Object)JSON.toJSONString((Object)sapStorageOrderReqDto));
    }

    private void noticeOrderAfterSale(CsOrderBusinessCallBackContext callBackContext) {
        Boolean portionFlag = callBackContext.getPortionFlag();
        CsInOutResultRespDto csInOutResultRespDto = callBackContext.getCsInOutResultRespDto();
        log.info("noticeOrderAfterSale==>\u552e\u540e\u9000\u8d27\u9000\u6b3e,wms\u56de\u4f20\u901a\u77e5\u552e\u540e,csInOutResultRespDto:{},portionFlag:{}", (Object)LogUtils.buildLogContent(csInOutResultRespDto), (Object)portionFlag);
        CsOrderAfterSaleMessageDto csOrderAfterSaleMessageDto = new CsOrderAfterSaleMessageDto();
        List inOutResultDetailRespDtoList = csInOutResultRespDto.getInOutResultDetailRespDtoList();
        ArrayList deliveryDetailMessageDtoList = Lists.newArrayList();
        for (CsInOutResultDetailRespDto detailRespDto : inOutResultDetailRespDtoList) {
            CsOrderAfterSaleDetailMessageDto orderAfterSaleDetailMessageDto = new CsOrderAfterSaleDetailMessageDto();
            orderAfterSaleDetailMessageDto.setOrderNo(csInOutResultRespDto.getRelevanceNo());
            orderAfterSaleDetailMessageDto.setInQuantity(detailRespDto.getDoneQuantity());
            orderAfterSaleDetailMessageDto.setSkuCode(detailRespDto.getSkuCode());
            orderAfterSaleDetailMessageDto.setTradeOrderItemId(detailRespDto.getTradeOrderItemId());
            deliveryDetailMessageDtoList.add(orderAfterSaleDetailMessageDto);
        }
        String shippingJson = csInOutResultRespDto.getShippingJson();
        log.info("noticeOrderAfterSale==>\u552e\u540e\u9000\u8d27\u9000\u6b3e,wms\u56de\u4f20\u901a\u77e5\u552e\u540e,shippingJson:{}", (Object)LogUtils.buildLogContent(shippingJson));
        if (StringUtils.isNotBlank((CharSequence)shippingJson)) {
            try {
                List csWmsShippingInfoReqDtoList = JSON.parseArray((String)shippingJson, CsWmsShippingInfoReqDto.class);
                log.info("noticeOrderAfterSale==>\u552e\u540e\u9000\u8d27\u9000\u6b3e,wms\u56de\u4f20\u901a\u77e5\u552e\u540e,csWmsShippingInfoReqDtoList:{}", (Object)LogUtils.buildLogContent(csWmsShippingInfoReqDtoList));
                csOrderAfterSaleMessageDto.setShippingInfoList(csWmsShippingInfoReqDtoList);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        csOrderAfterSaleMessageDto.setPortionFlag(portionFlag);
        csOrderAfterSaleMessageDto.setOrderAfterSaleDetailMessageDtoList((List)deliveryDetailMessageDtoList);
        csOrderAfterSaleMessageDto.setOrderNo(callBackContext.getRelevanceNo());
        csOrderAfterSaleMessageDto.setInResultDocumentNo(csInOutResultRespDto.getDocumentNo());
        MessageVo messageVo = new MessageVo();
        messageVo.setData((Object)csOrderAfterSaleMessageDto);
        log.info("noticeOrderAfterSale==>\u552e\u540e\u9000\u8d27\u9000\u6b3e,wms\u56de\u4f20\u901a\u77e5\u552e\u540e,tag:{},messageVo:{}", (Object)"ORDER_AFTER_SALE_WMS_SEND_BACK_TAG", (Object)LogUtils.buildLogContent(messageVo));
        this.mqService.sendSingleMessage("ORDER_AFTER_SALE_WMS_SEND_BACK_TAG", (Object)messageVo);
    }

    @Override
    public Boolean relieveOverchargeCallBack(CsOrderBusinessCallBackContext callBackContext) {
        return null;
    }

    @Override
    public Boolean overchargeAdjustCallBack(CsOrderBusinessCallBackContext callBackContext) {
        return null;
    }

    @Override
    public Boolean wmsCancel(CsOrderBusinessCallBackContext callBackContext) {
        return true;
    }

    @Override
    public void getContactsInfo(WmsStockOutOrderReqDto dto) {
    }

    @Override
    public void getContactsInfo(WmsStockEntryOrderReqDto dto) {
    }

    @Override
    public void closeOrderStatus(String relevanceNo) {
    }
}

