/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsPhysicsWarehouseExposedService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.IdUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.ValidationUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsPhysicsWarehouseExposedAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPhysicsWarehouseStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.yunxi.dg.base.center.enums.CsWarehouseClassifyEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.IPhysicsWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IWarehouseAddressDomain;
import com.yunxi.dg.base.center.inventory.eo.PhysicsWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.WarehouseAddressEo;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="csPhysicsWarehouseExposedServiceImpl")
public class CsPhysicsWarehouseExposedServiceImpl
implements ICsPhysicsWarehouseExposedService {
    private static Logger logger = LoggerFactory.getLogger(CsPhysicsWarehouseExposedServiceImpl.class);
    @Autowired
    IPhysicsWarehouseDomain physicsWarehouseDomain;
    @Autowired
    IWarehouseAddressDomain warehouseAddressDomain;
    @Resource
    private IContext context;

    @Override
    public Long addPhysicsWarehouse(CsPhysicsWarehouseExposedAddReqDto csPhysicsWarehouseExposedAddReqDto) {
        logger.info("addPhysicsWarehouse==>\u65b0\u589e\u7269\u7406\u4ed3\u4ed3\u5e93,csPhysicsWarehouseExposedAddReqDto:{}", (Object)LogUtils.buildLogContent(csPhysicsWarehouseExposedAddReqDto));
        this.checkParams(csPhysicsWarehouseExposedAddReqDto);
        this.checkWarehouseCode(csPhysicsWarehouseExposedAddReqDto);
        PhysicsWarehouseEo csPhysicsWarehouseEo = new PhysicsWarehouseEo();
        Long physicsWarehouseId = IdUtils.getId();
        csPhysicsWarehouseEo.setId(physicsWarehouseId);
        CubeBeanUtils.copyProperties((Object)csPhysicsWarehouseEo, (Object)csPhysicsWarehouseExposedAddReqDto, (String[])new String[0]);
        if (StringUtils.isNotBlank((CharSequence)csPhysicsWarehouseExposedAddReqDto.getRdcFlag())) {
            csPhysicsWarehouseEo.setRdcFlag(Integer.valueOf(csPhysicsWarehouseExposedAddReqDto.getRdcFlag()));
        }
        logger.info("addPhysicsWarehouse==>\u65b0\u589e\u7269\u7406\u4ed3\u4ed3\u5e93,csPhysicsWarehouseEo:{}", (Object)LogUtils.buildLogContent(csPhysicsWarehouseEo));
        this.physicsWarehouseDomain.insert((BaseEo)csPhysicsWarehouseEo);
        WarehouseAddressEo warehouseAddressEo = new WarehouseAddressEo();
        CubeBeanUtils.copyProperties((Object)warehouseAddressEo, (Object)csPhysicsWarehouseExposedAddReqDto, (String[])new String[0]);
        warehouseAddressEo.setWarehouseId(physicsWarehouseId);
        warehouseAddressEo.setValidFlag(CsValidFlagEnum.ENABLE.getCode());
        warehouseAddressEo.setWarehouseClassify(CsWarehouseClassifyEnum.PHYSICS.getCode());
        logger.info("addPhysicsWarehouse==>\u65b0\u589e\u7269\u7406\u4ed3\u4ed3\u5e93,warehouseAddressEo:{}", (Object)LogUtils.buildLogContent(warehouseAddressEo));
        this.warehouseAddressDomain.insert((BaseEo)warehouseAddressEo);
        return physicsWarehouseId;
    }

    private void checkWarehouseCode(CsPhysicsWarehouseExposedAddReqDto csPhysicsWarehouseExposedAddReqDto) {
        String warehouseCode = csPhysicsWarehouseExposedAddReqDto.getWarehouseCode();
        QueryWrapper physicsWrapper = new QueryWrapper();
        physicsWrapper.eq((Object)"warehouse_code", (Object)warehouseCode);
        List csPhysicsWarehouseEoList = this.physicsWarehouseDomain.getMapper().selectList((Wrapper)physicsWrapper);
        if (CollectionUtils.isEmpty((Collection)csPhysicsWarehouseEoList)) {
            return;
        }
        Long updateId = csPhysicsWarehouseExposedAddReqDto.getId();
        if (null != updateId) {
            for (PhysicsWarehouseEo eo : csPhysicsWarehouseEoList) {
                Long existId = eo.getId();
                if (null == existId || existId.equals(updateId)) continue;
                throw new BizException("\u7f16\u7801\u5df2\u5b58\u5728");
            }
        } else {
            throw new BizException("\u4ed3\u5e93\u7f16\u7801\u5df2\u5b58\u5728");
        }
    }

    @Override
    public Boolean updatePhysicsWarehouse(CsPhysicsWarehouseExposedAddReqDto csPhysicsWarehouseExposedAddReqDto) {
        int updateWarehouseFlag;
        logger.info("updatePhysicsWarehouse==>\u7f16\u8f91\u7269\u7406\u4ed3\u4ed3\u5e93,csPhysicsWarehouseExposedAddReqDto:{}", (Object)LogUtils.buildLogContent(csPhysicsWarehouseExposedAddReqDto));
        this.checkParams(csPhysicsWarehouseExposedAddReqDto);
        this.checkWarehouseCode(csPhysicsWarehouseExposedAddReqDto);
        Long physicsWarehouseId = csPhysicsWarehouseExposedAddReqDto.getId();
        AssertUtil.isTrue(null != physicsWarehouseId, "\u4ed3\u5e93ID\u4e0d\u80fd\u4e3a\u7a7a");
        PhysicsWarehouseEo originalEo = (PhysicsWarehouseEo)this.physicsWarehouseDomain.getMapper().selectById((Serializable)physicsWarehouseId);
        AssertUtil.isTrue(null != originalEo, "\u67e5\u8be2\u4e0d\u5230\u4ed3\u5e93\u4fe1\u606f");
        CubeBeanUtils.copyProperties((Object)originalEo, (Object)csPhysicsWarehouseExposedAddReqDto, (String[])new String[0]);
        QueryWrapper updateWrapper = new QueryWrapper();
        updateWrapper.eq((Object)"id", (Object)physicsWarehouseId);
        logger.info("updatePhysicsWarehouse==>\u7f16\u8f91\u7269\u7406\u4ed3\u4ed3\u5e93,originalEo:{}", (Object)LogUtils.buildLogContent(originalEo));
        if (StringUtils.isNotBlank((CharSequence)csPhysicsWarehouseExposedAddReqDto.getRdcFlag())) {
            originalEo.setRdcFlag(Integer.valueOf(csPhysicsWarehouseExposedAddReqDto.getRdcFlag()));
        }
        if ((updateWarehouseFlag = this.physicsWarehouseDomain.getMapper().update((Object)originalEo, (Wrapper)updateWrapper)) <= 0) {
            return false;
        }
        WarehouseAddressEo updateAddressEo = new WarehouseAddressEo();
        updateAddressEo.setValidFlag(CsValidFlagEnum.DISABLE.getCode());
        QueryWrapper updateAddressEoWrapper = new QueryWrapper();
        updateAddressEoWrapper.eq((Object)"warehouse_id", (Object)physicsWarehouseId);
        updateAddressEoWrapper.eq((Object)"warehouse_classify", (Object)CsWarehouseClassifyEnum.PHYSICS.getCode());
        this.warehouseAddressDomain.getMapper().update((Object)updateAddressEo, (Wrapper)updateAddressEoWrapper);
        WarehouseAddressEo warehouseAddressEo = new WarehouseAddressEo();
        CubeBeanUtils.copyProperties((Object)warehouseAddressEo, (Object)csPhysicsWarehouseExposedAddReqDto, (String[])new String[0]);
        warehouseAddressEo.setId(IdUtils.getId());
        warehouseAddressEo.setWarehouseId(physicsWarehouseId);
        warehouseAddressEo.setValidFlag(CsValidFlagEnum.ENABLE.getCode());
        warehouseAddressEo.setWarehouseClassify(CsWarehouseClassifyEnum.PHYSICS.getCode());
        logger.info("updatePhysicsWarehouse==>\u7f16\u8f91\u7269\u7406\u4ed3\u4ed3\u5e93,warehouseAddressEo:{}", (Object)LogUtils.buildLogContent(warehouseAddressEo));
        this.warehouseAddressDomain.insert((BaseEo)warehouseAddressEo);
        return true;
    }

    private void checkParams(CsPhysicsWarehouseExposedAddReqDto csPhysicsWarehouseExposedAddReqDto) {
        AssertUtil.isTrue(null != csPhysicsWarehouseExposedAddReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)csPhysicsWarehouseExposedAddReqDto.getWarehouseCode()), "\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)csPhysicsWarehouseExposedAddReqDto.getWarehouseName()), "\u4ed3\u5e93\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        String warehouseStatus = csPhysicsWarehouseExposedAddReqDto.getWarehouseStatus();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)warehouseStatus) && null != CsPhysicsWarehouseStatusEnum.getByCode((String)warehouseStatus), "\u4ed3\u5e93\u72b6\u6001\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)csPhysicsWarehouseExposedAddReqDto.getRdcFlag()) && (YesNoEnum.YES.getValue().equals(Integer.valueOf(csPhysicsWarehouseExposedAddReqDto.getRdcFlag())) || YesNoEnum.NO.getValue().equals(Integer.valueOf(csPhysicsWarehouseExposedAddReqDto.getRdcFlag()))), "\u662f\u5426RDC\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)csPhysicsWarehouseExposedAddReqDto.getContacts()), "\u8054\u7cfb\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)csPhysicsWarehouseExposedAddReqDto.getPhone()) && ValidationUtils.checkMobile(csPhysicsWarehouseExposedAddReqDto.getPhone()), "\u8054\u7cfb\u7535\u8bdd\u6709\u8bef");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)csPhysicsWarehouseExposedAddReqDto.getProvince()) && StringUtils.isNotBlank((CharSequence)csPhysicsWarehouseExposedAddReqDto.getProvinceCode()), "\u7701\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)csPhysicsWarehouseExposedAddReqDto.getCity()) && StringUtils.isNotBlank((CharSequence)csPhysicsWarehouseExposedAddReqDto.getCityCode()), "\u5e02\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)csPhysicsWarehouseExposedAddReqDto.getDetailAddress()), "\u8be6\u7ec6\u5730\u5740\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)csPhysicsWarehouseExposedAddReqDto.getLatitude()), "\u7eac\u5ea6\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)csPhysicsWarehouseExposedAddReqDto.getLongitude()), "\u7ecf\u5ea6\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyPhysicalWarehouseStatus(String ids, String status) {
        String[] idsString = ids.split(",");
        Long[] updateIds = new Long[idsString.length];
        for (int i = 0; i < idsString.length; ++i) {
            updateIds[i] = Long.valueOf(idsString[i]);
        }
        String updateStatus = "disable";
        if (status.equals("enable")) {
            updateStatus = "enable";
        }
        String updatePerson = null == this.context.userName() ? "-1" : this.context.userName();
        Date updateTime = new Date();
        this.physicsWarehouseDomain.batchUpdateStatusByIds(updateIds, updateStatus, updatePerson, updateTime);
    }
}

