/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl.inventory;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.com.google.common.base.Strings;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.CargoStorageDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.CargoStorageExtDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.dto.CloudInventoryDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.enus.OrderTypeEnu;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.basics.CsInventoryStrategyUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.basics.ICsInventoryBasicsService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.commons.CsCommonService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsInventoryExposedService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.inventory.ITcbjInventoryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.order.ITcbjBaseService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.InventoryActivityDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.InventoryActivityLogDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.inventory.CsActivityInventoryDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.log.CsActivityInventoryLogDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.CargoEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.CargoOccupyEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.DRAOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.InventoryActivityEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.InventoryActivityLogEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.OptionLogEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsActivityInventoryEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.log.CsActivityInventoryLogEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.CargoMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.InventoryActivityMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.OptionLogMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.TcbjCargoOccupyMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.TcbjDRAOrderCargoMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.TcbjDRAOrderMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.inventory.CsActivityInventoryMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.constant.OrderStatus;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjAvilableReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjCombinationActBacktrackReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjCombinationActDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjCombinationActReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjCombinationBatchReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjCompareReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjInventoryActLogReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjInventoryActReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjInventoryLogReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjInventoryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjProOccupyItemReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjProOccupyListReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjProOccupyReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.TbjcInventoryActLogRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.TcbjAvilableRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.TcbjInventoryActDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.TcbjInventoryActRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.TcbjInventoryLogRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.TcbjInventoryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.TcbjProOccupyRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.OptionLogReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.OrderCargoBatchReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics.CsInventoryInOutBasicsCargoDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics.CsInventoryInOutBasicsDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateCargoReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.warehouse.ItemInventoryQueryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsActivityInventoryStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryInOutEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.domain.entity.IInventoryPreemptionDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicInventoryDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicInventoryTotalDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.dto.calc.PreemptDto;
import com.yunxi.dg.base.center.inventory.dto.calc.ReleasePreemptDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDetailDto;
import com.yunxi.dg.base.center.inventory.eo.InventoryPreemptionEo;
import com.yunxi.dg.base.center.inventory.eo.LogicInventoryEo;
import com.yunxi.dg.base.center.inventory.eo.LogicInventoryTotalEo;
import com.yunxi.dg.base.center.inventory.service.calc.ICalcInventoryService;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TcbjInventoryServiceImpl
implements ITcbjInventoryService {
    private static final Logger logger = LoggerFactory.getLogger(TcbjInventoryServiceImpl.class);
    private final String COMBINATION_ACTIVITY = "COMBINATION_ACTIVITY";
    @Resource
    private TcbjCargoOccupyMapper tcbjCargoOccupyMapper;
    @Resource
    private ITcbjBaseService tcbjBaseService;
    @Autowired
    private ICustomerExtQueryApi customerExtQueryApi;
    @Autowired
    private OptionLogMapper optionLogMapper;
    @Resource
    private IContext context;
    @Resource
    private CargoMapper cargoMapper;
    @Autowired
    private TcbjDRAOrderMapper tcbjDRAOrderMapper;
    @Autowired
    private TcbjDRAOrderCargoMapper tcbjDRAOrderCargoMapper;
    @Resource
    private ICacheService cacheService;
    @Resource
    private ILockService lockService;
    @Autowired
    private InventoryActivityDas inventoryActivityDas;
    @Autowired
    private InventoryActivityMapper inventoryActivityMapper;
    @Autowired
    private InventoryActivityLogDas inventoryActivityLogDas;
    @Autowired
    private ILogicInventoryTotalDomain logicInventoryTotalDomain;
    @Autowired
    private ILogicInventoryDomain logicInventoryDomain;
    @Autowired
    private IInventoryPreemptionDomain inventoryPreemptionDomain;
    @Autowired
    private CsActivityInventoryDas csActivityInventoryDas;
    @Autowired
    private CsActivityInventoryMapper csActivityInventoryMapper;
    @Autowired
    private CsActivityInventoryLogDas csActivityInventoryLogDas;
    @Autowired
    private ILogicWarehouseDomain logicWarehouseDomain;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Resource
    private ICsInventoryExposedService inventoryExposedService;
    @Resource
    private CsCommonService csCommonService;
    @Resource
    private ICalcInventoryService calcInventoryService;

    @Override
    public boolean checkOption(String no, String requestId, String status) {
        QueryWrapper objectQueryWrapper = new QueryWrapper();
        objectQueryWrapper.eq((Object)"no", (Object)no);
        objectQueryWrapper.eq((Object)"status", (Object)status);
        OptionLogEo optionLogEo = (OptionLogEo)this.optionLogMapper.selectOne((Wrapper)objectQueryWrapper);
        return optionLogEo != null;
    }

    @Override
    public boolean updateOptionLog(OptionLogReqDto reqDto) {
        UpdateWrapper objectUpdateWrapper = new UpdateWrapper();
        QueryWrapper objectQueryWrapper = new QueryWrapper();
        objectQueryWrapper.eq((Object)"no", (Object)reqDto.getNo());
        OptionLogEo queryLogEo = (OptionLogEo)this.optionLogMapper.selectOne((Wrapper)objectQueryWrapper);
        if (queryLogEo == null) {
            OptionLogEo optionLogEo = new OptionLogEo();
            BeanUtils.copyProperties((Object)reqDto, (Object)optionLogEo);
            optionLogEo.setStatus(reqDto.getStatus());
            optionLogEo.setRequestId(reqDto.getRequestId());
            int insert = this.optionLogMapper.insert((Object)optionLogEo);
            return insert > 0;
        }
        OptionLogEo optionLogEo = new OptionLogEo();
        optionLogEo.setStatus("001");
        optionLogEo.setUpdateTime(new Date());
        optionLogEo.setNo(reqDto.getNo());
        optionLogEo.setId(queryLogEo.getId());
        int update = this.optionLogMapper.updateById((BaseEo)optionLogEo);
        return update > 0;
    }

    @Override
    public RestResponse<PageInfo<CargoStorageExtDto>> queryCargoStorage(CargoStorageDto queryDto) {
        logger.info("\u83b7\u53d6\u5e93\u5b58\u5217\u8868\u67e5\u8be2-\u8f93\u5165:{}", (Object)JSON.toJSONString((Object)queryDto));
        Integer pageNum = queryDto.getPageNum();
        Integer pageSize = queryDto.getPageSize();
        AssertUtil.isTrue(Objects.nonNull(pageNum) && pageNum > 0, "\u9875\u7801\u53c2\u6570\u4e0d\u5408\u6cd5");
        AssertUtil.isTrue(Objects.nonNull(pageSize) && pageSize > 0, "\u6bcf\u9875\u6761\u6570\u4e0d\u5408\u6cd5");
        PageInfo<CargoStorageExtDto> result = new PageInfo<CargoStorageExtDto>();
        if (StringUtils.isNotBlank((CharSequence)queryDto.getBatch())) {
            QueryWrapper<LogicInventoryEo> querywrapper = this.getLogicInventoryEoQueryWrapper(queryDto);
            result = this.queryCsLogicInventoryPage(pageNum, pageSize, querywrapper);
        } else {
            QueryWrapper<LogicInventoryTotalEo> querywrapper = this.getLogicInventoryTotalEoQueryWrapper(queryDto);
            result = this.queryCsLogicInventoryTotalPage(pageNum, pageSize, querywrapper);
        }
        logger.info("\u83b7\u53d6\u5e93\u5b58-\u8f93\u51fa:{}", (Object)JSON.toJSONString(result));
        return new RestResponse("0", "success", result);
    }

    @Override
    public RestResponse<PageInfo<CargoStorageExtDto>> queryBatchByActivity(TcbjCombinationBatchReqDto queryDto) {
        logger.info("\u83b7\u53d6\u6d3b\u52a8\u5e93\u5b58\u6279\u6b21\u53f7\u67e5\u8be2-\u8f93\u5165:{}", (Object)JSON.toJSONString((Object)queryDto));
        Integer pageNum = queryDto.getPageNum();
        Integer pageSize = queryDto.getPageSize();
        AssertUtil.isTrue(Objects.nonNull(pageNum) && pageNum > 0, "\u9875\u7801\u53c2\u6570\u4e0d\u5408\u6cd5");
        AssertUtil.isTrue(Objects.nonNull(pageSize) && pageSize > 0, "\u6bcf\u9875\u6761\u6570\u4e0d\u5408\u6cd5");
        PageHelper.startPage((int)pageNum, (int)pageSize);
        QueryWrapper activityEoQuerywrapper = new QueryWrapper();
        activityEoQuerywrapper.eq((Object)"dr", (Object)"0");
        if (Objects.nonNull(queryDto.getActivityId())) {
            activityEoQuerywrapper.eq((Object)"activity_id", (Object)queryDto.getActivityId());
        } else if (CollectionUtils.isNotEmpty((Collection)queryDto.getActivityIds())) {
            activityEoQuerywrapper.in((Object)"activity_id", (Collection)queryDto.getActivityIds());
        } else {
            throw new BizException("\u6d3b\u52a8ID\u53c2\u6570\u4e0d\u5408\u6cd5\uff01");
        }
        activityEoQuerywrapper.eq((Object)"cargo_code", (Object)queryDto.getCargoCode());
        List list = this.csActivityInventoryMapper.selectList((Wrapper)activityEoQuerywrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new BizException("\u6279\u6b21\u53f7\u5217\u8868\u4e0d\u5b58\u5728\uff01");
        }
        List collect = list.stream().map(e -> {
            CargoStorageExtDto cargoStorageDto = new CargoStorageExtDto();
            QueryWrapper storageEoQuerywrapper = new QueryWrapper();
            storageEoQuerywrapper.eq((Object)"dr", (Object)"0");
            storageEoQuerywrapper.eq((Object)"sku_code", (Object)e.getCargoCode());
            storageEoQuerywrapper.eq((Object)"warehouse_code", (Object)e.getWarehouseCode());
            storageEoQuerywrapper.eq((Object)"batch", (Object)e.getBatch());
            LogicInventoryEo one = (LogicInventoryEo)this.logicInventoryDomain.getMapper().selectOne((Wrapper)storageEoQuerywrapper);
            if (Objects.nonNull(one)) {
                BeanUtils.copyProperties((Object)one, (Object)cargoStorageDto);
                cargoStorageDto.setBalance(e.getAvailable());
                return cargoStorageDto;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        PageInfo info = new PageInfo(list);
        PageInfo result = new PageInfo();
        BeanUtils.copyProperties((Object)info, (Object)result);
        result.setList(collect);
        logger.info("\u83b7\u53d6\u6d3b\u52a8\u5e93\u5b58\u6279\u6b21\u53f7\u67e5\u8be2-\u8f93\u51fa:{}", (Object)JSON.toJSONString((Object)result));
        return new RestResponse("0", "success", (Object)result);
    }

    @Override
    public RestResponse<PageInfo<CargoStorageExtDto>> queryBatch(CargoStorageDto queryDto) {
        logger.info("\u83b7\u53d6\u5e93\u5b58\u6279\u6b21\u53f7\u67e5\u8be2-\u8f93\u5165:{}", (Object)JSON.toJSONString((Object)queryDto));
        Integer pageNum = queryDto.getPageNum();
        Integer pageSize = queryDto.getPageSize();
        AssertUtil.isTrue(Objects.nonNull(pageNum) && pageNum > 0, "\u9875\u7801\u53c2\u6570\u4e0d\u5408\u6cd5");
        AssertUtil.isTrue(Objects.nonNull(pageSize) && pageSize > 0, "\u6bcf\u9875\u6761\u6570\u4e0d\u5408\u6cd5");
        List<Object> logicWarehouseIds = new ArrayList();
        if (Objects.isNull(queryDto.getWarehouseId())) {
            logicWarehouseIds = this.csCommonService.getUserLogicWarehouseIds();
        }
        AssertUtil.isTrue(Objects.nonNull(queryDto.getWarehouseId()) || CollectionUtils.isNotEmpty(logicWarehouseIds), "\u4ed3\u5e93id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtil.isTrue(StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{queryDto.getCargoCode()}), "\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        PageInfo<CargoStorageExtDto> result = new PageInfo<CargoStorageExtDto>();
        QueryWrapper querywrapper = new QueryWrapper();
        if (Objects.nonNull(queryDto.getWarehouseId())) {
            querywrapper.eq((Object)"warehouse_id", (Object)queryDto.getWarehouseId());
        }
        if (CollectionUtils.isNotEmpty(logicWarehouseIds)) {
            querywrapper.in((Object)"warehouse_id", logicWarehouseIds);
        }
        if (StringUtils.isNotBlank((CharSequence)queryDto.getBatch())) {
            querywrapper.eq((Object)"batch", (Object)queryDto.getBatch());
        }
        querywrapper.eq((Object)"cargo_code", (Object)queryDto.getCargoCode());
        querywrapper.ge((Object)"available", (Object)0);
        querywrapper.orderByAsc((Object)"produce_time,batch");
        querywrapper.eq((Object)"dr", (Object)"0");
        PageHelper.startPage((int)pageNum, (int)pageSize);
        result = this.queryCsLogicInventoryPage(pageNum, pageSize, (QueryWrapper<LogicInventoryEo>)querywrapper);
        logger.info("\u83b7\u53d6\u5e93\u5b58-\u8f93\u51fa:{}", (Object)JSON.toJSONString(result));
        return new RestResponse("0", "success", result);
    }

    @Override
    public RestResponse<PageInfo<TcbjInventoryRespDto>> page(TcbjInventoryReqDto queryDto) {
        logger.info("\u83b7\u53d6\u5e93\u5b58-\u8f93\u5165:{}", (Object)JSON.toJSONString((Object)queryDto));
        Integer pageNum = queryDto.getPageNum();
        Integer pageSize = queryDto.getPageSize();
        AssertUtil.isTrue(Objects.nonNull(pageNum) && pageNum > 0, "\u9875\u7801\u53c2\u6570\u4e0d\u5408\u6cd5");
        AssertUtil.isTrue(Objects.nonNull(pageSize) && pageSize > 0, "\u6bcf\u9875\u6761\u6570\u4e0d\u5408\u6cd5");
        RestResponse restResponse = this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId());
        Long orgId = (Long)RestResponseHelper.extractData((RestResponse)restResponse);
        queryDto.setOrgId(orgId);
        PageHelper.startPage((int)pageNum, (int)pageSize);
        return new RestResponse("0", "success", null);
    }

    @Override
    public RestResponse<PageInfo<TcbjInventoryLogRespDto>> log(TcbjInventoryLogReqDto queryDto) {
        logger.info("\u83b7\u53d6\u5e93\u5b58\u6d41\u6c34-\u8f93\u5165:{}", (Object)JSON.toJSONString((Object)queryDto));
        Integer pageNum = queryDto.getPageNum();
        Integer pageSize = queryDto.getPageSize();
        AssertUtil.isTrue(Objects.nonNull(pageNum) && pageNum > 0, "\u9875\u7801\u53c2\u6570\u4e0d\u5408\u6cd5");
        AssertUtil.isTrue(Objects.nonNull(pageSize) && pageSize > 0, "\u6bcf\u9875\u6761\u6570\u4e0d\u5408\u6cd5");
        RestResponse restResponse = this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId());
        Long orgId = (Long)RestResponseHelper.extractData((RestResponse)restResponse);
        queryDto.setOrgId(orgId);
        PageHelper.startPage((int)pageNum, (int)pageSize);
        return new RestResponse("0", "success", null);
    }

    @Override
    public RestResponse<String> insertLog(String relevanceNo, long cargoId, String warehouseId, int type, double old, double newv) {
        return new RestResponse("0", "success", null);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<String> preOccupy(TcbjProOccupyReqDto tcbjProOccupyReqDto) {
        return RestResponse.SUCCEED;
    }

    private Boolean preemptActInventory(CsInventoryOperateReqDto inventoryOperateReqDto, List<CsInventoryOperateCargoReqDto> actCargoList, CsInventoryInOutBasicsCargoDto baseCargoDto) {
        CsInventoryOperateReqDto actOperateReqDto = new CsInventoryOperateReqDto();
        CubeBeanUtils.copyProperties((Object)actOperateReqDto, (Object)inventoryOperateReqDto, (String[])new String[0]);
        actOperateReqDto.setOperateCargoReqDtoList(actCargoList);
        ICsInventoryBasicsService activityInventoryService = CsInventoryStrategyUtils.getInventoryService(CsInventoryStrategyEnum.ACTIVITY.getCode());
        logger.info("preemptInventory==>\u9884\u5360\u6d3b\u52a8\u5e93\u5b58,sourceNo:{},activityInventoryService:{}", (Object)inventoryOperateReqDto.getSourceNo(), (Object)LogUtils.buildLogContent(activityInventoryService));
        ArrayList inOutBasicsCargoDtoList = Lists.newArrayList();
        CsInventoryInOutBasicsDto csInventoryInOutBasicsDto = new CsInventoryInOutBasicsDto();
        csInventoryInOutBasicsDto.setInOutFlag(inventoryOperateReqDto.getInOutFlag());
        csInventoryInOutBasicsDto.setStrategy(CsInventoryStrategyEnum.ACTIVITY.getCode());
        csInventoryInOutBasicsDto.setNegativeValidate(YesNoEnum.YES.getValue());
        csInventoryInOutBasicsDto.setSourceNo(inventoryOperateReqDto.getSourceNo());
        csInventoryInOutBasicsDto.setSourceType(inventoryOperateReqDto.getSourceType());
        for (CsInventoryOperateCargoReqDto actDto : actCargoList) {
            CsInventoryInOutBasicsCargoDto inOutBasicsCargoDto = new CsInventoryInOutBasicsCargoDto();
            CubeBeanUtils.copyProperties((Object)inOutBasicsCargoDto, (Object)baseCargoDto, (String[])new String[0]);
            inOutBasicsCargoDto.setCargoCode(actDto.getCargoCode());
            inOutBasicsCargoDto.setActivityFlag(YesNoEnum.YES.getValue());
            inOutBasicsCargoDto.setBalance(actDto.getChangeInventory().abs());
            inOutBasicsCargoDto.setAvailable(actDto.getChangeInventory().abs());
            inOutBasicsCargoDto.setWarehouseCode(actDto.getWarehouseCode());
            inOutBasicsCargoDto.setBatch(actDto.getBatch());
            inOutBasicsCargoDto.setActivityId(actDto.getActivityId());
            inOutBasicsCargoDto.setCargoProportion(actDto.getCargoProportion());
            inOutBasicsCargoDto.setFinishFlag(CsActivityInventoryStatusEnum.ONGOING.getCode());
            inOutBasicsCargoDtoList.add(inOutBasicsCargoDto);
        }
        csInventoryInOutBasicsDto.setInOutBasicsCargoDtoList((List)inOutBasicsCargoDtoList);
        logger.info("preemptInventory==>\u65b0\u5efa\u6d3b\u52a8\u5373\u5c06\u521d\u59cb\u5316\u6d3b\u52a8\u5e93\u5b58,sourceNo:{},csInventoryInOutBasicsDto:{}", (Object)inventoryOperateReqDto.getSourceNo(), (Object)LogUtils.buildLogContent(csInventoryInOutBasicsDto));
        Boolean commonFlag = activityInventoryService.outInventory(csInventoryInOutBasicsDto);
        logger.info("preemptInventory==>\u65b0\u5efa\u6d3b\u52a8\u5373\u5c06\u521d\u59cb\u5316\u6d3b\u52a8\u5e93\u5b58\u64cd\u4f5c\u7ed3\u679c,sourceNo:{},commonFlag:{}", (Object)inventoryOperateReqDto.getSourceNo(), (Object)LogUtils.buildLogContent(commonFlag));
        return commonFlag;
    }

    private Boolean preemptCommonInventory(CsInventoryOperateReqDto inventoryOperateReqDto, List<CsInventoryOperateCargoReqDto> commonCargoList) {
        logger.info("preemptInventory==>\u9884\u5360\u903b\u8f91\u4ed3\u5e93\u5b58,inventoryOperateReqDto:{},commonCargoList:{}", (Object)LogUtils.buildLogContent(inventoryOperateReqDto), (Object)LogUtils.buildLogContent(commonCargoList));
        CsInventoryOperateReqDto commonOperateReqDto = new CsInventoryOperateReqDto();
        CubeBeanUtils.copyProperties((Object)commonOperateReqDto, (Object)inventoryOperateReqDto, (String[])new String[0]);
        commonOperateReqDto.setOperateCargoReqDtoList(commonCargoList);
        PreemptDto preemptDto = new PreemptDto();
        preemptDto.setIsActivityPreempt(Boolean.valueOf(true));
        preemptDto.setSourceNo(inventoryOperateReqDto.getSourceNo());
        preemptDto.setSourceType(inventoryOperateReqDto.getSourceType());
        preemptDto.setExternalOrderNo(inventoryOperateReqDto.getPlatformOrderNo());
        preemptDto.setValidNegative(Boolean.valueOf(!Objects.equals(0, inventoryOperateReqDto.getNegativeValidate())));
        preemptDto.setDetails(commonCargoList.stream().map(r -> {
            CalcDetailDto calcDetailDto = (CalcDetailDto)BeanUtil.copyProperties((Object)r, CalcDetailDto.class, (String[])new String[0]);
            calcDetailDto.setSkuCode(r.getCargoCode());
            calcDetailDto.setNum(r.getChangeInventory());
            return calcDetailDto;
        }).collect(Collectors.toList()));
        this.calcInventoryService.preempt(preemptDto);
        logger.info("preemptInventory==>\u6d3b\u52a8\u521b\u5efa\uff0c\u9884\u5360\u903b\u8f91\u4ed3\u5e93\u5b58,\u5373\u5c06\u8c03\u7528\u51fa\u5e93\u64cd\u4f5c\u7ed3\u679c,commonFlag:{}", (Object)LogUtils.buildLogContent(true));
        return true;
    }

    private void backOccupy(List<CargoOccupyEo> occupyEoList) {
        logger.info("backOccupy==>occupyEoList:{}", (Object)LogUtils.buildLogContent(occupyEoList));
        if (CollectionUtils.isEmpty(occupyEoList)) {
            return;
        }
        for (CargoOccupyEo occupyEo : occupyEoList) {
            InventoryActivityEo inventoryActivityQueryEo = new InventoryActivityEo();
            inventoryActivityQueryEo.setActivityId(occupyEo.getActivityId());
            inventoryActivityQueryEo.setCargoCode(occupyEo.getCargoCode());
            inventoryActivityQueryEo.setWarehouseCode(occupyEo.getWarehouseCode());
            inventoryActivityQueryEo.setBatch(occupyEo.getBatch());
            List inventoryActivityEoList = this.inventoryActivityDas.selectList((BaseEo)inventoryActivityQueryEo);
            logger.info("backOccupy==>\u7ef4\u62a4\u7ec4\u5408\u5957\u88c5\u5546\u54c1\u7684\u6d3b\u52a8\u5e93\u5b58,inventoryActivityEoList:{}", (Object)LogUtils.buildLogContent(inventoryActivityEoList));
            if (CollectionUtils.isEmpty((Collection)inventoryActivityEoList)) {
                return;
            }
            for (InventoryActivityEo inventoryActivityEo : inventoryActivityEoList) {
                BigDecimal originalActivityBalance = inventoryActivityEo.getActivityBalance();
                BigDecimal originalActivitySurplus = inventoryActivityEo.getActivitySurplus();
                BigDecimal originalActivitySold = inventoryActivityEo.getActivitySold();
                Integer occupyEoNum = occupyEo.getNum();
                BigDecimal occNum = new BigDecimal(occupyEoNum);
                BigDecimal activitySold = BigDecimal.ZERO;
                activitySold = inventoryActivityEo.getActivitySold().subtract(occNum);
                BigDecimal newActivitySurplus = originalActivityBalance.subtract(activitySold);
                inventoryActivityEo.setActivitySold(activitySold);
                inventoryActivityEo.setActivitySurplus(newActivitySurplus);
                logger.info("backOccupy==>\u7ef4\u62a4\u7ec4\u5408\u5957\u88c5\u5546\u54c1\u7684\u6d3b\u52a8\u5e93\u5b58,\u66f4\u65b0inventoryActivityEo:{}", (Object)LogUtils.buildLogContent(inventoryActivityEo));
                this.inventoryActivityDas.updateSelective((BaseEo)inventoryActivityEo);
                InventoryActivityLogEo inventoryActivityLogEo = new InventoryActivityLogEo();
                CubeBeanUtils.copyProperties((Object)inventoryActivityLogEo, (Object)inventoryActivityEo, (String[])new String[0]);
                inventoryActivityLogEo.setId(null);
                inventoryActivityLogEo.setBeforeInventory(originalActivitySurplus);
                inventoryActivityLogEo.setChangeInventory(occNum);
                inventoryActivityLogEo.setAfterInventory(newActivitySurplus);
                inventoryActivityLogEo.setOrderType(OrderTypeEnu.INVOKE_COMBINATION_ACT_AUDIT_REDUCE.getCode());
                inventoryActivityLogEo.setOrderNo(occupyEo.getOrderNo());
                logger.info("backOccupy==>\u7ef4\u62a4\u6d3b\u52a8\u5e93\u5b58\u65e5\u5fd7\u4fe1\u606f\uff0cinventoryActivityLogEo:{}", (Object)LogUtils.buildLogContent(inventoryActivityLogEo));
                this.inventoryActivityLogDas.insert((BaseEo)inventoryActivityLogEo);
            }
        }
    }

    private void formatReqItemInfo(TcbjProOccupyReqDto tcbjProOccupyReqDto, Map<String, List<InventoryActivityEo>> activityEoMap) {
        logger.info("formatReqItemInfo==>tcbjProOccupyReqDto:{},activityEoMap:{}", (Object)LogUtils.buildLogContent(tcbjProOccupyReqDto), (Object)LogUtils.buildLogContent(activityEoMap));
        List tcbjProOccupyItemReqDtoList = tcbjProOccupyReqDto.getTcbjProOccupyItemReqDtos();
        ArrayList batchItemList = Lists.newArrayList();
        block0: for (TcbjProOccupyItemReqDto itemReqDto : tcbjProOccupyItemReqDtoList) {
            String key = itemReqDto.getActivityId() + "_" + itemReqDto.getCargoCode() + "_" + itemReqDto.getWarehouseCode();
            List<InventoryActivityEo> tempEoList = activityEoMap.get(key);
            if (CollectionUtils.isEmpty(tempEoList)) continue;
            int size = tempEoList.size();
            Integer num = itemReqDto.getNum();
            BigDecimal numDeci = new BigDecimal(num);
            if (size == 1) {
                InventoryActivityEo inventoryActivityEo = tempEoList.get(0);
                TcbjProOccupyItemReqDto batchItem = new TcbjProOccupyItemReqDto();
                CubeBeanUtils.copyProperties((Object)batchItem, (Object)itemReqDto, (String[])new String[0]);
                batchItem.setBatch(inventoryActivityEo.getBatch());
                BigDecimal perActivityBalance = inventoryActivityEo.getPerActivityBalance();
                BigDecimal one = BigDecimal.ONE;
                BigDecimal val = numDeci.multiply(one);
                logger.info("preOccupyForActItem==>\u5355\u6279\u6b21val:{}", (Object)val);
                batchItem.setNum(Integer.valueOf(val.intValue()));
                batchItemList.add(batchItem);
                continue;
            }
            List greaterZeroEoList = tempEoList.stream().filter(eo -> eo.getActivitySurplus().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
            logger.info("formatReqItemInfo==>greaterZeroEoList:{}", (Object)LogUtils.buildLogContent(greaterZeroEoList));
            List actBalanceList = greaterZeroEoList.stream().sorted(Comparator.comparing(InventoryActivityEo::getActivitySurplus).reversed()).collect(Collectors.toList());
            logger.info("formatReqItemInfo==>actBalanceList:{}", (Object)LogUtils.buildLogContent(actBalanceList));
            InventoryActivityEo balanceEo = (InventoryActivityEo)actBalanceList.get(0);
            BigDecimal perActivityBalance = balanceEo.getPerActivityBalance();
            BigDecimal one = BigDecimal.ONE;
            BigDecimal val = numDeci.multiply(one);
            logger.info("formatReqItemInfo==>\u591a\u6279\u6b21val:{}", (Object)val);
            BigDecimal totalBatchSurplus = tempEoList.stream().map(InventoryActivityEo::getActivitySurplus).reduce(BigDecimal.ZERO, BigDecimal::add);
            logger.info("formatReqItemInfo==>totalBatchSurplus:{}", (Object)totalBatchSurplus);
            if (val.compareTo(totalBatchSurplus) > 0) {
                logger.info("\u8d27\u54c1:{}\u6d3b\u52a8\u5269\u4f59\u5e93\u5b58\u4e0d\u8db3,activityCode:{}", (Object)balanceEo.getCargoName(), (Object)balanceEo.getActivityCode());
                throw new BizException(String.format("\u8d27\u54c1\u3010%s\u3011\u6d3b\u52a8\u5269\u4f59\u5e93\u5b58\u4e0d\u8db3", balanceEo.getCargoName()));
            }
            for (InventoryActivityEo inventoryActivityEo : actBalanceList) {
                if (val.compareTo(BigDecimal.ZERO) == 0) continue block0;
                BigDecimal activitySurplus = inventoryActivityEo.getActivitySurplus();
                BigDecimal subtract = activitySurplus.subtract(val);
                logger.info("formatReqItemInfo==>activitySurplus:{},subtract:{},val:{}", new Object[]{LogUtils.buildLogContent(activitySurplus), subtract, val});
                int compareVal = subtract.compareTo(BigDecimal.ZERO);
                TcbjProOccupyItemReqDto batchItem = new TcbjProOccupyItemReqDto();
                CubeBeanUtils.copyProperties((Object)batchItem, (Object)itemReqDto, (String[])new String[0]);
                batchItem.setBatch(inventoryActivityEo.getBatch());
                batchItemList.add(batchItem);
                if (compareVal >= 0) {
                    batchItem.setNum(Integer.valueOf(val.intValue()));
                    continue block0;
                }
                if (compareVal >= 0) continue;
                batchItem.setNum(Integer.valueOf(activitySurplus.intValue()));
                val = subtract.abs();
            }
        }
        logger.info("preOccupyForActItem==>batchItemList:{}", (Object)LogUtils.buildLogContent(batchItemList));
        tcbjProOccupyReqDto.setTcbjProOccupyItemReqDtos((List)batchItemList);
    }

    private void manageActInventory(CargoOccupyEo occupyEo, String orderNo) {
        logger.info("manageActInventory==>\u7ef4\u62a4\u7ec4\u5408\u5957\u88c5\u5546\u54c1\u7684\u6d3b\u52a8\u5e93\u5b58,occupyEo:{},orderNo:{}", (Object)LogUtils.buildLogContent(occupyEo), (Object)orderNo);
        if (OrderTypeEnu.INVOKE_COMBINATION_ACT_PREEMPT.getCode().equals(occupyEo.getOrderType())) {
            return;
        }
        InventoryActivityEo inventoryActivityQueryEo = new InventoryActivityEo();
        inventoryActivityQueryEo.setActivityId(occupyEo.getActivityId());
        inventoryActivityQueryEo.setCargoCode(occupyEo.getCargoCode());
        inventoryActivityQueryEo.setWarehouseCode(occupyEo.getWarehouseCode());
        inventoryActivityQueryEo.setBatch(occupyEo.getBatch());
        List inventoryActivityEoList = this.inventoryActivityDas.selectList((BaseEo)inventoryActivityQueryEo);
        logger.info("manageActInventory==>\u7ef4\u62a4\u7ec4\u5408\u5957\u88c5\u5546\u54c1\u7684\u6d3b\u52a8\u5e93\u5b58,inventoryActivityEoList:{}", (Object)LogUtils.buildLogContent(inventoryActivityEoList));
        if (CollectionUtils.isEmpty((Collection)inventoryActivityEoList)) {
            return;
        }
        String orderType = occupyEo.getOrderType();
        for (InventoryActivityEo inventoryActivityEo : inventoryActivityEoList) {
            BigDecimal originalActivityBalance = inventoryActivityEo.getActivityBalance();
            BigDecimal originalActivitySurplus = inventoryActivityEo.getActivitySurplus();
            BigDecimal originalActivitySold = inventoryActivityEo.getActivitySold();
            Integer occupyEoNum = occupyEo.getNum();
            BigDecimal occNum = new BigDecimal(occupyEoNum);
            BigDecimal activitySold = BigDecimal.ZERO;
            if (OrderTypeEnu.INVOKE_COMBINATION_ACT_ORDER_PREEMPT.getCode().equals(orderType) || OrderTypeEnu.INVOKE_COMBINATION_ACT_AUDIT_PREEMPT.getCode().equals(orderType)) {
                activitySold = inventoryActivityEo.getActivitySold().add(occNum);
            } else if (OrderTypeEnu.INVOKE_COMBINATION_ACT_ORDER_CANCEL.getCode().equals(orderType) || OrderTypeEnu.INVOKE_COMBINATION_ACT_AUDIT_REDUCE.getCode().equals(orderType)) {
                activitySold = inventoryActivityEo.getActivitySold().subtract(occNum);
            }
            BigDecimal newActivitySurplus = originalActivityBalance.subtract(activitySold);
            inventoryActivityEo.setActivitySold(activitySold);
            inventoryActivityEo.setActivitySurplus(newActivitySurplus);
            logger.info("manageActInventory==>\u7ef4\u62a4\u7ec4\u5408\u5957\u88c5\u5546\u54c1\u7684\u6d3b\u52a8\u5e93\u5b58,\u66f4\u65b0inventoryActivityEo:{}", (Object)LogUtils.buildLogContent(inventoryActivityEo));
            this.inventoryActivityDas.updateSelective((BaseEo)inventoryActivityEo);
            InventoryActivityLogEo inventoryActivityLogEo = new InventoryActivityLogEo();
            CubeBeanUtils.copyProperties((Object)inventoryActivityLogEo, (Object)inventoryActivityEo, (String[])new String[0]);
            inventoryActivityLogEo.setId(null);
            inventoryActivityLogEo.setBeforeInventory(originalActivitySurplus);
            inventoryActivityLogEo.setChangeInventory(occNum);
            inventoryActivityLogEo.setAfterInventory(newActivitySurplus);
            inventoryActivityLogEo.setOrderType(orderType);
            inventoryActivityLogEo.setOrderNo(orderNo);
            logger.info("manageActInventory==>\u7ef4\u62a4\u6d3b\u52a8\u5e93\u5b58\u65e5\u5fd7\u4fe1\u606f\uff0cinventoryActivityLogEo:{}", (Object)LogUtils.buildLogContent(inventoryActivityLogEo));
            this.inventoryActivityLogDas.insert((BaseEo)inventoryActivityLogEo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<String> cancelPreOccupy(String json, String type, boolean updateStorage, boolean isReturnAudit) {
        return RestResponse.SUCCEED;
    }

    @Override
    public int cacelOccupy(CargoOccupyEo occupyEo, String type, boolean updateStorage, boolean isReturnAudit) {
        return 0;
    }

    @Override
    public RestResponse<PageInfo<TcbjProOccupyRespDto>> preOccupyList(TcbjProOccupyListReqDto queryDto) {
        logger.info("\u83b7\u53d6\u5e93\u5b58-\u8f93\u5165:{}", (Object)JSON.toJSONString((Object)queryDto));
        Integer pageNum = queryDto.getPageNum();
        Integer pageSize = queryDto.getPageSize();
        AssertUtil.isTrue(Objects.nonNull(pageNum) && pageNum > 0, "\u9875\u7801\u53c2\u6570\u4e0d\u5408\u6cd5");
        AssertUtil.isTrue(Objects.nonNull(pageSize) && pageSize > 0, "\u6bcf\u9875\u6761\u6570\u4e0d\u5408\u6cd5");
        QueryWrapper qwrapper = new QueryWrapper();
        if (!Strings.isNullOrEmpty((String)queryDto.getArtNo())) {
            qwrapper.eq((Object)"art_no", (Object)queryDto.getArtNo());
        }
        if (!Strings.isNullOrEmpty((String)queryDto.getCode())) {
            qwrapper.eq((Object)"cargo_code", (Object)queryDto.getCode());
        }
        if (!Strings.isNullOrEmpty((String)queryDto.getOrderNo())) {
            qwrapper.eq((Object)"source_no", (Object)queryDto.getOrderNo());
        }
        if (Objects.nonNull(queryDto.getActivityId())) {
            qwrapper.eq((Object)"activity_id", (Object)queryDto.getActivityId());
        }
        if (!Strings.isNullOrEmpty((String)queryDto.getBatch())) {
            qwrapper.eq((Object)"batch", (Object)queryDto.getBatch());
        }
        if (!Strings.isNullOrEmpty((String)queryDto.getWarehouseCode())) {
            qwrapper.eq((Object)"warehouse_code", (Object)queryDto.getWarehouseCode());
        }
        if (Objects.isNull(queryDto.getDisplay()) || -1 != queryDto.getDisplay()) {
            qwrapper.eq((Object)"display", (Object)(Objects.nonNull(queryDto.getDisplay()) ? queryDto.getDisplay() : YesNoEnum.YES.getValue()));
        }
        if (StringUtils.isNotBlank((CharSequence)queryDto.getValid())) {
            qwrapper.eq((Object)"valid", (Object)queryDto.getValid());
        }
        qwrapper.isNotNull((Object)"batch");
        qwrapper.eq((Object)"dr", (Object)"0");
        qwrapper.orderByDesc((Object)"create_time");
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List rList = this.inventoryPreemptionDomain.getMapper().selectList((Wrapper)qwrapper);
        PageInfo info = new PageInfo(rList);
        List list = rList.stream().map(c -> {
            TcbjProOccupyRespDto tmp = new TcbjProOccupyRespDto();
            tmp.setCode(c.getSkuCode());
            tmp.setName(c.getSkuName());
            tmp.setWarehouseName(c.getWarehouseName());
            tmp.setWarehouseCode(c.getWarehouseCode());
            tmp.setBatch(c.getBatch());
            tmp.setPreempt(Integer.valueOf(c.getPreemptNum().intValue()));
            tmp.setUpdateTime(c.getUpdateTime());
            tmp.setCreateTime(c.getCreateTime());
            tmp.setOrderNo(c.getSourceNo());
            tmp.setOrderType(c.getSourceType());
            tmp.setOrderTypeDescribe(CsInventorySourceTypeEnum.getByCode((String)c.getSourceType()).getDesc());
            return tmp;
        }).collect(Collectors.toList());
        PageInfo result = new PageInfo(list);
        BeanUtils.copyProperties((Object)info, (Object)result);
        result.setList(list);
        logger.info("\u83b7\u53d6\u5e93\u5b58-\u8f93\u51fa:{}", (Object)JSON.toJSONString((Object)result));
        return new RestResponse((Object)result);
    }

    @Override
    public RestResponse<List<TcbjAvilableRespDto>> avilable(TcbjAvilableReqDto queryDto) {
        logger.info("avilable==>\u8425\u9500\u4e91\u53ef\u7528\u5e93\u5b58\u67e5\u8be2,queryDto:{}", (Object)LogUtils.buildLogContent(queryDto));
        List<Object> available = new ArrayList();
        List list = CollectionUtils.isNotEmpty((Collection)queryDto.getList()) ? queryDto.getList() : Lists.newArrayList((Object[])new TcbjAvilableReqDto[]{queryDto});
        for (TcbjAvilableReqDto reqDto : list) {
            List inventoryEos;
            QueryWrapper inventoryWrapper = new QueryWrapper();
            inventoryWrapper.eq((Object)"warehouse_code", (Object)(StringUtils.isNotBlank((CharSequence)reqDto.getWarehouseCode()) ? reqDto.getWarehouseCode() : queryDto.getWarehouseCode()));
            inventoryWrapper.ge((Object)"balance", (Object)0);
            inventoryWrapper.gt((Object)"available", (Object)0);
            if (StringUtils.isNotBlank((CharSequence)reqDto.getCargoCode())) {
                Consumer<QueryWrapper> inventoryWrapper2 = qw -> {
                    qw.like((Object)"sku_code", (Object)reqDto.getCargoCode());
                    qw.or();
                    qw.like((Object)"sku_name", (Object)reqDto.getCargoCode());
                };
                inventoryWrapper.and(inventoryWrapper2);
            }
            inventoryWrapper.eq((Object)"dr", (Object)0);
            if (StringUtils.isNotBlank((CharSequence)reqDto.getBatch())) {
                inventoryWrapper.like((Object)"batch", (Object)reqDto.getBatch());
            }
            if (CollectionUtils.isEmpty((Collection)(inventoryEos = this.logicInventoryDomain.getMapper().selectList((Wrapper)inventoryWrapper)))) continue;
            List<Object> finalAvailable = available;
            inventoryEos.forEach(eo -> {
                TcbjAvilableRespDto dto = new TcbjAvilableRespDto();
                dto.setCargoCode(eo.getSkuCode());
                dto.setWarehouseCode(eo.getWarehouseCode());
                dto.setBatch(eo.getBatch());
                dto.setAvailable(Double.valueOf(Objects.nonNull(eo.getAvailable()) ? eo.getAvailable().doubleValue() : 0.0));
                dto.setPreempt(Double.valueOf(Objects.nonNull(eo.getPreempt()) ? eo.getPreempt().doubleValue() : 0.0));
                dto.setBalance(Double.valueOf(Objects.nonNull(eo.getBalance()) ? eo.getBalance().doubleValue() : 0.0));
                finalAvailable.add(dto);
            });
        }
        if (CollectionUtils.isNotEmpty(available)) {
            available = available.stream().distinct().collect(Collectors.toList());
        }
        logger.info("avilable==>\u8425\u9500\u4e91\u53ef\u7528\u5e93\u5b58\u67e5\u8be2-\u8f93\u51fa:{}", (Object)JSON.toJSONString(available));
        return new RestResponse(available);
    }

    @Override
    public RestResponse<List<TcbjAvilableRespDto>> totalAvilable(TcbjAvilableReqDto queryDto) {
        logger.info("avilable==>\u8425\u9500\u4e91\u603b\u53ef\u7528\u5e93\u5b58\u67e5\u8be2,queryDto:{}", (Object)LogUtils.buildLogContent(queryDto));
        List<Object> available = new ArrayList();
        List LogicInventoryTotalEos = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)queryDto.getList())) {
            LambdaQueryWrapper inventoryTotalWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)inventoryTotalWrapper.eq(LogicInventoryTotalEo::getWarehouseCode, (Object)queryDto.getWarehouseCode())).eq(BaseEo::getDr, (Object)0);
            LogicInventoryTotalEos = this.logicInventoryTotalDomain.getMapper().selectList((Wrapper)inventoryTotalWrapper);
        } else {
            for (TcbjAvilableReqDto reqDto : queryDto.getList()) {
                QueryWrapper inventoryWrapper = new QueryWrapper();
                inventoryWrapper.eq((Object)"warehouse_code", (Object)(StringUtils.isNotBlank((CharSequence)reqDto.getWarehouseCode()) ? reqDto.getWarehouseCode() : queryDto.getWarehouseCode()));
                if (StringUtils.isNotBlank((CharSequence)reqDto.getCargoCode())) {
                    Consumer<QueryWrapper> inventoryWrapper2 = qw -> {
                        qw.like((Object)"sku_code", (Object)reqDto.getCargoCode());
                        qw.or();
                        qw.like((Object)"sku_name", (Object)reqDto.getCargoCode());
                    };
                    inventoryWrapper.and(inventoryWrapper2);
                }
                inventoryWrapper.eq((Object)"dr", (Object)0);
                List totalEos = this.logicInventoryTotalDomain.getMapper().selectList((Wrapper)inventoryWrapper);
                if (CollectionUtils.isEmpty((Collection)totalEos)) continue;
                LogicInventoryTotalEos.addAll(totalEos);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)LogicInventoryTotalEos)) {
            for (LogicInventoryTotalEo eo : LogicInventoryTotalEos) {
                TcbjAvilableRespDto dto = new TcbjAvilableRespDto();
                dto.setCargoCode(eo.getSkuCode());
                dto.setWarehouseCode(eo.getWarehouseCode());
                dto.setTotalAvailable(Integer.valueOf(Objects.nonNull(eo.getAvailable()) ? eo.getAvailable().intValue() : 0));
                dto.setTotalPreempt(Integer.valueOf(Objects.nonNull(eo.getPreempt()) ? eo.getPreempt().intValue() : 0));
                dto.setTotalBalance(Integer.valueOf(Objects.nonNull(eo.getBalance()) ? eo.getBalance().intValue() : 0));
                available.add(dto);
            }
            available = available.stream().distinct().collect(Collectors.toList());
        }
        logger.info("avilable==>\u8425\u9500\u4e91\u53ef\u7528\u5e93\u5b58\u67e5\u8be2-\u8f93\u51fa:{}", (Object)JSON.toJSONString(available));
        return new RestResponse(available);
    }

    @Override
    public RestResponse<List<TcbjAvilableRespDto>> avilableYingXiaoYun(TcbjAvilableReqDto queryDto) {
        logger.info("avilableYingXiaoYun==>\u524d\u7aef\u53ef\u7528\u5e93\u5b58\u67e5\u8be2,queryDto:{}", (Object)LogUtils.buildLogContent(queryDto));
        ArrayList available = new ArrayList();
        List list = CollectionUtils.isNotEmpty((Collection)queryDto.getList()) ? queryDto.getList() : Lists.newArrayList((Object[])new TcbjAvilableReqDto[]{queryDto});
        for (TcbjAvilableReqDto reqDto : list) {
            if (StringUtils.isNotBlank((CharSequence)reqDto.getBatch())) {
                QueryWrapper inventoryWrapper = new QueryWrapper();
                inventoryWrapper.like((Object)"batch", (Object)reqDto.getBatch());
                inventoryWrapper.eq((Object)"warehouse_code", (Object)reqDto.getWarehouseCode());
                inventoryWrapper.ge((Object)"balance", (Object)0);
                inventoryWrapper.ge((Object)"available", (Object)0);
                inventoryWrapper.eq((Object)"sku_code", (Object)reqDto.getCargoCode());
                inventoryWrapper.eq((Object)"dr", (Object)0);
                List inventoryEos = this.logicInventoryDomain.getMapper().selectList((Wrapper)inventoryWrapper);
                if (CollectionUtils.isEmpty((Collection)inventoryEos)) continue;
                inventoryEos.forEach(eo -> {
                    TcbjAvilableRespDto dto = new TcbjAvilableRespDto();
                    dto.setCargoCode(eo.getSkuCode());
                    dto.setWarehouseCode(eo.getWarehouseCode());
                    dto.setBatch(eo.getBatch());
                    dto.setAvailable(Double.valueOf(Objects.nonNull(eo.getAvailable()) ? eo.getAvailable().doubleValue() : 0.0));
                    dto.setPreempt(Double.valueOf(Objects.nonNull(eo.getPreempt()) ? eo.getPreempt().doubleValue() : 0.0));
                    dto.setBalance(Double.valueOf(Objects.nonNull(eo.getBalance()) ? eo.getBalance().doubleValue() : 0.0));
                    available.add(dto);
                });
                continue;
            }
            QueryWrapper inventoryTotalWrapper = new QueryWrapper();
            inventoryTotalWrapper.eq((Object)"warehouse_code", (Object)reqDto.getWarehouseCode());
            inventoryTotalWrapper.ge((Object)"balance", (Object)0);
            inventoryTotalWrapper.ge((Object)"available", (Object)0);
            inventoryTotalWrapper.eq((Object)"sku_code", (Object)reqDto.getCargoCode());
            inventoryTotalWrapper.eq((Object)"dr", (Object)0);
            List totalEos = this.logicInventoryTotalDomain.getMapper().selectList((Wrapper)inventoryTotalWrapper);
            if (CollectionUtils.isEmpty((Collection)totalEos)) continue;
            totalEos.forEach(eo -> {
                TcbjAvilableRespDto dto = new TcbjAvilableRespDto();
                dto.setCargoCode(eo.getSkuCode());
                dto.setWarehouseCode(eo.getWarehouseCode());
                dto.setAvailable(Double.valueOf(Objects.nonNull(eo.getAvailable()) ? eo.getAvailable().doubleValue() : 0.0));
                dto.setPreempt(Double.valueOf(Objects.nonNull(eo.getPreempt()) ? eo.getPreempt().doubleValue() : 0.0));
                dto.setBalance(Double.valueOf(Objects.nonNull(dto.getBalance()) ? dto.getBalance() : 0.0));
                available.add(dto);
            });
        }
        logger.info("\u83b7\u53d6\u5e93\u5b58-\u8f93\u51fa:{}", (Object)JSON.toJSONString(available));
        return new RestResponse(available);
    }

    @Override
    public RestResponse<String> adjust(TcbjCompareReqDto queryDto) {
        return null;
    }

    @Override
    public RestResponse<String> diff() {
        List<CloudInventoryDto> inventory = this.tcbjBaseService.getInventory();
        return new RestResponse("0", "success", (Object)JSON.toJSONString(inventory));
    }

    @Override
    public List<ItemInventoryQueryRespDto> queryBranchItemStorage(List<String> itemCodeList) {
        return null;
    }

    @Override
    public RestResponse<String> returnAuditOrderStatus(String preNo) {
        logger.info("\u53cd\u5ba1\u6838\u66f4\u65b0\u5355\u636e\u72b6\u6001");
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"pre_no", (Object)preNo);
        DRAOrderEo one = (DRAOrderEo)this.tcbjDRAOrderMapper.selectOne((Wrapper)wrapper);
        AssertUtil.isTrue(Objects.nonNull(one), "\u8be5\u8ba2\u5355\u7684\u5165\u5e93\u5355\u672a\u627e\u5230");
        one.setStatus(OrderStatus.DELIVERY_WAIT_AUDIT);
        this.tcbjDRAOrderMapper.updateById((BaseEo)one);
        return new RestResponse("0", "success");
    }

    @Override
    public RestResponse<String> changeOrderStatus(String preNo, Integer orderStatus) {
        logger.info("\u66f4\u65b0\u5355\u636e\u72b6\u6001");
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"pre_no", (Object)preNo);
        DRAOrderEo one = (DRAOrderEo)this.tcbjDRAOrderMapper.selectOne((Wrapper)wrapper);
        AssertUtil.isTrue(Objects.nonNull(one), "\u8be5\u8ba2\u5355\u7684\u5165\u5e93\u5355\u672a\u627e\u5230");
        one.setStatus(orderStatus);
        this.tcbjDRAOrderMapper.updateById((BaseEo)one);
        return new RestResponse("0", "success");
    }

    @Override
    public void updateNotiBatch(List<OrderCargoBatchReqDto> orderCargoBatchReqDto) {
        logger.info("\u4fee\u590d\u901a\u77e5\u5355\u6279\u6b21:{}", orderCargoBatchReqDto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void combinationActPreempt(TcbjCombinationActReqDto combinationActReqDto) {
        logger.info("combinationActPreempt==>\u7ec4\u5408\u5957\u88c5\u5546\u54c1\uff0c\u5e93\u5b58\u9884\u5360\u63a5\u53e3,combinationActReqDto:{}", (Object)LogUtils.buildLogContent(combinationActReqDto));
        this.checkParams(combinationActReqDto);
        this.doCombinationActPreempt(combinationActReqDto);
    }

    private void checkParams(TcbjCombinationActReqDto combinationActReqDto) {
        if (CollectionUtils.isEmpty((Collection)combinationActReqDto.getDetailReqDtoList())) {
            return;
        }
        Map cargoEoMap = this.cargoMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery((Object)new CargoEo()).in(BaseEo::getId, (Collection)combinationActReqDto.getDetailReqDtoList().stream().map(TcbjCombinationActDetailReqDto::getCargoId).distinct().collect(Collectors.toList()))).eq(BaseEo::getDr, (Object)0)).stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
        combinationActReqDto.getDetailReqDtoList().forEach(r -> {
            CargoEo mapOrDefault = cargoEoMap.getOrDefault(r.getCargoId(), new CargoEo());
            r.setCargoCode(mapOrDefault.getCode());
            r.setCargoName(mapOrDefault.getName());
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void backtrackInventory(TcbjCombinationActBacktrackReqDto combinationActBacktrackReqDto) {
        logger.info("backtrackInventory==>\u7ec4\u5408\u5957\u88c5\u5546\u54c1\uff0c\u6d3b\u52a8\u7ed3\u675f\uff0c\u8fd4\u8fd8\u5e93\u5b58,combinationActBacktrackReqDto:{}", (Object)LogUtils.buildLogContent(combinationActBacktrackReqDto));
        AssertUtil.isTrue(null != combinationActBacktrackReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Long activityId = combinationActBacktrackReqDto.getActivityId();
        AssertUtil.isTrue(null != activityId && activityId > 0L, "\u6d3b\u52a8ID\u53c2\u6570\u6709\u8bef");
        String activityCode = combinationActBacktrackReqDto.getActivityCode();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)activityCode), "\u6d3b\u52a8\u7f16\u7801\u53c2\u6570\u6709\u8bef");
        CsActivityInventoryEo csActivityInventoryEo = new CsActivityInventoryEo();
        csActivityInventoryEo.setActivityId(activityId);
        List activityInventoryEoList = this.csActivityInventoryDas.selectList((BaseEo)csActivityInventoryEo);
        logger.info("backtrackInventory==>\u7ec4\u5408\u5957\u88c5\u5546\u54c1\uff0c\u6d3b\u52a8\u7ed3\u675f\uff0c\u8fd4\u8fd8\u5e93\u5b58,activityInventoryEoList:{}", (Object)LogUtils.buildLogContent(activityInventoryEoList));
        if (CollectionUtils.isEmpty((Collection)activityInventoryEoList)) {
            return;
        }
        CsInventoryOperateReqDto inventoryOperateReqDto = new CsInventoryOperateReqDto();
        ArrayList operateCargoReqDtoList = Lists.newArrayList();
        inventoryOperateReqDto.setInOutFlag(CsInventoryInOutEnum.IN.getCode());
        inventoryOperateReqDto.setSourceNo(combinationActBacktrackReqDto.getActivityCode());
        inventoryOperateReqDto.setSourceType(CsInventorySourceTypeEnum.IN_ACT_FINISH_BACKTRACK.getCode());
        inventoryOperateReqDto.setOperateCargoReqDtoList((List)operateCargoReqDtoList);
        ArrayList csActivityInventoryLogEoList = Lists.newArrayList();
        Map<String, CsActivityInventoryEo> csActEoMap = activityInventoryEoList.stream().collect(Collectors.toMap(eo -> eo.getActivityId() + "_" + eo.getWarehouseCode() + "_" + eo.getCargoCode() + "_" + eo.getBatch(), Function.identity()));
        activityInventoryEoList.forEach(eo -> {
            CsInventoryOperateCargoReqDto dto = new CsInventoryOperateCargoReqDto();
            dto.setId(eo.getId());
            dto.setBatch(eo.getBatch());
            dto.setChangeInventory(eo.getPreempt());
            dto.setActivityId(eo.getActivityId());
            dto.setCargoCode(eo.getCargoCode());
            dto.setWarehouseCode(eo.getWarehouseCode());
            operateCargoReqDtoList.add(dto);
            CsActivityInventoryLogEo inventoryActivityLogEo = new CsActivityInventoryLogEo();
            CubeBeanUtils.copyProperties((Object)inventoryActivityLogEo, (Object)eo, (String[])new String[0]);
            inventoryActivityLogEo.setId(null);
            inventoryActivityLogEo.setBeforeBalance(eo.getBalance());
            inventoryActivityLogEo.setChangeBalance(eo.getBalance());
            inventoryActivityLogEo.setAfterBalance(BigDecimal.ZERO);
            inventoryActivityLogEo.setBeforePreempt(eo.getPreempt());
            inventoryActivityLogEo.setChangePreempt(eo.getPreempt());
            inventoryActivityLogEo.setAfterBalance(BigDecimal.ZERO);
            inventoryActivityLogEo.setBeforeCompleted(eo.getCompleted());
            inventoryActivityLogEo.setChangeCompleted(eo.getCompleted());
            inventoryActivityLogEo.setAfterCompleted(BigDecimal.ZERO);
            inventoryActivityLogEo.setBeforeAvailable(eo.getAvailable());
            inventoryActivityLogEo.setChangeAvailable(eo.getAvailable());
            inventoryActivityLogEo.setAfterAvailable(BigDecimal.ZERO);
            inventoryActivityLogEo.setSourceType(CsInventorySourceTypeEnum.IN_ACT_FINISH_BACKTRACK.getCode());
            csActivityInventoryLogEoList.add(inventoryActivityLogEo);
        });
        this.releaseActInventory(inventoryOperateReqDto, inventoryOperateReqDto.getOperateCargoReqDtoList(), csActEoMap);
        this.releaseCommonInventory(inventoryOperateReqDto, inventoryOperateReqDto.getOperateCargoReqDtoList(), csActEoMap);
        for (CsActivityInventoryEo updateEo : activityInventoryEoList) {
            updateEo.setFinishFlag(CsActivityInventoryStatusEnum.TERMINATE.getCode());
            this.csActivityInventoryDas.updateSelective((BaseEo)updateEo);
        }
        InventoryPreemptionEo preemptionEo = new InventoryPreemptionEo();
        preemptionEo.setActivityFlag(YesNoEnum.NO.getValue());
        preemptionEo.setUpdateTime(new Date());
        preemptionEo.setDisplay(YesNoEnum.YES.getValue());
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"activity_id", (Object)activityId);
        updateWrapper.eq((Object)"activity_flag", (Object)YesNoEnum.YES.getValue());
        updateWrapper.eq((Object)"valid", (Object)CsValidFlagEnum.ENABLE.getCode());
        updateWrapper.eq((Object)"dr", (Object)0);
        logger.info("\u66f4\u65b0\u9884\u5360\u8868\u4e3a\u4e0d\u662f\u6d3b\u52a8\u5546\u54c1");
        this.inventoryPreemptionDomain.getMapper().update((Object)preemptionEo, (Wrapper)updateWrapper);
        preemptionEo = new InventoryPreemptionEo();
        preemptionEo.setDisplay(YesNoEnum.NO.getValue());
        preemptionEo.setUpdateTime(new Date());
        updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"activity_id", (Object)activityId);
        updateWrapper.eq((Object)"source_type", (Object)CsInventorySourceTypeEnum.OUT_ACT_AUDIT_PREEMPT.getCode());
        updateWrapper.eq((Object)"display", (Object)YesNoEnum.YES.getValue());
        updateWrapper.eq((Object)"dr", (Object)0);
        logger.info("\u66f4\u65b0\u6d3b\u52a8\u5ba1\u6838\u9884\u5360");
        this.inventoryPreemptionDomain.getMapper().update((Object)preemptionEo, (Wrapper)updateWrapper);
    }

    private Boolean releaseActInventory(CsInventoryOperateReqDto inventoryOperateReqDto, List<CsInventoryOperateCargoReqDto> actCargoList, Map<String, CsActivityInventoryEo> csActEoMap) {
        CsInventoryOperateReqDto actOperateReqDto = new CsInventoryOperateReqDto();
        CubeBeanUtils.copyProperties((Object)actOperateReqDto, (Object)inventoryOperateReqDto, (String[])new String[0]);
        actOperateReqDto.setOperateCargoReqDtoList(actCargoList);
        ICsInventoryBasicsService activityInventoryService = CsInventoryStrategyUtils.getInventoryService(CsInventoryStrategyEnum.ACTIVITY.getCode());
        logger.info("preemptInventory==>\u91ca\u653e\u9884\u5360\u7684\u6d3b\u52a8\u5e93\u5b58,sourceNo:{},activityInventoryService:{}", (Object)inventoryOperateReqDto.getSourceNo(), (Object)LogUtils.buildLogContent(activityInventoryService));
        ArrayList inOutBasicsCargoDtoList = Lists.newArrayList();
        CsInventoryInOutBasicsDto csInventoryInOutBasicsDto = new CsInventoryInOutBasicsDto();
        csInventoryInOutBasicsDto.setInOutFlag(inventoryOperateReqDto.getInOutFlag());
        csInventoryInOutBasicsDto.setStrategy(CsInventoryStrategyEnum.ACTIVITY.getCode());
        csInventoryInOutBasicsDto.setNegativeValidate(YesNoEnum.YES.getValue());
        csInventoryInOutBasicsDto.setSourceNo(inventoryOperateReqDto.getSourceNo());
        csInventoryInOutBasicsDto.setSourceType(inventoryOperateReqDto.getSourceType());
        for (CsInventoryOperateCargoReqDto actDto : actCargoList) {
            String key = actDto.getActivityId() + "_" + actDto.getWarehouseCode() + "_" + actDto.getCargoCode() + "_" + actDto.getBatch();
            CsActivityInventoryEo csActivityInventoryEo = csActEoMap.get(key);
            if (null == csActivityInventoryEo) continue;
            CsInventoryInOutBasicsCargoDto inOutBasicsCargoDto = new CsInventoryInOutBasicsCargoDto();
            inOutBasicsCargoDto.setId(actDto.getId());
            inOutBasicsCargoDto.setCargoCode(actDto.getCargoCode());
            inOutBasicsCargoDto.setActivityFlag(YesNoEnum.YES.getValue());
            inOutBasicsCargoDto.setActivityId(actDto.getActivityId());
            BigDecimal available = csActivityInventoryEo.getAvailable() == null ? BigDecimal.ZERO : csActivityInventoryEo.getAvailable();
            BigDecimal updateDecimal = BigDecimal.ZERO.compareTo(available) == 0 ? null : available.abs().negate();
            inOutBasicsCargoDto.setBalance(updateDecimal);
            inOutBasicsCargoDto.setAvailable(updateDecimal);
            inOutBasicsCargoDto.setWarehouseCode(actDto.getWarehouseCode());
            inOutBasicsCargoDto.setBatch(actDto.getBatch());
            inOutBasicsCargoDto.setCargoProportion(actDto.getCargoProportion());
            inOutBasicsCargoDtoList.add(inOutBasicsCargoDto);
        }
        csInventoryInOutBasicsDto.setInOutBasicsCargoDtoList((List)inOutBasicsCargoDtoList);
        logger.info("preemptInventory==>\u6d3b\u52a8\u7ed3\u675f\uff0c\u91ca\u653e\u9884\u5360\u7684\u6d3b\u52a8\u5e93\u5b58,\u5373\u5c06\u8c03\u7528\u5165\u5e93,sourceNo:{},csInventoryInOutBasicsDto:{}", (Object)inventoryOperateReqDto.getSourceNo(), (Object)LogUtils.buildLogContent(csInventoryInOutBasicsDto));
        Boolean commonFlag = activityInventoryService.inInventory(csInventoryInOutBasicsDto);
        logger.info("preemptInventory==>\u6d3b\u52a8\u7ed3\u675f\uff0c\u91ca\u653e\u9884\u5360\u7684\u6d3b\u52a8\u5e93\u5b58,\u5165\u5e93\u540e\u7684\u64cd\u4f5c\u7ed3\u679c,sourceNo:{},commonFlag:{}", (Object)inventoryOperateReqDto.getSourceNo(), (Object)LogUtils.buildLogContent(commonFlag));
        return commonFlag;
    }

    private Boolean releaseCommonInventory(CsInventoryOperateReqDto inventoryOperateReqDto, List<CsInventoryOperateCargoReqDto> commonCargoList, Map<String, CsActivityInventoryEo> csActEoMap) {
        logger.info("preemptInventory==>\u91ca\u653e\u9884\u5360\u7684\u903b\u8f91\u4ed3\u5e93\u5b58,inventoryOperateReqDto:{},commonCargoList:{}", (Object)LogUtils.buildLogContent(inventoryOperateReqDto), (Object)LogUtils.buildLogContent(commonCargoList));
        ReleasePreemptDto preemptDto = new ReleasePreemptDto();
        preemptDto.setIsActivityPreempt(Boolean.valueOf(true));
        preemptDto.setSourceNo(inventoryOperateReqDto.getSourceNo());
        preemptDto.setSourceType(inventoryOperateReqDto.getSourceType());
        preemptDto.setExternalOrderNo(inventoryOperateReqDto.getPlatformOrderNo());
        preemptDto.setValidNegative(Boolean.valueOf(!Objects.equals(0, inventoryOperateReqDto.getNegativeValidate())));
        preemptDto.setDetails(commonCargoList.stream().map(r -> {
            CalcDetailDto calcDetailDto = (CalcDetailDto)BeanUtil.copyProperties((Object)r, CalcDetailDto.class, (String[])new String[0]);
            calcDetailDto.setSkuCode(r.getCargoCode());
            calcDetailDto.setNum(r.getChangeInventory());
            return calcDetailDto;
        }).collect(Collectors.toList()));
        this.calcInventoryService.releasePreempt(preemptDto);
        logger.info("preemptInventory==>\u6d3b\u52a8\u7ed3\u675f\uff0c\u91ca\u653e\u9884\u5360\u7684\u903b\u8f91\u4ed3\u5e93\u5b58,\u5165\u5e93\u540e\u7684\u64cd\u4f5c\u7ed3\u679c,commonFlag:{}", (Object)LogUtils.buildLogContent(preemptDto));
        return true;
    }

    @Override
    public List<TcbjInventoryActRespDto> inventoryActQuery(TcbjInventoryActReqDto inventoryActReqDto) {
        logger.info("inventoryActQuery==>\u7ec4\u5408\u5957\u88c5\u6d3b\u52a8\u5546\u54c1,\u5e93\u5b58\u67e5\u8be2,inventoryActReqDto:{}", (Object)LogUtils.buildLogContent(inventoryActReqDto));
        AssertUtil.isTrue(null != inventoryActReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList inventoryActRespDtoList = Lists.newArrayList();
        QueryWrapper<CsActivityInventoryEo> inventoryActivityEoQueryWrapper = this.buildCsActivityInventoryQueryWrapper(inventoryActReqDto);
        logger.info("inventoryActQuery==>\u67e5\u8be2\u53c2\u6570,inventoryActivityEoQueryWrapper:{}", (Object)LogUtils.buildLogContent(inventoryActivityEoQueryWrapper));
        List inventoryActivityEoList = this.csActivityInventoryMapper.selectList(inventoryActivityEoQueryWrapper);
        logger.info("inventoryActQuery==>\u67e5\u8be2\u5230\u7684\u96c6\u5408\u6570\u636e,inventoryActivityEoList:{}", (Object)LogUtils.buildLogContent(inventoryActivityEoList));
        if (CollectionUtil.isEmpty((Collection)inventoryActivityEoList)) {
            return inventoryActRespDtoList;
        }
        Map<Long, List<CsActivityInventoryEo>> inventoryActEoGroupMap = inventoryActivityEoList.stream().collect(Collectors.groupingBy(CsActivityInventoryEo::getActivityId));
        logger.info("inventoryActQuery==>\u5206\u7ec4\u540e\u7684\u6570\u636e,inventoryActEoGroupMap:{}", (Object)LogUtils.buildLogContent(inventoryActEoGroupMap));
        for (Map.Entry<Long, List<CsActivityInventoryEo>> entry : inventoryActEoGroupMap.entrySet()) {
            List<CsActivityInventoryEo> actEoList = entry.getValue();
            if (CollectionUtil.isEmpty(actEoList)) continue;
            CsActivityInventoryEo inventoryActivityEo = actEoList.get(0);
            TcbjInventoryActRespDto tcbjInventoryActRespDto = new TcbjInventoryActRespDto();
            ArrayList detailRespDtoList = Lists.newArrayList();
            tcbjInventoryActRespDto.setDetailRespDtoList((List)detailRespDtoList);
            tcbjInventoryActRespDto.setActivityId(inventoryActivityEo.getActivityId());
            tcbjInventoryActRespDto.setActivityCode(inventoryActivityEo.getActivityCode());
            tcbjInventoryActRespDto.setActivityName(inventoryActivityEo.getActivityName());
            tcbjInventoryActRespDto.setOriginalActivityNum(inventoryActivityEo.getActivityNum());
            for (CsActivityInventoryEo tempActEo : actEoList) {
                TcbjInventoryActDetailRespDto inventoryActDetailRespDto = new TcbjInventoryActDetailRespDto();
                inventoryActDetailRespDto.setCargoId(tempActEo.getCargoId());
                inventoryActDetailRespDto.setCargoCode(tempActEo.getCargoCode());
                inventoryActDetailRespDto.setCargoName(tempActEo.getCargoName());
                inventoryActDetailRespDto.setWarehouseId(tempActEo.getWarehouseId());
                inventoryActDetailRespDto.setWarehouseCode(tempActEo.getWarehouseCode());
                inventoryActDetailRespDto.setWarehouseName(tempActEo.getWarehouseName());
                inventoryActDetailRespDto.setActivityBalance(tempActEo.getBalance());
                inventoryActDetailRespDto.setActivitySold(tempActEo.getPreempt().add(tempActEo.getCompleted()));
                inventoryActDetailRespDto.setActivitySurplus(tempActEo.getAvailable());
                detailRespDtoList.add(inventoryActDetailRespDto);
            }
            inventoryActRespDtoList.add(tcbjInventoryActRespDto);
        }
        logger.info("inventoryActQuery==>\u8fd4\u56de\u6570\u636e,inventoryActRespDtoList:{}", (Object)LogUtils.buildLogContent(inventoryActRespDtoList));
        return inventoryActRespDtoList;
    }

    private QueryWrapper<CsActivityInventoryEo> buildCsActivityInventoryQueryWrapper(TcbjInventoryActReqDto inventoryActReqDto) {
        QueryWrapper inventoryActivityEoQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)inventoryActReqDto.getBatch())) {
            inventoryActivityEoQueryWrapper.eq((Object)"batch", (Object)inventoryActReqDto.getBatch());
        }
        if (null != inventoryActReqDto.getCargoId()) {
            inventoryActivityEoQueryWrapper.eq((Object)"cargo_id", (Object)inventoryActReqDto.getCargoId());
        }
        if (StringUtils.isNotBlank((CharSequence)inventoryActReqDto.getCargoCode())) {
            inventoryActivityEoQueryWrapper.eq((Object)"cargo_code", (Object)inventoryActReqDto.getCargoCode());
        }
        if (null != inventoryActReqDto.getWarehouseId()) {
            inventoryActivityEoQueryWrapper.eq((Object)"warehouse_id", (Object)inventoryActReqDto.getWarehouseId());
        }
        if (StringUtils.isNotBlank((CharSequence)inventoryActReqDto.getWarehouseCode())) {
            inventoryActivityEoQueryWrapper.eq((Object)"warehouse_code", (Object)inventoryActReqDto.getWarehouseCode());
        }
        if (null != inventoryActReqDto.getActivityId()) {
            inventoryActivityEoQueryWrapper.eq((Object)"activity_id", (Object)inventoryActReqDto.getActivityId());
        }
        if (StringUtils.isNotBlank((CharSequence)inventoryActReqDto.getActivityCode())) {
            inventoryActivityEoQueryWrapper.eq((Object)"activity_code", (Object)inventoryActReqDto.getActivityCode());
        }
        if (CollectionUtil.isNotEmpty((Collection)inventoryActReqDto.getCargoIdList())) {
            inventoryActivityEoQueryWrapper.in((Object)"cargo_id", (Collection)inventoryActReqDto.getCargoIdList());
        }
        if (CollectionUtil.isNotEmpty((Collection)inventoryActReqDto.getCargoCodeList())) {
            inventoryActivityEoQueryWrapper.in((Object)"cargo_code", (Collection)inventoryActReqDto.getCargoCodeList());
        }
        if (CollectionUtil.isNotEmpty((Collection)inventoryActReqDto.getWarehouseIdList())) {
            inventoryActivityEoQueryWrapper.in((Object)"warehouse_id", (Collection)inventoryActReqDto.getWarehouseIdList());
        }
        if (CollectionUtil.isNotEmpty((Collection)inventoryActReqDto.getWarehouseCodeList())) {
            inventoryActivityEoQueryWrapper.in((Object)"warehouse_code", (Collection)inventoryActReqDto.getWarehouseCodeList());
        }
        if (CollectionUtil.isNotEmpty((Collection)inventoryActReqDto.getActivityIdList())) {
            inventoryActivityEoQueryWrapper.in((Object)"activity_id", (Collection)inventoryActReqDto.getActivityIdList());
        }
        if (CollectionUtil.isNotEmpty((Collection)inventoryActReqDto.getActivityCodeList())) {
            inventoryActivityEoQueryWrapper.in((Object)"activity_code", (Collection)inventoryActReqDto.getActivityCodeList());
        }
        if (CollectionUtil.isNotEmpty((Collection)inventoryActReqDto.getBatchList())) {
            inventoryActivityEoQueryWrapper.in((Object)"batch", (Collection)inventoryActReqDto.getBatchList());
        }
        return inventoryActivityEoQueryWrapper;
    }

    private QueryWrapper<InventoryActivityEo> buildQueryWrapper(TcbjInventoryActReqDto inventoryActReqDto) {
        QueryWrapper inventoryActivityEoQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)inventoryActReqDto.getBatch())) {
            inventoryActivityEoQueryWrapper.eq((Object)"batch", (Object)inventoryActReqDto.getBatch());
        }
        if (null != inventoryActReqDto.getCargoId()) {
            inventoryActivityEoQueryWrapper.eq((Object)"cargo_id", (Object)inventoryActReqDto.getCargoId());
        }
        if (StringUtils.isNotBlank((CharSequence)inventoryActReqDto.getCargoCode())) {
            inventoryActivityEoQueryWrapper.eq((Object)"cargo_code", (Object)inventoryActReqDto.getCargoCode());
        }
        if (null != inventoryActReqDto.getWarehouseId()) {
            inventoryActivityEoQueryWrapper.eq((Object)"warehouse_id", (Object)inventoryActReqDto.getWarehouseId());
        }
        if (StringUtils.isNotBlank((CharSequence)inventoryActReqDto.getWarehouseCode())) {
            inventoryActivityEoQueryWrapper.eq((Object)"warehouse_code", (Object)inventoryActReqDto.getWarehouseCode());
        }
        if (null != inventoryActReqDto.getActivityId()) {
            inventoryActivityEoQueryWrapper.eq((Object)"activity_id", (Object)inventoryActReqDto.getActivityId());
        }
        if (StringUtils.isNotBlank((CharSequence)inventoryActReqDto.getActivityCode())) {
            inventoryActivityEoQueryWrapper.eq((Object)"activity_code", (Object)inventoryActReqDto.getActivityCode());
        }
        if (CollectionUtil.isNotEmpty((Collection)inventoryActReqDto.getCargoIdList())) {
            inventoryActivityEoQueryWrapper.in((Object)"cargo_id", (Collection)inventoryActReqDto.getCargoIdList());
        }
        if (CollectionUtil.isNotEmpty((Collection)inventoryActReqDto.getCargoCodeList())) {
            inventoryActivityEoQueryWrapper.in((Object)"cargo_code", (Collection)inventoryActReqDto.getCargoCodeList());
        }
        if (CollectionUtil.isNotEmpty((Collection)inventoryActReqDto.getWarehouseIdList())) {
            inventoryActivityEoQueryWrapper.in((Object)"warehouse_id", (Collection)inventoryActReqDto.getWarehouseIdList());
        }
        if (CollectionUtil.isNotEmpty((Collection)inventoryActReqDto.getWarehouseCodeList())) {
            inventoryActivityEoQueryWrapper.in((Object)"warehouse_code", (Collection)inventoryActReqDto.getWarehouseCodeList());
        }
        if (CollectionUtil.isNotEmpty((Collection)inventoryActReqDto.getActivityIdList())) {
            inventoryActivityEoQueryWrapper.in((Object)"activity_id", (Collection)inventoryActReqDto.getActivityIdList());
        }
        if (CollectionUtil.isNotEmpty((Collection)inventoryActReqDto.getActivityCodeList())) {
            inventoryActivityEoQueryWrapper.in((Object)"activity_code", (Collection)inventoryActReqDto.getActivityCodeList());
        }
        if (CollectionUtil.isNotEmpty((Collection)inventoryActReqDto.getBatchList())) {
            inventoryActivityEoQueryWrapper.in((Object)"batch", (Collection)inventoryActReqDto.getBatchList());
        }
        return inventoryActivityEoQueryWrapper;
    }

    private void doCombinationActPreempt(TcbjCombinationActReqDto combinationActReqDto) {
        logger.info("doCombinationActPreempt==>\u7ec4\u5408\u5957\u88c5\u5546\u54c1\uff0c\u8c03\u7528\u539f\u6709\u7684\u5e93\u5b58\u9884\u5360\u63a5\u53e3,combinationActReqDto:{}", (Object)LogUtils.buildLogContent(combinationActReqDto));
        CsInventoryOperateReqDto inventoryOperateReqDto = new CsInventoryOperateReqDto();
        ArrayList operateCargoReqDtoList = Lists.newArrayList();
        inventoryOperateReqDto.setSourceNo(combinationActReqDto.getActivityCode());
        inventoryOperateReqDto.setSourceType(CsInventorySourceTypeEnum.OUT_ACT_AUDIT_PREEMPT.getCode());
        inventoryOperateReqDto.setOperateCargoReqDtoList((List)operateCargoReqDtoList);
        List detailReqDtoList = combinationActReqDto.getDetailReqDtoList();
        detailReqDtoList.forEach(detailDto -> {
            BigDecimal preemptNum = detailDto.getPreemptNum();
            CsInventoryOperateCargoReqDto csInventoryOperateCargoReqDto = new CsInventoryOperateCargoReqDto();
            csInventoryOperateCargoReqDto.setBatch(detailDto.getBatch());
            csInventoryOperateCargoReqDto.setChangeInventory(preemptNum);
            csInventoryOperateCargoReqDto.setCargoCode(detailDto.getCargoCode());
            csInventoryOperateCargoReqDto.setCargoProportion(detailDto.getRatio());
            csInventoryOperateCargoReqDto.setActivityId(combinationActReqDto.getActivityId());
            csInventoryOperateCargoReqDto.setWarehouseCode(combinationActReqDto.getWarehouseCode());
            operateCargoReqDtoList.add(csInventoryOperateCargoReqDto);
        });
        logger.info("doCombinationActPreempt==>\u7ec4\u5408\u5957\u88c5\u5546\u54c1\uff0c\u8c03\u7528\u539f\u6709\u7684\u5e93\u5b58\u9884\u5360\u63a5\u53e3,inventoryOperateReqDto:{}", (Object)LogUtils.buildLogContent(inventoryOperateReqDto));
        CsInventoryInOutBasicsCargoDto baseCargoDto = new CsInventoryInOutBasicsCargoDto();
        baseCargoDto.setActivityName(combinationActReqDto.getActivityName());
        baseCargoDto.setActivityCode(combinationActReqDto.getActivityCode());
        baseCargoDto.setActivityType(combinationActReqDto.getActivityType());
        baseCargoDto.setActivityNum(combinationActReqDto.getSuiteNum());
        baseCargoDto.setShopId(combinationActReqDto.getShopId());
        baseCargoDto.setWarehouseId(combinationActReqDto.getWarehouseId());
        RestResponse shopDtoRestResponse = this.shopQueryApi.queryById(combinationActReqDto.getShopId().longValue(), new String[]{"{}"});
        ShopDto shopDto = (ShopDto)RestResponseHelper.extractData((RestResponse)shopDtoRestResponse);
        baseCargoDto.setShopName(shopDto.getName());
        baseCargoDto.setShopCode(shopDto.getCode());
        baseCargoDto.setWarehouseName(combinationActReqDto.getWarehouseName());
        baseCargoDto.setSuitCode(combinationActReqDto.getSuitCode());
        baseCargoDto.setSuitName(combinationActReqDto.getSuitName());
        Boolean actFlag = this.preemptActInventory(inventoryOperateReqDto, inventoryOperateReqDto.getOperateCargoReqDtoList(), baseCargoDto);
        Boolean commonFlag = this.preemptCommonInventory(inventoryOperateReqDto, inventoryOperateReqDto.getOperateCargoReqDtoList());
        if (!actFlag.booleanValue() || !commonFlag.booleanValue()) {
            throw new BizException("\u6d3b\u52a8\u5e93\u5b58\u9884\u5360\u5f02\u5e38");
        }
    }

    @Override
    public PageInfo<TbjcInventoryActLogRespDto> inventoryActLogPageQuery(TcbjInventoryActLogReqDto inventoryActLogReqDto) {
        logger.info("inventoryActLogPageQuery==>\u6d3b\u52a8\u5e93\u5b58\u6d41\u6c34\u5206\u9875\u67e5\u8be2,inventoryActLogReqDto:{}", (Object)LogUtils.buildLogContent(inventoryActLogReqDto));
        this.checkParams(inventoryActLogReqDto);
        return null;
    }

    @Override
    public List<CargoStorageDto> queryCargoStorageByBatchesAndWarehouseCode(List<String> batchList, String warehouseCode) {
        AssertUtil.isTrue(CollectionUtils.isNotEmpty(batchList), "\u6279\u6b21\u53f7\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)warehouseCode), "\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"warehouse_code", (Object)warehouseCode);
        queryWrapper.in((Object)"batch", batchList);
        queryWrapper.eq((Object)"dr", (Object)"0");
        List list = this.logicInventoryDomain.getMapper().selectList((Wrapper)queryWrapper);
        ArrayList<CargoStorageDto> collect = new ArrayList<CargoStorageDto>();
        CubeBeanUtils.copyCollection(collect, (Collection)list, CargoStorageDto.class);
        return collect;
    }

    private void checkParams(TcbjInventoryActLogReqDto inventoryActLogReqDto) {
        AssertUtil.isTrue(null != inventoryActLogReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private PageInfo<CargoStorageExtDto> queryCsLogicInventoryTotalPage(Integer pageNum, Integer pageSize, QueryWrapper<LogicInventoryTotalEo> querywrapper) {
        PageInfo result = new PageInfo();
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List list = this.logicInventoryTotalDomain.getMapper().selectList(querywrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return result;
        }
        List collect = list.stream().map(e -> {
            CargoStorageExtDto cargoStorageDto = new CargoStorageExtDto();
            BeanUtils.copyProperties((Object)e, (Object)cargoStorageDto);
            return cargoStorageDto;
        }).collect(Collectors.toList());
        PageInfo info = new PageInfo(list);
        BeanUtils.copyProperties((Object)info, (Object)result);
        result.setList(collect);
        return result;
    }

    private QueryWrapper<LogicInventoryTotalEo> getLogicInventoryTotalEoQueryWrapper(CargoStorageDto queryDto) {
        QueryWrapper querywrapper = new QueryWrapper();
        if (queryDto.getWarehouseId() != null) {
            querywrapper.eq((Object)"warehouse_id", (Object)queryDto.getWarehouseId());
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{queryDto.getWarehouseCode()})) {
            querywrapper.eq((Object)"warehouse_code", (Object)queryDto.getWarehouseCode());
        }
        if (queryDto.getCargoId() != null) {
            querywrapper.eq((Object)"cargo_id", (Object)queryDto.getCargoId());
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{queryDto.getCargoCode()})) {
            querywrapper.eq((Object)"sku_code", (Object)queryDto.getCargoCode());
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{queryDto.getCargoName()})) {
            querywrapper.like((Object)"sku_name", (Object)queryDto.getCargoName());
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{queryDto.getArtNo()})) {
            querywrapper.like((Object)"art_no", (Object)queryDto.getArtNo());
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{queryDto.getBatch()})) {
            querywrapper.like((Object)"batch", (Object)queryDto.getBatch());
        }
        querywrapper.eq((Object)"dr", (Object)"0");
        return querywrapper;
    }

    private PageInfo<CargoStorageExtDto> queryCsLogicInventoryPage(Integer pageNum, Integer pageSize, QueryWrapper<LogicInventoryEo> querywrapper) {
        PageInfo result = new PageInfo();
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List list = this.logicInventoryDomain.getMapper().selectList(querywrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return result;
        }
        List collect = list.stream().map(e -> {
            CargoStorageExtDto cargoStorageDto = new CargoStorageExtDto();
            BeanUtils.copyProperties((Object)e, (Object)cargoStorageDto);
            return cargoStorageDto;
        }).collect(Collectors.toList());
        PageInfo info = new PageInfo(list);
        BeanUtils.copyProperties((Object)info, (Object)result);
        result.setList(collect);
        return result;
    }

    private QueryWrapper<LogicInventoryEo> getLogicInventoryEoQueryWrapper(CargoStorageDto queryDto) {
        QueryWrapper querywrapper = new QueryWrapper();
        if (queryDto.getWarehouseId() != null) {
            querywrapper.eq((Object)"warehouse_id", (Object)queryDto.getWarehouseId());
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{queryDto.getWarehouseCode()})) {
            querywrapper.eq((Object)"warehouse_code", (Object)queryDto.getWarehouseCode());
        }
        if (queryDto.getCargoId() != null) {
            querywrapper.eq((Object)"cargo_id", (Object)queryDto.getCargoId());
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{queryDto.getCargoCode()})) {
            querywrapper.eq((Object)"sku_code", (Object)queryDto.getCargoCode());
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{queryDto.getCargoName()})) {
            querywrapper.like((Object)"sku_name", (Object)queryDto.getCargoName());
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{queryDto.getArtNo()})) {
            querywrapper.like((Object)"art_no", (Object)queryDto.getArtNo());
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{queryDto.getBatch()})) {
            querywrapper.like((Object)"batch", (Object)queryDto.getBatch());
        }
        querywrapper.eq((Object)"dr", (Object)"0");
        return querywrapper;
    }
}

