/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.apiimpl.cs.order;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsDeliveryNoticeOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.exception.InventoryExceptionCode;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsDeliveryNoticeOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsDeliveryNoticeOrderDetailQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryNoticeOrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryNoticeOrderRespDto;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.inventory.dto.domain.CsDeliveryNoticeOrderQueryDto;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="csDeliveryNoticeOrderQueryApi")
public class CsDeliveryNoticeOrderQueryApiImpl
implements ICsDeliveryNoticeOrderQueryApi {
    private static Logger logger = LoggerFactory.getLogger(CsDeliveryNoticeOrderQueryApiImpl.class);
    @Autowired
    private ICsDeliveryNoticeOrderQueryService csDeliveryNoticeOrderQueryService;

    public RestResponse<CsDeliveryNoticeOrderRespDto> queryByPrimaryKey(Long id) {
        logger.info("\u6839\u636eid\u67e5\u8be2\u4fe1\u606f\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        CsDeliveryNoticeOrderRespDto csDeliveryNoticeOrderRespDto = this.csDeliveryNoticeOrderQueryService.queryById(id);
        AssertUtil.isTrue(csDeliveryNoticeOrderRespDto != null, InventoryExceptionCode.RECORD_NOT_EXIST.getMsg());
        return new RestResponse((Object)csDeliveryNoticeOrderRespDto);
    }

    public RestResponse<CsDeliveryNoticeOrderRespDto> queryByDocumentNo(String documentNo) {
        return new RestResponse((Object)this.csDeliveryNoticeOrderQueryService.queryByDocumentNo(documentNo));
    }

    public RestResponse<CsDeliveryNoticeOrderRespDto> queryVersionSecondByDocumentNo(String documentNo) {
        return null;
    }

    public RestResponse<PageInfo<CsDeliveryNoticeOrderDetailRespDto>> queryDeliveryNoticeOrderDetails(CsDeliveryNoticeOrderDetailQueryDto dto) {
        return null;
    }

    public RestResponse<PageInfo<CsDeliveryNoticeOrderRespDto>> queryByPage(CsDeliveryNoticeOrderQueryDto queryDto) {
        logger.info("\u5206\u9875\u67e5\u8be2\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(queryDto, "pageNum", "pageSize"));
        PageInfo<CsDeliveryNoticeOrderRespDto> pageInfo = this.csDeliveryNoticeOrderQueryService.queryByPage(queryDto);
        return new RestResponse(pageInfo);
    }

    public RestResponse<List<CsDeliveryNoticeOrderRespDto>> queryByParam(CsDeliveryNoticeOrderQueryDto queryDto) {
        logger.info("\u67e5\u8be2\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(queryDto));
        return new RestResponse(null);
    }

    public RestResponse<List<String>> queryPreOrderNoIsBatch(List<String> preOrderNoList) {
        logger.info("\u6279\u91cf\u67e5\u8be2\u8ba2\u5355\u5173\u8054\u7684\u53d1\u8d27\u901a\u77e5\u5355\uff0c\u6ca1\u6709\u8bbe\u7f6e\u6279\u6b21\u7684\u524d\u7f6e\u5355\u636e\u53f7\uff08\u8ba2\u5355\u53f7\uff09 \u5165\u53c2\uff1a[{}]", (Object)LogUtils.buildLogContent(preOrderNoList));
        List<String> list = this.csDeliveryNoticeOrderQueryService.queryPreOrderNoIsBatch(preOrderNoList);
        return new RestResponse(list);
    }

    public RestResponse<CsDeliveryNoticeOrderRespDto> queryByRelevanceNo(String relevanceNo) {
        return null;
    }
}

