/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.external.impl.wms;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.external.AbstractCsBasicsExternalService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.external.anno.CsBasicsExternalStrategy;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.IAdjustInTransitHandler;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.business.CsBusinessOrderCallBackUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.business.ICsBusinessOrderCallBackService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsLogicWarehouseQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.DateUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.IdUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.inventory.CsTransferOrderDetailDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsTransferOrderDetailEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsTransferOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.other.CsShipmenetEnterpriseEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.inventory.CsTransferOrderMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.other.CsShipmenetEnterpriseMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.bd.sap.PushItemReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.bd.sap.PushStorageOrderHeadReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.bd.sap.PushStorageOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.external.wms.CsBasicsCancelReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.external.wms.CsBasicsReceiveReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.external.wms.CsWmsBasicsDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.message.CsDeliveryReceiveNoticeOrderDetailMessageReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.message.CsDeliveryReceiveNoticeOrderMessageReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.message.CsInOutNoticeOrderDetailMessageReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.message.CsInOutNoticeOrderMessageReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.message.CsInOutNoticeOrderReceiveInfoMessageReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.message.CsInOutNoticeOrderSendInfoMessageReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOrderBusinessCallBackContext;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryReceiveResultDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryReceiveResultRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsInOutResultDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsInOutResultRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsBaseOrderAddressContactsTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsBusinessCallBackStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderItemStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsTransferDispatcherStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.SapCenterTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.bd.BdTypeOfDocumentEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.bd.PcpBasicInventoryBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.bd.PcpBasicTradeBusinessTypeEnum;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.enums.CsWarehouseClassifyEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.domain.entity.IBaseOrderAddressDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IRelWarehouseDomain;
import com.yunxi.dg.base.center.inventory.dto.domain.CsBasicsOrderReqDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsOutNoticeOrderDetailRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsWmsShippingInfoReqDto;
import com.yunxi.dg.base.center.inventory.eo.BaseOrderAddressEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.RelWarehouseEo;
import com.yunxi.dg.base.center.inventory.proxy.data.IPcpDictApiProxy;
import com.yunxi.dg.base.center.inventory.proxy.item.IItemSkuQueryApiProxy;
import com.yunxi.dg.base.center.inventory.proxy.transform.ITrLogisticsMappingRelationQueryApiProxy;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderCallBack;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderFacade;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderBaseContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.InOutResultOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.InOutResultOrderFacadeBo;
import com.yunxi.dg.base.center.item.ItemSkuDto;
import com.yunxi.dg.base.center.transform.LogisticsMappingType;
import com.yunxi.dg.base.center.transform.TrLogisticsMappingRelationReqDto;
import com.yunxi.dg.base.center.transform.TrLogisticsMappingRelationRespDto;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@CsBasicsExternalStrategy(strategyName="bd_wms")
@Component(value="csBdWmsExternalService")
public class CsBdWmsExternalServiceImpl
extends AbstractCsBasicsExternalService {
    private static Logger logger = LoggerFactory.getLogger(CsBdWmsExternalServiceImpl.class);
    private String portionFlag_key = "portionFlag_key";
    private String overchargeFlag_key = "overchargeFlag_key";
    private String inTransferHangUpFlag_key = "inTransferHangUpFlag_key";
    private String ADDRESS_NOT_FOUND_MSG = "\u57fa\u7840\u5355\u636e\u53d1\u3001\u6536\u8d27\u4eba\u5730\u5740\u4fe1\u606f\u627e\u4e0d\u5230";
    private String COMMON = "common";
    private String PACKAGE_MATERIAL = "packageMaterial";
    private final String ZT = "ZT";
    private final String OTHER = "OTHER";
    private final String ZT_SHIPMENT_NO = "zitifahuo";
    private final String OTHER_SHIPMENT_NO = "xunifahuo";
    @Autowired
    private ICommonsMqService mqService;
    @Autowired
    private IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Autowired
    private IInOutNoticeOrderDetailDomain inOutNoticeOrderDetailDomain;
    @Autowired
    private IReceiveDeliveryNoticeOrderDomain receiveDeliveryNoticeOrderDomain;
    @Autowired
    private IReceiveDeliveryNoticeOrderDetailDomain receiveDeliveryNoticeOrderDetailDomain;
    @Autowired
    private IInOutResultOrderDomain inOutResultOrderDomain;
    @Resource
    private IPcpDictApiProxy pcpDictApiProxy;
    @Autowired
    private IInOutResultOrderDetailDomain inOutResultOrderDetailDomain;
    @Autowired
    private IReceiveDeliveryResultOrderDomain receiveDeliveryResultOrderDomain;
    @Autowired
    private IReceiveDeliveryResultOrderDetailDomain receiveDeliveryResultOrderDetailDomain;
    @Resource
    private IBaseOrderAddressDomain baseOrderAddressDomain;
    @Resource
    private IRelWarehouseDomain relWarehouseDomain;
    @Resource
    private IItemSkuQueryApiProxy itemSkuQueryApiProxy;
    @Autowired
    private CsShipmenetEnterpriseMapper shipmenetEnterpriseMapper;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;
    @Resource
    private ILogicWarehouseDomain logicWarehouseDomain;
    @Resource
    IAdjustInTransitHandler adjustInTransitHandler;
    @Resource
    private BaseOrderFacade baseOrderFacade;
    @Autowired
    private CsTransferOrderMapper csTransferOrderMapper;
    @Resource
    private CsTransferOrderDetailDas csTransferOrderDetailDas;
    @Autowired
    private ITrLogisticsMappingRelationQueryApiProxy trLogisticsMappingRelationQueryApiProxy;
    @Autowired
    private ICsLogicWarehouseQueryService csLogicWarehouseQueryService;
    @Resource
    private ICommonsMqService commonsMqService;

    @Override
    public Boolean send(CsBasicsOrderReqDto sendInfo) {
        logger.info("\u63a8\u9001WMS\u7684\u65b9\u6cd5\u5165\u53c2 sendInfo:{}", (Object)LogUtils.buildLogContent(sendInfo));
        AssertUtil.isTrue(Objects.nonNull(sendInfo), "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String tag = sendInfo.getMessageTag();
        if (StringUtils.isBlank((CharSequence)tag)) {
            logger.info("\u63a8\u9001\u7684\u6d88\u606ftag\u4e3a\u7a7a\uff0c\u5373\u4e0d\u901a\u8fc7send\u65b9\u6cd5\u53d1\u9001mq\uff0c\u76f4\u63a5\u8fd4\u56de");
            return true;
        }
        return true;
    }

    private MessageVo buildDeliveryReceiveNoticeMqDto(CsBasicsOrderReqDto sendInfo) {
        String documentNo = sendInfo.getDocumentNo();
        ReceiveDeliveryNoticeOrderEo deliveryNoticeOrderEo = (ReceiveDeliveryNoticeOrderEo)((ExtQueryChainWrapper)this.receiveDeliveryNoticeOrderDomain.filter().eq((Object)"document_no", (Object)documentNo)).one();
        AssertUtil.isTrue(Objects.nonNull(deliveryNoticeOrderEo), String.format("\u6839\u636e\u5355\u53f7\uff1a%s\u627e\u4e0d\u5230\u5355\u636e\u4fe1\u606f", documentNo));
        List detailEos = ((ExtQueryChainWrapper)this.receiveDeliveryNoticeOrderDetailDomain.filter().eq((Object)"document_no", (Object)documentNo)).list();
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)detailEos), String.format("\u6839\u636e\u5355\u53f7\uff1a%s\u627e\u4e0d\u5230\u5546\u54c1\u660e\u7ec6\u4fe1\u606f", documentNo));
        MessageVo messageVo = new MessageVo();
        CsDeliveryReceiveNoticeOrderMessageReqDto reqDto = new CsDeliveryReceiveNoticeOrderMessageReqDto();
        messageVo.setData((Object)reqDto);
        CubeBeanUtils.copyProperties((Object)reqDto, (Object)deliveryNoticeOrderEo, (String[])new String[0]);
        ArrayList detailList = new ArrayList();
        reqDto.setDetailList(detailList);
        CubeBeanUtils.copyCollection(detailList, (Collection)detailEos, CsDeliveryReceiveNoticeOrderDetailMessageReqDto.class);
        CsInOutNoticeOrderSendInfoMessageReqDto sendInfoMessageReqDto = new CsInOutNoticeOrderSendInfoMessageReqDto();
        CsInOutNoticeOrderReceiveInfoMessageReqDto receiveInfoMessageReqDto = new CsInOutNoticeOrderReceiveInfoMessageReqDto();
        String msg = this.buildAddressData(documentNo, sendInfoMessageReqDto, receiveInfoMessageReqDto);
        logger.info("\u7ec4\u88c5\u57fa\u7840\u5355\u636e\u53d1\u3001\u6536\u8d27\u4eba\u5730\u5740\u4fe1\u606f\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)msg);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            return messageVo;
        }
        reqDto.setSendInfoMessageReqDto(sendInfoMessageReqDto);
        reqDto.setReceiveInfoMessageReqDto(receiveInfoMessageReqDto);
        logger.info("\u6d88\u606fvo\u8bbe\u7f6e\u5730\u5740\u4fe1\u606f\u6210\u529f");
        return messageVo;
    }

    private MessageVo buildOutInNoticeMqDto(CsBasicsOrderReqDto sendInfo) {
        String documentNo = sendInfo.getDocumentNo();
        QueryWrapper outNoticeOrderQueryWrapper = new QueryWrapper();
        outNoticeOrderQueryWrapper.eq((Object)"document_no", (Object)documentNo);
        outNoticeOrderQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        InOutNoticeOrderEo outNoticeOrderEo = (InOutNoticeOrderEo)((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"document_no", (Object)documentNo)).one();
        AssertUtil.isTrue(Objects.nonNull(outNoticeOrderEo), String.format("\u6839\u636e\u5355\u53f7\uff1a%s\u627e\u4e0d\u5230\u5355\u636e\u4fe1\u606f", documentNo));
        List detailEos = ((ExtQueryChainWrapper)this.inOutNoticeOrderDetailDomain.filter().eq((Object)"document_no", (Object)documentNo)).list();
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)detailEos), String.format("\u6839\u636e\u5355\u53f7\uff1a%s\u627e\u4e0d\u5230\u5546\u54c1\u660e\u7ec6\u4fe1\u606f", documentNo));
        MessageVo messageVo = new MessageVo();
        CsInOutNoticeOrderMessageReqDto reqDto = new CsInOutNoticeOrderMessageReqDto();
        messageVo.setData((Object)reqDto);
        CubeBeanUtils.copyProperties((Object)reqDto, (Object)outNoticeOrderEo, (String[])new String[0]);
        ArrayList detailList = new ArrayList();
        reqDto.setOrderDetailMessageReqDtoList(detailList);
        CubeBeanUtils.copyCollection(detailList, (Collection)detailEos, CsInOutNoticeOrderDetailMessageReqDto.class);
        CsInOutNoticeOrderSendInfoMessageReqDto sendInfoMessageReqDto = new CsInOutNoticeOrderSendInfoMessageReqDto();
        CsInOutNoticeOrderReceiveInfoMessageReqDto receiveInfoMessageReqDto = new CsInOutNoticeOrderReceiveInfoMessageReqDto();
        String msg = this.buildAddressData(documentNo, sendInfoMessageReqDto, receiveInfoMessageReqDto);
        logger.info("\u7ec4\u88c5\u57fa\u7840\u5355\u636e\u53d1\u3001\u6536\u8d27\u4eba\u5730\u5740\u4fe1\u606f\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)msg);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            return messageVo;
        }
        reqDto.setSendInfoMessageReqDto(sendInfoMessageReqDto);
        reqDto.setReceiveInfoMessageReqDto(receiveInfoMessageReqDto);
        logger.info("\u6d88\u606fvo\u8bbe\u7f6e\u5730\u5740\u4fe1\u606f\u6210\u529f");
        return messageVo;
    }

    private String buildAddressData(String documentNo, CsInOutNoticeOrderSendInfoMessageReqDto sendInfoMessageReqDto, CsInOutNoticeOrderReceiveInfoMessageReqDto receiveInfoMessageReqDto) {
        BaseOrderAddressEo addressEo;
        List csBaseOrderAddressEos = ((ExtQueryChainWrapper)this.baseOrderAddressDomain.filter().eq((Object)"document_no", (Object)documentNo)).list();
        if (CollectionUtils.isEmpty((Collection)csBaseOrderAddressEos)) {
            return this.ADDRESS_NOT_FOUND_MSG;
        }
        Map addressMap = csBaseOrderAddressEos.stream().collect(Collectors.toMap(BaseOrderAddressEo::getContactsType, Function.identity(), (k1, k2) -> k1));
        if (!addressMap.isEmpty() && Objects.nonNull(addressMap.get(CsBaseOrderAddressContactsTypeEnum.CONSIGNOR.getCode()))) {
            addressEo = (BaseOrderAddressEo)addressMap.get(CsBaseOrderAddressContactsTypeEnum.CONSIGNOR.getCode());
            sendInfoMessageReqDto.setDocumentNo(addressEo.getDocumentNo());
            sendInfoMessageReqDto.setSendPersonName(addressEo.getContacts());
            sendInfoMessageReqDto.setSendPersonPhone(addressEo.getPhone());
            sendInfoMessageReqDto.setProvinceName(addressEo.getProvince());
            sendInfoMessageReqDto.setProvinceCode(addressEo.getProvinceCode());
            sendInfoMessageReqDto.setCityName(addressEo.getCity());
            sendInfoMessageReqDto.setCityCode(addressEo.getCityCode());
            sendInfoMessageReqDto.setDetailAddress(addressEo.getDetailAddress());
        }
        if (!addressMap.isEmpty() && Objects.nonNull(addressMap.get(CsBaseOrderAddressContactsTypeEnum.CONSIGNEE.getCode()))) {
            addressEo = (BaseOrderAddressEo)addressMap.get(CsBaseOrderAddressContactsTypeEnum.CONSIGNEE.getCode());
            receiveInfoMessageReqDto.setDocumentNo(addressEo.getDocumentNo());
            receiveInfoMessageReqDto.setReceivePersonName(addressEo.getContacts());
            receiveInfoMessageReqDto.setReceivePersonPhone(addressEo.getPhone());
            receiveInfoMessageReqDto.setProvinceName(addressEo.getProvince());
            receiveInfoMessageReqDto.setProvinceCode(addressEo.getProvinceCode());
            receiveInfoMessageReqDto.setCityName(addressEo.getCity());
            receiveInfoMessageReqDto.setCityCode(addressEo.getCityCode());
            receiveInfoMessageReqDto.setDetailAddress(addressEo.getDetailAddress());
        }
        return "";
    }

    @Override
    public Boolean receive(CsBasicsOrderReqDto receiveInfo) {
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean receiveIn(CsBasicsReceiveReqDto basicsReceiveBasicsReqDto) {
        this.checkParams(basicsReceiveBasicsReqDto);
        String inOutNoticeOrderNo = basicsReceiveBasicsReqDto.getInOutNoticeOrderNo();
        List inOutNoticeOrderEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"document_no", (Object)inOutNoticeOrderNo)).eq((Object)"order_type", (Object)"in")).list();
        InOutNoticeOrderEo inOutNoticeOrderEo = (InOutNoticeOrderEo)inOutNoticeOrderEoList.get(0);
        AssertUtil.isTrue(null != inOutNoticeOrderEo, "\u67e5\u8be2\u4e0d\u5230\u51fa\u5165\u5e93\u5355\u636e\u4fe1\u606f");
        if (BdTypeOfDocumentEnum.SEND_RECEIVE_DIFF.getCode().equals(inOutNoticeOrderEo.getBusinessType())) {
            logger.info("\u5dee\u5f02\u8c03\u6574\u5355\u63a8\u9001wms\u65e0\u9700\u63a5\u6536wms\u8fd4\u56de\u7ed3\u679c\uff0c\u76f4\u63a5\u8fd4\u56de");
            return true;
        }
        AssertUtil.isTrue(!BaseOrderStatusEnum.FINISH_OVER.getCode().equals(inOutNoticeOrderEo.getOrderStatus()), "\u5355\u636e\u5df2\u5b8c\u7ed3\uff0c\u4e0d\u80fd\u91cd\u590d\u5165\u5e93\u3002");
        if (!StringUtils.isNotBlank((CharSequence)basicsReceiveBasicsReqDto.getWmsOrderNo()) || !basicsReceiveBasicsReqDto.getWmsOrderNo().contains("_TYPE99")) {
            AssertUtil.isTrue(BaseOrderStatusEnum.INO_WAIT_IN.getCode().equals(inOutNoticeOrderEo.getOrderStatus()) || BaseOrderStatusEnum.INO_PORTION_IN.getCode().equals(inOutNoticeOrderEo.getOrderStatus()), "\u975e\u5f85\u5165\u5e93\u548c\u90e8\u5206\u5165\u5e93\u72b6\u6001\uff0c\u4e0d\u80fd\u8fdb\u884c\u5165\u5e93\u56de\u4f20");
        }
        if (CsRelevanceTableNameEnum.CS_IN_PLANNED_ORDER.getCode().equals(inOutNoticeOrderEo.getRelevanceTableName())) {
            this.calculateExpireTime(basicsReceiveBasicsReqDto);
        }
        this.wmsOperate(basicsReceiveBasicsReqDto, inOutNoticeOrderEo, true);
        return true;
    }

    private void calculateExpireTime(CsBasicsReceiveReqDto basicsReceiveBasicsReqDto) {
        List detailReqDtoList = basicsReceiveBasicsReqDto.getDetailReqDtoList();
        List longCodeList = detailReqDtoList.stream().map(CsWmsBasicsDetailReqDto::getSkuCode).distinct().collect(Collectors.toList());
        List itemSkuDtos = this.itemSkuQueryApiProxy.queryBySkuCodes(longCodeList);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)itemSkuDtos), "\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728");
        Map itemEoMap = itemSkuDtos.stream().collect(Collectors.toMap(eo -> eo.getSkuCode(), Function.identity()));
        for (CsWmsBasicsDetailReqDto detailReqDto : detailReqDtoList) {
            String skuCode = detailReqDto.getSkuCode();
            Date produceTime = detailReqDto.getProduceTime();
            AssertUtil.isTrue(null != produceTime, "\u751f\u4ea7\u65e5\u671f\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            String produceTimeStr = DateUtils.formatDate(produceTime, "yyyy-MM-dd");
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)produceTimeStr), "\u751f\u4ea7\u65e5\u671f\u53c2\u6570\u683c\u5f0f\u6709\u8bef");
            ItemSkuDto csItemEo = (ItemSkuDto)itemEoMap.get(skuCode);
            AssertUtil.isTrue(null != csItemEo, "\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728");
            String expirationDate = "12";
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)expirationDate), String.format("\u3010%s\u3011\u5546\u54c1\u8d28\u4fdd\u671f\u6570\u636e\u4e3a\u7a7a", skuCode));
            Integer expirationDateInt = Integer.parseInt(expirationDate);
            Date date = DateUtils.addMonth(produceTime, expirationDateInt);
            Date expireTime = DateUtils.beforeDay(date, 1);
            detailReqDto.setExpireTime(expireTime);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean receiveOut(CsBasicsReceiveReqDto basicsReceiveBasicsReqDto) {
        this.checkParams(basicsReceiveBasicsReqDto);
        String inOutNoticeOrderNo = basicsReceiveBasicsReqDto.getInOutNoticeOrderNo();
        List inOutNoticeOrderEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"document_no", (Object)inOutNoticeOrderNo)).eq((Object)"order_type", (Object)"out")).list();
        InOutNoticeOrderEo inOutNoticeOrderEo = (InOutNoticeOrderEo)inOutNoticeOrderEoList.get(0);
        AssertUtil.isTrue(null != inOutNoticeOrderEo, "\u67e5\u8be2\u4e0d\u5230\u51fa\u5165\u5e93\u5355\u636e\u4fe1\u606f");
        if (BdTypeOfDocumentEnum.SEND_RECEIVE_DIFF.getCode().equals(inOutNoticeOrderEo.getBusinessType())) {
            logger.info("\u5dee\u5f02\u8c03\u6574\u5355\u63a8\u9001wms\u65e0\u9700\u63a5\u6536wms\u8fd4\u56de\u7ed3\u679c\uff0c\u76f4\u63a5\u8fd4\u56de");
            return true;
        }
        this.shipmentDispose(inOutNoticeOrderEo, basicsReceiveBasicsReqDto);
        if (CollectionUtils.isEmpty((Collection)basicsReceiveBasicsReqDto.getPackageMaterialDetailReqDtoList())) {
            AssertUtil.isTrue(BaseOrderStatusEnum.ONO_WAIT_OUT.getCode().equals(inOutNoticeOrderEo.getOrderStatus()) || BaseOrderStatusEnum.ONO_PORTION_OUT.getCode().equals(inOutNoticeOrderEo.getOrderStatus()), "\u975e\u5f85\u51fa\u5e93\u548c\u90e8\u5206\u51fa\u5e93\u72b6\u6001\uff0c\u4e0d\u80fd\u8fdb\u884c\u51fa\u5e93\u56de\u4f20");
            this.wmsOperate(basicsReceiveBasicsReqDto, inOutNoticeOrderEo, false);
        } else {
            this.wmsOperatePackageMaterial(basicsReceiveBasicsReqDto, inOutNoticeOrderEo, false);
        }
        return Boolean.TRUE;
    }

    @Override
    protected void checkParams(CsBasicsReceiveReqDto basicsReceiveBasicsReqDto) {
        List shippingCompanyCodeList;
        logger.info("checkParams==>\u53c2\u6570\u6821\u9a8c,basicsReceiveBasicsReqDto:{}", (Object)LogUtils.buildLogContent(basicsReceiveBasicsReqDto));
        AssertUtil.isTrue(null != basicsReceiveBasicsReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String wmsOrderNo = basicsReceiveBasicsReqDto.getWmsOrderNo();
        String inNoticeOrderNo = basicsReceiveBasicsReqDto.getInOutNoticeOrderNo();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)inNoticeOrderNo), "\u5165\u5e93\u901a\u77e5\u5355\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        List detailReqDtoList = basicsReceiveBasicsReqDto.getDetailReqDtoList();
        List packageMaterialDetailReqDtoList = basicsReceiveBasicsReqDto.getPackageMaterialDetailReqDtoList();
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)detailReqDtoList) || CollectionUtils.isNotEmpty((Collection)packageMaterialDetailReqDtoList), "\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        List<String> longCodeList = this.checkDetailInfo(detailReqDtoList);
        List<String> packageMaterialLongCodeList = this.checkDetailInfo(packageMaterialDetailReqDtoList);
        if (CollectionUtils.isNotEmpty(packageMaterialLongCodeList)) {
            longCodeList.addAll(packageMaterialLongCodeList);
        }
        List itemList = this.itemSkuQueryApiProxy.queryBySkuCodes(longCodeList);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)itemList), "\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728");
        List warehouseCodeList = detailReqDtoList.stream().map(CsWmsBasicsDetailReqDto::getWarehouseCode).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty((Collection)packageMaterialDetailReqDtoList)) {
            List packageMaterialWarehouseCodeList = packageMaterialDetailReqDtoList.stream().map(CsWmsBasicsDetailReqDto::getWarehouseCode).distinct().collect(Collectors.toList());
            warehouseCodeList.addAll(packageMaterialWarehouseCodeList);
        }
        QueryWrapper logicWarehouseEoQueryWrapper = new QueryWrapper();
        logicWarehouseEoQueryWrapper.in((Object)"warehouse_code", warehouseCodeList);
        logicWarehouseEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        List csLogicWarehouseEoList = this.logicWarehouseDomain.getMapper().selectList((Wrapper)logicWarehouseEoQueryWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)csLogicWarehouseEoList), "\u4ed3\u5e93\u4fe1\u606f\u4e0d\u5b58\u5728");
        if (StringUtils.isNotBlank((CharSequence)wmsOrderNo)) {
            QueryWrapper csOutResultOrderEoQueryWrapper = new QueryWrapper();
            csOutResultOrderEoQueryWrapper.eq((Object)"wms_order_no", (Object)wmsOrderNo);
            List csOutResultOrderEoList = this.inOutResultOrderDomain.getMapper().selectList((Wrapper)csOutResultOrderEoQueryWrapper);
            AssertUtil.isTrue(CollectionUtils.isEmpty((Collection)csOutResultOrderEoList), "WMS\u5355\u53f7\u5df2\u5b58\u5728");
        }
        if (CollectionUtils.isNotEmpty((Collection)basicsReceiveBasicsReqDto.getShippingInfoReqDtoList()) && CollectionUtils.isNotEmpty(shippingCompanyCodeList = basicsReceiveBasicsReqDto.getShippingInfoReqDtoList().stream().map(e -> e.getShippingCompanyCode()).distinct().collect(Collectors.toList()))) {
            QueryWrapper shipmenetEnterpriseEoQueryWrapper = new QueryWrapper();
            shipmenetEnterpriseEoQueryWrapper.in((Object)"shipment_enterprise_code", shippingCompanyCodeList);
            shipmenetEnterpriseEoQueryWrapper.eq((Object)"dr", (Object)0);
            List shipmenetEnterpriseEos = this.shipmenetEnterpriseMapper.selectList((Wrapper)shipmenetEnterpriseEoQueryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)shipmenetEnterpriseEos)) {
                Map shipmenetEnterpriseEoMap = shipmenetEnterpriseEos.stream().collect(Collectors.toMap(CsShipmenetEnterpriseEo::getShipmentEnterpriseCode, Function.identity(), (k1, k2) -> k1));
                for (CsWmsShippingInfoReqDto wmsShippingInfoReqDto : basicsReceiveBasicsReqDto.getShippingInfoReqDtoList()) {
                    String shippingCompanyCode = wmsShippingInfoReqDto.getShippingCompanyCode();
                    CsShipmenetEnterpriseEo shipmenetEnterpriseEo = (CsShipmenetEnterpriseEo)shipmenetEnterpriseEoMap.get(shippingCompanyCode);
                    if (Objects.isNull(shipmenetEnterpriseEo)) {
                        logger.info("\u6839\u636ewms\u56de\u4f20\u7684\u7269\u6d41\u516c\u53f8\u7f16\u7801\uff1a{}\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7269\u6d41\u516c\u53f8\u4fe1\u606f", (Object)shippingCompanyCode);
                        continue;
                    }
                    wmsShippingInfoReqDto.setShippingCompanyName(shipmenetEnterpriseEo.getShipmentEnterpriseName());
                    wmsShippingInfoReqDto.setLogisticsType(shipmenetEnterpriseEo.getLogisticsType());
                }
            }
        }
    }

    private List<String> checkDetailInfo(List<CsWmsBasicsDetailReqDto> detailReqDtoList) {
        if (CollectionUtils.isEmpty(detailReqDtoList)) {
            return new ArrayList<String>();
        }
        for (CsWmsBasicsDetailReqDto detailReqDto : detailReqDtoList) {
            String batch = detailReqDto.getBatch();
            String skuCode = detailReqDto.getSkuCode();
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)skuCode), "\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            BigDecimal quantity = detailReqDto.getQuantity();
            AssertUtil.isTrue(null != quantity, "\u5546\u54c1\u6570\u91cf\u6709\u8bef");
            String warehouseCode = detailReqDto.getWarehouseCode();
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)warehouseCode), "\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return detailReqDtoList.stream().map(CsWmsBasicsDetailReqDto::getSkuCode).distinct().collect(Collectors.toList());
    }

    private void shipmentDispose(InOutNoticeOrderEo inOutNoticeOrderEo, CsBasicsReceiveReqDto basicsReceiveBasicsReqDto) {
        logger.info("shipmentDispose==>\u7279\u6b8a\u5904\u7406\uff0c\u9488\u5bf9\u4e8e\u81ea\u63d0\u548c\u5176\u4ed6\u7c7b\u578b\u7684\u7269\u6d41\u5355,InOutNoticeOrderEo#documentNo:{},basicsReceiveBasicsReqDto:{}", (Object)inOutNoticeOrderEo.getDocumentNo(), (Object)LogUtils.buildLogContent(basicsReceiveBasicsReqDto));
        Boolean sinceTheClosedLoopFlag = basicsReceiveBasicsReqDto.getSinceTheClosedLoopFlag();
        if (sinceTheClosedLoopFlag.booleanValue()) {
            return;
        }
        String shipmentEnterpriseCode = inOutNoticeOrderEo.getShipmentEnterpriseCode();
        if (!"ZT".equals(shipmentEnterpriseCode) && !"OTHER".equals(shipmentEnterpriseCode)) {
            return;
        }
        String shippingJson = inOutNoticeOrderEo.getShippingJson();
        if (StringUtils.isNotBlank((CharSequence)shippingJson)) {
            return;
        }
        List backShippingInfoReqDtoList = basicsReceiveBasicsReqDto.getShippingInfoReqDtoList();
        if (CollectionUtils.isNotEmpty((Collection)backShippingInfoReqDtoList)) {
            return;
        }
        String shippingNo = "zitifahuo";
        String shippingCompany = "ZT";
        if ("OTHER".equals(shipmentEnterpriseCode)) {
            shippingNo = "xunifahuo";
            shippingCompany = "OTHER";
        }
        ArrayList<CsWmsShippingInfoReqDto> shippingInfoReqDtoList = new ArrayList<CsWmsShippingInfoReqDto>(1);
        CsWmsShippingInfoReqDto csWmsShippingInfoReqDto = new CsWmsShippingInfoReqDto();
        csWmsShippingInfoReqDto.setShippingNo(shippingNo);
        csWmsShippingInfoReqDto.setShippingCompanyCode(shippingCompany);
        csWmsShippingInfoReqDto.setShippingCompanyName(this.getShipmentName(shippingCompany));
        csWmsShippingInfoReqDto.setOutNoticeOrderNo(inOutNoticeOrderEo.getDocumentNo());
        csWmsShippingInfoReqDto.setPlatformOrderNo(inOutNoticeOrderEo.getExternalOrderNo());
        csWmsShippingInfoReqDto.setDeliveryTime(new Date());
        shippingInfoReqDtoList.add(csWmsShippingInfoReqDto);
        logger.info("shipmentDispose==>\u7279\u6b8a\u5904\u7406\uff0c\u9488\u5bf9\u4e8e\u81ea\u63d0\u548c\u5176\u4ed6\u7c7b\u578b\u7684\u7269\u6d41\u5355,shippingInfoReqDtoList:{}", (Object)LogUtils.buildLogContent(shippingInfoReqDtoList));
        basicsReceiveBasicsReqDto.setShippingInfoReqDtoList(shippingInfoReqDtoList);
    }

    private String getShipmentName(String shippingCompanyCode) {
        QueryWrapper csShipmenetEnterpriseEoQueryWrapper = new QueryWrapper();
        csShipmenetEnterpriseEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        csShipmenetEnterpriseEoQueryWrapper.eq((Object)"shipment_enterprise_code", (Object)shippingCompanyCode);
        csShipmenetEnterpriseEoQueryWrapper.eq((Object)"shipment_enterprise_status", (Object)YesNoEnum.YES.getValue());
        List csShipmenetEnterpriseEoList = this.shipmenetEnterpriseMapper.selectList((Wrapper)csShipmenetEnterpriseEoQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)csShipmenetEnterpriseEoList)) {
            return null;
        }
        return ((CsShipmenetEnterpriseEo)csShipmenetEnterpriseEoList.get(0)).getShipmentEnterpriseName();
    }

    private void wmsOperate(CsBasicsReceiveReqDto basicsReceiveBasicsReqDto, InOutNoticeOrderEo inOutNoticeOrderEo, Boolean inFlag) {
        logger.info("inOutNoticeNo:{},inFlag:{}", (Object)basicsReceiveBasicsReqDto.getInOutNoticeOrderNo(), (Object)inFlag);
        basicsReceiveBasicsReqDto.setIgnoreBatch(Boolean.valueOf(InventoryConfig.isNoneBatch()));
        this.buildOverchargeProportion(inOutNoticeOrderEo);
        logger.info("wmsOperate==>\u8d85\u6536\u6bd4\u4f8b\u4fe1\u606f,overchargeProportion:{}", (Object)LogUtils.buildLogContent(this.overchargeProportion));
        String inOutStr = "\u5165\u5e93";
        String rDStr = "\u6536\u8d27";
        if (!inFlag.booleanValue()) {
            inOutStr = "\u51fa\u5e93";
            rDStr = "\u53d1\u8d27";
        }
        String noticeOrderNo = inOutNoticeOrderEo.getDocumentNo();
        AssertUtil.isTrue(null != inOutNoticeOrderEo, inOutStr + "\u901a\u77e5\u5355\u4e0d\u5b58\u5728");
        logger.info("wmsIn==>wms\u51fa\u5165\u5e93\u5e93\u56de\u4f20\u64cd\u4f5c,InOutNoticeOrderEo:{}", (Object)LogUtils.buildLogContent(inOutNoticeOrderEo));
        List inOutNoticeOrderDetailEoList = ((ExtQueryChainWrapper)this.inOutNoticeOrderDetailDomain.filter().eq((Object)"document_no", (Object)noticeOrderNo)).list();
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)inOutNoticeOrderDetailEoList), inOutStr + "\u901a\u77e5\u5355\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u4e0d\u5b58\u5728");
        logger.info("wmsIn==>wms\u51fa\u5165\u5e93\u5e93\u56de\u4f20\u64cd\u4f5c,inOutNoticeOrderDetailEoList:{}", (Object)LogUtils.buildLogContent(inOutNoticeOrderDetailEoList));
        ArrayList originalOutNoticeOrderDetailRespList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)originalOutNoticeOrderDetailRespList, (Collection)inOutNoticeOrderDetailEoList, CsOutNoticeOrderDetailRespDto.class);
        CsBusinessCallBackStrategyEnum callBackStrategyEnum = CsBusinessCallBackStrategyEnum.getByTableName((String)inOutNoticeOrderEo.getRelevanceTableName());
        this.matchLineNo(basicsReceiveBasicsReqDto.getDetailReqDtoList(), inOutNoticeOrderDetailEoList);
        this.diffCalculate(basicsReceiveBasicsReqDto, inOutNoticeOrderDetailEoList, callBackStrategyEnum, inOutNoticeOrderEo);
        this.transferOrderOverCharge(callBackStrategyEnum, inOutNoticeOrderEo, basicsReceiveBasicsReqDto, inOutNoticeOrderDetailEoList);
        ArrayList innStatusList = Lists.newArrayList();
        String orderType = "receive";
        if (inFlag.booleanValue()) {
            innStatusList.add(BaseOrderStatusEnum.RNO_WAIT_RECEIVE.getCode());
            innStatusList.add(BaseOrderStatusEnum.RNO_PORTION_RECEIVE.getCode());
        } else {
            orderType = "delivery";
            innStatusList.add(BaseOrderStatusEnum.DNO_WAIT_DELIVERY.getCode());
            innStatusList.add(BaseOrderStatusEnum.DNO_PORTION_DELIVERY.getCode());
        }
        ReceiveDeliveryNoticeOrderEo ReceiveDeliveryNoticeOrderEo2 = (ReceiveDeliveryNoticeOrderEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.receiveDeliveryNoticeOrderDomain.filter().eq((Object)"document_no", (Object)inOutNoticeOrderEo.getPreOrderNo())).eq((Object)"order_type", (Object)orderType)).in(!StringUtils.isNotBlank((CharSequence)basicsReceiveBasicsReqDto.getWmsOrderNo()) || !basicsReceiveBasicsReqDto.getWmsOrderNo().contains("_TYPE99"), (Object)"order_status", (Collection)innStatusList)).one();
        AssertUtil.isTrue(null != ReceiveDeliveryNoticeOrderEo2, rDStr + "\u901a\u77e5\u5355\u4e0d\u5b58\u5728");
        logger.info("wmsIn==>wms\u51fa\u5165\u5e93\u5e93\u56de\u4f20\u64cd\u4f5c,csReceiveNoticeOrderEo:{}", (Object)LogUtils.buildLogContent(ReceiveDeliveryNoticeOrderEo2));
        List deliveryNoticeOrderDetailEoList = ((ExtQueryChainWrapper)this.receiveDeliveryNoticeOrderDetailDomain.filter().eq((Object)"document_no", (Object)ReceiveDeliveryNoticeOrderEo2.getDocumentNo())).list();
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)deliveryNoticeOrderDetailEoList), rDStr + "\u901a\u77e5\u5355\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u4e0d\u5b58\u5728");
        logger.info("wmsIn==>wms\u51fa\u5165\u5e93\u5e93\u56de\u4f20\u64cd\u4f5c,deliveryNoticeOrderDetailEoList:{}", (Object)LogUtils.buildLogContent(deliveryNoticeOrderDetailEoList));
        Map<String, Boolean> flagMap = this.updateInNoticeOrderInfo(inOutNoticeOrderEo.getRelevanceNo(), basicsReceiveBasicsReqDto, inOutNoticeOrderEo, inOutNoticeOrderDetailEoList, inFlag);
        this.updateReceiveNoticeOrderInfo(ReceiveDeliveryNoticeOrderEo2, basicsReceiveBasicsReqDto, flagMap, inOutNoticeOrderEo, inFlag);
        CsOrderBusinessCallBackContext callBackContext = new CsOrderBusinessCallBackContext();
        callBackContext.setInFlag(inFlag);
        callBackContext.setShopCode(basicsReceiveBasicsReqDto.getShopCode());
        callBackContext.setOverchargeFlag(flagMap.get(this.overchargeFlag_key));
        callBackContext.setPortionFlag(flagMap.get(this.portionFlag_key));
        callBackContext.setInTransferHangUpFlag(flagMap.get(this.inTransferHangUpFlag_key));
        callBackContext.setBasicsReceiveBasicsReqDto(basicsReceiveBasicsReqDto);
        callBackContext.setInOutTime(basicsReceiveBasicsReqDto.getInOutTime());
        callBackContext.setDeliveryNoticeOrderNo(ReceiveDeliveryNoticeOrderEo2.getDocumentNo());
        callBackContext.setInOutNoticeNo(inOutNoticeOrderEo.getDocumentNo());
        callBackContext.setOriginalOutNoticeOrderDetailRespList((List)originalOutNoticeOrderDetailRespList);
        callBackContext.setOrderAfterSaleFlagCommon(basicsReceiveBasicsReqDto.getOrderAfterSaleFlagCommon());
        callBackContext.setRelevanceTableName(ReceiveDeliveryNoticeOrderEo2.getRelevanceTableName());
        InOutResultOrderEo inOutResultOrderEo = this.generateInResultOrderInfo(basicsReceiveBasicsReqDto, inOutNoticeOrderEo, inOutNoticeOrderDetailEoList, flagMap, callBackContext, inFlag, basicsReceiveBasicsReqDto.getDetailReqDtoList(), this.COMMON);
        callBackContext.setInResultOrderNo(inOutResultOrderEo.getDocumentNo());
        callBackContext.setRelevanceNo(inOutResultOrderEo.getRelevanceNo());
        inOutResultOrderEo.setDocumentNo(inOutResultOrderEo.getDocumentNo());
        this.inOutResultCallBack(ReceiveDeliveryNoticeOrderEo2.getRelevanceTableName(), callBackContext);
        Boolean overchargeFlag = flagMap.get(this.overchargeFlag_key);
        if (!overchargeFlag.booleanValue()) {
            Boolean ignoreBatch = basicsReceiveBasicsReqDto.getIgnoreBatch();
            ReceiveDeliveryResultOrderEo ReceiveDeliveryResultOrderEo2 = null;
            ReceiveDeliveryResultOrderEo2 = ignoreBatch == false ? this.generateReceiveResultOrderInfo(basicsReceiveBasicsReqDto, ReceiveDeliveryNoticeOrderEo2, deliveryNoticeOrderDetailEoList, flagMap, inOutResultOrderEo, callBackContext, inFlag, basicsReceiveBasicsReqDto.getDetailReqDtoList(), this.COMMON) : this.generateReceiveResultOrderInfoIgnoreBatch(basicsReceiveBasicsReqDto, ReceiveDeliveryNoticeOrderEo2, deliveryNoticeOrderDetailEoList, flagMap, inOutResultOrderEo, callBackContext, inFlag, basicsReceiveBasicsReqDto.getDetailReqDtoList(), this.COMMON);
            inOutResultOrderEo.setDocumentNo(ReceiveDeliveryResultOrderEo2.getDocumentNo());
            this.deliveryReceiveResultCallBack(ReceiveDeliveryNoticeOrderEo2.getRelevanceTableName(), callBackContext);
        }
    }

    private void transferOrderOverCharge(CsBusinessCallBackStrategyEnum callBackStrategyEnum, InOutNoticeOrderEo csOutNoticeOrderEo, CsBasicsReceiveReqDto basicsReceiveBasicsReqDto, List<InOutNoticeOrderDetailEo> csOutNoticeOrderDetailEoList) {
        if (CsBusinessCallBackStrategyEnum.TRANSFER_ORDER.getCode().equals(callBackStrategyEnum.getCode())) {
            DictDto dictDto = this.pcpDictApiProxy.queryByGroupCodeAndCode("OVER_CHARGE", "TRANSFER_SWITCH");
            logger.info("\u5224\u65ad\u8c03\u62e8\u5355\u662f\u5426\u5141\u8bb8\u8d85\u6536dict:{}", (Object)JSON.toJSONString((Object)dictDto));
            if ("out".equals(csOutNoticeOrderEo.getOrderType()) || "in".equals(csOutNoticeOrderEo.getOrderType()) && (null == dictDto || "1".equals(dictDto.getValue()))) {
                InOutResultOrderEo outResultOrderEo = new InOutResultOrderEo();
                outResultOrderEo.setRelevanceNo(csOutNoticeOrderEo.getRelevanceNo());
                outResultOrderEo.setOrderType(csOutNoticeOrderEo.getOrderType());
                List csOutResultOrderEos = this.inOutResultOrderDomain.selectList((BaseEo)outResultOrderEo);
                List csTransferOrderDetailEos = this.csTransferOrderDetailDas.queryByTransferOrderNo(csOutNoticeOrderEo.getRelevanceNo());
                BigDecimal reduceSum = csTransferOrderDetailEos.stream().map(CsTransferOrderDetailEo::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal reduce2 = basicsReceiveBasicsReqDto.getDetailReqDtoList().stream().map(map -> map.getQuantity().add(map.getDispatcherQuantity())).reduce(BigDecimal.ZERO, BigDecimal::add);
                Map<String, BigDecimal> reduceMap2 = basicsReceiveBasicsReqDto.getDetailReqDtoList().stream().collect(Collectors.groupingBy(a -> a.getSkuCode(), Collectors.collectingAndThen(Collectors.mapping(map -> map.getQuantity().add(map.getDispatcherQuantity()), Collectors.reducing(BigDecimal::add)), Optional::get)));
                Map<String, BigDecimal> reduceMap3 = csOutNoticeOrderDetailEoList.stream().collect(Collectors.groupingBy(a -> a.getSkuCode(), Collectors.collectingAndThen(Collectors.mapping(InOutNoticeOrderDetailEo::getWaitQuantity, Collectors.reducing(BigDecimal::add)), Optional::get)));
                if (CollectionUtils.isEmpty((Collection)csTransferOrderDetailEos)) {
                    throw new BizException("\u627e\u4e0d\u5230\u539f\u5355\u636e");
                }
                logger.info("\u672c\u6b21\u5165\u5e93\u7684map\u503c,{}", (Object)JSONObject.toJSONString(reduceMap2));
                logger.info("\u672c\u6b21\u5165\u5e93\u901a\u77e5\u5355\u7684map\u503c,{}", (Object)JSONObject.toJSONString(reduceMap3));
                for (String key : reduceMap2.keySet()) {
                    if (reduceMap3.containsKey(key)) {
                        if (reduceMap3.get(key).compareTo(reduceMap2.get(key)) != -1) continue;
                        throw new BizException(String.format("\u7269\u6599,\u6279\u6b21:%s,\u7981\u6b62\u8d85\u5165\uff0c\u8d85\u5165\u6570\u91cf:%s,\u5165\u5e93\u5931\u8d25", key, reduceMap2.get(key)));
                    }
                    throw new BizException(String.format("\u7269\u6599,\u6279\u6b21:%s,\u7981\u6b62\u8d85\u5165\uff0c\u8d85\u5165\u6570\u91cf:%s,\u5165\u5e93\u5931\u8d25", key, reduceMap2.get(key)));
                }
                if (CollectionUtils.isNotEmpty((Collection)csOutResultOrderEos)) {
                    List documents = csOutResultOrderEos.stream().map(InOutResultOrderEo::getDocumentNo).collect(Collectors.toList());
                    List csOutResultOrderDetailEos = this.inOutResultOrderDetailDomain.getMapper().selectList((Wrapper)((QueryWrapper)new QueryWrapper().in((Object)"document_no", documents)).eq((Object)"dr", (Object)YesNoHelper.NO));
                    BigDecimal reduce1 = csOutResultOrderDetailEos.stream().map(InOutResultOrderDetailEo::getDoneQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
                    if (reduceSum.compareTo(reduce1.add(reduce2)) == -1) {
                        throw new BizException("\u8c03\u62e8\u5355" + csOutNoticeOrderEo.getRelevanceNo() + "\u7981\u6b62\u8d85\u5165,\u8bf7\u68c0\u67e5\u5165\u5e93\u6570\u91cf");
                    }
                } else if (reduceSum.compareTo(reduce2) == -1) {
                    throw new BizException("\u8c03\u62e8\u5355" + csOutNoticeOrderEo.getRelevanceNo() + "\u7981\u6b62\u8d85\u5165,\u8bf7\u68c0\u67e5\u5165\u5e93\u6570\u91cf");
                }
            }
        }
    }

    private void diffCalculate(CsBasicsReceiveReqDto basicsReceiveBasicsReqDto, List<InOutNoticeOrderDetailEo> inOutNoticeOrderDetailEoList, CsBusinessCallBackStrategyEnum callBackStrategyEnum, InOutNoticeOrderEo inOutNoticeOrderEo) {
        if (!InventoryConfig.isDispatchOrderEnable()) {
            return;
        }
        Map itemBatchMap = inOutNoticeOrderDetailEoList.stream().collect(Collectors.toMap(InOutNoticeOrderDetailEo::getSkuCode, Function.identity(), (o, o1) -> o));
        Map itemBatchPreOrderItemIdMap = inOutNoticeOrderDetailEoList.stream().collect(Collectors.toMap(InOutNoticeOrderDetailEo::getPreOrderItemId, Function.identity(), (o, o1) -> o));
        basicsReceiveBasicsReqDto.getDetailReqDtoList().forEach(detail -> {
            Long preOrderItemId = detail.getTradeOrderItemId();
            String key = detail.getSkuCode() + Optional.ofNullable(detail.getBatch()).filter(StringUtils::isNotBlank).map(r -> "_" + r).orElse("");
            if (CsBusinessCallBackStrategyEnum.TRANSFER_ORDER.getCode().equals(callBackStrategyEnum.getCode()) && "in".equals(inOutNoticeOrderEo.getOrderType())) {
                boolean exist;
                logger.info("\u5f00\u59cb\u8fdb\u884c\u6536\u53d1\u5dee\u5f02\u5355\u7684\u5224\u65ad,detail\uff1a{}", (Object)JSON.toJSONString((Object)detail));
                boolean bl = exist = Objects.nonNull(preOrderItemId) ? itemBatchPreOrderItemIdMap.containsKey(preOrderItemId) : itemBatchMap.containsKey(key);
                if (exist) {
                    InOutNoticeOrderDetailEo eo1 = Objects.nonNull(preOrderItemId) ? (InOutNoticeOrderDetailEo)itemBatchPreOrderItemIdMap.get(preOrderItemId) : (InOutNoticeOrderDetailEo)itemBatchMap.get(key);
                    logger.info("eo1:{}", (Object)JSON.toJSONString((Object)eo1));
                    BigDecimal subtract = detail.getQuantity().subtract(eo1.getWaitQuantity());
                    if (subtract.compareTo(BigDecimal.ZERO) > 0) {
                        logger.info("\u591a\u6536");
                        detail.setQuantity(eo1.getWaitQuantity());
                        detail.setDispatcherStatus(CsTransferDispatcherStatusEnum.MORE_DISPATCHER.getCode());
                    } else if (subtract.compareTo(BigDecimal.ZERO) < 0) {
                        logger.info("\u5c11\u6536");
                        detail.setDispatcherStatus(CsTransferDispatcherStatusEnum.LESS_DISPATCHER.getCode());
                    } else {
                        logger.info("\u6b63\u5e38\u6536");
                        detail.setDispatcherStatus(CsTransferDispatcherStatusEnum.NO_DISPATCHER.getCode());
                    }
                    detail.setDispatcherQuantity(subtract);
                } else {
                    logger.info("\u65b0\u589e\u591a\u6536");
                    detail.setDispatcherQuantity(detail.getQuantity());
                    detail.setQuantity(BigDecimal.ZERO);
                    detail.setDispatcherStatus(CsTransferDispatcherStatusEnum.MORE_DISPATCHER.getCode());
                }
                logger.info("\u6536\u53d1\u5dee\u5f02\u5355\u7684\u5224\u65ad\u7ed3\u675f,detail\uff1a{}", (Object)JSON.toJSONString((Object)detail));
            }
        });
    }

    private void wmsOperatePackageMaterial(CsBasicsReceiveReqDto basicsReceiveBasicsReqDto, InOutNoticeOrderEo inOutNoticeOrderEo, Boolean inFlag) {
        logger.info("wmsOperatePackageMaterial-inOutNoticeNo:{},inFlag:{}", (Object)basicsReceiveBasicsReqDto.getInOutNoticeOrderNo(), (Object)inFlag);
        basicsReceiveBasicsReqDto.setIgnoreBatch(Boolean.valueOf(InventoryConfig.isNoneBatch()));
        this.buildOverchargeProportion(inOutNoticeOrderEo);
        String inOutStr = "\u5165\u5e93";
        String rDStr = "\u6536\u8d27";
        if (!inFlag.booleanValue()) {
            inOutStr = "\u51fa\u5e93";
            rDStr = "\u53d1\u8d27";
        }
        String noticeOrderNo = inOutNoticeOrderEo.getDocumentNo();
        AssertUtil.isTrue(null != inOutNoticeOrderEo, inOutStr + "\u901a\u77e5\u5355\u4e0d\u5b58\u5728");
        logger.info("wmsIn==>wms\u51fa\u5165\u5e93\u5e93\u56de\u4f20\u64cd\u4f5c,InOutNoticeOrderEo:{}", (Object)LogUtils.buildLogContent(inOutNoticeOrderEo));
        List inOutNoticeOrderDetailEoList = ((ExtQueryChainWrapper)this.inOutNoticeOrderDetailDomain.filter().eq((Object)"document_no", (Object)noticeOrderNo)).list();
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)inOutNoticeOrderDetailEoList), inOutStr + "\u901a\u77e5\u5355\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u4e0d\u5b58\u5728");
        logger.info("wmsIn==>wms\u51fa\u5165\u5e93\u5e93\u56de\u4f20\u64cd\u4f5c,inOutNoticeOrderDetailEoList:{}", (Object)LogUtils.buildLogContent(inOutNoticeOrderDetailEoList));
        CsBusinessCallBackStrategyEnum callBackStrategyEnum = CsBusinessCallBackStrategyEnum.getByTableName((String)inOutNoticeOrderEo.getRelevanceTableName());
        this.diffCalculate(basicsReceiveBasicsReqDto, inOutNoticeOrderDetailEoList, callBackStrategyEnum, inOutNoticeOrderEo);
        this.matchLineNo(basicsReceiveBasicsReqDto.getDetailReqDtoList(), inOutNoticeOrderDetailEoList);
        ArrayList innStatusList = Lists.newArrayList();
        String orderType = "receive";
        if (inFlag.booleanValue()) {
            innStatusList.add(BaseOrderStatusEnum.RNO_WAIT_RECEIVE.getCode());
            innStatusList.add(BaseOrderStatusEnum.RNO_PORTION_RECEIVE.getCode());
        } else {
            orderType = "delivery";
            innStatusList.add(BaseOrderStatusEnum.DNO_WAIT_DELIVERY.getCode());
            innStatusList.add(BaseOrderStatusEnum.DNO_PORTION_DELIVERY.getCode());
            innStatusList.add(BaseOrderStatusEnum.DNO_TOTAL_DELIVERY.getCode());
        }
        ReceiveDeliveryNoticeOrderEo ReceiveDeliveryNoticeOrderEo2 = (ReceiveDeliveryNoticeOrderEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.receiveDeliveryNoticeOrderDomain.filter().eq((Object)"document_no", (Object)inOutNoticeOrderEo.getPreOrderNo())).eq((Object)"order_type", (Object)orderType)).in((Object)"order_status", (Collection)innStatusList)).one();
        AssertUtil.isTrue(null != ReceiveDeliveryNoticeOrderEo2, rDStr + "\u901a\u77e5\u5355\u4e0d\u5b58\u5728");
        logger.info("wmsIn==>wms\u51fa\u5165\u5e93\u5e93\u56de\u4f20\u64cd\u4f5c,csReceiveNoticeOrderEo:{}", (Object)LogUtils.buildLogContent(ReceiveDeliveryNoticeOrderEo2));
        List deliveryNoticeOrderDetailEoList = ((ExtQueryChainWrapper)this.receiveDeliveryNoticeOrderDetailDomain.filter().eq((Object)"document_no", (Object)ReceiveDeliveryNoticeOrderEo2.getDocumentNo())).list();
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)deliveryNoticeOrderDetailEoList), rDStr + "\u901a\u77e5\u5355\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u4e0d\u5b58\u5728");
        logger.info("wmsIn==>wms\u51fa\u5165\u5e93\u5e93\u56de\u4f20\u64cd\u4f5c,deliveryNoticeOrderDetailEoList:{}", (Object)LogUtils.buildLogContent(deliveryNoticeOrderDetailEoList));
        Map<Object, Object> flagMap = new HashMap();
        List detailReqDtoList = basicsReceiveBasicsReqDto.getDetailReqDtoList();
        List packageMaterialDetailReqDtoList = basicsReceiveBasicsReqDto.getPackageMaterialDetailReqDtoList();
        boolean flag = CollectionUtils.isNotEmpty((Collection)detailReqDtoList) && (inFlag != false || inFlag == false && !BaseOrderStatusEnum.DNO_TOTAL_DELIVERY.getCode().equals(ReceiveDeliveryNoticeOrderEo2.getOrderStatus()));
        logger.info("\u666e\u901a\u5546\u54c1\u4fe1\u606f\u4e0d\u4e3a\u7a7a\uff0c\u4e14\u662f\u5165\u5e93\u7c7b\u578b\u6216\u662f\u51fa\u5e93\u7c7b\u578b\u4f46\u72b6\u6001\u975e\u5168\u90e8\u53d1\u8d27\u7684\u624d\u66f4\u65b0\u4fe1\u606fflag:{}", (Object)flag);
        if (flag) {
            logger.info("\u56de\u4f20\u7684\u662f\u5546\u54c1\u4fe1\u606f\uff0c\u9700\u66f4\u65b0\u51fa\u5165\u5e93\u3001\u53d1\u6536\u8d27\u901a\u77e5\u5355");
            flagMap = this.updateInNoticeOrderInfo(inOutNoticeOrderEo.getRelevanceNo(), basicsReceiveBasicsReqDto, inOutNoticeOrderEo, inOutNoticeOrderDetailEoList, inFlag);
            this.updateReceiveNoticeOrderInfo(ReceiveDeliveryNoticeOrderEo2, basicsReceiveBasicsReqDto, flagMap, inOutNoticeOrderEo, inFlag);
        }
        CsOrderBusinessCallBackContext callBackContext = new CsOrderBusinessCallBackContext();
        callBackContext.setInFlag(inFlag);
        Boolean portionFlag = Objects.nonNull(flagMap.get(this.portionFlag_key)) ? (Boolean)flagMap.get(this.portionFlag_key) : Boolean.valueOf(false);
        callBackContext.setPortionFlag(portionFlag);
        callBackContext.setBasicsReceiveBasicsReqDto(basicsReceiveBasicsReqDto);
        callBackContext.setDeliveryNoticeOrderNo(ReceiveDeliveryNoticeOrderEo2.getDocumentNo());
        callBackContext.setInOutNoticeNo(inOutNoticeOrderEo.getDocumentNo());
        InOutResultOrderEo inOutResultOrderEo = new InOutResultOrderEo();
        if (flag) {
            inOutResultOrderEo = this.generateInResultOrderInfo(basicsReceiveBasicsReqDto, inOutNoticeOrderEo, inOutNoticeOrderDetailEoList, flagMap, callBackContext, inFlag, detailReqDtoList, this.COMMON);
        }
        if (CollectionUtils.isNotEmpty((Collection)packageMaterialDetailReqDtoList)) {
            inOutResultOrderEo = this.generateInResultOrderInfo(basicsReceiveBasicsReqDto, inOutNoticeOrderEo, inOutNoticeOrderDetailEoList, flagMap, callBackContext, inFlag, packageMaterialDetailReqDtoList, this.PACKAGE_MATERIAL);
        }
        logger.info("inOutResultOrderEo:{}", (Object)JSON.toJSONString((Object)inOutResultOrderEo));
        callBackContext.setInResultOrderNo(inOutResultOrderEo.getDocumentNo());
        callBackContext.setRelevanceNo(inOutResultOrderEo.getRelevanceNo());
        inOutResultOrderEo.setDocumentNo(inOutResultOrderEo.getDocumentNo());
        if (flag) {
            this.inOutResultCallBack(ReceiveDeliveryNoticeOrderEo2.getRelevanceTableName(), callBackContext);
        }
        Boolean overchargeFlag = Objects.nonNull(flagMap.get(this.overchargeFlag_key)) ? (Boolean)flagMap.get(this.overchargeFlag_key) : Boolean.valueOf(false);
        callBackContext.setOverchargeFlag(overchargeFlag);
        if (!overchargeFlag.booleanValue()) {
            Boolean ignoreBatch = basicsReceiveBasicsReqDto.getIgnoreBatch();
            ReceiveDeliveryResultOrderEo ReceiveDeliveryResultOrderEo2 = null;
            if (!ignoreBatch.booleanValue()) {
                logger.info("\u4e0d\u5ffd\u7565\u6279\u6b21");
                if (flag) {
                    logger.info("\u751f\u6210\u5546\u54c1\u6536\u53d1\u8d27\u7ed3\u679c\u5355");
                    ReceiveDeliveryResultOrderEo2 = this.generateReceiveResultOrderInfo(basicsReceiveBasicsReqDto, ReceiveDeliveryNoticeOrderEo2, deliveryNoticeOrderDetailEoList, flagMap, inOutResultOrderEo, callBackContext, inFlag, detailReqDtoList, this.COMMON);
                }
                if (CollectionUtils.isNotEmpty((Collection)packageMaterialDetailReqDtoList)) {
                    logger.info("\u751f\u6210\u5305\u6750\u6536\u53d1\u8d27\u7ed3\u679c\u5355");
                    ReceiveDeliveryResultOrderEo2 = this.generateReceiveResultOrderInfo(basicsReceiveBasicsReqDto, ReceiveDeliveryNoticeOrderEo2, deliveryNoticeOrderDetailEoList, flagMap, inOutResultOrderEo, callBackContext, inFlag, packageMaterialDetailReqDtoList, this.PACKAGE_MATERIAL);
                }
            } else {
                logger.info("\u5ffd\u7565\u6279\u6b21");
                if (flag) {
                    logger.info("\u751f\u6210\u5546\u54c1\u6536\u53d1\u8d27\u7ed3\u679c\u5355");
                    ReceiveDeliveryResultOrderEo2 = this.generateReceiveResultOrderInfoIgnoreBatch(basicsReceiveBasicsReqDto, ReceiveDeliveryNoticeOrderEo2, deliveryNoticeOrderDetailEoList, flagMap, inOutResultOrderEo, callBackContext, inFlag, detailReqDtoList, this.COMMON);
                }
                if (CollectionUtils.isNotEmpty((Collection)packageMaterialDetailReqDtoList)) {
                    logger.info("\u751f\u6210\u5305\u6750\u6536\u53d1\u8d27\u7ed3\u679c\u5355");
                    ReceiveDeliveryResultOrderEo2 = this.generateReceiveResultOrderInfoIgnoreBatch(basicsReceiveBasicsReqDto, ReceiveDeliveryNoticeOrderEo2, deliveryNoticeOrderDetailEoList, flagMap, inOutResultOrderEo, callBackContext, inFlag, packageMaterialDetailReqDtoList, this.PACKAGE_MATERIAL);
                }
            }
            logger.info("ReceiveDeliveryResultOrderEo:{}", (Object)JSON.toJSONString(ReceiveDeliveryResultOrderEo2));
            if (flag) {
                this.deliveryReceiveResultCallBack(ReceiveDeliveryNoticeOrderEo2.getRelevanceTableName(), callBackContext);
            }
            if (!inFlag.booleanValue() && CollectionUtils.isNotEmpty((Collection)packageMaterialDetailReqDtoList)) {
                this.pushPackageMaterialDeliveryResultOrderMsg(callBackContext);
            }
        }
    }

    private void inOutResultCallBack(String tableName, CsOrderBusinessCallBackContext context) {
        CsBusinessCallBackStrategyEnum callBackStrategyEnum = CsBusinessCallBackStrategyEnum.getByTableName((String)tableName);
        ICsBusinessOrderCallBackService businessOrderCallBackService = CsBusinessOrderCallBackUtils.getBusinessOrderCallBackService(callBackStrategyEnum.getCode());
        businessOrderCallBackService.inOutResultOrderCallBack(context);
    }

    private void deliveryReceiveResultCallBack(String tableName, CsOrderBusinessCallBackContext context) {
        CsBusinessCallBackStrategyEnum callBackStrategyEnum = CsBusinessCallBackStrategyEnum.getByTableName((String)tableName);
        ICsBusinessOrderCallBackService businessOrderCallBackService = CsBusinessOrderCallBackUtils.getBusinessOrderCallBackService(callBackStrategyEnum.getCode());
        businessOrderCallBackService.deliveryReceiveResultOrderCallBack(context);
    }

    private ReceiveDeliveryResultOrderEo generateReceiveResultOrderInfo(CsBasicsReceiveReqDto basicsReceiveBasicsReqDto, ReceiveDeliveryNoticeOrderEo ReceiveDeliveryNoticeOrderEo2, List<ReceiveDeliveryNoticeOrderDetailEo> deliveryNoticeOrderDetailEoList, Map<String, Boolean> flagMap, InOutResultOrderEo inOutResultOrderEo, CsOrderBusinessCallBackContext callBackContext, Boolean inFlag, List<CsWmsBasicsDetailReqDto> detailReqDtoList, String orderClassify) {
        List receiveDeliveryResultOrderEos = ((ExtQueryChainWrapper)this.receiveDeliveryResultOrderDomain.filter().eq((Object)"pre_order_no", (Object)inOutResultOrderEo.getDocumentNo())).list();
        logger.info("\u6839\u636e\u524d\u7f6e\u5355\u53f7\u67e5\u8be2\u6536\u8d27\u7ed3\u679c\u5355\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)receiveDeliveryResultOrderEos));
        List receiveDeliveryResultOrderDetailEos = ((ExtQueryChainWrapper)this.receiveDeliveryResultOrderDetailDomain.filter().eq((Object)"pre_order_no", (Object)inOutResultOrderEo.getDocumentNo())).list();
        logger.info("\u6839\u636e\u524d\u7f6e\u5355\u53f7\u67e5\u8be2\u6536\u8d27\u7ed3\u679c\u5355\u660e\u7ec6\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)receiveDeliveryResultOrderDetailEos));
        ReceiveDeliveryResultOrderEo csReceiveResultOrderEo = new ReceiveDeliveryResultOrderEo();
        if (CollectionUtils.isNotEmpty((Collection)receiveDeliveryResultOrderEos)) {
            csReceiveResultOrderEo = (ReceiveDeliveryResultOrderEo)receiveDeliveryResultOrderEos.get(0);
            CsDeliveryReceiveResultRespDto csDeliveryReceiveResultRespDto = new CsDeliveryReceiveResultRespDto();
            CubeBeanUtils.copyProperties((Object)csDeliveryReceiveResultRespDto, (Object)csReceiveResultOrderEo, (String[])new String[0]);
            ArrayList deliveryReceiveResultDetailRespDtoList = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)deliveryReceiveResultDetailRespDtoList, (Collection)receiveDeliveryResultOrderDetailEos, CsDeliveryReceiveResultDetailRespDto.class);
            csDeliveryReceiveResultRespDto.setDeliveryReceiveResultDetailRespDtoList((List)deliveryReceiveResultDetailRespDtoList);
            callBackContext.setDeliveryReceiveResultOrderNo(csReceiveResultOrderEo.getDocumentNo());
            callBackContext.setCsDeliveryReceiveResultRespDto(csDeliveryReceiveResultRespDto);
            callBackContext.setDeliveryResultOrderId(csReceiveResultOrderEo.getId());
        }
        return csReceiveResultOrderEo;
    }

    private ReceiveDeliveryResultOrderEo generateReceiveResultOrderInfoIgnoreBatch(CsBasicsReceiveReqDto basicsReceiveBasicsReqDto, ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo, List<ReceiveDeliveryNoticeOrderDetailEo> deliveryNoticeOrderDetailEoList, Map<String, Boolean> flagMap, InOutResultOrderEo inOutResultOrderEo, CsOrderBusinessCallBackContext callBackContext, Boolean inFlag, List<CsWmsBasicsDetailReqDto> detailReqDtoList, String orderClassify) {
        List receiveDeliveryResultOrderEos = ((ExtQueryChainWrapper)this.receiveDeliveryResultOrderDomain.filter().eq((Object)"pre_order_no", (Object)inOutResultOrderEo.getDocumentNo())).list();
        logger.info("\u6839\u636e\u524d\u7f6e\u5355\u53f7\u67e5\u8be2\u6536\u8d27\u7ed3\u679c\u5355\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)receiveDeliveryResultOrderEos));
        List receiveDeliveryResultOrderDetailEos = ((ExtQueryChainWrapper)this.receiveDeliveryResultOrderDetailDomain.filter().eq((Object)"pre_order_no", (Object)inOutResultOrderEo.getDocumentNo())).list();
        logger.info("\u6839\u636e\u524d\u7f6e\u5355\u53f7\u67e5\u8be2\u6536\u8d27\u7ed3\u679c\u5355\u660e\u7ec6\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)receiveDeliveryResultOrderDetailEos));
        ReceiveDeliveryResultOrderEo csReceiveResultOrderEo = new ReceiveDeliveryResultOrderEo();
        if (CollectionUtils.isNotEmpty((Collection)receiveDeliveryResultOrderEos)) {
            csReceiveResultOrderEo = (ReceiveDeliveryResultOrderEo)receiveDeliveryResultOrderEos.get(0);
            CsDeliveryReceiveResultRespDto csDeliveryReceiveResultRespDto = new CsDeliveryReceiveResultRespDto();
            CubeBeanUtils.copyProperties((Object)csDeliveryReceiveResultRespDto, (Object)csReceiveResultOrderEo, (String[])new String[0]);
            ArrayList deliveryReceiveResultDetailRespDtoList = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)deliveryReceiveResultDetailRespDtoList, (Collection)receiveDeliveryResultOrderDetailEos, CsDeliveryReceiveResultDetailRespDto.class);
            csDeliveryReceiveResultRespDto.setDeliveryReceiveResultDetailRespDtoList((List)deliveryReceiveResultDetailRespDtoList);
            callBackContext.setDeliveryReceiveResultOrderNo(csReceiveResultOrderEo.getDocumentNo());
            callBackContext.setCsDeliveryReceiveResultRespDto(csDeliveryReceiveResultRespDto);
            callBackContext.setDeliveryResultOrderId(csReceiveResultOrderEo.getId());
        }
        return csReceiveResultOrderEo;
    }

    private InOutResultOrderEo generateInResultOrderInfo(CsBasicsReceiveReqDto basicsReceiveBasicsReqDto, InOutNoticeOrderEo inOutNoticeOrderEo, List<InOutNoticeOrderDetailEo> inOutNoticeOrderDetailEoList, Map<String, Boolean> flagMap, CsOrderBusinessCallBackContext callBackContext, Boolean inFlag, List<CsWmsBasicsDetailReqDto> detailReqDtoList, String orderClassify) {
        InOutResultOrderFacadeBo inOutResultOrderFacadeBo = new InOutResultOrderFacadeBo();
        inOutResultOrderFacadeBo.setWmsOrderNo(basicsReceiveBasicsReqDto.getWmsOrderNo());
        inOutResultOrderFacadeBo.setMergeQuantity(basicsReceiveBasicsReqDto.getMergeQuantity());
        inOutResultOrderFacadeBo.setTotalCartons(basicsReceiveBasicsReqDto.getTotalCartons());
        inOutResultOrderFacadeBo.setInOutNoticeOrderEo(inOutNoticeOrderEo);
        inOutResultOrderFacadeBo.setInOutNoticeOrderDetailEos(inOutNoticeOrderDetailEoList);
        inOutResultOrderFacadeBo.setOverchargeQuantity(detailReqDtoList.stream().filter(a -> CsTransferDispatcherStatusEnum.MORE_DISPATCHER.getCode().equals(a.getDispatcherStatus())).map(CsWmsBasicsDetailReqDto::getDispatcherQuantity).reduce(BigDecimal.ZERO, BigDecimal::add));
        inOutResultOrderFacadeBo.setReceivelessQuantity(detailReqDtoList.stream().filter(a -> CsTransferDispatcherStatusEnum.LESS_DISPATCHER.getCode().equals(a.getDispatcherStatus())).map(CsWmsBasicsDetailReqDto::getDispatcherQuantity).reduce(BigDecimal.ZERO, BigDecimal::add));
        inOutResultOrderFacadeBo.setDispatcherStatus(this.getDispatcherStatus(inOutResultOrderFacadeBo.getOverchargeQuantity(), inOutResultOrderFacadeBo.getReceivelessQuantity()));
        inOutResultOrderFacadeBo.setLinkNoticeUpdate(false);
        inOutResultOrderFacadeBo.setShippingInfoReqDtoList(basicsReceiveBasicsReqDto.getShippingInfoReqDtoList());
        List skuCodes = detailReqDtoList.stream().map(CsWmsBasicsDetailReqDto::getSkuCode).distinct().collect(Collectors.toList());
        List skuDtoList = this.itemSkuQueryApiProxy.queryBySkuCodes(skuCodes);
        Map skuDtoMap = skuDtoList.stream().collect(Collectors.toMap(ItemSkuDto::getSkuCode, Function.identity()));
        ArrayList baseOrderDetailReqDtos = Lists.newArrayList();
        for (CsWmsBasicsDetailReqDto csWmsBasicsDetailReqDto : detailReqDtoList) {
            BaseOrderDetailReqDto detailReqDto = new BaseOrderDetailReqDto();
            ItemSkuDto itemSkuDto = (ItemSkuDto)skuDtoMap.get(csWmsBasicsDetailReqDto.getSkuCode());
            if (null == itemSkuDto) {
                throw new BizException("\u5546\u54c1\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728, sku code: " + csWmsBasicsDetailReqDto.getSkuCode());
            }
            detailReqDto.setLineNo(csWmsBasicsDetailReqDto.getLineNo());
            detailReqDto.setSkuCode(csWmsBasicsDetailReqDto.getSkuCode());
            detailReqDto.setSkuName(itemSkuDto.getSkuName());
            detailReqDto.setBatch(csWmsBasicsDetailReqDto.getBatch());
            detailReqDto.setSnCodes(csWmsBasicsDetailReqDto.getSnCodes());
            detailReqDto.setQuantity(csWmsBasicsDetailReqDto.getQuantity());
            detailReqDto.setWeight(csWmsBasicsDetailReqDto.getWeight());
            detailReqDto.setVolume(csWmsBasicsDetailReqDto.getVolume());
            detailReqDto.setExpireTime(csWmsBasicsDetailReqDto.getExpireTime());
            detailReqDto.setProduceTime(csWmsBasicsDetailReqDto.getProduceTime());
            detailReqDto.setPreOrderItemId(csWmsBasicsDetailReqDto.getTradeOrderItemId());
            detailReqDto.setExtension(csWmsBasicsDetailReqDto.getExtensionExternal());
            detailReqDto.setDispatcherQuantity(csWmsBasicsDetailReqDto.getDispatcherQuantity());
            detailReqDto.setDispatcherStatus(csWmsBasicsDetailReqDto.getDispatcherStatus());
            baseOrderDetailReqDtos.add(detailReqDto);
        }
        inOutResultOrderFacadeBo.setOrderBasicsDetailReqDtoList((List)baseOrderDetailReqDtos);
        Long outResultOrderId = IdUtils.getId();
        inOutResultOrderFacadeBo.setWmsOrderNo(basicsReceiveBasicsReqDto.getWmsOrderNo());
        inOutResultOrderFacadeBo.setTotalCartons(basicsReceiveBasicsReqDto.getTotalCartons());
        inOutResultOrderFacadeBo.setMergeQuantity(basicsReceiveBasicsReqDto.getMergeQuantity());
        this.setResultCallback(basicsReceiveBasicsReqDto, inOutNoticeOrderEo, inOutNoticeOrderDetailEoList, flagMap, inFlag, detailReqDtoList, orderClassify, inOutResultOrderFacadeBo);
        logger.info("generateInResultOrderInfo==>\u751f\u6210\u5165\u5e93\u7ed3\u679c\u5355,inOutResultOrderFacadeBo:{}", (Object)LogUtils.buildLogContent(inOutResultOrderFacadeBo));
        if (this.PACKAGE_MATERIAL.equals(orderClassify)) {
            inOutResultOrderFacadeBo.setSourceType(CsInventorySourceTypeEnum.OUT_TO_PACKAGE_MATERIAL.getCode());
            inOutResultOrderFacadeBo.setAssignWarehouse(true);
            inOutResultOrderFacadeBo.setLogicWarehouseCode(basicsReceiveBasicsReqDto.getWarehouseCode());
        }
        InOutResultOrderContext context = this.callGenResultOrder(inOutNoticeOrderEo, inFlag, inOutResultOrderFacadeBo);
        InOutResultOrderEo csInResultOrderEo = context.getInOutResultOrderEo();
        CsInOutResultRespDto csInOutResultRespDto = new CsInOutResultRespDto();
        callBackContext.setCsInOutResultRespDto(csInOutResultRespDto);
        CubeBeanUtils.copyProperties((Object)csInOutResultRespDto, (Object)csInResultOrderEo, (String[])new String[0]);
        ArrayList inOutResultDetailRespDtoList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)inOutResultDetailRespDtoList, (Collection)context.getInOutResultOrderDetailEoList(), CsInOutResultDetailRespDto.class);
        csInOutResultRespDto.setInOutResultDetailRespDtoList((List)inOutResultDetailRespDtoList);
        callBackContext.setOutResultOrderId(outResultOrderId);
        return csInResultOrderEo;
    }

    private InOutResultOrderContext callGenResultOrder(InOutNoticeOrderEo inOutNoticeOrderEo, Boolean inFlag, InOutResultOrderFacadeBo inOutResultOrderFacadeBo) {
        InOutResultOrderContext context;
        if (inFlag.booleanValue()) {
            context = this.baseOrderFacade.inResultOrderGen(inOutResultOrderFacadeBo);
        } else {
            if (CsRelevanceTableNameEnum.CS_TRANSFER_ORDER.getCode().equals(inOutNoticeOrderEo.getRelevanceTableName())) {
                CsTransferOrderEo transferOrderEo = (CsTransferOrderEo)this.csTransferOrderMapper.selectOne((Wrapper)Wrappers.lambdaQuery(CsTransferOrderEo.class).eq(CsTransferOrderEo::getTransferOrderNo, (Object)inOutNoticeOrderEo.getRelevanceNo()));
                inOutResultOrderFacadeBo.setTransferInLogicWarehouseCode(transferOrderEo.getInLogicWarehouseCode());
            }
            context = this.baseOrderFacade.outResultOrderGen(inOutResultOrderFacadeBo);
        }
        return context;
    }

    private void setResultCallback(final CsBasicsReceiveReqDto basicsReceiveBasicsReqDto, final InOutNoticeOrderEo inOutNoticeOrderEo, List<InOutNoticeOrderDetailEo> inOutNoticeOrderDetailEoList, final Map<String, Boolean> flagMap, final Boolean inFlag, final List<CsWmsBasicsDetailReqDto> detailReqDtoList, final String orderClassify, InOutResultOrderFacadeBo inOutResultOrderFacadeBo) {
        final Map<String, List<InOutNoticeOrderDetailEo>> noticeDetailBatchMap = inOutNoticeOrderDetailEoList.stream().collect(Collectors.groupingBy(InOutNoticeOrderDetailEo::getSkuCode));
        inOutResultOrderFacadeBo.setCallBack((BaseOrderCallBack)new BaseOrderCallBack<BaseOrderBaseContext>(){

            public void beforeCallBack(BaseOrderBaseContext context) {
                boolean overchargeFlag;
                InOutResultOrderContext inContext = (InOutResultOrderContext)context;
                String overchargeReason = CsBdWmsExternalServiceImpl.this.checkOverchargeFlag(inOutNoticeOrderEo, noticeDetailBatchMap, detailReqDtoList);
                inContext.setHangup(StringUtils.isNotBlank((CharSequence)overchargeReason));
                InOutResultOrderEo inOutResultOrderEo = inContext.getInOutResultOrderEo();
                inOutResultOrderEo.setOverChargeReason(overchargeReason);
                inOutResultOrderEo.setOverChargeTime(inContext.getCurDate());
                inOutResultOrderEo.setWmsNo(basicsReceiveBasicsReqDto.getWmsOrderNo());
                inOutResultOrderEo.setBusinessType(inOutNoticeOrderEo.getBusinessType());
                inOutResultOrderEo.setOrderType("in");
                inOutResultOrderEo.setRelevanceTableName(inOutNoticeOrderEo.getRelevanceTableName());
                inOutResultOrderEo.setTotalVolume(basicsReceiveBasicsReqDto.getTotalVolume());
                inOutResultOrderEo.setTotalWeight(basicsReceiveBasicsReqDto.getTotalWeight());
                inOutResultOrderEo.setEstimatedTime(basicsReceiveBasicsReqDto.getEstimatedTime());
                inOutResultOrderEo.setOrderStatus(BaseOrderStatusEnum.IRO_DONE_IN.getCode());
                inOutResultOrderEo.setWarehouseId(inOutNoticeOrderEo.getWarehouseId());
                inOutResultOrderEo.setWarehouseCode(inOutNoticeOrderEo.getWarehouseCode());
                inOutResultOrderEo.setWarehouseName(inOutNoticeOrderEo.getWarehouseName());
                inOutResultOrderEo.setWarehouseClassify(CsWarehouseClassifyEnum.PHYSICS.getCode());
                inOutResultOrderEo.setShopName(inOutNoticeOrderEo.getShopName());
                inOutResultOrderEo.setShopCode(inOutNoticeOrderEo.getShopCode());
                inOutResultOrderEo.setShopId(inOutNoticeOrderEo.getShopId());
                BigDecimal totalQuantity = detailReqDtoList.stream().map(CsWmsBasicsDetailReqDto::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
                inOutResultOrderEo.setTotalQuantity(totalQuantity);
                String shippingJSON = JSON.toJSONString((Object)basicsReceiveBasicsReqDto.getShippingInfoReqDtoList());
                inOutResultOrderEo.setShippingJson(shippingJSON);
                if (!inContext.isHangup()) {
                    basicsReceiveBasicsReqDto.setRelevanceNo(inOutNoticeOrderEo.getRelevanceNo());
                    List shippingInfoReqDtoList = basicsReceiveBasicsReqDto.getShippingInfoReqDtoList();
                    if (CollectionUtils.isNotEmpty((Collection)shippingInfoReqDtoList)) {
                        for (CsWmsShippingInfoReqDto csWmsShippingInfoReqDto : shippingInfoReqDtoList) {
                            csWmsShippingInfoReqDto.setFirstShippingCompanyCode(csWmsShippingInfoReqDto.getShippingCompanyCode());
                            csWmsShippingInfoReqDto.setFirstShippingCompanyName(csWmsShippingInfoReqDto.getShippingCompanyName());
                        }
                    }
                    CsBdWmsExternalServiceImpl.this.logisticsMapping(basicsReceiveBasicsReqDto, inOutResultOrderEo);
                    if (StringUtils.isNotEmpty((CharSequence)basicsReceiveBasicsReqDto.getLogisticsRemark())) {
                        inOutResultOrderEo.setOverChargeReason("\u7269\u6d41\u6620\u5c04\u5f02\u5e38");
                        inOutResultOrderEo.setRemark(basicsReceiveBasicsReqDto.getLogisticsRemark());
                    }
                    shippingJSON = JSON.toJSONString((Object)basicsReceiveBasicsReqDto.getShippingInfoReqDtoList());
                    inOutResultOrderEo.setShippingJson(shippingJSON);
                }
                if (!inFlag.booleanValue()) {
                    inOutResultOrderEo.setOrderStatus(BaseOrderStatusEnum.ORO_DONE_OUT.getCode());
                    inOutResultOrderEo.setOrderType("out");
                }
                boolean bl = overchargeFlag = !flagMap.isEmpty() && (Boolean)flagMap.get(CsBdWmsExternalServiceImpl.this.overchargeFlag_key) != false;
                if (overchargeFlag) {
                    inOutResultOrderEo.setOrderStatus(BaseOrderStatusEnum.IRO_HANG_UP.getCode());
                    if (!inFlag.booleanValue()) {
                        inOutResultOrderEo.setOrderStatus(BaseOrderStatusEnum.ORO_HANG_UP.getCode());
                    }
                }
                inOutResultOrderEo.setOverchargeQuantity(detailReqDtoList.stream().filter(a -> CsTransferDispatcherStatusEnum.MORE_DISPATCHER.getCode().equals(a.getDispatcherStatus())).map(CsWmsBasicsDetailReqDto::getDispatcherQuantity).reduce(BigDecimal.ZERO, BigDecimal::add));
                inOutResultOrderEo.setReceivelessQuantity(detailReqDtoList.stream().filter(a -> CsTransferDispatcherStatusEnum.LESS_DISPATCHER.getCode().equals(a.getDispatcherStatus())).map(CsWmsBasicsDetailReqDto::getDispatcherQuantity).reduce(BigDecimal.ZERO, BigDecimal::add));
                inOutResultOrderEo.setDispatcherStatus(CsBdWmsExternalServiceImpl.this.getDispatcherStatus(inOutResultOrderEo.getOverchargeQuantity(), inOutResultOrderEo.getReceivelessQuantity()));
                inOutResultOrderEo.setInOutTime(basicsReceiveBasicsReqDto.getInOutTime());
                inOutResultOrderEo.setOrderClassify(orderClassify);
                CsBdWmsExternalServiceImpl.this.resultOrderWrapperWarehouse(inOutResultOrderEo, inOutNoticeOrderEo, basicsReceiveBasicsReqDto, detailReqDtoList);
                inContext.setNoticeEnd(true);
                if (CsBdWmsExternalServiceImpl.this.PACKAGE_MATERIAL.equals(orderClassify)) {
                    inOutResultOrderEo.setDisplayBusinessType(PcpBasicTradeBusinessTypeEnum.SALES_OUTBOUND_PACKAGING_RECIPIENTS.getCode());
                    inOutResultOrderEo.setDisplayBusinessName(PcpBasicTradeBusinessTypeEnum.SALES_OUTBOUND_PACKAGING_RECIPIENTS.getValue());
                    context.setDisplayBusinessType(PcpBasicTradeBusinessTypeEnum.SALES_OUTBOUND_PACKAGING_RECIPIENTS.getCode());
                    context.setDisplayBusinessName(PcpBasicTradeBusinessTypeEnum.SALES_OUTBOUND_PACKAGING_RECIPIENTS.getValue());
                    inContext.getInOutResultOrderDetailEoList().forEach(csInResultOrderDetailEo -> csInResultOrderDetailEo.setItemStatus(CsPlannedOrderItemStatusEnum.COMMON.getCode()));
                    inContext.setIgnorePreempt(true);
                    inContext.setAppendRecord(true);
                }
            }

            public void afterCallBack(BaseOrderBaseContext context) {
                InOutResultOrderContext inContext = (InOutResultOrderContext)context;
                CsBusinessCallBackStrategyEnum callBackStrategyEnum = CsBusinessCallBackStrategyEnum.getByTableName((String)inOutNoticeOrderEo.getRelevanceTableName());
                ICsBusinessOrderCallBackService businessOrderCallBackService = CsBusinessOrderCallBackUtils.getBusinessOrderCallBackService(callBackStrategyEnum.getCode());
                if (inContext.isHangup()) {
                    businessOrderCallBackService.updateMainOrderStatus(inOutNoticeOrderEo.getRelevanceNo(), true);
                } else if (basicsReceiveBasicsReqDto.getEnableAdjustInTransit().booleanValue() && Objects.equals(inOutNoticeOrderEo.getRelevanceTableName(), "cs_transfer_order")) {
                    CsBdWmsExternalServiceImpl.this.adjustInTransitHandler.handle(new IAdjustInTransitHandler.AdjustInTransitHandlerVo(inOutNoticeOrderEo, true, inContext.getInOutResultOrderDetailEoList(), inContext.getInOutResultOrderEo(), basicsReceiveBasicsReqDto.getAdjustInTransitAutoAudit()));
                }
            }
        });
    }

    private void resultOrderWrapperWarehouse(InOutResultOrderEo inOutResultOrderEo, InOutNoticeOrderEo inOutNoticeOrderEo, CsBasicsReceiveReqDto basicsReceiveBasicsReqDto, List<CsWmsBasicsDetailReqDto> detailReqDtoList) {
        String wmsWarehouseCode;
        String warehouseCode = "out".equals(inOutNoticeOrderEo.getOrderType()) ? inOutNoticeOrderEo.getOutLogicWarehouseCode() : inOutNoticeOrderEo.getInLogicWarehouseCode();
        String string = wmsWarehouseCode = Objects.nonNull(basicsReceiveBasicsReqDto.getWarehouseCode()) ? basicsReceiveBasicsReqDto.getWarehouseCode() : detailReqDtoList.get(0).getWarehouseCode();
        if (StringUtils.isNotBlank((CharSequence)wmsWarehouseCode) && !wmsWarehouseCode.equals(warehouseCode)) {
            List relWarehouseEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.relWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)wmsWarehouseCode)).eq((Object)"valid_flag", (Object)CsValidFlagEnum.ENABLE.getCode())).eq((Object)"warehouse_classify", (Object)CsWarehouseClassifyEnum.LOGIC.getCode())).eq((Object)"ref_warehouse_classify", (Object)CsWarehouseClassifyEnum.PHYSICS.getCode())).list();
            AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)relWarehouseEos), "wms\u8fd4\u56de\u7684\u4ed3\u5e93\u7f16\u7801\u4ed3\u5e93\u5173\u8054\u8868\u4e0d\u5b58\u5728");
            RelWarehouseEo warehouseEo = (RelWarehouseEo)relWarehouseEos.get(0);
            if ("out".equals(inOutNoticeOrderEo.getOrderType())) {
                inOutResultOrderEo.setOutLogicWarehouseCode(warehouseEo.getWarehouseCode());
                inOutResultOrderEo.setOutLogicWarehouseName(warehouseEo.getWarehouseName());
                inOutResultOrderEo.setOutPhysicsWarehouseCode(warehouseEo.getRefWarehouseCode());
                inOutResultOrderEo.setOutPhysicsWarehouseName(warehouseEo.getRefWarehouseName());
            } else {
                inOutResultOrderEo.setInLogicWarehouseCode(warehouseEo.getWarehouseCode());
                inOutResultOrderEo.setInLogicWarehouseName(warehouseEo.getWarehouseName());
                inOutResultOrderEo.setInPhysicsWarehouseCode(warehouseEo.getRefWarehouseCode());
                inOutResultOrderEo.setInPhysicsWarehouseName(warehouseEo.getRefWarehouseName());
            }
        } else {
            logger.info("wms\u56de\u4f20\u7684\u4ed3\u5e93\u7f16\u7801\u548c\u51fa\u5165\u5e93\u901a\u77e5\u5355\u7684\u4ed3\u5e93\u7f16\u7801\u4e00\u81f4\uff0c\u6309\u901a\u77e5\u5355\u7684\u4ed3\u5e93\u8bbe\u7f6e\u5230\u7ed3\u679c\u5355\u4e2d");
            inOutResultOrderEo.setInLogicWarehouseCode(inOutNoticeOrderEo.getInLogicWarehouseCode());
            inOutResultOrderEo.setInLogicWarehouseName(inOutNoticeOrderEo.getInLogicWarehouseName());
            inOutResultOrderEo.setInPhysicsWarehouseCode(inOutNoticeOrderEo.getInPhysicsWarehouseCode());
            inOutResultOrderEo.setInPhysicsWarehouseName(inOutNoticeOrderEo.getInPhysicsWarehouseName());
            inOutResultOrderEo.setOutLogicWarehouseCode(inOutNoticeOrderEo.getOutLogicWarehouseCode());
            inOutResultOrderEo.setOutLogicWarehouseName(inOutNoticeOrderEo.getOutLogicWarehouseName());
            inOutResultOrderEo.setOutPhysicsWarehouseCode(inOutNoticeOrderEo.getOutPhysicsWarehouseCode());
            inOutResultOrderEo.setOutPhysicsWarehouseName(inOutNoticeOrderEo.getOutPhysicsWarehouseName());
        }
    }

    private void logisticsMapping(CsBasicsReceiveReqDto csBasicsReceiveReqDto, InOutResultOrderEo inOutResultOrderEo) {
        if (!InventoryConfig.isLogisticsMapping()) {
            return;
        }
        logger.info("outSendBack-->csBasicsReceiveReqDto:{}", (Object)LogUtils.buildLogContent(csBasicsReceiveReqDto));
        List shippingInfoReqDtoList = csBasicsReceiveReqDto.getShippingInfoReqDtoList();
        if (CollectionUtils.isNotEmpty((Collection)shippingInfoReqDtoList)) {
            String warehouseCode;
            CsWmsShippingInfoReqDto csWmsShippingInfoReqDto = (CsWmsShippingInfoReqDto)shippingInfoReqDtoList.get(0);
            String shippingCompanyCode = csWmsShippingInfoReqDto.getShippingCompanyCode();
            if (StringUtils.isEmpty((CharSequence)shippingCompanyCode) && StringUtils.isNotEmpty((CharSequence)csBasicsReceiveReqDto.getShippingCompanyCode())) {
                shippingCompanyCode = csBasicsReceiveReqDto.getShippingCompanyCode();
            }
            if (StringUtils.isEmpty((CharSequence)(warehouseCode = csBasicsReceiveReqDto.getWarehouseCode())) && CollectionUtils.isNotEmpty((Collection)csBasicsReceiveReqDto.getDetailReqDtoList())) {
                warehouseCode = ((CsWmsBasicsDetailReqDto)csBasicsReceiveReqDto.getDetailReqDtoList().get(0)).getWarehouseCode();
            }
            CsLogicWarehouseRespDto csLogicWarehouseRespDto = this.csLogicWarehouseQueryService.queryByCodeAndFlag(warehouseCode);
            logger.info("outSendBack-->csLogicWarehouseRespDto:{}", (Object)LogUtils.buildLogContent(csLogicWarehouseRespDto));
            if (ObjectUtils.isNotEmpty((Object)csLogicWarehouseRespDto)) {
                TrLogisticsMappingRelationReqDto trLogisticsMappingRelationReqDto = new TrLogisticsMappingRelationReqDto();
                trLogisticsMappingRelationReqDto.setMappingType(LogisticsMappingType.WMS.getCode());
                trLogisticsMappingRelationReqDto.setExternalLogisticsCode(shippingCompanyCode);
                trLogisticsMappingRelationReqDto.setSystematicCode(csLogicWarehouseRespDto.getWarehouseCorrespondingSystem());
                trLogisticsMappingRelationReqDto.setOrderType(inOutResultOrderEo.getRelevanceTableName());
                logger.info("logisticsMapping-->trLogisticsMappingRelationReqDto:{}", (Object)LogUtils.buildLogContent(trLogisticsMappingRelationReqDto));
                TrLogisticsMappingRelationRespDto trLogisticsMappingRelationRespDto = this.trLogisticsMappingRelationQueryApiProxy.queryByRelationReqDtoSiteMatching(trLogisticsMappingRelationReqDto);
                logger.info("logisticsMapping-->trLogisticsMappingRelationRespDto:{}", (Object)LogUtils.buildLogContent(trLogisticsMappingRelationRespDto));
                if (ObjectUtils.isNotEmpty((Object)trLogisticsMappingRelationRespDto)) {
                    CsWmsShippingInfoReqDto wmsCsWmsShippingInfoReqDto = (CsWmsShippingInfoReqDto)shippingInfoReqDtoList.get(0);
                    for (CsWmsShippingInfoReqDto csWmsShippingInfoReq : shippingInfoReqDtoList) {
                        csWmsShippingInfoReq.setShippingCompanyCode(trLogisticsMappingRelationRespDto.getLogisticsCode());
                        csWmsShippingInfoReq.setShippingCompanyName(trLogisticsMappingRelationRespDto.getLogisticsName());
                        csWmsShippingInfoReq.setFirstShippingCompanyCode(wmsCsWmsShippingInfoReqDto.getShippingCompanyCode());
                        csWmsShippingInfoReq.setFirstShippingCompanyName(wmsCsWmsShippingInfoReqDto.getShippingCompanyName());
                    }
                } else {
                    String message = "\u53d1\u8d27\u56de\u4f20\u65f6\uff0cWMS\u7269\u6d41" + shippingCompanyCode + "\u6620\u5c04\u4e0d\u5230\u7269\u6d41\u7f16\u7801";
                    csBasicsReceiveReqDto.setLogisticsRemark(message);
                }
            }
        }
    }

    private void saveOrderAddressInfo(String generateResultDocumentNo, String noticeDocumentNo) {
        logger.info("saveOrderAddressInfo==>\u4fdd\u5b58\u5730\u5740\u4fe1\u606f,generateResultDocumentNo:{},noticeDocumentNo:{}", (Object)generateResultDocumentNo, (Object)noticeDocumentNo);
        QueryWrapper csBaseOrderAddressEoQueryWrapper = new QueryWrapper();
        csBaseOrderAddressEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        csBaseOrderAddressEoQueryWrapper.eq((Object)"document_no", (Object)noticeDocumentNo);
        List csBaseOrderAddressEoList = ((ExtQueryChainWrapper)this.baseOrderAddressDomain.filter().eq((Object)"document_no", (Object)noticeDocumentNo)).list();
        logger.info("saveOrderAddressInfo==>\u4fdd\u5b58\u5730\u5740\u4fe1\u606f,csBaseOrderAddressEoList:{}", (Object)LogUtils.buildLogContent(csBaseOrderAddressEoList));
        if (CollectionUtils.isEmpty((Collection)csBaseOrderAddressEoList)) {
            return;
        }
        ArrayList insertOrderAddressEoList = Lists.newArrayList();
        for (BaseOrderAddressEo sourceEo : csBaseOrderAddressEoList) {
            BaseOrderAddressEo insertEo = new BaseOrderAddressEo();
            CubeBeanUtils.copyProperties((Object)insertEo, (Object)sourceEo, (String[])new String[0]);
            insertEo.setId(null);
            insertEo.setDocumentNo(generateResultDocumentNo);
            insertOrderAddressEoList.add(insertEo);
        }
        logger.info("saveOrderAddressInfo==>\u4fdd\u5b58\u5730\u5740\u4fe1\u606f,insertOrderAddressEoList:{}", (Object)LogUtils.buildLogContent(insertOrderAddressEoList));
        this.baseOrderAddressDomain.insertBatch((List)insertOrderAddressEoList);
    }

    private void updateReceiveNoticeOrderInfo(ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo, CsBasicsReceiveReqDto basicsReceiveBasicsReqDto, Map<String, Boolean> flagMap, InOutNoticeOrderEo csOutNoticeOrderEo, Boolean inFlag) {
        String documentNo = receiveDeliveryNoticeOrderEo.getDocumentNo();
        QueryWrapper updateWrapper = new QueryWrapper();
        updateWrapper.eq((Object)"document_no", (Object)documentNo);
        this.receiveDeliveryNoticeOrderDetailDomain.getMapper().delete((Wrapper)updateWrapper);
        QueryWrapper csInNoticeOrderDetailEoQueryWrapper = new QueryWrapper();
        csInNoticeOrderDetailEoQueryWrapper.eq((Object)"document_no", (Object)csOutNoticeOrderEo.getDocumentNo());
        csInNoticeOrderDetailEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        List csInNoticeOrderDetailEoList = this.inOutNoticeOrderDetailDomain.getMapper().selectList((Wrapper)csInNoticeOrderDetailEoQueryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)csInNoticeOrderDetailEoList)) {
            ArrayList insertEoList = Lists.newArrayList();
            for (InOutNoticeOrderDetailEo tempEo : csInNoticeOrderDetailEoList) {
                ReceiveDeliveryNoticeOrderDetailEo receiveNoticeOrderDetailEo = new ReceiveDeliveryNoticeOrderDetailEo();
                receiveNoticeOrderDetailEo.setDocumentNo(receiveDeliveryNoticeOrderEo.getDocumentNo());
                receiveNoticeOrderDetailEo.setRelevanceNo(receiveDeliveryNoticeOrderEo.getRelevanceNo());
                receiveNoticeOrderDetailEo.setPreOrderNo(receiveDeliveryNoticeOrderEo.getPreOrderNo());
                receiveNoticeOrderDetailEo.setExternalOrderNo(receiveDeliveryNoticeOrderEo.getExternalOrderNo());
                receiveNoticeOrderDetailEo.setWmsOrderNo(receiveDeliveryNoticeOrderEo.getWmsOrderNo());
                receiveNoticeOrderDetailEo.setSkuCode(tempEo.getSkuCode());
                receiveNoticeOrderDetailEo.setSkuName(tempEo.getSkuName());
                receiveNoticeOrderDetailEo.setBatch(tempEo.getBatch());
                receiveNoticeOrderDetailEo.setOriginPlanQuantity(tempEo.getOriginPlanQuantity());
                receiveNoticeOrderDetailEo.setPlanQuantity(tempEo.getPlanQuantity());
                receiveNoticeOrderDetailEo.setWaitQuantity(tempEo.getWaitQuantity());
                receiveNoticeOrderDetailEo.setDoneQuantity(tempEo.getDoneQuantity());
                receiveNoticeOrderDetailEo.setCancelQuantity(tempEo.getCancelQuantity());
                receiveNoticeOrderDetailEo.setRemark(tempEo.getRemark());
                receiveNoticeOrderDetailEo.setItemStatus(tempEo.getItemStatus());
                receiveNoticeOrderDetailEo.setInitFlag(tempEo.getInitFlag());
                receiveNoticeOrderDetailEo.setDr(tempEo.getDr());
                receiveNoticeOrderDetailEo.setPreOrderItemId(tempEo.getPreOrderItemId());
                receiveNoticeOrderDetailEo.setWmsOrderNo(tempEo.getWmsOrderNo());
                insertEoList.add(receiveNoticeOrderDetailEo);
            }
            this.receiveDeliveryNoticeOrderDetailDomain.getMapper().insertBatch((List)insertEoList);
        }
        Boolean overchargeFlag = flagMap.get(this.overchargeFlag_key);
        Boolean portionFlag = flagMap.get(this.portionFlag_key);
        if (!overchargeFlag.booleanValue()) {
            receiveDeliveryNoticeOrderEo.setOrderStatus(BaseOrderStatusEnum.RNO_TOTAL_RECEIVE.getCode());
            if (!inFlag.booleanValue()) {
                receiveDeliveryNoticeOrderEo.setOrderStatus(BaseOrderStatusEnum.DNO_TOTAL_DELIVERY.getCode());
            }
            if (portionFlag.booleanValue()) {
                receiveDeliveryNoticeOrderEo.setOrderStatus(BaseOrderStatusEnum.RNO_PORTION_RECEIVE.getCode());
                if (!inFlag.booleanValue()) {
                    receiveDeliveryNoticeOrderEo.setOrderStatus(BaseOrderStatusEnum.DNO_PORTION_DELIVERY.getCode());
                }
            }
            receiveDeliveryNoticeOrderEo.setTotalCartons(basicsReceiveBasicsReqDto.getTotalCartons());
            receiveDeliveryNoticeOrderEo.setMergeQuantity(basicsReceiveBasicsReqDto.getMergeQuantity());
            receiveDeliveryNoticeOrderEo.setShippingCode(csOutNoticeOrderEo.getShippingCode());
            receiveDeliveryNoticeOrderEo.setShippingCompany(csOutNoticeOrderEo.getShippingCompany());
            receiveDeliveryNoticeOrderEo.setShippingCompanyName(csOutNoticeOrderEo.getShippingCompanyName());
            receiveDeliveryNoticeOrderEo.setShippingJson(csOutNoticeOrderEo.getShippingJson());
            UpdateWrapper csReceiveNoticeOrderEoUpdateWrapper = new UpdateWrapper();
            csReceiveNoticeOrderEoUpdateWrapper.eq((Object)"id", (Object)receiveDeliveryNoticeOrderEo.getId());
            this.receiveDeliveryNoticeOrderDomain.getMapper().update((Object)receiveDeliveryNoticeOrderEo, (Wrapper)csReceiveNoticeOrderEoUpdateWrapper);
        }
    }

    private Map<String, Boolean> updateInNoticeOrderInfo(String relevanceNo, CsBasicsReceiveReqDto basicsReceiveBasicsReqDto, InOutNoticeOrderEo csOutNoticeOrderEo, List<InOutNoticeOrderDetailEo> csOutNoticeOrderDetailEoList, Boolean inFlag) {
        Boolean lackBatchFlag;
        List initEoList = csOutNoticeOrderDetailEoList.stream().filter(eo -> eo.getInitFlag().equals(YesNoEnum.YES.getValue())).collect(Collectors.toList());
        InOutNoticeOrderDetailEo csOutNoticeOrderDetailEo = (InOutNoticeOrderDetailEo)initEoList.get(0);
        if (StringUtils.isBlank((CharSequence)csOutNoticeOrderDetailEo.getBatch())) {
            basicsReceiveBasicsReqDto.setLackBatchFlag(Boolean.TRUE);
        } else {
            basicsReceiveBasicsReqDto.setLackBatchFlag(Boolean.FALSE);
        }
        Map<Object, Object> flagMap = Maps.newHashMap();
        Boolean ignoreBatch = basicsReceiveBasicsReqDto.getIgnoreBatch();
        flagMap = Boolean.FALSE.equals(ignoreBatch) ? ((lackBatchFlag = basicsReceiveBasicsReqDto.getLackBatchFlag()).booleanValue() ? this.updateInNoticeLackBatchInfo(relevanceNo, basicsReceiveBasicsReqDto, csOutNoticeOrderEo, csOutNoticeOrderDetailEoList, inFlag) : this.updateInNoticeBatchInfo(basicsReceiveBasicsReqDto, csOutNoticeOrderDetailEoList, inFlag)) : this.updateInNoticeIgnoreBatchInfo(basicsReceiveBasicsReqDto, csOutNoticeOrderDetailEoList, inFlag, ignoreBatch);
        logger.info("updateInNoticeOrderInfo==>\u66f4\u65b0\u7ef4\u62a4\u5165\u5e93\u901a\u77e5\u5355\u4fe1\u606f,flagMap:{}", (Object)LogUtils.buildLogContent(flagMap));
        Boolean overchargeFlag = (Boolean)flagMap.get(this.overchargeFlag_key);
        Boolean portionFlag = (Boolean)flagMap.get(this.portionFlag_key);
        if (!overchargeFlag.booleanValue()) {
            csOutNoticeOrderEo.setOrderStatus(BaseOrderStatusEnum.INO_TOTAL_IN.getCode());
            if (!inFlag.booleanValue()) {
                csOutNoticeOrderEo.setOrderStatus(BaseOrderStatusEnum.ONO_TOTAL_OUT.getCode());
            }
            if (portionFlag.booleanValue()) {
                csOutNoticeOrderEo.setOrderStatus(BaseOrderStatusEnum.INO_PORTION_IN.getCode());
                if (!inFlag.booleanValue()) {
                    csOutNoticeOrderEo.setOrderStatus(BaseOrderStatusEnum.ONO_PORTION_OUT.getCode());
                }
            }
            csOutNoticeOrderEo.setTotalCartons(basicsReceiveBasicsReqDto.getTotalCartons());
            csOutNoticeOrderEo.setMergeQuantity(basicsReceiveBasicsReqDto.getMergeQuantity());
            UpdateWrapper csOutNoticeOrderEoUpdateWrapper = new UpdateWrapper();
            csOutNoticeOrderEoUpdateWrapper.eq((Object)"id", (Object)csOutNoticeOrderEo.getId());
            List shippingInfoReqDtoList = basicsReceiveBasicsReqDto.getShippingInfoReqDtoList();
            if (CollectionUtils.isNotEmpty((Collection)shippingInfoReqDtoList)) {
                shippingInfoReqDtoList.forEach(s -> s.setWmsOrderNo(basicsReceiveBasicsReqDto.getWmsOrderNo()));
                CsWmsShippingInfoReqDto csWmsShippingInfoReqDto = (CsWmsShippingInfoReqDto)shippingInfoReqDtoList.get(0);
                csOutNoticeOrderEo.setShippingCode(csWmsShippingInfoReqDto.getShippingNo());
                csOutNoticeOrderEo.setShippingCompany(csWmsShippingInfoReqDto.getShippingCompanyCode());
                csOutNoticeOrderEo.setShippingCompanyName(csWmsShippingInfoReqDto.getShippingCompanyName());
                String resultShippingJsonStr = this.formatShippingInfo(csOutNoticeOrderEo.getShippingJson(), shippingInfoReqDtoList);
                csOutNoticeOrderEo.setShippingJson(resultShippingJsonStr);
            }
            if (StringUtils.isNotEmpty((CharSequence)basicsReceiveBasicsReqDto.getLogisticsRemark())) {
                csOutNoticeOrderEo.setRemark(basicsReceiveBasicsReqDto.getLogisticsRemark());
            }
            this.inOutNoticeOrderDomain.getMapper().update((Object)csOutNoticeOrderEo, (Wrapper)csOutNoticeOrderEoUpdateWrapper);
        }
        return flagMap;
    }

    private String formatShippingInfo(String shippingJson, List<CsWmsShippingInfoReqDto> shippingInfoReqDtoList) {
        logger.info("formatShippingInfo==>\u5904\u7406\u5df2\u6709\u7684\u7269\u6d41json\u6570\u636e,shippingJson:{},shippingInfoReqDtoList:{}", (Object)shippingJson, (Object)LogUtils.buildLogContent(shippingInfoReqDtoList));
        List csWmsShippingInfoReqDtoList = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)shippingJson)) {
            try {
                csWmsShippingInfoReqDtoList = JSON.parseArray((String)shippingJson, CsWmsShippingInfoReqDto.class);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        HashSet shippingInfo = new HashSet();
        csWmsShippingInfoReqDtoList.stream().filter(e -> Objects.nonNull(e) && StringUtils.isNotBlank((CharSequence)e.getShippingNo())).forEach(e -> shippingInfo.add(e.getShippingCompanyCode() + " " + e.getShippingNo()));
        List removeDuplicateShippingInfoReqDtoList = shippingInfoReqDtoList.stream().filter(e -> !shippingInfo.contains(e.getShippingCompanyCode() + " " + e.getShippingNo())).collect(Collectors.toList());
        logger.info("\u53bb\u91cd\u540ewms\u56de\u4f20\u7684\u7269\u6d41\u4fe1\u606f:{}", (Object)JSON.toJSONString(removeDuplicateShippingInfoReqDtoList));
        if (CollectionUtils.isEmpty(removeDuplicateShippingInfoReqDtoList)) {
            return shippingJson;
        }
        csWmsShippingInfoReqDtoList.addAll(removeDuplicateShippingInfoReqDtoList);
        String resultShippingJsonStr = JSON.toJSONString(csWmsShippingInfoReqDtoList);
        logger.info("formatShippingInfo==>\u5904\u7406\u5df2\u6709\u7684\u7269\u6d41json\u6570\u636e,resultShippingJsonStr:{}", (Object)LogUtils.buildLogContent(resultShippingJsonStr));
        return resultShippingJsonStr;
    }

    private Map<String, Boolean> updateInNoticeBatchInfo(CsBasicsReceiveReqDto basicsReceiveBasicsReqDto, List<InOutNoticeOrderDetailEo> csOutNoticeOrderDetailEoList, Boolean inFlag) {
        String itemStatus = CsPlannedOrderItemStatusEnum.OVERCHARGE.getCode();
        if (!inFlag.booleanValue()) {
            itemStatus = CsPlannedOrderItemStatusEnum.DIFFERENCE.getCode();
        }
        List detailReqDtoList = basicsReceiveBasicsReqDto.getDetailReqDtoList();
        Boolean portionFlag = false;
        Boolean overchargeFlag = false;
        HashMap resultMap = Maps.newHashMap();
        Map sendBackDetailReqDtoMap = detailReqDtoList.stream().collect(Collectors.toMap(dto -> dto.getSkuCode(), Function.identity()));
        QueryWrapper updateWrapper = new QueryWrapper();
        for (InOutNoticeOrderDetailEo csInNoticeOrderDetailEo : csOutNoticeOrderDetailEoList) {
            String key = csInNoticeOrderDetailEo.getSkuCode();
            CsWmsBasicsDetailReqDto detailReqDto = (CsWmsBasicsDetailReqDto)sendBackDetailReqDtoMap.get(key);
            AssertUtil.isTrue(null != detailReqDto, String.format("\u3010%s\u3011\u6279\u6b21\u5728\u539f\u5165\u5e93\u901a\u77e5\u5355\u4e2d\u4e0d\u5b58\u5728", csInNoticeOrderDetailEo.getBatch()));
            BigDecimal sendBackQuantity = detailReqDto.getQuantity();
            BigDecimal planQuantity = csInNoticeOrderDetailEo.getPlanQuantity();
            BigDecimal doneQuantity = null == csInNoticeOrderDetailEo.getDoneQuantity() ? BigDecimal.ZERO : csInNoticeOrderDetailEo.getDoneQuantity();
            BigDecimal currentDoneQuantity = doneQuantity.add(sendBackQuantity);
            csInNoticeOrderDetailEo.setDoneQuantity(currentDoneQuantity);
            BigDecimal enableOverchargeVal = new BigDecimal(planQuantity.multiply(this.overchargeProportion).intValue());
            BigDecimal overchargeVal = new BigDecimal(currentDoneQuantity.subtract(enableOverchargeVal).intValue());
            int compareVal = overchargeVal.compareTo(BigDecimal.ZERO);
            int sendBackCompareVal = currentDoneQuantity.compareTo(planQuantity);
            if (sendBackCompareVal < 0) {
                portionFlag = true;
            } else if (sendBackCompareVal != 0 && (sendBackCompareVal <= 0 || compareVal > 0) && sendBackCompareVal > 0 && compareVal > 0) {
                overchargeFlag = true;
                csInNoticeOrderDetailEo.setItemStatus(itemStatus);
            }
            csInNoticeOrderDetailEo.setWaitQuantity(csInNoticeOrderDetailEo.getPlanQuantity().subtract(csInNoticeOrderDetailEo.getDoneQuantity()));
            updateWrapper.eq((Object)"id", (Object)csInNoticeOrderDetailEo.getId());
            this.inOutNoticeOrderDetailDomain.getMapper().update((Object)csInNoticeOrderDetailEo, (Wrapper)updateWrapper);
            updateWrapper.clear();
        }
        resultMap.put(this.portionFlag_key, portionFlag);
        resultMap.put(this.overchargeFlag_key, overchargeFlag);
        return resultMap;
    }

    private Map<String, Boolean> updateInNoticeIgnoreBatchInfo(CsBasicsReceiveReqDto basicsReceiveBasicsReqDto, List<InOutNoticeOrderDetailEo> csOutNoticeOrderDetailEoList, Boolean inFlag, Boolean ignoreBatch) {
        String itemStatus = CsPlannedOrderItemStatusEnum.OVERCHARGE.getCode();
        if (!inFlag.booleanValue()) {
            itemStatus = CsPlannedOrderItemStatusEnum.DIFFERENCE.getCode();
        }
        List detailReqDtoList = basicsReceiveBasicsReqDto.getDetailReqDtoList();
        Boolean portionFlag = false;
        Boolean overchargeFlag = false;
        HashMap resultMap = Maps.newHashMap();
        logger.info("updateInNoticeIgnoreBatchInfo==>\u66f4\u65b0\u5ffd\u7565\u5e26\u6279\u6b21\u7684,detailReqDtoList:{}", (Object)LogUtils.buildLogContent(detailReqDtoList));
        Map sendBackDetailReqDtoMap = detailReqDtoList.stream().collect(Collectors.toMap(dto -> dto.getSkuCode() + "_" + dto.getTradeOrderItemId(), Function.identity()));
        logger.info("updateInNoticeIgnoreBatchInfo==>\u66f4\u65b0\u5ffd\u7565\u5e26\u6279\u6b21\u7684,sendBackDetailReqDtoMap:{}", (Object)LogUtils.buildLogContent(sendBackDetailReqDtoMap));
        QueryWrapper updateWrapper = new QueryWrapper();
        for (InOutNoticeOrderDetailEo csInNoticeOrderDetailEo : csOutNoticeOrderDetailEoList) {
            String key = csInNoticeOrderDetailEo.getSkuCode() + "_" + csInNoticeOrderDetailEo.getPreOrderItemId();
            CsWmsBasicsDetailReqDto detailReqDto = (CsWmsBasicsDetailReqDto)sendBackDetailReqDtoMap.get(key);
            BigDecimal planQuantity = csInNoticeOrderDetailEo.getPlanQuantity();
            BigDecimal doneQuantity = null == csInNoticeOrderDetailEo.getDoneQuantity() ? BigDecimal.ZERO : csInNoticeOrderDetailEo.getDoneQuantity();
            BigDecimal enableOverchargeVal = new BigDecimal(planQuantity.multiply(this.overchargeProportion).intValue());
            if (null == detailReqDto) {
                logger.info("\u6839\u636e\u51fa\u5165\u5e93\u901a\u77e5\u5355\u4ea7\u54c1\u7f16\u7801\uff1a{} \u5728\u56de\u4f20\u7684\u4ea7\u54c1\u4e2d\u627e\u4e0d\u5230\u3002\u53ea\u9700\u5224\u65ad\u4ea7\u54c1\u6570\u91cf\u662f\u5426\u90e8\u5206\u53d1\u8d27\u6216\u8d85\u6536\uff0c\u4e0d\u66f4\u65b0\u660e\u7ec6\u4fe1\u606f", (Object)key);
                int sendBackCompareVal = doneQuantity.compareTo(planQuantity);
                BigDecimal overchargeVal = new BigDecimal(doneQuantity.subtract(enableOverchargeVal).intValue());
                int compareVal = overchargeVal.compareTo(BigDecimal.ZERO);
                if (sendBackCompareVal < 0) {
                    portionFlag = true;
                    continue;
                }
                if (sendBackCompareVal <= 0 || compareVal <= 0) continue;
                overchargeFlag = true;
                continue;
            }
            BigDecimal sendBackQuantity = detailReqDto.getQuantity();
            BigDecimal currentDoneQuantity = doneQuantity.add(sendBackQuantity);
            csInNoticeOrderDetailEo.setDoneQuantity(currentDoneQuantity);
            BigDecimal overchargeVal = new BigDecimal(currentDoneQuantity.subtract(enableOverchargeVal).intValue());
            int compareVal = overchargeVal.compareTo(BigDecimal.ZERO);
            int sendBackCompareVal = currentDoneQuantity.compareTo(planQuantity);
            if (sendBackCompareVal < 0) {
                portionFlag = true;
            } else if (sendBackCompareVal != 0 && (sendBackCompareVal <= 0 || compareVal > 0) && sendBackCompareVal > 0 && compareVal > 0) {
                overchargeFlag = true;
                csInNoticeOrderDetailEo.setItemStatus(itemStatus);
            }
            csInNoticeOrderDetailEo.setWaitQuantity(csInNoticeOrderDetailEo.getPlanQuantity().subtract(csInNoticeOrderDetailEo.getDoneQuantity()));
            logger.info("\u5df2\u5165\u5e93\u6570\u91cf:\u3010{}\u3011\uff0c\u672c\u6b21\u7684\u5df2\u5165\u6570\u91cf:\u3010{}\u3011", (Object)JSON.toJSONString((Object)doneQuantity), (Object)JSON.toJSONString((Object)currentDoneQuantity));
            updateWrapper.eq((Object)"id", (Object)csInNoticeOrderDetailEo.getId());
            this.inOutNoticeOrderDetailDomain.getMapper().update((Object)csInNoticeOrderDetailEo, (Wrapper)updateWrapper);
            updateWrapper.clear();
        }
        resultMap.put(this.portionFlag_key, portionFlag);
        resultMap.put(this.overchargeFlag_key, overchargeFlag);
        if (ignoreBatch.booleanValue() && (overchargeFlag = (Boolean)resultMap.get(this.overchargeFlag_key)).booleanValue()) {
            resultMap.put(this.overchargeFlag_key, false);
            resultMap.put(this.inTransferHangUpFlag_key, Boolean.TRUE);
        }
        return resultMap;
    }

    private Map<String, Boolean> updateInNoticeLackBatchInfo(String relevanceNo, CsBasicsReceiveReqDto basicsReceiveBasicsReqDto, InOutNoticeOrderEo InOutNoticeOrderEo2, List<InOutNoticeOrderDetailEo> inOutNoticeOrderDetailEoList, Boolean inFlag) {
        String orderType = inFlag != false ? "in" : "out";
        List outResultOrderEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutResultOrderDomain.filter().eq((Object)"relevance_no", (Object)relevanceNo)).eq((Object)"order_type", (Object)orderType)).list();
        if (CollectionUtils.isEmpty((Collection)outResultOrderEoList)) {
            return this.firstTimeSendBack(basicsReceiveBasicsReqDto, InOutNoticeOrderEo2, inOutNoticeOrderDetailEoList, inFlag);
        }
        return this.followUpSendBack(basicsReceiveBasicsReqDto, inOutNoticeOrderDetailEoList, inFlag);
    }

    private Map<String, Boolean> followUpSendBack(CsBasicsReceiveReqDto basicsReceiveBasicsReqDto, List<InOutNoticeOrderDetailEo> csOutNoticeOrderDetailEoList, Boolean inFlag) {
        Long id;
        QueryWrapper batchEoUpdateWrapper;
        String longCode;
        String itemStatus = CsPlannedOrderItemStatusEnum.OVERCHARGE.getCode();
        if (!inFlag.booleanValue()) {
            itemStatus = CsPlannedOrderItemStatusEnum.DIFFERENCE.getCode();
        }
        Boolean portionFlag = false;
        Boolean overchargeFlag = false;
        Boolean updateWaitToZeroFlag = false;
        HashMap resultMap = Maps.newHashMap();
        List sendBackDetailReqDtoList = basicsReceiveBasicsReqDto.getDetailReqDtoList();
        ArrayList initEoList = Lists.newArrayList();
        ArrayList batchEoList = Lists.newArrayList();
        for (InOutNoticeOrderDetailEo detailEo : csOutNoticeOrderDetailEoList) {
            Integer initFlag = detailEo.getInitFlag();
            if (YesNoEnum.YES.getValue().equals(initFlag)) {
                initEoList.add(detailEo);
                continue;
            }
            batchEoList.add(detailEo);
        }
        Map batchEoMap = batchEoList.stream().collect(Collectors.toMap(eo -> eo.getSkuCode() + "_" + eo.getBatch(), Function.identity()));
        InOutNoticeOrderDetailEo basicsBatchEo = (InOutNoticeOrderDetailEo)batchEoList.get(0);
        Map<Object, Object> initEoMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)initEoList)) {
            initEoMap = initEoList.stream().collect(Collectors.toMap(InOutNoticeOrderDetailEo::getSkuCode, Function.identity()));
        }
        for (CsWmsBasicsDetailReqDto detailReqDto : sendBackDetailReqDtoList) {
            String key = detailReqDto.getSkuCode() + "_" + detailReqDto.getBatch();
            InOutNoticeOrderDetailEo batchEo = (InOutNoticeOrderDetailEo)batchEoMap.get(key);
            longCode = detailReqDto.getSkuCode();
            InOutNoticeOrderDetailEo csOutNoticeOrderDetailEo = (InOutNoticeOrderDetailEo)initEoMap.get(longCode);
            if (null != batchEo) {
                batchEo.setDoneQuantity(batchEo.getDoneQuantity().add(detailReqDto.getQuantity()));
                batchEo.setPlanQuantity(batchEo.getDoneQuantity());
                batchEo.setWaitQuantity(BigDecimal.ZERO);
                continue;
            }
            InOutNoticeOrderDetailEo newBatchEo = new InOutNoticeOrderDetailEo();
            CubeBeanUtils.copyProperties((Object)newBatchEo, (Object)basicsBatchEo, (String[])new String[0]);
            newBatchEo.setId(null);
            newBatchEo.setBatch(detailReqDto.getBatch());
            newBatchEo.setSkuCode(detailReqDto.getSkuCode());
            newBatchEo.setPlanQuantity(detailReqDto.getQuantity());
            newBatchEo.setDoneQuantity(detailReqDto.getQuantity());
            newBatchEo.setOriginPlanQuantity(detailReqDto.getQuantity());
            if (null != csOutNoticeOrderDetailEo) {
                newBatchEo.setSkuName(csOutNoticeOrderDetailEo.getSkuName());
                newBatchEo.setSkuCode(csOutNoticeOrderDetailEo.getSkuCode());
            }
            newBatchEo.setWaitQuantity(BigDecimal.ZERO);
            newBatchEo.setInitFlag(YesNoEnum.NO.getValue());
            batchEoList.add(newBatchEo);
        }
        Map<String, List<InOutNoticeOrderDetailEo>> mergeBatchEoMap = batchEoList.stream().collect(Collectors.groupingBy(InOutNoticeOrderDetailEo::getSkuCode));
        ArrayList updateInitEoList = Lists.newArrayList();
        for (InOutNoticeOrderDetailEo initEo : initEoList) {
            longCode = initEo.getSkuCode();
            InOutNoticeOrderDetailEo tempInitEo = (InOutNoticeOrderDetailEo)initEoMap.get(longCode);
            BigDecimal planQuantity = tempInitEo.getPlanQuantity();
            BigDecimal enableOverchargeVal = new BigDecimal(planQuantity.multiply(this.overchargeProportion).intValue());
            List<InOutNoticeOrderDetailEo> mergeBatchEoList = mergeBatchEoMap.get(longCode);
            BigDecimal mergeTotalDoneQuantity = mergeBatchEoList.stream().map(InOutNoticeOrderDetailEo::getDoneQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal overchargeVal = new BigDecimal(mergeTotalDoneQuantity.subtract(enableOverchargeVal).intValue());
            int compareVal = overchargeVal.compareTo(BigDecimal.ZERO);
            int sendBackCompareVal = mergeTotalDoneQuantity.compareTo(planQuantity);
            if (sendBackCompareVal < 0) {
                portionFlag = true;
            } else if (sendBackCompareVal == 0 || sendBackCompareVal > 0 && compareVal <= 0) {
                updateWaitToZeroFlag = true;
            } else if (sendBackCompareVal > 0 && compareVal > 0) {
                overchargeFlag = true;
                initEo.setItemStatus(itemStatus);
            }
            initEo.setDoneQuantity(mergeTotalDoneQuantity);
            initEo.setWaitQuantity(initEo.getPlanQuantity().subtract(initEo.getDoneQuantity()));
            updateInitEoList.add(initEo);
        }
        if (CollectionUtils.isNotEmpty((Collection)batchEoList)) {
            batchEoUpdateWrapper = new QueryWrapper();
            for (InOutNoticeOrderDetailEo batchUpdateEo : batchEoList) {
                id = batchUpdateEo.getId();
                if (null != id) {
                    batchEoUpdateWrapper.eq((Object)"id", (Object)id);
                    this.inOutNoticeOrderDetailDomain.getMapper().update((Object)batchUpdateEo, (Wrapper)batchEoUpdateWrapper);
                    batchEoUpdateWrapper.clear();
                    continue;
                }
                this.inOutNoticeOrderDetailDomain.getMapper().insert((Object)batchUpdateEo);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)updateInitEoList)) {
            batchEoUpdateWrapper = new QueryWrapper();
            for (InOutNoticeOrderDetailEo initUpdateEo : updateInitEoList) {
                id = initUpdateEo.getId();
                batchEoUpdateWrapper.eq((Object)"id", (Object)id);
                initUpdateEo.setWmsOrderNo(basicsReceiveBasicsReqDto.getWmsOrderNo());
                if (updateWaitToZeroFlag.booleanValue()) {
                    initUpdateEo.setWaitQuantity(BigDecimal.ZERO);
                }
                this.inOutNoticeOrderDetailDomain.getMapper().update((Object)initUpdateEo, (Wrapper)batchEoUpdateWrapper);
                batchEoUpdateWrapper.clear();
            }
        }
        resultMap.put(this.portionFlag_key, portionFlag);
        resultMap.put(this.overchargeFlag_key, overchargeFlag);
        return resultMap;
    }

    private Map<String, Boolean> firstTimeSendBack(CsBasicsReceiveReqDto basicsReceiveBasicsReqDto, InOutNoticeOrderEo csOutNoticeOrderEo, List<InOutNoticeOrderDetailEo> initEoList, Boolean inFlag) {
        String itemStatus = CsPlannedOrderItemStatusEnum.OVERCHARGE.getCode();
        if (!inFlag.booleanValue()) {
            itemStatus = CsPlannedOrderItemStatusEnum.DIFFERENCE.getCode();
        }
        Boolean portionFlag = false;
        Boolean overchargeFlag = false;
        Boolean updateWaitToZeroFlag = false;
        HashMap resultMap = Maps.newHashMap();
        Map initEoMap = initEoList.stream().collect(Collectors.toMap(InOutNoticeOrderDetailEo::getSkuCode, Function.identity()));
        List detailReqDtoList = basicsReceiveBasicsReqDto.getDetailReqDtoList();
        Map<String, List<CsWmsBasicsDetailReqDto>> wmsSendBackMap = detailReqDtoList.stream().collect(Collectors.groupingBy(CsWmsBasicsDetailReqDto::getSkuCode));
        ArrayList insertBatchList = Lists.newArrayList();
        Set<Map.Entry<String, List<CsWmsBasicsDetailReqDto>>> entrySet = wmsSendBackMap.entrySet();
        for (Map.Entry<String, List<CsWmsBasicsDetailReqDto>> entry : entrySet) {
            String longCode = entry.getKey();
            List<CsWmsBasicsDetailReqDto> csWmsInSendBackDetailReqDtoList = entry.getValue();
            List sortSendBackList = csWmsInSendBackDetailReqDtoList.stream().sorted(Comparator.comparing(CsWmsBasicsDetailReqDto::getQuantity).reversed()).collect(Collectors.toList());
            InOutNoticeOrderDetailEo csOutNoticeOrderDetailEo = (InOutNoticeOrderDetailEo)initEoMap.get(longCode);
            BigDecimal planQuantity = csOutNoticeOrderDetailEo.getPlanQuantity();
            BigDecimal enableOverchargeVal = new BigDecimal(planQuantity.multiply(this.overchargeProportion).intValue());
            BigDecimal sendBackTotalQuantity = csWmsInSendBackDetailReqDtoList.stream().map(CsWmsBasicsDetailReqDto::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal overchargeVal = new BigDecimal(sendBackTotalQuantity.subtract(enableOverchargeVal).intValue());
            int compareVal = overchargeVal.compareTo(BigDecimal.ZERO);
            int sendBackCompareVal = sendBackTotalQuantity.compareTo(planQuantity);
            for (CsWmsBasicsDetailReqDto sendBackDetailReqDto : sortSendBackList) {
                InOutNoticeOrderDetailEo insertBatchEo = new InOutNoticeOrderDetailEo();
                CubeBeanUtils.copyProperties((Object)insertBatchEo, (Object)csOutNoticeOrderDetailEo, (String[])new String[0]);
                insertBatchEo.setId(null);
                insertBatchEo.setDocumentNo(csOutNoticeOrderEo.getDocumentNo());
                insertBatchEo.setRelevanceNo(csOutNoticeOrderEo.getRelevanceNo());
                insertBatchEo.setPreOrderNo(csOutNoticeOrderEo.getPreOrderNo());
                insertBatchEo.setExternalOrderNo(csOutNoticeOrderEo.getExternalOrderNo());
                insertBatchEo.setWmsOrderNo(basicsReceiveBasicsReqDto.getWmsOrderNo());
                insertBatchEo.setOriginPlanQuantity(sendBackDetailReqDto.getQuantity());
                insertBatchEo.setPlanQuantity(sendBackDetailReqDto.getQuantity());
                insertBatchEo.setDoneQuantity(sendBackDetailReqDto.getQuantity());
                insertBatchEo.setWaitQuantity(BigDecimal.ZERO);
                insertBatchEo.setBatch(sendBackDetailReqDto.getBatch());
                insertBatchEo.setItemStatus(CsPlannedOrderItemStatusEnum.COMMON.getCode());
                insertBatchEo.setRemark(null);
                insertBatchEo.setInitFlag(YesNoEnum.NO.getValue());
                insertBatchList.add(insertBatchEo);
            }
            BigDecimal doneQuantity = sortSendBackList.stream().map(CsWmsBasicsDetailReqDto::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
            csOutNoticeOrderDetailEo.setDoneQuantity(doneQuantity);
            csOutNoticeOrderDetailEo.setWaitQuantity(csOutNoticeOrderDetailEo.getPlanQuantity().subtract(csOutNoticeOrderDetailEo.getDoneQuantity()));
            if (sendBackCompareVal < 0) {
                portionFlag = true;
                continue;
            }
            if (sendBackCompareVal == 0 || sendBackCompareVal > 0 && compareVal <= 0) {
                updateWaitToZeroFlag = true;
                continue;
            }
            if (sendBackCompareVal <= 0 || compareVal <= 0) continue;
            overchargeFlag = true;
            csOutNoticeOrderDetailEo.setItemStatus(itemStatus);
        }
        QueryWrapper csOutNoticeOrderDetailEoQueryWrapper = new QueryWrapper();
        for (InOutNoticeOrderDetailEo csOutNoticeOrderDetailEo : initEoList) {
            Long id = csOutNoticeOrderDetailEo.getId();
            csOutNoticeOrderDetailEoQueryWrapper.eq((Object)"id", (Object)id);
            csOutNoticeOrderDetailEo.setWmsOrderNo(basicsReceiveBasicsReqDto.getWmsOrderNo());
            if (updateWaitToZeroFlag.booleanValue()) {
                csOutNoticeOrderDetailEo.setWaitQuantity(BigDecimal.ZERO);
            }
            this.inOutNoticeOrderDetailDomain.getMapper().update((Object)csOutNoticeOrderDetailEo, (Wrapper)csOutNoticeOrderDetailEoQueryWrapper);
            csOutNoticeOrderDetailEoQueryWrapper.clear();
        }
        if (CollectionUtils.isNotEmpty((Collection)insertBatchList)) {
            this.inOutNoticeOrderDetailDomain.getMapper().insertBatch((List)insertBatchList);
        }
        resultMap.put(this.portionFlag_key, portionFlag);
        resultMap.put(this.overchargeFlag_key, overchargeFlag);
        return resultMap;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean cancel(CsBasicsCancelReqDto csBasicsCancelReqDto) {
        logger.info("cancel==>WMS\u53d1\u8d77\u53d6\u6d88\u64cd\u4f5c,csBasicsCancelReqDto:{}", (Object)LogUtils.buildLogContent(csBasicsCancelReqDto));
        this.checkParams(csBasicsCancelReqDto);
        String noticeOrderNo = csBasicsCancelReqDto.getNoticeOrderNo();
        InOutNoticeOrderEo inOutNoticeOrderEo = (InOutNoticeOrderEo)((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"document_no", (Object)noticeOrderNo)).one();
        AssertUtil.isTrue(null != inOutNoticeOrderEo, "\u67e5\u8be2\u4e0d\u5230\u51fa\u5165\u5e93\u901a\u77e5\u5355\u4fe1\u606f");
        if ("in".equals(inOutNoticeOrderEo.getOrderType())) {
            AssertUtil.isTrue(!BaseOrderStatusEnum.ONO_CANCEL.getCode().equals(inOutNoticeOrderEo.getOrderStatus()), "\u5df2\u53d6\u6d88\u72b6\u6001\u4e0d\u5141\u8bb8\u91cd\u590d\u64cd\u4f5c\u53d6\u6d88");
        } else if ("out".equals(inOutNoticeOrderEo.getOrderType())) {
            AssertUtil.isTrue(!BaseOrderStatusEnum.DNO_CANCEL.getCode().equals(inOutNoticeOrderEo.getOrderStatus()), "\u5df2\u53d6\u6d88\u72b6\u6001\u4e0d\u5141\u8bb8\u91cd\u590d\u64cd\u4f5c\u53d6\u6d88");
        }
        String orderType = inOutNoticeOrderEo.getOrderType();
        CsOrderBusinessCallBackContext callBackContext = new CsOrderBusinessCallBackContext();
        if ("in".equals(orderType)) {
            this.inCancel(inOutNoticeOrderEo, csBasicsCancelReqDto);
            callBackContext.setInFlag(Boolean.valueOf(true));
        } else if ("out".equals(orderType)) {
            this.outCancel(inOutNoticeOrderEo, csBasicsCancelReqDto);
            callBackContext.setInFlag(Boolean.valueOf(false));
        }
        String relevanceTableName = inOutNoticeOrderEo.getRelevanceTableName();
        CsBusinessCallBackStrategyEnum callBackStrategyEnum = CsBusinessCallBackStrategyEnum.getByTableName((String)("bd_" + relevanceTableName));
        ICsBusinessOrderCallBackService businessOrderCallBackService = CsBusinessOrderCallBackUtils.getBusinessOrderCallBackService(callBackStrategyEnum.getCode());
        callBackContext.setRelevanceNo(inOutNoticeOrderEo.getRelevanceNo());
        callBackContext.setDocumentNo(csBasicsCancelReqDto.getNoticeOrderNo());
        businessOrderCallBackService.wmsCancel(callBackContext);
        return true;
    }

    @Override
    public void pushPackageMaterialDeliveryResultOrderMsg(CsOrderBusinessCallBackContext callBackContext) {
        logger.info("\u5305\u6750\u4fe1\u606f\u63a8sap:{}", (Object)JSON.toJSONString((Object)callBackContext));
        CsInOutResultRespDto csInOutResultRespDto = callBackContext.getCsInOutResultRespDto();
        List detailList = csInOutResultRespDto.getInOutResultDetailRespDtoList();
        List outNoticeOrderEos = this.inOutNoticeOrderDomain.queryByDocumentNo(csInOutResultRespDto.getPreOrderNo());
        logger.info("\u6839\u636e\u7ed3\u679c\u5355\u7684\u524d\u7f6e\u5355\u53f7\uff1a{}\u67e5\u8be2\u901a\u77e5\u5355\u4fe1\u606f\uff1a{}", (Object)csInOutResultRespDto.getPreOrderNo(), (Object)JSON.toJSONString((Object)outNoticeOrderEos));
        if (CollectionUtils.isEmpty((Collection)outNoticeOrderEos)) {
            return;
        }
        List<String> notSaleBusinessTypes = Arrays.asList(PcpBasicInventoryBusinessTypeEnum.TRANSFER_STAFF_OPPORTUNITY.getCode(), PcpBasicInventoryBusinessTypeEnum.TRANSFER_BORROW_MACHINE.getCode(), PcpBasicInventoryBusinessTypeEnum.TRANSFER_WARHEOUSE.getCode(), PcpBasicInventoryBusinessTypeEnum.TRANSFER_CONSIGNMENT_TO_CARGO.getCode(), PcpBasicInventoryBusinessTypeEnum.TRANSFER_STORES_TO_CARGO.getCode(), PcpBasicInventoryBusinessTypeEnum.TRANSFER_STORE_SALES_WARHEOUSE_SEND.getCode(), PcpBasicInventoryBusinessTypeEnum.TRANSFER_STORE_RAISED.getCode());
        if (!notSaleBusinessTypes.contains(((InOutNoticeOrderEo)outNoticeOrderEos.get(0)).getDisplayBusinessType())) {
            logger.info("\u975e\u8fd9\u4e9b\u7c7b\u578b\u7684\u5305\u6750\u4fe1\u606f\u4e0d\u7528\u63a8sap\uff1a\u5458\u5de5\u501f\u673a-71003,\u8bd5\u4ea7\u673a\u501f\u7528-71001,\u4ed3\u5e93\u8c03\u62e8-71010,\u5bc4\u552e\u8981\u8d27-71005");
            return;
        }
        if (!callBackContext.getInFlag().booleanValue()) {
            this.pushOrder(callBackContext.getOutResultOrderId().toString(), csInOutResultRespDto, detailList, "PUSH_DELIVERY_RESULT_ORDER", csInOutResultRespDto.getOutLogicWarehouseCode());
        }
    }

    private void pushOrder(String id, CsInOutResultRespDto inOutResultRespDto, List<CsInOutResultDetailRespDto> detailList, String tag, String warehouseCode) {
        logger.info("\u5305\u6750\u4fe1\u606f\u8fdb\u5165pushOrder\u65b9\u6cd5,id:{},relevanceNo:{},csDeliveryReceiveResultRespDto:{}", new Object[]{id, inOutResultRespDto.getRelevanceNo(), LogUtils.buildLogContent(inOutResultRespDto)});
        String relevanceNo = inOutResultRespDto.getRelevanceNo();
        PushStorageOrderHeadReqDto head = new PushStorageOrderHeadReqDto();
        head.setId(id);
        head.setCreateDate(DateUtil.formatDateTime((Date)new Date()));
        head.setSapMoveType(SapCenterTypeEnum.getSapType((String)inOutResultRespDto.getDisplayBusinessType()));
        String factoryType = "1220";
        head.setFactoryType(factoryType);
        head.setRefNo(inOutResultRespDto.getDocumentNo());
        head.setTransferOrderNo(relevanceNo);
        head.setSrcOrderNo(inOutResultRespDto.getExternalOrderNo());
        ArrayList<PushItemReqDto> itemReqDtoList = new ArrayList<PushItemReqDto>(detailList.size());
        DecimalFormat df = new DecimalFormat("#0.00");
        String moveReason = "";
        if (CsRelevanceTableNameEnum.CS_TRANSFER_ORDER.getCode().equals(inOutResultRespDto.getRelevanceTableName())) {
            List<String> product = Arrays.asList(CsPcpBusinessTypeEnum.DICT_ALLOT_PRODUCTION_BORROW.getCode(), CsPcpBusinessTypeEnum.DICT_ALLOT_PRODUCTION_RETURN.getCode());
            if (product.contains(inOutResultRespDto.getDisplayBusinessType())) {
                moveReason = "0004";
            }
            head.setSrcOrderNo(null);
        }
        for (int i = 0; i < detailList.size(); ++i) {
            PushItemReqDto sapItemReqDto = new PushItemReqDto();
            sapItemReqDto.setCode(detailList.get(i).getSkuCode());
            sapItemReqDto.setRowNum(String.valueOf(i + 1));
            sapItemReqDto.setWarehouseCode(warehouseCode);
            sapItemReqDto.setNum(df.format(detailList.get(i).getQuantity()));
            sapItemReqDto.setFactoryType(factoryType);
            sapItemReqDto.setMoveReason(moveReason);
            itemReqDtoList.add(sapItemReqDto);
        }
        PushStorageOrderReqDto sapStorageOrderReqDto = new PushStorageOrderReqDto();
        sapStorageOrderReqDto.setStorageOrderHearReqDto(head);
        sapStorageOrderReqDto.setItemReqDtoList(itemReqDtoList);
        logger.info("\u5305\u6750\u51fa\u5e93\u7ed3\u679c\u5355,pushOrder\u63a8\u9001\u975e\u9500\u552e\u51fa\u5e93\u5355mq\u6d88\u606f,sapStorageOrderReqDto:{}", (Object)LogUtils.buildLogContent(sapStorageOrderReqDto));
        this.mqService.sendSingleMessage("SINGLE_TOPIC", tag, (Object)JSON.toJSONString((Object)sapStorageOrderReqDto));
    }

    private void outCancel(InOutNoticeOrderEo csOutNoticeOrderEo, CsBasicsCancelReqDto csBasicsCancelReqDto) {
        logger.info("inCancel==>\u51fa\u5e93\u7684\u53d6\u6d88,csOutNoticeOrderEo:{},csBasicsCancelReqDto:{}", (Object)LogUtils.buildLogContent(csOutNoticeOrderEo), (Object)LogUtils.buildLogContent(csBasicsCancelReqDto));
        csOutNoticeOrderEo.setOrderStatus(BaseOrderStatusEnum.ONO_CANCEL.getCode());
        QueryWrapper csOutNoticeOrderEoQueryWrapper = new QueryWrapper();
        csOutNoticeOrderEoQueryWrapper.eq((Object)"document_no", (Object)csOutNoticeOrderEo.getDocumentNo());
        this.inOutNoticeOrderDomain.getMapper().update((Object)csOutNoticeOrderEo, (Wrapper)csOutNoticeOrderEoQueryWrapper);
        QueryWrapper csDeliveryNoticeOrderEoQueryWrapper = new QueryWrapper();
        csDeliveryNoticeOrderEoQueryWrapper.eq((Object)"document_no", (Object)csOutNoticeOrderEo.getPreOrderNo());
        csDeliveryNoticeOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        csDeliveryNoticeOrderEoQueryWrapper.eq((Object)"order_type", (Object)"delivery");
        ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo = (ReceiveDeliveryNoticeOrderEo)this.receiveDeliveryNoticeOrderDomain.getMapper().selectOne((Wrapper)csDeliveryNoticeOrderEoQueryWrapper);
        AssertUtil.isTrue(null != receiveDeliveryNoticeOrderEo, "\u67e5\u8be2\u4e0d\u5230\u53d1\u8d27\u5e93\u901a\u77e5\u5355\u4fe1\u606f");
        csDeliveryNoticeOrderEoQueryWrapper.clear();
        csDeliveryNoticeOrderEoQueryWrapper.eq((Object)"document_no", (Object)receiveDeliveryNoticeOrderEo.getDocumentNo());
        receiveDeliveryNoticeOrderEo.setOrderStatus(BaseOrderStatusEnum.DNO_CANCEL.getCode());
        this.receiveDeliveryNoticeOrderDomain.getMapper().update((Object)receiveDeliveryNoticeOrderEo, (Wrapper)csDeliveryNoticeOrderEoQueryWrapper);
    }

    private void inCancel(InOutNoticeOrderEo inOutNoticeOrderEo, CsBasicsCancelReqDto csBasicsCancelReqDto) {
        logger.info("inCancel==>\u5165\u5e93\u7684\u53d6\u6d88,InOutNoticeOrderEo:{},csBasicsCancelReqDto:{}", (Object)LogUtils.buildLogContent(inOutNoticeOrderEo), (Object)LogUtils.buildLogContent(csBasicsCancelReqDto));
        inOutNoticeOrderEo.setOrderStatus(BaseOrderStatusEnum.INO_CANCEL.getCode());
        QueryWrapper InOutNoticeOrderEoQueryWrapper = new QueryWrapper();
        InOutNoticeOrderEoQueryWrapper.eq((Object)"document_no", (Object)inOutNoticeOrderEo.getDocumentNo());
        this.inOutNoticeOrderDomain.getMapper().update((Object)inOutNoticeOrderEo, (Wrapper)InOutNoticeOrderEoQueryWrapper);
        QueryWrapper ReceiveDeliveryNoticeOrderEoQueryWrapper = new QueryWrapper();
        ReceiveDeliveryNoticeOrderEoQueryWrapper.eq((Object)"document_no", (Object)inOutNoticeOrderEo.getPreOrderNo());
        ReceiveDeliveryNoticeOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        ReceiveDeliveryNoticeOrderEoQueryWrapper.eq((Object)"order_type", (Object)"receive");
        ReceiveDeliveryNoticeOrderEo ReceiveDeliveryNoticeOrderEo2 = (ReceiveDeliveryNoticeOrderEo)this.receiveDeliveryNoticeOrderDomain.getMapper().selectOne((Wrapper)ReceiveDeliveryNoticeOrderEoQueryWrapper);
        AssertUtil.isTrue(null != ReceiveDeliveryNoticeOrderEo2, "\u67e5\u8be2\u4e0d\u5230\u6536\u8d27\u5e93\u901a\u77e5\u5355\u4fe1\u606f");
        ReceiveDeliveryNoticeOrderEoQueryWrapper.clear();
        ReceiveDeliveryNoticeOrderEoQueryWrapper.eq((Object)"document_no", (Object)ReceiveDeliveryNoticeOrderEo2.getDocumentNo());
        ReceiveDeliveryNoticeOrderEo2.setOrderStatus(BaseOrderStatusEnum.RNO_CANCEL.getCode());
        this.receiveDeliveryNoticeOrderDomain.getMapper().update((Object)ReceiveDeliveryNoticeOrderEo2, (Wrapper)ReceiveDeliveryNoticeOrderEoQueryWrapper);
    }

    private void checkParams(CsBasicsCancelReqDto csBasicsCancelReqDto) {
        AssertUtil.isTrue(null != csBasicsCancelReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String noticeOrderNo = csBasicsCancelReqDto.getNoticeOrderNo();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)noticeOrderNo), "\u51fa\u5165\u5e93\u901a\u77e5\u5355\u5355\u53f7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private String getDispatcherStatus(BigDecimal overchargeQuantity, BigDecimal receivelessQuantity) {
        if (overchargeQuantity.compareTo(BigDecimal.ZERO) != 0 && receivelessQuantity.compareTo(BigDecimal.ZERO) != 0) {
            return CsTransferDispatcherStatusEnum.DISPATCHER.getCode();
        }
        if (overchargeQuantity.compareTo(BigDecimal.ZERO) == 0 && receivelessQuantity.compareTo(BigDecimal.ZERO) == 0) {
            return CsTransferDispatcherStatusEnum.NO_DISPATCHER.getCode();
        }
        if (overchargeQuantity.compareTo(BigDecimal.ZERO) != 0) {
            return CsTransferDispatcherStatusEnum.MORE_DISPATCHER.getCode();
        }
        if (receivelessQuantity.compareTo(BigDecimal.ZERO) != 0) {
            return CsTransferDispatcherStatusEnum.LESS_DISPATCHER.getCode();
        }
        return null;
    }
}

