/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.receive.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.GenerateCodeUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.receive.IReceiveStrategyService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.IdUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.receive.ReceiveStrategyDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.receive.ReceiveStrategyChannelEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.receive.ReceiveStrategyEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.receive.ReceiveStrategyChannelMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.receive.ReceiveStrategyMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.vo.ReceiveStrategyPageRespVo;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.receive.ReceiveStrategyGenerateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.receive.ReceiveStrategyPageQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.receive.ReceiveStrategyParamQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.receive.ReceiveStrategyReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.receive.ReceiveStrategyDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.receive.ReceiveStrategyPageRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.receive.ReceiveStrategyRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsGenerateCodeStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ReceiveStrategyServiceImpl
implements IReceiveStrategyService {
    private static Logger logger = LoggerFactory.getLogger(ReceiveStrategyServiceImpl.class);
    @Resource
    private ReceiveStrategyDas receiveStrategyDas;
    @Autowired
    private ReceiveStrategyChannelMapper receiveStrategyChannelMapper;
    @Autowired
    private ReceiveStrategyMapper receiveStrategyMapper;

    @Override
    public Long addReceiveStrategy(ReceiveStrategyReqDto addReqDto) {
        ReceiveStrategyEo receiveStrategyEo = new ReceiveStrategyEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)receiveStrategyEo);
        this.receiveStrategyDas.insert((BaseEo)receiveStrategyEo);
        return receiveStrategyEo.getId();
    }

    @Override
    public void modifyReceiveStrategy(ReceiveStrategyReqDto modifyReqDto) {
        ReceiveStrategyEo receiveStrategyEo = new ReceiveStrategyEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)receiveStrategyEo);
        this.receiveStrategyDas.updateSelective((BaseEo)receiveStrategyEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeReceiveStrategy(String ids) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.receiveStrategyDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public ReceiveStrategyRespDto queryById(Long id) {
        ReceiveStrategyEo receiveStrategyEo = (ReceiveStrategyEo)this.receiveStrategyDas.selectByPrimaryKey(id);
        ReceiveStrategyRespDto receiveStrategyRespDto = new ReceiveStrategyRespDto();
        DtoHelper.eo2Dto((BaseEo)receiveStrategyEo, (BaseVo)receiveStrategyRespDto);
        return receiveStrategyRespDto;
    }

    @Override
    public PageInfo<ReceiveStrategyRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        ReceiveStrategyReqDto receiveStrategyReqDto = (ReceiveStrategyReqDto)JSON.parseObject((String)filter, ReceiveStrategyReqDto.class);
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List eoList = this.receiveStrategyDas.queryByPage(receiveStrategyReqDto);
        PageInfo eoPageInfo = new PageInfo(eoList);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ReceiveStrategyRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public void modifyReceiveStrategyStatus(String id, String type) {
        String status = "disable";
        if (type.equals("enable")) {
            status = "enable";
        }
        ReceiveStrategyReqDto modifyReqDto = new ReceiveStrategyReqDto();
        modifyReqDto.setId(Long.valueOf(id));
        modifyReqDto.setStrategyStatus(status);
        this.modifyReceiveStrategy(modifyReqDto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long generateReceiveStrategy(ReceiveStrategyGenerateReqDto receiveStrategyGenerateReqDto) {
        logger.info("generateReceiveStrategy==>\u65b0\u589e\u6536\u8d27\u7b56\u7565receiveStrategyGenerateReqDto:{}", (Object)LogUtils.buildLogContent(receiveStrategyGenerateReqDto));
        this.checkParams(receiveStrategyGenerateReqDto);
        String channelCode = receiveStrategyGenerateReqDto.getChannelCode();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        queryWrapper.eq((Object)"channel_code", (Object)channelCode);
        List receiveStrategyChannelEoList = this.receiveStrategyChannelMapper.selectList((Wrapper)queryWrapper);
        AssertUtil.isTrue(CollectionUtils.isEmpty((Collection)receiveStrategyChannelEoList), String.format("\u3010%s\u3011\u6e20\u9053\u5df2\u8bbe\u7f6e\u786e\u8ba4\u6536\u8d27\u7b56\u7565", receiveStrategyGenerateReqDto.getChannelName()));
        Long id = IdUtils.getId();
        String strategyCode = receiveStrategyGenerateReqDto.getStrategyCode();
        if (StringUtils.isBlank((CharSequence)strategyCode)) {
            strategyCode = GenerateCodeUtils.getStrategy(CsGenerateCodeStrategyEnum.RECEIVE_STRATEGY.getCode()).getCode();
        }
        ReceiveStrategyEo receiveStrategyEo = new ReceiveStrategyEo();
        receiveStrategyEo.setId(id);
        receiveStrategyEo.setStrategyCode(strategyCode);
        receiveStrategyEo.setStrategyName(strategyCode);
        receiveStrategyEo.setStrategyStatus(CsValidFlagEnum.ENABLE.getCode());
        receiveStrategyEo.setStartTime(new Date());
        receiveStrategyEo.setEndTime(new Date());
        receiveStrategyEo.setPriority(Integer.valueOf(1));
        receiveStrategyEo.setStrategyDay(receiveStrategyGenerateReqDto.getStrategyDay());
        this.receiveStrategyMapper.insert((Object)receiveStrategyEo);
        ReceiveStrategyChannelEo receiveStrategyChannelEo = new ReceiveStrategyChannelEo();
        receiveStrategyChannelEo.setStrategyCode(strategyCode);
        receiveStrategyChannelEo.setStrategyName(strategyCode);
        receiveStrategyChannelEo.setChannelCode(channelCode);
        receiveStrategyChannelEo.setChannelName(receiveStrategyGenerateReqDto.getChannelName());
        this.receiveStrategyChannelMapper.insert((Object)receiveStrategyChannelEo);
        return id;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean editReceiveStrategy(ReceiveStrategyGenerateReqDto receiveStrategyGenerateReqDto) {
        logger.info("editReceiveStrategy==>\u7f16\u8f91\u6536\u8d27\u7b56\u7565,receiveStrategyGenerateReqDto:{}", (Object)LogUtils.buildLogContent(receiveStrategyGenerateReqDto));
        AssertUtil.isTrue(null != receiveStrategyGenerateReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String strategyCode = receiveStrategyGenerateReqDto.getStrategyCode();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)strategyCode), "\u7b56\u7565\u7f16\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        this.logicDeleteInfo(strategyCode);
        this.generateReceiveStrategy(receiveStrategyGenerateReqDto);
        return true;
    }

    private void logicDeleteInfo(String strategyCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        queryWrapper.eq((Object)"strategy_code", (Object)strategyCode);
        List receiveStrategyEoList = this.receiveStrategyMapper.selectList((Wrapper)queryWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)receiveStrategyEoList), "\u6536\u8d27\u7b56\u7565\u4fe1\u606f\u4e0d\u5b58\u5728");
        QueryWrapper receiveStrategyChannelEoQueryWrapper = new QueryWrapper();
        receiveStrategyChannelEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        receiveStrategyChannelEoQueryWrapper.eq((Object)"strategy_code", (Object)strategyCode);
        List receiveStrategyChannelEoList = this.receiveStrategyChannelMapper.selectList((Wrapper)receiveStrategyChannelEoQueryWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)receiveStrategyChannelEoList), "\u6536\u8d27\u7b56\u7565\u6e20\u9053\u4fe1\u606f\u4e0d\u5b58\u5728");
        ReceiveStrategyEo receiveStrategyEo = (ReceiveStrategyEo)receiveStrategyEoList.get(0);
        receiveStrategyEo.setDr(YesNoEnum.YES.getValue());
        receiveStrategyEo.setStrategyStatus(CsValidFlagEnum.DISABLE.getCode());
        queryWrapper.clear();
        queryWrapper.eq((Object)"id", (Object)receiveStrategyEo.getId());
        this.receiveStrategyMapper.update((Object)receiveStrategyEo, (Wrapper)queryWrapper);
        for (ReceiveStrategyChannelEo receiveStrategyChannelEo : receiveStrategyChannelEoList) {
            receiveStrategyChannelEoQueryWrapper.clear();
            receiveStrategyChannelEoQueryWrapper.eq((Object)"id", (Object)receiveStrategyChannelEo.getId());
            receiveStrategyChannelEo.setDr(YesNoEnum.YES.getValue());
            this.receiveStrategyChannelMapper.update((Object)receiveStrategyChannelEo, (Wrapper)receiveStrategyChannelEoQueryWrapper);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean deleteReceiveStrategy(String strategyCode) {
        logger.info("deleteReceiveStrategy==>\u6839\u636e\u6536\u8d27\u7b56\u7565\u7f16\u7801\u5220\u9664,strategyCode:{}", (Object)strategyCode);
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)strategyCode), "\u6536\u8d27\u7b56\u7565\u7f16\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        this.logicDeleteInfo(strategyCode);
        return true;
    }

    @Override
    public ReceiveStrategyDetailRespDto queryReceiveStrategyDetail(String strategyCode) {
        logger.info("queryReceiveStrategyDetail==>\u6839\u636e\u6536\u8d27\u7b56\u7565\u7f16\u7801\u67e5\u8be2\u6536\u8d27\u7b56\u7565\u8be6\u60c5,strategyCode:{}", (Object)LogUtils.buildLogContent(strategyCode));
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)strategyCode), "\u6536\u8d27\u7b56\u7565\u7f16\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        queryWrapper.eq((Object)"strategy_code", (Object)strategyCode);
        List receiveStrategyEoList = this.receiveStrategyMapper.selectList((Wrapper)queryWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)receiveStrategyEoList), "\u6536\u8d27\u7b56\u7565\u4fe1\u606f\u4e0d\u5b58\u5728");
        QueryWrapper receiveStrategyChannelEoQueryWrapper = new QueryWrapper();
        receiveStrategyChannelEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        receiveStrategyChannelEoQueryWrapper.eq((Object)"strategy_code", (Object)strategyCode);
        List receiveStrategyChannelEoList = this.receiveStrategyChannelMapper.selectList((Wrapper)receiveStrategyChannelEoQueryWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)receiveStrategyChannelEoList), "\u6536\u8d27\u7b56\u7565\u6e20\u9053\u4fe1\u606f\u4e0d\u5b58\u5728");
        ReceiveStrategyDetailRespDto respDto = new ReceiveStrategyDetailRespDto();
        ReceiveStrategyEo receiveStrategyEo = (ReceiveStrategyEo)receiveStrategyEoList.get(0);
        ReceiveStrategyChannelEo receiveStrategyChannelEo = (ReceiveStrategyChannelEo)receiveStrategyChannelEoList.get(0);
        respDto.setId(receiveStrategyEo.getId());
        respDto.setCreatePerson(receiveStrategyEo.getCreatePerson());
        respDto.setCreateTime(receiveStrategyEo.getCreateTime());
        respDto.setUpdatePerson(receiveStrategyEo.getUpdatePerson());
        respDto.setUpdateTime(receiveStrategyEo.getUpdateTime());
        respDto.setStrategyCode(receiveStrategyEo.getStrategyCode());
        respDto.setStrategyName(receiveStrategyEo.getStrategyName());
        respDto.setStrategyDay(receiveStrategyEo.getStrategyDay());
        respDto.setChannelCode(receiveStrategyChannelEo.getChannelCode());
        respDto.setChannelName(receiveStrategyChannelEo.getChannelName());
        logger.info("queryReceiveStrategyDetail==>\u6839\u636e\u6536\u8d27\u7b56\u7565\u7f16\u7801\u67e5\u8be2\u6536\u8d27\u7b56\u7565\u8be6\u60c5,\u54cd\u5e94respDto:{}", (Object)LogUtils.buildLogContent(strategyCode));
        return respDto;
    }

    @Override
    public PageInfo<ReceiveStrategyPageRespDto> queryPage(ReceiveStrategyPageQueryReqDto relWarehouseShipmentPageQueryDto) {
        logger.info("queryPage==>\u6536\u8d27\u7b56\u7565\u5206\u9875\u67e5\u8be2,relWarehouseShipmentPageQueryDto:{}", (Object)LogUtils.buildLogContent(relWarehouseShipmentPageQueryDto));
        AssertUtil.isTrue(null != relWarehouseShipmentPageQueryDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(null != relWarehouseShipmentPageQueryDto.getPageNum() && relWarehouseShipmentPageQueryDto.getPageNum() > 0, "\u5206\u9875\u9875\u7801\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(null != relWarehouseShipmentPageQueryDto.getPageSize() && relWarehouseShipmentPageQueryDto.getPageSize() > 0, "\u5206\u9875\u5927\u5c0f\u53c2\u6570\u6709\u8bef");
        List channelCodeList = relWarehouseShipmentPageQueryDto.getChannelCodeList();
        if (CollectionUtils.isEmpty((Collection)channelCodeList)) {
            relWarehouseShipmentPageQueryDto.setChannelCodeList(null);
        }
        PageHelper.startPage((int)relWarehouseShipmentPageQueryDto.getPageNum(), (int)relWarehouseShipmentPageQueryDto.getPageSize());
        List resultList = this.receiveStrategyMapper.queryByPageInfo(relWarehouseShipmentPageQueryDto);
        if (CollectionUtils.isEmpty((Collection)resultList)) {
            return new PageInfo();
        }
        PageInfo selectPage = new PageInfo(resultList);
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)selectPage, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList receiveStrategyPageRespDtoList = Lists.newArrayList();
        for (ReceiveStrategyPageRespVo receiveStrategyPageRespVo : resultList) {
            ReceiveStrategyPageRespDto relWarehouseShipmentPageRespDto = new ReceiveStrategyPageRespDto();
            CubeBeanUtils.copyProperties((Object)relWarehouseShipmentPageRespDto, (Object)receiveStrategyPageRespVo, (String[])new String[0]);
            receiveStrategyPageRespDtoList.add(relWarehouseShipmentPageRespDto);
        }
        pageInfo.setList((List)receiveStrategyPageRespDtoList);
        return pageInfo;
    }

    @Override
    public List<ReceiveStrategyPageRespDto> queryParam(ReceiveStrategyParamQueryReqDto receiveStrategyParamQueryReqDto) {
        logger.info("queryParam==>\u591a\u6761\u4ef6\u67e5\u8be2,receiveStrategyParamQueryReqDto:{}", (Object)LogUtils.buildLogContent(receiveStrategyParamQueryReqDto));
        if (null == receiveStrategyParamQueryReqDto) {
            return Lists.newArrayList();
        }
        QueryWrapper receiveStrategyChannelEoQueryWrapper = new QueryWrapper();
        receiveStrategyChannelEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        if (CollectionUtils.isNotEmpty((Collection)receiveStrategyParamQueryReqDto.getChannelCodeList())) {
            receiveStrategyChannelEoQueryWrapper.in((Object)"channel_code", (Collection)receiveStrategyParamQueryReqDto.getChannelCodeList());
        }
        if (CollectionUtils.isNotEmpty((Collection)receiveStrategyParamQueryReqDto.getStrategyCodeList())) {
            receiveStrategyChannelEoQueryWrapper.in((Object)"strategy_code", (Collection)receiveStrategyParamQueryReqDto.getStrategyCodeList());
        }
        List receiveStrategyChannelEoList = this.receiveStrategyChannelMapper.selectList((Wrapper)receiveStrategyChannelEoQueryWrapper);
        logger.info("queryParam==>\u591a\u6761\u4ef6\u67e5\u8be2,receiveStrategyChannelEoList:{}", (Object)LogUtils.buildLogContent(receiveStrategyChannelEoList));
        if (CollectionUtils.isEmpty((Collection)receiveStrategyChannelEoList)) {
            return Lists.newArrayList();
        }
        Map strategyChannelEoMap = receiveStrategyChannelEoList.stream().collect(Collectors.toMap(eo -> eo.getStrategyCode(), Function.identity()));
        List strategyCodeList = receiveStrategyChannelEoList.stream().map(ReceiveStrategyChannelEo::getStrategyCode).collect(Collectors.toList());
        QueryWrapper receiveStrategyEoQueryWrapper = new QueryWrapper();
        receiveStrategyEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        receiveStrategyEoQueryWrapper.in((Object)"strategy_code", strategyCodeList);
        receiveStrategyEoQueryWrapper.in((Object)"strategy_status", new Object[]{CsValidFlagEnum.ENABLE.getCode()});
        List receiveStrategyEoList = this.receiveStrategyMapper.selectList((Wrapper)receiveStrategyEoQueryWrapper);
        logger.info("queryParam==>\u591a\u6761\u4ef6\u67e5\u8be2,receiveStrategyEoList:{}", (Object)LogUtils.buildLogContent(receiveStrategyEoList));
        if (CollectionUtils.isEmpty((Collection)receiveStrategyEoList)) {
            return Lists.newArrayList();
        }
        ArrayList resultList = Lists.newArrayList();
        for (ReceiveStrategyEo receiveStrategyEo : receiveStrategyEoList) {
            String strategyCode = receiveStrategyEo.getStrategyCode();
            ReceiveStrategyChannelEo receiveStrategyChannelEo = (ReceiveStrategyChannelEo)strategyChannelEoMap.get(strategyCode);
            if (null == receiveStrategyChannelEo) continue;
            ReceiveStrategyPageRespDto respDto = new ReceiveStrategyPageRespDto();
            respDto.setStrategyCode(receiveStrategyEo.getStrategyCode());
            respDto.setStrategyName(receiveStrategyEo.getStrategyName());
            respDto.setStrategyDay(receiveStrategyEo.getStrategyDay());
            respDto.setChannelCode(receiveStrategyChannelEo.getChannelCode());
            respDto.setChannelName(receiveStrategyChannelEo.getChannelName());
            resultList.add(respDto);
        }
        logger.info("queryParam==>\u591a\u6761\u4ef6\u67e5\u8be2,resultList:{}", (Object)LogUtils.buildLogContent(resultList));
        return resultList;
    }

    private void checkParams(ReceiveStrategyGenerateReqDto receiveStrategyGenerateReqDto) {
        AssertUtil.isTrue(null != receiveStrategyGenerateReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String channelCode = receiveStrategyGenerateReqDto.getChannelCode();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)channelCode), "\u6e20\u9053\u7f16\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String channelName = receiveStrategyGenerateReqDto.getChannelName();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)channelName), "\u6e20\u9053\u540d\u79f0\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Integer strategyDay = receiveStrategyGenerateReqDto.getStrategyDay();
        AssertUtil.isTrue(null != strategyDay && strategyDay >= 0 && strategyDay <= 99, "\u8bbe\u7f6e\u5929\u6570\u53c2\u6570\u6709\u8bef");
    }
}

