/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.biz.dto.request.CsBasisOrderBusinessDataReqDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.INoticeWmsStatusService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsBaseOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsOutNoticeOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.QueryInTransitQualifiedNoticeReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsOutNoticeOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.OutNoticeOrderDetailRespVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.domain.ContactDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsBasisOrderBusinessDataRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsInNoticeOrderDetailQueryDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsInNoticeOrderDetailRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsOutNoticeOrderDetailRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsOutNoticeOrderQueryDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsOutResultOrderRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsWmsShippingInfoReqDto;
import com.yunxi.dg.base.center.inventory.dto.domain.OutNoticeOrderDetailVo;
import com.yunxi.dg.base.center.inventory.dto.domain.QueryInTransitQualifiedNoticeDetailVo;
import com.yunxi.dg.base.center.inventory.dto.domain.QueryInTransitQualifiedNoticeVo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="csOutNoticeOrderQueryService")
public class CsOutNoticeOrderQueryServiceImpl
implements ICsOutNoticeOrderQueryService {
    private static final Logger log = LoggerFactory.getLogger(CsOutNoticeOrderQueryServiceImpl.class);
    @Autowired
    IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Autowired
    IInOutNoticeOrderDetailDomain inOutNoticeOrderDetailDomain;
    @Autowired
    IInOutResultOrderDomain inOutResultOrderDomain;
    @Autowired
    IInOutResultOrderDetailDomain inOutResultOrderDetailDomain;
    @Resource
    ICsBaseOrderQueryService csBaseOrderQueryService;
    @Resource
    private INoticeWmsStatusService noticeWmsStatusService;

    @Override
    public InOutNoticeOrderEo selectByPrimaryKey(Long id) {
        log.info("\u6839\u636eid\u67e5\u8be2\u4fe1\u606f\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        return Optional.ofNullable(this.inOutNoticeOrderDomain.selectByPrimaryKey(id)).map(inOutNoticeOrderEo -> (InOutNoticeOrderEo)BeanUtil.copyProperties((Object)inOutNoticeOrderEo, InOutNoticeOrderEo.class, (String[])new String[0])).orElse(null);
    }

    @Override
    public CsOutNoticeOrderRespDto queryByPrimaryKey(Long id) {
        log.info("\u6839\u636eid\u67e5\u8be2\u4fe1\u606f\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        InOutNoticeOrderEo eo = this.selectByPrimaryKey(id);
        AssertUtil.isTrue(eo != null, "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        log.info("eo\u54cd\u5e94=>{}", (Object)JSON.toJSONString((Object)eo));
        CsOutNoticeOrderRespDto dto = new CsOutNoticeOrderRespDto();
        DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)dto);
        log.info("dto\u54cd\u5e94=>{}", (Object)JSON.toJSONString((Object)dto));
        String documentNo = eo.getDocumentNo();
        InOutResultOrderEo InOutResultOrderEoQuery = new InOutResultOrderEo();
        InOutResultOrderEoQuery.setRelevanceNo(documentNo);
        List csOutResultOrderList = this.inOutResultOrderDomain.selectList((BaseEo)InOutResultOrderEoQuery);
        if (CollectionUtils.isNotEmpty((Collection)csOutResultOrderList)) {
            ArrayList csDeliveryResultOrderRespDtos = Lists.newArrayList();
            DtoHelper.eoList2DtoList((Collection)csOutResultOrderList, (Collection)csDeliveryResultOrderRespDtos, CsOutResultOrderRespDto.class);
            dto.setCsOutResultOrderRespDtos((List)csDeliveryResultOrderRespDtos);
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getExtension())) {
            try {
                ContactDto contactDto = (ContactDto)JSON.parseObject((String)dto.getExtension(), ContactDto.class);
                dto.setContactDto(contactDto);
            }
            catch (Exception ex) {
                log.info("\u6355\u83b7\u5f02\u5e38\uff0c\u903b\u8f91\u4e0d\u5904\u7406\uff1a\u524d\u7f6e\u5355\u636e\u6536\u8d27\u4fe1\u606f\u9519\u8bef");
            }
        }
        return dto;
    }

    @Override
    public PageInfo<CsOutNoticeOrderRespDto> queryPage(CsOutNoticeOrderQueryDto queryDto) {
        return null;
    }

    @Override
    public CsOutNoticeOrderRespDto queryByDocumentNo(String documentNo) {
        return this.queryByDocumentNo(documentNo, null);
    }

    @Override
    public CsOutNoticeOrderRespDto queryByDocumentNo(String documentNo, String orderType) {
        String shippingJson;
        QueryWrapper outNoticeOrderQueryWrapper = new QueryWrapper();
        outNoticeOrderQueryWrapper.eq((Object)"document_no", (Object)documentNo);
        outNoticeOrderQueryWrapper.eq((Object)"dr", (Object)0);
        List list = this.inOutNoticeOrderDomain.getMapper().selectList((Wrapper)outNoticeOrderQueryWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)list), "\u67e5\u8be2\u4e0d\u5230\u8be5\u5355\u53f7");
        InOutNoticeOrderEo eo = (InOutNoticeOrderEo)list.get(0);
        AssertUtil.isTrue(eo != null, "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        log.info("eo\u54cd\u5e94=>{}", (Object)JSON.toJSONString((Object)eo));
        CsOutNoticeOrderRespDto dto = new CsOutNoticeOrderRespDto();
        DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)dto);
        dto.setWarehouseCode(eo.getOutPhysicsWarehouseCode());
        dto.setWarehouseName(eo.getOutPhysicsWarehouseName());
        dto.setInWarehouseCode(eo.getInLogicWarehouseCode());
        dto.setInWarehouseName(eo.getInLogicWarehouseName());
        log.info("dto\u54cd\u5e94=>{}", (Object)JSON.toJSONString((Object)dto));
        CsBasisOrderBusinessDataReqDto dataReqDto = new CsBasisOrderBusinessDataReqDto();
        CubeBeanUtils.copyProperties((Object)dataReqDto, (Object)dto, (String[])new String[0]);
        dataReqDto.setShippingJson(dto.getShippingJson());
        CsBasisOrderBusinessDataRespDto dataRespDto = this.csBaseOrderQueryService.outInNoticeBuildRelOrderInfo(dataReqDto, "delivery", "out");
        if (Objects.nonNull(dataRespDto)) {
            dto.setContactDto(dataRespDto.getContactDto());
            dto.setRelOrderInfoList(dataRespDto.getRelOrderInfoList());
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(shippingJson = dto.getShippingJson()))) {
            try {
                List csWmsShippingInfoReqDtoList = JSON.parseArray((String)shippingJson, CsWmsShippingInfoReqDto.class);
                log.info("queryVersionSecondByDocumentNo==>\u5355\u53f7:{},\u7269\u6d41\u4fe1\u606f\u96c6\u5408,csWmsShippingInfoReqDtoList:{}", (Object)dto.getDocumentNo(), (Object)LogUtils.buildLogContent(csWmsShippingInfoReqDtoList));
                dto.setShippingInfoList(csWmsShippingInfoReqDtoList);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        log.info("dto\u54cd\u5e94=>{}", (Object)JSON.toJSONString((Object)dto));
        BigDecimal skuNum = this.csBaseOrderQueryService.queryItemMapByOutInNoticeDocumentNo(dto.getDocumentNo());
        dto.setSkuNum(skuNum);
        dto.setWmsStatus(this.noticeWmsStatusService.getNewWmsStatusByDocumentNo(dto.getDocumentNo()));
        return dto;
    }

    @Override
    public PageInfo<CsOutNoticeOrderDetailRespDto> queryDetailPage(CsOutNoticeOrderQueryDto queryDto) {
        log.info("\u5206\u9875\u67e5\u8be2\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(queryDto, "pageNum", "pageSize"));
        AssertUtil.emptyValidated(queryDto, "pageNum", "pageSize");
        if (StringUtil.isNotBlank((String)queryDto.getIdentification()) && queryDto.getIdentification().equals("identification")) {
            CsInNoticeOrderDetailQueryDto detailQueryDto = new CsInNoticeOrderDetailQueryDto();
            BeanUtil.copyProperties((Object)queryDto, (Object)detailQueryDto, (String[])new String[0]);
            PageHelper.startPage((int)queryDto.getPageNum(), (int)queryDto.getPageSize());
            List dtoList = this.inOutNoticeOrderDetailDomain.queryByPage(detailQueryDto);
            ArrayList respDtoList = Lists.newArrayList();
            for (CsInNoticeOrderDetailRespDto dto : dtoList) {
                CsOutNoticeOrderDetailRespDto respDto = new CsOutNoticeOrderDetailRespDto();
                BeanUtil.copyProperties((Object)dto, (Object)respDto, (String[])new String[0]);
                respDto.setLongCode(dto.getCargoCode());
                respDto.setSkuCode(dto.getCargoCode());
                respDto.setCargoName(dto.getCargoName());
                respDtoList.add(respDto);
            }
            return new PageInfo((List)respDtoList);
        }
        InOutNoticeOrderDetailEo eo = new InOutNoticeOrderDetailEo();
        DtoHelper.dto2Eo((BaseVo)queryDto, (BaseEo)eo);
        PageInfo csDeliveryNoticeOrderDetailEoPageInfo = this.inOutNoticeOrderDetailDomain.selectPage((BaseEo)eo, queryDto.getPageNum(), queryDto.getPageSize());
        if (CollectionUtils.isEmpty((Collection)csDeliveryNoticeOrderDetailEoPageInfo.getList())) {
            return new PageInfo();
        }
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)csDeliveryNoticeOrderDetailEoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList list = Lists.newArrayList();
        for (InOutNoticeOrderDetailEo detailEo : csDeliveryNoticeOrderDetailEoPageInfo.getList()) {
            CsOutNoticeOrderDetailRespDto respDto = new CsOutNoticeOrderDetailRespDto();
            BeanUtil.copyProperties((Object)detailEo, (Object)respDto, (String[])new String[0]);
            respDto.setLongCode(detailEo.getSkuCode());
            respDto.setCargoCode(detailEo.getSkuCode());
            respDto.setCargoName(detailEo.getSkuName());
            list.add(respDto);
        }
        pageInfo.setList((List)list);
        return pageInfo;
    }

    @Override
    public PageInfo<OutNoticeOrderDetailRespVo> queryInTransitQualifiedNotice(QueryInTransitQualifiedNoticeReqDto reqDto) {
        QueryInTransitQualifiedNoticeVo queryInTransitQualifiedNoticeVo = (QueryInTransitQualifiedNoticeVo)BeanUtil.copyProperties((Object)reqDto, QueryInTransitQualifiedNoticeVo.class, (String[])new String[0]);
        ArrayList detailVoArrayList = new ArrayList();
        CubeBeanUtils.copyCollection(detailVoArrayList, (Collection)queryInTransitQualifiedNoticeVo.getQueryDetails(), QueryInTransitQualifiedNoticeDetailVo.class);
        queryInTransitQualifiedNoticeVo.setQueryDetails(detailVoArrayList);
        PageInfo outNoticeOrderDetailRespVoPageInfo = this.inOutNoticeOrderDomain.queryInTransitQualifiedNotice(queryInTransitQualifiedNoticeVo, reqDto.getPageNum(), reqDto.getPageSize());
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)outNoticeOrderDetailRespVoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)outNoticeOrderDetailRespVoPageInfo.getList(), OutNoticeOrderDetailRespVo.class);
        pageInfo.setList((List)list);
        return pageInfo;
    }

    @Override
    public List<CsOutNoticeOrderRespDto> queryByRelevanceNoList(List<String> relevanceNoList) {
        log.info("queryByRelevanceNoList==>\u6279\u91cf\u6839\u636e\u5173\u8054\u5355\u53f7\u67e5\u8be2\u51fa\u5165\u5e93\u901a\u77e5\u5355\u4e3b\u4f53\u4fe1\u606f,relevanceNoList:{}", (Object)LogUtils.buildLogContent(relevanceNoList));
        AssertUtil.isTrue(CollectionUtils.isNotEmpty(relevanceNoList), "\u5173\u8054\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"relevance_no", relevanceNoList);
        queryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        queryWrapper.ne((Object)"order_status", (Object)BaseOrderStatusEnum.ONO_CANCEL.getCode());
        queryWrapper.orderByDesc((Object)"create_time");
        List InOutNoticeOrderEos = this.inOutNoticeOrderDomain.getMapper().selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)InOutNoticeOrderEos)) {
            return null;
        }
        ArrayList<CsOutNoticeOrderRespDto> list = new ArrayList<CsOutNoticeOrderRespDto>();
        CubeBeanUtils.copyCollection(list, (Collection)InOutNoticeOrderEos, CsOutNoticeOrderRespDto.class);
        return list;
    }

    @Override
    public List<CsOutNoticeOrderRespDto> queryByParam(CsOutNoticeOrderQueryDto queryDto) {
        if (StringUtils.isBlank((CharSequence)queryDto.getDocumentNo()) && StringUtils.isBlank((CharSequence)queryDto.getRelevanceNo()) && StringUtils.isBlank((CharSequence)queryDto.getPreOrderNo())) {
            throw new BizException("\u7f3a\u5c11\u5fc5\u8981\u67e5\u8be2\u53c2\u6570");
        }
        List inOutNoticeOrderEos = this.inOutNoticeOrderDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InOutNoticeOrderEo.class).eq(StringUtils.isNotBlank((CharSequence)queryDto.getDocumentNo()), InOutNoticeOrderEo::getDocumentNo, (Object)queryDto.getDocumentNo())).eq(StringUtils.isNotBlank((CharSequence)queryDto.getPreOrderNo()), InOutNoticeOrderEo::getPreOrderNo, (Object)queryDto.getPreOrderNo())).eq(StringUtils.isNotBlank((CharSequence)queryDto.getRelevanceNo()), InOutNoticeOrderEo::getRelevanceNo, (Object)queryDto.getRelevanceNo())).eq(StringUtils.isNotBlank((CharSequence)queryDto.getOrderType()), InOutNoticeOrderEo::getOrderType, (Object)queryDto.getOrderType())).eq(StringUtils.isNotBlank((CharSequence)queryDto.getBusinessType()), InOutNoticeOrderEo::getBusinessType, (Object)queryDto.getBusinessType())).eq(StringUtils.isNotBlank((CharSequence)queryDto.getOrderStatus()), InOutNoticeOrderEo::getOrderStatus, (Object)queryDto.getOrderStatus())).orderByDesc(BaseEo::getCreateTime));
        if (CollectionUtils.isEmpty((Collection)inOutNoticeOrderEos)) {
            return Lists.newArrayList();
        }
        ArrayList respDtoList = Lists.newArrayList();
        for (InOutNoticeOrderEo inOutNoticeOrderEo : inOutNoticeOrderEos) {
            CsOutNoticeOrderRespDto respDto = new CsOutNoticeOrderRespDto();
            BeanUtils.copyProperties((Object)inOutNoticeOrderEo, (Object)respDto);
            respDtoList.add(respDto);
        }
        return respDtoList;
    }

    @Override
    public PageInfo<CsInNoticeOrderDetailRespDto> queryDetailByPage(CsInNoticeOrderDetailQueryDto queryDto) {
        if (StringUtil.isNotBlank((String)queryDto.getIdentification()) && queryDto.getIdentification().equals("identification")) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"document_no", (Object)queryDto.getDocumentNo());
            queryWrapper.eq((Object)"dr", (Object)0);
            PageHelper.startPage((int)queryDto.getPageNum(), (int)queryDto.getPageSize());
            List eos = this.inOutNoticeOrderDetailDomain.getMapper().selectList((Wrapper)queryWrapper);
            if (CollectionUtils.isEmpty((Collection)eos)) {
                return new PageInfo();
            }
            PageInfo csOutResultOrderDetailEoPageInfo = new PageInfo(eos);
            PageInfo pageInfo = new PageInfo();
            CubeBeanUtils.copyProperties((Object)pageInfo, (Object)csOutResultOrderDetailEoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
            ArrayList list = Lists.newArrayList();
            for (InOutNoticeOrderDetailEo detailEo : csOutResultOrderDetailEoPageInfo.getList()) {
                CsInNoticeOrderDetailRespDto respDto = new CsInNoticeOrderDetailRespDto();
                BeanUtils.copyProperties((Object)detailEo, (Object)respDto);
                respDto.setCargoName(detailEo.getSkuName());
                respDto.setProduceTime(DateUtil.formatDateTime((Date)detailEo.getProduceTime()));
                respDto.setExpireTime(DateUtil.formatDateTime((Date)detailEo.getExpireTime()));
                list.add(respDto);
            }
            pageInfo.setList((List)list);
            return pageInfo;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"document_no", (Object)queryDto.getDocumentNo());
        queryWrapper.eq((Object)"dr", (Object)0);
        PageHelper.startPage((int)queryDto.getPageNum(), (int)queryDto.getPageSize());
        List eos = this.inOutNoticeOrderDetailDomain.getMapper().selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)eos)) {
            return new PageInfo();
        }
        PageInfo csOutResultOrderDetailEoPageInfo = new PageInfo(eos);
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)csOutResultOrderDetailEoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)csOutResultOrderDetailEoPageInfo.getList(), CsInNoticeOrderDetailRespDto.class);
        pageInfo.setList((List)list);
        return pageInfo;
    }

    @Override
    public List<OutNoticeOrderDetailRespVo> queryTransferInNoticeDetails(String longCode, String batch) {
        List outNoticeOrderDetailVos = this.inOutNoticeOrderDomain.queryTransferInNoticeDetails(longCode, batch);
        if (CollectionUtils.isEmpty((Collection)outNoticeOrderDetailVos)) {
            return Lists.newArrayList();
        }
        ArrayList respVoList = Lists.newArrayList();
        for (OutNoticeOrderDetailVo outNoticeOrderDetailVo : outNoticeOrderDetailVos) {
            OutNoticeOrderDetailRespVo respVo = new OutNoticeOrderDetailRespVo();
            BeanUtils.copyProperties((Object)outNoticeOrderDetailVo, (Object)respVo);
            respVoList.add(respVo);
        }
        return respVoList;
    }
}

