/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.adapter;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.IAdjustmentInventoryApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.mq.MqService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.commons.CsCommonService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.GenerateCodeUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsDeliveryNoticeOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsOutNoticeOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.inventory.IAdjustmentInventoryAuditService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.inventory.IAdjustmentInventoryDetailService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.inventory.IAdjustmentInventoryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.inventory.AdjustmentInventoryDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.AdjustmentInventoryEo;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.AdjustmentInventoryAuditReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.AdjustmentInventoryDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.AdjustmentInventoryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.AdjustmentInventoryAuditRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.AdjustmentInventoryDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.AdjustmentInventoryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.adjustmentInventoryStatusCountRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.message.CsInventoryAutoAuditMessageReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryNoticeOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsOutNoticeOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsAdjustmentChangeTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsAdjustmentOrderTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsBatchAdjustmentOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsGenerateCodeStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.bd.BdTypeOfDocumentEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.bd.PcpBasicInventoryBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.exception.CsInventoryException;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.enums.CsWarehouseClassifyEnum;
import com.yunxi.dg.base.center.enums.ProjectEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.dto.calc.PreemptDto;
import com.yunxi.dg.base.center.inventory.dto.calc.ReleasePreemptDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDetailDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsDeliveryNoticeOrderQueryDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsOutNoticeOrderQueryDto;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.proxy.data.IPcpDictApiProxy;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderCallBack;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderFacade;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderBaseContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.ReceiveDeliveryNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.ReceiveDeliveryNoticeOrderFacadeBo;
import com.yunxi.dg.base.center.inventory.service.calc.ICalcInventoryService;
import com.yunxi.dg.base.center.inventory.transcation.TransactionAfterService;
import com.yunxi.dg.base.center.inventory.transcation.TransactionCallBackService;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public abstract class AdjustmentInventoryApiImpl
implements IAdjustmentInventoryApi {
    private static final Logger log = LoggerFactory.getLogger(AdjustmentInventoryApiImpl.class);
    @Autowired
    protected IAdjustmentInventoryService adjustmentInventoryService;
    @Autowired
    protected IAdjustmentInventoryDetailService detailService;
    @Autowired
    protected IAdjustmentInventoryAuditService adjustmentInventoryAuditService;
    @Autowired
    protected ICalcInventoryService calcInventoryService;
    @Autowired
    protected AdjustmentInventoryDas adjustmentInventoryDas;
    @Autowired
    protected ICsDeliveryNoticeOrderQueryService csDeliveryNoticeOrderQueryService;
    @Autowired
    protected ICsOutNoticeOrderQueryService csOutNoticeOrderQueryService;
    @Resource
    protected MqService mqService;
    @Autowired
    protected CsCommonService csCommonService;
    @Autowired
    protected ILockService lockService;
    @Resource
    private IPcpDictApiProxy dataDictProxy;
    @Autowired
    protected TransactionAfterService transactionAfterService;
    @Autowired
    protected TransactionCallBackService transactionCallBackService;
    @Autowired
    protected BaseOrderFacade baseOrderFacade;
    @Resource
    private ICommonsMqService commonsMqService;

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Long> addAdjustmentInventory(AdjustmentInventoryReqDto addReqDto) {
        log.info("\u65b0\u589e\u5e93\u5b58\u8c03\u6574\u5355:{}", (Object)JSON.toJSONString((Object)addReqDto));
        this.csCommonService.getSetUserName();
        this.checkParam(addReqDto);
        String adjustmentNo = addReqDto.getAdjustmentNo();
        if (StringUtils.isEmpty((CharSequence)adjustmentNo)) {
            String generateCodeStrategy = CsGenerateCodeStrategyEnum.ADJUSTMENT_INVENTORY_ORDER.getCode();
            if (CsPcpBusinessTypeEnum.IN_TRANSIT_ADJUSTMENT.getCode().equals(addReqDto.getAdjustmentType())) {
                generateCodeStrategy = CsGenerateCodeStrategyEnum.IN_TRANSIT_ADJUSTMENT_INVENTORY_ORDER.getCode();
            }
            adjustmentNo = GenerateCodeUtils.getStrategy(generateCodeStrategy).getCode();
        }
        addReqDto.setAdjustmentNo(adjustmentNo);
        this.preemptInventory(addReqDto);
        addReqDto.setAdjustmentStatus("wait_audit");
        Long id = this.adjustmentInventoryService.addAdjustmentInventory(addReqDto);
        log.info("\u65b0\u589e\u8c03\u6574\u5355id:{}", (Object)JSON.toJSONString((Object)id));
        List detailReqDtoList = addReqDto.getDetailReqDtoList();
        for (AdjustmentInventoryDetailReqDto detail : detailReqDtoList) {
            detail.setAdjustmentNo(adjustmentNo);
            detail.setAdjustmentId(id);
        }
        log.info("\u6279\u91cf\u65b0\u589e\u5546\u54c1\u8be6\u60c5:{}", (Object)JSON.toJSONString((Object)detailReqDtoList));
        this.detailService.batchAddAdjustmentInventoryDetail(detailReqDtoList);
        if (addReqDto.getAutoAuditPass().booleanValue()) {
            AdjustmentInventoryAuditRespDto auditRespDto = new AdjustmentInventoryAuditRespDto();
            auditRespDto.setAdjustmentNo(adjustmentNo);
            auditRespDto.setAuditIds((List)Lists.newArrayList((Object[])new Long[]{id}));
            auditRespDto.setAuditStatus("pass");
            auditRespDto.setInOutOrder(Boolean.valueOf(!CsWarehouseClassifyEnum.IN_TRANSIT.getCode().equals(addReqDto.getWarehouseClassify())));
            this.auditAdjustmentInventory(auditRespDto);
        }
        MessageVo messageVo = new MessageVo();
        CsInventoryAutoAuditMessageReqDto auditMessageReqDto = new CsInventoryAutoAuditMessageReqDto();
        auditMessageReqDto.setBusinessTypeCode("51000");
        auditMessageReqDto.setGroupCode(BdTypeOfDocumentEnum.INVENTORY_ADJUST.getCode());
        auditMessageReqDto.setDocumentNo(adjustmentNo);
        messageVo.setData((Object)auditMessageReqDto);
        log.info("\u53d1\u9001\u5e93\u5b58\u81ea\u52a8\u5ba1\u6838\u6d88\u8d39\u8005mq\u6d88\u606f,map:{}", (Object)LogUtils.buildLogContent(messageVo));
        this.commonsMqService.sendSingleMessage("SINGLE_TOPIC", "INVENTORY_AUTO_AUDIT_TAG", (Object)messageVo);
        return new RestResponse((Object)id);
    }

    private void preemptInventory(AdjustmentInventoryReqDto addReqDto) {
        log.info("preemptInventory==>\u7ec4\u88c5\u9884\u5360\u5e93\u5b58\u4fe1\u606f");
        List adjustmentDetails = addReqDto.getDetailReqDtoList();
        Map<String, List<AdjustmentInventoryDetailReqDto>> adjustmentChangeTypeMap = adjustmentDetails.stream().collect(Collectors.groupingBy(AdjustmentInventoryDetailReqDto::getChangeType));
        List<AdjustmentInventoryDetailReqDto> decreaseDetails = adjustmentChangeTypeMap.get(CsAdjustmentChangeTypeEnum.DECREASE.getCode());
        if (CollectionUtils.isEmpty(decreaseDetails)) {
            return;
        }
        PreemptDto preemptParam = new PreemptDto();
        preemptParam.setSourceNo(addReqDto.getAdjustmentNo());
        preemptParam.setSourceType(CsInventorySourceTypeEnum.INVENTORY_ADJUSTMENT_SUBMITTED_PREEMPT.getCode());
        preemptParam.setBusinessType(addReqDto.getBusinessType());
        if (ProjectEnum.BD.getCode().equals(InventoryConfig.getProjectCode())) {
            preemptParam.setBusinessType(PcpBasicInventoryBusinessTypeEnum.EXCHANGE_ORDER_REDUCE.getCode());
        }
        preemptParam.setValidNegative(Boolean.valueOf(false));
        preemptParam.setNoneLineNo(Boolean.TRUE);
        ArrayList detailParams = Lists.newArrayList();
        for (AdjustmentInventoryDetailReqDto detailReqDto : decreaseDetails) {
            CalcDetailDto detailParam = new CalcDetailDto();
            BigDecimal preemptNum = BigDecimalUtils.abs((BigDecimal)detailReqDto.getChangeQuantity());
            detailParam.setNum(preemptNum);
            detailParam.setSkuCode(detailReqDto.getCargoCode());
            detailParam.setLogicWarehouseCode(addReqDto.getWarehouseCode());
            detailParam.setBatch(detailReqDto.getBatch());
            detailParam.setProduceDate(detailReqDto.getProduceTime());
            detailParam.setExpireDate(detailReqDto.getExpireTime());
            detailParams.add(detailParam);
        }
        preemptParam.setDetails((List)detailParams);
        this.calcInventoryService.preempt(preemptParam);
    }

    public RestResponse<Void> modifyAdjustmentInventory(AdjustmentInventoryReqDto modifyReqDto) {
        this.adjustmentInventoryService.modifyAdjustmentInventory(modifyReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> removeAdjustmentInventory(String ids, Long instanceId) {
        this.adjustmentInventoryService.removeAdjustmentInventory(ids, instanceId);
        return RestResponse.VOID;
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> closeAdjustmentInventory(Long id, String remark) {
        AdjustmentInventoryRespDto adjustmentInventoryRespDto = this.adjustmentInventoryService.queryById(id);
        AdjustmentInventoryEo updateAdjustmentInventoryEo = new AdjustmentInventoryEo();
        updateAdjustmentInventoryEo.setId(adjustmentInventoryRespDto.getId());
        updateAdjustmentInventoryEo.setAdjustmentStatus("cancel");
        updateAdjustmentInventoryEo.setAdjustmentRemark(remark);
        this.adjustmentInventoryDas.updateSelective((BaseEo)updateAdjustmentInventoryEo);
        List detailRespDtoList = adjustmentInventoryRespDto.getDetailRespDtoList();
        Map<String, List<AdjustmentInventoryDetailRespDto>> changeTypeMap = detailRespDtoList.stream().collect(Collectors.groupingBy(AdjustmentInventoryDetailRespDto::getChangeType));
        List<AdjustmentInventoryDetailRespDto> decreaseList = changeTypeMap.get(CsAdjustmentChangeTypeEnum.DECREASE.getCode());
        if (CollectionUtils.isNotEmpty(decreaseList)) {
            this.releasePreempt(adjustmentInventoryRespDto.getAdjustmentNo(), adjustmentInventoryRespDto.getBusinessType());
        }
        return RestResponse.VOID;
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> auditAdjustmentInventory(AdjustmentInventoryAuditRespDto dto) {
        String adjustmentStatus = "audit_failed";
        if ("pass".equals(dto.getAuditStatus())) {
            adjustmentStatus = "completed";
        }
        for (Long id : dto.getAuditIds()) {
            this.doAudit(dto, adjustmentStatus, id);
        }
        return RestResponse.VOID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAudit(AdjustmentInventoryAuditRespDto dto, String adjustmentStatus, Long id) {
        Mutex mutex = this.lockService.lock("adjustmentInventory", dto.getAdjustmentNo(), 10, 15, TimeUnit.SECONDS);
        try {
            final AdjustmentInventoryRespDto adjustmentInventoryRespDto = this.adjustmentInventoryService.queryById(id);
            if (!CsBatchAdjustmentOrderStatusEnum.WAIT_AUDIT.getCode().equals(adjustmentInventoryRespDto.getAdjustmentStatus())) {
                throw new CsInventoryException("\u8be5\u76d8\u70b9\u5355\u5df2\u5ba1\u6838\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c", new Object[0]);
            }
            if ("pass".equals(dto.getAuditStatus())) {
                ReceiveDeliveryNoticeOrderFacadeBo deliveryNoticeOrderContext = new ReceiveDeliveryNoticeOrderFacadeBo();
                deliveryNoticeOrderContext.setBusinessType(adjustmentInventoryRespDto.getBusinessType());
                deliveryNoticeOrderContext.setSourceType(CsInventorySourceTypeEnum.OUT_TO_ADJUST.getCode());
                deliveryNoticeOrderContext.setExternalOrderNo(adjustmentInventoryRespDto.getExternalOrderNo());
                deliveryNoticeOrderContext.setPreOrderNo(adjustmentInventoryRespDto.getPreOrderNo());
                deliveryNoticeOrderContext.setRelevanceNo(adjustmentInventoryRespDto.getAdjustmentNo());
                deliveryNoticeOrderContext.setRelevanceTableName(CsRelevanceTableNameEnum.CS_ADJUSTMENT_INVENTORY);
                deliveryNoticeOrderContext.setLogicWarehouseCode(adjustmentInventoryRespDto.getWarehouseCode());
                deliveryNoticeOrderContext.setAutoComplete(Boolean.valueOf(true));
                deliveryNoticeOrderContext.setValidNegative(Boolean.valueOf(false));
                ReceiveDeliveryNoticeOrderFacadeBo receiveNoticeOrderContext = new ReceiveDeliveryNoticeOrderFacadeBo();
                BeanUtils.copyProperties((Object)deliveryNoticeOrderContext, (Object)receiveNoticeOrderContext);
                receiveNoticeOrderContext.setSourceType(CsInventorySourceTypeEnum.IN_TO_ADJUST.getCode());
                ArrayList deliveryNoticeOrderDetails = Lists.newArrayList();
                ArrayList receiveNoticeOrderDetails = Lists.newArrayList();
                for (AdjustmentInventoryDetailRespDto detail : adjustmentInventoryRespDto.getDetailRespDtoList()) {
                    BaseOrderDetailReqDto detailReqDto = new BaseOrderDetailReqDto();
                    detailReqDto.setPreOrderItemId(detail.getId());
                    detailReqDto.setBatch(detail.getBatch());
                    detailReqDto.setQuantity(BigDecimalUtils.abs((BigDecimal)detail.getChangeQuantity()));
                    detailReqDto.setSkuCode(detail.getCargoCode());
                    detailReqDto.setSkuName(detail.getCargoName());
                    detailReqDto.setExpireTime(detail.getExpireTime());
                    detailReqDto.setProduceTime(detail.getProduceTime());
                    if (CsAdjustmentChangeTypeEnum.INCREASE.getCode().equals(detail.getChangeType())) {
                        receiveNoticeOrderDetails.add(detailReqDto);
                        continue;
                    }
                    deliveryNoticeOrderDetails.add(detailReqDto);
                }
                deliveryNoticeOrderContext.setCallBack((BaseOrderCallBack)new BaseOrderCallBack<BaseOrderBaseContext>(){

                    public void beforeCallBack(BaseOrderBaseContext context) {
                        boolean isInstanceof = context instanceof ReceiveDeliveryNoticeOrderContext;
                        log.info("beforeCallBack->context instanceof ReceiveDeliveryNoticeOrderContext:{}", (Object)JSON.toJSONString((Object)isInstanceof));
                        if (!isInstanceof) {
                            return;
                        }
                        ReceiveDeliveryNoticeOrderContext context1 = (ReceiveDeliveryNoticeOrderContext)context;
                        ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo = context1.getReceiveDeliveryNoticeOrderEo();
                        receiveDeliveryNoticeOrderEo.setExtension(adjustmentInventoryRespDto.getExtension());
                        receiveDeliveryNoticeOrderEo.setTotalQuantity(adjustmentInventoryRespDto.getTotalQuantity());
                    }

                    public void afterCallBack(BaseOrderBaseContext context) {
                    }
                });
                if (CollectionUtils.isNotEmpty((Collection)deliveryNoticeOrderDetails)) {
                    deliveryNoticeOrderContext.setOrderBasicsDetailReqDtoList((List)deliveryNoticeOrderDetails);
                    deliveryNoticeOrderContext.setDisplayBusinessType(PcpBasicInventoryBusinessTypeEnum.EXCHANGE_ORDER_REDUCE.getCode());
                    this.baseOrderFacade.deliveryNoticeOrderGen(deliveryNoticeOrderContext);
                }
                if (CollectionUtils.isNotEmpty((Collection)receiveNoticeOrderDetails)) {
                    receiveNoticeOrderContext.setOrderBasicsDetailReqDtoList((List)receiveNoticeOrderDetails);
                    receiveNoticeOrderContext.setDisplayBusinessType(PcpBasicInventoryBusinessTypeEnum.INVENTORY_ADJUST_ADD.getCode());
                    this.baseOrderFacade.receiveNoticeOrderGen(receiveNoticeOrderContext);
                }
            } else {
                List detailRespDtoList = adjustmentInventoryRespDto.getDetailRespDtoList();
                Map<String, List<AdjustmentInventoryDetailRespDto>> changeTypeMap = detailRespDtoList.stream().collect(Collectors.groupingBy(AdjustmentInventoryDetailRespDto::getChangeType));
                List<AdjustmentInventoryDetailRespDto> decreaseList = changeTypeMap.get(CsAdjustmentChangeTypeEnum.DECREASE.getCode());
                if (CollectionUtils.isNotEmpty(decreaseList)) {
                    this.releasePreempt(adjustmentInventoryRespDto.getAdjustmentNo(), adjustmentInventoryRespDto.getBusinessType());
                }
            }
            AdjustmentInventoryEo updateAdjustmentInventoryEo = new AdjustmentInventoryEo();
            updateAdjustmentInventoryEo.setId(adjustmentInventoryRespDto.getId());
            updateAdjustmentInventoryEo.setAdjustmentStatus(adjustmentStatus);
            this.adjustmentInventoryDas.updateSelective((BaseEo)updateAdjustmentInventoryEo);
            AdjustmentInventoryAuditReqDto addReqDto = new AdjustmentInventoryAuditReqDto();
            addReqDto.setAdjustmentNo(adjustmentInventoryRespDto.getAdjustmentNo());
            addReqDto.setAuditRemark(dto.getAuditRemark());
            addReqDto.setAuditStatus(dto.getAuditStatus());
            this.adjustmentInventoryAuditService.addAdjustmentInventoryAudit(addReqDto);
            this.transactionCallBackService.execute(() -> this.sendMq(adjustmentInventoryRespDto));
        }
        finally {
            this.transactionAfterService.execute(() -> this.lockService.unlock(mutex));
        }
    }

    private void sendMq(AdjustmentInventoryRespDto adjustmentInventoryRespDto) {
        if (CsAdjustmentOrderTypeEnum.IN_TRANSIT_ADJUSTMENT.getCode().equals(adjustmentInventoryRespDto.getAdjustmentType())) {
            MessageVo messageVo = new MessageVo();
            messageVo.setData((Object)JSON.toJSONString((Object)adjustmentInventoryRespDto.getAdjustmentNo()));
            this.mqService.inTransitAdjustmentCompleteProcessor(messageVo);
            log.info("\u8c03\u6574\u5355\u5b8c\u6210\u53d1\u9001\u901a\u77e5,\u63a8\u9001\u6d88\u606f:{}", (Object)LogUtils.buildLogContent(messageVo));
        }
    }

    public void checkParam(AdjustmentInventoryReqDto dto) {
        String businessType;
        if (CollectionUtil.isEmpty((Collection)dto.getDetailReqDtoList())) {
            throw new BizException("\u8c03\u6574\u5355\u7684\u5546\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String string = businessType = StringUtils.isEmpty((CharSequence)dto.getBusinessType()) ? dto.getAdjustmentType() : dto.getBusinessType();
        if (CsPcpBusinessTypeEnum.IN_TRANSIT_ADJUSTMENT.getCode().equals(dto.getAdjustmentType())) {
            String changeType = ((AdjustmentInventoryDetailReqDto)dto.getDetailReqDtoList().get(0)).getChangeType();
            businessType = CsAdjustmentChangeTypeEnum.INCREASE.getCode().equals(changeType) ? CsPcpBusinessTypeEnum.IN_TRANSIT_ADJUSTMENT_IN.getCode() : CsPcpBusinessTypeEnum.IN_TRANSIT_ADJUSTMENT_OUT.getCode();
        }
        dto.setBusinessType(businessType);
    }

    private void releasePreempt(String adjustmentNo, String businessType) {
        ReleasePreemptDto releasePreemptParam = new ReleasePreemptDto();
        releasePreemptParam.setSourceNo(adjustmentNo);
        releasePreemptParam.setSourceType(CsInventorySourceTypeEnum.INVENTORY_ADJUSTMENT_SUBMITTED_PREEMPT_RELEASE.getCode());
        releasePreemptParam.setBusinessType(businessType);
        this.calcInventoryService.releasePreempt(releasePreemptParam);
    }

    public RestResponse<AdjustmentInventoryRespDto> queryById(Long id) {
        AdjustmentInventoryRespDto dto = this.adjustmentInventoryService.queryById(id);
        if ("logic".equals(dto.getWarehouseType())) {
            CsDeliveryNoticeOrderQueryDto queryDto = new CsDeliveryNoticeOrderQueryDto();
            queryDto.setRelevanceNo(dto.getAdjustmentNo());
            queryDto.setPageNum(Integer.valueOf(1));
            queryDto.setPageSize(Integer.valueOf(10000));
            PageInfo<CsDeliveryNoticeOrderRespDto> pageInfo = this.csDeliveryNoticeOrderQueryService.queryByPage(queryDto);
            dto.setDeliveryNoticeOrderRespDtoList(pageInfo.getList());
        } else {
            CsOutNoticeOrderQueryDto queryDto = new CsOutNoticeOrderQueryDto();
            queryDto.setRelevanceNo(dto.getAdjustmentNo());
            queryDto.setPageNum(Integer.valueOf(1));
            queryDto.setPageSize(Integer.valueOf(10000));
            PageInfo<CsOutNoticeOrderRespDto> pageInfo = this.csOutNoticeOrderQueryService.queryPage(queryDto);
            dto.setOutNoticeOrderRespDtoList(pageInfo.getList());
        }
        return new RestResponse((Object)dto);
    }

    public RestResponse<AdjustmentInventoryRespDto> queryByAdjustmentNo(String adjustmentNo) {
        return new RestResponse((Object)this.adjustmentInventoryService.queryByAdjustmentNo(adjustmentNo));
    }

    public RestResponse<PageInfo<AdjustmentInventoryRespDto>> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.adjustmentInventoryService.queryByPage(filter, pageNum, pageSize));
    }

    public RestResponse<adjustmentInventoryStatusCountRespDto> adjustmentInventoryStatusCount(String filter) {
        return new RestResponse((Object)this.adjustmentInventoryService.adjustmentInventoryStatusCount(filter));
    }
}

