/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl.inventory;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.biz.mq.OrderInformMqService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.inventory.IMqMessageService;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.MqMessageDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.MqMessageEo;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.MqContentOrderDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.MqMessageReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.MqMessageRespDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import liquibase.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MqMessageServiceImpl
implements IMqMessageService {
    private static final Logger logger = LoggerFactory.getLogger(MqMessageServiceImpl.class);
    @Resource
    private MqMessageDas mqMessageDas;
    @Resource
    private OrderInformMqService orderInformMqService;
    private static final String SRC_SYSTEM_ORDER = "YWZT";

    @Override
    public Long addMqMessage(MqMessageReqDto mqMessageReqDto) {
        MqMessageEo mqMessageEo = new MqMessageEo();
        DtoHelper.dto2Eo((BaseVo)mqMessageReqDto, (BaseEo)mqMessageEo);
        this.mqMessageDas.insert((BaseEo)mqMessageEo);
        return mqMessageEo.getId();
    }

    @Override
    public MqMessageRespDto queryById(Long id, boolean status) {
        MqMessageEo mqMessageEo = (MqMessageEo)this.mqMessageDas.selectByPrimaryKey(id);
        MqMessageRespDto mqMessageRespDto = null;
        if (mqMessageEo != null) {
            mqMessageRespDto = new MqMessageRespDto();
            DtoHelper.eo2Dto((BaseEo)mqMessageEo, (BaseVo)mqMessageRespDto);
            if (status) {
                mqMessageEo.setStatus(Integer.valueOf(1));
                this.mqMessageDas.update((BaseEo)mqMessageEo);
            }
        }
        return mqMessageRespDto;
    }

    @Override
    public MqMessageRespDto queryById(Long messageId) {
        MqMessageEo mqMessageEo = (MqMessageEo)this.mqMessageDas.selectByPrimaryKey(messageId);
        MqMessageRespDto mqMessageRespDto = new MqMessageRespDto();
        DtoHelper.eo2Dto((BaseEo)mqMessageEo, (BaseVo)mqMessageRespDto);
        return mqMessageRespDto;
    }

    @Override
    public void sendDeliverOrderInform(MqContentOrderDto dto) {
        dto.setSrcSystem(SRC_SYSTEM_ORDER);
        MqMessageEo mqMessageEo = new MqMessageEo();
        mqMessageEo.setType(Integer.valueOf(1));
        mqMessageEo.setNo(dto.getNo());
        mqMessageEo.setMessage(JSON.toJSONString((Object)dto));
        mqMessageEo.setStatus(Integer.valueOf(0));
        this.mqMessageDas.insert((BaseEo)mqMessageEo);
        this.orderInformMqService.sendDeliverOrderInformMq(mqMessageEo.getId().toString());
    }

    @Override
    public void sendReceiveOrderInformMq(MqContentOrderDto dto) {
        dto.setSrcSystem(SRC_SYSTEM_ORDER);
        MqMessageEo mqMessageEo = new MqMessageEo();
        mqMessageEo.setType(Integer.valueOf(2));
        mqMessageEo.setNo(dto.getNo());
        mqMessageEo.setMessage(JSONObject.toJSONString((Object)dto));
        mqMessageEo.setStatus(Integer.valueOf(0));
        this.mqMessageDas.insert((BaseEo)mqMessageEo);
        this.orderInformMqService.sendReceiveOrderInformMq(mqMessageEo.getId().toString());
    }

    @Override
    public List<MqMessageRespDto> queryByNo(List<String> noList) {
        if (CollectionUtil.isEmpty(noList)) {
            return new ArrayList<MqMessageRespDto>();
        }
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"no", noList));
        MqMessageEo mqMessageEo = new MqMessageEo();
        mqMessageEo.setSqlFilters(sqlFilters);
        List mqMessageEos = this.mqMessageDas.select((BaseEo)mqMessageEo);
        ArrayList<MqMessageRespDto> list = new ArrayList<MqMessageRespDto>();
        DtoHelper.eoList2DtoList((Collection)mqMessageEos, list, MqMessageRespDto.class);
        return list;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String repairDataOfNo() {
        try {
            int updNum = 0;
            List mqMessageEos = this.mqMessageDas.selectAll();
            if (CollectionUtil.isNotEmpty((Collection)mqMessageEos)) {
                for (MqMessageEo eo : mqMessageEos) {
                    if (!StringUtils.isEmpty((String)eo.getNo())) continue;
                    Map map = (Map)JSONObject.parseObject((String)eo.getMessage(), Map.class);
                    eo.setNo(map.get("no").toString());
                    this.mqMessageDas.update((BaseEo)eo);
                    ++updNum;
                }
                return "\u6267\u884c\u6210\u529f\uff1a\u67e5\u8be2\u603b\u6570\uff1a" + mqMessageEos.size() + "\uff0c\u66f4\u65b0\u6761\u6570\uff1a" + updNum;
            }
            return "\u6267\u884c\u6210\u529f\uff1a\u65e0MQ\u8bb0\u5f55\u4fe1\u606f";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "\u6267\u884c\u5f02\u5e38\uff1a" + e.getMessage();
        }
    }

    @Override
    public void updateMessage(MqMessageReqDto mqMessageReqDto) {
        logger.info("\u63a5\u6536\u5230\u7f16\u8f91\u961f\u5217\u6d88\u606f\u4fe1\u606f,updateMessage \u53c2\u6570{}", (Object)JSON.toJSONString((Object)mqMessageReqDto));
        MqMessageEo updateEo = new MqMessageEo();
        DtoHelper.dto2Eo((BaseVo)mqMessageReqDto, (BaseEo)updateEo);
        this.mqMessageDas.updateSelective((BaseEo)updateEo);
    }
}

