/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.biz.dto.request.CsBasisOrderBusinessDataReqDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.commons.CsCommonService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsBaseOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsDeliveryNoticeOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsDeliveryNoticeOrderDetailQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryNoticeOrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryNoticeOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicInventoryTotalDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.domain.ContactDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsBasisOrderBusinessDataRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsDeliveryNoticeOrderQueryDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsWmsShippingInfoReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.ReceiveDeliveryNoticeOrderDetailQueryDto;
import com.yunxi.dg.base.center.inventory.eo.LogicInventoryTotalEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderEo;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import jodd.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="csDeliveryNoticeOrderQueryService")
public class CsDeliveryNoticeOrderQueryServiceImpl
implements ICsDeliveryNoticeOrderQueryService {
    private static final Logger log = LoggerFactory.getLogger(CsDeliveryNoticeOrderQueryServiceImpl.class);
    @Resource
    IReceiveDeliveryNoticeOrderDomain receiveDeliveryNoticeOrderDomain;
    @Resource
    IReceiveDeliveryNoticeOrderDetailDomain receiveDeliveryNoticeOrderDetailDomain;
    @Resource
    IReceiveDeliveryResultOrderDomain receiveDeliveryResultOrderDomain;
    @Resource
    CsCommonService csCommonService;
    @Resource
    ICsBaseOrderQueryService csBaseOrderQueryService;
    @Autowired
    ILogicInventoryTotalDomain logicInventoryTotalDomain;
    @Resource
    ILogicWarehouseDomain logicWarehouseDomain;

    @Override
    public ReceiveDeliveryNoticeOrderEo selectByPrimaryKey(Long id) {
        log.info("\u6839\u636eid\u67e5\u8be2\u4fe1\u606f\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        ReceiveDeliveryNoticeOrderEo deliveryNoticeOrderEo = (ReceiveDeliveryNoticeOrderEo)this.receiveDeliveryNoticeOrderDomain.selectByPrimaryKey(id);
        AssertUtils.isTrue((deliveryNoticeOrderEo != null && deliveryNoticeOrderEo.getId() != null ? 1 : 0) != 0, (String)"\u8bb0\u5f55\u4e0d\u5b58\u5728");
        return (ReceiveDeliveryNoticeOrderEo)BeanUtil.copyProperties((Object)deliveryNoticeOrderEo, ReceiveDeliveryNoticeOrderEo.class, (String[])new String[0]);
    }

    @Override
    public CsDeliveryNoticeOrderRespDto queryById(Long id) {
        log.info("\u6839\u636eid\u67e5\u8be2\u4fe1\u606f\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtils.isTrue((id != null && id > 0L ? 1 : 0) != 0, (String)"\u53c2\u6570\u6709\u8bef");
        ReceiveDeliveryNoticeOrderEo deliveryNoticeOrderEo = (ReceiveDeliveryNoticeOrderEo)this.receiveDeliveryNoticeOrderDomain.selectByPrimaryKey(id);
        AssertUtils.isTrue((deliveryNoticeOrderEo != null && deliveryNoticeOrderEo.getId() != null ? 1 : 0) != 0, (String)"\u8bb0\u5f55\u4e0d\u5b58\u5728");
        return this.wrapperDetail(deliveryNoticeOrderEo);
    }

    @Override
    public CsDeliveryNoticeOrderRespDto queryByDocumentNo(String documentNo) {
        List list = ((ExtQueryChainWrapper)this.receiveDeliveryNoticeOrderDomain.filter().eq((Object)"document_no", (Object)documentNo)).list();
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)list), "\u5355\u53f7\u4e0d\u5b58\u5728");
        return this.wrapperDetail((ReceiveDeliveryNoticeOrderEo)list.get(0));
    }

    @Override
    public PageInfo<CsDeliveryNoticeOrderDetailRespDto> queryDeliveryNoticeOrderDetails(CsDeliveryNoticeOrderDetailQueryDto queryDto) {
        log.info("\u5206\u9875\u67e5\u8be2\u53c2\u6570\uff1a[{}]", (Object)JSONObject.toJSONString((Object)queryDto));
        AssertUtil.emptyValidated(queryDto, "pageNum", "pageSize");
        PageInfo pageInfo = new PageInfo();
        if (StringUtil.isNotBlank((CharSequence)queryDto.getIdentification()) && queryDto.getIdentification().equals("identification")) {
            PageHelper.startPage((int)queryDto.getPageNum(), (int)queryDto.getPageSize());
            ReceiveDeliveryNoticeOrderDetailQueryDto receiveDeliveryNoticeOrderDetailQueryDto = (ReceiveDeliveryNoticeOrderDetailQueryDto)BeanUtil.copyProperties((Object)queryDto, ReceiveDeliveryNoticeOrderDetailQueryDto.class, (String[])new String[0]);
            PageInfo selectPage = this.receiveDeliveryNoticeOrderDetailDomain.queryPage(receiveDeliveryNoticeOrderDetailQueryDto);
            CubeBeanUtils.copyProperties((Object)pageInfo, (Object)selectPage, (String[])new String[]{"list", "navigatepageNums"});
            ArrayList dtoList = new ArrayList();
            CubeBeanUtils.copyCollection(dtoList, (Collection)selectPage.getList(), CsDeliveryNoticeOrderDetailRespDto.class);
            for (CsDeliveryNoticeOrderDetailRespDto respDto : dtoList) {
                respDto.setCargoCode(respDto.getSkuCode());
                respDto.setCargoName(respDto.getSkuName());
                respDto.setLongCode(respDto.getSkuCode());
            }
            pageInfo.setList(dtoList);
            return pageInfo;
        }
        ReceiveDeliveryNoticeOrderDetailEo eo = new ReceiveDeliveryNoticeOrderDetailEo();
        DtoHelper.dto2Eo((BaseVo)queryDto, (BaseEo)eo);
        PageInfo receiveDeliveryNoticeOrderDetailEoPageInfo = this.receiveDeliveryNoticeOrderDetailDomain.selectPage((BaseEo)eo, queryDto.getPageNum(), queryDto.getPageSize());
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)receiveDeliveryNoticeOrderDetailEoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List<Object> list = Lists.newArrayList();
        if (Objects.nonNull(receiveDeliveryNoticeOrderDetailEoPageInfo) && CollectionUtils.isNotEmpty((Collection)receiveDeliveryNoticeOrderDetailEoPageInfo.getList())) {
            list = receiveDeliveryNoticeOrderDetailEoPageInfo.getList().stream().map(e -> {
                CsDeliveryNoticeOrderDetailRespDto respDto = new CsDeliveryNoticeOrderDetailRespDto();
                CubeBeanUtils.copyProperties((Object)respDto, (Object)e, (String[])new String[0]);
                respDto.setCargoCode(e.getSkuCode());
                respDto.setLongCode(e.getSkuCode());
                respDto.setCargoName(e.getSkuName());
                return respDto;
            }).collect(Collectors.toList());
        }
        pageInfo.setList((List)list);
        return pageInfo;
    }

    @Override
    public CsDeliveryNoticeOrderRespDto queryVersionSecondByDocumentNo(String documentNo) {
        ReceiveDeliveryNoticeOrderEo receiveOrderEo;
        BigDecimal skuNum;
        List list = this.receiveDeliveryNoticeOrderDomain.queryDeliveryNotice(documentNo);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)list), "\u5355\u53f7\u4e0d\u5b58\u5728");
        ReceiveDeliveryNoticeOrderEo deliveryNoticeOrderEo = (ReceiveDeliveryNoticeOrderEo)list.get(0);
        AssertUtil.isTrue(deliveryNoticeOrderEo != null && deliveryNoticeOrderEo.getId() != null, "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        CsDeliveryNoticeOrderRespDto dto = new CsDeliveryNoticeOrderRespDto();
        CubeBeanUtils.copyProperties((Object)dto, (Object)deliveryNoticeOrderEo, (String[])new String[0]);
        if (deliveryNoticeOrderEo.getTotalQuantity() != null && deliveryNoticeOrderEo.getTotalQuantity().compareTo(BigDecimal.ZERO) > 0) {
            dto.setTotalQuantity(deliveryNoticeOrderEo.getTotalQuantity());
        } else {
            dto.setTotalQuantity(BigDecimal.ZERO);
        }
        dto.setWarehouseCode(deliveryNoticeOrderEo.getDeliveryLogicWarehouseCode());
        dto.setWarehouseName(deliveryNoticeOrderEo.getDeliveryLogicWarehouseName());
        dto.setReceiveWarehouseCode(deliveryNoticeOrderEo.getReceiveLogicWarehouseCode());
        dto.setReceiveWarehouseName(deliveryNoticeOrderEo.getReceiveLogicWarehouseName());
        String shippingJson = deliveryNoticeOrderEo.getShippingJson();
        if (StringUtils.isNotBlank((CharSequence)shippingJson)) {
            try {
                List csWmsShippingInfoReqDtoList = JSON.parseArray((String)shippingJson, CsWmsShippingInfoReqDto.class);
                log.info("queryVersionSecondByDocumentNo==>\u5355\u53f7:{},\u7269\u6d41\u4fe1\u606f\u96c6\u5408,csWmsShippingInfoReqDtoList:{}", (Object)deliveryNoticeOrderEo.getDocumentNo(), (Object)LogUtils.buildLogContent(csWmsShippingInfoReqDtoList));
                dto.setShippingInfoList(csWmsShippingInfoReqDtoList);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        CsBasisOrderBusinessDataReqDto dataReqDto = new CsBasisOrderBusinessDataReqDto();
        CubeBeanUtils.copyProperties((Object)dataReqDto, (Object)dto, (String[])new String[0]);
        CsBasisOrderBusinessDataRespDto dataRespDto = this.csBaseOrderQueryService.deliveryReceiveNoticeBuildRelOrderInfo(dataReqDto, "delivery", "out");
        if (Objects.nonNull(dataRespDto)) {
            dto.setContactDto(dataRespDto.getContactDto());
            dto.setRelOrderInfoList(dataRespDto.getRelOrderInfoList());
        }
        if (Objects.nonNull(skuNum = this.csBaseOrderQueryService.queryItemMapByDeliveryReceiveNoticeDocumentNo(dto.getDocumentNo()))) {
            dto.setSkuNum(skuNum.toString());
        }
        if (StringUtils.isBlank((CharSequence)dto.getReceiveLogicWarehouseCode()) && (receiveOrderEo = this.receiveDeliveryNoticeOrderDomain.queryByRelevanceNoOrderType(deliveryNoticeOrderEo.getRelevanceNo(), "receive")) != null) {
            dto.setReceiveLogicWarehouseCode(receiveOrderEo.getReceiveLogicWarehouseCode());
            dto.setReceiveLogicWarehouseName(receiveOrderEo.getReceiveLogicWarehouseName());
            dto.setReceiveWarehouseCode(receiveOrderEo.getReceiveLogicWarehouseCode());
            dto.setReceiveWarehouseName(receiveOrderEo.getReceiveLogicWarehouseName());
        }
        this.buildWarehouseInfo(dto);
        return dto;
    }

    @Override
    public List<CsDeliveryNoticeOrderDetailRespDto> queryByRelevanceNo(String relevanceNo) {
        List deliveryNoticeOrderDetailEoList = this.receiveDeliveryNoticeOrderDetailDomain.queryByRelevanceNo(relevanceNo);
        if (CollectionUtils.isNotEmpty((Collection)deliveryNoticeOrderDetailEoList)) {
            ArrayList<CsDeliveryNoticeOrderDetailRespDto> list = new ArrayList<CsDeliveryNoticeOrderDetailRespDto>();
            CubeBeanUtils.copyCollection(list, (Collection)deliveryNoticeOrderDetailEoList, CsDeliveryNoticeOrderDetailRespDto.class);
            return list;
        }
        return null;
    }

    @Override
    public PageInfo<CsDeliveryNoticeOrderRespDto> queryByPage(CsDeliveryNoticeOrderQueryDto queryDto) {
        log.info("\u83b7\u53d6\u53d1\u8d27\u7ed3\u679c\u5355-\u8f93\u5165:{}", (Object)JSON.toJSONString((Object)queryDto));
        Integer pageNum = queryDto.getPageNum();
        Integer pageSize = queryDto.getPageSize();
        AssertUtils.isTrue((Objects.nonNull(pageNum) && pageNum > 0 ? 1 : 0) != 0, (String)"\u9875\u7801\u53c2\u6570\u4e0d\u5408\u6cd5");
        AssertUtils.isTrue((Objects.nonNull(pageSize) && pageSize > 0 ? 1 : 0) != 0, (String)"\u6bcf\u9875\u6761\u6570\u4e0d\u5408\u6cd5");
        Long organizationId = this.csCommonService.getUserOrganizationId();
        PageInfo selectPage = this.receiveDeliveryNoticeOrderDomain.getReceiveDeliveryNoticeOrderEoPageInfo(queryDto, pageNum, pageSize, organizationId);
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)selectPage, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)selectPage.getList(), dtoList, CsDeliveryNoticeOrderRespDto.class);
        pageInfo.setList(dtoList);
        return pageInfo;
    }

    @Override
    public CsDeliveryNoticeOrderRespDto queryByPreOrderNo(String preOrderNo) {
        List list = this.receiveDeliveryNoticeOrderDomain.queryByPreOrderNo(preOrderNo, "delivery");
        CsDeliveryNoticeOrderRespDto dto = new CsDeliveryNoticeOrderRespDto();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            CubeBeanUtils.copyProperties((Object)dto, list.get(0), (String[])new String[0]);
        }
        return dto;
    }

    @Override
    public List<LogicInventoryTotalEo> queryWarehouseInventory(String warehouseCode, List<String> cargoList) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"warehouse_code", (Object)warehouseCode);
        wrapper.in((Object)"sku_code", cargoList);
        wrapper.eq((Object)"dr", (Object)0);
        return this.logicInventoryTotalDomain.getMapper().selectList((Wrapper)wrapper);
    }

    @Override
    public List<String> queryPreOrderNoIsBatch(List<String> preOrderNoList) {
        List<ReceiveDeliveryNoticeOrderDetailEo> detailEoList = this.queryByPreOrderNoList(preOrderNoList);
        if (CollectionUtils.isNotEmpty(detailEoList)) {
            return detailEoList.stream().map(ReceiveDeliveryNoticeOrderDetailEo::getPreOrderNo).distinct().collect(Collectors.toList());
        }
        return null;
    }

    private List<ReceiveDeliveryNoticeOrderDetailEo> queryByPreOrderNoList(List<String> preOrderNoList) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"pre_order_no", preOrderNoList);
        queryWrapper.isNull((Object)"batch");
        return BeanUtil.copyToList((Collection)this.receiveDeliveryNoticeOrderDetailDomain.getMapper().selectList((Wrapper)queryWrapper), ReceiveDeliveryNoticeOrderDetailEo.class);
    }

    private CsDeliveryNoticeOrderRespDto wrapperDetail(ReceiveDeliveryNoticeOrderEo deliveryNoticeOrderEo) {
        List resultOrderEoList;
        List detailEoList = this.receiveDeliveryNoticeOrderDetailDomain.queryByDocumentNo(deliveryNoticeOrderEo.getDocumentNo());
        CsDeliveryNoticeOrderRespDto dto = new CsDeliveryNoticeOrderRespDto();
        CubeBeanUtils.copyProperties((Object)dto, (Object)deliveryNoticeOrderEo, (String[])new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)detailEoList)) {
            ArrayList deliveryNoticeOrderDetailRespDtoList = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)deliveryNoticeOrderDetailRespDtoList, (Collection)detailEoList, CsDeliveryNoticeOrderDetailRespDto.class);
            dto.setDeliveryNoticeOrderDetailRespDtoList((List)deliveryNoticeOrderDetailRespDtoList);
        }
        if (StringUtils.isNotBlank((CharSequence)deliveryNoticeOrderEo.getExtension())) {
            try {
                ContactDto contactDto = (ContactDto)JSON.parseObject((String)deliveryNoticeOrderEo.getExtension(), ContactDto.class);
                dto.setContactDto(contactDto);
            }
            catch (Exception ex) {
                log.error("\u6355\u83b7\u5f02\u5e38\uff0c\u903b\u8f91\u4e0d\u5904\u7406\uff1a\u524d\u7f6e\u5355\u636e\u6536\u8d27\u4fe1\u606f\u9519\u8bef");
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(resultOrderEoList = this.receiveDeliveryResultOrderDomain.queryByRelevanceNo(deliveryNoticeOrderEo.getDocumentNo())))) {
            List resultNo = resultOrderEoList.stream().map(ReceiveDeliveryResultOrderEo::getDocumentNo).collect(Collectors.toList());
            dto.setResultNo(resultNo);
        }
        return dto;
    }

    private void buildWarehouseInfo(CsDeliveryNoticeOrderRespDto dto) {
        LogicWarehouseEo receiveLogicWarehouseEo;
        String receiveWarehouseCode;
        ArrayList warehouseList = Lists.newArrayList();
        String warehouseCode = dto.getWarehouseCode();
        if (StringUtils.isNotBlank((CharSequence)warehouseCode)) {
            warehouseList.add(warehouseCode);
        }
        if (StringUtils.isNotBlank((CharSequence)(receiveWarehouseCode = dto.getReceiveWarehouseCode()))) {
            warehouseList.add(receiveWarehouseCode);
        }
        if (CollectionUtils.isEmpty((Collection)warehouseList)) {
            return;
        }
        Map<String, LogicWarehouseEo> logicWarehouseEoMap = this.getLogicWarehouseEoMap(warehouseList);
        LogicWarehouseEo LogicWarehouseEo2 = logicWarehouseEoMap.get(warehouseCode);
        if (null != LogicWarehouseEo2) {
            dto.setWarehouseName(LogicWarehouseEo2.getWarehouseName());
        }
        if (null != (receiveLogicWarehouseEo = logicWarehouseEoMap.get(receiveWarehouseCode))) {
            dto.setReceiveWarehouseName(receiveLogicWarehouseEo.getWarehouseName());
        }
    }

    public Map<String, LogicWarehouseEo> getLogicWarehouseEoMap(List<String> warehouseList) {
        QueryWrapper LogicWarehouseEoQueryWrapper = new QueryWrapper();
        LogicWarehouseEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        LogicWarehouseEoQueryWrapper.in((Object)"warehouse_code", warehouseList);
        LogicWarehouseEoQueryWrapper.eq((Object)"warehouse_status", (Object)CsValidFlagEnum.ENABLE.getCode());
        List LogicWarehouseEoList = this.logicWarehouseDomain.getMapper().selectList((Wrapper)LogicWarehouseEoQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)LogicWarehouseEoList)) {
            return Maps.newHashMap();
        }
        Map<String, LogicWarehouseEo> logicWarehouseEoMap = LogicWarehouseEoList.stream().collect(Collectors.toMap(LogicWarehouseEo::getWarehouseCode, Function.identity()));
        return logicWarehouseEoMap;
    }
}

