/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.adapter.bd;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.biz.adapter.CsReceiveNoticeOrderQueryApiImpl;
import com.dtyunxi.yundt.cube.center.inventory.biz.dto.request.CsBasisOrderBusinessDataReqDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsBaseOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsBaseOrderAddressContactsTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.dtyunxi.yundt.cube.center.inventory.exception.CsInventoryExceptionCode;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.IBaseOrderAddressDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.domain.ContactDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsBasisOrderBusinessDataRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsReceiveNoticeOrderRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsWmsShippingInfoReqDto;
import com.yunxi.dg.base.center.inventory.eo.BaseOrderAddressEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="bd_ICsReceiveNoticeOrderQueryApi")
public class BdReceiveNoticeOrderQueryApiImpl
extends CsReceiveNoticeOrderQueryApiImpl {
    private static final Logger log = LoggerFactory.getLogger(BdReceiveNoticeOrderQueryApiImpl.class);
    @Resource
    private IReceiveDeliveryNoticeOrderDomain receiveDeliveryNoticeOrderDomain;
    @Resource
    private ICsBaseOrderQueryService csBaseOrderQueryService;
    @Resource
    private ILogicWarehouseDomain logicWarehouseDomain;
    @Resource
    private IBaseOrderAddressDomain baseOrderAddressDomain;

    @Override
    public RestResponse<CsReceiveNoticeOrderRespDto> queryVersionSecondByDocumentNo(String documentNo) {
        QueryWrapper deliveryNoticeOrderQueryWrapper = new QueryWrapper();
        deliveryNoticeOrderQueryWrapper.eq((Object)"document_no", (Object)documentNo);
        deliveryNoticeOrderQueryWrapper.eq((Object)"dr", (Object)0);
        deliveryNoticeOrderQueryWrapper.eq((Object)"order_type", (Object)"receive");
        List list = this.receiveDeliveryNoticeOrderDomain.getMapper().selectList((Wrapper)deliveryNoticeOrderQueryWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)list), "\u5355\u53f7\u4e0d\u5b58\u5728");
        ReceiveDeliveryNoticeOrderEo eo = (ReceiveDeliveryNoticeOrderEo)list.get(0);
        AssertUtil.isTrue(eo != null, CsInventoryExceptionCode.RECORD_NOT_EXIST.getMsg());
        log.info("eo\u54cd\u5e94=>{}", (Object)JSON.toJSONString((Object)eo));
        CsReceiveNoticeOrderRespDto dto = new CsReceiveNoticeOrderRespDto();
        DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)dto);
        dto.setWarehouseCode(eo.getReceiveLogicWarehouseCode());
        dto.setWarehouseName(eo.getReceiveLogicWarehouseName());
        dto.setDeliveryWarehouseCode(eo.getDeliveryLogicWarehouseCode());
        dto.setDeliveryWarehouseName(eo.getDeliveryLogicWarehouseName());
        String shippingJson = eo.getShippingJson();
        if (StringUtils.isNotBlank((CharSequence)shippingJson)) {
            try {
                List csWmsShippingInfoReqDtoList = JSON.parseArray((String)shippingJson, CsWmsShippingInfoReqDto.class);
                log.info("queryVersionSecondByDocumentNo==>\u5355\u53f7:{},\u7269\u6d41\u4fe1\u606f\u96c6\u5408,csWmsShippingInfoReqDtoList:{}", (Object)eo.getDocumentNo(), (Object)LogUtils.buildLogContent(csWmsShippingInfoReqDtoList));
                dto.setShippingInfoList(csWmsShippingInfoReqDtoList);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        CsBasisOrderBusinessDataReqDto dataReqDto = new CsBasisOrderBusinessDataReqDto();
        CubeBeanUtils.copyProperties((Object)dataReqDto, (Object)dto, (String[])new String[0]);
        CsBasisOrderBusinessDataRespDto dataRespDto = this.csBaseOrderQueryService.deliveryReceiveNoticeBuildRelOrderInfo(dataReqDto, "receive", "in");
        if (Objects.nonNull(dataRespDto)) {
            dto.setContactDto(dataRespDto.getContactDto());
            this.queryBaseOrderAddressInfo(eo, dto);
            dto.setRelOrderInfoList(dataRespDto.getRelOrderInfoList());
        }
        BigDecimal skuNum = this.csBaseOrderQueryService.queryItemMapByDeliveryReceiveNoticeDocumentNo(dto.getDocumentNo());
        dto.setSkuNum(skuNum);
        if (!CsPcpBusinessTypeEnum.returnInWarehouseAddressBusinessType((String)eo.getBusinessType()).booleanValue()) {
            log.info("\u4e0d\u7528\u8fd4\u56de\u5173\u8054\u4e1a\u52a1\u5355\u4fe1\u606f,\u76f4\u63a5\u8fd4\u56de");
            dto.setContactDto(null);
            log.info("dto\u54cd\u5e94=>{}", (Object)JSON.toJSONString((Object)dto));
            return new RestResponse((Object)dto);
        }
        BaseOrderAddressEo orderAddressEo = null;
        if (StringUtils.isNotBlank((CharSequence)documentNo)) {
            QueryWrapper baseOrderAddressQueryWrapper = new QueryWrapper();
            baseOrderAddressQueryWrapper.eq((Object)"document_no", (Object)documentNo);
            baseOrderAddressQueryWrapper.eq((Object)"dr", (Object)"0");
            List baseOrderAddressEos = this.baseOrderAddressDomain.getMapper().selectList((Wrapper)baseOrderAddressQueryWrapper);
            orderAddressEo = baseOrderAddressEos.stream().filter(e -> CsBaseOrderAddressContactsTypeEnum.CONSIGNEE.getCode().equals(e.getContactsType())).findAny().orElse(null);
        }
        if (Objects.nonNull(orderAddressEo) && !CsRelevanceTableNameEnum.CS_TRANSFER_ORDER.getCode().equals(eo.getRelevanceTableName())) {
            ContactDto contactDto = Objects.nonNull(dto.getContactDto()) ? dto.getContactDto() : new ContactDto();
            String country = Objects.nonNull(orderAddressEo.getCountry()) ? orderAddressEo.getCountry() : "";
            contactDto.setAddress(country + orderAddressEo.getProvince() + orderAddressEo.getCity() + orderAddressEo.getDistrict() + orderAddressEo.getDetailAddress());
            contactDto.setReciveName(orderAddressEo.getContacts());
            contactDto.setRecivePhone(orderAddressEo.getPhone());
            dto.setContactDto(contactDto);
        }
        this.buildWarehouseInfo(dto);
        log.info("dto\u54cd\u5e94=>{}", (Object)JSON.toJSONString((Object)dto));
        return new RestResponse((Object)dto);
    }

    private void queryBaseOrderAddressInfo(ReceiveDeliveryNoticeOrderEo eo, CsReceiveNoticeOrderRespDto receiveNoticeOrderRespDto) {
        String documentNo = eo.getDocumentNo();
        QueryWrapper BaseOrderAddressEoQueryWrapper = new QueryWrapper();
        BaseOrderAddressEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        BaseOrderAddressEoQueryWrapper.eq((Object)"document_no", (Object)documentNo);
        List BaseOrderAddressEoList = this.baseOrderAddressDomain.getMapper().selectList((Wrapper)BaseOrderAddressEoQueryWrapper);
        log.info("queryBaseOrderAddressInfo==>\u6536\u8d27\u901a\u77e5\u5355\u67e5\u8be2\u5730\u5740\u4fe1\u606f,BaseOrderAddressEoList:{}", (Object)LogUtils.buildLogContent(BaseOrderAddressEoList));
        if (CollectionUtils.isEmpty((Collection)BaseOrderAddressEoList)) {
            return;
        }
        BaseOrderAddressEo BaseOrderAddressEo2 = (BaseOrderAddressEo)BaseOrderAddressEoList.get(0);
        ContactDto contactDto = new ContactDto();
        contactDto.setReciveName(BaseOrderAddressEo2.getContacts());
        contactDto.setRecivePhone(BaseOrderAddressEo2.getPhone());
        contactDto.setAddress(BaseOrderAddressEo2.getDetailAddress());
        receiveNoticeOrderRespDto.setContactDto(contactDto);
    }

    private void buildWarehouseInfo(CsReceiveNoticeOrderRespDto dto) {
        LogicWarehouseEo receiveLogicWarehouseEo;
        String deliveryWarehouseCode;
        ArrayList warehouseList = Lists.newArrayList();
        String warehouseCode = dto.getWarehouseCode();
        if (StringUtils.isNotBlank((CharSequence)warehouseCode)) {
            warehouseList.add(warehouseCode);
        }
        if (StringUtils.isNotBlank((CharSequence)(deliveryWarehouseCode = dto.getDeliveryWarehouseCode()))) {
            warehouseList.add(deliveryWarehouseCode);
        }
        if (CollectionUtils.isEmpty((Collection)warehouseList)) {
            return;
        }
        Map<String, LogicWarehouseEo> logicWarehouseEoMap = this.getLogicWarehouseEoMap(warehouseList);
        LogicWarehouseEo LogicWarehouseEo2 = logicWarehouseEoMap.get(warehouseCode);
        if (null != LogicWarehouseEo2) {
            dto.setWarehouseName(LogicWarehouseEo2.getWarehouseName());
        }
        if (null != (receiveLogicWarehouseEo = logicWarehouseEoMap.get(deliveryWarehouseCode))) {
            dto.setDeliveryWarehouseName(receiveLogicWarehouseEo.getWarehouseName());
        }
    }

    public Map<String, LogicWarehouseEo> getLogicWarehouseEoMap(List<String> warehouseList) {
        QueryWrapper LogicWarehouseEoQueryWrapper = new QueryWrapper();
        LogicWarehouseEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        LogicWarehouseEoQueryWrapper.in((Object)"warehouse_code", warehouseList);
        LogicWarehouseEoQueryWrapper.eq((Object)"warehouse_status", (Object)CsValidFlagEnum.ENABLE.getCode());
        List LogicWarehouseEoList = this.logicWarehouseDomain.getMapper().selectList((Wrapper)LogicWarehouseEoQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)LogicWarehouseEoList)) {
            return Maps.newHashMap();
        }
        Map<String, LogicWarehouseEo> logicWarehouseEoMap = LogicWarehouseEoList.stream().collect(Collectors.toMap(LogicWarehouseEo::getWarehouseCode, Function.identity()));
        return logicWarehouseEoMap;
    }
}

