/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.basics.ICsInventoryPreSplitService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsInventoryExposedService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsDeliveryNoticeOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsActivityInventoryEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsPhysicsInventoryTotalEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.inventory.CsActivityInventoryMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.inventory.CsPhysicsInventoryTotalMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics.CsInventoryInOutBasicsCargoDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.basics.CsInventoryInOutBasicsDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryInitOperateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateCargoReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryReleasePreemptOperateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.basics.CsInOutBasicsOrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsActivityInventoryStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsDocumentActionEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryCargoTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryInOutEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsWarehouseClassifyEnum;
import com.dtyunxi.yundt.cube.center.inventory.exception.CsInventoryExceptionCode;
import com.github.pagehelper.PageHelper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.inventory.domain.entity.IInventoryLogDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInventoryPreemptionDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicInventoryTotalDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IRelWarehouseDomain;
import com.yunxi.dg.base.center.inventory.dto.calc.PreemptDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDetailDto;
import com.yunxi.dg.base.center.inventory.dto.response.InventoryStatisticNumVo;
import com.yunxi.dg.base.center.inventory.eo.InventoryLogEo;
import com.yunxi.dg.base.center.inventory.eo.InventoryPreemptionEo;
import com.yunxi.dg.base.center.inventory.eo.LogicInventoryTotalEo;
import com.yunxi.dg.base.center.inventory.service.calc.ICalcInventoryService;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.RepeatFilter;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="csInventoryExposedServiceImpl")
public class CsInventoryExposedServiceImpl
implements ICsInventoryExposedService,
ICsInventoryPreSplitService {
    private static final Logger log = LoggerFactory.getLogger(CsInventoryExposedServiceImpl.class);
    @Autowired
    private ICsDeliveryNoticeOrderService csDeliveryNoticeOrderService;
    @Autowired
    private IInventoryPreemptionDomain inventoryPreemptionDomain;
    @Autowired
    private CsActivityInventoryMapper csActivityInventoryMapper;
    @Autowired
    private IRelWarehouseDomain relWarehouseDomain;
    @Autowired
    private RepeatFilter repeatFilter;
    @Autowired
    private ILogicInventoryTotalDomain logicInventoryTotalDomain;
    @Autowired
    private CsPhysicsInventoryTotalMapper csPhysicsInventoryTotalMapper;
    @Autowired
    private IInventoryLogDomain inventoryLogDomain;
    @Autowired
    ICalcInventoryService calcInventoryService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean preemptInventory(CsInventoryOperateReqDto inventoryOperateReqDto) {
        log.info("preemptInventory==>\u5e93\u5b58\u9884\u5360,inventoryOperateReqDto:{}", (Object)LogUtils.buildLogContent(inventoryOperateReqDto));
        this.checkParams(inventoryOperateReqDto);
        this.preemptIdempotentCheck(inventoryOperateReqDto);
        inventoryOperateReqDto.setInOutFlag(CsInventoryInOutEnum.OUT.getCode());
        List operateCargoReqDtoList = inventoryOperateReqDto.getOperateCargoReqDtoList();
        Map<String, List<CsInventoryOperateCargoReqDto>> splitReqCargoMap = this.splitReqCargo(operateCargoReqDtoList);
        log.info("preemptInventory==>\u5e93\u5b58\u9884\u5360,\u533a\u5206\u6d3b\u52a8\u8d27\u54c1\u548c\u666e\u901a\u8d27\u54c1splitReqCargoMap:{}", (Object)LogUtils.buildLogContent(splitReqCargoMap));
        List<CsInventoryOperateCargoReqDto> actCargoList = splitReqCargoMap.get(CsInventoryCargoTypeEnum.ACTIVITY.getCode());
        List<CsInventoryOperateCargoReqDto> commonCargoList = splitReqCargoMap.get(CsInventoryCargoTypeEnum.COMMON.getCode());
        Boolean commonFlag = true;
        Boolean actFlag = true;
        if (CollectionUtils.isNotEmpty(actCargoList)) {
            actFlag = this.preemptActInventory(inventoryOperateReqDto, actCargoList);
        }
        if (CollectionUtils.isNotEmpty(commonCargoList)) {
            commonFlag = this.preemptCommonInventory(inventoryOperateReqDto, commonCargoList);
        }
        if (!commonFlag.booleanValue() || !actFlag.booleanValue()) {
            throw new BizException("\u5e93\u5b58\u9884\u5360\u5931\u8d25");
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean batchPreemptInventory(List<CsInventoryOperateReqDto> inventoryOperateReqDtoList) {
        log.info("batchPreemptInventory==>\u6279\u91cf\u5e93\u5b58\u9884\u5360,inventoryOperateReqDtoList:{}", (Object)LogUtils.buildLogContent(inventoryOperateReqDtoList));
        this.validBatchPreemptInventory(inventoryOperateReqDtoList);
        if (CollectionUtils.isEmpty(inventoryOperateReqDtoList)) {
            return true;
        }
        log.info("batchPreemptInventory==>\u6279\u91cf\u5e93\u5b58\u9884\u5360,\u6821\u9a8c\u6210\u529f");
        this.extracted(inventoryOperateReqDtoList);
        log.info("batchPreemptInventory==>\u6279\u91cf\u5e93\u5b58\u9884\u5360,\u5e93\u5b58\u5224\u65ad\u5145\u8db3\u6210\u529f");
        ArrayList preemptDtoList = Lists.newArrayList();
        for (CsInventoryOperateReqDto csInventoryOperateReqDto : inventoryOperateReqDtoList) {
            PreemptDto preemptParam = new PreemptDto();
            if (StringUtils.contains((CharSequence)csInventoryOperateReqDto.getSourceNo(), (CharSequence)"DD")) {
                preemptParam.setIsSaleOrder(Boolean.valueOf(true));
            }
            preemptParam.setSourceNo(csInventoryOperateReqDto.getSourceNo());
            preemptParam.setSourceType(csInventoryOperateReqDto.getSourceType());
            preemptParam.setBusinessType(csInventoryOperateReqDto.getBusinessType());
            String externalOrderNo = csInventoryOperateReqDto.getPlatformOrderNo();
            if (CsPcpBusinessTypeEnum.INTERNAL_DEAL.getCode().equals(csInventoryOperateReqDto.getBusinessType()) || CsPcpBusinessTypeEnum.INTERNAL_DEAL_RETURN.getCode().equals(csInventoryOperateReqDto.getBusinessType()) || CsPcpBusinessTypeEnum.SALE_RETURN_INTERNAL_DEAL.getCode().equals(csInventoryOperateReqDto.getBusinessType()) || CsPcpBusinessTypeEnum.INTERNAL_DEAL_BA.getCode().equals(csInventoryOperateReqDto.getBusinessType()) || CsPcpBusinessTypeEnum.INTERNAL_DEAL_RETURN_BA.getCode().equals(csInventoryOperateReqDto.getBusinessType()) || CsPcpBusinessTypeEnum.SALE_RETURN_INTERNAL_DEAL_BA.getCode().equals(csInventoryOperateReqDto.getBusinessType())) {
                externalOrderNo = csInventoryOperateReqDto.getSourceNo();
            }
            preemptParam.setExternalOrderNo(externalOrderNo);
            preemptParam.setNoneLineNo(Boolean.valueOf(true));
            ArrayList detailParams = Lists.newArrayList();
            for (CsInventoryOperateCargoReqDto detailReqDto : csInventoryOperateReqDto.getOperateCargoReqDtoList()) {
                CalcDetailDto detailParam = new CalcDetailDto();
                BigDecimal preempt = BigDecimalUtils.abs((BigDecimal)detailReqDto.getChangeInventory());
                detailParam.setNum(preempt);
                detailParam.setSkuCode(detailReqDto.getLongCode());
                detailParam.setLogicWarehouseCode(detailReqDto.getWarehouseCode());
                detailParam.setBatch(detailReqDto.getBatch());
                detailParams.add(detailParam);
                preemptParam.setNoneBatch(Boolean.valueOf(StringUtils.isEmpty((CharSequence)detailReqDto.getBatch())));
                preemptParam.setShoutBatch(Boolean.valueOf(StringUtils.isNotBlank((CharSequence)detailReqDto.getBatch())));
            }
            preemptParam.setDetails((List)detailParams);
            preemptDtoList.add(preemptParam);
        }
        this.calcInventoryService.batchPreempt((List)preemptDtoList);
        log.info("batchPreemptInventory==>\u6279\u91cf\u5e93\u5b58\u9884\u5360,\u6210\u529f");
        return true;
    }

    private void extracted(List<CsInventoryOperateReqDto> inventoryOperateReqDtoList) {
        List<Object> warehouseCodeList = new ArrayList();
        List<Object> cargoCodeList = new ArrayList();
        HashMap<String, BigDecimal> warehouseCargoMap = new HashMap<String, BigDecimal>();
        for (CsInventoryOperateReqDto csInventoryOperateReqDto : inventoryOperateReqDtoList) {
            for (CsInventoryOperateCargoReqDto cargoReqDto : csInventoryOperateReqDto.getOperateCargoReqDtoList()) {
                warehouseCodeList.add(cargoReqDto.getWarehouseCode());
                cargoCodeList.add(cargoReqDto.getLongCode());
                String key = cargoReqDto.getWarehouseCode() + cargoReqDto.getLongCode();
                BigDecimal preempt = (BigDecimal)warehouseCargoMap.get(key);
                warehouseCargoMap.put(key, null != preempt ? preempt.add(cargoReqDto.getChangeInventory()) : cargoReqDto.getChangeInventory());
            }
        }
        warehouseCodeList = warehouseCodeList.stream().distinct().collect(Collectors.toList());
        AssertUtil.isTrue((cargoCodeList = cargoCodeList.stream().distinct().collect(Collectors.toList())).size() < 10000, "\u4e3a\u4e86\u6570\u636e\u5b89\u5168\uff0c\u8bf7\u5c06\u5355\u636e\u8d27\u54c1\u62c6\u5206\u621010000\u4ee5\u4e0b\u5904\u7406");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"warehouse_code", warehouseCodeList);
        queryWrapper.in((Object)"sku_code", cargoCodeList);
        queryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        List LogicInventoryTotalEos = this.logicInventoryTotalDomain.getMapper().selectList((Wrapper)queryWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)LogicInventoryTotalEos), "\u5f85\u9884\u5360\u7684\u5e93\u5b58\u4e0d\u5b58\u5728");
        ArrayList<String> errorList = new ArrayList<String>();
        for (LogicInventoryTotalEo LogicInventoryTotalEo2 : LogicInventoryTotalEos) {
            String key = LogicInventoryTotalEo2.getWarehouseCode() + LogicInventoryTotalEo2.getSkuCode();
            BigDecimal preempt = (BigDecimal)warehouseCargoMap.get(key);
            if (null == preempt || LogicInventoryTotalEo2.getAvailable().compareTo(preempt) >= 0) continue;
            String error = "\u4ed3\u5e93[" + LogicInventoryTotalEo2.getWarehouseCode() + "],\u8d27\u54c1[" + LogicInventoryTotalEo2.getSkuCode() + "];";
            errorList.add(error);
        }
        AssertUtil.isTrue(CollectionUtils.isEmpty(errorList), JSON.toJSONString(errorList) + "\u5e93\u5b58\u4e0d\u8db3");
    }

    private void validBatchPreemptInventory(List<CsInventoryOperateReqDto> inventoryOperateReqDtoList) {
        AssertUtil.isTrue(CollectionUtils.isNotEmpty(inventoryOperateReqDtoList), "\u9884\u5360\u5355\u636e\u4e0d\u5b58\u5728");
        ArrayList<String> sourceNoList = new ArrayList<String>();
        for (CsInventoryOperateReqDto csInventoryOperateReqDto : inventoryOperateReqDtoList) {
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)csInventoryOperateReqDto.getPlatformOrderNo()), "\u5e73\u53f0\u5355\u53f7\u4e0d\u5b58\u5728");
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)csInventoryOperateReqDto.getSourceNo()), "\u6765\u6e90\u5355\u636e\u53f7\u4e0d\u5b58\u5728");
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)csInventoryOperateReqDto.getBusinessType()) && null != CsPcpBusinessTypeEnum.getByCode((String)csInventoryOperateReqDto.getBusinessType()), "\u6765\u6e90\u4e1a\u52a1\u7c7b\u578b\u4e0d\u5b58\u5728");
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)csInventoryOperateReqDto.getSourceSystem()), "\u8bf7\u6307\u5b9a\u6765\u6e90\u7cfb\u7edf");
            AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)csInventoryOperateReqDto.getOperateCargoReqDtoList()), "\u8d27\u54c1\u660e\u7ec6\u4e0d\u5b58\u5728");
            for (CsInventoryOperateCargoReqDto cargoReqDto : csInventoryOperateReqDto.getOperateCargoReqDtoList()) {
                AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)cargoReqDto.getWarehouseCode()), "\u4ed3\u5e93\u4fe1\u606f\u4e0d\u5b58\u5728");
                AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)cargoReqDto.getLongCode()), "\u8d27\u54c1\u7f16\u7801\u4e0d\u5b58\u5728");
                AssertUtil.isTrue(null != cargoReqDto.getChangeInventory() && BigDecimal.ZERO.compareTo(cargoReqDto.getChangeInventory()) < 0, "\u8bf7\u6307\u5b9a\u9884\u5360\u6570\u91cf,\u4e14\u4e3a\u6b63\u6570");
            }
            csInventoryOperateReqDto.setNegativeValidate(null == csInventoryOperateReqDto.getNegativeValidate() ? YesNoEnum.YES.getValue() : csInventoryOperateReqDto.getNegativeValidate());
            sourceNoList.add(csInventoryOperateReqDto.getSourceNo());
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"source_no", sourceNoList);
        queryWrapper.eq((Object)"valid", (Object)CsValidFlagEnum.ENABLE.getCode());
        queryWrapper.eq((Object)"warehouse_classify", (Object)CsWarehouseClassifyEnum.LOGIC.getCode());
        queryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        List InventoryPreemptionEoList = this.inventoryPreemptionDomain.getMapper().selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)InventoryPreemptionEoList)) {
            List sourceNos = InventoryPreemptionEoList.stream().map(InventoryPreemptionEo::getSourceNo).distinct().collect(Collectors.toList());
            log.info("batchPreemptInventory==>\u6279\u91cf\u5e93\u5b58\u9884\u5360,\u6279\u91cf\u9884\u5360\u5355\u636e\u4e2d\u5b58\u5728\u6709\u6548\u9884\u5360,\u5254\u9664sourceNos:{}", (Object)LogUtils.buildLogContent(sourceNos));
            Iterator<CsInventoryOperateReqDto> iterator = inventoryOperateReqDtoList.iterator();
            block2: while (iterator.hasNext()) {
                CsInventoryOperateReqDto operateReqDto = iterator.next();
                for (String sourceNo : sourceNos) {
                    if (!operateReqDto.getSourceNo().equals(sourceNo)) continue;
                    iterator.remove();
                    continue block2;
                }
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean preemptOrderInventory(CsInventoryOperateReqDto inventoryOperateReqDto) {
        log.info("preemptOrderInventory==>\u5e93\u5b58\u9884\u5360\uff0c\u5305\u542b\u5355\u636e\u64cd\u4f5c-\u751f\u6210\u53d1\u8d27\u901a\u77e5\u5355,inventoryOperateReqDto:{}", (Object)LogUtils.buildLogContent(inventoryOperateReqDto));
        Boolean preemptInventoryFlag = true;
        Boolean generateFlag = true;
        preemptInventoryFlag = this.preemptInventory(inventoryOperateReqDto);
        String sourceNo = inventoryOperateReqDto.getSourceNo();
        CompletableFuture.runAsync(() -> {
            log.info("\u5f02\u6b65\u64cd\u4f5c\u5f00\u59cb\uff1a\u751f\u6210\u53d1\u8d27\u901a\u77e5\u5355\uff0csourceNo\uff1a{}", (Object)sourceNo);
            this.csDeliveryNoticeOrderService.generateOutNoticeOrder(sourceNo);
            log.info("\u5f02\u6b65\u64cd\u4f5c\u7ed3\u675f\uff0c\u751f\u6210\u53d1\u8d27\u901a\u77e5\u5355\u5b8c\u6210");
        });
        log.info("preemptOrderInventory==>preemptInventoryFlag:{},generateFlag:{}", (Object)preemptInventoryFlag, (Object)generateFlag);
        if (!preemptInventoryFlag.booleanValue() || !generateFlag.booleanValue()) {
            throw new BizException("\u5e93\u5b58\u9884\u5360\u5931\u8d25");
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public Boolean releaseInventory(CsInventoryOperateReqDto inventoryOperateReqDto, Boolean idempotentCheck) {
        log.info("releaseInventory==>\u5e93\u5b58\u91ca\u653e,inventoryOperateReqDto:{}", (Object)LogUtils.buildLogContent(inventoryOperateReqDto));
        if (idempotentCheck.booleanValue()) {
            this.releaseIdempotentCheck(inventoryOperateReqDto);
        }
        this.checkParams(inventoryOperateReqDto);
        inventoryOperateReqDto.setNegativeValidate(YesNoEnum.NO.getValue());
        inventoryOperateReqDto.setInOutFlag(CsInventoryInOutEnum.IN.getCode());
        List operateCargoReqDtoList = inventoryOperateReqDto.getOperateCargoReqDtoList();
        Map<String, List<CsInventoryOperateCargoReqDto>> splitReqCargoMap = this.splitReqCargo(operateCargoReqDtoList);
        log.info("releaseInventory==>\u5e93\u5b58\u91ca\u653e,\u533a\u5206\u6d3b\u52a8\u8d27\u54c1\u548c\u666e\u901a\u8d27\u54c1splitReqCargoMap:{}", (Object)LogUtils.buildLogContent(splitReqCargoMap));
        List<CsInventoryOperateCargoReqDto> actCargoList = splitReqCargoMap.get(CsInventoryCargoTypeEnum.ACTIVITY.getCode());
        List<CsInventoryOperateCargoReqDto> commonCargoList = splitReqCargoMap.get(CsInventoryCargoTypeEnum.COMMON.getCode());
        Boolean commonFlag = true;
        Boolean actFlag = true;
        if (CollectionUtils.isNotEmpty(actCargoList)) {
            actFlag = this.releaseActInventory(inventoryOperateReqDto, actCargoList);
        }
        if (CollectionUtils.isNotEmpty(commonCargoList)) {
            commonFlag = this.releaseCommonInventory(inventoryOperateReqDto, commonCargoList);
        }
        if (!commonFlag.booleanValue() || !actFlag.booleanValue()) {
            throw new BizException(CsInventoryExceptionCode.INVENTORY_NOT_PREEMPT.getCode(), CsInventoryExceptionCode.INVENTORY_NOT_PREEMPT.getMsg());
        }
        return true;
    }

    @Override
    public Boolean releaseOrderInventory(CsInventoryOperateReqDto inventoryOperateReqDto) {
        log.info("releaseOrderInventory==>\u5e93\u5b58\u91ca\u653e\uff0c\u5305\u542b\u5355\u636e\u64cd\u4f5c-\u53d6\u6d88\u53d1\u8d27\u901a\u77e5\u5355,inventoryOperateReqDto:{}", (Object)LogUtils.buildLogContent(inventoryOperateReqDto));
        Boolean releaseInventoryFlag = true;
        releaseInventoryFlag = this.releaseInventory(inventoryOperateReqDto, true);
        String sourceNo = inventoryOperateReqDto.getSourceNo();
        String sourceType = inventoryOperateReqDto.getSourceType();
        String action = CsDocumentActionEnum.CANCEL_PAY.getCode();
        if (CsInventorySourceTypeEnum.IN_BUSINESS_APPROVE_RELEASE.getCode().equals(sourceType) || CsInventorySourceTypeEnum.IN_FINANCE_APPROVE_RELEASE.getCode().equals(sourceType)) {
            action = CsDocumentActionEnum.AUDIT_ADJUST.getCode();
        }
        this.csDeliveryNoticeOrderService.updateOrderStatus(sourceNo, action);
        if (!releaseInventoryFlag.booleanValue()) {
            throw new BizException("\u5e93\u5b58\u91ca\u653e\u5931\u8d25");
        }
        return true;
    }

    @Override
    public Boolean deductionInventory(CsInventoryOperateReqDto inventoryOperateReqDto) {
        log.info("deductionInventory==>\u5e93\u5b58\u53d1\u8d27\u6263\u51cf,inventoryOperateReqDto:{}", (Object)LogUtils.buildLogContent(inventoryOperateReqDto));
        this.deductionIdempotentCheck(inventoryOperateReqDto);
        this.checkParams(inventoryOperateReqDto);
        inventoryOperateReqDto.setInOutFlag(CsInventoryInOutEnum.OUT.getCode());
        List operateCargoReqDtoList = inventoryOperateReqDto.getOperateCargoReqDtoList();
        Map<String, List<CsInventoryOperateCargoReqDto>> splitReqCargoMap = this.splitReqCargo(operateCargoReqDtoList);
        log.info("deductionInventory==>\u5e93\u5b58\u53d1\u8d27\u6263\u51cf,\u533a\u5206\u6d3b\u52a8\u8d27\u54c1\u548c\u666e\u901a\u8d27\u54c1splitReqCargoMap:{}", (Object)LogUtils.buildLogContent(splitReqCargoMap));
        List<CsInventoryOperateCargoReqDto> actCargoList = splitReqCargoMap.get(CsInventoryCargoTypeEnum.ACTIVITY.getCode());
        List<CsInventoryOperateCargoReqDto> commonCargoList = splitReqCargoMap.get(CsInventoryCargoTypeEnum.COMMON.getCode());
        boolean commonFlag = true;
        boolean actFlag = true;
        if (CollectionUtils.isNotEmpty(actCargoList)) {
            actFlag = this.deductionActInventory(inventoryOperateReqDto, actCargoList);
        }
        if (CollectionUtils.isNotEmpty(commonCargoList)) {
            commonFlag = this.deductionCommonInventory(inventoryOperateReqDto, commonCargoList);
            this.deductionCommonPhysicInventory(inventoryOperateReqDto, commonCargoList);
        }
        if (!commonFlag || !actFlag) {
            throw new BizException("\u5e93\u5b58\u53d1\u8d27\u6263\u51cf\u5931\u8d25");
        }
        return true;
    }

    @Override
    public Boolean initPhysicsInventory(CsInventoryInitOperateReqDto csInventoryInitOperateReqDto) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public Boolean initLogicPhysicsInventory(List<CsInventoryOperateCargoReqDto> operateCargoReqDtoList, String sourceNo) {
        return false;
    }

    @Override
    public void operateInventory(CsInventoryInOutBasicsDto csInventoryInOutBasicsDto) {
        log.info("operateInventory==>\u5165\u5e93\u903b\u8f91\u3001\u7269\u7406\u4ed3\u5e93\u5b58,csInventoryInOutBasicsDto:{}", (Object)LogUtils.buildLogContent(csInventoryInOutBasicsDto));
    }

    @Override
    public void wmsOperateRelInventory(CsInventoryInOutBasicsDto inOutBasicsDto) {
        log.info("wmsOperateRelInventory==>wms\u53d1\u8d27\u56de\u4f20\uff0c\u64cd\u4f5c\u51fa\u5e93,inOutBasicsDto:{}", (Object)LogUtils.buildLogContent(inOutBasicsDto));
    }

    @Override
    public Boolean releaseInventoryByStrategy(CsInventoryOperateReqDto inventoryOperateReqDto) {
        List InventoryPreemptionEoList;
        log.info("releaseInventoryByStrategy==>inventoryOperateReqDto:{}", (Object)LogUtils.buildLogContent(inventoryOperateReqDto));
        this.checkParamByStrategy(inventoryOperateReqDto);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        queryWrapper.eq((Object)"valid", (Object)CsValidFlagEnum.ENABLE.getCode());
        queryWrapper.eq((Object)"source_no", (Object)inventoryOperateReqDto.getSourceNo());
        List releaseStrategyList = inventoryOperateReqDto.getReleaseStrategyList();
        if (CollectionUtils.isNotEmpty((Collection)releaseStrategyList)) {
            queryWrapper.in((Object)"warehouse_classify", (Collection)releaseStrategyList);
        }
        if (CollectionUtils.isEmpty((Collection)(InventoryPreemptionEoList = this.inventoryPreemptionDomain.getMapper().selectList((Wrapper)queryWrapper)))) {
            return true;
        }
        ArrayList batchInventoryPreemptionEoList = Lists.newArrayList();
        ArrayList unBatchInventoryPreemptionEoList = Lists.newArrayList();
        for (InventoryPreemptionEo inventoryPreemptionEo : InventoryPreemptionEoList) {
            String batch = inventoryPreemptionEo.getBatch();
            if (StringUtils.isNotBlank((CharSequence)batch)) {
                batchInventoryPreemptionEoList.add(inventoryPreemptionEo);
                continue;
            }
            unBatchInventoryPreemptionEoList.add(inventoryPreemptionEo);
        }
        if (CollectionUtils.isNotEmpty((Collection)batchInventoryPreemptionEoList)) {
            this.releasePreemptionInfo(batchInventoryPreemptionEoList, inventoryOperateReqDto);
        }
        if (CollectionUtils.isNotEmpty((Collection)unBatchInventoryPreemptionEoList)) {
            this.releasePreemptionInfo(unBatchInventoryPreemptionEoList, inventoryOperateReqDto);
        }
        return true;
    }

    private void releasePreemptionInfo(List<InventoryPreemptionEo> inventoryPreemptionEoList, CsInventoryOperateReqDto inventoryOperateReqDto) {
    }

    private void checkParamByStrategy(CsInventoryOperateReqDto inventoryOperateReqDto) {
        AssertUtil.isTrue(null != inventoryOperateReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String sourceNo = inventoryOperateReqDto.getSourceNo();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)sourceNo), "\u6765\u6e90\u5355\u636e\u53f7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        List releaseStrategyList = inventoryOperateReqDto.getReleaseStrategyList();
        if (CollectionUtils.isNotEmpty((Collection)releaseStrategyList)) {
            AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)releaseStrategyList), "\u5bf9\u5e94\u5e93\u5b58\u7b56\u7565\u96c6\u5408\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            for (String releaseStrategy : releaseStrategyList) {
                AssertUtil.isTrue(null != CsInventorySourceTypeEnum.getByCode((String)releaseStrategy), "\u7b56\u7565\u53c2\u6570\u6709\u8bef");
            }
        }
    }

    @Override
    public Boolean approvePassInventory(CsInventoryOperateReqDto inventoryOperateReqDto) {
        this.operateInventory(inventoryOperateReqDto);
        this.updateOrderDetailBatch(inventoryOperateReqDto);
        return true;
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateOrderDetailBatch(CsInventoryOperateReqDto inventoryOperateReqDto) {
        List operateCargoReqDtoList = inventoryOperateReqDto.getOperateCargoReqDtoList();
        inventoryOperateReqDto.setOperateCargoReqDtoList(operateCargoReqDtoList);
        log.info("approveInventory==>\u5f00\u59cb\u66f4\u65b0\u5355\u636e\u6279\u6b21\u53f7");
        Integer num = this.csDeliveryNoticeOrderService.updateDetailBatch(inventoryOperateReqDto);
        log.info("approveInventory==>\u5b8c\u6210\u66f4\u65b0\u5355\u636e\u6279\u6b21\u53f7,\u66f4\u65b0\u6761\u6570\uff1a{}", (Object)num);
    }

    @Transactional(rollbackFor={Exception.class})
    public void operateInventory(CsInventoryOperateReqDto inventoryOperateReqDto) {
        ArrayList operateCargoReqDtoList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)operateCargoReqDtoList, (Collection)inventoryOperateReqDto.getOperateCargoReqDtoList(), CsInventoryOperateCargoReqDto.class);
        log.info("approveInventory-->\u5ba1\u6279\u5e93\u5b58\u64cd\u4f5c,inventoryOperateReqDto:{}", (Object)LogUtils.buildLogContent(inventoryOperateReqDto));
        this.checkParams(inventoryOperateReqDto);
        String sourceType = inventoryOperateReqDto.getSourceType();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)sourceType) && (CsInventorySourceTypeEnum.OUT_BUSINESS_APPROVE_PREEMPT.getCode().equals(sourceType) || CsInventorySourceTypeEnum.OUT_FINANCE_APPROVE_PREEMPT.getCode().equals(sourceType)), "\u6765\u6e90\u5355\u636e\u7c7b\u578b\u53c2\u6570\u6709\u8bef\uff0c\u53ea\u80fd\u4e3a\u4e1a\u52a1\u5ba1\u6279\u6216\u8005\u8d22\u52a1\u5ba1\u6279");
        this.approvePassInventoryAct(inventoryOperateReqDto);
        this.approvePassInventoryCommon(inventoryOperateReqDto);
        inventoryOperateReqDto.setOperateCargoReqDtoList((List)operateCargoReqDtoList);
    }

    private void approvePassInventoryCommon(CsInventoryOperateReqDto inventoryOperateReqDto) {
        List operateCargoReqDtoList = inventoryOperateReqDto.getOperateCargoReqDtoList();
        ArrayList commonList = Lists.newArrayList();
        for (CsInventoryOperateCargoReqDto commonDto : operateCargoReqDtoList) {
            Long activityId = commonDto.getActivityId();
            if (null != activityId) continue;
            commonList.add(commonDto);
        }
        log.info("approvePassInventoryCommon==>,sourceNo:{},commonList:{}", (Object)inventoryOperateReqDto.getSourceNo(), (Object)LogUtils.buildLogContent(commonList));
        if (CollectionUtils.isEmpty((Collection)commonList)) {
            return;
        }
        String sourceType = inventoryOperateReqDto.getSourceType();
        String releaseSourceType = CsInventorySourceTypeEnum.IN_BUSINESS_APPROVE_RELEASE.getCode();
        if (CsInventorySourceTypeEnum.OUT_FINANCE_APPROVE_PREEMPT.getCode().equals(sourceType)) {
            releaseSourceType = CsInventorySourceTypeEnum.IN_FINANCE_APPROVE_RELEASE.getCode();
        }
        CsInventoryReleasePreemptOperateReqDto releasePreemptOperateReqDto = new CsInventoryReleasePreemptOperateReqDto();
        releasePreemptOperateReqDto.setSourceNo(inventoryOperateReqDto.getSourceNo());
        releasePreemptOperateReqDto.setSourceType(releaseSourceType);
        releasePreemptOperateReqDto.setActivityFlag(YesNoEnum.NO.getValue());
        try {
            Boolean commonApproveReleaseFlag = this.releaseInventoryByPreemption(releasePreemptOperateReqDto);
            log.info("approvePassInventoryCommon==>sourceNo:{},commonApproveReleaseFlag:{}", (Object)inventoryOperateReqDto.getSourceNo(), (Object)commonApproveReleaseFlag);
        }
        catch (BizException ex) {
            if (!CsInventoryExceptionCode.NO_FOUND_PREEMPT_RECORD.getCode().equals(ex.getCode())) {
                throw new BizException(ex.getCode(), ex.getMessage());
            }
            inventoryOperateReqDto.setNegativeValidate(YesNoEnum.YES.getValue());
            log.info("approvePassInventoryCommon==>sourceNo:{},\u9884\u5360\u8bb0\u5f55\u4e0d\u5b58\u5728\u91cd\u65b0\u9884\u5360\uff0c\u7ee7\u7eed\u6267\u884c", (Object)inventoryOperateReqDto.getSourceNo());
        }
        if (StringUtils.isNotBlank((CharSequence)((CsInventoryOperateCargoReqDto)commonList.get(0)).getBatch())) {
            Boolean commonApprovePreemptFlag = this.preemptCommonInventory(inventoryOperateReqDto, commonList);
            log.info("approvePassInventoryCommon==>sourceNo:{},commonApprovePreemptFlag:{}", (Object)inventoryOperateReqDto.getSourceNo(), (Object)commonApprovePreemptFlag);
        }
        commonList.forEach(common -> common.setBatch(null));
        Map<String, List<CsInventoryOperateCargoReqDto>> commonMap = commonList.stream().collect(Collectors.groupingBy(common -> common.getWarehouseCode() + "_" + common.getCargoCode()));
        Set<Map.Entry<String, List<CsInventoryOperateCargoReqDto>>> entrySet = commonMap.entrySet();
        ArrayList updateList = Lists.newArrayList();
        for (Map.Entry<String, List<CsInventoryOperateCargoReqDto>> entry : entrySet) {
            List<CsInventoryOperateCargoReqDto> list = entry.getValue();
            BigDecimal totalChangeInventory = list.stream().map(CsInventoryOperateCargoReqDto::getChangeInventory).reduce(BigDecimal.ZERO, BigDecimal::add);
            CsInventoryOperateCargoReqDto cargoReqDto = list.get(0);
            cargoReqDto.setChangeInventory(totalChangeInventory);
            cargoReqDto.setBatch(null);
            updateList.add(cargoReqDto);
        }
        this.preemptCommonInventory(inventoryOperateReqDto, updateList);
    }

    private void approvePassInventoryAct(CsInventoryOperateReqDto inventoryOperateReqDto) {
        List operateCargoReqDtoList = inventoryOperateReqDto.getOperateCargoReqDtoList();
        ArrayList actList = Lists.newArrayList();
        for (CsInventoryOperateCargoReqDto actDto : operateCargoReqDtoList) {
            Long activityId = actDto.getActivityId();
            if (null == activityId) continue;
            actList.add(actDto);
        }
        log.info("approvePassInventoryAct==>,sourceNo:{},actList:{}", (Object)inventoryOperateReqDto.getSourceNo(), (Object)LogUtils.buildLogContent(actList));
        if (CollectionUtils.isEmpty((Collection)actList)) {
            return;
        }
        Map<Long, String> activityStatusMap = this.queryActivityStatus(actList);
        Iterator iterator = actList.iterator();
        while (iterator.hasNext()) {
            CsInventoryOperateCargoReqDto next = (CsInventoryOperateCargoReqDto)iterator.next();
            if (!CsActivityInventoryStatusEnum.TERMINATE.getCode().equals(activityStatusMap.get(next.getActivityId()))) continue;
            iterator.remove();
            for (CsInventoryOperateCargoReqDto cargoReqDto : inventoryOperateReqDto.getOperateCargoReqDtoList()) {
                if (null == cargoReqDto.getActivityId() || !cargoReqDto.getActivityId().equals(next.getActivityId())) continue;
                log.info("\u8d27\u54c1\uff1a{}\uff0c\u8fc7\u6ee4\u5df2\u7ed3\u675f\u6d3b\u52a8\uff0cactivityId:{}", (Object)next.getCargoCode(), (Object)next.getActivityId());
                cargoReqDto.setActivityId(null);
            }
        }
        if (CollectionUtils.isEmpty((Collection)actList)) {
            return;
        }
        String sourceType = inventoryOperateReqDto.getSourceType();
        String releaseSourceType = CsInventorySourceTypeEnum.IN_ACT_CANCEL_PREEMPT.getCode();
        if (CsInventorySourceTypeEnum.OUT_FINANCE_APPROVE_PREEMPT.getCode().equals(sourceType)) {
            releaseSourceType = CsInventorySourceTypeEnum.IN_ACT_AUDIT_RELEASE.getCode();
        }
        CsInventoryReleasePreemptOperateReqDto releasePreemptOperateReqDto = new CsInventoryReleasePreemptOperateReqDto();
        releasePreemptOperateReqDto.setSourceNo(inventoryOperateReqDto.getSourceNo());
        releasePreemptOperateReqDto.setSourceType(releaseSourceType);
        releasePreemptOperateReqDto.setActivityFlag(YesNoEnum.YES.getValue());
        try {
            Boolean actApproveReleaseFlag = this.releaseInventoryByPreemption(releasePreemptOperateReqDto);
            log.info("approvePassInventoryAct==>sourceNo:{},actApproveReleaseFlag:{}", (Object)inventoryOperateReqDto.getSourceNo(), (Object)actApproveReleaseFlag);
        }
        catch (BizException ex) {
            if (!CsInventoryExceptionCode.NO_FOUND_PREEMPT_RECORD.getCode().equals(ex.getCode())) {
                throw new BizException(ex.getCode(), ex.getMessage());
            }
            inventoryOperateReqDto.setNegativeValidate(YesNoEnum.YES.getValue());
            log.info("approvePassInventoryAct==>sourceNo:{},\u9884\u5360\u8bb0\u5f55\u4e0d\u5b58\u5728\u91cd\u65b0\u9884\u5360\uff0c\u7ee7\u7eed\u6267\u884c", (Object)inventoryOperateReqDto.getSourceNo());
        }
        Boolean preemptActFlag = this.preemptActInventory(inventoryOperateReqDto, actList);
        log.info("approvePassInventoryAct==>sourceNo:{},preemptActFlag:{}", (Object)inventoryOperateReqDto.getSourceNo(), (Object)preemptActFlag);
    }

    @Override
    public Boolean releaseInventoryByPreemption(CsInventoryReleasePreemptOperateReqDto releasePreemptOperateReqDto) {
        log.info("releaseInventoryByPreemption==>\u6839\u636e\u9884\u5360\u8bb0\u5f55\uff0c\u91ca\u653e\u4e4b\u524d\u9884\u5360\u7684\u5e93\u5b58,releasePreemptOperateReqDto:{}", (Object)LogUtils.buildLogContent(releasePreemptOperateReqDto));
        String sourceNo = releasePreemptOperateReqDto.getSourceNo();
        String sourceType = releasePreemptOperateReqDto.getSourceType();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)sourceNo), "\u6765\u6e90\u5355\u53f7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)sourceType), "\u6765\u6e90\u5355\u636e\u7c7b\u578b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        List operateCargoReqDtoList = releasePreemptOperateReqDto.getOperateCargoReqDtoList();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"source_no", (Object)sourceNo);
        queryWrapper.eq((Object)"valid", (Object)CsValidFlagEnum.ENABLE.getCode());
        List includeSourceTypeList = releasePreemptOperateReqDto.getIncludeSourceTypeList();
        if (CollectionUtils.isNotEmpty((Collection)includeSourceTypeList)) {
            queryWrapper.in((Object)"source_type", (Collection)includeSourceTypeList);
        }
        if (CollectionUtils.isNotEmpty((Collection)operateCargoReqDtoList)) {
            List cargoCodeList = operateCargoReqDtoList.stream().filter(dto -> StringUtils.isBlank((CharSequence)dto.getCargoCode())).map(CsInventoryOperateCargoReqDto::getCargoCode).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(cargoCodeList)) {
                queryWrapper.in((Object)"sku_code", cargoCodeList);
            }
            List warehouseCodeList = operateCargoReqDtoList.stream().filter(dto -> StringUtils.isBlank((CharSequence)dto.getWarehouseCode())).map(CsInventoryOperateCargoReqDto::getWarehouseCode).distinct().collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(cargoCodeList)) {
                queryWrapper.in((Object)"warehouse_code", warehouseCodeList);
            }
        }
        Integer activityFlag = releasePreemptOperateReqDto.getActivityFlag();
        if (YesNoEnum.YES.getValue().equals(activityFlag)) {
            queryWrapper.eq((Object)"activity_flag", (Object)YesNoEnum.YES.getValue());
        } else if (YesNoEnum.NO.getValue().equals(activityFlag)) {
            queryWrapper.eq((Object)"activity_flag", (Object)YesNoEnum.NO.getValue());
        }
        queryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        List InventoryPreemptionEoList = this.inventoryPreemptionDomain.getMapper().selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)InventoryPreemptionEoList)) {
            log.error("releasePreemptionInfo==>\u67e5\u8be2\u4e0d\u5230\u9884\u5360\u8bb0\u5f55,sourceNo:{}", (Object)sourceNo);
            throw new BizException(CsInventoryExceptionCode.NO_FOUND_PREEMPT_RECORD.getCode(), "\u67e5\u8be2\u4e0d\u5230\u9884\u5360\u8bb0\u5f55");
        }
        CsInventoryOperateReqDto releaseOperateReqDto = new CsInventoryOperateReqDto();
        releaseOperateReqDto.setSourceNo(releasePreemptOperateReqDto.getSourceNo());
        releaseOperateReqDto.setSourceType(sourceType);
        releaseOperateReqDto.setInOutFlag(CsInventoryInOutEnum.OUT.getCode());
        ArrayList releaseBatchCargoReqDtoList = Lists.newArrayList();
        ArrayList releaseUnBatchCargoReqDtoList = Lists.newArrayList();
        for (InventoryPreemptionEo InventoryPreemptionEo2 : InventoryPreemptionEoList) {
            CsInventoryOperateCargoReqDto releaseCargoReqDto = new CsInventoryOperateCargoReqDto();
            releaseCargoReqDto.setCargoCode(InventoryPreemptionEo2.getSkuCode());
            releaseCargoReqDto.setWarehouseCode(InventoryPreemptionEo2.getWarehouseCode());
            releaseCargoReqDto.setChangeInventory(InventoryPreemptionEo2.getPreemptNum());
            releaseCargoReqDto.setBatch(InventoryPreemptionEo2.getBatch());
            releaseCargoReqDto.setActivityId(InventoryPreemptionEo2.getActivityId());
            if (StringUtils.isNotBlank((CharSequence)releaseCargoReqDto.getBatch())) {
                releaseBatchCargoReqDtoList.add(releaseCargoReqDto);
                continue;
            }
            releaseUnBatchCargoReqDtoList.add(releaseCargoReqDto);
        }
        Boolean releaseBatchInventory = true;
        if (CollectionUtils.isNotEmpty((Collection)releaseBatchCargoReqDtoList)) {
            ArrayList updateList = Lists.newArrayList();
            Map<String, List<CsInventoryOperateCargoReqDto>> cargoMap = releaseBatchCargoReqDtoList.stream().collect(Collectors.groupingBy(dto -> dto.getWarehouseCode() + "_" + dto.getCargoCode() + "_" + dto.getBatch() + "_" + dto.getActivityId()));
            Set<Map.Entry<String, List<CsInventoryOperateCargoReqDto>>> entrySet = cargoMap.entrySet();
            for (Map.Entry<String, List<CsInventoryOperateCargoReqDto>> entry : entrySet) {
                List<CsInventoryOperateCargoReqDto> list = entry.getValue();
                BigDecimal totalChangeInventory = list.stream().map(CsInventoryOperateCargoReqDto::getChangeInventory).reduce(BigDecimal.ZERO, BigDecimal::add);
                CsInventoryOperateCargoReqDto cargoReqDto = list.get(0);
                cargoReqDto.setChangeInventory(totalChangeInventory);
                updateList.add(cargoReqDto);
                releaseOperateReqDto.setOperateCargoReqDtoList((List)updateList);
            }
            releaseBatchInventory = this.releaseInventory(releaseOperateReqDto, false);
        }
        Boolean releaseTotalInventory = true;
        if (CollectionUtils.isNotEmpty((Collection)releaseUnBatchCargoReqDtoList)) {
            ArrayList updateList = Lists.newArrayList();
            Map<String, List<CsInventoryOperateCargoReqDto>> cargoMap = releaseUnBatchCargoReqDtoList.stream().collect(Collectors.groupingBy(dto -> dto.getWarehouseCode() + "_" + dto.getCargoCode() + "_" + dto.getActivityId()));
            Set<Map.Entry<String, List<CsInventoryOperateCargoReqDto>>> entrySet = cargoMap.entrySet();
            for (Map.Entry<String, List<CsInventoryOperateCargoReqDto>> entry : entrySet) {
                List<CsInventoryOperateCargoReqDto> list = entry.getValue();
                BigDecimal totalChangeInventory = list.stream().map(CsInventoryOperateCargoReqDto::getChangeInventory).reduce(BigDecimal.ZERO, BigDecimal::add);
                CsInventoryOperateCargoReqDto cargoReqDto = list.get(0);
                cargoReqDto.setChangeInventory(totalChangeInventory);
                updateList.add(cargoReqDto);
            }
            releaseOperateReqDto.setOperateCargoReqDtoList((List)updateList);
            releaseTotalInventory = this.releaseInventory(releaseOperateReqDto, false);
        }
        if (!releaseBatchInventory.booleanValue() || !releaseTotalInventory.booleanValue()) {
            return false;
        }
        return true;
    }

    public Boolean releaseInventoryByPreemptionApprove(CsInventoryReleasePreemptOperateReqDto releasePreemptOperateReqDto) {
        log.info("releaseInventoryByPreemptionApprove==>\u6839\u636e\u9884\u5360\u8bb0\u5f55\uff0c\u91ca\u653e\u4e4b\u524d\u9884\u5360\u7684\u5e93\u5b58,releasePreemptOperateReqDto:{}", (Object)LogUtils.buildLogContent(releasePreemptOperateReqDto));
        String sourceNo = releasePreemptOperateReqDto.getSourceNo();
        String sourceType = releasePreemptOperateReqDto.getSourceType();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)sourceNo), "\u6765\u6e90\u5355\u53f7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)sourceType), "\u6765\u6e90\u5355\u636e\u7c7b\u578b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        List operateCargoReqDtoList = releasePreemptOperateReqDto.getOperateCargoReqDtoList();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"source_no", (Object)sourceNo);
        queryWrapper.eq((Object)"valid", (Object)CsValidFlagEnum.ENABLE.getCode());
        List includeSourceTypeList = releasePreemptOperateReqDto.getIncludeSourceTypeList();
        if (CollectionUtils.isNotEmpty((Collection)includeSourceTypeList)) {
            queryWrapper.in((Object)"source_type", (Collection)includeSourceTypeList);
        }
        if (CollectionUtils.isNotEmpty((Collection)operateCargoReqDtoList)) {
            List cargoCodeList = operateCargoReqDtoList.stream().filter(dto -> StringUtils.isBlank((CharSequence)dto.getCargoCode())).map(CsInventoryOperateCargoReqDto::getCargoCode).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(cargoCodeList)) {
                queryWrapper.in((Object)"sku_code", cargoCodeList);
            }
            List warehouseCodeList = operateCargoReqDtoList.stream().filter(dto -> StringUtils.isBlank((CharSequence)dto.getWarehouseCode())).map(CsInventoryOperateCargoReqDto::getWarehouseCode).distinct().collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(cargoCodeList)) {
                queryWrapper.in((Object)"warehouse_code", warehouseCodeList);
            }
        }
        Integer activityFlag = releasePreemptOperateReqDto.getActivityFlag();
        if (YesNoEnum.YES.getValue().equals(activityFlag)) {
            queryWrapper.eq((Object)"activity_flag", (Object)YesNoEnum.YES.getValue());
        } else if (YesNoEnum.NO.getValue().equals(activityFlag)) {
            queryWrapper.eq((Object)"activity_flag", (Object)YesNoEnum.NO.getValue());
        }
        queryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        List InventoryPreemptionEoList = this.inventoryPreemptionDomain.getMapper().selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)InventoryPreemptionEoList)) {
            log.error("releaseInventoryByPreemptionApprove==>\u67e5\u8be2\u4e0d\u5230\u9884\u5360\u8bb0\u5f55,sourceNo:{}", (Object)sourceNo);
            throw new BizException("\u67e5\u8be2\u4e0d\u5230\u9884\u5360\u8bb0\u5f55");
        }
        HashMap unBatchMap = Maps.newHashMap();
        ArrayList batchList = Lists.newArrayList();
        CsInventoryOperateReqDto releaseOperateReqDto = new CsInventoryOperateReqDto();
        releaseOperateReqDto.setSourceNo(releasePreemptOperateReqDto.getSourceNo());
        releaseOperateReqDto.setSourceType(sourceType);
        releaseOperateReqDto.setInOutFlag(CsInventoryInOutEnum.OUT.getCode());
        ArrayList releaseCargoReqDtoList = Lists.newArrayList();
        for (InventoryPreemptionEo InventoryPreemptionEo2 : InventoryPreemptionEoList) {
            CsInventoryOperateCargoReqDto releaseCargoReqDto = new CsInventoryOperateCargoReqDto();
            releaseCargoReqDto.setCargoCode(InventoryPreemptionEo2.getSkuCode());
            releaseCargoReqDto.setLongCode(InventoryPreemptionEo2.getSkuCode());
            releaseCargoReqDto.setWarehouseCode(InventoryPreemptionEo2.getWarehouseCode());
            releaseCargoReqDto.setChangeInventory(InventoryPreemptionEo2.getPreemptNum().abs());
            releaseCargoReqDto.setBatch(InventoryPreemptionEo2.getBatch());
            releaseCargoReqDto.setActivityId(InventoryPreemptionEo2.getActivityId());
            releaseCargoReqDtoList.add(releaseCargoReqDto);
            if (StringUtils.isBlank((CharSequence)InventoryPreemptionEo2.getBatch())) {
                String key = InventoryPreemptionEo2.getWarehouseCode() + "_" + InventoryPreemptionEo2.getSkuCode();
                if (unBatchMap.containsKey(key)) continue;
                unBatchMap.put(key, 1);
                continue;
            }
            if (!StringUtils.isNotBlank((CharSequence)InventoryPreemptionEo2.getBatch())) continue;
            batchList.add(releaseCargoReqDto);
        }
        releaseOperateReqDto.setOperateCargoReqDtoList((List)releaseCargoReqDtoList);
        this.formatBatchInfo(batchList, releaseCargoReqDtoList, unBatchMap);
        log.info("releaseInventoryByPreemptionApprove==>\u5373\u5c06\u8c03\u7528\u91ca\u653e\u5e93\u5b58\u7684\u65b9\u6cd5,releaseOperateReqDto:{}", (Object)LogUtils.buildLogContent(releaseOperateReqDto));
        Boolean releaseInventory = this.releaseInventory(releaseOperateReqDto, false);
        return releaseInventory;
    }

    private void formatBatchInfo(List<CsInventoryOperateCargoReqDto> batchList, List<CsInventoryOperateCargoReqDto> releaseCargoReqDtoList, Map<String, Integer> unBatchMap) {
        log.info("formatBatchInfo==>batchList:{}", (Object)LogUtils.buildLogContent(batchList));
        if (CollectionUtils.isEmpty(batchList)) {
            return;
        }
        Map<String, List<CsInventoryOperateCargoReqDto>> cargoOperateBatchListMap = batchList.stream().collect(Collectors.groupingBy(dto -> dto.getWarehouseCode() + "_" + dto.getCargoCode()));
        ListIterator<CsInventoryOperateCargoReqDto> listIterator = releaseCargoReqDtoList.listIterator();
        while (listIterator.hasNext()) {
            List<CsInventoryOperateCargoReqDto> csInventoryOperateCargoReqDtoList;
            String key;
            CsInventoryOperateCargoReqDto cargoReqDto = listIterator.next();
            String batch = cargoReqDto.getBatch();
            if (StringUtils.isBlank((CharSequence)batch) || unBatchMap.containsKey(key = cargoReqDto.getWarehouseCode() + "_" + cargoReqDto.getCargoCode()) || CollectionUtils.isEmpty(csInventoryOperateCargoReqDtoList = cargoOperateBatchListMap.get(key))) continue;
            unBatchMap.put(key, 1);
            BigDecimal batchPreemptVal = csInventoryOperateCargoReqDtoList.stream().map(CsInventoryOperateCargoReqDto::getChangeInventory).reduce(BigDecimal.ZERO, BigDecimal::add);
            CsInventoryOperateCargoReqDto operateCargoReqDto = csInventoryOperateCargoReqDtoList.get(0);
            CsInventoryOperateCargoReqDto totalOperateCargoReqDto = new CsInventoryOperateCargoReqDto();
            CubeBeanUtils.copyProperties((Object)totalOperateCargoReqDto, (Object)operateCargoReqDto, (String[])new String[0]);
            totalOperateCargoReqDto.setBatch(null);
            totalOperateCargoReqDto.setChangeInventory(batchPreemptVal.abs());
            listIterator.add(totalOperateCargoReqDto);
        }
    }

    private void checkParams(CsInventoryInitOperateReqDto csInventoryInitOperateReqDto) {
        AssertUtil.isTrue(null != csInventoryInitOperateReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        List warehouseCodeList = csInventoryInitOperateReqDto.getWarehouseCodeList();
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)warehouseCodeList), "\u4ed3\u5e93\u7f16\u7801\u96c6\u5408\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(warehouseCodeList.size() <= 200, "\u5355\u6b21\u64cd\u4f5c\u5e93\u5b58\u96c6\u5408\u5927\u5c0f\u6700\u5927\u9650\u5236\u4e3a200");
        List operateDetailReqDtoList = csInventoryInitOperateReqDto.getOperateCargoReqDtoList();
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)operateDetailReqDtoList), "\u8d27\u54c1\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        for (CsInventoryOperateCargoReqDto inventoryOperateDetailReqDto : operateDetailReqDtoList) {
            String cargoCode = inventoryOperateDetailReqDto.getCargoCode();
            String longCode = inventoryOperateDetailReqDto.getLongCode();
            if (StringUtils.isNotBlank((CharSequence)cargoCode) && StringUtils.isBlank((CharSequence)longCode)) {
                inventoryOperateDetailReqDto.setLongCode(cargoCode);
            }
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)inventoryOperateDetailReqDto.getLongCode()), "\u5546\u54c1\u957f\u7f16\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtil.isTrue(null != inventoryOperateDetailReqDto.getChangeInventory(), "\u53d8\u52a8\u5e93\u5b58\u6570\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void checkParams2(List<CsInventoryOperateCargoReqDto> operateCargoReqDtoList) {
        AssertUtil.isTrue(CollectionUtils.isNotEmpty(operateCargoReqDtoList), "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(operateCargoReqDtoList.size() <= 10000, "\u5355\u6b21\u64cd\u4f5c\u5e93\u5b58\u96c6\u5408\u5927\u5c0f\u6700\u5927\u9650\u5236\u4e3a10000");
        for (CsInventoryOperateCargoReqDto inventoryOperateDetailReqDto : operateCargoReqDtoList) {
            String cargoCode = inventoryOperateDetailReqDto.getCargoCode();
            String longCode = inventoryOperateDetailReqDto.getLongCode();
            if (StringUtils.isNotBlank((CharSequence)cargoCode) && StringUtils.isBlank((CharSequence)longCode)) {
                inventoryOperateDetailReqDto.setLongCode(cargoCode);
            }
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)inventoryOperateDetailReqDto.getWarehouseCode()), "\u4ed3\u5e93\u7f16\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)inventoryOperateDetailReqDto.getLongCode()), "\u5546\u54c1\u957f\u7f16\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)inventoryOperateDetailReqDto.getBatch()), "\u8d27\u54c1\u6279\u6b21\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtil.isTrue(null != inventoryOperateDetailReqDto.getChangeInventory(), "\u53d8\u52a8\u5e93\u5b58\u6570\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private Boolean deductionActInventory(CsInventoryOperateReqDto inventoryOperateReqDto, List<CsInventoryOperateCargoReqDto> actCargoList) {
        return true;
    }

    private void deductionActInventoryCalculate(CsInventoryOperateCargoReqDto cargoDto, CsInventoryInOutBasicsCargoDto actBasicsCargoDto, CsInventoryInOutBasicsCargoDto logicBasicsCargoDto, CsInventoryInOutBasicsCargoDto physicsBasicsCargoDto, String finishFlag) {
        log.info("deductionActInventoryCalculate==>cargoDto:{}", (Object)LogUtils.buildLogContent(cargoDto));
        if (CsActivityInventoryStatusEnum.ONGOING.getCode().equals(finishFlag)) {
            physicsBasicsCargoDto.setBalance(cargoDto.getChangeInventory().abs().negate());
            logicBasicsCargoDto.setBalance(cargoDto.getChangeInventory().abs().negate());
            logicBasicsCargoDto.setActivityAllocate(cargoDto.getChangeInventory().abs().negate());
            actBasicsCargoDto.setBalance(cargoDto.getChangeInventory().abs().negate());
            actBasicsCargoDto.setPreempt(cargoDto.getChangeInventory().abs().negate());
        } else if (CsActivityInventoryStatusEnum.TERMINATE.getCode().equals(finishFlag)) {
            physicsBasicsCargoDto.setBalance(cargoDto.getChangeInventory().abs().negate());
            logicBasicsCargoDto.setBalance(cargoDto.getChangeInventory().abs().negate());
            logicBasicsCargoDto.setActivityAllocate(cargoDto.getChangeInventory().abs().negate());
        }
    }

    private Map<Long, String> queryActivityStatus(List<CsInventoryOperateCargoReqDto> actCargoList) {
        List activityIds = actCargoList.stream().map(CsInventoryOperateCargoReqDto::getActivityId).distinct().collect(Collectors.toList());
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"activity_id", activityIds);
        wrapper.groupBy((Object)"activity_id");
        List csActivityInventoryEos = this.csActivityInventoryMapper.selectList((Wrapper)wrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)csActivityInventoryEos), "\u6d3b\u52a8\u4e0d\u5b58\u5728");
        Map<Long, String> activityStatusMap = csActivityInventoryEos.stream().collect(Collectors.toMap(CsActivityInventoryEo::getActivityId, CsActivityInventoryEo::getFinishFlag));
        return activityStatusMap;
    }

    private void joinCargoList(List<CsInventoryOperateCargoReqDto> actCargoList, Map<Long, String> activityStatusMap, List<CsInventoryInOutBasicsCargoDto> activityList, List<CsInventoryInOutBasicsCargoDto> logicList, List<CsInventoryInOutBasicsCargoDto> physicList) {
        for (CsInventoryOperateCargoReqDto cargoReqDto : actCargoList) {
            CsInventoryInOutBasicsCargoDto inOutBasicsCargoDto = new CsInventoryInOutBasicsCargoDto();
            inOutBasicsCargoDto.setWarehouseCode(cargoReqDto.getWarehouseCode());
            inOutBasicsCargoDto.setBatch(cargoReqDto.getBatch());
            inOutBasicsCargoDto.setExpireTime(cargoReqDto.getExpireTime());
            inOutBasicsCargoDto.setProduceTime(cargoReqDto.getProduceTime());
            inOutBasicsCargoDto.setCargoCode(cargoReqDto.getCargoCode());
            inOutBasicsCargoDto.setLongCode(cargoReqDto.getLongCode());
            inOutBasicsCargoDto.setActivityFlag(YesNoEnum.YES.getValue());
            inOutBasicsCargoDto.setActivityId(cargoReqDto.getActivityId());
            inOutBasicsCargoDto.setBalance(cargoReqDto.getChangeInventory().abs().negate());
            inOutBasicsCargoDto.setCompleted(cargoReqDto.getChangeInventory().abs());
            CsInventoryInOutBasicsCargoDto inOutBasicsCargoDto1 = new CsInventoryInOutBasicsCargoDto();
            CubeBeanUtils.copyProperties((Object)inOutBasicsCargoDto1, (Object)inOutBasicsCargoDto, (String[])new String[0]);
            if (CsActivityInventoryStatusEnum.ONGOING.getCode().equals(activityStatusMap.get(cargoReqDto.getActivityId()))) {
                CsInventoryInOutBasicsCargoDto inOutBasicsCargoDto2 = new CsInventoryInOutBasicsCargoDto();
                CubeBeanUtils.copyProperties((Object)inOutBasicsCargoDto2, (Object)inOutBasicsCargoDto, (String[])new String[0]);
                inOutBasicsCargoDto.setPreempt(cargoReqDto.getChangeInventory().abs().negate());
                activityList.add(inOutBasicsCargoDto);
                inOutBasicsCargoDto2.setActivityAllocate(cargoReqDto.getChangeInventory().abs().negate());
                logicList.add(inOutBasicsCargoDto2);
            } else {
                inOutBasicsCargoDto.setPreempt(cargoReqDto.getChangeInventory().abs().negate());
                logicList.add(inOutBasicsCargoDto);
            }
            inOutBasicsCargoDto1.setAvailable(cargoReqDto.getChangeInventory().abs().negate());
            physicList.add(inOutBasicsCargoDto1);
        }
    }

    private Boolean deductionCommonInventory(CsInventoryOperateReqDto inventoryOperateReqDto, List<CsInventoryOperateCargoReqDto> commonCargoList) {
        log.info("deductionCommonInventory==>\u6263\u51cf\u903b\u8f91\u4ed3\u5e93\u5b58,inventoryOperateReqDto:{},commonCargoList:{}", (Object)LogUtils.buildLogContent(inventoryOperateReqDto), (Object)LogUtils.buildLogContent(commonCargoList));
        return false;
    }

    private Boolean deductionCommonPhysicInventory(CsInventoryOperateReqDto inventoryOperateReqDto, List<CsInventoryOperateCargoReqDto> commonCargoList) {
        return false;
    }

    private Boolean releaseActInventory(CsInventoryOperateReqDto inventoryOperateReqDto, List<CsInventoryOperateCargoReqDto> actCargoList) {
        return false;
    }

    private void joinCargoListToRelease(List<CsInventoryOperateCargoReqDto> actCargoList, Map<Long, String> activityStatusMap, List<CsInventoryInOutBasicsCargoDto> activityList, List<CsInventoryInOutBasicsCargoDto> logicList) {
        for (CsInventoryOperateCargoReqDto cargoReqDto : actCargoList) {
            CsInventoryInOutBasicsCargoDto inOutBasicsCargoDto = new CsInventoryInOutBasicsCargoDto();
            inOutBasicsCargoDto.setWarehouseCode(cargoReqDto.getWarehouseCode());
            inOutBasicsCargoDto.setBatch(cargoReqDto.getBatch());
            inOutBasicsCargoDto.setExpireTime(cargoReqDto.getExpireTime());
            inOutBasicsCargoDto.setProduceTime(cargoReqDto.getProduceTime());
            inOutBasicsCargoDto.setCargoCode(cargoReqDto.getCargoCode());
            inOutBasicsCargoDto.setLongCode(cargoReqDto.getLongCode());
            inOutBasicsCargoDto.setActivityFlag(YesNoEnum.YES.getValue());
            inOutBasicsCargoDto.setActivityId(cargoReqDto.getActivityId());
            if (CsActivityInventoryStatusEnum.ONGOING.getCode().equals(activityStatusMap.get(cargoReqDto.getActivityId()))) {
                inOutBasicsCargoDto.setPreempt(cargoReqDto.getChangeInventory().abs().negate());
                inOutBasicsCargoDto.setAvailable(cargoReqDto.getChangeInventory().abs());
                activityList.add(inOutBasicsCargoDto);
                continue;
            }
            inOutBasicsCargoDto.setPreempt(cargoReqDto.getChangeInventory().abs().negate());
            inOutBasicsCargoDto.setAvailable(cargoReqDto.getChangeInventory().abs());
            logicList.add(inOutBasicsCargoDto);
        }
    }

    private Boolean releaseCommonInventory(CsInventoryOperateReqDto inventoryOperateReqDto, List<CsInventoryOperateCargoReqDto> commonCargoList) {
        log.info("preemptInventory==>\u91ca\u653e\u9884\u5360\u7684\u903b\u8f91\u4ed3\u5e93\u5b58,inventoryOperateReqDto:{},commonCargoList:{}", (Object)LogUtils.buildLogContent(inventoryOperateReqDto), (Object)LogUtils.buildLogContent(commonCargoList));
        return false;
    }

    private Boolean preemptActInventory(CsInventoryOperateReqDto inventoryOperateReqDto, List<CsInventoryOperateCargoReqDto> actCargoList) {
        return false;
    }

    private List<CsInventoryOperateCargoReqDto> prepositionActCargoInfo(CsInventoryOperateReqDto inventoryOperateReqDto, List<CsInventoryOperateCargoReqDto> actCargoList) {
        log.info("prepositionActiCargoInfo==>sourceNo:{},actCargoList:{}", (Object)inventoryOperateReqDto.getSourceNo(), (Object)LogUtils.buildLogContent(actCargoList));
        if (CollectionUtils.isEmpty(actCargoList)) {
            return Lists.newArrayList();
        }
        List activityIdList = actCargoList.stream().map(CsInventoryOperateCargoReqDto::getActivityId).distinct().collect(Collectors.toList());
        List cargoCodeList = actCargoList.stream().map(CsInventoryOperateCargoReqDto::getCargoCode).distinct().collect(Collectors.toList());
        List warehouseCodeList = actCargoList.stream().map(CsInventoryOperateCargoReqDto::getWarehouseCode).distinct().collect(Collectors.toList());
        QueryWrapper actQueryWrapper = new QueryWrapper();
        actQueryWrapper.in((Object)"cargo_code", cargoCodeList);
        actQueryWrapper.in((Object)"activity_id", activityIdList);
        actQueryWrapper.in((Object)"warehouse_code", warehouseCodeList);
        actQueryWrapper.gt((Object)"available", (Object)BigDecimal.ZERO);
        List activityInventoryEoList = this.csActivityInventoryMapper.selectList((Wrapper)actQueryWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)activityInventoryEoList), "\u67e5\u8be2\u4e0d\u5230\u6d3b\u52a8\u8d27\u54c1\u4fe1\u606f");
        Map<String, List<CsActivityInventoryEo>> csActEoMap = activityInventoryEoList.stream().collect(Collectors.groupingBy(eo -> eo.getActivityId() + "_" + eo.getWarehouseCode() + "_" + eo.getCargoCode()));
        log.info("prepositionActCargoInfo==>\u5206\u7ec4\u540e\u7684\u4fe1\u606f,sourceNo:{},csActEoMap:{}", (Object)inventoryOperateReqDto.getSourceNo(), (Object)LogUtils.buildLogContent(csActEoMap));
        ArrayList csInventoryOperateCargoReqDtoList = Lists.newArrayList();
        block0: for (CsInventoryOperateCargoReqDto cargoReqDto : actCargoList) {
            String key = cargoReqDto.getActivityId() + "_" + cargoReqDto.getWarehouseCode() + "_" + cargoReqDto.getCargoCode();
            List<CsActivityInventoryEo> csActivityInventoryEoList = csActEoMap.get(key);
            if (CollectionUtils.isEmpty(csActivityInventoryEoList)) continue;
            List actBalanceList = csActivityInventoryEoList.stream().sorted(Comparator.comparing(CsActivityInventoryEo::getAvailable).reversed()).collect(Collectors.toList());
            CsActivityInventoryEo csActivityInventoryEo = csActivityInventoryEoList.get(0);
            BigDecimal changeInventory = cargoReqDto.getChangeInventory();
            BigDecimal totalBatchSurplus = csActivityInventoryEoList.stream().map(CsActivityInventoryEo::getAvailable).reduce(BigDecimal.ZERO, BigDecimal::add);
            log.info("prepositionActCargoInfo==>totalBatchSurplus:{}", (Object)totalBatchSurplus);
            if (changeInventory.compareTo(totalBatchSurplus) > 0) {
                log.info("\u5355\u636e\u53f7sourceNo:{},\u8d27\u54c1cargoCode:{}\u6d3b\u52a8\u5269\u4f59\u5e93\u5b58\u4e0d\u8db3,activityCode:{}", new Object[]{inventoryOperateReqDto.getSourceNo(), csActivityInventoryEo.getCargoCode(), csActivityInventoryEo.getCargoCode()});
                throw new BizException(String.format("\u8d27\u54c1\u3010%s\u3011\u6d3b\u52a8\u5269\u4f59\u5e93\u5b58\u4e0d\u8db3", csActivityInventoryEo.getCargoName()));
            }
            for (CsActivityInventoryEo actEo : actBalanceList) {
                BigDecimal available = actEo.getAvailable();
                BigDecimal subtract = available.subtract(changeInventory);
                log.info("prepositionActCargoInfo==>\u6570\u636e\u5bf9\u6bd4,sourceNo:{},available:{},subtract:{},changeInventory:{}", new Object[]{inventoryOperateReqDto.getSourceNo(), available, subtract, changeInventory});
                int compareVal = subtract.compareTo(BigDecimal.ZERO);
                CsInventoryOperateCargoReqDto batchReqDto = new CsInventoryOperateCargoReqDto();
                CubeBeanUtils.copyProperties((Object)batchReqDto, (Object)cargoReqDto, (String[])new String[0]);
                if (StringUtils.isBlank((CharSequence)cargoReqDto.getBatch())) {
                    batchReqDto.setBatch(actEo.getBatch());
                }
                csInventoryOperateCargoReqDtoList.add(batchReqDto);
                if (compareVal >= 0) {
                    batchReqDto.setChangeInventory(changeInventory);
                    continue block0;
                }
                if (compareVal >= 0) continue;
                batchReqDto.setChangeInventory(available);
                changeInventory = subtract.abs();
            }
        }
        return csInventoryOperateCargoReqDtoList;
    }

    @Override
    public Boolean preemptCommonInventory(CsInventoryOperateReqDto inventoryOperateReqDto, List<CsInventoryOperateCargoReqDto> commonCargoList) {
        return false;
    }

    @Override
    public Boolean dealInventory(CsInventoryInOutBasicsDto csInventoryInOutBasicsDto, List<CsInOutBasicsOrderDetailRespDto> inventoryList, String warehouseCode, String strategy) {
        return false;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public Integer updateInventoryTotalBalance(String preOrderNo, String type) {
        List<InventoryLogEo> inventoryLogEoList = this.updateLogicInventoryTotalBalance(preOrderNo, type);
        if (CollectionUtils.isEmpty(inventoryLogEoList)) {
            return 0;
        }
        this.updatePhysicsInventoryTotalBalance(preOrderNo, type, inventoryLogEoList);
        this.inventoryLogDomain.insertBatch(inventoryLogEoList);
        return inventoryLogEoList.size();
    }

    private void updatePhysicsInventoryTotalBalance(String preOrderNo, String type, List<InventoryLogEo> inventoryLogEoList) {
        List statisticNumVoList = this.csPhysicsInventoryTotalMapper.queryPhysicsInventoryTotalBalance();
        if (CollectionUtils.isNotEmpty((Collection)statisticNumVoList)) {
            for (InventoryStatisticNumVo inventoryStatisticNumVo : statisticNumVoList) {
                CsPhysicsInventoryTotalEo csPhysicsInventoryTotalEo = new CsPhysicsInventoryTotalEo();
                csPhysicsInventoryTotalEo.setId(inventoryStatisticNumVo.getId());
                csPhysicsInventoryTotalEo.setBalance(inventoryStatisticNumVo.getAfterBalance());
                this.csPhysicsInventoryTotalMapper.updateById((BaseEo)csPhysicsInventoryTotalEo);
                InventoryLogEo InventoryLogEo2 = new InventoryLogEo();
                BeanUtils.copyProperties((Object)inventoryStatisticNumVo, (Object)InventoryLogEo2, (String[])new String[]{"id", "beforePreempt"});
                InventoryLogEo2.setChangeBalance(InventoryLogEo2.getAfterBalance().subtract(InventoryLogEo2.getBeforeBalance()));
                InventoryLogEo2.setSourceNo(preOrderNo);
                InventoryLogEo2.setSourceType(type);
                InventoryLogEo2.setWarehouseClassify(CsWarehouseClassifyEnum.PHYSICS.getCode());
                inventoryLogEoList.add(InventoryLogEo2);
            }
        }
    }

    private List<InventoryLogEo> updateLogicInventoryTotalBalance(String preOrderNo, String type) {
        ArrayList inventoryLogEoList = Lists.newArrayList();
        List statisticNumVoList = this.logicInventoryTotalDomain.queryLogicInventoryTotalBalance();
        if (CollectionUtils.isEmpty((Collection)statisticNumVoList)) {
            return null;
        }
        Date nowDate = new Date();
        for (InventoryStatisticNumVo inventoryStatisticNumVo : statisticNumVoList) {
            LogicInventoryTotalEo LogicInventoryTotalEo2 = new LogicInventoryTotalEo();
            LogicInventoryTotalEo2.setId(inventoryStatisticNumVo.getId());
            LogicInventoryTotalEo2.setBalance(inventoryStatisticNumVo.getAfterBalance());
            this.logicInventoryTotalDomain.getMapper().updateById((BaseEo)LogicInventoryTotalEo2);
            InventoryLogEo InventoryLogEo2 = new InventoryLogEo();
            BeanUtils.copyProperties((Object)inventoryStatisticNumVo, (Object)InventoryLogEo2, (String[])new String[]{"id", "beforePreempt"});
            InventoryLogEo2.setChangeBalance(InventoryLogEo2.getAfterBalance().subtract(InventoryLogEo2.getBeforeBalance()));
            InventoryLogEo2.setSourceNo(preOrderNo);
            InventoryLogEo2.setSourceType(type);
            InventoryLogEo2.setWarehouseClassify(CsWarehouseClassifyEnum.LOGIC.getCode());
            InventoryLogEo2.setChangeTime(nowDate);
            inventoryLogEoList.add(InventoryLogEo2);
        }
        return inventoryLogEoList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public Integer updateInventoryTotalPreempt(String preOrderNo, String type) {
        List<InventoryLogEo> inventoryLogEoList = this.updateLogicInventoryTotalPreempt(preOrderNo, type);
        if (CollectionUtils.isEmpty(inventoryLogEoList)) {
            return 0;
        }
        this.inventoryLogDomain.insertBatch(inventoryLogEoList);
        return inventoryLogEoList.size();
    }

    private List<InventoryLogEo> updateLogicInventoryTotalPreempt(String preOrderNo, String type) {
        List statisticNumVoList = this.logicInventoryTotalDomain.queryInventoryTotalPreempt();
        if (CollectionUtils.isEmpty((Collection)statisticNumVoList)) {
            return null;
        }
        ArrayList inventoryLogEoList = Lists.newArrayList();
        Date nowDate = new Date();
        for (InventoryStatisticNumVo inventoryStatisticNumVo : statisticNumVoList) {
            if (inventoryStatisticNumVo.getBeforeBalance().compareTo(inventoryStatisticNumVo.getAfterPreempt()) < 0) continue;
            LogicInventoryTotalEo LogicInventoryTotalEo2 = new LogicInventoryTotalEo();
            LogicInventoryTotalEo2.setId(inventoryStatisticNumVo.getId());
            LogicInventoryTotalEo2.setPreempt(inventoryStatisticNumVo.getAfterPreempt());
            this.logicInventoryTotalDomain.getMapper().updateById((BaseEo)LogicInventoryTotalEo2);
            InventoryLogEo InventoryLogEo2 = new InventoryLogEo();
            BeanUtils.copyProperties((Object)inventoryStatisticNumVo, (Object)InventoryLogEo2, (String[])new String[]{"id", "beforeBalance"});
            InventoryLogEo2.setChangePreempt(InventoryLogEo2.getAfterPreempt().subtract(InventoryLogEo2.getBeforePreempt()));
            InventoryLogEo2.setSourceNo(preOrderNo);
            InventoryLogEo2.setSourceType(type);
            InventoryLogEo2.setChangeTime(nowDate);
            InventoryLogEo2.setWarehouseClassify(CsWarehouseClassifyEnum.LOGIC.getCode());
            inventoryLogEoList.add(InventoryLogEo2);
        }
        return inventoryLogEoList;
    }

    private void checkParams(CsInventoryOperateReqDto inventoryOperateReqDto) {
        AssertUtil.isTrue(null != inventoryOperateReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)inventoryOperateReqDto.getSourceNo()), "\u6765\u6e90\u5355\u636e\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)inventoryOperateReqDto.getSourceType()), "\u6765\u6e90\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Integer negativeValidate = inventoryOperateReqDto.getNegativeValidate();
        if (null == negativeValidate) {
            negativeValidate = YesNoEnum.YES.getValue();
        }
        AssertUtil.isTrue(YesNoEnum.YES.getValue().equals(negativeValidate) || YesNoEnum.NO.getValue().equals(negativeValidate), "\u662f\u5426\u6821\u9a8c\u8d1f\u5e93\u5b58\u53c2\u6570\u6709\u8bef");
        List operateDetailReqDtoList = inventoryOperateReqDto.getOperateCargoReqDtoList();
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)operateDetailReqDtoList), "\u8d27\u54c1\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        for (CsInventoryOperateCargoReqDto inventoryOperateDetailReqDto : operateDetailReqDtoList) {
            String cargoCode = inventoryOperateDetailReqDto.getCargoCode();
            String longCode = inventoryOperateDetailReqDto.getLongCode();
            if (StringUtils.isNotBlank((CharSequence)cargoCode) && StringUtils.isBlank((CharSequence)longCode)) {
                inventoryOperateDetailReqDto.setLongCode(cargoCode);
            }
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)inventoryOperateDetailReqDto.getLongCode()), "\u5546\u54c1\u957f\u7f16\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)inventoryOperateDetailReqDto.getWarehouseCode()), "\u4ed3\u5e93\u7f16\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtil.isTrue(null != inventoryOperateDetailReqDto.getChangeInventory(), "\u53d8\u52a8\u5e93\u5b58\u6570\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void releaseIdempotentCheck(CsInventoryOperateReqDto inventoryOperateReqDto) {
        String sourceNo = inventoryOperateReqDto.getSourceNo();
        this.repeatFilter.checkRepeat("RELEASE_INVENTORY:" + sourceNo + inventoryOperateReqDto.getSourceType() + inventoryOperateReqDto.getSuffix(), () -> this.releasePreValid(sourceNo), true);
    }

    private void deductionIdempotentCheck(CsInventoryOperateReqDto inventoryOperateReqDto) {
        String sourceNo = inventoryOperateReqDto.getSourceNo();
        this.repeatFilter.checkRepeat("DEDUCTION_INVENTORY:" + sourceNo + inventoryOperateReqDto.getSourceType() + inventoryOperateReqDto.getSuffix(), () -> this.releasePreValid(sourceNo), true);
    }

    private void releasePreValid(String sourceNo) {
        QueryWrapper inventoryPreemptionEoQueryWrapper = new QueryWrapper();
        inventoryPreemptionEoQueryWrapper.eq((Object)"source_no", (Object)sourceNo);
        inventoryPreemptionEoQueryWrapper.eq((Object)"valid", (Object)CsValidFlagEnum.ENABLE);
        inventoryPreemptionEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        PageHelper.startPage((int)1, (int)1);
        List InventoryPreemptionEoList = this.inventoryPreemptionDomain.getMapper().selectList((Wrapper)inventoryPreemptionEoQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)InventoryPreemptionEoList)) {
            throw new BizException("\u6b64\u5355\u636e\u4e0d\u5b58\u5728\u9884\u5360\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u91ca\u653e\u53d1\u8d27");
        }
    }

    private void preemptIdempotentCheck(CsInventoryOperateReqDto inventoryOperateReqDto) {
        String sourceNo = inventoryOperateReqDto.getSourceNo();
        this.repeatFilter.checkRepeat("PREEMPT_INVENTORY:" + sourceNo + inventoryOperateReqDto.getSourceType() + inventoryOperateReqDto.getSuffix(), () -> this.preemptPreValid(sourceNo), true);
    }

    private void preemptPreValid(String sourceNo) {
        List InventoryPreemptionEoList = this.inventoryPreemptionDomain.queryBySourceNo(sourceNo, CsValidFlagEnum.ENABLE.getCode());
        if (CollectionUtils.isNotEmpty((Collection)InventoryPreemptionEoList)) {
            throw new BizException("\u6b64\u5355\u636e\u5df2\u8fdb\u884c\u9884\u5360\u64cd\u4f5c\uff0c\u4e0d\u80fd\u91cd\u590d\u9884\u5360");
        }
    }

    @Override
    public Map<String, List<CsInventoryOperateCargoReqDto>> splitReqCargo(List<CsInventoryOperateCargoReqDto> paramsList) {
        return ICsInventoryPreSplitService.super.splitReqCargo(paramsList);
    }
}

