/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.adapter.bd;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.biz.adapter.CsInventoryExposedApiImpl;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.commons.IOrderPreemptWrapperHelper;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.ThirdWarehouseMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateCargoReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryReleasePreemptOperateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsDocumentActionEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsDocumentTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.bd.CsOutNoticePushStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.exception.CsInventoryExceptionCode;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInventoryPreemptionDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.calc.PreemptDto;
import com.yunxi.dg.base.center.inventory.dto.calc.ReleasePreemptDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDetailDto;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderCallBack;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderFacade;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderBaseContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.ReceiveDeliveryNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.BaseOrderCommonCancelBo;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.ReceiveDeliveryNoticeOrderFacadeBo;
import com.yunxi.dg.base.center.inventory.service.calc.ICalcInventoryService;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bd_InventoryExposedApi")
public class BdCsInventoryExposedApiImpl
extends CsInventoryExposedApiImpl {
    private Logger logger = LoggerFactory.getLogger(BdCsInventoryExposedApiImpl.class);
    @Resource
    private ICalcInventoryService calcInventoryService;
    @Autowired
    private BaseOrderFacade baseOrderFacade;
    @Resource
    private IReceiveDeliveryNoticeOrderDomain receiveDeliveryNoticeOrderDomain;
    @Resource
    private ILockService lockService;
    @Resource
    private IOrderPreemptWrapperHelper orderPreemptWrapperHelper;
    @Resource
    private IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Resource
    private IInOutResultOrderDomain inOutResultOrderDomain;
    @Resource
    private IInventoryPreemptionDomain inventoryPreemptionDomain;
    @Resource
    private ILogicWarehouseDomain logicWarehouseDomain;
    @Resource
    private ThirdWarehouseMapper thirdWarehouseMapper;
    @Resource
    private IReceiveDeliveryNoticeOrderDetailDomain receiveDeliveryNoticeOrderDetailDomain;

    @Override
    public RestResponse<Boolean> preemptInventory(CsInventoryOperateReqDto inventoryOperateReqDto) {
        PreemptDto preemptParam = new PreemptDto();
        preemptParam.setSourceNo(inventoryOperateReqDto.getSourceNo());
        preemptParam.setSourceType(inventoryOperateReqDto.getSourceType());
        preemptParam.setBusinessType(inventoryOperateReqDto.getBusinessType());
        preemptParam.setValidNegative(Boolean.valueOf(1 == inventoryOperateReqDto.getNegativeValidate()));
        preemptParam.setNoneLineNo(Boolean.TRUE);
        ArrayList detailParams = Lists.newArrayList();
        List operateCargoReqDtoList = inventoryOperateReqDto.getOperateCargoReqDtoList();
        for (CsInventoryOperateCargoReqDto detailReqDto : operateCargoReqDtoList) {
            CalcDetailDto detailParam = new CalcDetailDto();
            BigDecimal preemptNum = BigDecimalUtils.abs((BigDecimal)detailReqDto.getChangeInventory());
            detailParam.setNum(preemptNum);
            detailParam.setSkuCode(detailReqDto.getCargoCode());
            detailParam.setLogicWarehouseCode(inventoryOperateReqDto.getLogicWarehouseCode());
            detailParam.setBatch(detailReqDto.getBatch());
            detailParam.setProduceDate(detailReqDto.getProduceTime());
            detailParam.setExpireDate(detailReqDto.getExpireTime());
            detailParams.add(detailParam);
        }
        preemptParam.setDetails((List)detailParams);
        this.calcInventoryService.preempt(preemptParam);
        return new RestResponse((Object)true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public RestResponse<Boolean> preemptInventoryByYxy(CsInventoryOperateReqDto inventoryOperateReqDto) {
        this.logger.info("\u8425\u9500\u4e91\u56de\u4f20\uff0c\u5e93\u5b58\u9884\u5360,\u5165\u53c2\uff1a{}", (Object)LogUtils.buildLogContent(inventoryOperateReqDto));
        if (CsInventorySourceTypeEnum.OUT_ALLOT.getCode().equals(inventoryOperateReqDto.getSourceType())) {
            inventoryOperateReqDto.setSourceType(CsInventorySourceTypeEnum.OUT_ALLOT_PREEMPT.getCode());
        }
        if (CsInventorySourceTypeEnum.OUT_OTHER.getCode().equals(inventoryOperateReqDto.getSourceType())) {
            inventoryOperateReqDto.setSourceType(CsInventorySourceTypeEnum.OUT_OTHER_PREEMPT.getCode());
        }
        if (CsInventorySourceTypeEnum.OUT_SEPARATE.getCode().equals(inventoryOperateReqDto.getSourceType())) {
            inventoryOperateReqDto.setSourceType(CsInventorySourceTypeEnum.OUT_SEPARATE_PREEMPT.getCode());
        }
        if (CsInventorySourceTypeEnum.OUT_BACKTRACK.getCode().equals(inventoryOperateReqDto.getSourceType())) {
            inventoryOperateReqDto.setSourceType(CsInventorySourceTypeEnum.OUT_BACKTRACK_PREEMPT.getCode());
        }
        if (CsInventorySourceTypeEnum.OUT_TOP_BACKTRACK.getCode().equals(inventoryOperateReqDto.getSourceType())) {
            inventoryOperateReqDto.setSourceType(CsInventorySourceTypeEnum.OUT_TOP_BACKTRACK_PREEMPT.getCode());
        }
        if (CsInventorySourceTypeEnum.OUT_MATERIAL_ADJUST.getCode().equals(inventoryOperateReqDto.getSourceType())) {
            inventoryOperateReqDto.setSourceType(CsInventorySourceTypeEnum.OUT_MATERIAL_ADJUST_PREEMPT.getCode());
        }
        if (CsInventorySourceTypeEnum.OUT_INTERIOR_ADJUST.getCode().equals(inventoryOperateReqDto.getSourceType())) {
            inventoryOperateReqDto.setSourceType(CsInventorySourceTypeEnum.OUT_INTERIOR_ADJUST_PREEMPT.getCode());
        }
        if (CsInventorySourceTypeEnum.SECOND_OUT_TOP_BACKTRACK.getCode().equals(inventoryOperateReqDto.getSourceType())) {
            inventoryOperateReqDto.setSourceType(CsInventorySourceTypeEnum.SECOND_OUT_TOP_BACKTRACK_PREEMPT.getCode());
        }
        inventoryOperateReqDto.setUpdateTotalFlag(YesNoEnum.NO.getValue());
        this.preemptInventory(inventoryOperateReqDto);
        this.logger.info("\u8425\u9500\u4e91\u56de\u4f20\uff0c\u5e93\u5b58\u9884\u5360,\u5e93\u5b58\u9884\u5360\u7ed3\u675f");
        return new RestResponse((Object)true);
    }

    @Override
    public RestResponse<Boolean> preemptOrderInventory(final CsInventoryOperateReqDto inventoryOperateReqDto) {
        ReceiveDeliveryNoticeOrderFacadeBo receiveDeliveryNoticeOrderFacadeBo = this.orderPreemptWrapperHelper.getPreemptFacadeBo(inventoryOperateReqDto);
        receiveDeliveryNoticeOrderFacadeBo.setRelevanceTableName(CsRelevanceTableNameEnum.CS_ORDER_SALE);
        receiveDeliveryNoticeOrderFacadeBo.setCallBack((BaseOrderCallBack)new BaseOrderCallBack<BaseOrderBaseContext>(){

            public void beforeCallBack(BaseOrderBaseContext context) {
                ReceiveDeliveryNoticeOrderContext context1 = (ReceiveDeliveryNoticeOrderContext)context;
                BdCsInventoryExposedApiImpl.this.orderPreemptWrapperHelper.wrapperOrderInfo(context1, inventoryOperateReqDto);
            }

            public void afterCallBack(BaseOrderBaseContext context) {
            }
        });
        this.baseOrderFacade.deliveryNoticeOrderGen(receiveDeliveryNoticeOrderFacadeBo);
        return new RestResponse((Object)true);
    }

    @Override
    public RestResponse<Boolean> releaseInventory(CsInventoryOperateReqDto inventoryOperateReqDto) {
        ReleasePreemptDto releasePreemptParam = new ReleasePreemptDto();
        releasePreemptParam.setSourceNo(inventoryOperateReqDto.getSourceNo());
        releasePreemptParam.setSourceType(inventoryOperateReqDto.getSourceType());
        releasePreemptParam.setBusinessType(inventoryOperateReqDto.getBusinessType());
        this.calcInventoryService.releasePreempt(releasePreemptParam);
        return new RestResponse((Object)true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public RestResponse<Boolean> releaseInventoryByYxy(CsInventoryOperateReqDto inventoryOperateReqDto) {
        this.logger.info("\u8425\u9500\u4e91\u56de\u4f20\uff0c\u5e93\u5b58\u91ca\u653e,\u5165\u53c2\uff1a{}", (Object)LogUtils.buildLogContent(inventoryOperateReqDto));
        Boolean releaseFlag = true;
        try {
            this.logger.info("\u8425\u9500\u4e91\u56de\u4f20\uff0c\u5e93\u5b58\u91ca\u653e,\u5f00\u59cb\u91ca\u653e\uff1a{}", (Object)LogUtils.buildLogContent(inventoryOperateReqDto));
            this.releaseInventory(inventoryOperateReqDto);
            this.logger.info("\u8425\u9500\u4e91\u56de\u4f20\uff0c\u5e93\u5b58\u91ca\u653e,\u66f4\u65b0\u9884\u5360\u8bb0\u5f55\u72b6\u6001\u5b8c\u6210");
        }
        catch (BizException ex) {
            this.logger.info("\u8425\u9500\u4e91\u56de\u4f20\uff0c\u5e93\u5b58\u91ca\u653e,\u91ca\u653e\u5f02\u5e38\uff1a{}", (Object)LogUtils.buildLogContent((Object)ex));
        }
        return new RestResponse((Object)releaseFlag);
    }

    @Override
    public RestResponse<Boolean> reloadPreOccupy(CsInventoryOperateReqDto inventoryOperateReqDto) {
        return null;
    }

    @Override
    public RestResponse<Boolean> releaseOrderInventory(CsInventoryOperateReqDto inventoryOperateReqDto) {
        String descByCode;
        String sourceNo = inventoryOperateReqDto.getSourceNo();
        String sourceType = inventoryOperateReqDto.getSourceType();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)sourceNo) && StringUtils.isNotBlank((CharSequence)sourceType), CsInventoryExceptionCode.OPERATION_NOT_EXIST.getCode(), CsInventoryExceptionCode.OPERATION_NOT_EXIST.getMsg());
        String action = CsDocumentActionEnum.CANCEL_PAY.getCode();
        if (CsInventorySourceTypeEnum.IN_BUSINESS_APPROVE_RELEASE.getCode().equals(sourceType) || CsInventorySourceTypeEnum.IN_FINANCE_APPROVE_RELEASE.getCode().equals(sourceType)) {
            action = CsDocumentActionEnum.AUDIT_ADJUST.getCode();
        }
        AssertUtil.isTrue(null != (descByCode = CsDocumentActionEnum.getDescByCode((String)action)), CsInventoryExceptionCode.OPERATION_NOT_EXIST.getCode(), CsInventoryExceptionCode.OPERATION_NOT_EXIST.getMsg());
        List deliveryNoticeOrderEoList = this.receiveDeliveryNoticeOrderDomain.queryByPreOrderNo(sourceNo);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)deliveryNoticeOrderEoList), CsInventoryExceptionCode.DELIVERY_NOTICE_NOT_EXIST.getCode(), CsInventoryExceptionCode.DELIVERY_NOTICE_NOT_EXIST.getMsg());
        BaseOrderCommonCancelBo commonCancelBo = BaseOrderCommonCancelBo.builder().documentNo(((ReceiveDeliveryNoticeOrderEo)deliveryNoticeOrderEoList.get(0)).getDocumentNo()).sourceType(sourceType).build();
        this.baseOrderFacade.deliveryNoticeOrderCancel(commonCancelBo);
        return new RestResponse((Object)true);
    }

    @Override
    public RestResponse<Boolean> releaseInventoryByPreemption(CsInventoryReleasePreemptOperateReqDto releasePreemptOperateReqDto) {
        Boolean releaseFlag = false;
        try {
            ReleasePreemptDto releasePreemptParam = new ReleasePreemptDto();
            releasePreemptParam.setSourceNo(releasePreemptOperateReqDto.getSourceNo());
            releasePreemptParam.setSourceType(releasePreemptOperateReqDto.getSourceType());
            this.calcInventoryService.releasePreempt(releasePreemptParam);
            releaseFlag = true;
            this.logger.info("releaseInventoryByPreemption==>sourceNo:{},commonApproveReleaseFlag:{}", (Object)releasePreemptOperateReqDto.getSourceNo(), (Object)releaseFlag);
        }
        catch (BizException ex) {
            if (!CsInventoryExceptionCode.NO_FOUND_PREEMPT_RECORD.getCode().equals(ex.getCode())) {
                throw new BizException(ex.getCode(), ex.getMessage());
            }
            this.logger.info("releaseInventoryByPreemption==>sourceNo:{},\u9884\u5360\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u7ee7\u7eed\u6267\u884c", (Object)releasePreemptOperateReqDto.getSourceNo());
        }
        return new RestResponse((Object)releaseFlag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Boolean> releaseInventoryByStrategy(CsInventoryOperateReqDto inventoryOperateReqDto) {
        Mutex lock;
        block8: {
            block9: {
                List InventoryPreemptionEoList;
                block7: {
                    RestResponse restResponse;
                    this.logger.info("releaseInventoryByStrategy==>inventoryOperateReqDto:{}", (Object)LogUtils.buildLogContent(inventoryOperateReqDto));
                    lock = null;
                    String cacheKey = "releaseInventoryByStrategy";
                    try {
                        lock = this.lockService.lock(cacheKey, inventoryOperateReqDto.getSourceNo(), 10, 20, TimeUnit.SECONDS);
                        if (null == lock) {
                            throw new BizException(String.format("\u6839\u636e\u4f20\u5165\u7684\u5e93\u5b58\u7b56\u7565\u8fdb\u884c\u5bf9\u5e94\u5e93\u5b58\u91ca\u653e\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25,\u8ba2\u5355\u53f7\uff1a%s", inventoryOperateReqDto.getSourceNo()));
                        }
                        this.checkParamByStrategy(inventoryOperateReqDto);
                        Boolean checkFlag = this.checkWms(inventoryOperateReqDto);
                        if (checkFlag.booleanValue()) break block7;
                        restResponse = new RestResponse((Object)Boolean.FALSE);
                        if (lock == null) return restResponse;
                    }
                    catch (Throwable throwable) {
                        if (lock == null) throw throwable;
                        this.lockService.unlock(lock);
                        throw throwable;
                    }
                    this.lockService.unlock(lock);
                    return restResponse;
                }
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
                queryWrapper.eq((Object)"valid", (Object)CsValidFlagEnum.ENABLE.getCode());
                queryWrapper.eq((Object)"source_no", (Object)inventoryOperateReqDto.getSourceNo());
                List releaseStrategyList = inventoryOperateReqDto.getReleaseStrategyList();
                if (CollectionUtils.isNotEmpty((Collection)releaseStrategyList)) {
                    queryWrapper.in((Object)"warehouse_classify", (Collection)releaseStrategyList);
                }
                if (!CollectionUtils.isEmpty((Collection)(InventoryPreemptionEoList = this.inventoryPreemptionDomain.getMapper().selectList((Wrapper)queryWrapper)))) break block8;
                Boolean specialCheckFlag = this.specialCheck(inventoryOperateReqDto);
                if (specialCheckFlag.booleanValue()) break block9;
                RestResponse restResponse = new RestResponse((Object)Boolean.FALSE);
                if (lock == null) return restResponse;
                this.lockService.unlock(lock);
                return restResponse;
            }
            RestResponse restResponse = new RestResponse((Object)Boolean.TRUE);
            if (lock == null) return restResponse;
            this.lockService.unlock(lock);
            return restResponse;
        }
        this.cancelOrderStrategy(inventoryOperateReqDto);
        if (lock == null) return new RestResponse((Object)true);
        this.lockService.unlock(lock);
        return new RestResponse((Object)true);
    }

    private void cancelOrderStrategy(CsInventoryOperateReqDto inventoryOperateReqDto) {
        List cancelOrderStrategyList = inventoryOperateReqDto.getCancelOrderStrategyList();
        if (CollectionUtils.isEmpty((Collection)cancelOrderStrategyList)) {
            return;
        }
        if (cancelOrderStrategyList.contains(CsDocumentTypeEnum.DELIVERY_NOTICE_ORDER.getCode())) {
            QueryWrapper receiveDeliveryNoticeOrderEoQueryWrapper = new QueryWrapper();
            receiveDeliveryNoticeOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
            receiveDeliveryNoticeOrderEoQueryWrapper.eq((Object)"order_type", (Object)"delivery");
            receiveDeliveryNoticeOrderEoQueryWrapper.eq((Object)"relevance_no", (Object)inventoryOperateReqDto.getSourceNo());
            List receiveDeliveryNoticeOrderEoList = this.receiveDeliveryNoticeOrderDomain.getMapper().selectList((Wrapper)receiveDeliveryNoticeOrderEoQueryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)receiveDeliveryNoticeOrderEoList)) {
                for (ReceiveDeliveryNoticeOrderEo deliveryNoticeOrderEo : receiveDeliveryNoticeOrderEoList) {
                    if (BaseOrderStatusEnum.DNO_CANCEL.getCode().equals(deliveryNoticeOrderEo.getOrderStatus())) {
                        this.logger.info("\u53d1\u8d27\u901a\u77e5\u5355\uff1a{}\u662f\u53d6\u6d88\u72b6\u6001\uff0c\u4e0d\u5904\u7406", (Object)deliveryNoticeOrderEo.getDocumentNo());
                        continue;
                    }
                    List receiveDeliveryNoticeOrderDetailEos = ((ExtQueryChainWrapper)this.receiveDeliveryNoticeOrderDetailDomain.filter().eq((Object)"document_no", (Object)deliveryNoticeOrderEo.getDocumentNo())).list();
                    List skuCodeList = receiveDeliveryNoticeOrderDetailEos.stream().sorted(Comparator.comparing(ReceiveDeliveryNoticeOrderDetailEo::getSkuCode)).map(e -> e.getSkuCode()).distinct().collect(Collectors.toList());
                    this.logger.info("\u6839\u636e\u4ea7\u54c1\u7f16\u7801\u6392\u5e8fskuCodeList:{}", (Object)JSON.toJSONString(skuCodeList));
                    BaseOrderCommonCancelBo commonCancelBo = BaseOrderCommonCancelBo.builder().documentNo(deliveryNoticeOrderEo.getDocumentNo()).sourceType(CsInventorySourceTypeEnum.PCP_OUT_SALE_RELEASE.getCode()).build();
                    this.baseOrderFacade.deliveryNoticeOrderCancel(commonCancelBo);
                }
            }
        }
        if (cancelOrderStrategyList.contains(CsDocumentTypeEnum.OUT_NOTICE_ORDER.getCode())) {
            // empty if block
        }
    }

    private Boolean specialCheck(CsInventoryOperateReqDto inventoryOperateReqDto) {
        this.logger.info("specialCheck==>inventoryOperateReqDto:{}", (Object)LogUtils.buildLogContent(inventoryOperateReqDto));
        String sourceNo = inventoryOperateReqDto.getSourceNo();
        ArrayList<String> cancelStatusList = new ArrayList<String>(1);
        cancelStatusList.add(BaseOrderStatusEnum.ONO_CANCEL.getCode());
        QueryWrapper InOutNoticeOrderEoQueryWrapper = new QueryWrapper();
        InOutNoticeOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        InOutNoticeOrderEoQueryWrapper.eq((Object)"relevance_no", (Object)sourceNo);
        InOutNoticeOrderEoQueryWrapper.notIn((Object)"order_status", cancelStatusList);
        List InOutNoticeOrderEoList = this.inOutNoticeOrderDomain.getMapper().selectList((Wrapper)InOutNoticeOrderEoQueryWrapper);
        this.logger.info("specialCheck==>InOutNoticeOrderEoList:{}", (Object)LogUtils.buildLogContent(InOutNoticeOrderEoList));
        if (CollectionUtils.isEmpty((Collection)InOutNoticeOrderEoList)) {
            return Boolean.TRUE;
        }
        InOutNoticeOrderEo outNoticeOrderEo = (InOutNoticeOrderEo)InOutNoticeOrderEoList.get(0);
        String pushStatus = outNoticeOrderEo.getPushStatus();
        ArrayList<String> cacelOutResultStatusList = new ArrayList<String>(2);
        cacelOutResultStatusList.add(BaseOrderStatusEnum.ORO_HANG_UP.getCode());
        cacelOutResultStatusList.add(BaseOrderStatusEnum.ORO_ERROR.getCode());
        QueryWrapper InOutResultOrderEoQueryWrapper = new QueryWrapper();
        InOutResultOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        InOutResultOrderEoQueryWrapper.eq((Object)"relevance_no", (Object)sourceNo);
        InOutResultOrderEoQueryWrapper.eq((Object)"order_type", (Object)"out");
        InOutResultOrderEoQueryWrapper.notIn((Object)"order_status", cacelOutResultStatusList);
        List InOutResultOrderEoList = this.inOutResultOrderDomain.getMapper().selectList((Wrapper)InOutResultOrderEoQueryWrapper);
        this.logger.info("specialCheck==>InOutResultOrderEoList:{}", (Object)LogUtils.buildLogContent(InOutResultOrderEoList));
        if (CsOutNoticePushStatusEnum.WITHOUT_PUSH.getCode().equals(pushStatus) && CollectionUtils.isNotEmpty((Collection)InOutResultOrderEoList)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private void checkParamByStrategy(CsInventoryOperateReqDto inventoryOperateReqDto) {
        AssertUtil.isTrue(null != inventoryOperateReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String sourceNo = inventoryOperateReqDto.getSourceNo();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)sourceNo), "\u6765\u6e90\u5355\u636e\u53f7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        List releaseStrategyList = inventoryOperateReqDto.getReleaseStrategyList();
        if (CollectionUtils.isNotEmpty((Collection)releaseStrategyList)) {
            AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)releaseStrategyList), "\u5bf9\u5e94\u5e93\u5b58\u7b56\u7565\u96c6\u5408\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            for (String releaseStrategy : releaseStrategyList) {
                AssertUtil.isTrue(null != CsInventoryStrategyEnum.getByCode((String)releaseStrategy), "\u7b56\u7565\u53c2\u6570\u6709\u8bef");
            }
        }
        if (CollectionUtils.isEmpty((Collection)inventoryOperateReqDto.getCancelOrderStrategyList())) {
            ArrayList cancelOrderStrategyList = Lists.newArrayList();
            cancelOrderStrategyList.add(CsDocumentTypeEnum.DELIVERY_NOTICE_ORDER.getCode());
            cancelOrderStrategyList.add(CsDocumentTypeEnum.OUT_NOTICE_ORDER.getCode());
            inventoryOperateReqDto.setCancelOrderStrategyList((List)cancelOrderStrategyList);
        }
    }

    private Boolean checkWms(CsInventoryOperateReqDto inventoryOperateReqDto) {
        return false;
    }
}

