/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.adapter.bd;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.biz.adapter.LogicWarehouseApiImpl;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsPhysicsWarehouseService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsRelWarehouseService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsWarehouseAddressService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsRelWarehouseAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsWarehouseAddressAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.WarehouseAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.CsWarehouseClassifyEnum;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.PhysicsWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.RelWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.WarehouseAddressEo;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bd_LogicWarehouseApi")
public class BdLogicWarehouseApiImpl
extends LogicWarehouseApiImpl {
    private static final Logger log = LoggerFactory.getLogger(BdLogicWarehouseApiImpl.class);
    @Autowired
    ICsPhysicsWarehouseService csPhysicsWarehouseService;
    @Autowired
    ICsRelWarehouseService csRelWarehouseService;
    @Autowired
    ICsWarehouseAddressService csWarehouseAddressService;
    private final ExecutorService executorService = new ThreadPoolExecutor(2, 10, 1L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(5, true), Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Long> addLogicAndPhysicsWarehouse(WarehouseAddReqDto addReqDto) {
        Long logicWarehouseId;
        LogicWarehouseEo warehouseEo;
        AssertUtil.isTrue(addReqDto != null, "\u53c2\u6570\u6709\u8bef");
        log.info("\u65b0\u589e\u903b\u8f91\u548c\u7269\u7406\u4ed3\u5e93\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)addReqDto));
        if (StringUtils.isBlank((String)addReqDto.getCargoEscheatageName())) {
            addReqDto.setCargoEscheatageId(Long.valueOf(1L));
            addReqDto.setCargoEscheatageName("\u5317\u9f0e\u79d1\u6280");
        }
        if ((warehouseEo = this.csLogicWarehouseService.queryByWarehouseCode(addReqDto.getWarehouseCode())) == null) {
            LogicWarehouseEo logicWarehouseEo = new LogicWarehouseEo();
            CubeBeanUtils.copyProperties((Object)logicWarehouseEo, (Object)addReqDto, (String[])new String[0]);
            logicWarehouseId = this.csLogicWarehouseService.add(logicWarehouseEo);
            PhysicsWarehouseEo physicsWarehouseEo = new PhysicsWarehouseEo();
            CubeBeanUtils.copyProperties((Object)physicsWarehouseEo, (Object)addReqDto, (String[])new String[0]);
            physicsWarehouseEo.setWarehouseCode(logicWarehouseEo.getWarehouseCode());
            Long physicsWarehouseId = this.csPhysicsWarehouseService.add(physicsWarehouseEo);
            CsWarehouseAddressAddReqDto warehouseAddressAddReqDto = addReqDto.getAddressDto();
            if (warehouseAddressAddReqDto != null) {
                ArrayList addressList = Lists.newArrayList();
                warehouseAddressAddReqDto.setValidFlag(CsValidFlagEnum.ENABLE.getCode());
                warehouseAddressAddReqDto.setWarehouseCode(addReqDto.getWarehouseCode());
                warehouseAddressAddReqDto.setWarehouseName(addReqDto.getWarehouseName());
                warehouseAddressAddReqDto.setWarehouseClassify(CsWarehouseClassifyEnum.LOGIC.getCode());
                warehouseAddressAddReqDto.setWarehouseId(logicWarehouseId);
                warehouseAddressAddReqDto.setWarehouseCode(addReqDto.getWarehouseCode());
                warehouseAddressAddReqDto.setContacts(addReqDto.getContact());
                warehouseAddressAddReqDto.setPhone(addReqDto.getPhone());
                addressList.add(warehouseAddressAddReqDto);
                CsWarehouseAddressAddReqDto warehouseAddressAddDto = new CsWarehouseAddressAddReqDto();
                CubeBeanUtils.copyProperties((Object)warehouseAddressAddDto, (Object)warehouseAddressAddReqDto, (String[])new String[0]);
                warehouseAddressAddDto.setWarehouseClassify(CsWarehouseClassifyEnum.PHYSICS.getCode());
                warehouseAddressAddDto.setWarehouseId(physicsWarehouseId);
                warehouseAddressAddDto.setWarehouseCode(addReqDto.getWarehouseCode());
                addressList.add(warehouseAddressAddDto);
                this.csWarehouseAddressService.batchAdd(addressList);
            }
            CsRelWarehouseAddReqDto relWarehouseAddReqDto = new CsRelWarehouseAddReqDto();
            relWarehouseAddReqDto.setWarehouseId(logicWarehouseId);
            relWarehouseAddReqDto.setWarehouseCode(addReqDto.getWarehouseCode());
            relWarehouseAddReqDto.setWarehouseName(addReqDto.getWarehouseName());
            relWarehouseAddReqDto.setWarehouseClassify(CsWarehouseClassifyEnum.LOGIC.getCode());
            relWarehouseAddReqDto.setWarehouseType(null);
            relWarehouseAddReqDto.setRefWarehouseId(physicsWarehouseId);
            relWarehouseAddReqDto.setRefWarehouseCode(addReqDto.getWarehouseCode());
            relWarehouseAddReqDto.setRefWarehouseName(addReqDto.getWarehouseName());
            relWarehouseAddReqDto.setRefWarehouseClassify(CsWarehouseClassifyEnum.PHYSICS.getCode());
            relWarehouseAddReqDto.setValidFlag(CsValidFlagEnum.ENABLE.getCode());
            this.csRelWarehouseService.add(relWarehouseAddReqDto);
            relWarehouseAddReqDto = new CsRelWarehouseAddReqDto();
            relWarehouseAddReqDto.setWarehouseId(physicsWarehouseId);
            relWarehouseAddReqDto.setWarehouseCode(addReqDto.getWarehouseCode());
            relWarehouseAddReqDto.setWarehouseName(addReqDto.getWarehouseName());
            relWarehouseAddReqDto.setWarehouseClassify(CsWarehouseClassifyEnum.PHYSICS.getCode());
            relWarehouseAddReqDto.setWarehouseType(null);
            relWarehouseAddReqDto.setRefWarehouseId(logicWarehouseId);
            relWarehouseAddReqDto.setRefWarehouseCode(addReqDto.getWarehouseCode());
            relWarehouseAddReqDto.setRefWarehouseName(addReqDto.getWarehouseName());
            relWarehouseAddReqDto.setRefWarehouseClassify(CsWarehouseClassifyEnum.LOGIC.getCode());
            relWarehouseAddReqDto.setValidFlag(CsValidFlagEnum.ENABLE.getCode());
            this.csRelWarehouseService.add(relWarehouseAddReqDto);
        } else {
            logicWarehouseId = warehouseEo.getId();
            LogicWarehouseEo logicWarehouseEo = new LogicWarehouseEo();
            CubeBeanUtils.copyProperties((Object)logicWarehouseEo, (Object)addReqDto, (String[])new String[0]);
            logicWarehouseEo.setId(logicWarehouseId);
            this.csLogicWarehouseService.update(logicWarehouseEo);
            RelWarehouseEo csRelWarehouseEo = new RelWarehouseEo();
            csRelWarehouseEo.setWarehouseId(logicWarehouseId);
            csRelWarehouseEo.setRefWarehouseClassify(CsWarehouseClassifyEnum.PHYSICS.getCode());
            csRelWarehouseEo.setValidFlag(CsValidFlagEnum.ENABLE.getCode());
            List<RelWarehouseEo> relWarehouseEoList = this.csRelWarehouseService.selectList(csRelWarehouseEo);
            AssertUtil.isTrue(CollectionUtil.isNotEmpty(relWarehouseEoList), "\u4ed3\u5e93\u5173\u8054\u5173\u7cfb\u4e0d\u5b58\u5728");
            Long physicsWarehouseId = relWarehouseEoList.get(0).getRefWarehouseId();
            PhysicsWarehouseEo physicsWarehouseEo = new PhysicsWarehouseEo();
            CubeBeanUtils.copyProperties((Object)physicsWarehouseEo, (Object)addReqDto, (String[])new String[0]);
            physicsWarehouseEo.setId(physicsWarehouseId);
            physicsWarehouseEo.setWarehouseCode(logicWarehouseEo.getWarehouseCode());
            this.csPhysicsWarehouseService.update(physicsWarehouseEo);
            CsWarehouseAddressAddReqDto warehouseAddressAddReqDto = addReqDto.getAddressDto();
            if (warehouseAddressAddReqDto != null) {
                WarehouseAddressEo updateEo = new WarehouseAddressEo();
                CubeBeanUtils.copyProperties((Object)updateEo, (Object)warehouseAddressAddReqDto, (String[])new String[0]);
                updateEo.setContacts(addReqDto.getContact());
                updateEo.setPhone(addReqDto.getPhone());
                updateEo.setWarehouseId(logicWarehouseId);
                this.csWarehouseAddressService.updateByWarehouseId(updateEo);
                updateEo.setWarehouseId(physicsWarehouseId);
                this.csWarehouseAddressService.updateByWarehouseId(updateEo);
            }
        }
        return new RestResponse((Object)logicWarehouseId);
    }

    public RestResponse<Void> batchAddLogicAndPhysicsWarehouse(List<WarehouseAddReqDto> addReqDtos) {
        log.info("\u6279\u91cf\u65b0\u589e\u903b\u8f91\u548c\u7269\u7406\u4ed3\u5e93\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString(addReqDtos));
        AssertUtil.isTrue(CollectionUtil.isNotEmpty(addReqDtos), "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        for (WarehouseAddReqDto addReqDto : addReqDtos) {
            FutureTask<RestResponse> futureTask = new FutureTask<RestResponse>(() -> this.addLogicAndPhysicsWarehouse(addReqDto));
            this.executorService.execute(futureTask);
        }
        return RestResponse.VOID;
    }
}

