/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.adapter;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.DispatcherAssociatedDocumentVO;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.DispatcherOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.IDispatcherOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.query.IDispatcherOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsDispatcherOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsTransferOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.inventory.ICsOtherStorageOrderService;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsTransferOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.CsOtherStorageOrderRelevanceOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsDocumentTypeEnum;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderQueryDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderRespDto;
import com.yunxi.dg.base.center.inventory.dto.request.DispatcherOrderReqDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class DispatcherOrderApiImpl
implements IDispatcherOrderApi,
IDispatcherOrderQueryApi {
    private static final Logger log = LoggerFactory.getLogger(DispatcherOrderApiImpl.class);
    @Resource
    private ICsDispatcherOrderService dispatcherOrderService;
    @Resource
    private ICsOtherStorageOrderService csOtherStorageOrderService;
    @Resource
    private ICsTransferOrderService csTransferOrderService;

    public RestResponse<Long> addDispatcherOrder(DispatcherOrderReqDto addReqDto) {
        return new RestResponse((Object)this.dispatcherOrderService.addDispatcherOrder(addReqDto));
    }

    public RestResponse<Void> modifyDispatcherOrder(DispatcherOrderReqDto modifyReqDto) {
        this.dispatcherOrderService.modifyDispatcherOrder(modifyReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> calculateDifferencesDispatcher(String transferOrderNo) {
        this.dispatcherOrderService.calculateDifferencesDispatcher(transferOrderNo);
        return RestResponse.VOID;
    }

    public RestResponse<Void> handleDifferencesDispatcher(DispatcherOrderReqDto dispatcherOrderReqDto) {
        this.dispatcherOrderService.handleDifferencesDispatcher(dispatcherOrderReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> removeDispatcherOrder(String ids, Long instanceId) {
        this.dispatcherOrderService.removeDispatcherOrder(ids, instanceId);
        return RestResponse.VOID;
    }

    public RestResponse<Void> dispatcherTransferOrder(String transferOrderNo) {
        CsTransferOrderEo transferOrderEo = this.csTransferOrderService.dispatcherTransferOrder(transferOrderNo);
        log.info("\u8c03\u62e8\u5355\u751f\u6210\u7684\u6536\u53d1\u5dee\u5f02\uff0c{}", (Object)JSON.toJSONString((Object)transferOrderEo));
        return RestResponse.VOID;
    }

    public RestResponse<DispatcherOrderRespDto> queryById(Long id) {
        return new RestResponse((Object)this.dispatcherOrderService.queryById(id));
    }

    public RestResponse<PageInfo<DispatcherOrderRespDto>> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        return null;
    }

    public RestResponse<List<DispatcherAssociatedDocumentVO>> queryAllByRelevanceNo(String orderNo) {
        List documentVOList = new ArrayList();
        List<CsOtherStorageOrderRelevanceOrderRespDto> respDtoList = this.csOtherStorageOrderService.queryOtherStorageOrderRelevanceOrder(orderNo, "dispatcherOrder");
        if (CollectionUtils.isNotEmpty(respDtoList)) {
            List list = respDtoList.stream().map(o -> {
                DispatcherAssociatedDocumentVO documentVO = new DispatcherAssociatedDocumentVO();
                BeanUtils.copyProperties((Object)o, (Object)documentVO);
                documentVO.setOrderNo(o.getDocumentNo());
                documentVO.setOrderType(o.getOrderType());
                documentVO.setBusinessType(o.getBusinessType());
                return documentVO;
            }).collect(Collectors.toList());
            documentVOList.addAll(list);
        }
        CsTransferOrderQueryDto queryDto = new CsTransferOrderQueryDto();
        queryDto.setTransferOrderNo(orderNo);
        PageInfo<CsTransferOrderRespDto> csTransferOrderRespDtoPageInfo = this.csTransferOrderService.queryByPage(queryDto, 1, 1000);
        if (CollectionUtils.isNotEmpty((Collection)csTransferOrderRespDtoPageInfo.getList())) {
            List list = csTransferOrderRespDtoPageInfo.getList().stream().map(o -> {
                DispatcherAssociatedDocumentVO documentVO = new DispatcherAssociatedDocumentVO();
                BeanUtils.copyProperties((Object)o, (Object)documentVO);
                documentVO.setOrderNo(o.getTransferOrderNo());
                documentVO.setOrderType(o.getType());
                documentVO.setBusinessType(CsDocumentTypeEnum.TRANSFER_ORDER.getCode());
                return documentVO;
            }).collect(Collectors.toList());
            documentVOList.addAll(list);
        }
        if (CollectionUtils.isNotEmpty(documentVOList)) {
            documentVOList = documentVOList.stream().sorted(Comparator.comparing(DispatcherAssociatedDocumentVO::getCreateTime)).collect(Collectors.toList());
        }
        return new RestResponse(documentVOList);
    }
}

