/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.adapter;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.pcp.ICsOutPlannedOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.pcp.ICsOutPlannedOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsOutPlannedDifferenceAdjustReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsOutPlannedOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsOutPlannedOrderAuditReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsOutPlannedOrderGenerateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsOutPlannedOrderUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsOutPlannedRelieveDifferenceReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.out.CsOutPlannedOrderResultRespDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class OutPlannedOrderApiImpl
implements ICsOutPlannedOrderApi {
    private static final Logger log = LoggerFactory.getLogger(OutPlannedOrderApiImpl.class);
    @Autowired
    protected ICsOutPlannedOrderService csOutPlannedOrderService;

    public RestResponse<Long> add(CsOutPlannedOrderAddReqDto addReqDto) {
        log.info("\u6dfb\u52a0\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(addReqDto));
        return new RestResponse((Object)this.csOutPlannedOrderService.add(addReqDto));
    }

    public RestResponse<Void> update(Long id, CsOutPlannedOrderUpdateReqDto updateReqDto) {
        log.info("\u4fee\u6539\u53c2\u6570\uff1a[id:{}, {}]", (Object)id, (Object)LogUtils.buildLogContent(updateReqDto));
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        this.csOutPlannedOrderService.update(id, updateReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> delete(Long id) {
        log.info("\u5220\u9664\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        this.csOutPlannedOrderService.delete(id);
        return RestResponse.VOID;
    }

    public RestResponse<Long> generateRetreatOrder(CsOutPlannedOrderGenerateReqDto plannedOrderGenerateReqDto) {
        plannedOrderGenerateReqDto.setOrderNo(null);
        return new RestResponse((Object)this.csOutPlannedOrderService.generateRetreatOrder(plannedOrderGenerateReqDto));
    }

    public RestResponse<CsOutPlannedOrderResultRespDto> auditRetreatOrder(CsOutPlannedOrderAuditReqDto plannedOrderAuditReqDto) {
        return new RestResponse((Object)this.csOutPlannedOrderService.auditRetreatOrder(plannedOrderAuditReqDto));
    }

    public RestResponse<Void> cancelByOrderNo(String orderNo) {
        this.csOutPlannedOrderService.cancelByOrderNo(orderNo);
        return RestResponse.VOID;
    }

    public RestResponse<Long> editRetreatOrder(CsOutPlannedOrderGenerateReqDto plannedOrderGenerateReqDto) {
        Long plannedOrderId = this.csOutPlannedOrderService.editRetreatOrder(plannedOrderGenerateReqDto);
        return new RestResponse((Object)plannedOrderId);
    }

    public RestResponse<Void> submitByOrderNo(String orderNo) {
        this.csOutPlannedOrderService.submitByOrderNo(orderNo);
        return RestResponse.VOID;
    }

    public RestResponse<Void> relieveDifferenceByOrderDocumentNo(CsOutPlannedRelieveDifferenceReqDto outPlannedRelieveDifferenceReqDto) {
        this.csOutPlannedOrderService.relieveDifferenceByOrderDocumentNo(outPlannedRelieveDifferenceReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> differenceAdjust(CsOutPlannedDifferenceAdjustReqDto differenceAdjustReqDto) {
        this.csOutPlannedOrderService.differenceAdjust(differenceAdjustReqDto);
        return RestResponse.VOID;
    }
}

