/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.biz.commons.utils.Assert;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.InventorySubItemReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.request.ParseSubItemReq;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IInventorySubItemService;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.InventorySubItemDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.InventorySubItemEo;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.inventory.dto.domain.InventorySubItemRespDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class InventorySubItemServiceImpl
implements IInventorySubItemService {
    private static final Logger LOGGER = LoggerFactory.getLogger(InventorySubItemServiceImpl.class);
    @Resource
    private InventorySubItemDas inventorySubItemDas;

    @Override
    public Long addInventorySubItem(InventorySubItemReqDto addReqDto) {
        InventorySubItemEo inventorySubItemEo = new InventorySubItemEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)inventorySubItemEo);
        this.inventorySubItemDas.insert((BaseEo)inventorySubItemEo);
        return inventorySubItemEo.getId();
    }

    @Override
    public void modifyInventorySubItem(InventorySubItemReqDto modifyReqDto) {
        InventorySubItemEo inventorySubItemEo = new InventorySubItemEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)inventorySubItemEo);
        this.inventorySubItemDas.updateSelective((BaseEo)inventorySubItemEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeInventorySubItem(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.inventorySubItemDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public InventorySubItemRespDto queryById(Long id) {
        InventorySubItemEo inventorySubItemEo = (InventorySubItemEo)this.inventorySubItemDas.selectByPrimaryKey(id);
        InventorySubItemRespDto inventorySubItemRespDto = new InventorySubItemRespDto();
        DtoHelper.eo2Dto((BaseEo)inventorySubItemEo, (BaseVo)inventorySubItemRespDto);
        return inventorySubItemRespDto;
    }

    @Override
    public PageInfo<InventorySubItemRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        InventorySubItemReqDto inventorySubItemReqDto = (InventorySubItemReqDto)JSON.parseObject((String)filter, InventorySubItemReqDto.class);
        InventorySubItemEo inventorySubItemEo = new InventorySubItemEo();
        DtoHelper.dto2Eo((BaseVo)inventorySubItemReqDto, (BaseEo)inventorySubItemEo);
        ArrayList sqlFilters = Lists.newArrayList();
        if (!CollectionUtils.isEmpty((Collection)inventorySubItemReqDto.getParentItemCodes())) {
            sqlFilters.add(SqlFilter.in((String)"parent_item_code", (Object)inventorySubItemReqDto.getParentItemCodes()));
        }
        if (!CollectionUtils.isEmpty((Collection)inventorySubItemReqDto.getParentBatchs())) {
            sqlFilters.add(SqlFilter.in((String)"parent_batch", (Object)inventorySubItemReqDto.getParentBatchs()));
        }
        inventorySubItemEo.setSqlFilters((List)sqlFilters);
        PageInfo eoPageInfo = this.inventorySubItemDas.selectPage((BaseEo)inventorySubItemEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, InventorySubItemRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public void addInventorySubItem(String itemCode, String batch, List<InventorySubItemReqDto> subItemList) {
        if (!StringUtils.isNotBlank((CharSequence)itemCode) || !StringUtils.isNotBlank((CharSequence)batch) || CollectionUtils.isEmpty(subItemList)) {
            return;
        }
        InventorySubItemEo inventorySubItemEo = new InventorySubItemEo();
        inventorySubItemEo.setParentItemCode(itemCode);
        inventorySubItemEo.setParentBatch(batch);
        List inventorySubItemEos = this.inventorySubItemDas.select((BaseEo)inventorySubItemEo);
        if (!CollectionUtils.isEmpty((Collection)inventorySubItemEos)) {
            return;
        }
        List collect = subItemList.stream().map(dto -> {
            InventorySubItemEo inventorySubItem = new InventorySubItemEo();
            DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)inventorySubItem);
            inventorySubItem.setParentItemCode(itemCode);
            inventorySubItem.setParentBatch(batch);
            return inventorySubItem;
        }).collect(Collectors.toList());
        int result = this.inventorySubItemDas.insertBatch(collect);
        Assert.isTrue((result > 0 ? 1 : 0) != 0, (String)"0001", (String)"\u63d2\u5165\u793c\u76d2\u5b50\u4ea7\u54c1\u5173\u7cfb\u5931\u8d25");
    }

    @Override
    public Map<String, List<InventorySubItemRespDto>> subItemRelation(List<ParseSubItemReq> reqList) {
        LOGGER.info("\u83b7\u53d6\u4ea7\u54c1\u793c\u76d2\u5173\u7cfb\u660e\u7ec6 req : {} .", (Object)JSON.toJSONString(reqList));
        List cargoCodes = reqList.stream().filter(c -> YesNoEnum.YES.getValue().equals(c.getIsGift())).map(c -> c.getCargoCode()).collect(Collectors.toList());
        List batchs = reqList.stream().filter(c -> YesNoEnum.YES.getValue().equals(c.getIsGift())).map(c -> c.getBatch()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(cargoCodes) || CollectionUtils.isEmpty(batchs)) {
            return Maps.newHashMap();
        }
        InventorySubItemReqDto inventorySubItemReqDto = new InventorySubItemReqDto();
        inventorySubItemReqDto.setParentItemCodes(cargoCodes);
        inventorySubItemReqDto.setParentBatchs(batchs);
        PageInfo<InventorySubItemRespDto> inventorySubItemRespDtoPageInfo = this.queryByPage(JSON.toJSONString((Object)inventorySubItemReqDto), 1, Integer.MAX_VALUE);
        List list = inventorySubItemRespDtoPageInfo.getList();
        return Optional.of(list).orElse(Lists.newArrayList()).stream().collect(Collectors.groupingBy(key -> key.getParentItemCode() + key.getParentBatch()));
    }
}

