/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.pcp.impl;

import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.pcp.ICsOutPlannedOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.inventory.CsStorageAuditRecordDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.order.out.CsOutPlannedOrderDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.order.out.CsOutPlannedOrderDetailDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.order.out.CsOutPlannedOrderDetailEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.order.out.CsOutPlannedOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.CsStorageAuditRecordRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsOutPlannedOrderPageQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.out.CsOutPlannedOrderDetailQueryInfoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.out.CsOutPlannedOrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.out.CsOutPlannedOrderRelOrderInfoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.out.CsOutPlannedOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsDocumentTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderTypeEnum;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.domain.CsOutResultOrderDetailRespDto;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderEo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="csOutPlannedOrderQueryService")
public class CsOutPlannedOrderQueryServiceImpl
implements ICsOutPlannedOrderQueryService {
    private static Logger logger = LoggerFactory.getLogger(CsOutPlannedOrderQueryServiceImpl.class);
    @Autowired
    private CsOutPlannedOrderDas csOutPlannedOrderDas;
    @Resource
    private CsOutPlannedOrderDetailDas outPlannedOrderDetailDas;
    @Resource
    IReceiveDeliveryNoticeOrderDomain receiveDeliveryNoticeOrderDomain;
    @Resource
    IReceiveDeliveryResultOrderDomain receiveDeliveryResultOrderDomain;
    @Resource
    IInOutResultOrderDomain inOutResultOrderDomain;
    @Resource
    IInOutResultOrderDetailDomain inOutResultOrderDetailDomain;
    @Autowired
    IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Resource
    private CsStorageAuditRecordDas storageAuditRecordDas;

    @Override
    public CsOutPlannedOrderEo selectByPrimaryKey(Long id) {
        logger.info("\u6839\u636eid\u67e5\u8be2\u4fe1\u606f\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        return (CsOutPlannedOrderEo)this.csOutPlannedOrderDas.selectByPrimaryKey(id);
    }

    @Override
    public PageInfo<CsOutPlannedOrderRespDto> queryByPage(CsOutPlannedOrderPageQueryDto outPlannedOrderPageQueryDto) {
        logger.info("queryByPage==>\u5206\u9875\u67e5\u8be2,outPlannedOrderPageQueryDto:{}", (Object)LogUtils.buildLogContent(outPlannedOrderPageQueryDto));
        this.checkParams(outPlannedOrderPageQueryDto);
        ExtQueryChainWrapper filter = this.csOutPlannedOrderDas.filter();
        this.buildQueryFilter((ExtQueryChainWrapper<CsOutPlannedOrderEo>)filter, outPlannedOrderPageQueryDto);
        PageInfo page = filter.page(outPlannedOrderPageQueryDto.getPageNum(), outPlannedOrderPageQueryDto.getPageSize());
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)page, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)page.getList(), dtoList, CsOutPlannedOrderRespDto.class);
        pageInfo.setList(dtoList);
        return pageInfo;
    }

    @Override
    public CsOutPlannedOrderDetailQueryInfoRespDto queryDetailByOrderNo(String orderNo) {
        logger.info("queryDetailByOrderNo==>\u6839\u636e\u5355\u636e\u7f16\u7801\u67e5\u8be2\u5355\u636e\u8be6\u60c5\u4fe1\u606f,orderNo:{}", (Object)orderNo);
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)orderNo), "\u5355\u636e\u7f16\u53f7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        CsOutPlannedOrderEo csOutPlannedOrderEo = (CsOutPlannedOrderEo)((ExtQueryChainWrapper)this.csOutPlannedOrderDas.filter().eq((Object)"order_no", (Object)orderNo)).one();
        AssertUtil.isTrue(null != csOutPlannedOrderEo, "\u67e5\u8be2\u4e0d\u5230\u5355\u636e\u4fe1\u606f");
        CsOutPlannedOrderDetailQueryInfoRespDto infoRespDto = new CsOutPlannedOrderDetailQueryInfoRespDto();
        CubeBeanUtils.copyProperties((Object)infoRespDto, (Object)csOutPlannedOrderEo, (String[])new String[0]);
        this.buildItemInfo(infoRespDto);
        this.buildRelOrderInfo(infoRespDto);
        this.buildAuditInfo(infoRespDto);
        return infoRespDto;
    }

    private void buildAuditInfo(CsOutPlannedOrderDetailQueryInfoRespDto infoRespDto) {
        String orderNo = infoRespDto.getOrderNo();
        List storageAuditRecordEoList = ((ExtQueryChainWrapper)this.storageAuditRecordDas.filter().eq((Object)"order_src_no", (Object)orderNo)).list();
        ArrayList csStorageAuditRecordRespDtoList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)storageAuditRecordEoList)) {
            CubeBeanUtils.copyCollection(csStorageAuditRecordRespDtoList, (Collection)storageAuditRecordEoList, CsStorageAuditRecordRespDto.class);
            infoRespDto.setAuditRespDtoList(csStorageAuditRecordRespDtoList);
        }
    }

    @Override
    public List<CsOutResultOrderDetailRespDto> queryDifferenceDetailByDocumentNo(String resultDocumentNo) {
        logger.info("queryDifferenceDetailByDocumentNo==>\u6839\u636e\u51fa\u5e93\u7ed3\u679c\u5355\u5355\u53f7\u67e5\u8be2\u8d85\u6536\u4fe1\u606f,resultDocumentNo:{}", (Object)resultDocumentNo);
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)resultDocumentNo), "\u51fa\u5e93\u7ed3\u679c\u5355\u5355\u53f7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        InOutResultOrderEo InOutResultOrderEo2 = (InOutResultOrderEo)((ExtQueryChainWrapper)this.inOutResultOrderDomain.filter().eq((Object)"document_no", (Object)resultDocumentNo)).one();
        AssertUtil.isTrue(null != InOutResultOrderEo2, "\u67e5\u8be2\u4e0d\u5230\u5355\u636e\u4fe1\u606f");
        List csOutResultOrderDetailEoList = ((ExtQueryChainWrapper)this.inOutResultOrderDetailDomain.filter().eq((Object)"document_no", (Object)resultDocumentNo)).list();
        if (CollectionUtils.isEmpty((Collection)csOutResultOrderDetailEoList)) {
            return Lists.newArrayList();
        }
        ArrayList outResultOrderDetailRespDtoList = Lists.newArrayList();
        for (InOutResultOrderDetailEo outInResultOrderDetailEo : csOutResultOrderDetailEoList) {
            BigDecimal waitQuantity = outInResultOrderDetailEo.getWaitQuantity();
            if (waitQuantity.compareTo(BigDecimal.ZERO) >= 0) continue;
            CsOutResultOrderDetailRespDto csOutResultOrderDetailRespDto = new CsOutResultOrderDetailRespDto();
            CubeBeanUtils.copyProperties((Object)csOutResultOrderDetailRespDto, (Object)outInResultOrderDetailEo, (String[])new String[0]);
            outResultOrderDetailRespDtoList.add(csOutResultOrderDetailRespDto);
        }
        return outResultOrderDetailRespDtoList;
    }

    @Override
    public List<CsOutPlannedOrderRespDto> queryByIds(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return null;
        }
        List eos = this.csOutPlannedOrderDas.selectByIds(ids);
        if (CollectionUtils.isEmpty((Collection)eos)) {
            return null;
        }
        ArrayList dtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)eos, (Collection)dtoList, CsOutPlannedOrderRespDto.class);
        return dtoList;
    }

    private void buildRelOrderInfo(CsOutPlannedOrderDetailQueryInfoRespDto infoRespDto) {
        List InOutResultOrderEoList;
        InOutNoticeOrderEo InOutNoticeOrderEo2;
        List deliveryResultOrderEos;
        ReceiveDeliveryNoticeOrderEo deliveryNoticeOrderEo;
        ArrayList relOrderInfoList = Lists.newArrayList();
        infoRespDto.setRelOrderInfoList((List)relOrderInfoList);
        String orderNo = infoRespDto.getOrderNo();
        String platformOrderNo = infoRespDto.getPlatformOrderNo();
        if (StringUtils.isNotBlank((CharSequence)platformOrderNo)) {
            CsOutPlannedOrderRelOrderInfoRespDto easRelOrderInfo = new CsOutPlannedOrderRelOrderInfoRespDto();
            easRelOrderInfo.setId(infoRespDto.getId());
            easRelOrderInfo.setOrderNo(infoRespDto.getPlatformOrderNo());
            easRelOrderInfo.setBusinessType(infoRespDto.getBusinessType());
            easRelOrderInfo.setOrderType(infoRespDto.getBusinessType());
            easRelOrderInfo.setCreateTime(infoRespDto.getCreateTime());
            relOrderInfoList.add(easRelOrderInfo);
        }
        if (null != (deliveryNoticeOrderEo = (ReceiveDeliveryNoticeOrderEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.receiveDeliveryNoticeOrderDomain.filter().eq((Object)"relevance_no", (Object)orderNo)).eq((Object)"order_type", (Object)"delivery")).one())) {
            CsOutPlannedOrderRelOrderInfoRespDto receiveNoticeOrderInfoDto = new CsOutPlannedOrderRelOrderInfoRespDto();
            receiveNoticeOrderInfoDto.setId(deliveryNoticeOrderEo.getId());
            receiveNoticeOrderInfoDto.setOrderNo(deliveryNoticeOrderEo.getDocumentNo());
            receiveNoticeOrderInfoDto.setOrderType(CsDocumentTypeEnum.DELIVERY_NOTICE_ORDER.getCode());
            receiveNoticeOrderInfoDto.setOrderStatus(deliveryNoticeOrderEo.getOrderStatus());
            receiveNoticeOrderInfoDto.setRemark(deliveryNoticeOrderEo.getRemark());
            receiveNoticeOrderInfoDto.setCreateTime(deliveryNoticeOrderEo.getCreateTime());
            relOrderInfoList.add(receiveNoticeOrderInfoDto);
        }
        if (CollectionUtils.isNotEmpty((Collection)(deliveryResultOrderEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.receiveDeliveryResultOrderDomain.filter().eq((Object)"relevance_no", (Object)orderNo)).eq((Object)"order_type", (Object)"delivery")).list()))) {
            for (ReceiveDeliveryResultOrderEo csDeliveryResultOrderEo : deliveryResultOrderEos) {
                CsOutPlannedOrderRelOrderInfoRespDto receiveResultOrderInfoDto = new CsOutPlannedOrderRelOrderInfoRespDto();
                receiveResultOrderInfoDto.setId(csDeliveryResultOrderEo.getId());
                receiveResultOrderInfoDto.setOrderNo(csDeliveryResultOrderEo.getDocumentNo());
                receiveResultOrderInfoDto.setOrderType(CsDocumentTypeEnum.DELIVERY_RESULT_ORDER.getCode());
                receiveResultOrderInfoDto.setOrderStatus(csDeliveryResultOrderEo.getOrderStatus());
                receiveResultOrderInfoDto.setRemark(csDeliveryResultOrderEo.getRemark());
                receiveResultOrderInfoDto.setCreateTime(csDeliveryResultOrderEo.getCreateTime());
                relOrderInfoList.add(receiveResultOrderInfoDto);
            }
        }
        if (null != (InOutNoticeOrderEo2 = (InOutNoticeOrderEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"relevance_no", (Object)orderNo)).eq((Object)"order_type", (Object)"out")).one())) {
            CsOutPlannedOrderRelOrderInfoRespDto outNoticeOrderInfoDto = new CsOutPlannedOrderRelOrderInfoRespDto();
            outNoticeOrderInfoDto.setId(InOutNoticeOrderEo2.getId());
            outNoticeOrderInfoDto.setOrderNo(InOutNoticeOrderEo2.getDocumentNo());
            outNoticeOrderInfoDto.setOrderType(CsDocumentTypeEnum.OUT_NOTICE_ORDER.getCode());
            outNoticeOrderInfoDto.setOrderStatus(InOutNoticeOrderEo2.getOrderStatus());
            outNoticeOrderInfoDto.setRemark(InOutNoticeOrderEo2.getRemark());
            outNoticeOrderInfoDto.setCreateTime(deliveryNoticeOrderEo.getCreateTime());
            relOrderInfoList.add(outNoticeOrderInfoDto);
        }
        if (CollectionUtils.isNotEmpty((Collection)(InOutResultOrderEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutResultOrderDomain.filter().eq((Object)"relevance_no", (Object)orderNo)).eq((Object)"order_type", (Object)"out")).list()))) {
            for (InOutResultOrderEo InOutResultOrderEo2 : InOutResultOrderEoList) {
                CsOutPlannedOrderRelOrderInfoRespDto outResultOrderInfoDto = new CsOutPlannedOrderRelOrderInfoRespDto();
                outResultOrderInfoDto.setId(InOutResultOrderEo2.getId());
                outResultOrderInfoDto.setOrderNo(InOutResultOrderEo2.getDocumentNo());
                outResultOrderInfoDto.setOrderType(CsDocumentTypeEnum.OUT_RESULT_ORDER.getCode());
                outResultOrderInfoDto.setOrderStatus(InOutResultOrderEo2.getOrderStatus());
                outResultOrderInfoDto.setRemark(InOutResultOrderEo2.getRemark());
                outResultOrderInfoDto.setCreateTime(InOutResultOrderEo2.getCreateTime());
                relOrderInfoList.add(outResultOrderInfoDto);
            }
        }
    }

    private void buildItemInfo(CsOutPlannedOrderDetailQueryInfoRespDto infoRespDto) {
        String orderNo = infoRespDto.getOrderNo();
        List orderDetailEoList = ((ExtQueryChainWrapper)this.outPlannedOrderDetailDas.filter().eq((Object)"order_no", (Object)orderNo)).list();
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)orderDetailEoList), "\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u4e0d\u5b58\u5728");
        ArrayList itemInfoList = Lists.newArrayList();
        infoRespDto.setItemInfoList((List)itemInfoList);
        for (CsOutPlannedOrderDetailEo detailEo : orderDetailEoList) {
            CsOutPlannedOrderDetailRespDto detailRespDto = new CsOutPlannedOrderDetailRespDto();
            CubeBeanUtils.copyProperties((Object)detailRespDto, (Object)detailEo, (String[])new String[0]);
            itemInfoList.add(detailRespDto);
        }
    }

    private void buildQueryFilter(ExtQueryChainWrapper<CsOutPlannedOrderEo> filter, CsOutPlannedOrderPageQueryDto outPlannedOrderPageQueryDto) {
        String receiveWarehouseName;
        String receiveWarehouseCode;
        String businessType;
        String orderStatus;
        String orderNo = outPlannedOrderPageQueryDto.getOrderNo();
        if (StringUtils.isNotBlank((CharSequence)orderNo)) {
            filter.like((Object)"order_no", (Object)orderNo);
        }
        if (StringUtils.isNotBlank((CharSequence)(orderStatus = outPlannedOrderPageQueryDto.getOrderStatus()))) {
            filter.eq((Object)"order_status", (Object)orderStatus);
        }
        if (StringUtils.isNotBlank((CharSequence)(businessType = outPlannedOrderPageQueryDto.getBusinessType()))) {
            filter.eq((Object)"business_type", (Object)businessType);
        }
        if (StringUtils.isNotBlank((CharSequence)(receiveWarehouseCode = outPlannedOrderPageQueryDto.getDeliveryWarehouseCode()))) {
            filter.like((Object)"delivery_warehouse_code", (Object)receiveWarehouseCode);
        }
        if (StringUtils.isNotBlank((CharSequence)(receiveWarehouseName = outPlannedOrderPageQueryDto.getDeliveryWarehouseName()))) {
            filter.like((Object)"delivery_warehouse_name", (Object)receiveWarehouseName);
        }
        String createTimeStart = outPlannedOrderPageQueryDto.getCreateTimeStart();
        String createTimeEnd = outPlannedOrderPageQueryDto.getCreateTimeEnd();
        if (StringUtils.isNotBlank((CharSequence)createTimeStart) && StringUtils.isNotBlank((CharSequence)createTimeEnd)) {
            filter.ge((Object)"create_time", (Object)createTimeStart);
            filter.le((Object)"create_time", (Object)createTimeStart);
        }
        filter.orderByDesc((Object)"create_time");
    }

    private void checkParams(CsOutPlannedOrderPageQueryDto outPlannedOrderPageQueryDto) {
        AssertUtil.isTrue(null != outPlannedOrderPageQueryDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(null != outPlannedOrderPageQueryDto.getPageNum() && outPlannedOrderPageQueryDto.getPageNum() > 0, "\u5206\u9875\u9875\u7801\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(null != outPlannedOrderPageQueryDto.getPageSize() && outPlannedOrderPageQueryDto.getPageSize() > 0, "\u5206\u9875\u5927\u5c0f\u53c2\u6570\u6709\u8bef");
        String orderType = outPlannedOrderPageQueryDto.getOrderType();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)orderType) && null != CsPlannedOrderTypeEnum.getByCode((String)orderType), "\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
    }
}

