/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.apiimpl.order;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.TcbjStockChangeDto;
import com.dtyunxi.yundt.cube.center.inventory.api.order.adjust.ITcbjAdjustApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsTransferOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsDeliveryNoticeOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsDeliveryNoticeOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.order.ITcbjAdjustService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.DRAOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.TcbjDRAOrderCargoMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.TcbjDRAOrderMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.order.adjust.req.TcbjAdjustAuReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.order.adjust.req.TcbjAdjustGenReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.order.adjust.req.TcbjAdjustItemReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.order.adjust.req.TcbjAdjustReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.order.adjust.req.TcbjAdjustUpReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.order.adjust.resp.TcbjAdjustDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.order.adjust.resp.TcbjAdjustRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsDeliveryNoticeOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsDeliveryNoticeOrderDetailAddReqDto;
import com.github.pagehelper.PageInfo;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.dto.domain.ContactDto;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderFacade;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.InOutNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.InOutNoticeOrderFacadeBo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="tcbjAdjustApi")
public class TcbjAdjustApiImpl
implements ITcbjAdjustApi {
    private static final Logger logger = LoggerFactory.getLogger(TcbjAdjustApiImpl.class);
    @Resource
    ITcbjAdjustService tcbjAdjustService;
    @Resource
    private ICsTransferOrderService transferOrderService;
    @Resource
    private TcbjDRAOrderMapper tcbjDRAOrderMapper;
    @Resource
    private TcbjDRAOrderCargoMapper tcbjDRAOrderCargoMapper;
    @Resource
    private ICsDeliveryNoticeOrderService csDeliveryNoticeOrderService;
    @Resource
    private ICsDeliveryNoticeOrderQueryService csDeliveryNoticeOrderQueryService;
    @Resource
    private BaseOrderFacade baseOrderFacade;

    public RestResponse<PageInfo<TcbjAdjustRespDto>> page(TcbjAdjustReqDto queryDto) {
        return this.tcbjAdjustService.page(queryDto);
    }

    public RestResponse<String> gen(TcbjAdjustGenReqDto reqDto) {
        AssertUtil.isTrue(!Strings.isNullOrEmpty((String)reqDto.getWarehouseCode()), "\u672a\u4f20\u5165\u4ed3\u5e93\u7f16\u7801");
        return this.tcbjAdjustService.gen(reqDto);
    }

    public RestResponse<TcbjAdjustDetailRespDto> detail(String id) {
        return this.tcbjAdjustService.detail(id);
    }

    public RestResponse<Void> tcbjPhysicLogicWarehouseOut(TcbjStockChangeDto reqDto) {
        return RestResponse.VOID;
    }

    public RestResponse<String> update(TcbjAdjustUpReqDto dto) {
        AssertUtil.isTrue(!Strings.isNullOrEmpty((String)dto.getWarehouseCode()), "\u672a\u4f20\u5165\u4ed3\u5e93\u7f16\u7801");
        AssertUtil.isTrue(dto.getId() != null, "\u672a\u4f20\u5165Id");
        return this.tcbjAdjustService.update(dto);
    }

    public RestResponse<String> updateNoti(TcbjAdjustUpReqDto dto) {
        AssertUtil.isTrue(dto.getPreNo() != null, "\u672a\u4f20\u5165\u524d\u7f6e\u5355\u53f7");
        AssertUtil.isTrue(dto.getStatus() != null, "\u672a\u4f20\u5165\u4fee\u6539\u72b6\u6001");
        DRAOrderEo draOrderEo = new DRAOrderEo();
        UpdateWrapper draOrderEoUpdateWrapper = new UpdateWrapper();
        draOrderEoUpdateWrapper.eq((Object)"pre_no", (Object)dto.getPreNo());
        draOrderEo.setStatus(Integer.valueOf(dto.getStatus()));
        int updateCount = this.tcbjDRAOrderMapper.update((Object)draOrderEo, (Wrapper)draOrderEoUpdateWrapper);
        if ("1013".equals(dto.getStatus())) {
            try {
                this.createOutNoticeOrder(dto.getPreNo());
                logger.info("\u72b6\u6001\u66f4\u65b0\u4e3a1013\uff0c\u5df2\u521b\u5efa\u51fa\u5e93\u901a\u77e5\u5355\uff0c\u524d\u7f6e\u5355\u53f7\uff1a{}", (Object)dto.getPreNo());
            }
            catch (Exception e) {
                logger.error("\u521b\u5efa\u51fa\u5e93\u901a\u77e5\u5355\u5931\u8d25\uff0c\u524d\u7f6e\u5355\u53f7\uff1a{}\uff0c\u9519\u8bef\uff1a{}", new Object[]{dto.getPreNo(), e.getMessage(), e});
            }
        }
        return new RestResponse((Object)(updateCount + ""));
    }

    private void createOutNoticeOrder(String preNo) {
        logger.info("\u5f00\u59cb\u521b\u5efa\u51fa\u5e93\u901a\u77e5\u5355\uff0c\u524d\u7f6e\u5355\u53f7\uff1a{}", (Object)preNo);
        QueryWrapper orderWrapper = new QueryWrapper();
        orderWrapper.eq((Object)"pre_no", (Object)preNo);
        DRAOrderEo draOrderEo = (DRAOrderEo)this.tcbjDRAOrderMapper.selectOne((Wrapper)orderWrapper);
        AssertUtil.isTrue(draOrderEo != null, "\u672a\u627e\u5230\u5bf9\u5e94\u7684DRA\u8ba2\u5355\uff0c\u524d\u7f6e\u5355\u53f7\uff1a" + preNo);
        ReceiveDeliveryNoticeOrderEo deliveryNoticeOrderEo = this.csDeliveryNoticeOrderQueryService.getByRelevanceNo(draOrderEo.getPreNo());
        AssertUtil.isTrue(deliveryNoticeOrderEo != null, "\u672a\u627e\u5230\u5bf9\u5e94\u7684\u53d1\u8d27\u901a\u77e5\u5355\uff0c\u5173\u8054\u5355\u53f7\uff1a" + draOrderEo.getPreNo());
        List<ReceiveDeliveryNoticeOrderDetailEo> detailList = this.csDeliveryNoticeOrderQueryService.getDetailsByDocumentNo(deliveryNoticeOrderEo.getDocumentNo());
        AssertUtil.isTrue(detailList != null && !detailList.isEmpty(), "\u672a\u627e\u5230\u5bf9\u5e94\u7684\u53d1\u8d27\u901a\u77e5\u5355\u8be6\u60c5\uff0c\u5355\u636e\u53f7\uff1a" + deliveryNoticeOrderEo.getDocumentNo());
        InOutNoticeOrderFacadeBo facadeBo = this.buildOutNoticeOrderRequest(deliveryNoticeOrderEo, detailList);
        InOutNoticeOrderContext context = this.baseOrderFacade.outNoticeOrderGen(facadeBo);
        logger.info("\u51fa\u5e93\u901a\u77e5\u5355\u521b\u5efa\u6210\u529f\uff0c\u5355\u636e\u53f7\uff1a{}\uff0c\u524d\u7f6e\u5355\u53f7\uff1a{}", (Object)context.getInOutNoticeOrderEo().getDocumentNo(), (Object)preNo);
    }

    private InOutNoticeOrderFacadeBo buildOutNoticeOrderRequest(ReceiveDeliveryNoticeOrderEo deliveryNoticeOrderEo, List<ReceiveDeliveryNoticeOrderDetailEo> detailList) {
        InOutNoticeOrderFacadeBo facadeBo = new InOutNoticeOrderFacadeBo();
        facadeBo.setReceiveDeliveryNoticeOrderEo(deliveryNoticeOrderEo);
        facadeBo.setAutoComplete(Boolean.valueOf(false));
        facadeBo.setSendWms(true);
        return facadeBo;
    }

    public void testDeliveryNoticeOrderCreation() {
        logger.info("\u5f00\u59cb\u6d4b\u8bd5\u53d1\u8d27\u901a\u77e5\u5355\u751f\u6210\u529f\u80fd");
        CsDeliveryNoticeOrderAddReqDto testReqDto = new CsDeliveryNoticeOrderAddReqDto();
        testReqDto.setBusinessType("101");
        testReqDto.setPreOrderNo("KH2024821370363202510216375");
        testReqDto.setWarehouseCode("4374b8593e9040aa85024716286955c2");
        testReqDto.setOrganizationId(Long.valueOf(1292258031236878075L));
        testReqDto.setOrganizationName("\u6cb3\u6e90\u516c\u53f8");
        testReqDto.setTotalQuantity(BigDecimal.valueOf(3L));
        ContactDto contactDto = new ContactDto();
        contactDto.setAddress("\u5e7f\u4e1c\u5e7f\u5dde\u9ec4\u57d4\u533a\u5e7f\u4e1c\u7701\u5e7f\u5dde\u5e02\u9ec4\u6d66\u533a88\u53f7");
        contactDto.setPlanTime("2025-10-21 03:02:25");
        contactDto.setReciveName("\u5c0f\u5c0f");
        contactDto.setRecivePhone("15171111118");
        testReqDto.setContactDto(contactDto);
        ArrayList detailList = Lists.newArrayList();
        CsDeliveryNoticeOrderDetailAddReqDto detailDto = new CsDeliveryNoticeOrderDetailAddReqDto();
        detailDto.setCargoCode("F.A.34.FA34907");
        detailDto.setPlanQuantity(BigDecimal.valueOf(3L));
        detailDto.setActivityId(Long.valueOf(1421539001697979674L));
        detailDto.setTradeOrderItemId(Long.valueOf(1421539043252097715L));
        detailList.add(detailDto);
        testReqDto.setDetailAddReqDtoList((List)detailList);
        try {
            Long deliveryNoticeOrderId = this.csDeliveryNoticeOrderService.addWithBaseOrderFacade(testReqDto);
            logger.info("\u6d4b\u8bd5\u53d1\u8d27\u901a\u77e5\u5355\u751f\u6210\u6210\u529f\uff0cID\uff1a{}", (Object)deliveryNoticeOrderId);
        }
        catch (Exception e) {
            logger.error("\u6d4b\u8bd5\u53d1\u8d27\u901a\u77e5\u5355\u751f\u6210\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
    }

    public RestResponse<String> addCargo(TcbjAdjustItemReqDto dto) {
        AssertUtil.isTrue(dto.getCargoId() != null, "\u672a\u4f20\u5165\u8d27\u53f7Id");
        return this.tcbjAdjustService.addCargo(dto);
    }

    public RestResponse<String> delCargo(TcbjAdjustItemReqDto dto) {
        AssertUtil.isTrue(dto.getCargoId() != null, "\u672a\u4f20\u5165\u8d27\u53f7Id");
        return this.tcbjAdjustService.delCargo(dto);
    }

    public RestResponse<String> audit(TcbjAdjustAuReqDto dto) {
        return this.tcbjAdjustService.audit(dto);
    }
}

