/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.impl;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.commons.CsCommonService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.SimpleGenerateCodeUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsTransferOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsDeliveryNoticeOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsDeliveryNoticeOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsOutNoticeOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.IdUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.inventory.CsTransferOrderDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsTransferOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateCargoReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsDeliveryNoticeOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsDeliveryNoticeOrderDetailAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsDeliveryNoticeOrderUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.BusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsDocumentActionEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsDocumentActionProcessEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsTransferOrderEnum;
import com.dtyunxi.yundt.cube.center.inventory.exception.CsInventoryExceptionCode;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.TradeItemRespDto;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.enums.BasicsOrderOperateTypeEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.enums.CsWarehouseClassifyEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.calc.ReleasePreemptDto;
import com.yunxi.dg.base.center.inventory.dto.domain.ContactDto;
import com.yunxi.dg.base.center.inventory.eo.BaseOrderAddressEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderEo;
import com.yunxi.dg.base.center.inventory.proxy.item.IItemSkuQueryApiProxy;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderFacade;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.ReceiveDeliveryNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.ReceiveDeliveryNoticeOrderFacadeBo;
import com.yunxi.dg.base.center.inventory.service.calc.ICalcInventoryService;
import com.yunxi.dg.base.center.item.ItemSkuDto;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.RepeatFilter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="csDeliveryNoticeOrderService")
public class CsDeliveryNoticeOrderServiceImpl
implements ICsDeliveryNoticeOrderService {
    private static final Logger logger = LoggerFactory.getLogger(CsDeliveryNoticeOrderServiceImpl.class);
    @Resource
    IReceiveDeliveryNoticeOrderDomain receiveDeliveryNoticeOrderDomain;
    @Resource
    IReceiveDeliveryResultOrderDomain receiveDeliveryResultOrderDomain;
    @Resource
    IReceiveDeliveryNoticeOrderDetailDomain receiveDeliveryNoticeOrderDetailDomain;
    @Resource
    ICsTransferOrderService transferOrderService;
    @Resource
    ILogicWarehouseDomain logicWarehouseDomain;
    @Resource
    CsCommonService csCommonService;
    @Resource
    ICalcInventoryService calcInventoryService;
    @Resource
    IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Resource
    IInOutNoticeOrderDetailDomain inOutNoticeOrderDetailDas;
    @Resource
    SimpleGenerateCodeUtil simpleGenerateCodeUtil;
    @Resource
    ICsDeliveryNoticeOrderQueryService csDeliveryNoticeOrderQueryService;
    @Resource
    private RepeatFilter repeatFilter;
    @Resource
    private ICsOutNoticeOrderService csOutNoticeOrderService;
    @Resource
    private CsTransferOrderDas csTransferOrderDas;
    @Autowired
    IItemSkuQueryApiProxy itemSkuProxy;
    @Resource
    private BaseOrderFacade baseOrderFacade;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long add(CsDeliveryNoticeOrderAddReqDto addReqDto) {
        logger.info("\u521b\u5efa\u53d1\u8d27\u5355\uff1a[addReqDto:{}]", (Object)LogUtils.buildLogContent(addReqDto));
        return this.addWithBaseOrderFacade(addReqDto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addWithBaseOrderFacade(CsDeliveryNoticeOrderAddReqDto addReqDto) {
        logger.info("\u4f7f\u7528BaseOrderFacade\u521b\u5efa\u53d1\u8d27\u5355\uff1a[addReqDto:{}]", (Object)LogUtils.buildLogContent(addReqDto));
        this.repeatFilter.checkRepeat("DeliveryNotice:" + addReqDto.getPreOrderNo(), () -> this.preValid(addReqDto), true);
        this.dataValid(addReqDto);
        ReceiveDeliveryNoticeOrderFacadeBo facadeBo = this.buildReceiveDeliveryNoticeOrderFacadeBo(addReqDto);
        ReceiveDeliveryNoticeOrderContext context = this.baseOrderFacade.deliveryNoticeOrderGen(facadeBo);
        ReceiveDeliveryNoticeOrderEo deliveryNoticeOrderEo = context.getReceiveDeliveryNoticeOrderEo();
        if (deliveryNoticeOrderEo != null) {
            return deliveryNoticeOrderEo.getId();
        }
        throw new RuntimeException("\u751f\u6210\u53d1\u8d27\u901a\u77e5\u5355\u5931\u8d25");
    }

    private ReceiveDeliveryNoticeOrderFacadeBo buildReceiveDeliveryNoticeOrderFacadeBo(CsDeliveryNoticeOrderAddReqDto addReqDto) {
        ReceiveDeliveryNoticeOrderFacadeBo facadeBo = new ReceiveDeliveryNoticeOrderFacadeBo();
        facadeBo.setPreOrderNo(addReqDto.getPreOrderNo());
        facadeBo.setExternalOrderNo(addReqDto.getExternalOrderNo());
        facadeBo.setBusinessType(String.valueOf(addReqDto.getBusinessType()));
        facadeBo.setRelevanceNo(addReqDto.getPreOrderNo());
        facadeBo.setPreOrderNo(addReqDto.getPreOrderNo());
        facadeBo.setRelevanceTableName(CsRelevanceTableNameEnum.CS_TRANSFER_ORDER);
        facadeBo.setLogicWarehouseCode(addReqDto.getWarehouseCode());
        facadeBo.setLogicWarehouseName(addReqDto.getWarehouseName());
        facadeBo.setPhysicsWarehouseCode(addReqDto.getWarehouseCode());
        facadeBo.setPhysicsWarehouseName(addReqDto.getWarehouseName());
        facadeBo.setAutoComplete(Boolean.valueOf(false));
        facadeBo.setIsSaleOrder(Boolean.valueOf(false));
        facadeBo.setValidNegative(Boolean.valueOf(true));
        facadeBo.setShoutBatch(Boolean.valueOf(true));
        facadeBo.setLendEnable(false);
        facadeBo.setLendForceBatchEnable(false);
        if (addReqDto.getContactDto() != null) {
            List<BaseOrderAddressEo> addressList = this.buildAddressList(addReqDto.getContactDto());
            facadeBo.setBaseOrderAddressEoList(addressList);
        }
        ArrayList detailReqDtoList = Lists.newArrayList();
        for (CsDeliveryNoticeOrderDetailAddReqDto detailAddReqDto : addReqDto.getDetailAddReqDtoList()) {
            BaseOrderDetailReqDto detailReqDto = new BaseOrderDetailReqDto();
            detailReqDto.setSkuCode(detailAddReqDto.getCargoCode());
            detailReqDto.setSkuName(detailAddReqDto.getCargoName());
            detailReqDto.setBatch(detailAddReqDto.getBatch());
            detailReqDto.setQuantity(detailAddReqDto.getPlanQuantity());
            detailReqDto.setPreOrderItemId(detailAddReqDto.getTradeOrderItemId());
            detailReqDto.setExtension(JSON.toJSONString((Object)detailAddReqDto));
            detailReqDtoList.add(detailReqDto);
        }
        facadeBo.setOrderBasicsDetailReqDtoList((List)detailReqDtoList);
        if (addReqDto.getContactDto() != null) {
            facadeBo.setExtension(JSON.toJSONString((Object)addReqDto.getContactDto()));
        }
        return facadeBo;
    }

    private List<BaseOrderAddressEo> buildAddressList(ContactDto contactDto) {
        ArrayList addressList = Lists.newArrayList();
        if (contactDto != null) {
            BaseOrderAddressEo addressEo = new BaseOrderAddressEo();
            addressEo.setContacts(contactDto.getReciveName());
            addressEo.setPhone(contactDto.getRecivePhone());
            addressEo.setDetailAddress(contactDto.getAddress());
            if (contactDto.getExtFields() != null && !contactDto.getExtFields().isEmpty()) {
                addressEo.setExtension(JSON.toJSONString((Object)contactDto.getExtFields()));
            }
            addressList.add(addressEo);
        }
        return addressList;
    }

    private void dataValid(CsDeliveryNoticeOrderAddReqDto addReqDto) {
        AssertUtil.isTrue(!Strings.isNullOrEmpty((String)addReqDto.getWarehouseCode()), "\u672a\u4f20\u5165\u4ed3\u5e93\u7f16\u7801");
        AssertUtil.isTrue(!Strings.isNullOrEmpty((String)addReqDto.getPreOrderNo()), "\u672a\u4f20\u5165\u524d\u7f6e\u4e1a\u52a1\u5355\u636e");
        AssertUtil.isTrue(addReqDto.getBusinessType() != null, "\u672a\u4f20\u5165\u7c7b\u578b");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)BusinessTypeEnum.getDescByCode((String)addReqDto.getBusinessType())), "\u4e1a\u52a1\u7c7b\u578b\u4e0d\u5b58\u5728");
        List logicWarehouseEos = this.logicWarehouseDomain.queryByCodes((List)Lists.newArrayList((Object[])new String[]{addReqDto.getWarehouseCode()}));
        List cargoList = addReqDto.getDetailAddReqDtoList().stream().map(CsDeliveryNoticeOrderDetailAddReqDto::getCargoCode).collect(Collectors.toList());
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)logicWarehouseEos), "\u4ed3\u5e93\u4e0d\u5b58\u5728");
        AssertUtil.isTrue(CollectionUtils.isNotEmpty(cargoList), "\u8d27\u54c1\u4e0d\u5b58\u5728");
        List cargoEoList = this.itemSkuProxy.queryBySkuCodes(cargoList);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)cargoEoList), "\u8d27\u54c1\u672a\u914d\u7f6e");
        if (cargoEoList.size() != cargoList.size()) {
            logger.info("error,\u8d27\u54c1\u4e0d\u4e00\u81f4\uff0c\u540e\u7eed\u5904\u7406\uff1b");
        }
        LogicWarehouseEo csLogicWarehouseEo = (LogicWarehouseEo)logicWarehouseEos.get(0);
        addReqDto.setWarehouseId(csLogicWarehouseEo.getId());
        addReqDto.setWarehouseName(csLogicWarehouseEo.getWarehouseName());
        addReqDto.setWarehouseClassify(CsWarehouseClassifyEnum.LOGIC.getCode());
        addReqDto.setOrganizationId(csLogicWarehouseEo.getOrganizationId());
        addReqDto.setOrganizationName(csLogicWarehouseEo.getOrganizationName());
        Map<String, ItemSkuDto> cargoMap = cargoEoList.stream().collect(Collectors.toMap(ItemSkuDto::getSkuCode, entity -> entity));
        for (CsDeliveryNoticeOrderDetailAddReqDto detailAddReqDto : addReqDto.getDetailAddReqDtoList()) {
            ItemSkuDto cargoEo = cargoMap.get(detailAddReqDto.getCargoCode());
            if (null == cargoEo) {
                logger.info("error,\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728\uff0c\u540e\u7eed\u5904\u7406");
                continue;
            }
            detailAddReqDto.setCargoId(cargoEo.getId());
            detailAddReqDto.setCargoName(cargoEo.getSkuName());
            detailAddReqDto.setWaitQuantity(detailAddReqDto.getPlanQuantity());
        }
    }

    private void preValid(CsDeliveryNoticeOrderAddReqDto addReqDto) {
        List oldList = this.receiveDeliveryNoticeOrderDomain.queryByPreOrderNo(addReqDto.getPreOrderNo());
        if (CollectionUtils.isNotEmpty((Collection)oldList)) {
            for (ReceiveDeliveryNoticeOrderEo deliveryNoticeOrderEo : oldList) {
                AssertUtil.isTrue(BaseOrderStatusEnum.DELIVERY_CANCEL.getCode().equals(deliveryNoticeOrderEo.getOrderStatus()), CsInventoryExceptionCode.EXIST_PRE_ORDER.getCode(), deliveryNoticeOrderEo.getPreOrderNo() + CsInventoryExceptionCode.EXIST_PRE_ORDER.getMsg());
            }
        }
    }

    @Override
    public void update(Long id, CsDeliveryNoticeOrderUpdateReqDto updateReqDto) {
        logger.info("\u4fee\u6539\u53c2\u6570\uff1a[id:{}, {}]", (Object)id, (Object)LogUtils.buildLogContent(updateReqDto));
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(updateReqDto != null, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        ReceiveDeliveryNoticeOrderEo updateEo = new ReceiveDeliveryNoticeOrderEo();
        CubeBeanUtils.copyProperties((Object)updateEo, (Object)updateReqDto, (String[])new String[0]);
        updateEo.setId(id);
        this.receiveDeliveryNoticeOrderDomain.updateSelective((BaseEo)updateEo);
    }

    @Override
    public void delete(Long id) {
        logger.info("\u5220\u9664\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        ReceiveDeliveryNoticeOrderEo eo = this.csDeliveryNoticeOrderQueryService.selectByPrimaryKey(id);
        AssertUtil.isTrue(eo != null, "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        this.receiveDeliveryNoticeOrderDomain.logicDeleteById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public void updateOrderStatus(String preOrderNo, String action) {
        logger.info("\u4fee\u6539\u53d1\u8d27\u5355\u5355\u636e\u72b6\u6001\uff1a[preOrderNo:{},action:{}]", (Object)preOrderNo, (Object)action);
        String descByCode = CsDocumentActionEnum.getDescByCode((String)action);
        AssertUtil.isTrue(null != descByCode, CsInventoryExceptionCode.OPERATION_NOT_EXIST.getCode(), CsInventoryExceptionCode.OPERATION_NOT_EXIST.getMsg());
        List deliveryNoticeOrderEoList = this.receiveDeliveryNoticeOrderDomain.queryByPreOrderNo(preOrderNo);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)deliveryNoticeOrderEoList), CsInventoryExceptionCode.DELIVERY_NOTICE_NOT_EXIST.getCode(), CsInventoryExceptionCode.DELIVERY_NOTICE_NOT_EXIST.getMsg());
        ReceiveDeliveryNoticeOrderEo ReceiveDeliveryNoticeOrderEo2 = new ReceiveDeliveryNoticeOrderEo();
        for (ReceiveDeliveryNoticeOrderEo deliveryNoticeOrderEo : deliveryNoticeOrderEoList) {
            if (BaseOrderStatusEnum.DELIVERY_CANCEL.getCode().equals(deliveryNoticeOrderEo.getOrderStatus())) continue;
            ReceiveDeliveryNoticeOrderEo2 = deliveryNoticeOrderEo;
        }
        if (null == ReceiveDeliveryNoticeOrderEo2.getId()) {
            logger.info("\u65e0\u9700\u4fee\u6539\u5355\u636e\u72b6\u6001\uff1a[preOrderNo\uff1a{}\uff0caction:{}]", (Object)preOrderNo, (Object)action);
            return;
        }
        String suffixByAction = CsDocumentActionProcessEnum.getSuffixByAction((String)ReceiveDeliveryNoticeOrderEo2.getOrderStatus(), (String)action);
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)suffixByAction), CsInventoryExceptionCode.OPERATION_ERROR_DOCUMENT.getCode(), CsInventoryExceptionCode.OPERATION_ERROR_DOCUMENT.getMsg() + BaseOrderStatusEnum.getDescByCode((String)ReceiveDeliveryNoticeOrderEo2.getOrderStatus()));
        ReceiveDeliveryNoticeOrderEo ReceiveDeliveryNoticeOrderEo1 = new ReceiveDeliveryNoticeOrderEo();
        ReceiveDeliveryNoticeOrderEo1.setId(ReceiveDeliveryNoticeOrderEo2.getId());
        ReceiveDeliveryNoticeOrderEo1.setOrderStatus(suffixByAction);
        this.receiveDeliveryNoticeOrderDomain.updateSelective((BaseEo)ReceiveDeliveryNoticeOrderEo1);
        logger.info("\u4fee\u6539\u5355\u636e\u72b6\u6001\u6210\u529f\uff1a[preOrderNo\uff1a{}\uff0caction:{},suffixByAction\uff1a{}]", new Object[]{preOrderNo, action, suffixByAction});
    }

    @Override
    public void onlyUpdateDocumentStatus(String preOrderNo, String orderStatus) {
        BaseOrderStatusEnum statusByCode = BaseOrderStatusEnum.getStatusByCode((String)orderStatus);
        AssertUtil.isTrue(null != statusByCode, CsInventoryExceptionCode.UPDATE_STATUS_NOT_EXIST.getCode(), CsInventoryExceptionCode.UPDATE_STATUS_NOT_EXIST.getMsg());
        List deliveryNoticeOrderEoList = this.receiveDeliveryNoticeOrderDomain.queryByPreOrderNo(preOrderNo);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)deliveryNoticeOrderEoList), CsInventoryExceptionCode.DELIVERY_NOTICE_NOT_EXIST.getCode(), CsInventoryExceptionCode.DELIVERY_NOTICE_NOT_EXIST.getMsg());
        ReceiveDeliveryNoticeOrderEo ReceiveDeliveryNoticeOrderEo1 = new ReceiveDeliveryNoticeOrderEo();
        ReceiveDeliveryNoticeOrderEo1.setId(((ReceiveDeliveryNoticeOrderEo)deliveryNoticeOrderEoList.get(0)).getId());
        ReceiveDeliveryNoticeOrderEo1.setOrderStatus(orderStatus);
        this.receiveDeliveryNoticeOrderDomain.updateSelective((BaseEo)ReceiveDeliveryNoticeOrderEo1);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Integer updateDetailBatch(CsInventoryOperateReqDto csInventoryOperateReqDto) {
        String documentNo = this.valid(csInventoryOperateReqDto);
        List detailEoList = this.receiveDeliveryNoticeOrderDetailDomain.queryByDocumentNo(documentNo);
        HashMap<String, ReceiveDeliveryNoticeOrderDetailEo> detailMap = new HashMap<String, ReceiveDeliveryNoticeOrderDetailEo>(detailEoList.size());
        HashMap<String, ReceiveDeliveryNoticeOrderDetailEo> detailMap1 = new HashMap<String, ReceiveDeliveryNoticeOrderDetailEo>(detailEoList.size());
        for (ReceiveDeliveryNoticeOrderDetailEo detailEo : detailEoList) {
            detailMap.put(detailEo.getSkuCode() + detailEo.getActivityId(), detailEo);
            detailMap1.put(detailEo.getSkuCode(), detailEo);
        }
        List detailIds = detailEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
        this.receiveDeliveryNoticeOrderDetailDomain.getMapper().deleteBatchIds(detailIds);
        ArrayList list = Lists.newArrayList();
        for (CsInventoryOperateCargoReqDto cargoReqDto : csInventoryOperateReqDto.getOperateCargoReqDtoList()) {
            ReceiveDeliveryNoticeOrderDetailEo eo = (ReceiveDeliveryNoticeOrderDetailEo)detailMap.get(cargoReqDto.getCargoCode() + cargoReqDto.getActivityId());
            if (null == eo) {
                eo = (ReceiveDeliveryNoticeOrderDetailEo)detailMap1.get(cargoReqDto.getCargoCode());
            }
            ReceiveDeliveryNoticeOrderDetailEo detailEo = new ReceiveDeliveryNoticeOrderDetailEo();
            BeanUtils.copyProperties((Object)eo, (Object)detailEo);
            detailEo.setId(IdUtils.getId());
            detailEo.setPlanQuantity(cargoReqDto.getChangeInventory());
            detailEo.setWaitQuantity(cargoReqDto.getChangeInventory());
            detailEo.setBatch(cargoReqDto.getBatch());
            detailEo.setActivityId(cargoReqDto.getActivityId());
            list.add(detailEo);
        }
        return this.receiveDeliveryNoticeOrderDetailDomain.insertBatch((List)list);
    }

    @Override
    public String updateDetailBatch(OrderDetailRespDto orderDetailRespDto) {
        Map<String, String> cargoBatchMap = this.paramValid(orderDetailRespDto);
        List detailEoList = this.receiveDeliveryNoticeOrderDetailDomain.queryByDocumentNo(orderDetailRespDto.getOrigOrderNo());
        for (ReceiveDeliveryNoticeOrderDetailEo detailEo : detailEoList) {
            String batchNo = cargoBatchMap.get(detailEo.getSkuCode());
            detailEo.setBatch(batchNo);
            this.receiveDeliveryNoticeOrderDetailDomain.getMapper().updateById((BaseEo)detailEo);
        }
        return "0";
    }

    private Map<String, String> paramValid(OrderDetailRespDto orderDetailRespDto) {
        AssertUtil.isTrue(!Strings.isNullOrEmpty((String)orderDetailRespDto.getOrderNo()), "\u524d\u7f6e\u5355\u636e\u53f7\u4e3a\u7a7a");
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)orderDetailRespDto.getOrderItems()), "\u524d\u7f6e\u5355\u636e\u5173\u8054\u7684\u5546\u54c1\u4fe1\u606f\u4e3a\u7a7a");
        List deliveryNoticeOrderEoList = this.receiveDeliveryNoticeOrderDomain.queryByPreOrderNo(orderDetailRespDto.getOrderNo());
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)deliveryNoticeOrderEoList), "\u524d\u7f6e\u5355\u636e\u4e0d\u5b58\u5728\u53d1\u8d27\u901a\u77e5\u5355");
        ReceiveDeliveryNoticeOrderEo deliveryNoticeOrderEo = (ReceiveDeliveryNoticeOrderEo)deliveryNoticeOrderEoList.get(0);
        AssertUtil.isTrue(CsOrderStatusEnum.INIT.getCode().equals(deliveryNoticeOrderEo.getOrderStatus()) || CsOrderStatusEnum.DELIVERY_WAIT_AUDIT.getCode().equals(deliveryNoticeOrderEo.getOrderStatus()) || CsOrderStatusEnum.ADJUST_REFUSE.getCode().equals(deliveryNoticeOrderEo.getOrderStatus()), "\u5355\u636e\u5df2\u901a\u77e5\u51fa\u5e93\uff0c\u4e0d\u80fd\u66f4\u65b0\u6279\u6b21");
        HashMap<String, String> cargoBatchMap = new HashMap<String, String>();
        for (TradeItemRespDto orderItem : orderDetailRespDto.getOrderItems()) {
            AssertUtil.isTrue(!Strings.isNullOrEmpty((String)orderItem.getCargoSerial()) || !Strings.isNullOrEmpty((String)orderItem.getBatchNo()), "\u8d27\u54c1\u7f16\u7801/\u6279\u6b21\u4e0d\u80fd\u4e3a\u7a7a");
            cargoBatchMap.put(orderItem.getCargoSerial(), orderItem.getBatchNo());
        }
        orderDetailRespDto.setOrigOrderNo(deliveryNoticeOrderEo.getDocumentNo());
        return cargoBatchMap;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void cancelByDocumentNo(String cancelByDocumentNo) {
        logger.info("\u6839\u636e\u6536\u53d1\u8d27\u901a\u77e5\u5355\u53d6\u6d88\u6807\u51c6\u5355{}", (Object)cancelByDocumentNo);
        AssertUtil.isTrue(!Strings.isNullOrEmpty((String)cancelByDocumentNo), "\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"document_no", new Object[]{cancelByDocumentNo});
        queryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        ReceiveDeliveryNoticeOrderEo csDeliveryNoticeOrderEo = (ReceiveDeliveryNoticeOrderEo)this.receiveDeliveryNoticeOrderDomain.getMapper().selectOne((Wrapper)queryWrapper);
        AssertUtil.isTrue(!Objects.isNull(csDeliveryNoticeOrderEo), "\u901a\u77e5\u5355\u4e0d\u5b58\u5728");
        if (BasicsOrderOperateTypeEnum.RECEIVE.getCode().equalsIgnoreCase(csDeliveryNoticeOrderEo.getOrderType())) {
            AssertUtil.isTrue(BaseOrderStatusEnum.RNO_WAIT_RECEIVE.getCode().equals(csDeliveryNoticeOrderEo.getOrderStatus()) || BaseOrderStatusEnum.RNO_PORTION_RECEIVE.getCode().equals(csDeliveryNoticeOrderEo.getOrderStatus()), "\u6536\u8d27\u901a\u77e5\u5355\u72b6\u6001\u4e0d\u6b63\u786e\u53ea\u6709\u5f85\u6536\u8d27/\u90e8\u5206\u6536\u8d27\u624d\u80fd\u5b8c\u7ed3!");
        }
        if (BasicsOrderOperateTypeEnum.DELIVERY.getCode().equalsIgnoreCase(csDeliveryNoticeOrderEo.getOrderType())) {
            AssertUtil.isTrue(BaseOrderStatusEnum.DNO_WAIT_DELIVERY.getCode().equals(csDeliveryNoticeOrderEo.getOrderStatus()) || BaseOrderStatusEnum.DNO_PORTION_DELIVERY.getCode().equals(csDeliveryNoticeOrderEo.getOrderStatus()), "\u53d1\u8d27\u901a\u77e5\u5355\u72b6\u6001\u4e0d\u6b63\u786e\u53ea\u6709\u5f85\u51fa\u5e93/\u90e8\u5206\u51fa\u5e93\u624d\u80fd\u5b8c\u7ed3!");
        }
        AssertUtil.isTrue(CsRelevanceTableNameEnum.CS_TRANSFER_ORDER.getCode().equals(csDeliveryNoticeOrderEo.getRelevanceTableName()), "\u975e\u8c03\u62e8\u5355\u5355\u636e\u4e0d\u5141\u8bb8\u5173\u95ed");
        CsTransferOrderEo transferOrder = (CsTransferOrderEo)((ExtQueryChainWrapper)this.csTransferOrderDas.filter().eq((Object)"transfer_order_no", (Object)csDeliveryNoticeOrderEo.getRelevanceNo())).one();
        AssertUtil.isTrue(Objects.nonNull(transferOrder), "\u8c03\u62e8\u5355\u4e0d\u5b58\u5728");
        List deliveryList = ((ExtQueryChainWrapper)this.receiveDeliveryNoticeOrderDetailDomain.filter().eq((Object)"document_no", (Object)csDeliveryNoticeOrderEo.getDocumentNo())).list();
        for (ReceiveDeliveryNoticeOrderDetailEo deliveryNoticeOrderDetailEo : deliveryList) {
            deliveryNoticeOrderDetailEo.setCancelQuantity(deliveryNoticeOrderDetailEo.getWaitQuantity());
            deliveryNoticeOrderDetailEo.setWaitQuantity(BigDecimal.ZERO);
        }
        deliveryList.forEach(d -> {
            ReceiveDeliveryNoticeOrderDetailEo deliveryUpdate = new ReceiveDeliveryNoticeOrderDetailEo();
            deliveryUpdate.setId(d.getId());
            deliveryUpdate.setCancelQuantity(d.getCancelQuantity());
            deliveryUpdate.setWaitQuantity(d.getWaitQuantity());
            this.receiveDeliveryNoticeOrderDetailDomain.updateSelective((BaseEo)deliveryUpdate);
        });
        ReceiveDeliveryNoticeOrderEo deliveryUpdate = new ReceiveDeliveryNoticeOrderEo();
        deliveryUpdate.setId(csDeliveryNoticeOrderEo.getId());
        deliveryUpdate.setOrderStatus(BaseOrderStatusEnum.FINISH_OVER.getCode());
        this.receiveDeliveryNoticeOrderDomain.updateSelective((BaseEo)deliveryUpdate);
        List csOutNoticeOrderEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"pre_order_no", (Object)csDeliveryNoticeOrderEo.getDocumentNo())).eq((Object)"dr", (Object)YesNoEnum.NO.getValue())).list();
        if (!Objects.isNull(csOutNoticeOrderEos) && CollectionUtils.isNotEmpty((Collection)csOutNoticeOrderEos)) {
            csOutNoticeOrderEos.stream().forEach(closeInfo -> {
                if (BaseOrderStatusEnum.INO_TOTAL_IN.getCode().equals(closeInfo.getOrderStatus()) || BaseOrderStatusEnum.ONO_TOTAL_OUT.getCode().equals(closeInfo.getOrderStatus()) || BaseOrderStatusEnum.ONO_CANCEL.getCode().equals(closeInfo.getOrderStatus()) || BaseOrderStatusEnum.INO_CANCEL.getCode().equals(closeInfo.getOrderStatus())) {
                    return;
                }
                List outNoticeOrderDetailEoList = ((ExtQueryChainWrapper)this.inOutNoticeOrderDetailDas.filter().eq((Object)"document_no", (Object)closeInfo.getDocumentNo())).list();
                for (InOutNoticeOrderDetailEo outNoticeOrderDetailEo : outNoticeOrderDetailEoList) {
                    outNoticeOrderDetailEo.setCancelQuantity(outNoticeOrderDetailEo.getWaitQuantity());
                    outNoticeOrderDetailEo.setWaitQuantity(BigDecimal.ZERO);
                }
                outNoticeOrderDetailEoList.forEach(out -> {
                    InOutNoticeOrderDetailEo outUpdate = new InOutNoticeOrderDetailEo();
                    outUpdate.setId(out.getId());
                    outUpdate.setCancelQuantity(out.getCancelQuantity());
                    outUpdate.setWaitQuantity(out.getWaitQuantity());
                    this.inOutNoticeOrderDetailDas.updateSelective((BaseEo)out);
                });
                InOutNoticeOrderEo update = new InOutNoticeOrderEo();
                update.setId(closeInfo.getId());
                update.setOrderStatus(BaseOrderStatusEnum.FINISH_OVER.getCode());
                this.inOutNoticeOrderDomain.updateSelective((BaseEo)update);
            });
        }
        BigDecimal deliveryTotal = this.getDeliveryResultTotal(csDeliveryNoticeOrderEo.getRelevanceNo(), BasicsOrderOperateTypeEnum.DELIVERY.getCode().toLowerCase());
        CsTransferOrderEo csTransferOrderEo = new CsTransferOrderEo();
        csTransferOrderEo.setId(transferOrder.getId());
        csTransferOrderEo.setTotalQuantity(deliveryTotal);
        this.csTransferOrderDas.updateSelective((BaseEo)csTransferOrderEo);
        BigDecimal receiveTotal = this.getDeliveryNoticeTotal(csDeliveryNoticeOrderEo.getRelevanceNo(), BasicsOrderOperateTypeEnum.RECEIVE.getCode().toLowerCase());
        logger.info("\u5b8c\u7ed3\u6536\u53d1\u8d27\u901a\u77e5\u5355\uff0c\u5224\u5b9a\u8c03\u62e8\u5355\u72b6\u6001\u7684\u6570\u91cf\u662f:deliveryTotal:{},receiveTotal:{}", (Object)deliveryTotal, (Object)receiveTotal);
        if (!Objects.isNull(receiveTotal) && deliveryTotal.compareTo(receiveTotal) == 0) {
            CsTransferOrderEo updateEo = new CsTransferOrderEo();
            updateEo.setId(transferOrder.getId());
            updateEo.setOrderStatus(CsTransferOrderEnum.Status.FINISH.getCode());
            this.csTransferOrderDas.updateSelective((BaseEo)updateEo);
            this.transferOrderService.dispatcherTransferOrder(csDeliveryNoticeOrderEo.getRelevanceNo());
        }
        if (BasicsOrderOperateTypeEnum.DELIVERY.getCode().equalsIgnoreCase(csDeliveryNoticeOrderEo.getOrderType())) {
            logger.info("\u5f00\u59cb\u8fdb\u884c\u5e93\u5b58\u7684\u9884\u5360\u91ca\u653e:{}", (Object)csDeliveryNoticeOrderEo.getDocumentNo());
            ReleasePreemptDto releasePreemptDto = new ReleasePreemptDto();
            releasePreemptDto.setSourceNo(csDeliveryNoticeOrderEo.getRelevanceNo());
            releasePreemptDto.setSourceType(csDeliveryNoticeOrderEo.getRelevanceTableName());
            releasePreemptDto.setBusinessType(transferOrder.getType());
            this.calcInventoryService.releasePreempt(releasePreemptDto);
        }
    }

    private String valid(CsInventoryOperateReqDto csInventoryOperateReqDto) {
        AssertUtil.isTrue(!Strings.isNullOrEmpty((String)csInventoryOperateReqDto.getSourceNo()), CsInventoryExceptionCode.PRE_ORDER_IS_NULL.getCode(), CsInventoryExceptionCode.PRE_ORDER_IS_NULL.getMsg());
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)csInventoryOperateReqDto.getOperateCargoReqDtoList()), CsInventoryExceptionCode.PRE_ORDER_RELEVANCE_ITEM_IS_NULL.getCode(), CsInventoryExceptionCode.PRE_ORDER_RELEVANCE_ITEM_IS_NULL.getMsg());
        List deliveryNoticeOrderEoList = this.receiveDeliveryNoticeOrderDomain.queryByPreOrderNo(csInventoryOperateReqDto.getSourceNo());
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)deliveryNoticeOrderEoList), CsInventoryExceptionCode.DELIVERY_NOTICE_NOT_EXIST.getCode(), CsInventoryExceptionCode.DELIVERY_NOTICE_NOT_EXIST.getMsg());
        ReceiveDeliveryNoticeOrderEo deliveryNoticeOrderEo = (ReceiveDeliveryNoticeOrderEo)deliveryNoticeOrderEoList.get(0);
        AssertUtil.isTrue(BaseOrderStatusEnum.INIT.getCode().equals(deliveryNoticeOrderEo.getOrderStatus()) || BaseOrderStatusEnum.DELIVERY_WAIT_AUDIT.getCode().equals(deliveryNoticeOrderEo.getOrderStatus()) || BaseOrderStatusEnum.ADJUST_REFUSE.getCode().equals(deliveryNoticeOrderEo.getOrderStatus()), CsInventoryExceptionCode.DOCUMENT_ALWAYS_OUT.getCode(), CsInventoryExceptionCode.DOCUMENT_ALWAYS_OUT.getMsg());
        for (CsInventoryOperateCargoReqDto orderItem : csInventoryOperateReqDto.getOperateCargoReqDtoList()) {
            AssertUtil.isTrue(!Strings.isNullOrEmpty((String)orderItem.getCargoCode()) || !Strings.isNullOrEmpty((String)orderItem.getBatch()), "\u8d27\u54c1\u7f16\u7801/\u6279\u6b21\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return deliveryNoticeOrderEo.getDocumentNo();
    }

    @Override
    public Boolean generateOutNoticeOrder(String orderNo) {
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean batchUpdateNoticeStatusPass(List<String> preOrderNoList) {
        logger.info("\u6279\u91cf\u66f4\u65b0\u53d1\u8d27\u901a\u77e5\u5355\u72b6\u6001(\u901a\u8fc7)\uff0c\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString(preOrderNoList));
        this.repeatFilter.checkRepeat("BatchUpdateOrderStatusPass:", () -> this.validParam(preOrderNoList), true);
        List<ReceiveDeliveryNoticeOrderDetailEo> detailEoList = this.queryByPreOrderNoList(preOrderNoList);
        AssertUtil.isTrue(CollectionUtils.isEmpty(detailEoList), "\u6279\u91cf\u64cd\u4f5c\u4e2d\u5b58\u5728\u90e8\u5206\u672a\u6307\u5b9a\u6279\u6b21\u7684\u5355\u636e\uff0c\u8bf7\u6838\u5bf9\u540e\u64cd\u4f5c\uff01\u5355\u636e\u53f7\uff1a" + JSON.toJSONString(detailEoList.stream().map(ReceiveDeliveryNoticeOrderDetailEo::getPreOrderNo).distinct().collect(Collectors.toList())));
        List<ReceiveDeliveryNoticeOrderEo> deliveryNoticeOrderEoList = this.queryNoticeByPreOrderNoList(preOrderNoList);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty(deliveryNoticeOrderEoList), "\u524d\u7f6e\u5355\u636e\u5173\u8054\u7684\u53d1\u8d27\u901a\u77e5\u5355\u4e0d\u5b58\u5728");
        for (ReceiveDeliveryNoticeOrderEo deliveryNoticeOrderEo : deliveryNoticeOrderEoList) {
            AssertUtil.isTrue(BaseOrderStatusEnum.DELIVERY_WAIT_AUDIT.getCode().equals(deliveryNoticeOrderEo.getOrderStatus()), "\u5b58\u5728\u975e\u8d22\u52a1\u5ba1\u6838\u6d41\u7a0b\u5ba1\u6838\u5355\u636e\uff0c\u8bf7\u6838\u5bf9\u540e\u64cd\u4f5c\uff01");
            ReceiveDeliveryNoticeOrderEo deliveryNoticeOrderEo1 = new ReceiveDeliveryNoticeOrderEo();
            deliveryNoticeOrderEo1.setId(deliveryNoticeOrderEo.getId());
            deliveryNoticeOrderEo1.setOrderStatus(BaseOrderStatusEnum.DELIVERY_OUT_ING.getCode());
            this.receiveDeliveryNoticeOrderDomain.getMapper().updateById((BaseEo)deliveryNoticeOrderEo1);
        }
        logger.info("\u6279\u91cf\u66f4\u65b0\u53d1\u8d27\u901a\u77e5\u5355\u72b6\u6001(\u901a\u8fc7)\uff0c\u5f00\u59cb\u904d\u5386\u751f\u6210\u51fa\u5e93\u901a\u77e5\u5355");
        for (ReceiveDeliveryNoticeOrderEo deliveryNoticeOrderEo : deliveryNoticeOrderEoList) {
            this.csOutNoticeOrderService.createOutNoticeOrder(deliveryNoticeOrderEo.getDocumentNo());
        }
        logger.info("\u6279\u91cf\u66f4\u65b0\u53d1\u8d27\u901a\u77e5\u5355\u72b6\u6001(\u901a\u8fc7)\uff0c\u904d\u5386\u751f\u6210\u51fa\u5e93\u901a\u77e5\u5355\u5b8c\u6210");
        return true;
    }

    private List<ReceiveDeliveryNoticeOrderDetailEo> queryByPreOrderNoList(List<String> preOrderNoList) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"pre_order_no", preOrderNoList);
        queryWrapper.isNull((Object)"batch");
        return this.receiveDeliveryNoticeOrderDetailDomain.getMapper().selectList((Wrapper)queryWrapper);
    }

    private void validParam(List<String> preOrderNoList) {
        AssertUtil.isTrue(CollectionUtils.isNotEmpty(preOrderNoList), "\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u5355\u636e\uff01");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean batchUpdateNoticeStatusNoPass(List<String> preOrderNoList) {
        logger.info("\u6279\u91cf\u66f4\u65b0\u53d1\u8d27\u901a\u77e5\u5355\u72b6\u6001(\u4e0d\u901a\u8fc7)\uff0c\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString(preOrderNoList));
        this.repeatFilter.checkRepeat("BatchUpdateOrderStatusNoPass:", () -> this.validParam(preOrderNoList), true);
        List<ReceiveDeliveryNoticeOrderEo> deliveryNoticeOrderEoList = this.queryNoticeByPreOrderNoList(preOrderNoList);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty(deliveryNoticeOrderEoList), "\u524d\u7f6e\u5355\u636e\u5173\u8054\u7684\u53d1\u8d27\u901a\u77e5\u5355\u4e0d\u5b58\u5728");
        for (ReceiveDeliveryNoticeOrderEo deliveryNoticeOrderEo : deliveryNoticeOrderEoList) {
            AssertUtil.isTrue(BaseOrderStatusEnum.DELIVERY_WAIT_AUDIT.getCode().equals(deliveryNoticeOrderEo.getOrderStatus()), "\u5b58\u5728\u975e\u8d22\u52a1\u5ba1\u6838\u6d41\u7a0b\u5ba1\u6838\u5355\u636e\uff0c\u8bf7\u6838\u5bf9\u540e\u64cd\u4f5c\uff01");
            ReceiveDeliveryNoticeOrderEo deliveryNoticeOrderEo1 = new ReceiveDeliveryNoticeOrderEo();
            deliveryNoticeOrderEo1.setId(deliveryNoticeOrderEo.getId());
            deliveryNoticeOrderEo1.setOrderStatus(BaseOrderStatusEnum.ADJUST_REFUSE.getCode());
            this.receiveDeliveryNoticeOrderDomain.getMapper().updateById((BaseEo)deliveryNoticeOrderEo1);
        }
        logger.info("\u6279\u91cf\u66f4\u65b0\u53d1\u8d27\u901a\u77e5\u5355\u72b6\u6001(\u4e0d\u901a\u8fc7)\uff0c\u5f00\u59cb\u904d\u5386\u91ca\u653e\u9884\u5360\u5e93\u5b58");
        for (ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo : deliveryNoticeOrderEoList) {
        }
        logger.info("\u6279\u91cf\u66f4\u65b0\u53d1\u8d27\u901a\u77e5\u5355\u72b6\u6001(\u4e0d\u901a\u8fc7)\uff0c\u904d\u5386\u751f\u91ca\u653e\u9884\u5360\u5e93\u5b58\u5b8c\u6210");
        return true;
    }

    private List<ReceiveDeliveryNoticeOrderEo> queryNoticeByPreOrderNoList(List<String> preOrderNoList) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"pre_order_no", preOrderNoList);
        return this.receiveDeliveryNoticeOrderDomain.getMapper().selectList((Wrapper)queryWrapper);
    }

    @Override
    public void onlyUpdateDocumentStatusUnCheck(String preOrderNo, String orderStatus) {
        logger.info("onlyUpdateDocumentStatusUnCheck==>preOrderNo:{},orderStatus:{}", (Object)preOrderNo, (Object)orderStatus);
        BaseOrderStatusEnum statusByCode = BaseOrderStatusEnum.getStatusByCode((String)orderStatus);
        AssertUtil.isTrue(null != statusByCode, "\u53d8\u66f4\u72b6\u6001\u4e0d\u5b58\u5728");
        List deliveryNoticeOrderEoList = this.receiveDeliveryNoticeOrderDomain.queryByPreOrderNo(preOrderNo);
        if (CollectionUtils.isEmpty((Collection)deliveryNoticeOrderEoList)) {
            return;
        }
        logger.info("onlyUpdateDocumentStatusUnCheck==>deliveryNoticeOrderEoList:{}", (Object)LogUtils.buildLogContent(deliveryNoticeOrderEoList));
        ReceiveDeliveryNoticeOrderEo ReceiveDeliveryNoticeOrderEo1 = new ReceiveDeliveryNoticeOrderEo();
        ReceiveDeliveryNoticeOrderEo1.setId(((ReceiveDeliveryNoticeOrderEo)deliveryNoticeOrderEoList.get(0)).getId());
        ReceiveDeliveryNoticeOrderEo1.setOrderStatus(orderStatus);
        this.receiveDeliveryNoticeOrderDomain.updateSelective((BaseEo)ReceiveDeliveryNoticeOrderEo1);
    }

    private BigDecimal getDeliveryResultTotal(String relevanceNo, String orderType) {
        BigDecimal totalQuantity = BigDecimal.ZERO;
        if (StringUtils.isNotEmpty((CharSequence)relevanceNo)) {
            ReceiveDeliveryResultOrderEo csDeliveryResultOrderEo = new ReceiveDeliveryResultOrderEo();
            csDeliveryResultOrderEo.setRelevanceNo(relevanceNo);
            csDeliveryResultOrderEo.setOrderType(orderType);
            csDeliveryResultOrderEo.setDr(YesNoEnum.NO.getValue());
            List csDeliveryResultOrderList = this.receiveDeliveryResultOrderDomain.selectList((BaseEo)csDeliveryResultOrderEo, Integer.valueOf(1), Integer.valueOf(10000));
            if (CollectionUtils.isNotEmpty((Collection)csDeliveryResultOrderList)) {
                totalQuantity = csDeliveryResultOrderList.stream().map(ReceiveDeliveryResultOrderEo::getTotalQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
        }
        return totalQuantity;
    }

    private BigDecimal getDeliveryNoticeTotal(String relevanceNo, String orderType) {
        BigDecimal totalQuantity = BigDecimal.ZERO;
        if (StringUtils.isNotEmpty((CharSequence)relevanceNo)) {
            ReceiveDeliveryNoticeOrderEo csDeliveryNoticeOrderEo = new ReceiveDeliveryNoticeOrderEo();
            csDeliveryNoticeOrderEo.setRelevanceNo(relevanceNo);
            csDeliveryNoticeOrderEo.setOrderType(orderType);
            csDeliveryNoticeOrderEo.setDr(YesNoEnum.NO.getValue());
            List csDeliveryNoticeOrderEos = this.receiveDeliveryNoticeOrderDomain.selectList((BaseEo)csDeliveryNoticeOrderEo, Integer.valueOf(1), Integer.valueOf(10000));
            if (CollectionUtils.isNotEmpty((Collection)csDeliveryNoticeOrderEos)) {
                totalQuantity = csDeliveryNoticeOrderEos.stream().filter(a -> BaseOrderStatusEnum.FINISH_OVER.getCode().equals(a.getOrderStatus()) || BaseOrderStatusEnum.RNO_TOTAL_RECEIVE.getCode().equals(a.getOrderStatus())).map(ReceiveDeliveryNoticeOrderEo::getTotalQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
        }
        return totalQuantity;
    }
}

