/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsPhysicsWarehouseExposedQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.warehouse.CsLogicWarehouseEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.warehouse.CsPhysicsWarehouseEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.warehouse.CsRelWarehouseEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.warehouse.CsWarehouseAddressEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.warehouse.CsLogicWarehouseMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.warehouse.CsPhysicsWarehouseMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.warehouse.CsRelWarehouseMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.warehouse.CsWarehouseAddressMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsPhysicsWarehouseLogicDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsPhysicsWarehousePageQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsPhysicsWarehouseDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsPhysicsWarehouseLogicDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsPhysicsWarehousePageRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsWarehouseClassifyEnum;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="csPhysicsWarehouseExposedQueryServiceImpl")
public class CsPhysicsWarehouseExposedQueryServiceImpl
implements ICsPhysicsWarehouseExposedQueryService {
    private static Logger logger = LoggerFactory.getLogger(CsPhysicsWarehouseExposedQueryServiceImpl.class);
    @Autowired
    private CsPhysicsWarehouseMapper csPhysicsWarehouseMapper;
    @Autowired
    private CsWarehouseAddressMapper csWarehouseAddressMapper;
    @Autowired
    private CsRelWarehouseMapper csRelWarehouseMapper;
    @Autowired
    private CsLogicWarehouseMapper csLogicWarehouseMapper;

    @Override
    public CsPhysicsWarehouseDetailRespDto queryDetailById(Long id) {
        logger.info("queryDetailById==>\u6839\u636e\u4ed3\u5e93\u4fe1\u606f\u67e5\u8be2\u4ed3\u5e93\u8be6\u60c5\u4fe1\u606f,id:{}", (Object)id);
        AssertUtil.isTrue(null != id, "\u4ed3\u5e93ID\u4e0d\u80fd\u4e3a\u7a7a");
        CsPhysicsWarehouseEo csPhysicsWarehouseEo = (CsPhysicsWarehouseEo)this.csPhysicsWarehouseMapper.selectById((Serializable)id);
        AssertUtil.isTrue(null != csPhysicsWarehouseEo, "\u67e5\u8be2\u4e0d\u5230\u4ed3\u5e93\u4fe1\u606f");
        CsPhysicsWarehouseDetailRespDto respDto = new CsPhysicsWarehouseDetailRespDto();
        CubeBeanUtils.copyProperties((Object)respDto, (Object)csPhysicsWarehouseEo, (String[])new String[0]);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"warehouse_id", (Object)id);
        queryWrapper.eq((Object)"warehouse_classify", (Object)CsWarehouseClassifyEnum.PHYSICS.getCode());
        queryWrapper.eq((Object)"valid_flag", (Object)CsValidFlagEnum.ENABLE.getCode());
        CsWarehouseAddressEo csWarehouseAddressEo = (CsWarehouseAddressEo)this.csWarehouseAddressMapper.selectOne((Wrapper)queryWrapper);
        if (null != csWarehouseAddressEo) {
            logger.info("queryDetailById==>\u67e5\u8be2\u5230\u5730\u5740\u4fe1\u606f");
            CubeBeanUtils.copyProperties((Object)respDto, (Object)csWarehouseAddressEo, (String[])new String[0]);
        }
        logger.info("queryDetailById==>\u7269\u7406\u4ed3\u8be6\u60c5\u4fe1\u606f,respDto:{}", (Object)LogUtils.buildLogContent(respDto));
        return respDto;
    }

    @Override
    public PageInfo<CsPhysicsWarehouseLogicDetailRespDto> queryLogicInfo(CsPhysicsWarehouseLogicDetailReqDto csPhysicsWarehouseLogicDetailReqDto) {
        String logicWarehouseName;
        AssertUtil.isTrue(null != csPhysicsWarehouseLogicDetailReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(null != csPhysicsWarehouseLogicDetailReqDto.getPageNum() && csPhysicsWarehouseLogicDetailReqDto.getPageNum() > 0, "\u5206\u9875\u9875\u7801\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(null != csPhysicsWarehouseLogicDetailReqDto.getPageSize() && csPhysicsWarehouseLogicDetailReqDto.getPageSize() > 0, "\u5206\u9875\u5927\u5c0f\u53c2\u6570\u6709\u8bef");
        Long physicsWarehouseId = csPhysicsWarehouseLogicDetailReqDto.getPhysicsWarehouseId();
        AssertUtil.isTrue(null != physicsWarehouseId, "\u7269\u7406\u4ed3\u4ed3\u5e93ID\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper relWrapper = new QueryWrapper();
        relWrapper.eq((Object)"warehouse_id", (Object)physicsWarehouseId);
        relWrapper.eq((Object)"warehouse_classify", (Object)CsWarehouseClassifyEnum.PHYSICS.getCode());
        relWrapper.eq((Object)"valid_flag", (Object)CsValidFlagEnum.ENABLE.getCode());
        relWrapper.eq((Object)"ref_warehouse_classify", (Object)CsWarehouseClassifyEnum.LOGIC.getCode());
        String logicWarehouseCode = csPhysicsWarehouseLogicDetailReqDto.getLogicWarehouseCode();
        if (StringUtils.isNotBlank((CharSequence)logicWarehouseCode)) {
            relWrapper.eq((Object)"ref_warehouse_code", (Object)logicWarehouseCode);
        }
        if (StringUtils.isNotBlank((CharSequence)(logicWarehouseName = csPhysicsWarehouseLogicDetailReqDto.getLogicWarehouseName()))) {
            relWrapper.likeRight((Object)"ref_warehouse_name", (Object)logicWarehouseName);
        }
        PageHelper.startPage((int)csPhysicsWarehouseLogicDetailReqDto.getPageNum(), (int)csPhysicsWarehouseLogicDetailReqDto.getPageSize());
        logger.info("queryLogicInfo===>\u7269\u7406\u4ed3\u8be6\u60c5\u67e5\u8be2\u5173\u8054\u903b\u8f91\u4ed3\u4fe1\u606f,relWrapper:{}", (Object)LogUtils.buildLogContent(relWrapper));
        List csRelWarehouseEoList = this.csRelWarehouseMapper.selectList((Wrapper)relWrapper);
        logger.info("queryLogicInfo===>\u7269\u7406\u4ed3\u8be6\u60c5\u67e5\u8be2\u5173\u8054\u903b\u8f91\u4ed3\u4fe1\u606f,csRelWarehouseEoList:{}", (Object)LogUtils.buildLogContent(csRelWarehouseEoList));
        if (CollectionUtils.isEmpty((Collection)csRelWarehouseEoList)) {
            return new PageInfo();
        }
        List relLogicWarehouseIdList = csRelWarehouseEoList.stream().map(CsRelWarehouseEo::getRefWarehouseId).collect(Collectors.toList());
        QueryWrapper logicWrapper = new QueryWrapper();
        logicWrapper.in((Object)"id", relLogicWarehouseIdList);
        List csLogicWarehouseEoList = this.csLogicWarehouseMapper.selectList((Wrapper)logicWrapper);
        logger.info("\u5173\u8054\u7684\u903b\u8f91\u4ed3\u4fe1\u606f,csLogicWarehouseEoList:{}", (Object)LogUtils.buildLogContent(csLogicWarehouseEoList));
        if (CollectionUtils.isEmpty((Collection)csLogicWarehouseEoList)) {
            return new PageInfo();
        }
        Map logicWarehouseEoMap = csLogicWarehouseEoList.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
        ArrayList physicsWarehouseLogicDetailRespDtoList = Lists.newArrayList();
        for (CsRelWarehouseEo relWarehouseEo : csRelWarehouseEoList) {
            Long resPhysicsWarehouseId = relWarehouseEo.getWarehouseId();
            Long relLogicWarehouseId = relWarehouseEo.getRefWarehouseId();
            CsLogicWarehouseEo csLogicWarehouseEo = (CsLogicWarehouseEo)logicWarehouseEoMap.get(relLogicWarehouseId);
            if (null == csLogicWarehouseEo) {
                return null;
            }
            String refWarehouseCode = relWarehouseEo.getRefWarehouseCode();
            String refWarehouseName = relWarehouseEo.getRefWarehouseName();
            CsPhysicsWarehouseLogicDetailRespDto respDto = new CsPhysicsWarehouseLogicDetailRespDto();
            respDto.setPhysicsWarehouseId(resPhysicsWarehouseId);
            respDto.setLogicWarehouseName(refWarehouseName);
            respDto.setLogicWarehouseCode(refWarehouseCode);
            respDto.setLogicWarehouseStatus(csLogicWarehouseEo.getWarehouseStatus());
            physicsWarehouseLogicDetailRespDtoList.add(respDto);
        }
        PageInfo info = new PageInfo(csLogicWarehouseEoList);
        PageInfo result = new PageInfo();
        BeanUtils.copyProperties((Object)info, (Object)result);
        result.setList((List)physicsWarehouseLogicDetailRespDtoList);
        return result;
    }

    @Override
    public PageInfo<CsPhysicsWarehousePageRespDto> queryPageInfo(CsPhysicsWarehousePageQueryDto csPhysicsWarehousePageQueryDto) {
        String easWarehouseCode;
        String rdcFlag;
        String warehouseStatus;
        String warehouseName;
        logger.info("queryPageInfo==>\u7269\u7406\u4ed3\u5206\u9875\u5217\u8868\u67e5\u8be2,csPhysicsWarehousePageQueryDto:{}", (Object)LogUtils.buildLogContent(csPhysicsWarehousePageQueryDto));
        AssertUtil.isTrue(null != csPhysicsWarehousePageQueryDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(null != csPhysicsWarehousePageQueryDto.getPageNum() && csPhysicsWarehousePageQueryDto.getPageNum() > 0, "\u5206\u9875\u9875\u7801\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(null != csPhysicsWarehousePageQueryDto.getPageSize() && csPhysicsWarehousePageQueryDto.getPageSize() > 0, "\u5206\u9875\u5927\u5c0f\u53c2\u6570\u6709\u8bef");
        QueryWrapper physicsWrapper = new QueryWrapper();
        String warehouseCode = csPhysicsWarehousePageQueryDto.getWarehouseCode();
        if (StringUtils.isNotBlank((CharSequence)warehouseCode)) {
            physicsWrapper.likeRight((Object)"warehouse_code", (Object)warehouseCode);
        }
        if (StringUtils.isNotBlank((CharSequence)(warehouseName = csPhysicsWarehousePageQueryDto.getWarehouseName()))) {
            physicsWrapper.likeRight((Object)"warehouse_name", (Object)warehouseName);
        }
        if (StringUtils.isNotBlank((CharSequence)(warehouseStatus = csPhysicsWarehousePageQueryDto.getWarehouseStatus()))) {
            physicsWrapper.eq((Object)"warehouse_status", (Object)warehouseStatus);
        }
        if (StringUtils.isNotBlank((CharSequence)(rdcFlag = csPhysicsWarehousePageQueryDto.getRdcFlag()))) {
            physicsWrapper.eq((Object)"rdc_flag", (Object)rdcFlag);
        }
        if (StringUtils.isNotBlank((CharSequence)(easWarehouseCode = csPhysicsWarehousePageQueryDto.getEasWarehouseCode()))) {
            physicsWrapper.likeRight((Object)"eas_warehouse_code", (Object)easWarehouseCode);
        }
        PageHelper.startPage((int)csPhysicsWarehousePageQueryDto.getPageNum(), (int)csPhysicsWarehousePageQueryDto.getPageSize());
        logger.info("queryPageInfo===>\u7269\u7406\u4ed3\u5206\u9875\u5217\u8868\u67e5\u8be2,relWrapper:{}", (Object)LogUtils.buildLogContent(physicsWrapper));
        List csPhysicsWarehouseEoList = this.csPhysicsWarehouseMapper.selectList((Wrapper)physicsWrapper);
        logger.info("queryPageInfo===>\u7269\u7406\u4ed3\u5206\u9875\u5217\u8868\u67e5\u8be2,csPhysicsWarehouseEoList:{}", (Object)LogUtils.buildLogContent(csPhysicsWarehouseEoList));
        if (CollectionUtils.isEmpty((Collection)csPhysicsWarehouseEoList)) {
            return new PageInfo();
        }
        List physicsWarehouseIdList = csPhysicsWarehouseEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
        QueryWrapper addressEoQueryWrapper = new QueryWrapper();
        addressEoQueryWrapper.in((Object)"warehouse_id", physicsWarehouseIdList);
        addressEoQueryWrapper.in((Object)"valid_flag", new Object[]{CsValidFlagEnum.ENABLE.getCode()});
        addressEoQueryWrapper.in((Object)"warehouse_classify", new Object[]{CsWarehouseClassifyEnum.PHYSICS.getCode()});
        List csWarehouseAddressEoList = this.csWarehouseAddressMapper.selectList((Wrapper)addressEoQueryWrapper);
        Map<Object, Object> addressEoMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)csWarehouseAddressEoList)) {
            addressEoMap = csWarehouseAddressEoList.stream().collect(Collectors.toMap(CsWarehouseAddressEo::getWarehouseId, Function.identity()));
        }
        ArrayList physicsRespList = Lists.newArrayList();
        for (CsPhysicsWarehouseEo csPhysicsWarehouseEo : csPhysicsWarehouseEoList) {
            CsPhysicsWarehousePageRespDto csPhysicsWarehousePageRespDto = new CsPhysicsWarehousePageRespDto();
            CubeBeanUtils.copyProperties((Object)csPhysicsWarehousePageRespDto, (Object)csPhysicsWarehouseEo, (String[])new String[0]);
            Long physicsWarehouseEoId = csPhysicsWarehouseEo.getId();
            CsWarehouseAddressEo csWarehouseAddressEo = (CsWarehouseAddressEo)addressEoMap.get(physicsWarehouseEoId);
            if (null != csWarehouseAddressEo) {
                csPhysicsWarehousePageRespDto.setProvince(csWarehouseAddressEo.getProvince());
                csPhysicsWarehousePageRespDto.setCity(csWarehouseAddressEo.getCity());
                csPhysicsWarehousePageRespDto.setDistrict(csWarehouseAddressEo.getDistrict());
                csPhysicsWarehousePageRespDto.setDetailAddress(csWarehouseAddressEo.getDetailAddress());
            }
            physicsRespList.add(csPhysicsWarehousePageRespDto);
        }
        PageInfo info = new PageInfo(csPhysicsWarehouseEoList);
        PageInfo result = new PageInfo();
        BeanUtils.copyProperties((Object)info, (Object)result);
        result.setList((List)physicsRespList);
        return result;
    }
}

