/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl.order;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.constant.InventoryConstant;
import com.dtyunxi.yundt.cube.center.inventory.biz.enus.OrderTypeEnu;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.order.ITcbjBaseService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.order.ITcbjDeliveryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.order.ITcbjReciptService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.WarehouseDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.CargoEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.DRAOrderCargoEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.DRAOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.WarehouseEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.CargoMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.TcbjDRAOrderCargoMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.TcbjDRAOrderMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.base.req.SimpleRequestDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.base.req.TcbjNotiGenItemReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.base.req.TcbjNotiGenReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.base.req.TcbjResGenItemReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.base.req.TcbjResGenReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.base.resp.RelOrderAndResnosDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.base.resp.TcbjNotiDetailCargoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.base.resp.TcbjResDetailCargoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.constant.OrderStatus;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.MqContentOtherFieldDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjReCheckDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjReCheckReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.InDraOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.order.recipt.TcbjReciptAuReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.order.recipt.TcbjReciptNotiDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.order.recipt.TcbjReciptNotiReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.order.recipt.TcbjReciptNotiRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.order.recipt.TcbjReciptResDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.order.recipt.TcbjReciptResReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.order.recipt.TcbjReciptResRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.warehouse.TcbjWarehouseReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.ReturnItemConfirmDetailReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.tob.ReturnItemConfirmReqDto;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TcbjReciptServiceImpl
implements ITcbjReciptService {
    private static final Logger logger = LoggerFactory.getLogger(TcbjReciptServiceImpl.class);
    @Autowired
    private TcbjDRAOrderMapper tcbjDRAOrderMapper;
    @Autowired
    private WarehouseDas warehouseDas;
    @Autowired
    private ITcbjBaseService tcbjBaseService;
    @Autowired
    private TcbjDRAOrderCargoMapper tcbjDRAOrderCargoMapper;
    @Autowired
    private ICustomerExtQueryApi customerExtQueryApi;
    @Autowired
    private CargoMapper cargoMapper;
    @Resource
    private IContext context;
    @Resource
    private ICommonsMqService commonsMqService;
    @Autowired
    private ITcbjDeliveryService tcbjDeliveryService;
    @Resource
    private ICacheService cacheService;

    @Override
    public RestResponse<PageInfo<TcbjReciptNotiRespDto>> notiPage(TcbjReciptNotiReqDto queryDto) {
        logger.info("\u83b7\u53d6\u6536\u8d27\u901a\u77e5\u5355-\u8f93\u5165:{}", (Object)JSON.toJSONString((Object)queryDto));
        Integer pageNum = queryDto.getPageNum();
        Integer pageSize = queryDto.getPageSize();
        AssertUtil.isTrue(Objects.nonNull(pageNum) && pageNum > 0, "\u9875\u7801\u53c2\u6570\u4e0d\u5408\u6cd5");
        AssertUtil.isTrue(Objects.nonNull(pageSize) && pageSize > 0, "\u6bcf\u9875\u6761\u6570\u4e0d\u5408\u6cd5");
        PageHelper.startPage((int)pageNum, (int)pageSize);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"category", (Object)"201");
        RestResponse restResponse = this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId());
        Long orgId = (Long)RestResponseHelper.extractData((RestResponse)restResponse);
        wrapper.eq((Object)"organization_id", (Object)orgId);
        if (StringUtil.isNotBlank((String)queryDto.getType())) {
            wrapper.eq((Object)"type", (Object)queryDto.getType());
        }
        if (StringUtil.isNotBlank((String)queryDto.getStatus())) {
            wrapper.eq((Object)"status", (Object)queryDto.getStatus());
        }
        if (StringUtil.isNotBlank((String)queryDto.getNo())) {
            wrapper.like((Object)"no", (Object)queryDto.getNo());
        }
        if (StringUtil.isNotBlank((String)queryDto.getWarehouseName())) {
            wrapper.like((Object)"warehouse_name", (Object)queryDto.getWarehouseName());
        }
        if (StringUtil.isNotBlank((String)queryDto.getWarehouseCode())) {
            wrapper.like((Object)"warehouse_code", (Object)queryDto.getWarehouseCode());
        }
        if (StringUtil.isNotBlank((String)queryDto.getCreateTimeStart()) && StringUtil.isNotBlank((String)queryDto.getCreateTimeEnd())) {
            wrapper.between((Object)"create_time", (Object)queryDto.getCreateTimeStart(), (Object)queryDto.getCreateTimeEnd());
        }
        wrapper.orderByDesc((Object)"create_time");
        try {
            List list = this.tcbjDRAOrderMapper.selectList((Wrapper)wrapper);
            PageInfo info = new PageInfo(list);
            List rList = list.stream().map(t -> {
                TcbjReciptNotiRespDto dto = new TcbjReciptNotiRespDto();
                try {
                    BeanUtils.copyProperties((Object)dto, (Object)t);
                }
                catch (Exception e) {
                    logger.error("\u83b7\u53d6\u6536\u8d27\u901a\u77e5\u5355-\u9519\u8bef:{}", (Object)e.toString());
                }
                return dto;
            }).collect(Collectors.toList());
            PageInfo result = new PageInfo(rList);
            org.springframework.beans.BeanUtils.copyProperties((Object)info, (Object)result);
            result.setList(rList);
            logger.info("\u83b7\u53d6\u6536\u8d27\u901a\u77e5\u5355-\u8f93\u51fa:{}", (Object)JSON.toJSONString((Object)result));
            return new RestResponse("0", "success", (Object)result);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6536\u8d27\u901a\u77e5\u5355-\u9519\u8bef:{}", (Object)e.toString());
            return new RestResponse("-1", "fail", null);
        }
    }

    @Override
    public RestResponse<TcbjReciptNotiDetailRespDto> notiDetail(SimpleRequestDto dto) {
        logger.info("\u83b7\u53d6\u6536\u8d27\u901a\u77e5\u8be6\u7ec6\u5355-\u8f93\u5165:{}", (Object)JSON.toJSONString((Object)dto));
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"no", (Object)dto.getNo());
        DRAOrderEo one = (DRAOrderEo)this.tcbjDRAOrderMapper.selectOne((Wrapper)wrapper);
        AssertUtil.isTrue(Objects.nonNull(one), "\u8be5\u8ba2\u5355\u7684\u5165\u5e93\u5355\u672a\u627e\u5230");
        TcbjReciptNotiDetailRespDto respDto = new TcbjReciptNotiDetailRespDto();
        try {
            BeanUtils.copyProperties((Object)respDto, (Object)one);
        }
        catch (Exception e) {
            logger.error("\u53d1\u8d27\u901a\u77e5-\u9519\u8bef:{}", (Object)e.toString());
        }
        RelOrderAndResnosDto orderAndResnosDto = new RelOrderAndResnosDto();
        orderAndResnosDto.setReciveName(one.getPreReciveName());
        orderAndResnosDto.setRecivePhone(one.getPreRecivePhone());
        orderAndResnosDto.setAddress(one.getPreAddress());
        orderAndResnosDto.setPlanTime(one.getPrePlanTime());
        orderAndResnosDto.setRemark(one.getPreRemark());
        QueryWrapper wrapper2 = new QueryWrapper();
        wrapper2.eq((Object)"pre_no", (Object)one.getPreNo());
        wrapper2.eq((Object)"category", (Object)"202");
        try {
            List draOrderEos = this.tcbjDRAOrderMapper.selectList((Wrapper)wrapper2);
            List strings = draOrderEos.stream().map(DRAOrderEo::getNo).collect(Collectors.toList());
            orderAndResnosDto.setResNos(strings);
            respDto.setRelOrderAndResnosDto(orderAndResnosDto);
            List<TcbjNotiDetailCargoRespDto> cargoEos = this.tcbjBaseService.getNotiCargo(dto.getNo());
            respDto.setCargos(cargoEos);
            this.doReciptNotifyOrder(one, respDto);
            logger.info("\u83b7\u53d6\u6536\u8d27\u901a\u77e5\u8be6\u7ec6\u5355-\u8f93\u51fa:{}", (Object)JSON.toJSONString((Object)respDto));
            return new RestResponse("0", "success", (Object)respDto);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6536\u8d27\u901a\u77e5\u8be6\u7ec6\u5355-\u9519\u8bef:{}", (Object)e.toString());
            return new RestResponse("-1", "fail", null);
        }
    }

    private void doReciptNotifyOrder(DRAOrderEo draOrderEo, TcbjReciptNotiDetailRespDto reciptNotiDetailRespDto) {
        logger.info("doReciptNotifyOrder==>draOrderEo:{},reciptNotiDetailRespDto:{}", (Object)LogUtils.buildLogContent(draOrderEo), (Object)LogUtils.buildLogContent(reciptNotiDetailRespDto));
        List detailCargoList = reciptNotiDetailRespDto.getCargos();
        List relevanceOrderNoList = reciptNotiDetailRespDto.getRelOrderAndResnosDto().getResNos();
        Map<Object, Object> relevanceCargoMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty((Collection)relevanceOrderNoList)) {
            List<TcbjNotiDetailCargoRespDto> relevanceCargoList = this.tcbjBaseService.getNotifyCargoListByOrderNoList(relevanceOrderNoList);
            logger.info("doReciptNotifyOrder==>\u83b7\u53d6\u5173\u8054\u7684\u53d1\u8d27\u7ed3\u679c\u5355\u8d27\u54c1\u4fe1\u606f,relevanceCargoList:{}", (Object)LogUtils.buildLogContent(relevanceCargoList));
            if (CollectionUtil.isNotEmpty(relevanceCargoList)) {
                relevanceCargoMap = relevanceCargoList.stream().collect(Collectors.groupingBy(TcbjNotiDetailCargoRespDto::getCargoCode));
            }
        }
        if (OrderStatus.RECIPT_WAIT_AUDIT.equals(draOrderEo.getStatus()) || OrderStatus.RECIPT_WAIT_DELIVER.equals(draOrderEo.getStatus()) || OrderStatus.RECIPT_DELIVERED.equals(draOrderEo.getStatus()) || OrderStatus.RECIPT_WAIT_RECEIVE.equals(draOrderEo.getStatus()) || OrderStatus.RECIPT_ING.equals(draOrderEo.getStatus())) {
            detailCargoList.forEach(cargo -> {
                cargo.setPlanNum(cargo.getNum());
                cargo.setSentNum(Integer.valueOf(0));
                cargo.setWaitNum(cargo.getNum());
                cargo.setCancelNum(Integer.valueOf(0));
            });
        } else if (OrderStatus.RECIPT_FINISH.equals(draOrderEo.getStatus())) {
            for (TcbjNotiDetailCargoRespDto cargo2 : detailCargoList) {
                String cargoCode = cargo2.getCargoCode();
                Integer sentNum = cargo2.getNum();
                List cargoRespDtoList = (List)relevanceCargoMap.get(cargoCode);
                if (CollectionUtil.isNotEmpty((Collection)cargoRespDtoList)) {
                    sentNum = cargoRespDtoList.stream().map(TcbjNotiDetailCargoRespDto::getNum).reduce(Integer::sum).get();
                }
                cargo2.setPlanNum(cargo2.getNum());
                cargo2.setSentNum(sentNum);
                cargo2.setWaitNum(Integer.valueOf(0));
                cargo2.setCancelNum(Integer.valueOf(0));
            }
        } else if (OrderStatus.RECIPT_CANCEL.equals(draOrderEo.getStatus()) || OrderStatus.ADJUST_REFUSE.equals(draOrderEo.getStatus())) {
            detailCargoList.forEach(cargo -> {
                cargo.setPlanNum(cargo.getNum());
                cargo.setSentNum(Integer.valueOf(0));
                cargo.setWaitNum(Integer.valueOf(0));
                cargo.setCancelNum(cargo.getNum());
            });
        }
    }

    @Override
    public RestResponse<PageInfo<TcbjReciptResRespDto>> resPage(TcbjReciptResReqDto queryDto) {
        logger.info("\u83b7\u53d6\u6536\u8d27\u7ed3\u679c\u5355-\u8f93\u5165:{}", (Object)JSON.toJSONString((Object)queryDto));
        Integer pageNum = queryDto.getPageNum();
        Integer pageSize = queryDto.getPageSize();
        AssertUtil.isTrue(Objects.nonNull(pageNum) && pageNum > 0, "\u9875\u7801\u53c2\u6570\u4e0d\u5408\u6cd5");
        AssertUtil.isTrue(Objects.nonNull(pageSize) && pageSize > 0, "\u6bcf\u9875\u6761\u6570\u4e0d\u5408\u6cd5");
        PageHelper.startPage((int)pageNum, (int)pageSize);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"category", (Object)"202");
        RestResponse restResponse = this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId());
        Long orgId = (Long)RestResponseHelper.extractData((RestResponse)restResponse);
        wrapper.eq((Object)"organization_id", (Object)orgId);
        if (!Strings.isNullOrEmpty((String)queryDto.getType())) {
            wrapper.eq((Object)"type", (Object)queryDto.getType());
        }
        if (!Strings.isNullOrEmpty((String)queryDto.getPreNo())) {
            wrapper.eq((Object)"pre_no", (Object)queryDto.getPreNo());
        }
        if (!Strings.isNullOrEmpty((String)queryDto.getNo())) {
            wrapper.eq((Object)"no", (Object)queryDto.getNo());
        }
        if (StringUtil.isNotBlank((String)queryDto.getWarehouseName())) {
            wrapper.like((Object)"warehouse_name", (Object)queryDto.getWarehouseName());
        }
        if (StringUtil.isNotBlank((String)queryDto.getWarehouseCode())) {
            wrapper.like((Object)"warehouse_code", (Object)queryDto.getWarehouseCode());
        }
        if (StringUtil.isNotBlank((String)queryDto.getCreateTimeStart()) && StringUtil.isNotBlank((String)queryDto.getCreateTimeEnd())) {
            wrapper.between((Object)"create_time", (Object)queryDto.getCreateTimeStart(), (Object)queryDto.getCreateTimeEnd());
        }
        wrapper.orderByDesc((Object)"create_time");
        try {
            List list = this.tcbjDRAOrderMapper.selectList((Wrapper)wrapper);
            PageInfo info = new PageInfo(list);
            List rList = list.stream().map(t -> {
                TcbjReciptResRespDto dto = new TcbjReciptResRespDto();
                try {
                    BeanUtils.copyProperties((Object)dto, (Object)t);
                    dto.setReceiveTime(t.getCreateTime());
                }
                catch (Exception e) {
                    logger.error("\u83b7\u53d6\u6536\u8d27\u901a\u77e5\u8be6\u7ec6\u5355-\u9519\u8bef:{}", (Object)e.toString());
                }
                return dto;
            }).collect(Collectors.toList());
            PageInfo result = new PageInfo(rList);
            org.springframework.beans.BeanUtils.copyProperties((Object)info, (Object)result);
            result.setList(rList);
            logger.info("\u83b7\u53d6\u6536\u8d27\u7ed3\u679c\u5355-\u8f93\u51fa:{}", (Object)JSON.toJSONString((Object)result));
            return new RestResponse("0", "success", (Object)result);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6536\u8d27\u901a\u77e5\u8be6\u7ec6\u5355-\u9519\u8bef:{}", (Object)e.toString());
            return new RestResponse("-1", "fail", null);
        }
    }

    @Override
    public RestResponse<TcbjReciptResDetailRespDto> resDetail(SimpleRequestDto dto) {
        logger.info("\u83b7\u53d6\u6536\u8d27\u7ed3\u679c\u5355\u8be6\u7ec6-\u8f93\u5165:{}", (Object)JSON.toJSONString((Object)dto));
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"no", (Object)dto.getNo());
        DRAOrderEo one = (DRAOrderEo)this.tcbjDRAOrderMapper.selectOne((Wrapper)wrapper);
        AssertUtil.isTrue(Objects.nonNull(one), "\u8be5\u8ba2\u5355\u7684\u5165\u5e93\u5355\u672a\u627e\u5230");
        TcbjReciptResDetailRespDto respDto = new TcbjReciptResDetailRespDto();
        try {
            BeanUtils.copyProperties((Object)respDto, (Object)one);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6536\u8d27\u7ed3\u679c\u5355\u8be6\u7ec6-\u9519\u8bef:{}", (Object)e.toString());
        }
        QueryWrapper wrapper2 = new QueryWrapper();
        wrapper2.eq((Object)"pre_no", (Object)one.getPreNo());
        wrapper2.eq((Object)"category", (Object)"201");
        List draOrderEos = this.tcbjDRAOrderMapper.selectList((Wrapper)wrapper2);
        if (CollectionUtil.isNotEmpty((Collection)draOrderEos)) {
            RelOrderAndResnosDto orderAndResnosDto = new RelOrderAndResnosDto();
            DRAOrderEo notiOrder = (DRAOrderEo)draOrderEos.get(0);
            orderAndResnosDto.setReciveName(notiOrder.getPreReciveName());
            orderAndResnosDto.setRecivePhone(notiOrder.getPreRecivePhone());
            orderAndResnosDto.setAddress(notiOrder.getPreAddress());
            orderAndResnosDto.setPlanTime(notiOrder.getPrePlanTime());
            orderAndResnosDto.setRemark(notiOrder.getPreRemark());
            List strings = draOrderEos.stream().map(DRAOrderEo::getNo).collect(Collectors.toList());
            orderAndResnosDto.setResNos(strings);
            respDto.setRelOrderAndResnosDto(orderAndResnosDto);
        }
        try {
            List<TcbjResDetailCargoRespDto> cargoEos = this.tcbjBaseService.getResCargo(dto.getNo());
            respDto.setCargos(cargoEos);
            logger.info("\u83b7\u53d6\u6536\u8d27\u7ed3\u679c\u5355\u8be6\u7ec6-\u8f93\u51fa:{}", (Object)JSON.toJSONString((Object)respDto));
            return new RestResponse("0", "success", (Object)respDto);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6536\u8d27\u901a\u77e5\u5355-\u9519\u8bef:{}", (Object)e.toString());
            return new RestResponse("-1", "fail", null);
        }
    }

    @Override
    public RestResponse<String> send(TcbjNotiGenReqDto reqDto) {
        DRAOrderEo draOrderEo = new DRAOrderEo();
        String no = "SHTZ" + InventoryConstant.createId();
        draOrderEo.setCategory("201");
        draOrderEo.setStatus(OrderStatus.RECIPT_WAIT_AUDIT);
        draOrderEo.setType(reqDto.getType());
        draOrderEo.setWarehouseCode(reqDto.getWarehouseCode());
        draOrderEo.setPreNo(reqDto.getPreNo());
        draOrderEo.setPreReciveName(reqDto.getReciveName());
        draOrderEo.setPreRecivePhone(reqDto.getRecivePhone());
        draOrderEo.setPreAddress(reqDto.getAddress());
        draOrderEo.setPrePlanTime(reqDto.getPlanTime());
        draOrderEo.setNo(no);
        draOrderEo.setOrganizationId(reqDto.getOrganizationId());
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getNotiGenItemReqDtos())) {
            draOrderEo.setNum(Integer.valueOf(reqDto.getNotiGenItemReqDtos().stream().mapToInt(TcbjNotiGenItemReqDto::getNum).reduce(0, Integer::sum)));
        }
        TcbjWarehouseReqDto dto = new TcbjWarehouseReqDto();
        dto.setCode(reqDto.getWarehouseCode());
        WarehouseEo warehouseEo = this.warehouseDas.selectByCode(reqDto.getWarehouseCode());
        if (Objects.nonNull(warehouseEo)) {
            draOrderEo.setWarehouseName(warehouseEo.getName());
            draOrderEo.setWarehouseId(warehouseEo.getId());
        }
        this.tcbjBaseService.checkRepeat(draOrderEo);
        int insert = this.tcbjDRAOrderMapper.insert((Object)draOrderEo);
        if (insert > 0) {
            List draOrderCargoEos = reqDto.getNotiGenItemReqDtos().stream().map(d -> {
                DRAOrderCargoEo cargoEo = new DRAOrderCargoEo();
                cargoEo.setBatch(d.getBatch());
                cargoEo.setCargoCode(d.getCargoCode());
                cargoEo.setPlanNum(d.getPlanNum());
                cargoEo.setNum(d.getNum());
                cargoEo.setSentNum(d.getSentNum());
                cargoEo.setWaitNum(d.getWaitNum());
                cargoEo.setCancelNum(d.getCancelNum());
                cargoEo.setTradeOrderItemId(d.getTradeOrderItemId());
                return cargoEo;
            }).collect(Collectors.toList());
            for (DRAOrderCargoEo cargoEo : draOrderCargoEos) {
                QueryWrapper wrapper = new QueryWrapper();
                wrapper.eq((Object)"dr", (Object)"0");
                if (!Strings.isNullOrEmpty((String)cargoEo.getCargoCode())) {
                    wrapper.eq((Object)"code", (Object)cargoEo.getCargoCode());
                }
                if (cargoEo.getCargoId() != null && cargoEo.getCargoId() > 0L) {
                    wrapper.eq((Object)"id", (Object)cargoEo.getCargoId());
                }
                CargoEo one = (CargoEo)this.cargoMapper.selectOne((Wrapper)wrapper);
                AssertUtil.isTrue(Objects.nonNull(one), "\u5546\u54c1\u7f16\u7801\u672a\u627e\u5230\uff1a" + cargoEo.getCargoCode());
                cargoEo.setCargoName(one.getName());
                cargoEo.setCargoCode(one.getCode());
                cargoEo.setCargoNo(one.getArtNo());
                cargoEo.setCargoId(one.getId());
                cargoEo.setOrderNo(draOrderEo.getNo());
                cargoEo.setCreatePerson("sys");
                cargoEo.setCreateTime((java.util.Date)new Date(new java.util.Date().getTime()));
                cargoEo.setUpdatePerson("sys");
                cargoEo.setUpdateTime((java.util.Date)new Date(new java.util.Date().getTime()));
                cargoEo.setDr(0);
                this.tcbjDRAOrderCargoMapper.insert((Object)cargoEo);
            }
            return new RestResponse("0", "\u521b\u5efa\u6210\u529f", null);
        }
        return new RestResponse("-1", "fail", null);
    }

    @Override
    public RestResponse<String> sendback(TcbjResGenReqDto reqDto) {
        logger.info("\u5165\u5e93\u6536\u8d27\u56de\u4f20,sendback==>reqDto:{}", (Object)LogUtils.buildLogContent(reqDto));
        DRAOrderEo one = new DRAOrderEo();
        one.setPreNo(reqDto.getPreNo());
        one.setNotiNo(reqDto.getNotiNo());
        DRAOrderEo draOrderEo = new DRAOrderEo();
        draOrderEo.setCategory("202");
        draOrderEo.setType(reqDto.getType());
        draOrderEo.setWarehouseCode(reqDto.getWarehouseCode());
        draOrderEo.setPreNo(reqDto.getPreNo());
        draOrderEo.setNotiNo(reqDto.getNotiNo());
        List<DRAOrderCargoEo> draOrderCargoEos = reqDto.getResGenItemReqDtos().stream().map(d -> {
            DRAOrderCargoEo cargoEo = new DRAOrderCargoEo();
            cargoEo.setBatch(d.getBatch());
            cargoEo.setCargoCode(d.getCargoCode());
            cargoEo.setNum(d.getNum());
            cargoEo.setProduceTime(d.getProduceTime());
            cargoEo.setExpireTime(d.getExpireTime());
            cargoEo.setProduceTime(d.getProductDate());
            cargoEo.setExpireTime(d.getExpireDate());
            cargoEo.setPreNo(d.getOrderNo());
            return cargoEo;
        }).collect(Collectors.toList());
        Exception exception = null;
        try {
            logger.info("\u5165\u5e93\u6536\u8d27\u56de\u4f20,sendback==>draOrderEo:{},draOrderCargoEos:{}", (Object)LogUtils.buildLogContent(draOrderEo), (Object)LogUtils.buildLogContent(draOrderCargoEos));
            if (reqDto.getIsNewCheck().booleanValue()) {
                this.tcbjBaseService.add(draOrderEo, draOrderCargoEos, 3, one);
            } else {
                this.tcbjBaseService.add(draOrderEo, draOrderCargoEos, 2, one);
            }
            return RestResponse.SUCCEED;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6536\u8d27\u901a\u77e5\u5355-\u9519\u8bef:" + e.getMessage(), (Throwable)e);
            if (e instanceof BizException && ((BizException)e).getCode().equals("304")) {
                return RestResponse.SUCCEED;
            }
            exception = e;
            return new RestResponse("-1", exception.getMessage(), null);
        }
    }

    @Override
    public RestResponse<String> cancel(SimpleRequestDto dto) {
        logger.info("\u53d6\u6d88\u6536\u8d27\u5355\u8bf7\u6c42\u63d0\u793a:{}", (Object)JSONObject.toJSONString((Object)dto));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"no", (Object)dto.getNo());
        queryWrapper.eq((Object)"category", (Object)"201");
        DRAOrderEo dbEo = (DRAOrderEo)this.tcbjDRAOrderMapper.selectOne((Wrapper)queryWrapper);
        if (dbEo != null) {
            try {
                dbEo.setStatus(OrderStatus.RECIPT_CANCEL);
                dbEo.setDr(1);
                int update = this.tcbjDRAOrderMapper.updateById((BaseEo)dbEo);
                if (update <= 0) {
                    throw new BizException("\u975e\u6536\u8d27\u901a\u77e5\u5355\u4e0d\u80fd\u53d6\u6d88\uff01");
                }
                logger.info("\u53d6\u6d88\u6536\u8d27\u5355\u8fd4\u56de\u63d0\u793a:{}", (Object)JSONObject.toJSONString(null));
                return RestResponse.SUCCEED;
            }
            catch (Exception e) {
                logger.error("\u83b7\u53d6\u6536\u8d27\u901a\u77e5\u5355-\u9519\u8bef:{}", (Object)e.toString());
            }
        }
        return new RestResponse("-1", "fail", null);
    }

    @Override
    public RestResponse<List<TcbjResDetailCargoRespDto>> inNum(SimpleRequestDto dto) {
        return new RestResponse("0", "success");
    }

    public RestResponse<List<TcbjResDetailCargoRespDto>> inNum1(SimpleRequestDto dto) {
        logger.info("\u53d6\u6d88\u6536\u8d27\u5355\u8bf7\u6c42\u63d0\u793a:{}", (Object)JSONObject.toJSONString((Object)dto));
        String orderNo = null;
        QueryWrapper qwrapper = new QueryWrapper();
        qwrapper.eq((Object)"pre_no", (Object)dto.getNo());
        qwrapper.eq((Object)"category", (Object)"201");
        qwrapper.last("limit 1");
        DRAOrderEo draOrderEo = (DRAOrderEo)this.tcbjDRAOrderMapper.selectOne((Wrapper)qwrapper);
        AssertUtil.isTrue(Objects.nonNull(draOrderEo), "\u6539\u8ba2\u5355\u7684\u51fa\u5e93\u5355\u672a\u627e\u5230");
        orderNo = draOrderEo.getNo();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"order_no", (Object)orderNo);
        try {
            List cargoEos = this.tcbjDRAOrderCargoMapper.selectList((Wrapper)wrapper);
            List collect = cargoEos.stream().map(c -> {
                TcbjResDetailCargoRespDto tmp = new TcbjResDetailCargoRespDto();
                tmp.setCargoCode(c.getCargoCode());
                tmp.setCargoName(c.getCargoName());
                tmp.setCargoNo(c.getCargoNo());
                tmp.setNum(c.getNum());
                tmp.setBatch(c.getBatch());
                tmp.setTradeOrderItemId(c.getTradeOrderItemId());
                return tmp;
            }).collect(Collectors.toList());
            logger.info("\u53d6\u6d88\u6536\u8d27\u5355\u8fd4\u56de\u63d0\u793a:{}", (Object)JSONObject.toJSONString(collect));
            return new RestResponse("0", "success", collect);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6536\u8d27\u901a\u77e5\u5355-\u9519\u8bef:{}", (Object)e.toString());
            return new RestResponse("-1", "fail", null);
        }
    }

    @Override
    public RestResponse<String> audit(TcbjReciptAuReqDto dto) {
        logger.info("\u5ba1\u6838\u6536\u8d27\u901a\u77e5\u5355\u8bf7\u6c42\u63d0\u793a:{}", (Object)JSONObject.toJSONString((Object)dto));
        QueryWrapper qwrapper = new QueryWrapper();
        qwrapper.eq((Object)"pre_no", (Object)dto.getPreNo());
        qwrapper.eq((Object)"category", (Object)"201");
        qwrapper.eq((Object)"dr", (Object)0);
        DRAOrderEo eo = (DRAOrderEo)this.tcbjDRAOrderMapper.selectOne((Wrapper)qwrapper);
        if (eo.getStatus().equals(OrderStatus.RECIPT_FINISH) || eo.getStatus().equals(OrderStatus.RECIPT_CANCEL)) {
            return new RestResponse("-1", "fail", (Object)"\u8be5\u901a\u77e5\u5355\u5df2\u5b8c\u6210\u6216\u53d6\u6d88,\u4e0d\u80fd\u518d\u6b21\u4fee\u6539");
        }
        eo.setStatus(dto.getStatus());
        int update = this.tcbjDRAOrderMapper.updateById((BaseEo)eo);
        logger.info("\u5ba1\u6838\u6536\u8d27\u901a\u77e5\u5355\u8fd4\u56de\u63d0\u793a:{}", (Object)update);
        return RestResponse.SUCCEED;
    }

    @Override
    public RestResponse<List<InDraOrderRespDto>> inOrderQuery(SimpleRequestDto dto) {
        logger.info("\u83b7\u53d6\u5355\u636e\u6570\u636e-\u8f93\u5165:{}", (Object)JSON.toJSONString((Object)dto));
        QueryWrapper wrapper2 = new QueryWrapper();
        wrapper2.eq((Object)"pre_no", (Object)dto.getPreNo());
        wrapper2.eq((Object)"category", (Object)dto.getCategory());
        wrapper2.eq((Object)"type", (Object)dto.getType());
        List draOrderEos = this.tcbjDRAOrderMapper.selectList((Wrapper)wrapper2);
        if (CollectionUtils.isEmpty((Collection)draOrderEos)) {
            return new RestResponse();
        }
        ArrayList respDtos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)respDtos, (Collection)draOrderEos, InDraOrderRespDto.class);
        logger.info("\u83b7\u53d6\u5355\u636e\u6570\u636e-\u8f93\u51fa:{}", (Object)JSON.toJSONString((Object)respDtos));
        return new RestResponse("0", "success", (Object)respDtos);
    }

    @Override
    public void refundModifyNotifyStatus(TcbjResGenReqDto resGenReqDto) {
        logger.info("refundModifyNotifyStatus==>\u9000\u8d27\u56de\u4f20,\u4fee\u6539\u552e\u540e\u901a\u77e5\u5355\u72b6\u6001,resGenReqDto:{}", (Object)LogUtils.buildLogContent(resGenReqDto));
        AssertUtil.isTrue(null != resGenReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String notiNo = resGenReqDto.getNotiNo();
        String preNo = resGenReqDto.getPreNo();
        AssertUtil.isTrue(StringUtil.isNotBlank((String)notiNo), "\u901a\u77e5\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("orderTradeStatus", (Object)"SUCC");
        jsonObject.put("orderCode", (Object)preNo);
        jsonObject.put("type", (Object)"return");
        ReturnItemConfirmReqDto returnItemConfirmReqDto = new ReturnItemConfirmReqDto();
        returnItemConfirmReqDto.setReturnNo(preNo);
        this.cacheService.setCache("refundModifyNotifyStatus" + preNo, (Object)resGenReqDto);
        List draOrderCargoEos = resGenReqDto.getResGenItemReqDtos().stream().map(d -> {
            DRAOrderCargoEo cargoEo = new DRAOrderCargoEo();
            cargoEo.setBatch(d.getBatch());
            cargoEo.setCargoCode(d.getCargoCode());
            cargoEo.setNum(d.getNum());
            cargoEo.setProduceTime(d.getProduceTime());
            cargoEo.setExpireTime(d.getExpireTime());
            cargoEo.setProduceTime(d.getProductDate());
            cargoEo.setExpireTime(d.getExpireDate());
            if (StringUtil.isNotBlank((String)d.getOtherField1())) {
                MqContentOtherFieldDto otherFieldDto = (MqContentOtherFieldDto)JSON.parseObject((String)d.getOtherField1(), MqContentOtherFieldDto.class);
                cargoEo.setTradeOrderItemId(otherFieldDto.getTradeOrderItemId());
            }
            cargoEo.setPreNo(d.getOrderNo());
            return cargoEo;
        }).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(draOrderCargoEos)) {
            List items = draOrderCargoEos.stream().map(e -> {
                ReturnItemConfirmDetailReqDto returnItemConfirmDetailReqDto = new ReturnItemConfirmDetailReqDto();
                returnItemConfirmDetailReqDto.setItemCode(e.getCargoCode());
                returnItemConfirmDetailReqDto.setItemId(e.getCargoId() + "");
                returnItemConfirmDetailReqDto.setItemName(e.getCargoName());
                returnItemConfirmDetailReqDto.setCurrentNum(Long.valueOf(e.getNum().intValue()));
                returnItemConfirmDetailReqDto.setCargoSerial(e.getCargoId() + "");
                returnItemConfirmDetailReqDto.setCargoCode(e.getCargoCode());
                returnItemConfirmDetailReqDto.setBatchNo(e.getBatch());
                returnItemConfirmDetailReqDto.setOrderNo(e.getPreNo());
                returnItemConfirmDetailReqDto.setTradeOrderItemId(e.getTradeOrderItemId());
                return returnItemConfirmDetailReqDto;
            }).collect(Collectors.toList());
            returnItemConfirmReqDto.setReturnItemConfirmDetailReqDtos(items);
            jsonObject.put("items", (Object)returnItemConfirmReqDto);
        }
        MessageVo messageVo = new MessageVo();
        messageVo.setData((Object)jsonObject);
        this.commonsMqService.sendSingleMessage("SINGLE_TOPIC", "ORDER_STATUS_FINISH_TAG", (Object)messageVo);
        logger.info("\u53d1mq\u901a\u77e5\u8ba2\u5355\u4fee\u6539\u5df2\u5b8c\u6210\uff1a{}", (Object)JSON.toJSONString((Object)jsonObject));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void reCheckInInventory(TcbjReCheckReqDto reCheckReqDto) {
        logger.info("reCheckInInventory==>\u590d\u6838\u5165\u5e93,reCheckReqDto:{}", (Object)LogUtils.buildLogContent(reCheckReqDto));
        DRAOrderEo notifyOrderEo = this.checkParams(reCheckReqDto);
        logger.info("reCheckInInventory==>\u590d\u6838\u5165\u5e93,notifyOrderEo:{},reCheckReqDto:{}", (Object)LogUtils.buildLogContent(notifyOrderEo), (Object)LogUtils.buildLogContent(reCheckReqDto));
        TcbjResGenReqDto tcbjResGenReqDtoCache = (TcbjResGenReqDto)this.cacheService.getCache("refundModifyNotifyStatus" + reCheckReqDto.getRefundOrderNo(), TcbjResGenReqDto.class);
        logger.info("reCheckInInventory==>\u590d\u6838\u5165\u5e93,\u6267\u884c\u5165\u5e93\u64cd\u4f5ctcbjResGenReqDtoCache:{}", (Object)LogUtils.buildLogContent(tcbjResGenReqDtoCache));
        if (tcbjResGenReqDtoCache != null) {
            Map<Object, Object> receiveOrderCargoMap = Maps.newHashMap();
            List resGenItemReqDtos = tcbjResGenReqDtoCache.getResGenItemReqDtos();
            receiveOrderCargoMap = resGenItemReqDtos.stream().collect(Collectors.toMap(eo -> eo.getCargoCode() + "_" + eo.getBatch(), Function.identity()));
            for (TcbjReCheckDetailReqDto reCheckDetailReqDto : reCheckReqDto.getReCheckDetailReqDtoList()) {
                String cargoCode = reCheckDetailReqDto.getCargoCode();
                String batch = reCheckDetailReqDto.getBatch();
                TcbjResGenItemReqDto draOrderCargoEo = (TcbjResGenItemReqDto)receiveOrderCargoMap.get(cargoCode + "_" + batch);
                if (null == draOrderCargoEo) continue;
                reCheckDetailReqDto.setBatch(draOrderCargoEo.getBatch());
                reCheckDetailReqDto.setExpireTime(draOrderCargoEo.getExpireDate());
                reCheckDetailReqDto.setCargoCode(draOrderCargoEo.getCargoCode());
                reCheckDetailReqDto.setProduceTime(draOrderCargoEo.getProductDate());
            }
        }
        logger.info("reCheckInInventory==>\u590d\u6838\u5165\u5e93,\u6267\u884c\u5165\u5e93\u64cd\u4f5creCheckReqDto:{}", (Object)LogUtils.buildLogContent(reCheckReqDto));
        TcbjResGenReqDto reqDto = new TcbjResGenReqDto();
        reqDto.setPreNo(notifyOrderEo.getPreNo());
        reqDto.setNotiNo(notifyOrderEo.getNo());
        reqDto.setType(Integer.valueOf(OrderTypeEnu.INVOKE_CUBE_ORDER_TYPE_SUB_SALE_RTN_IN.getCode()));
        reqDto.setWarehouseCode(notifyOrderEo.getWarehouseCode());
        ArrayList resGenItemReqDtoList = Lists.newArrayList();
        List reCheckDetailReqDtoList = reCheckReqDto.getReCheckDetailReqDtoList();
        for (TcbjReCheckDetailReqDto reCheckDetailReqDto : reCheckDetailReqDtoList) {
            TcbjResGenItemReqDto tcbjResGenItemReqDto = new TcbjResGenItemReqDto();
            tcbjResGenItemReqDto.setNum(Integer.valueOf(reCheckDetailReqDto.getRefundNum().intValue()));
            tcbjResGenItemReqDto.setOrderNo(reCheckReqDto.getRefundOrderNo());
            tcbjResGenItemReqDto.setExpireTime(reCheckDetailReqDto.getExpireTime());
            tcbjResGenItemReqDto.setProduceTime(reCheckDetailReqDto.getProduceTime());
            tcbjResGenItemReqDto.setBatch(reCheckDetailReqDto.getBatch());
            tcbjResGenItemReqDto.setCargoCode(reCheckDetailReqDto.getCargoCode());
            tcbjResGenItemReqDto.setExpireDate(reCheckDetailReqDto.getExpireTime());
            tcbjResGenItemReqDto.setProductDate(reCheckDetailReqDto.getProduceTime());
            resGenItemReqDtoList.add(tcbjResGenItemReqDto);
        }
        this.cacheService.delCache("refundModifyNotifyStatus" + reCheckReqDto.getRefundOrderNo());
        reqDto.setResGenItemReqDtos((List)resGenItemReqDtoList);
        logger.info("reCheckInInventory==>\u590d\u6838\u5165\u5e93,\u6267\u884c\u5165\u5e93\u64cd\u4f5creqDto:{}", (Object)LogUtils.buildLogContent(reqDto));
        reqDto.setIsNewCheck(Boolean.valueOf(true));
        this.sendback(reqDto);
    }

    private DRAOrderEo checkParams(TcbjReCheckReqDto reCheckReqDto) {
        AssertUtil.isTrue(null != reCheckReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtil.isNotBlank((String)reCheckReqDto.getRefundOrderNo()), "\u9000\u8d27\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        List reCheckDetailReqDtoList = reCheckReqDto.getReCheckDetailReqDtoList();
        AssertUtil.isTrue(CollectionUtil.isNotEmpty((Collection)reCheckDetailReqDtoList), "\u9000\u8d27\u8d27\u54c1\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        List cargoCodeList = reCheckDetailReqDtoList.stream().map(TcbjReCheckDetailReqDto::getCargoCode).collect(Collectors.toList());
        QueryWrapper cargoEoQueryWrapper = new QueryWrapper();
        cargoEoQueryWrapper.in((Object)"code", cargoCodeList);
        List cargoEoList = this.cargoMapper.selectList((Wrapper)cargoEoQueryWrapper);
        AssertUtil.isTrue(CollectionUtil.isNotEmpty((Collection)cargoEoList), "\u67e5\u8be2\u4e0d\u5230\u8d27\u54c1\u4fe1\u606f");
        QueryWrapper receiveOrderEoQuery = new QueryWrapper();
        receiveOrderEoQuery.eq((Object)"pre_no", (Object)reCheckReqDto.getRefundOrderNo());
        receiveOrderEoQuery.eq((Object)"category", (Object)"201");
        DRAOrderEo notifyOrderEo = (DRAOrderEo)this.tcbjDRAOrderMapper.selectOne((Wrapper)receiveOrderEoQuery);
        logger.info("checkParams==>\u67e5\u8be2\u51fa\u7684\u6536\u8d27\u901a\u77e5\u5355\u4fe1\u606f");
        AssertUtil.isTrue(null != notifyOrderEo, String.format("\u6839\u636e\u9000\u8d27\u5355\u53f7:%s\u67e5\u8be2\u4e0d\u5230\u6536\u8d27\u901a\u77e5\u5355\u4fe1\u606f", reCheckReqDto.getRefundOrderNo()));
        return notifyOrderEo;
    }
}

