/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.apiimpl.cs.warehouse;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsLogicWarehouseApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsLogicWarehouseService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehouseAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehouseUpdateReqDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="csLogicWarehouseApiImpl")
public class CsLogicWarehouseApiImpl
implements ICsLogicWarehouseApi {
    private static Logger logger = LoggerFactory.getLogger(CsLogicWarehouseApiImpl.class);
    @Autowired
    private ICsLogicWarehouseService csLogicWarehouseService;

    public RestResponse<Long> add(CsLogicWarehouseAddReqDto addReqDto) {
        logger.info("\u6dfb\u52a0\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(addReqDto));
        return new RestResponse((Object)this.csLogicWarehouseService.add(addReqDto));
    }

    public RestResponse<Void> update(Long id, CsLogicWarehouseUpdateReqDto updateReqDto) {
        logger.info("\u4fee\u6539\u53c2\u6570\uff1a[id:{}, {}]", (Object)id, (Object)LogUtils.buildLogContent(updateReqDto));
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        this.csLogicWarehouseService.update(id, updateReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> delete(Long id) {
        logger.info("\u5220\u9664\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        this.csLogicWarehouseService.delete(id);
        return RestResponse.VOID;
    }

    public RestResponse<Long> addLogicWarehouse(CsLogicWarehouseAddReqDto addReqDto) {
        addReqDto.setNegativeFlag(addReqDto.getWarehouseIsNegative());
        Long warehouseId = this.csLogicWarehouseService.addLogicWarehouse(addReqDto);
        return new RestResponse((Object)warehouseId);
    }
}

