/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsOutResultOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.order.out.CsOutResultOrderDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.order.out.CsOutResultOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.order.out.CsOutResultOrderDetailMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.order.out.CsOutResultOrderMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOutResultOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.base.ContactDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsOutResultOrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsOutResultOrderRespDto;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="csOutResultOrderQueryService")
public class CsOutResultOrderQueryServiceImpl
implements ICsOutResultOrderQueryService {
    private static Logger logger = LoggerFactory.getLogger(CsOutResultOrderQueryServiceImpl.class);
    @Autowired
    private CsOutResultOrderDas csOutResultOrderDas;
    @Resource
    private CsOutResultOrderMapper csOutResultOrderMapper;
    @Resource
    private CsOutResultOrderDetailMapper csOutResultOrderDetailMapper;

    @Override
    public CsOutResultOrderEo selectByPrimaryKey(Long id) {
        logger.info("\u6839\u636eid\u67e5\u8be2\u4fe1\u606f\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        return (CsOutResultOrderEo)this.csOutResultOrderDas.selectByPrimaryKey(id);
    }

    @Override
    public CsOutResultOrderRespDto queryByDocumentNo(String documentNo) {
        CsOutResultOrderRespDto dto = new CsOutResultOrderRespDto();
        List csOutResultOrderEos = this.csOutResultOrderMapper.queryByDocumentNo(documentNo);
        if (CollectionUtils.isEmpty((Collection)csOutResultOrderEos)) {
            return dto;
        }
        CsOutResultOrderEo csOutResultOrderEo = (CsOutResultOrderEo)csOutResultOrderEos.get(0);
        List detailEoList = this.csOutResultOrderDetailMapper.queryByDocumentNo(documentNo);
        CubeBeanUtils.copyProperties((Object)dto, (Object)csOutResultOrderEo, (String[])new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)detailEoList)) {
            ArrayList detailRespDtoList = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)detailRespDtoList, (Collection)detailEoList, CsOutResultOrderDetailRespDto.class);
            dto.setDetailRespDtoList((List)detailRespDtoList);
        }
        if (StringUtils.isNotBlank((CharSequence)csOutResultOrderEo.getExtension())) {
            try {
                ContactDto contactDto = (ContactDto)JSON.parseObject((String)csOutResultOrderEo.getExtension(), ContactDto.class);
                dto.setContactDto(contactDto);
            }
            catch (Exception ex) {
                logger.info("\u6355\u83b7\u5f02\u5e38\uff0c\u903b\u8f91\u4e0d\u5904\u7406\uff1a\u524d\u7f6e\u5355\u636e\u6536\u8d27\u4fe1\u606f\u9519\u8bef");
            }
        }
        return dto;
    }

    @Override
    public String queryDocumentByPreOrderNo(String preOrderNo) {
        List csOutResultOrderEos = this.csOutResultOrderMapper.queryByPreOrderNo(preOrderNo);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)csOutResultOrderEos), "\u524d\u7f6e\u5355\u53f7\u4e0d\u5b58\u5728\u51fa\u5e93\u7ed3\u679c\u5355");
        return ((CsOutResultOrderEo)csOutResultOrderEos.get(0)).getDocumentNo();
    }

    @Override
    public CsOutResultOrderRespDto queryCsOutResultOrder(CsOutResultOrderAddReqDto csOutResultOrderAddReqDto) {
        CsOutResultOrderRespDto dto = new CsOutResultOrderRespDto();
        CsOutResultOrderEo csOutResultOrderEo = new CsOutResultOrderEo();
        if (StringUtils.isNotBlank((CharSequence)csOutResultOrderAddReqDto.getRelevanceNo())) {
            csOutResultOrderEo.setRelevanceNo(csOutResultOrderAddReqDto.getRelevanceNo());
        }
        if (StringUtils.isNotBlank((CharSequence)csOutResultOrderAddReqDto.getPreOrderNo())) {
            csOutResultOrderEo.setPreOrderNo(csOutResultOrderAddReqDto.getPreOrderNo());
        }
        if (StringUtils.isNotBlank((CharSequence)csOutResultOrderAddReqDto.getDocumentNo())) {
            csOutResultOrderEo.setDocumentNo(csOutResultOrderAddReqDto.getDocumentNo());
        }
        CsOutResultOrderEo csOutResultOrder = (CsOutResultOrderEo)this.csOutResultOrderDas.selectOne((BaseEo)csOutResultOrderEo);
        List detailEoList = this.csOutResultOrderDetailMapper.queryByDocumentNo(csOutResultOrder.getDocumentNo());
        CubeBeanUtils.copyProperties((Object)dto, (Object)csOutResultOrder, (String[])new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)detailEoList)) {
            ArrayList detailRespDtoList = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)detailRespDtoList, (Collection)detailEoList, CsOutResultOrderDetailRespDto.class);
            dto.setDetailRespDtoList((List)detailRespDtoList);
        }
        if (StringUtils.isNotBlank((CharSequence)csOutResultOrderEo.getExtension())) {
            try {
                ContactDto contactDto = (ContactDto)JSON.parseObject((String)csOutResultOrderEo.getExtension(), ContactDto.class);
                dto.setContactDto(contactDto);
            }
            catch (Exception ex) {
                logger.info("\u6355\u83b7\u5f02\u5e38\uff0c\u903b\u8f91\u4e0d\u5904\u7406\uff1a\u524d\u7f6e\u5355\u636e\u6536\u8d27\u4fe1\u606f\u9519\u8bef");
            }
        }
        return dto;
    }
}

