/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.apiimpl.cs.warehouse;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsPhysicsWarehouseApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsPhysicsWarehouseQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsPhysicsWarehouseService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsWarehouseAddressService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.WarehouseEo;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsPhysicsWarehouseAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsPhysicsWarehouseUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsWarehouseAddressAddReqDto;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="csPhysicsWarehouseApiImpl")
public class CsPhysicsWarehouseApiImpl
implements ICsPhysicsWarehouseApi {
    private static Logger logger = LoggerFactory.getLogger(CsPhysicsWarehouseApiImpl.class);
    @Autowired
    private ICsPhysicsWarehouseService csPhysicsWarehouseService;
    @Resource
    private ICsWarehouseAddressService csWarehouseAddressService;
    @Resource
    private ICsPhysicsWarehouseQueryService csPhysicsWarehouseQueryService;

    public RestResponse<Long> add(CsPhysicsWarehouseAddReqDto addReqDto) {
        logger.info("\u6dfb\u52a0\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(addReqDto));
        return new RestResponse((Object)this.csPhysicsWarehouseService.add(addReqDto));
    }

    public RestResponse<Void> update(Long id, CsPhysicsWarehouseUpdateReqDto updateReqDto) {
        logger.info("\u4fee\u6539\u53c2\u6570\uff1a[id:{}, {}]", (Object)id, (Object)LogUtils.buildLogContent(updateReqDto));
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        this.csPhysicsWarehouseService.update(id, updateReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> delete(Long id) {
        logger.info("\u5220\u9664\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "\u53c2\u6570\u6709\u8bef");
        this.csPhysicsWarehouseService.delete(id);
        return RestResponse.VOID;
    }

    public RestResponse<Long> initPhysicsWarehouse(CsPhysicsWarehouseAddReqDto addReqDto) {
        Long physicsWarehouseId = this.csPhysicsWarehouseService.initPhysicsWarehouse(addReqDto);
        return new RestResponse((Object)physicsWarehouseId);
    }

    public RestResponse<Long> initPhysicsWarehouseByOrganizationIdList(List<Long> organizationIdList) {
        AssertUtil.isTrue(CollectionUtils.isNotEmpty(organizationIdList), "\u7ec4\u7ec7id\u96c6\u5408\u4e3a\u7a7a");
        List<WarehouseEo> warehouseEoList = this.csPhysicsWarehouseQueryService.queryOldWarehouseByOrganizationIdList(organizationIdList);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty(warehouseEoList), "\u65e7\u6570\u636e\u4ed3\u5e93\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u65b0\u589e\u4ed3\u5e93\u8bf7\u5355\u72ec\u8c03\u7528\u5e93\u5b58\u521d\u59cb\u5316\u63a5\u53e3");
        for (WarehouseEo warehouseEo : warehouseEoList) {
            CsPhysicsWarehouseAddReqDto addReqDto = new CsPhysicsWarehouseAddReqDto();
            addReqDto.setWarehouseCode(warehouseEo.getCode());
            addReqDto.setWarehouseName(warehouseEo.getName());
            addReqDto.setWarehouseType(warehouseEo.getType());
            addReqDto.setOrganizationId(warehouseEo.getOrganizationId());
            addReqDto.setOrganizationName(warehouseEo.getOrganizationName());
            addReqDto.setMainWarehouse(warehouseEo.getMainWarehouse());
            addReqDto.setWarehouseStatus(warehouseEo.getStatus());
            try {
                Long physicsWarehouseId = this.csPhysicsWarehouseService.initPhysicsWarehouse(addReqDto);
                CsWarehouseAddressAddReqDto addressAddReqDto = new CsWarehouseAddressAddReqDto();
                BeanUtils.copyProperties((Object)warehouseEo, (Object)addressAddReqDto);
                addressAddReqDto.setWarehouseId(physicsWarehouseId);
                this.csWarehouseAddressService.add(addressAddReqDto);
            }
            catch (Exception exception) {
                logger.error("\u521d\u59cb\u5316\u4ed3\u5e93\u5931\u8d25\uff0c\u5ffd\u7565\u7ee7\u7eed\u8d70" + addReqDto.getWarehouseCode());
            }
        }
        return null;
    }

    public RestResponse<Void> updatePhysicsWarehouse(Long id, CsPhysicsWarehouseUpdateReqDto updateReqDto) {
        this.csPhysicsWarehouseService.updatePhysicsWarehouse(id, updateReqDto);
        return RestResponse.VOID;
    }
}

