/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.api.exception.InventoryExceptionCode;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsInventoryPreemptionQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsInventoryPreemptionService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.inventory.CsInventoryPreemptionDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsInventoryPreemptionEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.inventory.CsInventoryPreemptionMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateCargoReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryPreemptionAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryPreemptionUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="csInventoryPreemptionService")
public class CsInventoryPreemptionServiceImpl
implements ICsInventoryPreemptionService {
    private static Logger logger = LoggerFactory.getLogger(CsInventoryPreemptionServiceImpl.class);
    @Autowired
    private CsInventoryPreemptionDas csInventoryPreemptionDas;
    @Resource
    private CsInventoryPreemptionMapper csInventoryPreemptionMapper;
    @Autowired
    private ICsInventoryPreemptionQueryService csInventoryPreemptionQueryService;

    @Override
    public Long add(CsInventoryPreemptionAddReqDto addReqDto) {
        logger.info("\u6dfb\u52a0\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(addReqDto));
        AssertUtil.isTrue(addReqDto != null, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        CsInventoryPreemptionEo insertEo = CsInventoryPreemptionEo.newInstance();
        CubeBeanUtils.copyProperties((Object)insertEo, (Object)addReqDto, (String[])new String[0]);
        this.csInventoryPreemptionDas.insert((BaseEo)insertEo);
        return insertEo.getId();
    }

    @Override
    public void update(Long id, CsInventoryPreemptionUpdateReqDto updateReqDto) {
        logger.info("\u4fee\u6539\u53c2\u6570\uff1a[id:{}, {}]", (Object)id, (Object)LogUtils.buildLogContent(updateReqDto));
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(updateReqDto != null, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        CsInventoryPreemptionEo updateEo = CsInventoryPreemptionEo.newInstance();
        CubeBeanUtils.copyProperties((Object)updateEo, (Object)updateReqDto, (String[])new String[0]);
        updateEo.setId(id);
        this.csInventoryPreemptionDas.updateSelective((BaseEo)updateEo);
    }

    @Override
    public void delete(Long id) {
        logger.info("\u5220\u9664\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        CsInventoryPreemptionEo eo = this.csInventoryPreemptionQueryService.selectByPrimaryKey(id);
        AssertUtil.isTrue(eo != null, InventoryExceptionCode.RECORD_NOT_EXIST.getMsg());
        this.csInventoryPreemptionDas.logicDeleteById(id);
    }

    @Override
    public void insertPreemptInventoryRecord(CsInventoryOperateReqDto inParamDto) {
        logger.info("inParamDto:{}", (Object)LogUtils.buildLogContent(inParamDto));
        ArrayList csInventoryPreemptionEoList = Lists.newArrayList();
        for (CsInventoryOperateCargoReqDto cargoDto : inParamDto.getOperateCargoReqDtoList()) {
            CsInventoryPreemptionEo csInventoryPreemptionEo = new CsInventoryPreemptionEo();
            csInventoryPreemptionEo.setSourceNo(inParamDto.getSourceNo());
            csInventoryPreemptionEo.setSourceType(inParamDto.getSourceType());
            csInventoryPreemptionEo.setWarehouseCode(cargoDto.getWarehouseCode());
            csInventoryPreemptionEo.setCargoCode(cargoDto.getCargoCode());
            csInventoryPreemptionEo.setArtNo(cargoDto.getCargoCode());
            csInventoryPreemptionEo.setBatch(cargoDto.getBatch());
            csInventoryPreemptionEo.setValid(CsValidFlagEnum.ENABLE.getCode());
            csInventoryPreemptionEo.setActivityId(cargoDto.getActivityId());
            csInventoryPreemptionEo.setActivityFlag(null != cargoDto.getActivityId() ? YesNoEnum.YES.getValue() : YesNoEnum.NO.getValue());
            BigDecimal preempt = cargoDto.getChangeInventory();
            preempt = preempt == null ? BigDecimal.ZERO : preempt;
            csInventoryPreemptionEo.setPreemptNum(preempt);
            csInventoryPreemptionEoList.add(csInventoryPreemptionEo);
        }
        this.csInventoryPreemptionDas.insertBatch((List)csInventoryPreemptionEoList);
    }

    @Override
    public void updateStatusDisable(List<CsInventoryPreemptionEo> preemptionEoList) {
        for (CsInventoryPreemptionEo preemptionEo : preemptionEoList) {
            preemptionEo.setValid(CsValidFlagEnum.DISABLE.getCode());
            preemptionEo.setDisplay(YesNoEnum.NO.getValue());
            this.csInventoryPreemptionMapper.updateById((BaseEo)preemptionEo);
        }
    }

    @Override
    public void updateStatusDisableBySourceNo(String sourceNo) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"source_no", (Object)sourceNo);
        wrapper.eq((Object)"valid", (Object)CsValidFlagEnum.ENABLE.getCode());
        wrapper.orderByDesc((Object)"create_time");
        List preemptionEoList = this.csInventoryPreemptionMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)preemptionEoList)) {
            this.updateStatusDisable(preemptionEoList);
        }
    }
}

