/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl.warehouse;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.warehouse.ITcbjWarehouseService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.WarehouseEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.TcbjWarehouseMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.warehouse.TcbjWarehouseReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.warehouse.TcbjWarehouseRespDto;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TcbjWarehouseServiceImpl
implements ITcbjWarehouseService {
    private static final Logger logger = LoggerFactory.getLogger(TcbjWarehouseServiceImpl.class);
    @Autowired
    private TcbjWarehouseMapper tcbjWarehouseMapper;
    @Autowired
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IContext context;

    @Override
    public RestResponse<PageInfo<TcbjWarehouseRespDto>> notiPage(TcbjWarehouseReqDto queryDto) {
        logger.info("\u83b7\u53d6\u4ed3\u5e93-\u8f93\u5165:{}", (Object)JSON.toJSONString((Object)queryDto));
        Integer pageNum = queryDto.getPageNum();
        Integer pageSize = queryDto.getPageSize();
        AssertUtil.isTrue(Objects.nonNull(pageNum) && pageNum > 0, "\u9875\u7801\u53c2\u6570\u4e0d\u5408\u6cd5");
        AssertUtil.isTrue(Objects.nonNull(pageSize) && pageSize > 0, "\u6bcf\u9875\u6761\u6570\u4e0d\u5408\u6cd5");
        PageHelper.startPage((int)pageNum, (int)pageSize);
        RestResponse restResponse = this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId());
        Long orgId = (Long)RestResponseHelper.extractData((RestResponse)restResponse);
        queryDto.setOrgId(orgId);
        List list = this.tcbjWarehouseMapper.selectWarehouse(queryDto);
        PageInfo info = new PageInfo(list);
        logger.info("\u83b7\u53d6\u4ed3\u5e93-\u8f93\u51fa:{}", (Object)JSON.toJSONString((Object)info));
        return new RestResponse("0", "success", (Object)info);
    }

    @Override
    public RestResponse<TcbjWarehouseRespDto> detail(String code) {
        logger.info("\u83b7\u53d6\u4ed3\u5e93Detail-\u8f93\u5165:{}", (Object)JSON.toJSONString((Object)code));
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"code", (Object)code);
        WarehouseEo eo = (WarehouseEo)this.tcbjWarehouseMapper.selectOne((Wrapper)wrapper);
        TcbjWarehouseRespDto info = new TcbjWarehouseRespDto();
        BeanUtils.copyProperties((Object)info, (Object)eo);
        logger.info("\u83b7\u53d6\u4ed3\u5e93Detail-\u8f93\u51fa:{}", (Object)JSON.toJSONString((Object)info));
        return new RestResponse("0", "success", (Object)info);
    }
}

