/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.svr.rest.cs.order;

import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsOutResultOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsOutResultOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.base.req.TcbjResGenReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.RollbackDeliveryOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsOutResultOrderRepairDataDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOutResultOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOutResultOrderStringValidReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsOutResultSolutionToHangReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsOutResultSolutionToHangRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsShipmenetEnterpriseAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveredOutResultInfoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsLogisticsDeliveredInfoRespDto;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.exception.WarehouseAbleException;
import com.yunxi.dg.base.center.inventory.dto.domain.CsInfoQueryDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsOutResultOrderDetailRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsOutResultOrderQueryDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsOutResultOrderRespDto;
import io.swagger.annotations.Api;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"V2:\u51fa\u5e93\u7ed3\u679c\u5355\u64cd\u4f5c"})
@RestController
@RequestMapping(value={"/v2/csOutResultOrder"})
public class CsOutResultOrderRest
implements ICsOutResultOrderApi,
ICsOutResultOrderQueryApi {
    private static Logger logger = LoggerFactory.getLogger(CsOutResultOrderRest.class);
    @Resource(name="${yunxi.dg.base.project}_ICsOutResultOrderApi")
    private ICsOutResultOrderApi csOutResultOrderApi;
    @Resource(name="${yunxi.dg.base.project}_ICsOutResultOrderQueryApi")
    private ICsOutResultOrderQueryApi csOutResultOrderQueryApi;
    @Autowired
    ILockService lockService;

    @Retryable(value={WarehouseAbleException.class}, maxAttempts=20, backoff=@Backoff(random=true, delay=500L, maxDelay=3000L, multiplier=1.0))
    public RestResponse<String> sendBack(@Validated @RequestBody TcbjResGenReqDto reqDto) {
        return this.csOutResultOrderApi.sendBack(reqDto);
    }

    public RestResponse<Void> updateStringValidResult(@RequestBody List<CsOutResultOrderStringValidReqDto> stringValidReqDtoList) {
        return this.csOutResultOrderApi.updateStringValidResult(stringValidReqDtoList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RestResponse<Void> repairData(@PathVariable(value="documentNo") String documentNo, @RequestBody List<CsOutResultOrderRepairDataDto> repairDataDtos) {
        AssertUtil.assertNotBlank((String)documentNo, (String)"\u7ed3\u679c\u5355\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Mutex mutex = this.lockService.lock("CsOutResultOrderRest_repairData", documentNo, 30, 35, TimeUnit.SECONDS);
        try {
            RestResponse restResponse = this.csOutResultOrderApi.repairData(documentNo, repairDataDtos);
            return restResponse;
        }
        finally {
            this.lockService.unlock(mutex);
        }
    }

    public RestResponse<Void> updateSapNoById(@PathVariable(value="id") Long id, @PathVariable(value="sapNo") String sapNo) {
        return this.csOutResultOrderApi.updateSapNoById(id, sapNo);
    }

    public RestResponse<CsOutResultSolutionToHangRespDto> solutionToHang(@RequestBody CsOutResultSolutionToHangReqDto csOutResultSolutionToHangReqDto) {
        return this.csOutResultOrderApi.solutionToHang(csOutResultSolutionToHangReqDto);
    }

    public RestResponse<Void> outInResultOrderCallBackNoticeOrderSend(@RequestBody List<String> documentNos) {
        return this.csOutResultOrderApi.outInResultOrderCallBackNoticeOrderSend(documentNos);
    }

    public RestResponse<Void> rollbackOutResultOrder(@RequestBody RollbackDeliveryOrderReqDto rollbackDeliveryOrderReqDto) {
        return this.csOutResultOrderApi.rollbackOutResultOrder(rollbackDeliveryOrderReqDto);
    }

    public RestResponse<Long> updateOutResultOrder(@RequestBody CsOutResultOrderAddReqDto updateReqDto) {
        return this.csOutResultOrderApi.updateOutResultOrder(updateReqDto);
    }

    public RestResponse<CsOutResultOrderRespDto> queryByPrimaryKey(@PathVariable(value="id") Long id) {
        logger.info("\u6839\u636eid\u67e5\u8be2\u4fe1\u606f\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue((id != null && id > 0L ? 1 : 0) != 0, (String)"\u53c2\u6570\u6709\u8bef");
        return this.csOutResultOrderQueryApi.queryByPrimaryKey(id);
    }

    public RestResponse<CsOutResultOrderRespDto> queryByDocumentNo(String documentNo) {
        logger.info("\u6839\u636e\u5355\u53f7\u67e5\u8be2\u4fe1\u606f\u53c2\u6570\uff1a[documentNo:{}]", (Object)documentNo);
        AssertUtil.isTrue((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{documentNo}), (String)"\u5355\u636e\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        return this.csOutResultOrderQueryApi.queryByDocumentNo(documentNo);
    }

    public RestResponse<List<CsOutResultOrderDetailRespDto>> queryDetailByRelevanceNo(@PathVariable(value="relevanceNo") String relevanceNo) {
        return this.csOutResultOrderQueryApi.queryDetailByRelevanceNo(relevanceNo);
    }

    public RestResponse<List<CsOutResultOrderDetailRespDto>> queryDetailByDocumentNo(@PathVariable(value="documentNo") String documentNo) {
        return this.csOutResultOrderQueryApi.queryDetailByDocumentNo(documentNo);
    }

    public RestResponse<PageInfo<CsOutResultOrderDetailRespDto>> queryDetailByPage(CsOutResultOrderQueryDto queryDto) {
        logger.info("\u5206\u9875\u67e5\u8be2\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent((Object)queryDto, (String[])new String[]{"pageNum", "pageSize"}));
        return this.csOutResultOrderQueryApi.queryDetailByPage(queryDto);
    }

    public RestResponse<PageInfo<CsOutResultOrderRespDto>> queryByPage(@Validated @RequestBody CsOutResultOrderQueryDto queryDto) {
        logger.info("\u5206\u9875\u67e5\u8be2\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent((Object)queryDto, (String[])new String[]{"pageNum", "pageSize"}));
        return this.csOutResultOrderQueryApi.queryByPage(queryDto);
    }

    public RestResponse<List<CsOutResultOrderRespDto>> queryByParam(@Validated @RequestBody CsOutResultOrderQueryDto queryDto) {
        logger.info("\u67e5\u8be2\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent((Object)queryDto));
        return this.csOutResultOrderQueryApi.queryByParam(queryDto);
    }

    public RestResponse<CsLogisticsDeliveredInfoRespDto> queryInfoByExternalOrderNo(@RequestBody CsInfoQueryDto infoQueryDto) {
        return this.csOutResultOrderQueryApi.queryInfoByExternalOrderNo(infoQueryDto);
    }

    public RestResponse<String> queryOverChargeReason(@PathVariable(value="documentNo") String documentNo) {
        return this.csOutResultOrderQueryApi.queryOverChargeReason(documentNo);
    }

    public RestResponse<CsDeliveredOutResultInfoRespDto> queryDeliveredInfo(@PathVariable(value="preOrderNo") String preOrderNo) {
        return this.csOutResultOrderQueryApi.queryDeliveredInfo(preOrderNo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Retryable(value={WarehouseAbleException.class}, maxAttempts=5, backoff=@Backoff(delay=1800L, multiplier=1.5))
    public RestResponse<Void> unhook(@PathVariable(value="documentNo") String documentNo, @RequestParam(value="remark") String remark) {
        AssertUtil.assertNotBlank((String)documentNo, (String)"\u7ed3\u679c\u5355\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Mutex mutex = this.lockService.lock("CsOutResultOrderRest_unhook", documentNo, 30, 35, TimeUnit.SECONDS);
        try {
            RestResponse restResponse = this.csOutResultOrderApi.unhook(documentNo, remark);
            return restResponse;
        }
        finally {
            this.lockService.unlock(mutex);
        }
    }

    public RestResponse<Void> createConsignmentByOutResultOrderNo(@PathVariable(value="documentNo") String documentNo) {
        return this.csOutResultOrderApi.createConsignmentByOutResultOrderNo(documentNo);
    }

    public RestResponse<Void> refreshPlanTime(@PathVariable(value="documentNo") String documentNo, @RequestBody CsShipmenetEnterpriseAddReqDto reqDto) {
        return this.csOutResultOrderApi.refreshPlanTime(documentNo, reqDto);
    }
}

