/*
 * @(#)ItemSkuDto.java 1.0 2018-08-22
 *
 * 			Copyright (c) 2017, YUNXI. All rights reserved.
 * 			YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.api.base.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 商品组合Dto
 *
 * @author 风影
 * @since 2.0.0
 */
@ApiModel(value = "ItemBundleReqDto", description = "组合商品信息")
public class ItemBundleReqDto extends ItemSkuReqDto {

    @ApiModelProperty(name = "itemBundles", value = "组合商品dto，选填")
    private List<BundleItemReqDto> bundleItemDtos;

    @ApiModelProperty(name = "prices", value = "商品价格，选填")
    private List<ItemPriceReqDto> prices;

    @ApiModelProperty(name = "medias", value = "商品多媒体，选填")
    private List<ItemMediasReqDto> medias;

    @ApiModelProperty(name = "tags", value = "商品（SKU）标签，选填")
    private List<Long> tags;

    public List<BundleItemReqDto> getBundleItemDtos() {
        return bundleItemDtos;
    }

    public void setBundleItemDtos(List<BundleItemReqDto> bundleItemDtos) {
        this.bundleItemDtos = bundleItemDtos;
    }

    public List<ItemPriceReqDto> getPrices() {
        return prices;
    }

    public void setPrices(List<ItemPriceReqDto> prices) {
        this.prices = prices;
    }

    public List<ItemMediasReqDto> getMedias() {
        return medias;
    }

    public void setMedias(List<ItemMediasReqDto> medias) {
        this.medias = medias;
    }

    public List<Long> getTags() {
        return tags;
    }

    public void setTags(List<Long> tags) {
        this.tags = tags;
    }
}
