/*
 * @(#)ItemStatusEnum.java 1.0 2021年08月26日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.cube.center.item.api.common.enums;

/**
 * <p>Title:ItemStatusEnum</p>
 * <p>Description: 商品状态,0已发布 1上架 2下架 3未发布 4禁用状态</p>
 *
 * @author 寒江
 * @date 2021/8/26 16:26
 * @since 0.1.0
 */
public enum ItemStatus {
    /**
     * 已发布
     */
    PUBLISHED(0),

    /**
     * 上架
     */
    ON_LINE(1),
    /**
     * 已下架
     */
    OFF_SHELF(2),

    /**
     * 未发布
     */
    UNPUBLISHED(3),

    /**
     * 禁用状态
     */
    DISABLE(4),

    ;
    private Integer status;

    ItemStatus(Integer status) {
        this.status = status;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }
}
