/**
 * @(#) IExampleService.java 1.1.0 2018-08-20
 * <p>
 * Copyright (c)  2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.base.dto.response;

import com.dtyunxi.yundt.cube.center.item.api.base.dto.DistributionFeeDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.RItemBundleRespDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 商品响应Dto
 *
 * @author 佐助
 * @since 2.0.0
 */
@Data
@ApiModel(value = "ItemRespDto", description = "商品响应Dto")
public class ItemRespDto extends BaseRespDto {

    private static final long serialVersionUID = -6556019929400468602L;
    @ApiModelProperty(name = "id", value = "id")
    private Long id;
    @ApiModelProperty(name = "itemId", value = "商品ID")
    private Long itemId;
    /**
     * 名称
     */
    @ApiModelProperty(name = "name", value = "商品名称")
    private String name;

    /**
     * 显示名
     */
    @ApiModelProperty(name = "displayName", value = "显示名")
    private String displayName;

    /**
     * 是否礼盒
     */
    @ApiModelProperty(name = "giftBox", value = "是否礼盒（0：是、1：否）")
    private Integer giftBox;

    /**
     * 编码
     */
    @ApiModelProperty(name = "code", value = "编码")
    private String code;

    /**
     * 品牌名称
     */
    @ApiModelProperty(name = "brand", value = "品牌名称")
    private String brand;

    /**
     * 品牌Id
     */
    @ApiModelProperty(name = "brand_id", value = "品牌id")
    private Long brandId;
    /**
     * 虚拟商品
     */
    @ApiModelProperty(name = "vitrual", value = "虚拟商品")
    private Boolean vitrual;

    /**
     * 简介
     */
    @ApiModelProperty(name = "brief", value = "简介")
    private String brief;

    /**
     * 状态
     */
    @ApiModelProperty(name = "status", value = "状态")
    private Integer status;

    /**
     * 退货类型：1不可退 2手动可退 3过期自动退
     */
    @ApiModelProperty(name = "returnType", value = "退货类型：1不可退 2手动可退 3过期自动退")
    private Integer returnType;

    /**
     * 允许退货时间点
     */
    @ApiModelProperty(name = "allowReturnTime", value = "允许退货时间点")
    private String allowReturnTime;

    /**
     * 商品类型: 1-商品  2-产品  默认1 3 -组合商品；
     */
    @ApiModelProperty(name = "type", value = "商品类型:1-商品  2-产品  默认1 3 -组合商品；4虚拟商品")
    private Integer type;


    /**
     * 业务类型：0 普通； 1 社区团购  默认0
     */
    @ApiModelProperty(name = "busType", value = "业务类型：0 普通； 1 社区团购 2 积分商品 默认0")
    private Integer busType;

    /**
     * 产品id
     */
    @ApiModelProperty(name = "spuId", value = "产品id")
    private Long spuid;

    /**
     * 应用实例ID
     */
    @ApiModelProperty(name = "instanceId", value = "应用实例ID")
    private Long instanceId;

    /**
     * 创建人
     */
    @ApiModelProperty(name = "ownerId", value = "创建人")
    private Long ownerId;

    /**
     * 商品版本
     */
    @ApiModelProperty(name = "version", value = "商品版本")
    private Long version;

    /**
     * 详情
     */
    @ApiModelProperty(name = "detail", value = "详情")
    private String detail;

    /**
     * 可卖数量
     */
    @ApiModelProperty(name = "shelfAmount", value = "可卖数量=所有规格的可卖数量之和")
    private Long shelfAmount;

    /**
     * 目录Id
     */
    @ApiModelProperty(name = "dirId", value = "后台列木Id")
    private Long dirId;

    @ApiModelProperty(name = "dirName", value = "后台类目名称")
    private String dirName;

    /**
     * 租户ID
     */
    @ApiModelProperty(name = "tenantId", value = "租户ID")
    private Long tenantId;



    /**
     * 商品价格
     */
    @ApiModelProperty(name = "price", value = "商品价格")
    private List<ItemPriceRespDto> priceRespDtoList;

    /**
     * SKU列表
     */
    @ApiModelProperty(name = "itemSkuList", value = "SKU列表")
    private List<ItemSkuRespDto> itemSkuList;

    /**
     * 多媒体列表
     */
    @ApiModelProperty(name = "itemMediasList", value = "多媒体列表")
    private List<ItemMediasRespDto> itemMediasList;

    /**
     * 商品目录
     */
    @ApiModelProperty(name = "dirsItemsList", value = "商品目录")
    private List<DirsItemsRespDto> dirsItemsList = Lists.newArrayList();

    /**
     * 商品店铺
     */
    @ApiModelProperty(name = "itemShopList", value = "商品店铺")
    private List<ItemShopRespDto> itemShopList;

    /**
     * 排序Key
     */
    @ApiModelProperty(name = "groupKey", value = "排序Key")
    private String  groupKey;

    @ApiModelProperty(name = "itemPropRelationRespDtos", value = "商品属性关联dto")
    private List<ItemPropRelationRespDto> itemPropRelationRespDtos;
    @ApiModelProperty(name = "ruleRemark", value = "规则说明")
    private String ruleRemark;
    /**
     * 兑换类型：1积分 2积分+金额
     */
    @ApiModelProperty(name = "cashType", value = "兑换类型：1积分2积分+金额")
    private Integer cashType;
    @ApiModelProperty(name = "isAfterSale", value = "是否需要售后: 0否 1 是")
    private Integer isAfterSale;

    @ApiModelProperty(name = "itemShelfInfoList", value = "上架数据")
    private List<ItemShelfRespDto> itemShelfInfoList;

    @ApiModelProperty(name = "sellerId", value = "商户ID")
    private Long sellerId;

    @ApiModelProperty(name = "shopId", value = "店铺ID")
    private Long shopId;

    @ApiModelProperty(name = "snapshotId", value = "快照ID")
    private Long snapshotId;

    @ApiModelProperty(name = "shelfTaskDtoList", value = "定时任务列表")
    private List<ShelfTaskRespDto> shelfTaskRespDtoList = Lists.newArrayList();

    @ApiModelProperty(name = "salesCount", value = "统计的售卖数量")
    private Long salesCount;

    @ApiModelProperty(name = "searchAttr", value = "构建ES搜索属性，key有name和value，分别是名称和值")
    private List<Map<String, String>> searchAttr;

    @ApiModelProperty(name = "maxPrice", value = "最大售价")
    private Double maxPrice;

    @ApiModelProperty(name = "minPrice", value = "最小售价")
    private Double minPrice;

    /**
     * 供应商Id
     */
    @ApiModelProperty(name = "supplierId", value = "供应商id")
    private Long supplierId;

    @ApiModelProperty(name = "year", value = "所属年份")
    private Integer year;

    @ApiModelProperty(name = "saleChannel", value = "可售渠道,多个用英文逗号隔开,如：JD,TM")
    private String saleChannel;
    @ApiModelProperty(name = "shelfType", value = "上架类型：1普通上架，2周期购商品上架")
    private Integer shelfType;

    /**
     * 组织id
     */
    @ApiModelProperty(name = "organizationId", value = "组织id")
    private Long organizationId;

    /**
     * 组织名称
     */
    @ApiModelProperty(name = "organizationName", value = "组织名称，选填")
    private String organizationName;

    /**
     * 零售限购周期
     */
    @ApiModelProperty(name = "retailLimitPeriod", value = "零售限购周期")
    private String retailLimitPeriod;
    /**
     * 零售限购
     */
    @ApiModelProperty(name = "retailLimit", value = "零售限购")
    private String retailLimit;
    /**
     * 最小起售量（单次购买）
     */
    @ApiModelProperty(name = "retailLimitMin", value = "最小起售量（单次购买）")
    private String retailLimitMin;
    /**
     * 最大零售量（单次购买）
     */
    @ApiModelProperty(name = "retailLimitMax", value = "最大零售量（单次购买）")
    private String retailLimitMax;
    /**
     * 订货限购周期
     */
    @ApiModelProperty(name = "wholesaleLimitPeriod", value = "订货限购周期")
    private String wholesaleLimitPeriod;
    /**
     * 订货限购
     */
    @ApiModelProperty(name = "wholesaleLimit", value = "订货限购")
    private String wholesaleLimit;
    /**
     * 最小订货量（单次购买）
     */
    @ApiModelProperty(name = "wholesaleLimitMin", value = "最小订货量（单次购买）")
    private String wholesaleLimitMin;
    /**
     * 最大订货量（单次购买）
     */
    @ApiModelProperty(name = "wholesaleLimitMax", value = "最大订货量（单次购买）")
    private String wholesaleLimitMax;

    @ApiModelProperty(name = "distributionFeeList", value = "分销佣金列表")
    private List<DistributionFeeDto> distributionFeeList;

    @ApiModelProperty(name = "distribution", value = "是否分销：1是，0否")
    private Integer distribution;

    @ApiModelProperty(name = "distribution", value = "分销佣金")
    private BigDecimal distributionFee;

    @ApiModelProperty(name = "purchaseNum", value = "购买次数")
    private Long purchaseNum;

    @ApiModelProperty(name = "itemBCId", value = "浏览或收藏商品项id")
    private Long itemBCId;

    @ApiModelProperty(name = "itemBCTime", value = "浏览或收藏商品时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date itemBCTime;

    @ApiModelProperty(name = "mainPic", value = "商品主图")
    private String mainPic;

    @ApiModelProperty(name = "pointsDeduction", value = "是否积分扣减: 1 是, 0 否")
    private Integer pointsDeduction;

    @ApiModelProperty( value = "店铺类目ID")
    private Long shopDirId;

    @ApiModelProperty( value = "店铺类目名称")
    private String shopDirName;

    @ApiModelProperty(name = "subType", value = "商品子类型，1-产品，2-赠品，3-物料")
    private Integer subType;

    @ApiModelProperty(name = "longCode", value = "商品长编码")
    private String longCode;

    @ApiModelProperty(name = "dirIdList", value = "后端类目id集合：[1级，2级，3级]形式")
    private List<Long> dirIdList;

    @ApiModelProperty(name = "dirNameList", value = "后端类目名称集合：[1级，2级，3级]形式")
    private List<String> dirNameList;

    @ApiModelProperty(name = "dosageForm", value = "剂型")
    private String dosageForm;

    @ApiModelProperty(name = "skuId", value = "skuId")
    private Long skuId;

    // ==== 北鼎字段start ====
    private String dirLevel;

    private String dirPrefixLevel;

    private Long dirPrefixId;

    /**
     *  前台类目名称
     */
    private String dirPrefixName;

    /**
     *  产品大类
     */
    private String prodLargeClass;

    /**
     * 产品大类编码(北鼎一级品类)
     */
    private String prodLargeCode;

    /**
     *  产品二级分类
     */
    private String prodSecClassify;

    /**
     *产品二级分类编码(北鼎二级品类)
     */
    private String prodSecCode;

    /**
     * 产品三级分类(北鼎三级品类描述)
     */
    private String prodThrClassify;

    /**
     *产品三级分类编码(北鼎三级品类)
     */
    private String prodThrCode;

    /**
     *  产品负责人
     */
    private String principalPerson;

    /**
     *  国内B2B卖点
     */
    private String domesticB2b;


    /**
     *  国外B2B卖点
     */
    private String internalB2b;

    /**
     *  EN（69码）
     */
    private String enCode;

    /**
     *  规格
     */
    private String specContent;

    /**
     *
     */
    private String platforms;

    private String platformIds;

    private String platformNames;

    private String itemCode;

    private String itemName;

    private String shelfStatus;

    private List<ItemRespDto> sonItems;

    private String prodClassCode;

    private String prodClassName;

    private String accountingCategoryCode;

    private String accountingCategoryName;

    private Date addTime;

    /**
     * 产品组
     */
    private String prodGroup;

    /**
     * 物料组
     */
    private String materialGroup;

    /**
     * 产品层次
     */
    private String prodLevel;

    /**
     * 可用商品库存数
     */
    private Long avaNum;

    /**
     * 店铺名称
     */
    private String shopName;

    /**
     * BD50:玻璃险虚拟商品 BD51:无物料商品 BD52:等蜂来 BD53:分快递费虚拟商品/借贷项等其他虚拟商品
     */
    private String virtualType;


    private List<RItemBundleRespDto> bundleRespDtos;

    private Integer itemUse;

    /**
     * 单价
     */
    private BigDecimal unitPrice;
    // ==== 北鼎字段end ====

    // ==== 华帝字段start ====
    /**
     * 零售价
     */
    BigDecimal retailPrice = null;

    /*产品类别*/
    String itemCategory = null;
    /*软件著作权书号*/
    String softwareWorkCode = null;
    /*软件著作权名称*/
    String softwareWorkName = null;
    /*适用水压*/
    String hydraulicPressure = null;
    /*燃气种类*/
    String gasClass = null;
    /*适用地区*/
    String applyArea = null;
    /*泄露电流*/
    String leakageCurrent = null;
    /*防护等级*/
    String protectionLevel = null;
    /*燃气额定电压*/
    String gasNominalVoltage = null;
    /*热效率*/
    String thermalEfficiency = null;
    /*额定燃气高热值*/
    String heatingRating = null;
    /*安全阀泄压值*/
    String releasePressure = null;
    /*额定电功率*/
    String electricalRating = null;
    /*物料开票描述*/
    String invoiceDescription = null;
    /*燃气热值类型*/
    String gasHeatingType = null;
    /*额定电压*/
    String nominalVoltage = null;
    /*额定频率*/
    String ratedFrequency = null;
    /*额度热负荷*/
    String nominalHeatLoad = null;
    /*熄火保护装置类型*/
    String flameoutProtectionType = null;
    /*额定燃气低热值*/
    String lowRating = null;
    /*额定燃气相对密度*/
    String  gasRatedRelativeDensity = null;
    /*额定产热水能力*/
    String productionWaterCapacity = null;
    /*额定压力*/
    String nominalPressure = null;
    /*开票规格型号*/
    String invoicingRulesCode = null;
    /*供应商*/
    String supplier = null;
    /*产品定位*/
    String productPositioning = null;
    /*产品型号*/
    String productModel = null;
    /*销售组*/
    String saleGroup = null;
    /*税收分类名称*/
    String taxCategoryName = null;

    /**
     *产品层次2
     * */
    String prodLevelTwo = null;
    /**
     *产品层次3
     * */
    String prodLevelThree = null;
    /**
     *产品层次4
     * */
    String prodLevelFour = null;
    /**
     *产品层次5
     * */
    String prodLevelFive = null;
    /**
     * 是否推送WMS，0：否，1：是
     */
    Integer pushWms = null;

    /**
     * 推送第三方系统：HD:华帝，JST:聚水潭
     */
    String thirdSystem = null;
    // ==== 华帝字段end ====
}
